﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.MyFaceModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">头像设置</asp:Content>
<asp:Content ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/json2.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.swfupload/swfupload.js") %>" type="text/javascript"></script>

    <script type="text/javascript">
        $(document).ready(function () {
            var swfu = new SWFUpload({
                file_post_name: "file",
                upload_url: "<%=Url.Action("My_UpdateFace","Handler") %>",
                flash_url: "<%=ResolveUrl ("../../scripts/jquery.swfupload/flash/swfupload.swf") %>",
                post_params: { "upload_sign": "<%=Model.UploadSign%>" },
                file_types: "*.jpg;*.gif;*.png",
                file_types_description: "Allowed Files",
                file_size_limit: 0,
                file_upload_limit: 0,
                file_queue_limit: 1,

                button_image_url: "<%=this.ResolveUrl ("../../scripts/jquery.swfupload/image/swfupload_button.png") %>",
                button_width: "86",
                button_height: "30",
                button_placeholder_id: "spanSWFUploadButton",
                button_cursor: SWFUpload.CURSOR.HAND,
                button_action: SWFUpload.BUTTON_ACTION.SELECT_FILE,
                button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,

                minimum_flash_version: "9.0.28",
                swfupload_load_failed_handler: function () {
                    var bt = $("#spanSWFUploadButton");
                    bt.empty();
                    bt.append("您当前所使用的浏览器，无法进行头像上传。");
                },
                file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
                    if (numFilesSelected <= 0) return;
                    this.startUpload();
                },
                upload_start_handler: function (file) {
                    //wait
                    easyDialog.open({ container: { content: '正在提交。。。' } });
                },
                upload_success_handler: function (file, serverData) {
                    var v = JSON.parse(serverData);
                    if (v.error) {
                        //$.jokul.alert(v.description);
                        easyDialog.close();
                        easyDialog.open({ container: { header: '提示', content: v.description, noFn: true } });
                        return;
                    }

                    //easyDialog.close();
                    //$("#avatar").attr("src", "<%=Model.Url %>&_" + new Date().getTime());
                    window.location.reload();
			        //ok
			    },
                upload_error_handler: function (file, errorCode, message) {
                    var description = "未知错误:" + errorCode;
                    switch (errorCode) {
                        case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
                            description="上传错误:" + message;
                            break;
                        case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
                            description="上传失败.";
                            break;
                        case SWFUpload.UPLOAD_ERROR.IO_ERROR:
                            description="服务器(IO)错误";
                            break;
                        case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
                            description="安全信息错误";
                            break;
                        case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
                            description="超出上传限制.";
                            break;
                        case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
                            description="验证失败.";
                            break;
                        case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
                            description = "取消";
                            break;
                        case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
                            description="上传已经停止";
                            break;
                    }
                    easyDialog.close();
                    easyDialog.open({ container: { header: '提示', content: description, noFn: true } });
                },
                file_queue_error_handler: function (file, errorCode, message) {
                    var description = "未知错误(" + errorCode + "):" + message;
                    switch (errorCode) {
                        case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
                            description="同时进行上传的文件不能过多.";
                            break;
                        case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
                            description="文件过大.";
                            break;
                        case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
                            description="不能上传 0 字节文件.";
                            break;
                        case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
                            description="不支持的文件类型.";
                            break;
                    }
                    easyDialog.close();
                    easyDialog.open({ container: { header: '提示', content: description, noFn: true } });
                }
            });
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel sp clearfix my_area">
        <%Html.RenderPartial("Menu", "Face", ViewData);%>
        <div class="content">
            <div class="box_panel list_panel my_face_panel">
                <div class="box_panel_title">头像</div>
                <div class="box_panel_context">
                    <div class="list_panel_cut">
                        <form id="post" enctype="multipart/form-data" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post">
                            <table>
                                <tbody>
                                    <tr>
                                        <td>
                                            <img id="avatar" src="<%=Model.Url %>" alt="头像" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span id="spanSWFUploadButton">上传头像</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>



</asp:Content>
