﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.PMPageModel>" MasterPageFile="../Shared/home.master" %>


<asp:Content ContentPlaceHolderID="TitleContent" runat="server">收件箱</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script src="<%=ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script src="<%=ResolveUrl("../../scripts/jquery.twbsPagination/jquery.twbsPagination.js")%>" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('.sync-pagination').empty();
            $('.sync-pagination').twbsPagination({
                totalPages: <%=Model.PageCount %>,
                visiblePages: 7,
                startPage:<%=Model.PageIndex %>,
                first:'<<',
                prev:'上一页',
                next:'下一页',
                last:'',
                onPageClick: function (event, page) {
                    if(page==<%=Model.PageIndex %>)
                        return;
                    $("#form_page input[name='page']").val(page);
                    $("#form_page").submit();
                }
            });

            $("button[name=\"action\"]").click(function(){
                if($("input[name=\"tids\"]:checked").length<=0){
                    alert("请至少选择一个有效记录");
                    return;
                }
                var action = $(this).val();
                var action_text=$(this).text();
                if(confirm("确定要进行"+action_text+"吗？")){
                    $("#form_main input[name=\"action\"]").val(action);
                    $("#form_main").submit();
                }
            });
            
            $("[name='tids']:checkbox:enabled").click(function () {
                if (!$(this)[0].checked)
                    $(".select_all").checked( false);
                else if ($("[name='tids']:checkbox:checked").length == $("[name='tids']:checkbox:enabled").length)
                    $(".select_all").checked( true);

            });

            $(".select_all").change(function () {
                var selected = $(this)[0].checked;
                $(".select_all").checked(selected);
                $("[name='tids']:checkbox:enabled").checked(selected);
            });
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    
    <form id="form_page" method="get" action="<%=Request.Url.AbsoluteUri %>">
        <input type="hidden" name="page" value="<%=Model.PageIndex%>" />
    </form>
<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "PM", ViewData);%>
    <div class="content">
        <div class="line_tab">
            <ul class="clearfix">
                <li class="cur"><%=Html.ActionLink("收件箱","PMInBox","My") %></li>
                <li><%=Html.ActionLink("发站内信", "PMSend", "My")%></li>
            </ul>
        </div>
        
        <%if (Model.PMItems.Count>0){ %>
            <form id="form_main" method="post" action="<%=Url.Action("PMManage","My") %>">
                <input type="hidden" name="action" value="" />
                <input type="hidden" name="url" value="<%=Request.Url.AbsoluteUri %>" />
                <div class="box_panel  sp">
                    <div class="list_panel list_panel_cut message_list_panel">
                        <table>
                            <thead>
                                <tr>
                                    <td style="width:40px;text-align:center;">
                                        <input id="topic_select_all" type="checkbox" class="select_all" />
                                    </td>
                                    <td>标题</td>
                                    <td style="width:180px;text-align:center;">发件人/时间</td>
                                </tr>
                            </thead>
                            <tbody>
                                <%foreach(var p in Model.PMItems){ %>
                                    <tr>
                                        <td style="text-align:center;">
                                            <input type="checkbox" value="<%=p.Id%>" name="tids"/>
                                        </td>
                                        <td class="mail_icon<%=p.New>0?" mail_icon_new":"" %>">
                                            <%if(p.New>0){ %>
                                                <strong><%=Html.ActionLink(p.Title, "PMView", "My", new { id = p.Id }, null)%></strong>
                                            <%}else{ %>
                                                <%=Html.ActionLink(p.Title, "PMView", "My", new { id = p.Id }, null)%>
                                            <%} %>
                                        </td>
                                        <td>
                                            <img src="<%=Config.Passport.Api %>api/avatar.aspx?uid=<%=p.SenderId %>&size=50" style="background-color: #fff;padding:2px;border: 1px solid #eee;margin: 2px 5px 0 0;width: 32px;height: 32px;float: left;" />
                                            <div>
                                                <%=p.SenderUsername %><br />
                                                <%=Html.FriendlyTime( ConvertHelper.ToDateTime(p.Datetime,DateTime.MinValue),"yyyy-MM-dd HH:mm:ss") %>
                                            </div>
                                        </td>
                                    </tr>
                                <%} %>
                            </tbody>
                        </table>
                    </div>
                </div>
            </form>

        
            <div class="sp clearfix">
                <div class="fl">
                <button type="button" name="action" value="delete" class="button">删除</button>
                </div>

                <div class="page_panel fr">
                <ul class="sync-pagination"><li class="page"><a href="javascript:void(0);">页码加载中...</a></li></ul>
                </div>
            </div>
        <%}else{ %>
            <div class="sp">
                您的收件箱中还没有任何站内信
            </div>
        <%} %>
    </div>
</div>



</asp:Content>