﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.MyPMSendModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">发站内信</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.blockUI.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {

                var options = {
                    beforeSubmit: function (formData, jqForm, options) {
                        $.blockUI({ message: '正在提交。。。' });
                        return true;
                    },
                    success: function (responseText, statusText) {
                        if (responseText.num == 0) {
                            $.unblockUI({
                                onUnblock: function(){ alert("成功"); }
                            });
                            return;
                        }
                        $.unblockUI({
                            onUnblock: function(){ alert(responseText.msg); }
                        });
                    },
                    error: function () {
                        $.unblockUI({
                            onUnblock: function(){ alert("服务器通讯失败."); }
                        });
                    },
                    url: "<%=Url.Action("My_PMSend","Handler") %>",
                    type: 'post',
                    dataType: 'json',
                    clearForm: true
                };
                $("#post").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "PM", ViewData);%>
    <div class="content">
        <div class="line_tab">
            <ul class="clearfix">
                <li><%=Html.ActionLink("收件箱", "PMInBox", "My")%></li>
                <li class="cur"><%=Html.ActionLink("发站内信", "PMSend", "My")%></li>
            </ul>
        </div>
        <div class="box_panel form_panel_a sp">
            <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <dl>
                    <dt>收件人帐号</dt>
                    <dd><%=Html.TextBox("to_username", Model.Username, new { @class = "text" })%></dd>
                    <dt>标题</dt>
                    <dd><%=Html.TextBox("title", Model.Title, new { @class = "text" })%></dd>
                    <dd><div class="text_area"><%=Html.TextArea("msg", "", new { cols="50",rows="5"})%></div></dd>
                    <dd class="button_panel clearfix">
                        <ul>
                            <li><button type="submit" name="Ok" class="button skyblue">发送</button></li>
                        </ul>
                    </dd>
                </dl>
            </form>
        </div>
    </div>
</div>



</asp:Content>