﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.MyPermissionModel>" MasterPageFile="../Shared/home.master" %>


<asp:Content ContentPlaceHolderID="TitleContent" runat="server">我的权限</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">


<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "Permission", ViewData);%>
    <div class="content">
        <div class="box_panel">
            <div class="box_panel_title">我的分组权限</div>
	        <div class="box_panel_context">
                <div class="list_panel list_panel_cut">
                    <table>
                        <colgroup>
                            <col style="width:120px;" />
                        </colgroup>
                        <tbody>
                            <tr>
                                <th colspan="2">用户组</th>
                            </tr>
                            <tr>
                                <td>用户组头衔:</td>
                                <td><%=Group.Name %></td>
                            </tr>
                            <tr>
                                <th colspan="2">用户权限</th>
                            </tr>
                            <tr>
                                <td>发表主题:</td>
                                <td>
                                    <%if (Model.Permission.PostTopic > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>回复主题:</td>
                                <td>
                                    <%if (Model.Permission.PostReply > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>发表隐藏帖:</td>
                                <td>
                                    <%if (Model.Permission.PostBanTopic > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>显示隐藏帖:</td>
                                <td>
                                    <%if (Model.Permission.ViewBanTopic > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>主题评分:</td>
                                <td>
                                    <%if (Model.Permission.RateTopic > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>回复评分:</td>
                                <td>
                                    <%if (Model.Permission.RateReply > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>删除自己的主题:</td>
                                <td>
                                    <%if (Model.Permission.DeleteMyselfTopic > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>删除自己的回复:</td>
                                <td>
                                    <%if (Model.Permission.DeleteMyselfReply > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>编辑自己的主题:</td>
                                <td>
                                    <%if (Model.Permission.UpdateMyselfTopic > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>编辑自己的回复:</td>
                                <td>
                                    <%if (Model.Permission.UpdateMyselfReply > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>上传附件:</td>
                                <td>
                                    <%if (Model.Permission.UploadAttachment > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>查看附件:</td>
                                <td>
                                    <%if (Model.Permission.ViewAttachment > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>访问版块:</td>
                                <td>
                                    <%if (Model.Permission.VisitBoard > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>访问主题:</td>
                                <td>
                                    <%if (Model.Permission.VisitTopic > 0){ %>
                                        <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                    <%}else{ %>
                                        <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                    <%} %>
                                 </td>
                            </tr>
                            <tr>
                                <td>可上传附件大小:</td>
                                <td>
                                    <%=Html.FriendlyFileSize( Model.Extended.DayAttachmentSize*1024)%>
                                 </td>
                            </tr>
                            <tr>
                                <td>可上传附件类型:</td>
                                <td>
                                    <%if (string.IsNullOrEmpty(Model.Extended.AttachmentExtension)){ %>
                                        不限
                                    <%}else{ %>
                                        <%=Model.Extended.AttachmentExtension%>
                                    <%} %>
                                 </td>
                            </tr>
                            <%if (Model.IsManager){ %>
                                <tr>
                                    <th colspan="2">管理权限</th>
                                </tr>
                                <tr>
                                    <td>主题高亮:</td>
                                    <td>
                                        <%if (Model.ManagePermission.HighLightTopic > 0){ %>
                                            <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                        <%}else{ %>
                                            <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                        <%} %>
                                    </td>
                                </tr>
                                <tr>
                                    <td>主题屏蔽:</td>
                                    <td>
                                        <%if (Model.ManagePermission.BanTopic > 0){ %>
                                            <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                        <%}else{ %>
                                            <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                        <%} %>
                                    </td>
                                </tr>
                                <tr>
                                    <td>回复屏蔽:</td>
                                    <td>
                                        <%if (Model.ManagePermission.BanReply > 0){ %>
                                            <img src="<%=ResolveUrl("../../images/icon_yes.gif") %>" />
                                        <%}else{ %>
                                            <img src="<%=ResolveUrl("../../images/icon_no.gif") %>" />
                                        <%} %>
                                    </td>
                                </tr>
                            <%} %>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>




</asp:Content>