﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.MySettingModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">设置</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $("button[data-loading-text]").btns();

            $("#post").ajaxForm({
                beforeSubmit: function (formData, jqForm, options) {
                    $("button[data-loading-text]").btns("loading");
                    return true;
                },
                success: function (responseText, statusText) {
                    if (responseText.error) {
                        easyDialog.open({ container: { header: '提示', content: responseText.description, noFn: true } });
                        return;
                    }
                    easyDialog.open({
                        container: {
                            header: '提示',
                            content: "保存完成",
                            yesFn: function () { }
                        },
                        callback: function () { window.location.reload(); }
                    });
                },
                error: function () {
                    easyDialog.open({ container: { header: '提示', content: "服务器通讯失败", noFn: true } });
                },
                complete: function () {
                    $("button[data-loading-text]").btns("reset");
                },
                url: "<%=Url.Action("My_Setting","Handler") %>",
                    type: 'post',
                    dataType: 'json'
            });
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">


<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "Setting", ViewData);%>
    <div class="content">
        <div class="box_panel list_panel">
            <div class="box_panel_title">浏览设置</div>
	        <div class="box_panel_context form_panel_b">
                <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                    <dl>
                        <dt>皮肤</dt>
                        <dd>
                            <%=Html.DropDownList("skin", new SelectList(Model.Skins, "Id", "Name",Model.SkinId), "系统", null)%>
                            <div class="description">希望使用的皮肤</div>
                        </dd>
                    </dl>
                    <div class="control">
                        <button type="submit" name="Ok" class="button skyblue" data-loading-text="保存中...">确认</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



</asp:Content>