﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.TopicPageModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">我的主题</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script src="<%=ResolveUrl("../../scripts/jquery.twbsPagination/jquery.twbsPagination.js")%>" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('.sync-pagination').empty();
            $('.sync-pagination').twbsPagination({
                totalPages: <%=Model.PageCount %>,
                visiblePages: 7,
                startPage:<%=Model.PageIndex %>,
                first:'<<',
                prev:'上一页',
                next:'下一页',
                last:'',
                onPageClick: function (event, page) {
                    if(page==<%=Model.PageIndex %>)
                        return;
                    $("#form_page input[name='page']").val(page);
                    $("#form_page").submit();
                }
            });
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    
    <form id="form_page" method="get" action="<%=Request.Url.AbsoluteUri %>">
        <input type="hidden" name="page" value="<%=Model.PageIndex%>" />
    </form>
<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "Topics", ViewData);%>
    <div class="content">
        <div class="box_panel list_panel topic_list_panel">
            <div class="box_panel_title">我的主题</div>
	        <div class="box_panel_context">
                <%Html.RenderPartial("TopicList", Model.TopicItems); %>
            </div>
        </div>
        <div class="sp clearfix">
            <div class="page_panel fr">
            <ul class="sync-pagination"><li class="page"><a href="javascript:void(0);">页码加载中...</a></li></ul>
            </div>
        </div>
    </div>
</div>


</asp:Content>