﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IList<Jokul.Forum.MvcApp.Home.Models.TopicRowModel>>" %>


                <div class="list_panel list_panel_cut">
                    <table>
                        <thead>
                            <tr>
                                <td colspan="2" class="title"><%=Html.Lang("main.topic_list.title")%></td>
                                <td class="author"><%=Html.Lang("main.topic_list.create")%></td>
                                <td class="nums"><%=Html.Lang("main.topic_list.reply")%>/<%=Html.Lang("main.topic_list.view")%></td>
                                <td class="last"><%=Html.Lang("main.topic_list.last")%></td>
                            </tr>
                        </thead>
                        <tbody>
                            <%if (Model.Count > 0){ %>
                                <%foreach (var topic in Model){ %>
                                    <tr>
                                        <td class="icon">
                                            <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>" target="_blank">
                                                <img src="<%=ResolveUrl("../../images/topic_state_"+topic.IconKey+".gif") %>" title="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" alt="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" />
                                            </a>
                                        </td>
                                        <td class="title">
                                            <%if(topic.Board!=null){ %>
                                                <em>
                                                <a href="<%=Url.SiteAction("Show","Board",new{bid=topic.BoardId}) %>">[<%=topic.Board.Name%>]</a>
                                                </em>
                                            <%} %>
                                            <%if (topic.Ban > 0){ %>
                                                <del>
                                                    <a href="<%=Url.SiteAction("Show", "Topic", new { tid=topic.Id})%>"> 
                                                        此主题已经被管理人员屏蔽
                                                    </a>
                                                </del>
                                            <%}else{ %>
                                                <span class="topic_title">
                                                    <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>" title="<%=Html.Encode(topic.Title)%>">
                                                        <%=Html.Encode(topic.Title) %>
                                                    </a>
                                                </span>
                                            <%} %>
                                            <%if (topic.Rate != 0) { %>
                                                <span class="topic_row_rate" title="评分">[<%=topic.Rate>=0?"+":"-" %><%=Math.Abs(topic.Rate).ToString("0.##") %>]</span>
                                            <%} %>
                                            <%if (topic.Attachment == (int)EAttachmentType.File) { %>
                                                <span class="attachment_file" title="附件">[附件]</span>
                                            <%}else if (topic.Attachment== (int)EAttachmentType.Image){ %>
                                                <span class="attachment_image" title="图像">[图]</span>
                                            <%} %>
                                            <%if(topic.IsReplyNew){ %>
                                                <span class="topic_new" title="新">[新]</span>
                                            <%} %>
                                        </td>
                                        <td class="author">
                                            <cite>
                                                <%if (topic.PostUserId>0 && !string.IsNullOrEmpty(topic.PostUsername)){ %>
                                                    <%if(string.IsNullOrEmpty(topic.PostHighLight)){ %>
                                                        <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.PostUserId })%>"><%=topic.PostUsername %></a>
                                                    <%}else{ %>
                                                        <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.PostUserId })%>"><span style="<%=topic.PostHighLight%>"><%=topic.PostUsername %></span></a>
                                                    <%} %>
                                                <%}else{ %>
                                                    -
                                                <%} %>
                                            </cite>
                                            <em title="<%=Html.ForumTime(topic.PostDatetime).ToString("yyyy-MM-dd HH:mm") %>">
                                                <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>" title="<%=Html.ForumTime(topic.PostDatetime).ToString("yyyy-MM-dd HH:mm") %>">
                                                    <%=Html.FriendlyTime(topic.PostDatetime, "yyyy-MM-dd HH:mm") %>
                                                </a>
                                            </em>
                                        </td>
                                        <td class="nums">
                                            <strong><%=topic.ReplayCount %></strong>
                                            <em><%=topic.ViewCount %></em>
                                        </td>
                                        <td class="last">
                                            <cite>
                                                <%if (topic.LastPostUserId>0 && !string.IsNullOrEmpty(topic.LastPostUsername)){ %>
                                                    <%if(string.IsNullOrEmpty(topic.LastHighLight)){ %>
                                                        <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.LastPostUserId })%>"><%=topic.LastPostUsername %></a>
                                                    <%}else{ %>
                                                        <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.LastPostUserId })%>"><span style="<%=topic.LastHighLight%>"><%=topic.LastPostUsername %></span></a>
                                                    <%} %>
                                                <%}else{ %>
                                                    -
                                                <%} %>
                                            </cite>
                                            <em title="<%=Html.ForumTime(topic.LastPostDatetime).ToString("yyyy-MM-dd HH:mm") %>"<%if(topic.IsReplyNew) {%> class="hi"<%} %>>
                                                <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id,page="-1"}) %>#last_reply" title="<%=Html.ForumTime(topic.LastPostDatetime).ToString("yyyy-MM-dd HH:mm") %>">
                                                    <%=Html.FriendlyTime(topic.LastPostDatetime, "yyyy-MM-dd HH:mm")%>
                                                </a>
                                            </em>
                                        </td>
                                    </tr>
                                <%} %>
                            <%}else{ %>
                                <tr>
                                    <td colspan="5">无记录</td>
                                </tr>
                            <%} %>
                        </tbody>
                    </table>
                </div>