﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.TopicDestructionRatePostModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">首页</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#reson").change(function () {
                var me = $(this);
                var c = $("form textarea");
                c.val(me.val())
                c.text(me.val());
            });

            var options = {
                beforeSubmit: function(formData, jqForm, options) {
                    easyDialog.open({container : {content : '正在提交。。。'}});
                    return true;
                },
                success: function(responseText, statusText) {
                    if (!responseText.error)
                    {
                        top.location.href=responseText.url;
                        return;
                    }
                    easyDialog.open({container : {header : '提示',content : responseText.description,noFn : true}});

                },
                error: function() {
                    easyDialog.open({container : {header : '提示',content : "服务器通讯失败",noFn : true}});
                },
                complete:function(){
                },
                url: "<%=Url.Action("Topic_DestructionRatePost","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#post").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel manage_panel">
        <div class="box_panel_title">帖子评分撤销</div>
        <div class="box_panel_context form_panel_b">
            <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <input name="url" type="hidden" value="<%=Model.ResultUrl %>" />
                <input name="bid" type="hidden" value="<%=Model.BId%>" />
                <input name="tid" type="hidden" value="<%=Model.TId%>" />
                <input name="pid" type="hidden" value="<%=Model.PId%>" />
                
                <dl>
                    <dt>
                        积分
                    </dt>
                    <dd>
                        <table class="line">
                        <thead>
                            <tr>
                                <td>撤销</td>
                                <td>评分人</td>
                                <td>评分</td>
                                <td>原因</td>
                            </tr>
                        </thead>
                        <tbody>
                        <%var scores =Model.Score;%>
                        <%foreach (var grade in Model.Grades){ %>
                            <tr>
                                <td><input type="checkbox" name="grade_ids" value="<%=grade.Id %>"/></td>
                                <td><%=grade.Username%></td>
                                <td>
                                    <%int scores_index = 0; %>
                                    <%for(int i=0;i<Model.Score.Length;i++){ %>
                                        <%var ex = scores[i]; %>
                                        <%if (!ex.Enabled) continue; %>
                                        <%if (grade.Credits[i]==0) continue; %>

                                        <%if (scores_index > 0){ %>,<%} %>
                                        <%scores_index++; %>
                                        <%=ex.Name %>:<%=grade.Credits[i]>0?"+":"" %><%=grade.Credits[i].ToString("0.##")%>
                                    <%} %>
                                </td>
                                <td>
                                    <%if(string.IsNullOrEmpty(grade.Reason)){ %>
                                        无
                                    <%}else{ %>
                                        <%=grade.Reason%>
                                    <%} %>
                                </td>
                            </tr>
                        <%} %>
                        </tbody>
                        </table>
                    </dd>
                </dl>
                <dl>
                    <dt>
                        原因
                    </dt>
                    <dd>
                        <%if (Model.ManageReason.Length > 0){ %>
                            <div>
                            快捷原因：
                            <select id="reson">
                                <option value="">自定义</option>
                                <option value="">-----</option>
                                <%foreach (var reason in Model.ManageReason){ %>
                                    <option value="<%=Server.HtmlEncode(reason) %>"><%=string.IsNullOrEmpty(reason)?"-----":reason %></option>
                                <%} %>
                            </select>
                            </div>
                        <%} %>
                        <div class="text_area">
                            <textarea cols="50" rows="5" name="reason"></textarea>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>通知</dt>
                    <dd>
                        <input id="send_short_message" type="checkbox" name="send_message" value="1" checked="checked" />
                        <label for="send_short_message">操作后将以站内信方式通知作者</label>
                    </dd>
                </dl>
                <div class="control button_bar clearfix">
                    <ul>
                        <li>
                            <button type="submit" name="ok" value="ok" class="button skyblue">确认</button>
                        </li>
                        <li>
                            <button type="button" name="cancel" value="cancel" onclick="javascript: history.go(-1);" class="button">返回</button>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
    </div>


</asp:Content>