﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.TopicShowModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server"><%=Html.Encode( Model.CurrentTopic.Title) %></asp:Content>
<asp:Content ContentPlaceHolderID="RenderPointTop" runat="server">
    <%=RenderPluginPoint("topic.show.top") %>
</asp:Content>
<asp:Content ContentPlaceHolderID="RenderPointBottom" runat="server">
    <%=RenderPluginPoint("topic.show.bottom") %>
</asp:Content>
<asp:Content ContentPlaceHolderID="HeadStyle" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
    <link href="<%=this.ResolveUrl ("../../scripts/shadowbox/shadowbox.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=Url.SiteAction("Show","Topic",new RouteValueDictionary(new{tid=Model.CurrentTopic.Id}),SiteActionHostNameOut.MustHostName ) %>" rel="canonical" />
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    
     
    <div class="sp clearfix">
        <%if(Model.CanCreateTopic || Model.CanCreateReply || (!Model.CanCreateReply && User.Id==0) || Model.OperateTopic.OperateBatch|| Model.OperateReply.OperateBatch){ %>
        <div class="button_panel fl">
            <ul class="fl">
                <%if (Model.CanCreateTopic){ %>
                    <li>
                        <a href="<%=Url.Action("Create","Topic",new{bid=Model.CurrentBoard.Id},null) %>">
                            <img src="<%=ResolveUrl("../../images/post_button.png")%>" alt="发帖" />
                        </a>
                    </li>
                <%} %>
                <%if (Model.CanCreateReply){ %>
                    <li>
                        <a href="<%=Url.Action("CreateReply","Topic",new{tid=Model.CurrentTopic.Id},null) %>">
                            <img src="<%=ResolveUrl("../../images/reply_button.png")%>" alt="回复" />
                        </a>
                    </li>
                <%}else{ %>
                    <%if (User.Id == 0) { %>
                        <li>
                            <span class="no_ct">
                                您所在分组(<strong><%=Group.Name %></strong>)还不能进行回复
                                    ，您可以进行<a href="<%=Url.Action("Login","Account") %>">登录</a>或<a href="<%=Url.Action("Register","Account") %>">注册</a>
                            </span>
                        </li>
                    <%} %>
                <%} %>
                <%if (Model.OperateTopic.OperateBatch || Model.OperateReply.OperateBatch) { %>
                    <li>
                        <a href="javascript:void(0);">
                            <img class="mypop" data-pop-id="manage_panel" src="<%=ResolveUrl("../../images/manage_button.png")%>" alt="管理" />
                        </a>
                    </li>
                <%} %>
            </ul>
        </div>
        <%} %>
        <div class="page_panel fr">
            <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
        </div>
    </div>
    <%if(Model.Audited>0){ %>
        <div class="gginfo sp">
            <a href="<%=Url.Action("Show", "Topic", new { tid=Model.CurrentTopic.Id,audit=1})%>">您在本主题中有 <strong><%=Model.Audited %></strong> 条等待审核的回复</a>
        </div>
    <%} %>
    <div id="top_reply" class="box_panel sp post_list_panel">
        <form id="moderate" method="post" action="<%=Html.AttributeEncode(Request.Url.AbsoluteUri) %>">
            <input type="hidden" name="bid" value="<%=Model.CurrentBoard.Id %>" />
            <input type="hidden" name="tids" value="<%=Model.CurrentTopic.Id %>" />
            <input type="hidden" name="url" value="<%=Html.AttributeEncode(Request.RawUrl)%>" />
            <input type="hidden" name="tid" value="<%=Model.CurrentTopic.Id %>" />
            <%if (Model.OperateTopic.OperateBatch || Model.OperateReply.OperateBatch){ %>
                <div id="manage_panel" class="pop_panel manage_pop_panel">
	                <div class="content">
                        <%if(Model.OperateTopic.OperateBatch){ %>
                            <h3>主题管理</h3>
                            <ul>
                                <%if(Model.OperateTopic.Top){ %><li><a href="<%=Url.Action("Top", "Topic") %>" class="manage_action">主题置顶/取消</a></li><%} %>
                                <%if(Model.OperateTopic.Digest){ %><li><a href="<%=Url.Action("Digest", "Topic") %>" class="manage_action">精华设置/取消</a></li><%} %>
                                <%if(Model.OperateTopic.Close){ %><li><a href="<%=Url.Action("Close", "Topic") %>" class="manage_action">主题打开/关闭</a></li><%} %>
                                <%if(Model.OperateTopic.HighLight){ %><li><a href="<%=Url.Action("HighLight", "Topic") %>" class="manage_action">主题高亮</a></li><%} %>
                                <%if(Model.OperateTopic.Ban){ %><li><a href="<%=Url.Action("Ban", "Topic") %>" class="manage_action">主题屏蔽</a></li><%} %>
                                <%if(Model.OperateTopic.Delete){ %><li><a href="<%=Url.Action("Delete", "Topic") %>" class="manage_action">删除主题</a></li><%} %>
                                <%if(Model.OperateTopic.Move){ %><li><a href="<%=Url.Action("Move", "Topic") %>" class="manage_action">移动主题</a></li><%} %>
                                <%if(Model.OperateTopic.Type){ %><li><a href="<%=Url.Action("Type", "Topic") %>" class="manage_action">主题分类</a></li><%} %>
                            </ul>
                        <%} %>
                        <%if(Model.OperateReply.OperateBatch){ %>
                            <h3>批量回复管理</h3>
                            <%if(Model.CurrentTopic.ReplayCount>0){ %>
                                <ul>
                                    <li>
                                        <input id="post_select_all" type="checkbox" class="select_all" />
                                        <label for="post_select_all">全部回复</label>
                                    </li>
                                </ul>
                            <%} %>
                            <ul>
                                <%if(Model.OperateReply.Ban){ %><li><a href="<%=Url.Action("BanReply", "Topic") %>" class="manage_action">屏蔽回复</a></li><%} %>
                                <%if (Model.OperateReply.Delete) { %><li><a href="<%=Url.Action("DeleteReply", "Topic") %>" class="manage_action">删除回复</a></li><%} %>
                            </ul>
                        <%} %>
                    </div>
                </div>
                <%if (Model.OperateReply.OperateBatch) { %>
                    <div id="manageTopic" class="box_panel box_panel__color_easy post_manage_panel">
                        <div class="box_panel_title clearfix">
                            <div class="fl">选择了<span id="manageTopicCount">0</span>个回复</div>
	                        <div class="fr">
                                <input id="flex_post_select_all" type="checkbox" class="select_all" />
                                <label for="flex_post_select_all">全部回复</label>
                                <span class="pipe">|</span>
                                <span class="select_all_cancel">取消</span>
	                        </div>
                        </div>
                        <div class="box_panel_context">
                            <ul>
                                <%if(Model.OperateReply.Ban){ %><li><a href="<%=Url.Action("BanReply", "Topic") %>" class="manage_action">屏蔽回复</a></li><%} %>
                                <%if (Model.OperateReply.Delete) { %><li><a href="<%=Url.Action("DeleteReply", "Topic") %>" class="manage_action">删除回复</a></li><%} %>
                            </ul>
                        </div>
                    </div>
                <%} %>
            <%} %>
            <div class="thread_bar clearfix">
                <div class="thread_info">
                    <ul>
                        <li>
                            <em><%=Model.CurrentTopic.ViewCount%></em>
                            阅读
                        </li>
                        <li>
                            <em><%=Model.CurrentTopic.ReplayCount%></em>
                            回复
                        </li>
                    </ul>
                </div>
                <h1>
                    <%if (Model.TopicType!=null){ %>
                        [<%=Model.TopicType.Name %>]
                    <%} %>
                    <%if (Model.CurrentTopic.Ban > 0){ %>
                        此主题已经被管理人员屏蔽
                    <%}else{ %>
                        <%=Html.Encode(Html.InterceptStr( Model.CurrentTopic.Title,36*2,"..."))%>
                    <%} %>
                </h1>
                <div class="post_size_control">
                    <em onclick="$('.msg').removeClass().addClass('msg t_bigfont')">大</em>
                    <span class="pipe">|</span>
                    <em onclick="$('.msg').removeClass().addClass('msg t_msgfont')">中</em>
                    <span class="pipe">|</span>
                    <em onclick="$('.msg').removeClass().addClass('msg t_smallfont')">小</em>
                </div>
            </div>
            <div class="wline">
                <div class="left_bg">&nbsp;</div>
            </div>
            <%if (Model.Posts.Length > 0){ %>
                <%for (int postIndex = 0; postIndex < Model.Posts.Length; postIndex++) { %>
                    <%var post = Model.Posts[postIndex]; %>
                    <div id="reply_<%=post.Id %>" class="post">
                        <%if (postIndex + 1 == Model.Posts.Length) { %>
                            <div id="last_reply"></div>
                        <%} %>
                        <table class="pt">
                            <tr>
                                <td rowspan="2" class="user_info">
                                        <div class="user_pop clearfix" id="user_pop_<%=post.Id %>">
                                            <div class="userex">
                                                <div class="avatar">
                                                    <img src="<%=Url.Avatar120( post.Author.Id) %>" onerror="this.onerror=null;this.src='<%=ResolveUrl("../../images/avatar_none_120.jpg")%>'" alt="<%=Html.Encode(post.Author.Username) %>" />
                                                </div>
                                                <%if (post.Author.Id > 0) { %>
                                                    <div class="post_pm" style="line-height:25px;">
                                                        <a href="<%=Url.Action("PMSend", "My", new {uid=post.Author.Id })%>">发送短消息</a>
                                                    </div>
                                                <%} %>
                                            </div>
                                            <div class="popex">
                                                <ul class="attr">
                                                    <%if (post.Author.Id > 0) { %>
                                                        <li><label>UID:</label><%=post.Author.Id%></li>
                                                    <%} %>
                                                    <li>
                                                        <label>性别:</label>
                                                        <%if (post.Author.Gender == 1){ %>
                                                            男
                                                        <%}else if (post.Author.Gender == 2){ %>
                                                            女
                                                        <%}else{ %>
                                                            保密
                                                        <%} %>
                                                    </li>
                                                    <%if (!string.IsNullOrEmpty(post.PostUserIp)){ %>
                                                        <li><label>IP:</label><%=post.PostUserIp %></li>
                                                    <%} %>
                                                    <%if (post.Author.Id>0){ %>
                                                        <%if (!string.IsNullOrEmpty(post.Author.QQ)) {%>
                                                            <li><label>QQ:</label><%=post.Author.QQ%></li>
                                                        <%}%>
                                                        <%if (!string.IsNullOrEmpty(post.Author.MSN)){%>
                                                            <li><label>MSN:</label><%=post.Author.MSN%></li>
                                                        <%}%>
                                                        <li><label>积分:</label><%=post.Author.Credit.ToString("0.####")%></li>
                                                        <li><label>主题:</label><%=post.Author.TopicCount%></li>
                                                        <li><label>帖子:</label><%=post.Author.PostCount%></li>
                                                        <li><label>精华:</label><%=post.Author.PostDigestCount%></li>
                                                        <%if (!string.IsNullOrEmpty(post.Author.Address)){ %>
                                                            <li><label>来自:</label><%=post.Author.Address%></li>
                                                        <%} %>
                                                        <li><label>注册日期:</label><%=Html.ForumTime(post.Author.CreateDateTime).ToString("yyyy-MM-dd")%></li>
                                                        <li><label>最后登录:</label><%=Html.ForumTime(post.Author.LastDateTime).ToString("yyyy-MM-dd")%></li>
                                                    <%} %>
                                                </ul>
                                            </div>
                                        </div>
                                    <%if(post.Author.Id == Model.CurrentTopic.PostUserId){ %>
                                        <div class="man_icon">楼主帖</div>
                                    <%} %>
                                    <div class="avatar UserInfoPanelEx" data-exid="user_pop_<%=post.Id %>">
                                        <img src="<%=Url.Avatar120( post.Author.Id) %>" onerror="this.onerror=null;this.src='<%=ResolveUrl("../../images/avatar_none_120.jpg")%>'" alt="<%=Html.Encode(post.Author.Username) %>" />
                                    </div>
                                    <div class="username">
                                        <%if(Model.ShowOnline){ %>
                                            <span class="user_online_icon <%=post.Author.IsOnline?"user_online":"user_offline" %>_<%=post.Author.Gender==2?"female":"male" %>" title="<%=post.Author.IsOnline?"在线":"离线"%>"></span>
                                        <%} %>
                                        <%if (post.Author.Id > 0){ %>
                                            <%if(string.IsNullOrEmpty(post.Author.Group.HighLight)){ %>
                                                <a href="<%=Url.SiteAction("Show", "User", new { uid = post.Author.Id })%>"><%=post.Author.Username %></a>
                                            <%}else{ %>
                                                <a href="<%=Url.SiteAction("Show", "User", new { uid = post.Author.Id })%>"><span style="<%=post.Author.Group.HighLight%>"><%=post.Author.Username %></span></a>
                                            <%} %>
                                        <%}else{ %>
                                            <%=post.Author.Username %>
                                        <%} %>
                                    </div>
                                    <div class="exinfo">
                                        <%if (post.Author.Id > 0){ %>
                                            <ul class="attr">
                                                <li>
                                                    <%if(string.IsNullOrEmpty(post.Author.Group.HighLight)){ %>
                                                        <%=post.Author.Group.Name%>
                                                    <%}else{ %>
                                                        <span style="<%=post.Author.Group.HighLight%>"><%=post.Author.Group.Name%></span>
                                                    <%} %>
                                                </li>
                                                <%if(!string.IsNullOrEmpty(post.Author.Group.Image)){ %>
                                                    <li><img src="<%=post.Author.Group.Image.StartsWith("http://",StringComparison.OrdinalIgnoreCase)?post.Author.Group.Image: ResolveUrl("../../../../static/images/group/" + post.Author.Group.Image)%>" alt="<%=post.Author.Group.Name %>" title="<%=post.Author.Group.Name %>" /></li>
                                                <%} %>
                                                <%for (int i = 0; i < Model.Points.Length; i++) {%>
                                                <%if (Model.Points[i].Enabled) { %>
                                                <li><label><%=Model.Points[i].Name%>:</label><%=post.Author.Credits[i].ToString("0.####")%> <%=Model.Points[i].Unit%></li>
                                                <%}//if%>
                                                <%}//for%>
                                                <li><label>积分:</label><%=post.Author.Credit.ToString("0.####")%></li>
                                            </ul>
                                            <%if (post.Medal.Count>0) {%>
                                                <div class="xz">
                                                    <ul>
                                                        <%foreach (var medal in post.Medal) { %>
                                                            <li>
                                                                <%if(!StringHelper.IsNullOrWhiteSpace(medal.Url)){ %>
                                                                    <a href="<%=medal.Url %>" target="_blank">
                                                                <%} %>
                                                                    <img src="<%=ResolveUrl("../../../../static/images/medal/" + medal.Image)%>" alt="<%=Html.Encode(medal.Name) %>" title="<%=Html.Encode(medal.Name) %><%if(!StringHelper.IsNullOrWhiteSpace(medal.Description)){ %>:<%=Html.Encode(medal.Description) %><%} %>" />
                                                                <%if(!StringHelper.IsNullOrWhiteSpace(medal.Url)){ %>
                                                                    </a>
                                                                <%} %>
                                                            </li>
                                                        <%} %>
                                                    </ul>
                                                </div>
                                            <%} %>
                                        <%}else{ %>
                                            <dl>
                                                <dt>IP</dt>
                                                <dd><%=post.PostUserIp %></dd>
                                            </dl>
                                        <%} %>
                                    </div>
                                </td>
                                <td class="post_info">
                                    <div class="post_toolbar clearfix">
                                        <div class="fl">
                                            <%if (Model.OperateReply.OperateBatch && post.First <= 0){ %>
                                                <input id="post_<%=post.Id %>_select" type="checkbox" value="<%=post.Id%>" name="rids"/>
                                                <label for="post_<%=post.Id %>_select">管理</label>
                                                <span class="pipe">|</span>
                                            <%} %>
                                            发表于:
                                            <span title="<%=Html.ForumTime( post.PostDateTime).ToString("yyyy-MM-dd HH:mm") %>">
                                                <%=Html.FriendlyTime(post.PostDateTime, "yyyy-MM-dd HH:mm:ss")%>
                                            </span>
                                            
                                        </div>
                                        <div class="fr">
                                            <%if (post.OperatePostItem.DestructionRate){ %>
                                                <%=Html.ActionLink("撤销评分", "DestructionRatePost", "Topic", new { bid = post.BoardId, tid = post.TopicId, pid = post.Id, url = Request.RawUrl }, null)%>
                                                <span class="pipe">|</span>
                                            <%} %>
                                            <%if (post.First > 0){ %>
                                                <%if (Model.OperateTopic.Update) { %>
                                                    <%=Html.ActionLink("编辑", "Update", "Topic", new { tid = post.TopicId }, null)%>
                                                    <span class="pipe">|</span>
                                                <%} %>
                                            <%}else{ %>
                                                <%if (Model.OperateReply.Update){ %>
                                                    <%=Html.ActionLink("编辑", "UpdateReply", "Topic", new { tid = post.TopicId, rid = post.Id }, null)%>
                                                    <span class="pipe">|</span>
                                                <%} %>
                                            <%} %>
                                            <strong><%=post.Lev%></strong>
                                        </div>
                                    </div>
                                    <div class="post_main">
                                        <%if (!string.IsNullOrEmpty(Model.AD3[postIndex])){ %>
                                            <div class="adtop">
                                                <%=Model.AD3[postIndex]%>
                                            </div>
                                        <%} %>
                                        <%if(post.First>0 && Model.CurrentTopic.Invisible>0){ %>
                                            <div class="mb">请注意此主题已经在回收站中</div>
                                        <%}%>
                                        <%if (post.Warning == 1){ %>
                                            <div class="mb">提示:该帖被管理员人员屏蔽</div>
                                        <%} else if (post.Warning==2){%>
                                            <div class="mb">提示:该帖内容正在等待审核</div>
                                        <%}else if (post.Warning == 101){ %>
                                            <div class="mb">提示:该帖被管理员人员屏蔽，限有管理权限的成员或发帖用户可见</div>
                                        <%}else if (post.Warning==102){ %>
                                            <div class="mb">提示:该帖内容正在等待审核，限有管理权限的成员或发帖用户可见</div>
                                        <%} %>
                                        <%if(post.Content){ %>
                                            <%if(post.First>0 && Model.CurrentTopic.Close>0){ %>
                                                <div class="mb">
                                                    本主题已经关闭
                                                </div>
                                            <%} %>
                                            <%=RenderPluginPoint("topic.show.post.message",postIndex) %>
                                            <div id="postMessage_<%=post.Id %>" class="msg t_msgfont">
                                                <%if (!string.IsNullOrEmpty(Model.AD2[postIndex])){ %>
                                                    <div class="adright">
                                                        <%=Model.AD2[postIndex]%>
                                                    </div>
                                                <%} %>
                                                <%=post.Message%>
                                            </div>
                                            <%if (post.ImageAttachment.Length> 0){ %>
                                                <div class="list_panel rate_list_panel">
                                                    <table>
                                                        <thead>
                                                            <tr>
                                                                <td>图像附件</td>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <%foreach (var a in post.ImageAttachment) { %>
                                                                <tr>
                                                                    <td>
                                                                        <%=Html.RenderAttachment( a) %>
                                                                    </td>
                                                                </tr>
                                                            <%} %>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            <%} %>
                                            <%if (post.FileAttachment.Length> 0){ %>
                                                <div class="list_panel rate_list_panel">
                                                    <table>
                                                        <thead>
                                                            <tr>
                                                                <td>附件列表</td>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <%foreach (var a in post.FileAttachment) { %>
                                                                <tr>
                                                                    <td>
                                                                        <%=Html.RenderAttachment( a) %>
                                                                    </td>
                                                                </tr>
                                                            <%} %>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            <%} %>
                                            <%if (post.Rate != null || post.RateList != null) { %>
                                                <div class="list_panel rate_list_panel">
                                                    <table>
                                                        <%if(post.Rate!=null){ %>
                                                            <thead>
                                                                <tr>
                                                                    <td style="width:160px;">已有<em><%=post.Rate.UserCount %></em>人评分</td>
                                                                    <%for (int i = 0; i < Model.Points.Length; i++) {%>
                                                                        <%if (Model.Points[i].Enabled && post.Rate.Credits[i]!=0) { %>
                                                                            <td style="width:60px;"><%=Model.Points[i].Name%></td>
                                                                        <%}//if%>
                                                                    <%}//for%>
                                                                    <td>理由</td>
                                                                    <td style="width:160px;">时间</td>
                                                                </tr>
                                                            </thead>
                                                        <%} %>
                                                        <%if (post.RateList != null) { %>
                                                            <tbody>
                                                                <%foreach(var rate_user in post.RateList){  %>
                                                                    <tr>
                                                                        <td>
                                                                            <img src="<%=Url.Avatar50(rate_user.UserId) %>" width="24" onerror="this.onerror=null;this.src='<%=ResolveUrl("../../images/avatar_none_50.jpg")%>'" alt="<%=Html.Encode(rate_user.UserId) %>" />
                                                                            <a href="<%=Url.SiteAction("Show", "User", new { uid=rate_user.UserId})%>" target="_blank"><%=rate_user.Username %></a>
                                                                        </td>
                                                                        <%for (int i = 0; i < Model.Points.Length; i++) {%>
                                                                            <%if (Model.Points[i].Enabled && post.Rate.Credits[i] != 0) { %>
                                                                                <td><%=rate_user.Credits[i]!=0?rate_user.Credits[i].ToString("0.####"):"-"%></td>
                                                                            <%}//if%>
                                                                        <%}//for%>
                                                                        <td class="description"><%=Html.Encode(rate_user.Reason) %></td>
                                                                        <td><span title="<%=Html.ForumTime(rate_user.Time).ToString("yyyy-MM-dd HH:mm") %>"><%=Html.FriendlyTime(rate_user.Time) %><span></td>
                                                                    </tr>
                                                                <%} %>
                                                            </tbody>
                                                        <%} %>
                                                    </table>
                                                </div>
                                                <div class="rate_total">
                                                    总评分: 
                                                    <%for (int i = 0; i < Model.Points.Length; i++) {%>
                                                        <%if (Model.Points[i].Enabled && post.Rate.Credits[i]!=0) { %>
                                                            <span><%=Model.Points[i].Name%><em><%=post.Rate.Credits[i]>=0?"+":"-" %><%=Math.Abs(post.Rate.Credits[i]).ToString("0.####")%></em></span>
                                                        <%}//if%>
                                                    <%}//for%>
                                                    <a href="<%=Url.Action("RateList", "Topic", new { tid=Model.CurrentTopic.Id,pid=post.Id})%>" target="_blank">查看全部评分</a>
                                                </div>
                                            <%} %>
                                            <%if (post.UpdateUserId>0){ %>
                                                <div class="lastedit">
                                                    <%=post.UpdateUsername%> 于 <span title="<%=Html.ForumTime(post.UpdateTime).ToString("yyyy-MM-dd HH:mm") %>"><%=Html.FriendlyTime(post.UpdateTime, "yyyy-MM-dd HH:mm")%></span> 编辑过此帖
                                                </div>
                                            <%} %>
                                            <%if(post.First>0 && Model.Mod!=null){ %>
                                                <div class="lastmod">
                                                    本主题由 <%=Model.Mod.Username %> 于 <span title="<%=Html.ForumTime(Model.Mod.Time).ToString("yyyy-MM-dd HH:mm") %>"><%=Html.FriendlyTime( Model.Mod.Time,"yyyy-MM-dd HH:mm:ss") %></span> <%=Model.Mod.ActionName %>
                                                </div>
                                            <%} %>
                                        <%} %>
                                        <%if(post.First>0){ %>
                                            <%=RenderPluginPoint("topic.show.topic") %>
                                        <%} %>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td class="ex">
                                    <%if (!string.IsNullOrEmpty(post.Author.Signature)){ %>
                                        <div class="signatures"<%if (Model.UserSignatureHeight > 0){ %> style="_overflow:hidden;_height:<%=Model.UserSignatureHeight%>px;max-height:<%=Model.UserSignatureHeight%>px;"<%} %>>
                                            <%=post.Author.Signature%>
                                        </div>
                                    <%} %>
                                    <%if (!string.IsNullOrEmpty(Model.AD4[postIndex]))
                                        { %>
                                        <div class="adbottom">
                                            <%=Model.AD4[postIndex]%>
                                        </div>
                                    <%} %>
                                </td>
                            </tr>
                            <tr>
                                <td>&nbsp;</td>
                                <td class="post_tool_a">
                                    <div class="post_tool clearfix">
                                        <div class="fl">
                                            <ul>
                                                <li class="action_reply"><%=Html.ActionLink("回复", "CreateReply", "Topic", new { tid = Model.CurrentTopic.Id }, null)%></li>
                                                <%if(post.OperatePostItem.Rate){ %>
                                                    <li class="action_rate">
                                                        <%=Html.ActionLink("评分", "Rate", "Topic", new { bid = post.BoardId, tid = post.TopicId, pid = post.Id, url = Request.RawUrl }, null)%>
                                                    </li>
                                                <%} %>
                                                <%if (post.OperatePostItem.SelfUpdate) { %>
                                                    <li class="action_update">
                                                        <%if (post.First > 0){ %>
                                                            <%=Html.ActionLink("编辑", "Update", "Topic", new { tid = post.TopicId }, null)%>
                                                        <%}else{ %>
                                                            <%=Html.ActionLink("编辑", "UpdateReply", "Topic", new { tid = post.TopicId, rid = post.Id }, null)%>
                                                        <%} %>
                                                    </li>
                                                <%} %>
                                                <%if (post.OperatePostItem.SelfDelete){ %>
                                                    <li class="action_delete">
                                                        <a href="<%=Url.Action("SelfDelete", "Topic", new { tid = post.TopicId,pid = post.Id,agree=1, url = Request.RawUrl })%>" onclick = "javascript:return window.confirm('确定要删除吗?');"><%=post.First > 0?"删除我的主题":"删除我的回复" %></a>
                                                    </li>
                                                <%} %>
                                            </ul>
                                        </div>
                                        <div class="fr">
                                            <a href="#top_reply">返回顶部</a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <%if (postIndex<Model.AD1.Count){ %>
                        <%if (!string.IsNullOrEmpty(Model.AD1[postIndex])){ %>
                            <div class="aline">
                                <div class="b">
                                    <%=Model.AD1[postIndex]%>
                                </div>
                            </div>
                        <%}else{ %>
                            <div class="wline">
                                <div class="left_bg">
                                    &nbsp;
                                </div>
                            </div>
                        <%} %>
                    <%} %>
                <%} %>
            <%}else{ %>
                <div class="post">
                    数据加载失败
                </div>
                <div class="line">
                    <div class="a">
                        &nbsp;
                    </div>
                </div>
            <%} %>
        </form>
    </div>

    <div class="sp clearfix">
        <%if(Model.CanCreateTopic || Model.CanCreateReply || (!Model.CanCreateReply && User.Id==0) || Model.OperateTopic.OperateBatch|| Model.OperateReply.OperateBatch){ %>
        <div class="button_panel fl">
            <ul class="fl">
                <%if (Model.CanCreateTopic){ %>
                    <li>
                        <a href="<%=Url.Action("Create","Topic",new{bid=Model.CurrentBoard.Id},null) %>">
                            <img src="<%=ResolveUrl("../../images/post_button.png")%>" alt="发帖" />
                        </a>
                    </li>
                <%} %>
                <%if (Model.CanCreateReply){ %>
                    <li>
                        <a href="<%=Url.Action("CreateReply","Topic",new{tid=Model.CurrentTopic.Id},null) %>">
                            <img src="<%=ResolveUrl("../../images/reply_button.png")%>" alt="回复" />
                        </a>
                    </li>
                <%}else{ %>
                    <%if (User.Id == 0) { %>
                        <li>
                            <span class="no_ct">
                                您所在分组(<strong><%=Group.Name %></strong>)还不能进行回复
                                    ，您可以进行<a href="<%=Url.Action("Login","Account") %>">登录</a>或<a href="<%=Url.Action("Register","Account") %>">注册</a>
                            </span>
                        </li>
                    <%} %>
                <%} %>
                <%if (Model.OperateTopic.OperateBatch || Model.OperateReply.OperateBatch) { %>
                    <li>
                        <a href="javascript:void(0);">
                            <img class="mypop" data-pop-id="manage_panel" src="<%=ResolveUrl("../../images/manage_button.png")%>" alt="管理" />
                        </a>
                    </li>
                <%} %>
            </ul>
        </div>
        <%} %>
        <div class="page_panel fr">
            <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
        </div>
    </div>

    <%if (Model.QuicklyReply!=null){ %>
        <div class="box_panel sp">
            <div class="box_panel_title clearfix">
                <div class="fl">快速回复</div>
                <div class="fr"><a href="<%=Url.Action("CreateReply","Topic",new{tid=Model.CurrentTopic.Id}) %>">使用高级回帖</a>（可批量传图、插入附件等）</div>
            </div>
            <div class="box_panel_context quickly_create_reply">
                <form id="quickly_create_reply_form" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                    <%=Html.Hidden("tid",Model.CurrentTopic.Id) %>
                    <%=Html.Hidden("smile",1) %>
                    <%=Html.Hidden("signature", 1)%>
                    <%=Html.Hidden("AutoUrl", 1)%>
                    <table>
                        <tr>
                            <td class="author">
                                <div class="username"><%=User.Username %></div>
                                <div class="avatar">
                                    <img src="<%=Url.Avatar120(User.Id) %>" onerror="this.onerror=null;this.src='<%=ResolveUrl("../../images/avatar_none_120.jpg")%>'" alt="<%=Html.Encode(User.Username) %>" />
                                </div>
                            </td>
                            <td class="quickly_create_reply_main">
                                <div class="editor_loading">&nbsp;</div>
                                <div class="editor" style="display:none;">
                                    <textarea name="message" id = "textarea_message" class = "TextField" cols = "60" rows = "20" style="visibility: hidden; display: none;"></textarea>
                                    <%if (Model.QuicklyReply.VCEnabled) { %>
                                        <div class="options">
                                            <%= Html.TextBox("vc",string.Empty, new { size = "4", style = @"text-transform:uppercase;", @class = "vc text", tabindex = "3", value = string.Empty })%>
                                            <img id="vcimg" src="<%=ResolveUrl("../../images/loading.gif")%>" alt="code" />
                                            <a href="#" id="vcimgc" tabindex="6"><%=Html.Lang("account.login.vc_refresh")%></a>
                                        </div>
                                    <%} %>
                                    <%if(Model.QuicklyReply.NeedCheck){ %>
		                                <div class="ginfo sp" style="display: block; text-align: center;">
			                                您所发表的回复将在通过审核后显示
		                                </div>
                                    <%} %>
                                    <div class="action">
                                        <button type="submit" name="Ok" class="button skyblue">确认发布</button>
                                        [在内容区直接按 Ctrl+Enter 可完成发布]
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    <%} %>
</asp:Content>
<asp:Content runat="server" ContentPlaceHolderID="FootContent">
    <%if(Setting.View.LazyLoad){ %>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.lazyload.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            //加载图像
            $("img[data-lasy]").lazyload({
                data_attribute:"lasy",
                failure_limit: 10,
                skip_invisible: false,
                effect: "fadeIn"
            });
        });
    </script>
    <%} %>
    <script src="<%=this.ResolveUrl ("../../scripts/shadowbox/shadowbox.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <%if (Model.QuicklyReply!=null){ %>
    <script src="<%=this.ResolveUrl ("../../scripts/ckeditor/ckeditor.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {

            <%if (Model.QuicklyReply.VCEnabled) { %>
                function updateseccode() {
                    var rand = Math.random();
                    $('#VC').val('');
                    $('#vcimg').attr("src", "<%=Url.Action("ValidateCode", "Handler")%>?key=reply&_=" + rand);
                }
                updateseccode();
                $('#Username').focus();

                $('#vcimg').click(function () {
                    updateseccode();
                    $('#VC').focus();
                });
                $('#vcimgc').click(function () {
                    updateseccode();
                    $('#VC').focus();
                    return false;
                });
            <%} %>


                $("form").each(function (i, n) {
                    (function () {
                        var submit_called = false;
                        var old_submit = n.submit;
                        n.submit = function () {
                            submit_called = true;
                            n.submit = old_submit;
                            $(n).submit();
                        };
                    })(n);
                });

                var editor = CKEDITOR.replace('textarea_message', {
                    on:
                    {
                        instanceReady: function (ev) {
                            $(".editor_loading").remove();
                            $(".editor").show();
                        }
                    },
                    toolbar: [
                        ['Bold', 'Italic', 'Underline', 'Strike', 'Link', 'Unlink', 'RemoveFormat'], ['SmailSelect'], ['Source']
                    ],
                    height: 200,
                    startupFocus: false,
                    enterMode: CKEDITOR.ENTER_BR,
                    shiftEnterMode: CKEDITOR.ENTER_BR,
                    ignoreEmptyParagraph: true,
                    keystrokes: [
                        [CKEDITOR.CTRL + 13, "save"]
                    ],
                    removePlugins: 'elementspath,contextmenu,resize',
                    autoUpdateElement: false,
                    extraPlugins: 'smailbutton,jbbcode',
                    smails: [
                        <%=string.Join(",",Model.Emotions.Select(c=>string.Format("{{name:\"{0}\",items:[{1}]}}", 
                                Html.Encode(c.Name),
                                string.Join(",", c.Emotions.Select(e=>string.Format("{{name:\"{0}\",code:\"{1}\",surl:\"{2}\",url:\"{3}\"}}",
                                        e.Id,
                                        e.Code,
                                        e.Url,
                                        e.Url
                                        )).ToArray())
                            )).ToArray())%>
                    ]
                });

                $("#quickly_create_reply_form").ajaxForm({
                    beforeSerialize: function ($form, options) {
                        editor.updateElement();
                    },
                    beforeSubmit: function (formData, jqForm, options) {
                        easyDialog.open({ container: { content: '正在提交。。。' } });
                        return true;
                    },
                    success: function (responseText, statusText) {
                        if (!responseText.error) {
                            top.location.href = responseText.turl;
                            return;
                        }
                        easyDialog.open({ container: { header: '提示', content: responseText.description, noFn: true } });

                    },
                    error: function () {
                        easyDialog.open({ container: { header: '提示', content: "服务器通讯失败", noFn: true } });
                    },
                    complete: function () {
                    },
                    url: "<%=Url.Action("Reply_Create","Handler") %>",
                    type: 'post',
                    dataType: 'json'
                });
            });
    </script>
    <%} %>
    <script type="text/javascript">
        $(document).ready(function () {

            //$(".post_main img").lazyload();

            $('.UserInfoPanelEx').UserInfoPanel();

            $(".mypop").ExPanel();

            Shadowbox.init({ skipSetup: true });

            $('img[data-zoomfile]').click(function () {
                Shadowbox.open({
                    content: $(this).data('zoomfile'),
                    title: $(this).attr('alt'),
                    player: "img",
                    type: "img",
                    //gallery: $(this).attr('rel'),
                    options: { handleOversize: "drag", displayNav: true, overlayOpacity: 0.9, showOverlay: true }
                });
                return false;
            });

            //$(".attimg").ET();
            //$(".att").ExPanel();

            $('.att').hover(function () {
                var $this = $(this);
                
                var cY =
                (
                    document.documentElement.scrollTop
                    +
                    $(this).position().top
                    +
                    $(this).outerHeight(true)
                    +
                    $this.find('.post_attachs').outerHeight(true)
                    >
                    document.documentElement.scrollHeight
                )
                ?
                $(this).position().top - $this.find('.post_attachs').outerHeight(true)
                :
                $(this).position().top + $(this).outerHeight(true)

                $this.find('.attachment_tip').show().css({
                    left: $this.offset().left,
                    top: cY/*$this.find('.post_attachs').offset().top + $this.find('.post_attachs').outerHeight(true)*/
                });
            }, function () {
                $(this).find('.attachment_tip').hide();
            });

            $('.attimg').hover(function () {
                var $this = $(this);
                $this.find('.attachment_tip').show().css({
                    left: $this.offset().left,
                    top: $this.find('.post_attachs').offset().top
                });
            }, function () {
                $(this).find('.attachment_tip').hide();
            });
        });
    </script>


    <%if (Model.OperateReply.OperateBatch) { %>
    <script type="text/javascript">
        $(document).ready(function () {
            $(".manage_action").click(function () {
                var url = $(this).attr("href");
                var formObj = $("form[id='moderate']")[0];
                formObj.action = url;
                formObj.submit();
                return false;
            });
            ManageTopic();

            function ManageTopic() {
                var len = $("[name='rids']:checkbox:enabled:checked").length;
                if (len > 0) {
                    $("#manageTopicCount").html(len);
                    $("#manageTopic").show();
                }
                else {
                    $("#manageTopic").hide();
                }
                $("#manageTopic").css("left", $("#manageTopic").parent().offset().left + ($("#manageTopic").parent().width() - $("#manageTopic").outerWidth(false)) / 2 + "px");
            }

            $("[name='rids']:checkbox:enabled").click(function () {
                if (!$(this)[0].checked)
                    $(".select_all").checked(false);
                else if ($("[name='rids']:checkbox:checked").length == $("[name='rids']:checkbox:enabled").length)
                    $(".select_all").checked( true);

                ManageTopic();
            });

            $(".select_all_cancel").click(function () {
                $(".select_all").checked( false);
                $("[name='rids']:checkbox:checked").checked( false);
                $("#manageTopic").hide();
            });

            $(".select_all").change(function () {
                var selected = $(this)[0].checked;
                $(".select_all").checked(selected);
                $("[name='rids']:checkbox:enabled").checked(selected);
                ManageTopic();
            });
        });
    </script>
    <%} %>
</asp:Content>
