﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.TopicTopModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">首页</asp:Content>
<asp:Content ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#reson").change(function () {
                var me = $(this);
                var c = $("form textarea");
                c.val(me.val())
                c.text(me.val());
            });

            var options = {
                beforeSubmit: function(formData, jqForm, options) {
                    easyDialog.open({container : {content : '正在提交。。。'}});
                    return true;
                },
                success: function(responseText, statusText) {
                    if (responseText.error)
                    {
                        easyDialog.open({container : {header : '提示',content : responseText.description,noFn : true}});
                        return;
                    }
                    top.location.href=responseText.url;
                },
                error: function() {
                    easyDialog.open({container : {header : '提示',content : "服务器通讯失败",noFn : true}});
                },
                complete:function(){
                },
                url: "<%=Url.Action("Topic_Top","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#post").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel manage_panel">
        <div class="box_panel_title">置顶主题</div>
        <div class="box_panel_context form_panel_b">
            <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <input name="url" type="hidden" value="<%=Model.ResultUrl %>" />
                <input name="bid" type="hidden" value="<%=Model.BId%>" />

                
                <dl>
                    <dt>
                        置顶
                    </dt>
                    <dd>
                        <input id="top0" name="top" type="radio" value="0" checked="checked" />
                        <label for="top0">取消</label>
                        <%if(Model.Top1){ %>
                            <input id="top1" name="top" type="radio" value="1" />
                            <label for="top1">当前版块</label>
                        <%} %>
                        <%if(Model.Top2){ %>
                            <input id="top2" name="top" type="radio" value="2" />
                            <label for="top2">当前版块及其子版块</label>
                        <%} %>
                        <%if(Model.Top3){ %>
                            <input id="top3" name="top" type="radio" value="3" />
                            <label for="top3">全站</label>
                        <%} %>
                        <div class="description">设置或取消某个主题的置顶</div>
                    </dd>
                </dl>
                <dl>
                    <dt>
                        原因
                    </dt>
                    <dd>
                        <%if (Model.ManageReason.Length > 0){ %>
                            <div>
                            快捷原因：
                            <select id="reson">
                                <option value="">自定义</option>
                                <option value="">-----</option>
                                <%foreach (var reason in Model.ManageReason){ %>
                                    <option value="<%=Server.HtmlEncode(reason) %>"><%=string.IsNullOrEmpty(reason)?"-----":reason %></option>
                                <%} %>
                            </select>
                            </div>
                        <%} %>
                        <div class="text_area">
                            <textarea cols="50" rows="5" name="reason"></textarea>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>通知</dt>
                    <dd>
                        <input id="send_short_message" type="checkbox" name="send_message" value="1" checked="checked" />
                        <label for="send_short_message">操作后将以站内信方式通知作者</label>
                    </dd>
                </dl>
                <dl>
                    <dt>
                        相关主题
                    </dt>
                    <dd class="ul_list">
                        <ul>
                            <%foreach (var topic in Model.Topics){ %>
                                <li>
                                    <input id="topic_<%=topic.Id %>" type="checkbox" name="tids" value="<%=topic.Id %>" checked="checked"/>
                                    <label for="topic_<%=topic.Id %>"><%=Html.Encode(topic.Title) %></label>
                                </li>
                            <%} %>
                        </ul>
                    </dd>
                </dl>
                <div class="control button_bar clearfix">
                    <ul>
                        <li>
                            <button type="submit" name="ok" value="ok" class="button skyblue">确认</button>
                        </li>
                        <li>
                            <button type="button" name="cancel" value="cancel" onclick="javascript: history.go(-1);" class="button">返回</button>
                        </li>
                    </ul>
                </div>




            </form>
        </div>
    </div>


</asp:Content>