﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.AccountRegisterByEmailModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">注册</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            <%if (Model.VCEnabled) { %>
            function updateseccode() {
                var rand = Math.random();
                $('#VC').val('');
                $('#vcimg').attr("src","<%=Url.Action("ValidateCode", "Handler")%>?key=register&_="+rand);

                $('#VC').focus();
            }
            updateseccode();
        
            $('#vcimg').click(function() {
                updateseccode();
                $('#VC').focus();
            });
            $('#vcimgc').click(function() {
                updateseccode();
                $('#VC').focus();
                return false;
            });
            <%} %>
            //提交
            $("button[name='Cancel']").click(function(){
                top.location.href="<%=Model.Url %>";
            });
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel sp">
        <div class="box_panel_title clearfix">
            <div class="fl"><%=Html.Lang("account.register.title")%></div>
            <div class="fr"><a href="<%=Url.Action("Login","Account") %>">已有帐号？现在登录</a></div>
        </div>
        <div class="box_panel_context form_panel_a">
            <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <%= Html.ValidationSummary(false,string.Empty, new { @class = "error_panel" })%>
                <dl>
                    <dt><%=Html.Lang("account.register.username")%>:</dt>
                    <dd>
                        <%= Html.TextBox("username",Model.Username, new { size = "40" ,@class="text"+(Html.HasValidationMessage("username")?" error":"")})%>
                    </dd>
                    <dt><%=Html.Lang("account.register.password")%>:</dt>
                    <dd>
                        <%= Html.Password("password", Model.Password, new { size = "40", value = Model.Password, @class = "text"+(Html.HasValidationMessage("password")?" error":"") })%>
                    </dd>
                    <dt><%=Html.Lang("account.register.dpassword")%>:</dt>
                    <dd>
                        <%= Html.Password("tpassword", Model.TPassword, new { size = "40", value = Model.TPassword, @class = "text"+(Html.HasValidationMessage("tpassword")?" error":"") })%>
                    </dd>
                    <%if (Model.Agreement>0){ %>
                        <dd>
                            <label>
                                <%= Html.CheckBox("agree",Model.Agree)%>
                                我同意<%=Html.ActionLink("注册协议", "Agreement", "Account",null, new { target="_blank"})%>
                                <%= Html.ValidationMessage("agreement", "*", new { @class = "error_txt" })%>
                            </label>
                        </dd>
                    <%} %>
                    <%if (Model.VCEnabled) { %>
                        <dt><%=Html.Lang("account.register.vc")%>:</dt>
                        <dd>
                            <%= Html.TextBox("vc", Model.VC, new { size = "4", style = @"text-transform:uppercase;", @class = "vc text"+(Html.HasValidationMessage("vc")?" error":""), value = string.Empty })%>

                            <div class="description">
                                <%=Html.Lang("account.register.vc_description")%><br />
                                <img id="vcimg" src="<%=ResolveUrl("../../images/loading.gif")%>" alt="Loading" /><br />
                                <a href="#" id="vcimgc"><%=Html.Lang("account.register.vc_refresh")%></a>
                            </div>
                        </dd>
                    <%} %>
                    <dd class="button_panel clearfix">
                        <ul>
                            <li><button type="submit" name="Ok" class="button skyblue"><%=Html.Lang("account.register.reg")%></button></li>
                            <li><button type="button" name="Cancel" class="button"><%=Html.Lang("account.register.cancel")%></button></li>
                        </ul>
                    </dd>
                </dl>
            </form>
        </div>
    </div>
</asp:Content>