﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.SearchMainModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">首页</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">


<div class="box_panel sp">
    <div class="box_panel_title">搜索</div>
    <div class="box_panel_context form_panel_a">
        <form id="post" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
            <dl>
                <dt>关键字</dt>
                <dd>
                    <input class="textField" type="text" name="keys" maxlength="40" value="" autocomplete="off" x-webkit-speech="" speech="" placeholder="请输入搜索内容" />
                </dd>
                <dt>类别</dt>
                <dd>
	                <input class="textField" type="radio" id="searchtype_1" name="searchtype" value="1" checked="checked" /><label for="searchtype_1">主题标题</label>
	                <input class="textField" type="radio" id="searchtype_2" name="searchtype" value="2" /><label for="searchtype_2">帖子内容</label>
	                <input class="textField" type="radio" id="searchtype_3" name="searchtype" value="3" /><label for="searchtype_3">主题作者</label>
                </dd>
                <%if (Model.SubTables.Count > 1){ %>
                    <dt>选择分表</dt>
                    <dd>
	                    <select id="subtableid" name="subtableid">
	                        <option value="0">当前默认</option>
                            <%foreach (var t in Model.SubTables)
                                { %>
                                <option value="<%=t.Id %>"><%=t.Name%></option>
                            <%} %>
                        </select>
                    </dd>
                <%} %>
                <dt>结果排序</dt>
                <dd>
	                <select id="OrderId" name="OrderId">
                        <option value="1">最后回复时间</option>
                        <option value="2">发表时间</option>
                        <!--
                        <option value="3">回复数量</option>
                        <option value="4">查看次数</option>
                        -->
                    </select>
	                <input class="textField" type="radio" name="OrderType" value="1" checked="checked" /><label for="resultorder_1">升序</label>
	                <input class="textField" type="radio" name="OrderType" value="2" /><label for="resultorder_1">降序</label>
                </dd>
                <dt>版块</dt>
                <dd>
	                <select size="10" multiple name="board">
	                    <option value="0" selected="selected" >所有开放的版块</option>
                        <%foreach (var board in Model.Boards){ %>
	                        <option value="<%=board.Id %>">
	                            <%for (int i = 0; i < board.Layer; i++){%>&nbsp;&nbsp;<%} %>
	                            <%=board.Name%>
	                        </option>
	                    <%} %>
	                </select>
                </dd>
                <dd class="button_panel clearfix">
                    <ul>
                        <li><button class="button" type="submit">搜索</button></li>
                    </ul>
                </dd>
            </dl>
        </form>
    </div>
</div>

</asp:Content>