﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IList<Jokul.Forum.MvcApp.Home.Models.TopicRowModel>>" %>

<%if (Model.Count > 0){ %>
    <div class="list_panel list_panel_cut">
        <table>
            <tbody>
                <%foreach (var topic in Model){ %>
                    <tr>
                        <td class="icon">
                            <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>" target="_blank">
                                <img src="<%=ResolveUrl("../../images/topic_state_"+topic.IconKey+".gif") %>" title="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" alt="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" />
                            </a>
                        </td>
                        <td class="title">
                            <%if(topic.Board!=null){ %>
                                [<a href="<%=Url.SiteAction("Show","Board",new{bid=topic.BoardId}) %>"><%=topic.Board.Name%></a>]
                            <%} %>
                            <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>">
                                <%=Html.Encode(topic.Title) %>
                            </a>
                            <%if (topic.Rate != 0) { %>
                                <span class="topic_row_rate" title="评分">[<%=topic.Rate>=0?"+":"-" %><%=Math.Abs(topic.Rate).ToString("0.##") %>]</span>
                            <%} %>
                            <%if (topic.Attachment == (int)EAttachmentType.File) { %>
                                <span class="attachment_file" title="附件">[附件]</span>
                            <%}else if (topic.Attachment== (int)EAttachmentType.Image){ %>
                                <span class="attachment_image" title="图像">[图]</span>
                            <%} %>
                            <%if(topic.IsReplyNew){ %>
                                <span class="topic_new" title="新">[新]</span>
                            <%} %>
                            <br />
                            <span class="topic_row_ex">
                                <%if (topic.PostUserId>0){ %>
                                    <a href="<%=Url.Action("Show","User",new {uid=topic.PostUserId}) %>">
                                        <%=topic.PostUsername %>
                                    </a>
                                <%}else{ %>
                                    <%=topic.PostUsername %>
                                <%} %>
                                (<%=Html.FriendlyTime(topic.PostDatetime, "yyyy-MM-dd HH:mm") %>)
                                <%if (topic.ReplayCount>0){ %>
                                    回:<%=topic.ReplayCount %>
                                <%} %>
                            </span>
                        </td>
                    </tr>
                <%} %>
            </tbody>
        </table>
    </div>
<%}else{ %>
    <div class="noitem">
        尚无主题。
    </div>
<%} %>