﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.TopicShowModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server"><%=Html.Encode(Model.CurrentTopic.Title) %></asp:Content>
<asp:Content ContentPlaceHolderID="HeadStyle" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

     
    <div class="sp clearfix">
        <div class="button_panel fl">
            <ul class="fl">
                <li>
                    <a href="<%=Url.Action("Create","Topic",new{bid=Model.CurrentBoard.Id},null) %>">
                        <img src="<%=ResolveUrl("../../images/post_button.png")%>" />
                    </a>
                </li>
                <%if (Model.CurrentTopic.Close<=0){ %>
                    <li>
                        <a href="<%=Url.Action("CreateReply","Topic",new{tid=Model.CurrentTopic.Id},null) %>">
                            <img src="<%=ResolveUrl("../../images/reply_button.png")%>" />
                        </a>
                    </li>
                <%} %>
            </ul>
        </div>
    </div>
    <%if(Model.Audited>0){ %>
        <div class="gginfo sp">
            <a href="<%=Url.Action("Show", "Topic", new { tid=Model.CurrentTopic.Id,audit=1})%>">您在本主题中有 <strong><%=Model.Audited %></strong> 条等待审核的回复</a>
        </div>
    <%} %>
    <div class="box_panel sp post_list_panel">
        <div class="box_panel_title">
            <%if (Model.TopicType!=null){ %>
                [<%=Model.TopicType.Name %>]
            <%} %>
            <%if (Model.CurrentTopic.Ban > 0){ %>
                此主题已经被管理人员屏蔽
            <%}else{ %>
                <%=Html.Encode(StringHelper.InterceptStr( Model.CurrentTopic.Title,40*2,"..."))%>
            <%} %>
        </div>
        <div class="thread_bar">
            阅读:<%=Model.CurrentTopic.ViewCount%>
            <span class="pipe">|</span>
            回复:<%=Model.CurrentTopic.ReplayCount%>
        </div>
        <form id="moderate" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
            <input type="hidden" name="bid" value="<%=Model.CurrentBoard.Id %>" />
            <input type="hidden" name="tids" value="<%=Model.CurrentTopic.Id %>" />
            <input type="hidden" name="url" value="<%=Request.RawUrl%>" />
            <input type="hidden" name="tid" value="<%=Model.CurrentTopic.Id %>" />
            <%if (Model.Posts.Length > 0){ %>
                <%for (int postIndex = 0; postIndex < Model.Posts.Length; postIndex++) { %>
                    <%var post = Model.Posts[postIndex]; %>
                    <div class="wline">
                        <strong><%=post.Lev%></strong>
                        <%if (post.Author.Id > 0){ %>
                            <%=Html.ActionLink(post.Author.Username, "Show", "User", new { uid = post.Author.Id }, null)%>
                        <%}else{ %>
                            <%=post.Author.Username %>
                        <%} %>
                        (<%=post.Author.Group.Name%>)
                        <%=post.Author.IsOnline?"<font color='red'>online</font>":"" %>
                        <br />
                        发表于:
                        <%=Html.FriendlyTime(post.PostDateTime, "yyyy-MM-dd HH:mm:ss")%>
                    </div>
                    <div id="reply_<%=post.Id %>" class="post">
                        <%if (postIndex + 1 == Model.Posts.Length) { %>
                            <div id="last_reply"></div>
                        <%} %>
                        <div class="post_main">
                            <%if(post.First>0 && Model.CurrentTopic.Invisible>0){ %>
                                <div class="mb">请注意此主题已经在回收站中</div>
                            <%}%>
                            <%if (post.Warning == 1){ %>
                                <div class="mb">提示:该帖被管理员人员屏蔽</div>
                            <%} else if (post.Warning==2){%>
                                <div class="mb">提示:该帖内容正在等待审核</div>
                            <%}else if (post.Warning == 101){ %>
                                <div class="mb">提示:该帖被管理员人员屏蔽，限有管理权限的成员或发帖用户可见</div>
                            <%}else if (post.Warning==102){ %>
                                <div class="mb">提示:该帖内容正在等待审核，限有管理权限的成员或发帖用户可见</div>
                            <%} %>
                            <%if(post.Content){ %>
                                <div id="postMessage_<%=post.Id %>" class="msg t_msgfont">
                                    <%=post.Message%>
                                </div>
                                <%if (post.ImageAttachment.Length> 0){ %>
                                    <div class="list_panel rate_list_panel">
                                        <table>
                                            <thead>
                                                <tr>
                                                    <td>图像附件</td>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <%foreach (var a in post.ImageAttachment) { %>
                                                    <tr>
                                                        <td>
                                                            <%=Html.RenderAttachment(a) %>
                                                        </td>
                                                    </tr>
                                                <%} %>
                                            </tbody>
                                        </table>
                                    </div>
                                <%} %>
                                <%if (post.FileAttachment.Length> 0){ %>
                                    <div class="list_panel rate_list_panel">
                                        <table>
                                            <thead>
                                                <tr>
                                                    <td>附件列表</td>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <%foreach (var a in post.FileAttachment) { %>
                                                    <tr>
                                                        <td>
                                                            <%=Html.RenderAttachment(a) %>
                                                        </td>
                                                    </tr>
                                                <%} %>
                                            </tbody>
                                        </table>
                                    </div>
                                <%} %>
                                <%if (post.Rate != null) { %>
                                    <div class="rate_total">
                                        已有<em><%=post.Rate.UserCount %></em>人评分
                                        ,总评分: 
                                        <%for (int i = 0; i < Model.Points.Length; i++) {%>
                                            <%if (Model.Points[i].Enabled && post.Rate.Credits[i]!=0) { %>
                                                <span><%=Model.Points[i].Name%><em><%=post.Rate.Credits[i]>=0?"+":"-" %><%=Math.Abs(post.Rate.Credits[i]).ToString("0.####")%></em></span>
                                            <%}//if%>
                                        <%}//for%>
                                        <a href="<%=Url.Action("RateList", "Topic", new { tid=Model.CurrentTopic.Id,pid=post.Id})%>" target="_blank">查看全部评分</a>
                                    </div>
                                <%} %>
                                <%if (post.UpdateUserId>0){ %>
                                    <div class="lastedit">
                                        <%=post.UpdateUsername%> 于 <%=Html.FriendlyTime(post.UpdateTime, "yyyy-MM-dd HH:mm")%> 编辑过此帖
                                    </div>
                                <%} %>
                                <%if(post.First>0 && Model.Mod!=null){ %>
                                    <div class="lastmod">
                                        本主题由 <%=Model.Mod.Username %> 于 <%=Html.FriendlyTime( Model.Mod.Time,"yyyy-MM-dd HH:mm:ss") %> <%=Model.Mod.ActionName %>
                                    </div>
                                <%} %>
                            <%} %>
                        </div>
                    </div>
                <%} %>
            <%}else{ %>
                <div class="post">
                    数据加载失败
                </div>
            <%} %>
        </form>
    </div>
    <div class="sp clearfix">
        <div class="page_panel fl">
            <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
        </div>
    </div>
    <%if (Model.QuicklyReply!=null){ %>
        <div class="box_panel sp">
            <div class="box_panel_title clearfix">
                <div class="fl">快速回复</div>
                <div class="fr"><a href="<%=Url.Action("CreateReply","Topic",new{tid=Model.CurrentTopic.Id}) %>">切换至完整回复</a></div>
            </div>
            <div class="box_panel_context quickly_create_reply">
                <form id="quickly_create_reply_form" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                    <%=Html.Hidden("tid",Model.CurrentTopic.Id) %>
                    <%=Html.Hidden("smile",1) %>
                    <%=Html.Hidden("signature", 1)%>
                    <%=Html.Hidden("AutoUrl", 1)%>
                    <div class="editor">
                        <textarea name="message" id = "textarea_message" class = "TextField" cols = "10" rows = "5"></textarea>
                        <%if (Model.QuicklyReply.VCEnabled) { %>
                            <div class="options">
                                <%= Html.TextBox("vc",string.Empty, new { size = "4", style = @"text-transform:uppercase;", @class = "vc text", tabindex = "3", value = string.Empty })%>
                                <img id="vcimg" src="<%=ResolveUrl("../../images/loading.gif")%>" alt="Loading" />
                                <a href="#" id="vcimgc" tabindex="6"><%=Html.Lang("account.login.vc_refresh")%></a>
                            </div>
                        <%} %>
                        <%if(Model.QuicklyReply.NeedCheck){ %>
		                    <div class="ginfo sp" style="display: block; text-align: center;">
			                    您所发表的回复将在通过审核后显示
		                    </div>
                        <%} %>
                        <div class="action">
                            <button type="submit" name="Ok" class="button skyblue">确认发布</button>
                            [在内容区直接按 Ctrl+Enter 可完成发布]
                        </div>
                    </div>
                </form>
            </div>
        </div>
    <%} %>
</asp:Content>
<asp:Content runat="server" ContentPlaceHolderID="FootContent">
    <%if(Setting.View.LazyLoad){ %>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.lazyload.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            //加载图像
            $("img[data-lasy]").lazyload({
                data_attribute: "lasy",
                failure_limit: 10,
                skip_invisible: false,
                effect: "fadeIn"
            });
        });
    </script>
    <%} %>
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <%if (Model.QuicklyReply!=null){ %>
    <script type="text/javascript">
        $(document).ready(function () {

            <%if (Model.QuicklyReply.VCEnabled) { %>
                function updateseccode() {
                    var rand = Math.random();
                    $('#VC').val('');
                    $('#vcimg').attr("src", "<%=Url.Action("ValidateCode", "Handler")%>?key=reply&_=" + rand);
                }
                updateseccode();
                $('#Username').focus();

                $('#vcimg').click(function () {
                    updateseccode();
                    $('#VC').focus();
                });
                $('#vcimgc').click(function () {
                    updateseccode();
                    $('#VC').focus();
                    return false;
                });
            <%} %>



                $("#quickly_create_reply_form").ajaxForm({
                    beforeSerialize: function ($form, options) {
                    },
                    beforeSubmit: function (formData, jqForm, options) {
                        easyDialog.open({ container: { content: '正在提交。。。' } });
                        return true;
                    },
                    success: function (responseText, statusText) {
                        if (!responseText.error) {
                            top.location.href = responseText.turl;
                            return;
                        }
                        easyDialog.open({ container: { header: '提示', content: responseText.description, noFn: true } });

                    },
                    error: function () {
                        easyDialog.open({ container: { header: '提示', content: "服务器通讯失败", noFn: true } });
                    },
                    complete: function () {
                    },
                    url: "<%=Url.Action("Reply_Create","Handler") %>",
                    type: 'post',
                    dataType: 'json'
                });
            });
    </script>
    <%} %>


</asp:Content>
