//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using Tunynet;
using System.Linq;
using System.Collections.Generic;
using System;
using Tunynet.Common;
using Spacebuilder.Common;

namespace Spacebuilder.Bar
{
    public class BarUrlGetter : IBarUrlGetter
    {
        /// <summary>
        /// ⻧id
        /// </summary>
        public string TenantTypeId
        {
            get { return TenantTypeIds.Instance().Bar(); }
        }

        /// <summary>
        /// ̬ӵ
        /// </summary>
        public int ActivityOwnerType
        {
            get { return ActivityOwnerTypes.Instance().BarSection(); }
        }

        /// <summary>
        /// ǷΪ˽״̬
        /// </summary>
        /// <param name="sectionId"></param>
        /// <returns></returns>
        public bool IsPrivate(long sectionId)
        {
            return false;
        }

        /// <summary>
        /// ϸʾҳ
        /// </summary>
        /// <param name="threadId">id</param>
        /// <param name="onlyLandlord">ֻ¥</param>
        /// <param name="sortBy">ʽ</param>
        /// <param name="pageIndex">ҳ</param>
        /// <returns>ϸʾҳ</returns>
        public string ThreadDetail(long threadId, bool onlyLandlord = false, SortBy_BarPost sortBy = SortBy_BarPost.DateCreated, int pageIndex = 1, long? anchorPostId = null, bool isAnchorPostList = false, long? childPostIndex = null)
        {
            return SiteUrls.Instance().ThreadDetail(threadId, onlyLandlord, sortBy, pageIndex, anchorPostId, isAnchorPostList, childPostIndex);
        }

        /// <summary>
        /// ϸʾҳ
        /// </summary>
        /// <param name="sectionId">id</param>
        /// <returns>ϸʾҳ</returns>
        public string SectionDetail(long sectionId, SortBy_BarThread? sortBy = null, bool? isEssential = null, long? categoryId = null)
        {
            return SiteUrls.Instance().SectionDetail(sectionId, sortBy, isEssential, categoryId);
        }

        /// <summary>
        /// /༭ҳ
        /// </summary>
        /// <param name="sectionId">id</param>
        /// <param name="threadId">id</param>
        /// <returns>/༭ҳ</returns>
        public string Edit(long sectionId, long? threadId)
        {
            return SiteUrls.Instance().BarThreadEdit(sectionId, threadId);
        }

        /// <summary>
        /// ༭ҳ
        /// </summary>
        /// <param name="threadId">id</param>
        /// <param name="postId">id</param>
        /// <returns>༭ҳ</returns>
        public string EditPost(long threadId, long? postId)
        {
            return SiteUrls.Instance().EditPost(threadId, postId);
        }

        /// <summary>
        /// ûҳ
        /// </summary>
        /// <param name="userId">ûid</param>
        /// <param name="sectionId">id</param>
        /// <returns>ûҳ</returns>
        public string UserThreads(long userId, long? sectionId = null)
        {
            return SiteUrls.Instance().UserThreads(userId, false);
        }

        /// <summary>
        /// ûĻҳ
        /// </summary>
        /// <param name="userId">ûid</param>
        /// <param name="sectionId">id</param>
        /// <returns>ûĻҳ</returns>
        public string UserPosts(long userId, long? sectionId = null)
        {
            return SiteUrls.Instance().UserThreads(userId, true);
        }

        /// <summary>
        /// ҳ
        /// </summary>
        /// <param name="sectionId"></param>
        /// <returns></returns>
        public string ManageThreads(long sectionId)
        {
            return SiteUrls.Instance().ManageThreadsForSection(sectionId);
        }

        /// <summary>
        /// ҳ
        /// </summary>
        /// <param name="sectionId">id</param>
        /// <returns>ҳ</returns>
        public string ManagePosts(long sectionId)
        {
            return SiteUrls.Instance().ManagePostsForSection(sectionId);
        }

        /// <summary>
        /// ҳ
        /// </summary>
        /// <param name="sectionId">id</param>
        /// <returns>ҳ</returns>
        public string ManageCategories(long sectionId)
        {
            return SiteUrls.Instance().ManageThreadCategoriesForSection(sectionId);
        }

        /// <summary>
        /// ǩµҳ
        /// </summary>
        /// <param name="tagName">ǩ</param>
        /// <param name="sectionId">id</param>
        /// <returns>ǩµҳ</returns>
        public string ListByTag(string tagName, long? sectionId = null, SortBy_BarThread? sortBy = null, bool? isEssential = null)
        {
            return SiteUrls.Instance().ListsByTag(tagName, sortBy, isEssential);
        }

        /// <summary>
        /// ̨ҳ
        /// </summary>
        /// <returns></returns>
        public string BackstageHome()
        {
            return SiteUrls.Instance().ManageThreads();
        }


        /// <summary>
        /// ֲ̨ҳ
        /// </summary>
        /// <returns></returns>
        public string _ManageSubMenu()
        {
            return "~/Applications/Bar/Views/ControlPanelBar/_ManageBarRightMenuShortcut.cshtml";
        }

        /// <summary>
        /// ûҳ
        /// </summary>
        /// <param name="userId">ûҳ</param>
        /// <param name="sectionId">id</param>
        /// <returns>ûҳ</returns>
        public string UserSpaceHome(long userId, long? sectionId = null)
        {
            return SiteUrls.Instance().UserThreads(userId);
        }

    }
}