﻿DELETE FROM `tn_AccountTypes`;
DELETE FROM `tn_ActivityItems`;
DELETE FROM `tn_Areas`;
DELETE FROM `tn_InitialNavigations`;
DELETE FROM `tn_PointCategories`;
DELETE FROM `tn_PointItems`;
DELETE FROM `tn_PresentAreas`;
DELETE FROM `tn_PrivacyItems`;
DELETE FROM `tn_RecommendItemTypes`;
DELETE FROM `tn_Roles`;
DELETE FROM `tn_Schools`;
DELETE FROM `tn_SensitiveWords`;
DELETE FROM `tn_TaskDetails`;
DELETE FROM `tn_TenantTypes`;
DELETE FROM `tn_TenantTypesInServices`;
DELETE FROM `tn_ThemeAppearances`;
DELETE FROM `tn_Themes`;
DELETE FROM `tn_UserRanks`;
DELETE FROM `tn_EmotionCategories`;
DELETE FROM `spb_IdentificationTypes`;
DELETE FROM `tn_TagsInOwners`;
DELETE FROM `tn_TagsInGroups`;
DELETE FROM `tn_Tags`;
DELETE FROM `tn_TagGroups`;
DELETE FROM `tn_AuditItems`;
DELETE FROM `tn_Settings`;
DELETE FROM `tn_ApplicationManagementOperations`;

-- 租户类型
INSERT `tn_TenantTypes` (`TenantTypeId`, `ApplicationId`, `Name`, `ClassType`)
VALUES ('000011', 0, '用户', 'Spacebuilder.Common.User,Spacebuilder.Common'),
('000061', 0, '推荐', 'Tunynet.Common.RecommendItem,Tunynet.BusinessComponents'),
('000071', 0, '友情链接', 'Spacebuilder.Common.LinkEntity,Spacebuilder.Common'),
('000072', 0, '站点公告', 'Tunynet.Common.Announcement,Tunynet.BusinessComponents');

-- 租户类型关联的服务
INSERT `tn_TenantTypesInServices` (`TenantTypeId`, `ServiceKey`)
VALUES ('000011', 'UserCategory'),
('000011', 'Tag'),
('000011', 'Blog'),
('000011', 'Recommend'),
('000071', 'SiteCategory');

-- 动态
INSERT `tn_ActivityItems` (`ItemKey`, `ApplicationId`, `ItemName`, `DisplayOrder`, `Description`, `IsOnlyOnce`, `IsUserReceived`, `IsSiteReceived`) VALUES ('FollowUser', 0, '关注用户', 1, '', 1, 1, 1);

-- 用户等级
INSERT `tn_UserRanks` (`Rank`, `PointLower`, `RankName`)
VALUES (1, 0, '1级'),
 (2, 51, '2级'),
 (3, 101, '3级'),
 (4, 201, '4级'),
 (5, 401, '5级'),
 (6, 801, '6级'),
 (7, 1501, '7级'),
 (8, 2501, '8级'),
 (9, 4501, '9级'),
 (10, 7001, '10级'),
 (11, 10501, '11级'),
 (12, 15001, '12级'),
 (13, 20001, '13级'),
 (14, 30001, '14级'),
 (15, 40001, '15级'),
 (16, 50001, '16级'),
 (17, 65001, '17级'),
 (18, 80001, '18级'),
 (19, 100001, '19级'),
 (20, 150001, '20级');

-- 身份认证
INSERT `spb_IdentificationTypes` (`Name`, `Description`, `Enabled`, `CreaterId`, `DateCreated`, `IdentificationTypeLogo`) VALUES ('个人身份认证', '会员', 1, 207677921948,  '2013-01-01','IdentificationType\\00000\\00000\\00001\\v.jpg');

-- 主题
INSERT `tn_Themes` (`Id`, `PresentAreaKey`, `ThemeKey`, `Parent`, `Version`)
 VALUES ('Channel,Default', 'Channel', 'Default', '', '1.0'),
 ('Channel,Portal', 'Channel', 'Portal', 'Default', '1.0'),
 ('ControlPanel,Default', 'ControlPanel', 'Default', '', '1.0'),
 ('GroupSpace,Deep_sea', 'GroupSpace', 'Deep_sea', 'Default', '1.0'),
 ('GroupSpace,Default', 'GroupSpace', 'Default', 'Default', '1.0'),
 ('GroupSpace,Portal', 'GroupSpace', 'Portal', 'Default', '1.0'),
 ('UserSpace,Default', 'UserSpace', 'Default', '', '1.0'),
 ('UserSpace,Portal', 'UserSpace', 'Portal', 'Default', '1.0'),
 ('UserSpace,TrendElement', 'UserSpace', 'TrendElement', 'Default', '1.0');

-- 外观
INSERT `tn_ThemeAppearances` (`Id`, `PresentAreaKey`, `ThemeKey`, `AppearanceKey`, `Name`, `PreviewImage`, `PreviewLargeImage`, `LogoFileName`, `Description`, `Tags`, `Author`, `Copyright`, `LastModified`, `Version`, `ForProductVersion`, `DateCreated`, `IsEnabled`, `DisplayOrder`, `UserCount`, `Roles`, `RequiredRank`)
 VALUES ('Channel,Default,Default', 'Channel', 'Default', 'Default', 'Default', 'Preview.png', 'Preview.png', '', '', '', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 1, 0, '', 1),
 ('Channel,Default,Dark', 'Channel', 'Default', 'Dark', 'Dark', 'Preview.png', 'Preview.png', '', '', '', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 3, 0, '', 1),
 ('Channel,Default,Light', 'Channel', 'Default', 'Light', 'Light', 'Preview.png', 'Preview.png', '', '', '', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 4, 0, '', 1),
 ('Channel,Portal,Default', 'Channel', 'Portal', 'Default', 'Portal', 'Preview.png', 'Preview.png', ' ', ' ', ' ', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 6, 0, ' ', 1),
 ('ControlPanel,Default,Default', 'ControlPanel', 'Default', 'Default', 'Default', 'Preview.png', 'Preview.png', '', '', '', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 1, 0, '', 1),
 ('GroupSpace,Deep_sea,Default', 'GroupSpace', 'Deep_sea', 'Default', 'Deep_sea', 'Preview.png', 'Preview.png', ' ', ' ', ' ', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 4, 0, ' ', 1),
 ('GroupSpace,Default,Default', 'GroupSpace', 'Default', 'Default', 'Default', 'Preview.png', 'Preview.png', ' ', ' ', ' ', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 1, 0, ' ', 1),
 ('GroupSpace,Portal,Default', 'GroupSpace', 'Portal', 'Default', 'Portal', 'Preview.png', 'Preview.png', ' ', ' ', ' ', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 5, 0, ' ', 1),
 ('UserSpace,Default,Dark', 'UserSpace', 'Default', 'Dark', 'Dark', 'Preview.png', 'Preview.png', '', '', '', '', '', now(), '', '4.0', now(), 1, 2, 0, '', 0),
 ('UserSpace,Default,Default', 'UserSpace', 'Default', 'Default', 'Default', 'Preview.png', 'Preview.png', '', '', '', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 1, 0, '', 1),
 ('UserSpace,Default,Light', 'UserSpace', 'Default', 'Light', 'Light', 'Preview.png', 'Preview.png', '', '', '', '', '', now(), '', '4.0', now(), 1, 6, 0, '', 0),
 ('UserSpace,Portal,Default', 'UserSpace', 'Portal', 'Default', 'Portal', 'Preview.png', 'Preview.png', '', '', '', '', '', now(), '', '4.0', now(), 1, 16, 0, '', 0),
 ('UserSpace,TrendElement,Crystal', 'UserSpace', 'TrendElement', 'Crystal', '梦幻水晶', 'Preview.png', 'Preview.png', '', '', '', 'admin', 'tunynet', now(), '1.0', '4.0', now(), 1, 17, 0, '', 0),
 ('UserSpace,TrendElement,Default', 'UserSpace', 'TrendElement', 'Default', '潮元素', 'Preview.png', 'Preview.png', '', '', '', '', '', now(), '', '4.0', now(), 1, 20, 0, '', 0);

-- 定时任务
INSERT `tn_TaskDetails` (`Name`, `TaskRule`, `ClassType`, `Enabled`, `RunAtRestart`, `IsRunning`, `LastStart`, `LastEnd`, `LastIsSuccess`, `NextStart`, `StartDate`, `EndDate`, `RunAtServer`)
 VALUES ('保存计数队列', '0 0/1 * * * ?', 'Tunynet.Common.ExecCountQueueTask,Tunynet.BusinessComponents', 1, 0, 0,now(), now(), 1, now(), now(), NULL, 0),
 ('更新阶段计数', '0 0/1 * * * ?', 'Tunynet.Common.UpdateStageCountTask,Tunynet.BusinessComponents', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('清除过期的提醒记录', '0 10 0 * * ?"', 'Tunynet.Common.DeleteTrashReminderRecordsTask,Tunynet.BusinessComponents', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('保存访问记录队列', '0 0/1 * * * ?', 'Tunynet.Common.ExecVisitQueueTask,Tunynet.BusinessComponents', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 0),
 ('每天清除邀请码', '0 20 0 * * ?', 'Tunynet.Common.DeleteTrashInvitationCodesTask,Tunynet.BusinessComponents', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('发送邮件', '0 0/3 * * * ?', 'Tunynet.Email.Tasks.EmailTask,Tunynet.Infrastructure', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('清理垃圾临时附件', '0 0 1 * * ?', 'Tunynet.Common.DeleteTrashTemporaryAttachmentsTask,Tunynet.BusinessComponents', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('提交全文检索索引（每2分钟的开始）', '0 0/2 * * * ?', 'Spacebuilder.Search.Tasks.LuceneIndexCommitTask,Spacebuilder.Common', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('优化全文检索索引（每天中午12点整）', '0 0 12 * * ?', 'Spacebuilder.Search.Tasks.LuceneIndexOptimizeTask,Spacebuilder.Common', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('更新关注用户索引（每分钟第30秒）', '30 0/2 * * * ?', 'Spacebuilder.Search.Tasks.FollowUserIndexTask,Spacebuilder.Common', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('更新用户在线状态（每分钟）', '0 0/1 * * * ?', 'Tunynet.Common.Tasks.OnlineUserTask,Tunynet.BusinessComponents', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 0),
 ('定期移除过期的推荐内容', '0 30 1 * * ?', 'Tunynet.Common.DeleteExpiredRecommendItemsTask,Tunynet.BusinessComponents', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('发送提醒', '0 0/10 0 * * ?', 'Tunynet.Common.SendReminderTask,Tunynet.BusinessComponents', 1, 0, 0, now(), now(), 1, now(), now(), NULL, 1),
 ('清理垃圾数据', '0 0 2 * * ?', 'Tunynet.Common.DeleteTrashDataTask,Tunynet.BusinessComponents', 1, 0, 0,  now(), now(), 1, now(), now(), NULL, 1),
 ('更新置顶时间到期的帖子', '0 40 0 * * ?', 'Spacebuilder.Bar.ExpireStickyThreadsTask,Spacebuilder.Bar', 1, 0, 0,  now(), now(), 1, now(), now(), NULL, 1),
 ('更新群组的成长值', '0 50 0 * * ?', 'Spacebuilder.Group.CalculateGrowthValuesTask,Spacebuilder.Group', 1, 0, 0,  now(), now(), 1, now(), now(), NULL, 1);

-- 站点设置
INSERT `tn_Settings` (`ClassType`, `Settings`)
 VALUES ('Spacebuilder.Bar.BarSettings, Spacebuilder.Bar', '{"ThreadSubjectMaxLength":64,"ThreadBodyMaxLength":20000,"PostBodyMaxLength":5000,"EnableRating":true,"ReputationPointsMaxValue":5,"ReputationPointsMinValue":1,"UserReputationPointsPerDay":20,"EnableUserCreateSection":false,"UserRankOfCreateSection":5,"OnlyFollowerCreateThread":true,"OnlyFollowerCreatePost":false,"SectionManagerMaxCount":5}'),
 ('Spacebuilder.Blog.BlogSettings, Spacebuilder.Blog', '{"AllowSetSiteCategory":true,"RecommendPicTypeId":"10020102","RecommendWordTypeId":"10020101","RecommendUserTypeId":"00001102","ShowSummaryInRss":false,"RssPageSize":30}'),
 ('Spacebuilder.Common.Configuration.UserProfileSettings, Spacebuilder.Common', '{"OriginalAvatarWidth":350,"OriginalAvatarHeight":350,"AvatarWidth":160,"AvatarHeight":160,"MediumAvatarWidth":100,"MediumAvatarHeight":100,"SmallAvatarWidth":50,"SmallAvatarHeight":50,"MicroAvatarWidth":25,"MicroAvatarHeight":25,"IntegrityProportions":[20,10,10,10,10,0,15,15,10],"MinIntegrity":60,"MaxPersonTag":10}'),
 ('Tunynet.Common.AreaSettings, Tunynet.BusinessComponents', '{"AreaLevel":4,"RootAreaCode":"A1560000"}'),
 ('Tunynet.Common.Configuration.AttachmentSettings, Tunynet.BusinessComponents', '{"MaxAttachmentLength":10240,"BatchUploadLimit":10,"AllowedFileExtensions":"zip,rar,xml,txt,gif,jpg,jpeg,png,doc,xls,ppt,pdf,swf,mp3,wma,mmv,rm,avi,mov,qt,docx,pptx,xlsx,pps","TemporaryAttachmentStorageDay":3,"WatermarkSettings":{"WatermarkType":1,"WatermarkLocation":8,"WatermarkText":"近乎","WatermarkImageName":"watermark.png","WatermarkMinWidth":300,"WatermarkMinHeight":300,"WatermarkOpacity":0.6,"WatermarkImageDirectory":"~/Images/","WatermarkImagePhysicalPath":""},"MaxImageWidth":1920,"MaxImageHeight":1920,"InlinedImageWidth":800,"InlinedImageHeight":600,"ImageSizeTypes":[{"ImageSizeTypeKey":"Small","Size":{"IsEmpty":false,"Width":50,"Height":50},"ResizeMethod":1},{"ImageSizeTypeKey":"Medium","Size":{"IsEmpty":false,"Width":100,"Height":100},"ResizeMethod":1},{"ImageSizeTypeKey":"Big","Size":{"IsEmpty":false,"Width":320,"Height":240},"ResizeMethod":1},{"ImageSizeTypeKey":"Bigger","Size":{"IsEmpty":false,"Width":500,"Height":500},"ResizeMethod":1}]}'),
 ('Tunynet.Common.Configuration.CommentSettings, Tunynet.BusinessComponents', '{"_showCommentCount":false,"EnableComment":true,"ShowCommentCount":false,"EnableSupportOppose":false,"ShowLowCommentOnLoad":true,"MaxCommentLength":140,"EnablePrivate":false,"AllowAnonymousComment":false,"EntryBoxAutoHeight":true,"CommentClass":""}'),
 ('Tunynet.Common.Configuration.PointSettings, Tunynet.BusinessComponents', '{"ExperiencePointsCoefficient":1,"ReputationPointsCoefficient":2,"TransactionTax":10,"UserIntegratedPointRuleText":"经验*1 + 威望*2"}'),
 ('Tunynet.Common.EmotionSettings, Tunynet.BusinessComponents', '{"EmoticonPath":"~/Images/Emotions","EnableDirectlyUrl":false,"DirectlyRootUrl":""}'),
 ('Tunynet.Common.InvitationSettings, Tunynet.BusinessComponents', '{"InvitationTypeSettingses":[{"TypeKey":"InviteFollow","IsAllow":true},{"TypeKey":"InviteJoinGroup","IsAllow":true}]}'),
 ('Tunynet.Common.InviteFriendSettings, Tunynet.BusinessComponents', '{"AllowInvitationCodeUseOnce":true,"InvitationCodeTimeLiness":7,"InvitationCodeUnitPrice":20,"DefaultUserInvitationCodeCount":10}'),
 ('Tunynet.Common.LinktimelinessSettings, Tunynet.BusinessComponents', '{"Highlinktimeliness":1,"Lowlinktimeliness":7}'),
 ('Tunynet.Common.NoticeSettings, Tunynet.BusinessComponents', '{"NoticeTypeSettingses":[{"TypeId":1,"IsAllow":true},{"TypeId":2,"IsAllow":true},{"TypeId":3,"IsAllow":true}]}'),
 ('Tunynet.Common.ReminderSettings, Tunynet.BusinessComponents', '{"ReminderModeSettingses":[{"ModeId":1,"ReminderInfoTypeSettingses":[{"ReminderInfoTypeId":3,"ReminderThreshold":10,"IsEnabled":true,"IsRepeated":true,"RepeatInterval":10080},{"ReminderInfoTypeId":1,"ReminderThreshold":10,"IsEnabled":true,"IsRepeated":true,"RepeatInterval":10080},{"ReminderInfoTypeId":2,"ReminderThreshold":10,"IsEnabled":true,"IsRepeated":false,"RepeatInterval":0}],"AllowedUserRoleNames":[]},{"ModeId":2,"ReminderInfoTypeSettingses":[{"ReminderInfoTypeId":3,"ReminderThreshold":30,"IsEnabled":true,"IsRepeated":false,"RepeatInterval":0},{"ReminderInfoTypeId":1,"ReminderThreshold":30,"IsEnabled":true,"IsRepeated":false,"RepeatInterval":0},{"ReminderInfoTypeId":2,"ReminderThreshold":30,"IsEnabled":false,"IsRepeated":false,"RepeatInterval":0}],"AllowedUserRoleNames":["SuperAdministrator","ContentAdministrator"]}],"ReminderRecordStorageDay":30}'),
 ('Tunynet.Common.TagSettings, Tunynet.BusinessComponents', '{"MaxTagsCount":5}'),
 ('Tunynet.Email.EmailSettings, Tunynet.Infrastructure', '{"BatchSendLimit":100,"AdminEmailAddress":"admin@yourdomain.com","NoReplyAddress":"noreply@yourdomain.com","NumberOfTries":6,"SendTimeInterval":10,"SmtpSettings":null}'),
 ('Tunynet.Common.Configuration.UserSettings, Tunynet.BusinessComponents', '{"RegistrationMode":1,"AccountActivation":0,"MinUserNameLength":2,"MaxUserNameLength":64,"UserNameRegex":"^[\\\\w|\\\\u4e00-\\\\u9fa5]{1,64}$","NickNameRegex":"^[\\\\w|\\\\u4e00-\\\\u9fa5]{1,64}$","MinPasswordLength":4,"MinRequiredNonAlphanumericCharacters":0,"EmailRegex":"^([a-zA-Z0-9_\\\\.-])+@([a-zA-Z0-9_-])+((\\\\.[a-zA-Z0-9_-]{2,3}){1,2})$","EnableTrackAnonymous":true,"UserOnlineTimeWindow":20,"EnableNotActivatedUsersToLogin":false,"RequiresUniqueMobile":true,"UserPasswordFormat":1,"EnableNickname":true,"DisplayNameType":1,"AutomaticModerated":false,"NoModeratedUserPoint":100,"DisallowedUserNames":"admin，administrator，super","MyHomePageAsSiteEntry":true,"SuperAdministratorRoleName":"SuperAdministrator","AnonymousRoleName":"Anonymous","EnableAudit":true,"NoAuditedRoleNames":["SuperAdministrator","ContentAdministrator"],"MinNoAuditedUserRank":8}');

--  VALUES ('Tunynet.Common.SiteSettings, Tunynet.BusinessComponents', '{"BeiAnScript":"","StatScript":"","Links":"","SiteKey":"'+cast( UUID() as Char(100)) +'","SiteName":"Spacebuilder","SiteDescription":"基于asp.net mvc 最强大SNS社区软件","SearchMetaDescription":"Spacebuilder是一款业内领先的SNS社区软件。借助预置的微博、群组、日志、相册、贴吧、问答等应用模块，可以帮助客户快速搭建以用户为中心、用户乐于贡献内容、互动无处不在、易于运营的社区网站。","SearchMetaKeyWords":"Spacebuilder,SNS社区软件","EnableMultilingual":false,"DefaultLanguage":"zh-cn","MainSiteRootUrl":"","SiteTheme":"Default","SiteThemeAppearance":"","EnableAnonymousPosting":false,"EnableAnonymousBrowse":true,"ShareToThirdIsEnabled":true,"ShareToThirdDisplayType":1,"ShareDisplayIconSize":2,"ShareToThirdBusiness":"Baidu"}'),

-- 用户角色
INSERT `tn_Roles` (`RoleName`, `FriendlyRoleName`, `IsBuiltIn`, `ConnectToUser`, `ApplicationId`, `IsPublic`, `Description`, `IsEnabled`, `RoleImage`) VALUES ('ContentAdministrator', '内容管理员', 1, 1, 0, 1, '除超级管理员专管内容以外所有其他内容', 1, 'Role\\contentadministrator.png');
INSERT `tn_Roles` (`RoleName`, `FriendlyRoleName`, `IsBuiltIn`, `ConnectToUser`, `ApplicationId`, `IsPublic`, `Description`, `IsEnabled`, `RoleImage`) VALUES ('SuperAdministrator', '超级管理员', 1, 1, 0, 1, '最大权限，可以做任何操作', 1, 'Role\\superadministrator.png');

-- 表情
INSERT `tn_EmotionCategories` (`DirectoryName`, `DisplayOrder`, `IsEnabled`) VALUES ('default', 100, 1);

-- 推荐类别
INSERT `tn_RecommendItemTypes` (`TypeId`, `TenantTypeId`, `Name`, `Description`, `HasFeaturedImage`, `DateCreated`) VALUES ('00001101', '000011', '推荐用户', '推荐用户', 0, now());

-- 隐私项
INSERT `tn_PrivacyItems` (`ItemKey`, `ItemGroupId`, `ApplicationId`, `ItemName`, `Description`, `DisplayOrder`, `PrivacyStatus`)
 VALUES ('AtUser', 3, 0, '@提到我', '设置接收哪些人@提到我的微博/评论', 35, 2),
 ('Birthday', 1, 0, '生日', '', 1, 1),
 ('Comment', 3, 0, '评论', '设置谁可以评论我的内容', 34, 2),
 ('EducationExperience', 1, 0, '教育信息', '', 6, 2),
 ('Email', 1, 0, '联系邮箱', '', 3, 1),
 ('Follow', 3, 0, '加关注', '设置谁可以关注我', 31, 2),
 ('Invitation', 3, 0, '发请求', '设置谁可以给我发请求', 32, 1),
 ('InviteFollow', 3, 0, '求关注', '设置谁可以请求我关注TA', 30, 2),
 ('Message', 3, 0, '发私信', '设置谁可以给我发私信', 33, 2),
 ('Mobile', 1, 0, '手机号码', ' ', 2, 0),
 ('Msn', 1, 0, 'MS', '', 5, 1),
 ('QQ', 1, 0, 'QQ', '', 4, 1),
 ('TrueName', 1, 0, '真实姓名', '', 8, 1),
 ('VisitUserSpace', 2, 0, '空间访问', '', 21, 2),
 ('WorkExperience', 1, 0, '职业信息', '', 7, 2);

-- 呈现区域
INSERT `tn_PresentAreas` (`PresentAreaKey`, `AllowMultipleInstances`, `EnableThemes`, `DefaultAppearanceId`, `ThemeLocation`) VALUES ('Channel', 0, 0, 'Channel,Default,Default', '~/Themes/Channel/');
INSERT `tn_PresentAreas` (`PresentAreaKey`, `AllowMultipleInstances`, `EnableThemes`, `DefaultAppearanceId`, `ThemeLocation`) VALUES ('ControlPanel', 0, 0, 'ControlPanel,Default,Default', '~/Themes/ControlPanel/');
INSERT `tn_PresentAreas` (`PresentAreaKey`, `AllowMultipleInstances`, `EnableThemes`, `DefaultAppearanceId`, `ThemeLocation`) VALUES ('GroupSpace', 1, 1, 'GroupSpace,Default,Default', '~/Themes/GroupSpace/');
INSERT `tn_PresentAreas` (`PresentAreaKey`, `AllowMultipleInstances`, `EnableThemes`, `DefaultAppearanceId`, `ThemeLocation`) VALUES ('UserSpace', 1, 1, 'UserSpace,Default,Default', '~/Themes/UserSpace/');

-- 积分项
INSERT `tn_PointItems` (`ItemKey`, `ApplicationId`, `ItemName`, `DisplayOrder`, `ExperiencePoints`, `ReputationPoints`, `TradePoints`, `TradePoints2`, `TradePoints3`, `TradePoints4`, `Description`,`NeedPointMessage`)
 VALUES ('CancelEvaluation', 0, '取消评价', 46, -2, -1, -2, 0, 0, 0, '',0),
 ('CancelFollowUser', 0, '取消关注用户', 22, -2, -1, -2, 0, 0, 0, '',0),
 ('CreateComment', 0, '发表评论', 43, 2, 1, 2, 0, 0, 0, '包括评论、回复、留言等操作',1),
 ('CreateEvaluation', 0, '发表评价', 45, 2, 1, 2, 0, 0, 0, '包括星级评价、顶踩等操作',0),
 ('DeleteComment', 0, '删除评论', 44, -2, -1, -2, 0, 0, 0, '',1),
 ('EssentialContent', 0, '内容被加精', 33, 0, 10, 20, 0, 0, 0, '',0),
 ('FirstUploadAvatar', 0, '首次上传头像', 12, 10, 0, 10, 0, 0, 0, '',1),
 ('FollowUser', 0, '关注用户', 21, 2, 1, 2, 0, 0, 0, '',0),
 ('InviteUserRegister', 0, '邀请用户注册', 13, 20, 10, 20, 0, 0, 0, '',0),
 ('RecommendContent', 0, '内容被推荐', 32, 0, 10, 20, 0, 0, 0, '',0),
 ('RecommendUser', 0, '用户被推荐', 31, 0, 25, 50, 0, 0, 0, '',0),
 ('Register', 0, '注册', 11, 10, 0, 10, 0, 0, 0, '',1),
 ('StickyContent', 0, '内容被置顶', 34, 0, 10, 20, 0, 0, 0, '内容被管理员置顶',0),
 ('FreeModeratedUser', 0, '被邀请用户解除管制时邀请人奖励', 50, 50, 5, 50, 0, 0, 0, '邀请的用户解除管制',0),
 ('DeleteInvitedUser', 0, '被邀请用户被删除时邀请人惩罚', 51, -50, -5, -50, 0, 0, 0, '',0);


-- 积分类别
INSERT `tn_PointCategories` (`CategoryKey`, `CategoryName`, `Unit`, `QuotaPerDay`, `Description`, `DisplayOrder`) VALUES ('ExperiencePoints', '经验', '个', 500, '经验描述', 11);
INSERT `tn_PointCategories` (`CategoryKey`, `CategoryName`, `Unit`, `QuotaPerDay`, `Description`, `DisplayOrder`) VALUES ('ReputationPoints', '威望', '点', 500, '威望描述', 21);
INSERT `tn_PointCategories` (`CategoryKey`, `CategoryName`, `Unit`, `QuotaPerDay`, `Description`, `DisplayOrder`) VALUES ('TradePoints', '金币', '个', 500, '金币描述', 31);

-- 快捷操作
INSERT `tn_ApplicationManagementOperations` (`OperationId`, `ApplicationId`, `AssociatedNavigationId`, `PresentAreaKey`, `OperationType`, `OperationText`, `ResourceName`, `NavigationUrl`, `UrlRouteName`, `RouteDataName`, `IconName`, `ImageUrl`, `NavigationTarget`, `DisplayOrder`, `OnlyOwnerVisible`, `IsLocked`, `IsEnabled`) VALUES (11900001, 0, 0, 'UserSpace', 1, '更新资料', '', '', 'UserSpace_Settings_EditUserProfile', NULL, 'Archive', NULL, '_self', 11900001, 1, 1, 1);
INSERT `tn_ApplicationManagementOperations` (`OperationId`, `ApplicationId`, `AssociatedNavigationId`, `PresentAreaKey`, `OperationType`, `OperationText`, `ResourceName`, `NavigationUrl`, `UrlRouteName`, `RouteDataName`, `IconName`, `ImageUrl`, `NavigationTarget`, `DisplayOrder`, `OnlyOwnerVisible`, `IsLocked`, `IsEnabled`) VALUES (11900002, 0, 0, 'UserSpace', 1, '应用管理', '', '', 'UserSpace_Settings_ManageApplications', NULL, 'App', NULL, '_self', 11900002, 1, 1, 1);
INSERT `tn_ApplicationManagementOperations` (`OperationId`, `ApplicationId`, `AssociatedNavigationId`, `PresentAreaKey`, `OperationType`, `OperationText`, `ResourceName`, `NavigationUrl`, `UrlRouteName`, `RouteDataName`, `IconName`, `ImageUrl`, `NavigationTarget`, `DisplayOrder`, `OnlyOwnerVisible`, `IsLocked`, `IsEnabled`) VALUES (11900003, 0, 0, 'UserSpace', 1, '邀请好友', '', '', 'UserSpace_InviteFriend', NULL, 'UserInvite', NULL, '_self', 11900003, 1, 1, 1);

-- 广告位
DELETE FROM `tn_AdvertisingPosition` WHERE `PositionId` like '10000000%' or `PositionId` like '11000000%';
INSERT `tn_AdvertisingPosition` (`PositionId`, `PresentAreaKey`, `Description`, `FeaturedImage`, `Width`, `Height`, `IsEnable`)
 VALUES ('10000000001', 'Channel', '频道首页头部广告位(950x100)', 'AdvertisingPosition\\00001\\00000\\00001\\10000000001.jpg', 950, 100, 1),
 ('10000000002', 'Channel', '频道首页中部广告位(710x90)', 'AdvertisingPosition\\00001\\00000\\00002\\10000000002.jpg', 710, 90, 1),
 ('10000000003', 'Channel', '频道首页右中部广告位(230x70)', 'AdvertisingPosition\\00001\\00000\\00003\\10000000003.jpg', 230, 70, 1),
 ('10000000004', 'Channel', '频道首页右下部广告位(230x260)', 'AdvertisingPosition\\00001\\00000\\00004\\10000000004.jpg', 230, 260, 1),
 ('11000000001', 'UserSpace', '用户空间左下部广告位(170x220)', 'AdvertisingPosition\\00001\\10000\\00001\\11000000001.jpg', 170, 220, 1),
 ('11000000002', 'UserSpace', '用户空间中部广告位(550x80)', 'AdvertisingPosition\\00001\\10000\\00002\\11000000002.jpg', 550, 80, 1),
 ('11000000003', 'UserSpace', '空间应用统一广告位左下部广告位(190x260)', 'AdvertisingPosition\\00001\\10000\\00003\\11000000003.jpg', 190, 260, 1);


-- 初始导航
INSERT `tn_InitialNavigations` (`NavigationId`, `ParentNavigationId`, `Depth`, `PresentAreaKey`, `ApplicationId`, `NavigationType`, `NavigationText`, `ResourceName`, `NavigationUrl`, `UrlRouteName`, `RouteDataName`, `IconName`, `ImageUrl`, `NavigationTarget`, `DisplayOrder`, `OnlyOwnerVisible`, `IsLocked`, `IsEnabled`)
 VALUES (20000000, 0, 0, 'ControlPanel', 0, 1, '主页', ' ', ' ', 'ControlPanel_Home', NULL, NULL, NULL, '_self', 20000000, 0, 1, 1),
 (20000010, 0, 0, 'ControlPanel', 0, 1, '内容', ' ', ' ', 'ControlPanel_Content_Home', NULL, NULL, NULL, '_self', 20000010, 0, 1, 1),
 (20000011, 20000010, 1, 'ControlPanel', 0, 1, '应用内容', ' ', ' ', '', NULL, NULL, NULL, '_self', 20000011, 0, 1, 1),
 (20000012, 20000010, 1, 'ControlPanel', 0, 1, '公共内容', ' ', ' ', '', NULL, NULL, NULL, '_self', 20000012, 0, 1, 1),
 (20000014, 20000012, 2, 'ControlPanel', 0, 1, '标签管理', ' ', ' ', 'ControlPanel_Content_ManageTags', NULL, NULL, NULL, '_self', 20000014, 0, 1, 1),
 (20000015, 20000012, 2, 'ControlPanel', 0, 1, '站点类别', ' ', ' ', 'ControlPanel_Content_ManageSiteCategories', NULL, NULL, NULL, '_self', 20000015, 0, 1, 1),
 (20000016, 20000012, 2, 'ControlPanel', 0, 1, '用户类别', ' ', ' ', 'ControlPanel_Content_ManageUserCategories', NULL, NULL, NULL, '_self', 20000016, 0, 1, 1),
 (20000017, 20000012, 2, 'ControlPanel', 0, 1, '评论管理', ' ', ' ', 'ControlPanel_Content_ManageComments', NULL, NULL, NULL, '_self', 20000017, 0, 1, 1),
 (20000020, 0, 0, 'ControlPanel', 0, 1, '用户', ' ', ' ', 'ControlPanel_User_ManageUser', NULL, NULL, NULL, '_self', 20000020, 0, 1, 1),
 (20000021, 20000020, 1, 'ControlPanel', 0, 1, '用户', ' ', ' ', '', NULL, NULL, NULL, '_self', 20000021, 0, 1, 1),
 (20000022, 20000021, 2, 'ControlPanel', 0, 2, '用户管理', '', '', 'ControlPanel_User_ManageUser', NULL, NULL, NULL, '_self', 20000022, 0, 1, 1),
 (20000023, 20000021, 2, 'ControlPanel', 0, 2, '角色管理', ' ', ' ', 'ControlPanel_User_ManageUserRoles', NULL, NULL, NULL, '_self', 20000023, 0, 1, 1),
 (20000024, 20000021, 2, 'ControlPanel', 0, 2, '等级管理', ' ', ' ', 'ControlPanel_User_ManageRanks', NULL, NULL, NULL, '_self', 20000024, 0, 1, 1),
 (20000025, 20000021, 2, 'ControlPanel', 0, 2, '身份认证', ' ', ' ', 'ControlPanel_User_ManageIdentifications', NULL, NULL, NULL, '_self', 20000025, 0, 1, 1),
 (20000030, 0, 0, 'ControlPanel', 0, 1, '运营', ' ', ' ', 'ControlPanel_Operation_Home', NULL, NULL, NULL, '_self', 20000030, 0, 1, 1),
 (20000031, 20000030, 1, 'ControlPanel', 0, 1, '运营', ' ', ' ', '', NULL, NULL, NULL, '_self', 20000031, 0, 1, 1),
 (20000032, 20000031, 2, 'ControlPanel', 0, 1, '内容推荐', '', '', 'ControlPanel_Operation_ManageRecommendItems', NULL, NULL, NULL, '_self', 20000032, 0, 1, 1),
 (20000033, 20000031, 2, 'ControlPanel', 0, 1, '用户推荐', '', '', 'ControlPanel_Operation_ManageRecommendUsers', NULL, NULL, NULL, '_self', 20000033, 0, 1, 1),
 (20000034, 20000031, 2, 'ControlPanel', 0, 1, '友情链接', '', '', 'ControlPanel_Operation_ManageLinks', NULL, NULL, NULL, '_self', 20000034, 0, 1, 1),
 (20000035, 20000031, 2, 'ControlPanel', 0, 1, '广告管理', '', '', 'ControlPanel_Operation_ManageAdvertisings', NULL, NULL, NULL, '_self', 20000035, 0, 0, 1),
 (20000036, 20000031, 2, 'ControlPanel', 0, 1, '公告管理', '', '', 'ControlPanel_Operation_ManageAnnouncements', NULL, NULL, NULL, '_self', 20000036, 0, 1, 1),
 (20000037, 20000031, 2, 'ControlPanel', 0, 1, '帐号绑定', '', '', 'ControlPanel_Operation_ManageAccountTypes', NULL, NULL, NULL, '_self', 20000037, 0, 1, 1),
 (20000038, 20000031, 2, 'ControlPanel', 0, 1, '积分记录', '', '', 'ControlPanel_Operation_ManagePointRecords', NULL, NULL, NULL, '_self', 20000038, 0, 1, 1),
 (20000039, 20000031, 2, 'ControlPanel', 0, 1, '搜索热词', '', '', 'ControlPanel_Operation_ManageSearchedTerms', NULL, NULL, NULL, '_self', 20000039, 0, 1, 1),
 (20000040, 20000031, 2, 'ControlPanel', 0, 1, '用户举报', '', '', 'ControlPanel_Operation_ManageImpeachReports', NULL, NULL, NULL, '_self', 20000040, 0, 1, 1),
 (20000041, 20000031, 2, 'ControlPanel', 0, 1, '操作日志', '', '', 'ControlPanel_Operation_ManageOperationLogs', NULL, NULL, NULL, '_self', 20000041, 0, 1, 1),
 (20000075, 20000031, 2, 'ControlPanel', 0, 1, '客服消息', '', '', 'ControlPanel_Operation_ManageCustomMessage', NULL, NULL, NULL, '_self', 20000075, 0, 1, 1),
 (20000076, 20000031, 2, 'ControlPanel', 0, 1, '群发消息', '', '', 'ControlPanel_Operation_MassMessages', NULL, NULL, NULL, '_self', 20000076, 0, 1, 1),
 (20000077, 20000031, 2, 'ControlPanel', 0, 1, '站点统计', '', '', 'ControlPanel_Operation_Statistics', NULL, NULL, NULL, '_blank', 20000077, 0, 1, 1),
 (20000042, 0, 0, 'ControlPanel', 0, 1, '工具', ' ', ' ', 'ControlPanel_Tool_Home', NULL, NULL, NULL, '_self', 20000042, 0, 1, 1),
 (20000043, 20000042, 1, 'ControlPanel', 0, 1, '工具', ' ', ' ', '', NULL, NULL, NULL, '_self', 20000043, 0, 1, 1),
 (20000044, 20000043, 2, 'ControlPanel', 0, 1, '重建索引', ' ', ' ', 'ControlPanel_Tool_ManageIndex', NULL, NULL, NULL, '_self', 20000044, 0, 1, 1),
 (20000045, 20000043, 2, 'ControlPanel', 0, 1, '清除缓存', '', '', 'ControlPanel_Tool_ResetCache', NULL, NULL, NULL, '_self', 20000045, 0, 1, 1),
 (20000046, 20000043, 2, 'ControlPanel', 0, 1, '任务管理', '', '', 'ControlPanel_Tool_ManageTask', NULL, NULL, NULL, '_self', 20000046, 0, 1, 1),
 (20000047, 20000043, 2, 'ControlPanel', 0, 1, '重启站点', '', '', 'ControlPanel_Tool_UnloadAppDomain', NULL, NULL, NULL, '_self', 20000047, 0, 1, 1),
 (20000048, 20000043, 2, 'ControlPanel', 0, 1, '重建缩略图', '', '', 'ControlPanel_Tool_RebuildingThumbnails', NULL, NULL, NULL, '_self', 20000047, 0, 1, 1),
 (20000050, 0, 0, 'ControlPanel', 0, 1, '设置', ' ', ' ', 'ControlPanel_Settings_Home', NULL, NULL, NULL, '_self', 20000048, 0, 1, 1),
 (20000051, 20000050, 1, 'ControlPanel', 0, 1, '规则设置', '', '', '', NULL, NULL, NULL, '_self', 20000051, 0, 1, 1),
 (20000052, 20000051, 2, 'ControlPanel', 0, 1, '积分规则', '', '', 'ControlPanel_Settings_ManagePointItems', NULL, NULL, NULL, '_self', 20000052, 0, 1, 1),
 (20000053, 20000051, 2, 'ControlPanel', 0, 1, '权限规则', '', '', 'ControlPanel_Settings_ManagePermissionItems', NULL, NULL, NULL, '_self', 20000053, 0, 1, 1),
 (20000054, 20000051, 2, 'ControlPanel', 0, 1, '隐私规则', '', '', 'ControlPanel_Settings_ManagePrivacyItems', NULL, NULL, NULL, '_self', 20000054, 0, 1, 1),
 (20000055, 20000051, 2, 'ControlPanel', 0, 1, '审核规则', '', '', 'ControlPanel_Settings_ManageAuditItems', NULL, NULL, NULL, '_self', 20000055, 0, 1, 1),
 (20000056, 20000050, 1, 'ControlPanel', 0, 1, '站点设置', '', '', '', NULL, NULL, NULL, '_self', 20000056, 0, 1, 1),
 (20000057, 20000056, 2, 'ControlPanel', 0, 1, '基础设置', '', '', 'ControlPanel_Settings_SiteSettings', NULL, NULL, NULL, '_self', 20000057, 0, 1, 1),
 (20000058, 20000056, 2, 'ControlPanel', 0, 1, '用户设置', '', '', 'ControlPanel_Settings_UserSettings', NULL, NULL, NULL, '_self', 20000058, 0, 1, 1),
 (20000059, 20000056, 2, 'ControlPanel', 0, 1, '附件设置', '', '', 'ControlPanel_Settings_AttachmentSettings', NULL, NULL, NULL, '_self', 20000059, 0, 1, 1),
 (20000060, 20000056, 2, 'ControlPanel', 0, 1, '邮件设置', '', '', 'ControlPanel_Settings_ManageEmails', NULL, NULL, NULL, '_self', 20000060, 0, 0, 1),
 (20000061, 20000056, 2, 'ControlPanel', 0, 1, '消息设置', '', '', 'ControlPanel_Settings_MessagesSettings', NULL, NULL, NULL, '_self', 20000061, 0, 1, 1),
 (20000062, 20000056, 2, 'ControlPanel', 0, 1, '提醒设置', '', '', 'ControlPanel_Settings_ReminderSettings', NULL, NULL, NULL, '_self', 20000062, 0, 1, 1),
 (20000063, 20000056, 2, 'ControlPanel', 0, 1, '暂停站点', '', '', 'ControlPanel_Settings_PauseSiteSettings', NULL, NULL, NULL, '_self', 20000063, 0, 0, 1),
 (20000064, 20000050, 1, 'ControlPanel', 0, 1, '界面相关', '', '', '', NULL, NULL, NULL, '_self', 20000064, 0, 1, 1),
 (20000065, 20000064, 2, 'ControlPanel', 0, 1, '应用管理', '', '', 'ControlPanel_Settings_ManageApplications', NULL, NULL, NULL, '_self', 20000065, 0, 1, 1),
 (20000066, 20000064, 2, 'ControlPanel', 0, 1, '导航管理', '', '', 'ControlPanel_Settings_ManageNavigations', NULL, NULL, NULL, '_self', 20000066, 0, 1, 1),
 (20000067, 20000064, 2, 'ControlPanel', 0, 1, '皮肤管理', '', '', 'ControlPanel_Settings_ManageThemes', NULL, NULL, NULL, '_self', 20000067, 0, 0, 1),
 (20000070, 20000050, 1, 'ControlPanel', 0, 1, '基础数据', '', '', '', NULL, NULL, NULL, '_self', 20000070, 0, 1, 1),
 (20000071, 20000070, 2, 'ControlPanel', 0, 1, '地区数据', '', '', 'ControlPanel_Settings_ManageAreas', NULL, NULL, NULL, '_self', 20000071, 0, 1, 1),
 (20000072, 20000070, 2, 'ControlPanel', 0, 1, '学校数据', '', '', 'ControlPanel_Settings_ManageSchools', NULL, NULL, NULL, '_self', 20000072, 0, 1, 1),
 (20000073, 20000070, 2, 'ControlPanel', 0, 1, '表情数据', '', '', 'ControlPanel_Settings_ManageEmotionCategories', NULL, NULL, NULL, '_self', 20000073, 0, 1, 1),
 (20000074, 20000070, 2, 'ControlPanel', 0, 1, '敏感词数据', '', '', 'ControlPanel_Settings_ManageSensitiveWords', NULL, NULL, NULL, '_self', 20000074, 0, 1, 1);

-- 审核项
INSERT `tn_AuditItems` (`ItemKey`, `ApplicationId`, `ItemName`, `DisplayOrder`, `Description`) VALUES ('Comment', 0, '发表评论', 0, ' ');

-- 账户类型
INSERT `tn_AccountTypes` (`AccountTypeKey`, `ThirdAccountGetterClassType`, `AppKey`, `AppSecret`, `IsSync`, `IsShareMicroBlog`, `IsFollowMicroBlog`, `OfficialMicroBlogAccount`, `IsEnabled`) VALUES ('Renren', 'Spacebuilder.Common.RenrenAccountGetter,Spacebuilder.Common', '', '', 0, 0, 0, '', 0);
INSERT `tn_AccountTypes` (`AccountTypeKey`, `ThirdAccountGetterClassType`, `AppKey`, `AppSecret`, `IsSync`, `IsShareMicroBlog`, `IsFollowMicroBlog`, `OfficialMicroBlogAccount`, `IsEnabled`) VALUES ('SinaWeibo', 'Spacebuilder.Common.SinaWeiboAccountGetter,Spacebuilder.Common', '', '', 0, 0, 0, '', 0);

-- 标签
INSERT `tn_TagsInOwners` (`Id`, `TenantTypeId`, `TagName`, `OwnerId`, `ItemCount`) VALUES (1, '000011', 'Spacebuilder', 0, 0);

INSERT `tn_TagGroups` (`GroupId`, `TenantTypeId`, `GroupName`) VALUES (1, '000011', 'Spacebuilder');

INSERT `tn_TagsInGroups` (`Id`, `GroupId`, `TagName`, `TenantTypeId`) VALUES (1, 1, 'Spacebuilder', '000011');

INSERT `tn_Tags` (`TagId`, `TenantTypeId`, `TagName`, `DisplayName`, `Description`, `FeaturedImage`, `IsFeatured`, `ItemCount`, `OwnerCount`, `AuditStatus`, `DateCreated`, `PropertyNames`, `PropertyValues`) VALUES (1, '000011', 'Spacebuilder', 'Spacebuilder', '', '', 0, 0, 1, 40, now(), NULL, NULL);

-- 地区
INSERT `tn_Areas` (`AreaCode`, `ParentCode`, `Name`, `PostCode`, `DisplayOrder`, `Depth`, `ChildCount`)
 VALUES ('11000000', 'A1560000', '北京市', '', 0, 1, 1), 
 ('11010000', '11000000', '北京市', '', 1, 2, 18),
 ('11010100', '11010000', '东城区', '', 2, 3, 0),
('11010200', '11010000', '西城区', '', 3, 3, 0),
 ('11010300', '11010000', '崇文区', '', 4, 3, 0),
 ('11010400', '11010000', '宣武区', '', 5, 3, 0),
 ('11010500', '11010000', '朝阳区', '', 6, 3, 0),
 ('11010600', '11010000', '丰台区', '', 7, 3, 0),
 ('11010700', '11010000', '石景山区', '', 8, 3, 0),
 ('11010800', '11010000', '海淀区', '', 9, 3, 0),
 ('11010900', '11010000', '门头沟区', '', 10, 3, 0),
 ('11011100', '11010000', '房山区', '', 11, 3, 0),
 ('11011200', '11010000', '通州区', '', 12, 3, 0),
 ('11011300', '11010000', '顺义区', '', 13, 3, 0),
 ('11011400', '11010000', '昌平区', '', 14, 3, 0),
 ('11011500', '11010000', '大兴区', '', 15, 3, 0),
 ('11011600', '11010000', '怀柔区', '', 16, 3, 0),
 ('11011700', '11010000', '平谷区', '', 17, 3, 0),
 ('11022800', '11010000', '密云县', '', 18, 3, 0),
 ('11022900', '11010000', '延庆县', '', 19, 3, 0),
 ('11111111', '', '波斯尼亚和黑塞哥维那', '', 20, 0, 0),
 ('12000000', 'A1560000', '天津市', '', 21, 1, 1),
 ('12010000', '12000000', '天津市', '', 22, 2, 18),
 ('12010100', '12010000', '和平区', '', 23, 3, 0),
 ('12010200', '12010000', '河东区', '', 24, 3, 0),
 ('12010300', '12010000', '河西区', '', 25, 3, 0),
 ('12010400', '12010000', '南开区', '', 26, 3, 0),
 ('12010500', '12010000', '河北区', '', 27, 3, 0),
 ('12010600', '12010000', '红桥区', '', 28, 3, 0),
 ('12010700', '12010000', '塘沽区', '', 29, 3, 0),
 ('12010800', '12010000', '汉沽区', '', 30, 3, 0),
 ('12010900', '12010000', '大港区', '', 31, 3, 0),
 ('12011000', '12010000', '东丽区', '', 32, 3, 0),
 ('12011100', '12010000', '西青区', '', 33, 3, 0),
 ('12011200', '12010000', '津南区', '', 34, 3, 0),
 ('12011300', '12010000', '北辰区', '', 35, 3, 0),
 ('12011400', '12010000', '武清区', '', 36, 3, 0),
 ('12011500', '12010000', '宝坻区', '', 37, 3, 0),
 ('12022100', '12010000', '宁河县', '', 38, 3, 0),
 ('12022300', '12010000', '静海县', '', 39, 3, 0),
 ('12022500', '12010000', '蓟县', '', 40, 3, 0),
 ('13000000', 'A1560000', '河北省', '', 41, 1, 11),
 ('13010000', '13000000', '石家庄市', '', 42, 2, 23),
 ('13010200', '13010000', '长安区', '', 43, 3, 0),
 ('13010300', '13010000', '桥东区', '', 44, 3, 0),
 ('13010400', '13010000', '桥西区', '', 45, 3, 0),
 ('13010500', '13010000', '新华区', '', 46, 3, 0),
 ('13010700', '13010000', '井陉矿区', '', 47, 3, 0),
 ('13010800', '13010000', '裕华区', '', 48, 3, 0),
 ('13012100', '13010000', '井陉县', '', 49, 3, 0),
 ('13012300', '13010000', '正定县', '', 50, 3, 0),
 ('13012400', '13010000', '栾城县', '', 51, 3, 0),
 ('13012500', '13010000', '行唐县', '', 52, 3, 0),
 ('13012600', '13010000', '灵寿县', '', 53, 3, 0),
 ('13012700', '13010000', '高邑县', '', 54, 3, 0),
 ('13012800', '13010000', '深泽县', '', 55, 3, 0),
 ('13012900', '13010000', '赞皇县', '', 56, 3, 0),
 ('13013000', '13010000', '无极县', '', 57, 3, 0),
 ('13013100', '13010000', '平山县', '', 58, 3, 0),
 ('13013200', '13010000', '元氏县', '', 59, 3, 0),
 ('13013300', '13010000', '赵县', '', 60, 3, 0),
 ('13018100', '13010000', '辛集市', '', 61, 3, 0),
 ('13018200', '13010000', '藁城市', '', 62, 3, 0),
 ('13018300', '13010000', '晋州市', '', 63, 3, 0),
 ('13018400', '13010000', '新乐市', '', 64, 3, 0),
 ('13018500', '13010000', '鹿泉市', '', 65, 3, 0),
 ('13020000', '13000000', '唐山市', '', 66, 2, 14),
 ('13020200', '13020000', '路南区', '', 67, 3, 0),
 ('13020300', '13020000', '路北区', '', 68, 3, 0),
 ('13020400', '13020000', '古冶区', '', 69, 3, 0),
 ('13020500', '13020000', '开平区', '', 70, 3, 0),
 ('13020700', '13020000', '丰南区', '', 71, 3, 0),
 ('13020800', '13020000', '丰润区', '', 72, 3, 0),
 ('13022300', '13020000', '滦县', '', 73, 3, 0),
 ('13022400', '13020000', '滦南县', '', 74, 3, 0),
 ('13022500', '13020000', '乐亭县', '', 75, 3, 0),
 ('13022700', '13020000', '迁西县', '', 76, 3, 0),
 ('13022900', '13020000', '玉田县', '', 77, 3, 0),
 ('13023000', '13020000', '唐海县', '', 78, 3, 0),
 ('13028100', '13020000', '遵化市', '', 79, 3, 0),
 ('13028300', '13020000', '迁安市', '', 80, 3, 0),
 ('13030000', '13000000', '秦皇岛市', '', 81, 2, 7),
 ('13030200', '13030000', '海港区', '', 82, 3, 0),
 ('13030300', '13030000', '山海关区', '', 83, 3, 0),
 ('13030400', '13030000', '北戴河区', '', 84, 3, 0),
 ('13032100', '13030000', '青龙满族自治县', '', 85, 3, 0),
 ('13032200', '13030000', '昌黎县', '', 86, 3, 0),
 ('13032300', '13030000', '抚宁县', '', 87, 3, 0),
 ('13032400', '13030000', '卢龙县', '', 88, 3, 0),
 ('13040000', '13000000', '邯郸市', '', 89, 2, 19),
 ('13040200', '13040000', '邯山区', '', 90, 3, 0),
 ('13040300', '13040000', '丛台区', '', 91, 3, 0),
 ('13040400', '13040000', '复兴区', '', 92, 3, 0),
 ('13040600', '13040000', '峰峰矿区', '', 93, 3, 0),
 ('13042100', '13040000', '邯郸县', '', 94, 3, 0),
 ('13042300', '13040000', '临漳县', '', 95, 3, 0),
 ('13042400', '13040000', '成安县', '', 96, 3, 0),
 ('13042500', '13040000', '大名县', '', 97, 3, 0),
 ('13042600', '13040000', '涉县', '', 98, 3, 0),
 ('13042700', '13040000', '磁县', '', 99, 3, 0),
 ('13042800', '13040000', '肥乡县', '', 100, 3, 0),
 ('13042900', '13040000', '永年县', '', 101, 3, 0),
 ('13043000', '13040000', '邱县', '', 102, 3, 0),
 ('13043100', '13040000', '鸡泽县', '', 103, 3, 0),
 ('13043200', '13040000', '广平县', '', 104, 3, 0),
 ('13043300', '13040000', '馆陶县', '', 105, 3, 0),
 ('13043400', '13040000', '魏县', '', 106, 3, 0),
 ('13043500', '13040000', '曲周县', '', 107, 3, 0),
 ('13048100', '13040000', '武安市', '', 108, 3, 0),
 ('13050000', '13000000', '邢台市', '', 109, 2, 19),
 ('13050200', '13050000', '桥东区', '', 110, 3, 0),
 ('13050300', '13050000', '桥西区', '', 111, 3, 0),
 ('13052100', '13050000', '邢台县', '', 112, 3, 0),
 ('13052200', '13050000', '临城县', '', 113, 3, 0),
 ('13052300', '13050000', '内丘县', '', 114, 3, 0),
 ('13052400', '13050000', '柏乡县', '', 115, 3, 0),
 ('13052500', '13050000', '隆尧县', '', 116, 3, 0),
 ('13052600', '13050000', '任县', '', 117, 3, 0),
 ('13052700', '13050000', '南和县', '', 118, 3, 0),
 ('13052800', '13050000', '宁晋县', '', 119, 3, 0),
 ('13052900', '13050000', '巨鹿县', '', 120, 3, 0),
 ('13053000', '13050000', '新河县', '', 121, 3, 0),
 ('13053100', '13050000', '广宗县', '', 122, 3, 0),
 ('13053200', '13050000', '平乡县', '', 123, 3, 0),
 ('13053300', '13050000', '威县', '', 124, 3, 0),
 ('13053400', '13050000', '清河县', '', 125, 3, 0),
 ('13053500', '13050000', '临西县', '', 126, 3, 0),
 ('13058100', '13050000', '南宫市', '', 127, 3, 0),
 ('13058200', '13050000', '沙河市', '', 128, 3, 0),
 ('13060000', '13000000', '保定市', '', 129, 2, 25),
 ('13060200', '13060000', '新市区', '', 130, 3, 0),
 ('13060300', '13060000', '北市区', '', 131, 3, 0),
 ('13060400', '13060000', '南市区', '', 132, 3, 0),
 ('13062100', '13060000', '满城县', '', 133, 3, 0),
 ('13062200', '13060000', '清苑县', '', 134, 3, 0),
 ('13062300', '13060000', '涞水县', '', 135, 3, 0),
 ('13062400', '13060000', '阜平县', '', 136, 3, 0),
 ('13062500', '13060000', '徐水县', '', 137, 3, 0),
 ('13062600', '13060000', '定兴县', '', 138, 3, 0),
 ('13062700', '13060000', '唐县', '', 139, 3, 0),
 ('13062800', '13060000', '高阳县', '', 140, 3, 0),
 ('13062900', '13060000', '容城县', '', 141, 3, 0),
 ('13063000', '13060000', '涞源县', '', 142, 3, 0),
 ('13063100', '13060000', '望都县', '', 143, 3, 0),
 ('13063200', '13060000', '安新县', '', 144, 3, 0),
 ('13063300', '13060000', '易县', '', 145, 3, 0),
 ('13063400', '13060000', '曲阳县', '', 146, 3, 0),
 ('13063500', '13060000', '蠡县', '', 147, 3, 0),
 ('13063600', '13060000', '顺平县', '', 148, 3, 0),
 ('13063700', '13060000', '博野县', '', 149, 3, 0),
 ('13063800', '13060000', '雄县', '', 150, 3, 0),
 ('13068100', '13060000', '涿州市', '', 151, 3, 0),
 ('13068200', '13060000', '定州市', '', 152, 3, 0),
 ('13068300', '13060000', '安国市', '', 153, 3, 0),
 ('13068400', '13060000', '高碑店市', '', 154, 3, 0),
 ('13070000', '13000000', '张家口市', '', 155, 2, 17),
 ('13070200', '13070000', '桥东区', '', 156, 3, 0),
 ('13070300', '13070000', '桥西区', '', 157, 3, 0),
 ('13070500', '13070000', '宣化区', '', 158, 3, 0),
 ('13070600', '13070000', '下花园区', '', 159, 3, 0),
 ('13072100', '13070000', '宣化县', '', 160, 3, 0),
 ('13072200', '13070000', '张北县', '', 161, 3, 0),
 ('13072300', '13070000', '康保县', '', 162, 3, 0),
 ('13072400', '13070000', '沽源县', '', 163, 3, 0),
 ('13072500', '13070000', '尚义县', '', 164, 3, 0),
 ('13072600', '13070000', '蔚县', '', 165, 3, 0),
 ('13072700', '13070000', '阳原县', '', 166, 3, 0),
 ('13072800', '13070000', '怀安县', '', 167, 3, 0),
 ('13072900', '13070000', '万全县', '', 168, 3, 0),
 ('13073000', '13070000', '怀来县', '', 169, 3, 0),
 ('13073100', '13070000', '涿鹿县', '', 170, 3, 0),
 ('13073200', '13070000', '赤城县', '', 171, 3, 0),
 ('13073300', '13070000', '崇礼县', '', 172, 3, 0),
 ('13080000', '13000000', '承德市', '', 173, 2, 11),
 ('13080200', '13080000', '双桥区', '', 174, 3, 0),
 ('13080300', '13080000', '双滦区', '', 175, 3, 0),
 ('13080400', '13080000', '鹰手营子矿区', '', 176, 3, 0),
 ('13082100', '13080000', '承德县', '', 177, 3, 0),
 ('13082200', '13080000', '兴隆县', '', 178, 3, 0),
 ('13082300', '13080000', '平泉县', '', 179, 3, 0),
 ('13082400', '13080000', '滦平县', '', 180, 3, 0),
 ('13082500', '13080000', '隆化县', '', 181, 3, 0),
 ('13082600', '13080000', '丰宁满族自治县', '', 182, 3, 0),
 ('13082700', '13080000', '宽城满族自治县', '', 183, 3, 0),
 ('13082800', '13080000', '围场满族蒙古族自治县', '', 184, 3, 0),
 ('13090000', '13000000', '沧州市', '', 185, 2, 16),
 ('13090200', '13090000', '新华区', '', 186, 3, 0),
 ('13090300', '13090000', '运河区', '', 187, 3, 0),
 ('13092100', '13090000', '沧县', '', 188, 3, 0),
 ('13092200', '13090000', '青县', '', 189, 3, 0),
 ('13092300', '13090000', '东光县', '', 190, 3, 0),
 ('13092400', '13090000', '海兴县', '', 191, 3, 0),
 ('13092500', '13090000', '盐山县', '', 192, 3, 0),
 ('13092600', '13090000', '肃宁县', '', 193, 3, 0),
 ('13092700', '13090000', '南皮县', '', 194, 3, 0),
 ('13092800', '13090000', '吴桥县', '', 195, 3, 0),
 ('13092900', '13090000', '献县', '', 196, 3, 0),
 ('13093000', '13090000', '孟村回族自治县', '', 197, 3, 0),
 ('13098100', '13090000', '泊头市', '', 198, 3, 0),
 ('13098200', '13090000', '任丘市', '', 199, 3, 0),
 ('13098300', '13090000', '黄骅市', '', 200, 3, 0),
 ('13098400', '13090000', '河间市', '', 201, 3, 0),
 ('13100000', '13000000', '廊坊市', '', 202, 2, 10),
 ('13100200', '13100000', '安次区', '', 203, 3, 0),
 ('13100300', '13100000', '广阳区', '', 204, 3, 0),
 ('13102200', '13100000', '固安县', '', 205, 3, 0),
 ('13102300', '13100000', '永清县', '', 206, 3, 0),
 ('13102400', '13100000', '香河县', '', 207, 3, 0),
 ('13102500', '13100000', '大城县', '', 208, 3, 0),
 ('13102600', '13100000', '文安县', '', 209, 3, 0),
 ('13102800', '13100000', '大厂回族自治县', '', 210, 3, 0),
 ('13108100', '13100000', '霸州市', '', 211, 3, 0),
 ('13108200', '13100000', '三河市', '', 212, 3, 0),
 ('13110000', '13000000', '衡水市', '', 213, 2, 11),
 ('13110200', '13110000', '桃城区', '', 214, 3, 0),
 ('13112100', '13110000', '枣强县', '', 215, 3, 0),
 ('13112200', '13110000', '武邑县', '', 216, 3, 0),
 ('13112300', '13110000', '武强县', '', 217, 3, 0),
 ('13112400', '13110000', '饶阳县', '', 218, 3, 0),
 ('13112500', '13110000', '安平县', '', 219, 3, 0),
 ('13112600', '13110000', '故城县', '', 220, 3, 0),
 ('13112700', '13110000', '景县', '', 221, 3, 0),
 ('13112800', '13110000', '阜城县', '', 222, 3, 0),
 ('13118100', '13110000', '冀州市', '', 223, 3, 0),
 ('13118200', '13110000', '深州市', '', 224, 3, 0),
 ('14000000', 'A1560000', '山西省', '', 225, 1, 11),
 ('14010000', '14000000', '太原市', '', 226, 2, 10),
 ('14010500', '14010000', '小店区', '', 227, 3, 0),
 ('14010600', '14010000', '迎泽区', '', 228, 3, 0),
 ('14010700', '14010000', '杏花岭区', '', 229, 3, 0),
 ('14010800', '14010000', '尖草坪区', '', 230, 3, 0),
 ('14010900', '14010000', '万柏林区', '', 231, 3, 0),
 ('14011000', '14010000', '晋源区', '', 232, 3, 0),
 ('14012100', '14010000', '清徐县', '', 233, 3, 0),
 ('14012200', '14010000', '阳曲县', '', 234, 3, 0),
 ('14012300', '14010000', '娄烦县', '', 235, 3, 0),
 ('14018100', '14010000', '古交市', '', 236, 3, 0),
 ('14020000', '14000000', '大同市', '', 237, 2, 11),
 ('14020200', '14020000', '城区', '', 238, 3, 0),
 ('14020300', '14020000', '矿区', '', 239, 3, 0),
 ('14021100', '14020000', '南郊区', '', 240, 3, 0),
 ('14021200', '14020000', '新荣区', '', 241, 3, 0),
 ('14022100', '14020000', '阳高县', '', 242, 3, 0),
 ('14022200', '14020000', '天镇县', '', 243, 3, 0),
 ('14022300', '14020000', '广灵县', '', 244, 3, 0),
 ('14022400', '14020000', '灵丘县', '', 245, 3, 0),
 ('14022500', '14020000', '浑源县', '', 246, 3, 0),
 ('14022600', '14020000', '左云县', '', 247, 3, 0),
 ('14022700', '14020000', '大同县', '', 248, 3, 0),
 ('14030000', '14000000', '阳泉市', '', 249, 2, 5),
 ('14030200', '14030000', '城区', '', 250, 3, 0),
 ('14030300', '14030000', '矿区', '', 251, 3, 0),
 ('14031100', '14030000', '郊区', '', 252, 3, 0),
 ('14032100', '14030000', '平定县', '', 253, 3, 0),
 ('14032200', '14030000', '盂县', '', 254, 3, 0),
 ('14040000', '14000000', '长治市', '', 255, 2, 13),
 ('14040200', '14040000', '城区', '', 256, 3, 0),
 ('14041100', '14040000', '郊区', '', 257, 3, 0),
 ('14042100', '14040000', '长治县', '', 258, 3, 0),
 ('14042300', '14040000', '襄垣县', '', 259, 3, 0),
 ('14042400', '14040000', '屯留县', '', 260, 3, 0),
 ('14042500', '14040000', '平顺县', '', 261, 3, 0),
 ('14042600', '14040000', '黎城县', '', 262, 3, 0),
 ('14042700', '14040000', '壶关县', '', 263, 3, 0),
 ('14042800', '14040000', '长子县', '', 264, 3, 0),
 ('14042900', '14040000', '武乡县', '', 265, 3, 0),
 ('14043000', '14040000', '沁县', '', 266, 3, 0),
 ('14043100', '14040000', '沁源县', '', 267, 3, 0),
 ('14048100', '14040000', '潞城市', '', 268, 3, 0),
 ('14050000', '14000000', '晋城市', '', 269, 2, 6),
 ('14050200', '14050000', '城区', '', 270, 3, 0),
 ('14052100', '14050000', '沁水县', '', 271, 3, 0),
 ('14052200', '14050000', '阳城县', '', 272, 3, 0),
 ('14052400', '14050000', '陵川县', '', 273, 3, 0),
 ('14052500', '14050000', '泽州县', '', 274, 3, 0),
 ('14058100', '14050000', '高平市', '', 275, 3, 0),
 ('14060000', '14000000', '朔州市', '', 276, 2, 6),
 ('14060200', '14060000', '朔城区', '', 277, 3, 0),
 ('14060300', '14060000', '平鲁区', '', 278, 3, 0),
 ('14062100', '14060000', '山阴县', '', 279, 3, 0),
 ('14062200', '14060000', '应县', '', 280, 3, 0),
 ('14062300', '14060000', '右玉县', '', 281, 3, 0),
 ('14062400', '14060000', '怀仁县', '', 282, 3, 0),
 ('14070000', '14000000', '晋中市', '', 283, 2, 11),
 ('14070200', '14070000', '榆次区', '', 284, 3, 0),
 ('14072100', '14070000', '榆社县', '', 285, 3, 0),
 ('14072200', '14070000', '左权县', '', 286, 3, 0),
 ('14072300', '14070000', '和顺县', '', 287, 3, 0),
 ('14072400', '14070000', '昔阳县', '', 288, 3, 0),
 ('14072500', '14070000', '寿阳县', '', 289, 3, 0),
 ('14072600', '14070000', '太谷县', '', 290, 3, 0),
 ('14072700', '14070000', '祁县', '', 291, 3, 0),
 ('14072800', '14070000', '平遥县', '', 292, 3, 0),
 ('14072900', '14070000', '灵石县', '', 293, 3, 0),
 ('14078100', '14070000', '介休市', '', 294, 3, 0),
 ('14080000', '14000000', '运城市', '', 295, 2, 13),
 ('14080200', '14080000', '盐湖区', '', 296, 3, 0),
 ('14082100', '14080000', '临猗县', '', 297, 3, 0),
 ('14082200', '14080000', '万荣县', '', 298, 3, 0),
 ('14082300', '14080000', '闻喜县', '', 299, 3, 0),
 ('14082400', '14080000', '稷山县', '', 300, 3, 0),
 ('14082500', '14080000', '新绛县', '', 301, 3, 0),
 ('14082600', '14080000', '绛县', '', 302, 3, 0),
 ('14082700', '14080000', '垣曲县', '', 303, 3, 0),
 ('14082800', '14080000', '夏县', '', 304, 3, 0),
 ('14082900', '14080000', '平陆县', '', 305, 3, 0),
 ('14083000', '14080000', '芮城县', '', 306, 3, 0),
 ('14088100', '14080000', '永济市', '', 307, 3, 0),
 ('14088200', '14080000', '河津市', '', 308, 3, 0),
 ('14090000', '14000000', '忻州市', '', 309, 2, 14),
 ('14090200', '14090000', '忻府区', '', 310, 3, 0),
 ('14092100', '14090000', '定襄县', '', 311, 3, 0),
 ('14092200', '14090000', '五台县', '', 312, 3, 0),
 ('14092300', '14090000', '代县', '', 313, 3, 0),
 ('14092400', '14090000', '繁峙县', '', 314, 3, 0),
 ('14092500', '14090000', '宁武县', '', 315, 3, 0),
 ('14092600', '14090000', '静乐县', '', 316, 3, 0),
 ('14092700', '14090000', '神池县', '', 317, 3, 0),
 ('14092800', '14090000', '五寨县', '', 318, 3, 0),
 ('14092900', '14090000', '岢岚县', '', 319, 3, 0),
 ('14093000', '14090000', '河曲县', '', 320, 3, 0),
 ('14093100', '14090000', '保德县', '', 321, 3, 0),
 ('14093200', '14090000', '偏关县', '', 322, 3, 0),
 ('14098100', '14090000', '原平市', '', 323, 3, 0),
 ('14100000', '14000000', '临汾市', '', 324, 2, 17),
 ('14100200', '14100000', '尧都区', '', 325, 3, 0),
 ('14102100', '14100000', '曲沃县', '', 326, 3, 0),
 ('14102200', '14100000', '翼城县', '', 327, 3, 0),
 ('14102300', '14100000', '襄汾县', '', 328, 3, 0),
 ('14102400', '14100000', '洪洞县', '', 329, 3, 0),
 ('14102500', '14100000', '古县', '', 330, 3, 0),
 ('14102600', '14100000', '安泽县', '', 331, 3, 0),
 ('14102700', '14100000', '浮山县', '', 332, 3, 0),
 ('14102800', '14100000', '吉县', '', 333, 3, 0),
 ('14102900', '14100000', '乡宁县', '', 334, 3, 0),
 ('14103000', '14100000', '大宁县', '', 335, 3, 0),
 ('14103100', '14100000', '隰县', '', 336, 3, 0),
 ('14103200', '14100000', '永和县', '', 337, 3, 0),
 ('14103300', '14100000', '蒲县', '', 338, 3, 0),
 ('14103400', '14100000', '汾西县', '', 339, 3, 0),
 ('14108100', '14100000', '侯马市', '', 340, 3, 0),
 ('14108200', '14100000', '霍州市', '', 341, 3, 0),
 ('14110000', '14000000', '吕梁市', '', 342, 2, 13),
 ('14110200', '14110000', '离石区', '', 343, 3, 0),
 ('14112100', '14110000', '文水县', '', 344, 3, 0),
 ('14112200', '14110000', '交城县', '', 345, 3, 0),
 ('14112300', '14110000', '兴县', '', 346, 3, 0),
 ('14112400', '14110000', '临县', '', 347, 3, 0),
 ('14112500', '14110000', '柳林县', '', 348, 3, 0),
 ('14112600', '14110000', '石楼县', '', 349, 3, 0),
 ('14112700', '14110000', '岚县', '', 350, 3, 0),
 ('14112800', '14110000', '方山县', '', 351, 3, 0),
 ('14112900', '14110000', '中阳县', '', 352, 3, 0),
 ('14113000', '14110000', '交口县', '', 353, 3, 0),
 ('14118100', '14110000', '孝义市', '', 354, 3, 0),
 ('14118200', '14110000', '汾阳市', '', 355, 3, 0),
 ('15000000', 'A1560000', '内蒙古自治区', '', 356, 1, 12),
 ('15010000', '15000000', '呼和浩特市', '', 357, 2, 9),
 ('15010200', '15010000', '新城区', '', 358, 3, 0),
 ('15010300', '15010000', '回民区', '', 359, 3, 0),
 ('15010400', '15010000', '玉泉区', '', 360, 3, 0),
 ('15010500', '15010000', '赛罕区', '', 361, 3, 0),
 ('15012100', '15010000', '土默特左旗', '', 362, 3, 0),
 ('15012200', '15010000', '托克托县', '', 363, 3, 0),
 ('15012300', '15010000', '和林格尔县', '', 364, 3, 0),
 ('15012400', '15010000', '清水河县', '', 365, 3, 0),
 ('15012500', '15010000', '武川县', '', 366, 3, 0),
 ('15020000', '15000000', '包头市', '', 367, 2, 9),
 ('15020200', '15020000', '东河区', '', 368, 3, 0),
 ('15020300', '15020000', '昆都仑区', '', 369, 3, 0),
 ('15020400', '15020000', '青山区', '', 370, 3, 0),
 ('15020500', '15020000', '石拐区', '', 371, 3, 0),
 ('15020600', '15020000', '白云矿区', '', 372, 3, 0),
 ('15020700', '15020000', '九原区', '', 373, 3, 0),
 ('15022100', '15020000', '土默特右旗', '', 374, 3, 0),
 ('15022200', '15020000', '固阳县', '', 375, 3, 0),
 ('15022300', '15020000', '达尔罕茂明安联合旗', '', 376, 3, 0),
 ('15030000', '15000000', '乌海市', '', 377, 2, 3),
 ('15030200', '15030000', '海勃湾区', '', 378, 3, 0),
 ('15030300', '15030000', '海南区', '', 379, 3, 0),
 ('15030400', '15030000', '乌达区', '', 380, 3, 0),
 ('15040000', '15000000', '赤峰市', '', 381, 2, 12),
 ('15040200', '15040000', '红山区', '', 382, 3, 0),
 ('15040300', '15040000', '元宝山区', '', 383, 3, 0),
 ('15040400', '15040000', '松山区', '', 384, 3, 0),
 ('15042100', '15040000', '阿鲁科尔沁旗', '', 385, 3, 0),
 ('15042200', '15040000', '巴林左旗', '', 386, 3, 0),
 ('15042300', '15040000', '巴林右旗', '', 387, 3, 0),
 ('15042400', '15040000', '林西县', '', 388, 3, 0),
 ('15042500', '15040000', '克什克腾旗', '', 389, 3, 0),
 ('15042600', '15040000', '翁牛特旗', '', 390, 3, 0),
 ('15042800', '15040000', '喀喇沁旗', '', 391, 3, 0),
 ('15042900', '15040000', '宁城县', '', 392, 3, 0),
 ('15043000', '15040000', '敖汉旗', '', 393, 3, 0),
 ('15050000', '15000000', '通辽市', '', 394, 2, 8),
 ('15050200', '15050000', '科尔沁区', '', 395, 3, 0),
 ('15052100', '15050000', '科尔沁左翼中旗', '', 396, 3, 0),
 ('15052200', '15050000', '科尔沁左翼后旗', '', 397, 3, 0),
 ('15052300', '15050000', '开鲁县', '', 398, 3, 0),
 ('15052400', '15050000', '库伦旗', '', 399, 3, 0),
 ('15052500', '15050000', '奈曼旗', '', 400, 3, 0),
 ('15052600', '15050000', '扎鲁特旗', '', 401, 3, 0),
 ('15058100', '15050000', '霍林郭勒市', '', 402, 3, 0),
 ('15060000', '15000000', '鄂尔多斯市', '', 403, 2, 8),
 ('15060200', '15060000', '东胜区', '', 404, 3, 0),
 ('15062100', '15060000', '达拉特旗', '', 405, 3, 0),
 ('15062200', '15060000', '准格尔旗', '', 406, 3, 0),
 ('15062300', '15060000', '鄂托克前旗', '', 407, 3, 0),
 ('15062400', '15060000', '鄂托克旗', '', 408, 3, 0),
 ('15062500', '15060000', '杭锦旗', '', 409, 3, 0),
 ('15062600', '15060000', '乌审旗', '', 410, 3, 0),
 ('15062700', '15060000', '伊金霍洛旗', '', 411, 3, 0),
 ('15070000', '15000000', '呼伦贝尔市', '', 412, 2, 13),
 ('15070200', '15070000', '海拉尔区', '', 413, 3, 0),
 ('15072100', '15070000', '阿荣旗', '', 414, 3, 0),
 ('15072200', '15070000', '莫力达瓦达斡尔族自治旗', '', 415, 3, 0),
 ('15072300', '15070000', '鄂伦春自治旗', '', 416, 3, 0),
 ('15072400', '15070000', '鄂温克族自治旗', '', 417, 3, 0),
 ('15072500', '15070000', '陈巴尔虎旗', '', 418, 3, 0),
 ('15072600', '15070000', '新巴尔虎左旗', '', 419, 3, 0),
 ('15072700', '15070000', '新巴尔虎右旗', '', 420, 3, 0),
 ('15078100', '15070000', '满洲里市', '', 421, 3, 0),
 ('15078200', '15070000', '牙克石市', '', 422, 3, 0),
 ('15078300', '15070000', '扎兰屯市', '', 423, 3, 0),
 ('15078400', '15070000', '额尔古纳市', '', 424, 3, 0),
 ('15078500', '15070000', '根河市', '', 425, 3, 0),
 ('15080000', '15000000', '巴彦淖尔市', '', 426, 2, 7),
 ('15080200', '15080000', '临河区', '', 427, 3, 0),
 ('15082100', '15080000', '五原县', '', 428, 3, 0),
 ('15082200', '15080000', '磴口县', '', 429, 3, 0),
 ('15082300', '15080000', '乌拉特前旗', '', 430, 3, 0),
 ('15082400', '15080000', '乌拉特中旗', '', 431, 3, 0),
 ('15082500', '15080000', '乌拉特后旗', '', 432, 3, 0),
 ('15082600', '15080000', '杭锦后旗', '', 433, 3, 0),
 ('15090000', '15000000', '乌兰察布市', '', 434, 2, 11),
 ('15090200', '15090000', '集宁区', '', 435, 3, 0),
 ('15092100', '15090000', '卓资县', '', 436, 3, 0),
 ('15092200', '15090000', '化德县', '', 437, 3, 0),
 ('15092300', '15090000', '商都县', '', 438, 3, 0),
 ('15092400', '15090000', '兴和县', '', 439, 3, 0),
 ('15092500', '15090000', '凉城县', '', 440, 3, 0),
 ('15092600', '15090000', '察哈尔右翼前旗', '', 441, 3, 0),
 ('15092700', '15090000', '察哈尔右翼中旗', '', 442, 3, 0),
 ('15092800', '15090000', '察哈尔右翼后旗', '', 443, 3, 0),
 ('15092900', '15090000', '四子王旗', '', 444, 3, 0),
 ('15098100', '15090000', '丰镇市', '', 445, 3, 0),
 ('15220000', '15000000', '兴安盟', '', 446, 2, 6),
 ('15220100', '15220000', '乌兰浩特市', '', 447, 3, 0),
 ('15220200', '15220000', '阿尔山市', '', 448, 3, 0),
 ('15222100', '15220000', '科尔沁右翼前旗', '', 449, 3, 0),
 ('15222200', '15220000', '科尔沁右翼中旗', '', 450, 3, 0),
 ('15222300', '15220000', '扎赉特旗', '', 451, 3, 0),
 ('15222400', '15220000', '突泉县', '', 452, 3, 0),
 ('15250000', '15000000', '锡林郭勒盟', '', 453, 2, 12),
 ('15250100', '15250000', '二连浩特市', '', 454, 3, 0),
 ('15250200', '15250000', '锡林浩特市', '', 455, 3, 0),
 ('15252200', '15250000', '阿巴嘎旗', '', 456, 3, 0),
 ('15252300', '15250000', '苏尼特左旗', '', 457, 3, 0),
 ('15252400', '15250000', '苏尼特右旗', '', 458, 3, 0),
 ('15252500', '15250000', '东乌珠穆沁旗', '', 459, 3, 0),
 ('15252600', '15250000', '西乌珠穆沁旗', '', 460, 3, 0),
 ('15252700', '15250000', '太仆寺旗', '', 461, 3, 0),
 ('15252800', '15250000', '镶黄旗', '', 462, 3, 0),
 ('15252900', '15250000', '正镶白旗', '', 463, 3, 0),
 ('15253000', '15250000', '正蓝旗', '', 464, 3, 0),
 ('15253100', '15250000', '多伦县', '', 465, 3, 0),
 ('15290000', '15000000', '阿拉善盟', '', 466, 2, 3),
 ('15292100', '15290000', '阿拉善左旗', '', 467, 3, 0),
 ('15292200', '15290000', '阿拉善右旗', '', 468, 3, 0),
 ('15292300', '15290000', '额济纳旗', '', 469, 3, 0);
 INSERT `tn_Areas` (`AreaCode`, `ParentCode`, `Name`, `PostCode`, `DisplayOrder`, `Depth`, `ChildCount`)
 VALUES
 ('21000000', 'A1560000', '辽宁省', '', 470, 1, 14),
 ('21010000', '21000000', '沈阳市', '', 471, 2, 13),
 ('21010200', '21010000', '和平区', '', 472, 3, 0),
 ('21010300', '21010000', '沈河区', '', 473, 3, 0),
 ('21010400', '21010000', '大东区', '', 474, 3, 0),
 ('21010500', '21010000', '皇姑区', '', 475, 3, 0),
 ('21010600', '21010000', '铁西区', '', 476, 3, 0),
 ('21011100', '21010000', '苏家屯区', '', 477, 3, 0),
 ('21011200', '21010000', '东陵区', '', 478, 3, 0),
 ('21011300', '21010000', '新城子区', '', 479, 3, 0),
 ('21011400', '21010000', '于洪区', '', 480, 3, 0),
 ('21012200', '21010000', '辽中县', '', 481, 3, 0),
 ('21012300', '21010000', '康平县', '', 482, 3, 0),
 ('21012400', '21010000', '法库县', '', 483, 3, 0),
 ('21018100', '21010000', '新民市', '', 484, 3, 0),
 ('21020000', '21000000', '大连市', '', 485, 2, 10),
 ('21020200', '21020000', '中山区', '', 486, 3, 0),
 ('21020300', '21020000', '西岗区', '', 487, 3, 0),
 ('21020400', '21020000', '沙河口区', '', 488, 3, 0),
 ('21021100', '21020000', '甘井子区', '', 489, 3, 0),
 ('21021200', '21020000', '旅顺口区', '', 490, 3, 0),
 ('21021300', '21020000', '金州区', '', 491, 3, 0),
 ('21022400', '21020000', '长海县', '', 492, 3, 0),
 ('21028100', '21020000', '瓦房店市', '', 493, 3, 0),
 ('21028200', '21020000', '普兰店市', '', 494, 3, 0),
 ('21028300', '21020000', '庄河市', '', 495, 3, 0),
 ('21030000', '21000000', '鞍山市', '', 496, 2, 7),
 ('21030200', '21030000', '铁东区', '', 497, 3, 0),
 ('21030300', '21030000', '铁西区', '', 498, 3, 0),
 ('21030400', '21030000', '立山区', '', 499, 3, 0),
 ('21031100', '21030000', '千山区', '', 500, 3, 0),
 ('21032100', '21030000', '台安县', '', 501, 3, 0),
 ('21032300', '21030000', '岫岩满族自治县', '', 502, 3, 0),
 ('21038100', '21030000', '海城市', '', 503, 3, 0),
 ('21040000', '21000000', '抚顺市', '', 504, 2, 7),
 ('21040200', '21040000', '新抚区', '', 505, 3, 0),
 ('21040300', '21040000', '东洲区', '', 506, 3, 0),
 ('21040400', '21040000', '望花区', '', 507, 3, 0),
 ('21041100', '21040000', '顺城区', '', 508, 3, 0),
 ('21042100', '21040000', '抚顺县', '', 509, 3, 0),
 ('21042200', '21040000', '新宾满族自治县', '', 510, 3, 0),
 ('21042300', '21040000', '清原满族自治县', '', 511, 3, 0),
 ('21050000', '21000000', '本溪市', '', 512, 2, 6),
 ('21050200', '21050000', '平山区', '', 513, 3, 0),
 ('21050300', '21050000', '溪湖区', '', 514, 3, 0),
 ('21050400', '21050000', '明山区', '', 515, 3, 0),
 ('21050500', '21050000', '南芬区', '', 516, 3, 0),
 ('21052100', '21050000', '本溪满族自治县', '', 517, 3, 0),
 ('21052200', '21050000', '桓仁满族自治县', '', 518, 3, 0),
 ('21060000', '21000000', '丹东市', '', 519, 2, 6),
 ('21060200', '21060000', '元宝区', '', 520, 3, 0),
 ('21060300', '21060000', '振兴区', '', 521, 3, 0),
 ('21060400', '21060000', '振安区', '', 522, 3, 0),
 ('21062400', '21060000', '宽甸满族自治县', '', 523, 3, 0),
 ('21068100', '21060000', '东港市', '', 524, 3, 0),
 ('21068200', '21060000', '凤城市', '', 525, 3, 0),
 ('21070000', '21000000', '锦州市', '', 526, 2, 7),
 ('21070200', '21070000', '古塔区', '', 527, 3, 0),
 ('21070300', '21070000', '凌河区', '', 528, 3, 0),
 ('21071100', '21070000', '太和区', '', 529, 3, 0),
 ('21072600', '21070000', '黑山县', '', 530, 3, 0),
 ('21072700', '21070000', '义县', '', 531, 3, 0),
 ('21078100', '21070000', '凌海市', '', 532, 3, 0),
 ('21078200', '21070000', '北宁市', '', 533, 3, 0),
 ('21080000', '21000000', '营口市', '', 534, 2, 6),
 ('21080200', '21080000', '站前区', '', 535, 3, 0),
 ('21080300', '21080000', '西市区', '', 536, 3, 0),
 ('21080400', '21080000', '鲅鱼圈区', '', 537, 3, 0),
 ('21081100', '21080000', '老边区', '', 538, 3, 0),
 ('21088100', '21080000', '盖州市', '', 539, 3, 0),
 ('21088200', '21080000', '大石桥市', '', 540, 3, 0),
 ('21090000', '21000000', '阜新市', '', 541, 2, 7),
 ('21090200', '21090000', '海州区', '', 542, 3, 0),
 ('21090300', '21090000', '新邱区', '', 543, 3, 0),
 ('21090400', '21090000', '太平区', '', 544, 3, 0),
 ('21090500', '21090000', '清河门区', '', 545, 3, 0),
 ('21091100', '21090000', '细河区', '', 546, 3, 0),
 ('21092100', '21090000', '阜新蒙古族自治县', '', 547, 3, 0),
 ('21092200', '21090000', '彰武县', '', 548, 3, 0),
 ('21100000', '21000000', '辽阳市', '', 549, 2, 7),
 ('21100200', '21100000', '白塔区', '', 550, 3, 0),
 ('21100300', '21100000', '文圣区', '', 551, 3, 0),
 ('21100400', '21100000', '宏伟区', '', 552, 3, 0),
 ('21100500', '21100000', '弓长岭区', '', 553, 3, 0),
 ('21101100', '21100000', '太子河区', '', 554, 3, 0),
 ('21102100', '21100000', '辽阳县', '', 555, 3, 0),
 ('21108100', '21100000', '灯塔市', '', 556, 3, 0),
 ('21110000', '21000000', '盘锦市', '', 557, 2, 4),
 ('21110200', '21110000', '双台子区', '', 558, 3, 0),
 ('21110300', '21110000', '兴隆台区', '', 559, 3, 0),
 ('21112100', '21110000', '大洼县', '', 560, 3, 0),
 ('21112200', '21110000', '盘山县', '', 561, 3, 0),
 ('21120000', '21000000', '铁岭市', '', 562, 2, 7),
 ('21120200', '21120000', '银州区', '', 563, 3, 0),
 ('21120400', '21120000', '清河区', '', 564, 3, 0),
 ('21122100', '21120000', '铁岭县', '', 565, 3, 0),
 ('21122300', '21120000', '西丰县', '', 566, 3, 0),
 ('21122400', '21120000', '昌图县', '', 567, 3, 0),
 ('21128100', '21120000', '调兵山市', '', 568, 3, 0),
 ('21128200', '21120000', '开原市', '', 569, 3, 0),
 ('21130000', '21000000', '朝阳市', '', 570, 2, 7),
 ('21130200', '21130000', '双塔区', '', 571, 3, 0),
 ('21130300', '21130000', '龙城区', '', 572, 3, 0),
 ('21132100', '21130000', '朝阳县', '', 573, 3, 0),
 ('21132200', '21130000', '建平县', '', 574, 3, 0),
 ('21132400', '21130000', '喀喇沁左翼蒙古族自治县', '', 575, 3, 0),
 ('21138100', '21130000', '北票市', '', 576, 3, 0),
 ('21138200', '21130000', '凌源市', '', 577, 3, 0),
 ('21140000', '21000000', '葫芦岛市', '', 578, 2, 6),
 ('21140200', '21140000', '连山区', '', 579, 3, 0),
 ('21140300', '21140000', '龙港区', '', 580, 3, 0),
 ('21140400', '21140000', '南票区', '', 581, 3, 0),
 ('21142100', '21140000', '绥中县', '', 582, 3, 0),
 ('21142200', '21140000', '建昌县', '', 583, 3, 0),
 ('21148100', '21140000', '兴城市', '', 584, 3, 0),
 ('22000000', 'A1560000', '吉林省', '', 585, 1, 9),
 ('22010000', '22000000', '长春市', '', 586, 2, 10),
 ('22010200', '22010000', '南关区', '', 587, 3, 0),
 ('22010300', '22010000', '宽城区', '', 588, 3, 0),
 ('22010400', '22010000', '朝阳区', '', 589, 3, 0),
 ('22010500', '22010000', '二道区', '', 590, 3, 0),
 ('22010600', '22010000', '绿园区', '', 591, 3, 0),
 ('22011200', '22010000', '双阳区', '', 592, 3, 0),
 ('22012200', '22010000', '农安县', '', 593, 3, 0),
 ('22018100', '22010000', '九台市', '', 594, 3, 0),
 ('22018200', '22010000', '榆树市', '', 595, 3, 0),
 ('22018300', '22010000', '德惠市', '', 596, 3, 0),
 ('22020000', '22000000', '吉林市', '', 597, 2, 9),
 ('22020200', '22020000', '昌邑区', '', 598, 3, 0),
 ('22020300', '22020000', '龙潭区', '', 599, 3, 0),
 ('22020400', '22020000', '船营区', '', 600, 3, 0),
 ('22021100', '22020000', '丰满区', '', 601, 3, 0),
 ('22022100', '22020000', '永吉县', '', 602, 3, 0),
 ('22028100', '22020000', '蛟河市', '', 603, 3, 0),
 ('22028200', '22020000', '桦甸市', '', 604, 3, 0),
 ('22028300', '22020000', '舒兰市', '', 605, 3, 0),
 ('22028400', '22020000', '磐石市', '', 606, 3, 0),
 ('22030000', '22000000', '四平市', '', 607, 2, 6),
 ('22030200', '22030000', '铁西区', '', 608, 3, 0),
 ('22030300', '22030000', '铁东区', '', 609, 3, 0),
 ('22032200', '22030000', '梨树县', '', 610, 3, 0),
 ('22032300', '22030000', '伊通满族自治县', '', 611, 3, 0),
 ('22038100', '22030000', '公主岭市', '', 612, 3, 0),
 ('22038200', '22030000', '双辽市', '', 613, 3, 0),
 ('22040000', '22000000', '辽源市', '', 614, 2, 4),
 ('22040200', '22040000', '龙山区', '', 615, 3, 0),
 ('22040300', '22040000', '西安区', '', 616, 3, 0),
 ('22042100', '22040000', '东丰县', '', 617, 3, 0),
 ('22042200', '22040000', '东辽县', '', 618, 3, 0),
 ('22050000', '22000000', '通化市', '', 619, 2, 7),
 ('22050200', '22050000', '东昌区', '', 620, 3, 0),
 ('22050300', '22050000', '二道江区', '', 621, 3, 0),
 ('22052100', '22050000', '通化县', '', 622, 3, 0),
 ('22052300', '22050000', '辉南县', '', 623, 3, 0),
 ('22052400', '22050000', '柳河县', '', 624, 3, 0),
 ('22058100', '22050000', '梅河口市', '', 625, 3, 0),
 ('22058200', '22050000', '集安市', '', 626, 3, 0),
 ('22060000', '22000000', '白山市', '', 627, 2, 6),
 ('22060200', '22060000', '八道江区', '', 628, 3, 0),
 ('22062100', '22060000', '抚松县', '', 629, 3, 0),
 ('22062200', '22060000', '靖宇县', '', 630, 3, 0),
 ('22062300', '22060000', '长白朝鲜族自治县', '', 631, 3, 0),
 ('22062500', '22060000', '江源县', '', 632, 3, 0),
 ('22068100', '22060000', '临江市', '', 633, 3, 0),
 ('22070000', '22000000', '松原市', '', 634, 2, 5),
 ('22070200', '22070000', '宁江区', '', 635, 3, 0),
 ('22072100', '22070000', '前郭尔罗斯蒙古族自治县', '', 636, 3, 0),
 ('22072200', '22070000', '长岭县', '', 637, 3, 0),
 ('22072300', '22070000', '乾安县', '', 638, 3, 0),
 ('22072400', '22070000', '扶余县', '', 639, 3, 0),
 ('22080000', '22000000', '白城市', '', 640, 2, 5),
 ('22080200', '22080000', '洮北区', '', 641, 3, 0),
 ('22082100', '22080000', '镇赉县', '', 642, 3, 0),
 ('22082200', '22080000', '通榆县', '', 643, 3, 0),
 ('22088100', '22080000', '洮南市', '', 644, 3, 0),
 ('22088200', '22080000', '大安市', '', 645, 3, 0),
 ('22240000', '22000000', '延边朝鲜族自治州', '', 646, 2, 8),
 ('22240100', '22240000', '延吉市', '', 647, 3, 0),
 ('22240200', '22240000', '图们市', '', 648, 3, 0),
 ('22240300', '22240000', '敦化市', '', 649, 3, 0),
 ('22240400', '22240000', '珲春市', '', 650, 3, 0),
 ('22240500', '22240000', '龙井市', '', 651, 3, 0),
 ('22240600', '22240000', '和龙市', '', 652, 3, 0),
 ('22242400', '22240000', '汪清县', '', 653, 3, 0),
 ('22242600', '22240000', '安图县', '', 654, 3, 0),
 ('23000000', 'A1560000', '黑龙江省', '', 655, 1, 13),
 ('23010000', '23000000', '哈尔滨市', '', 656, 2, 19),
 ('23010200', '23010000', '道里区', '', 657, 3, 0),
 ('23010300', '23010000', '南岗区', '', 658, 3, 0),
 ('23010400', '23010000', '道外区', '', 659, 3, 0),
 ('23010600', '23010000', '香坊区', '', 660, 3, 0),
 ('23010700', '23010000', '动力区', '', 661, 3, 0),
 ('23010800', '23010000', '平房区', '', 662, 3, 0),
 ('23010900', '23010000', '松北区', '', 663, 3, 0),
 ('23011100', '23010000', '呼兰区', '', 664, 3, 0),
 ('23012300', '23010000', '依兰县', '', 665, 3, 0),
 ('23012400', '23010000', '方正县', '', 666, 3, 0),
 ('23012500', '23010000', '宾县', '', 667, 3, 0),
 ('23012600', '23010000', '巴彦县', '', 668, 3, 0),
 ('23012700', '23010000', '木兰县', '', 669, 3, 0),
 ('23012800', '23010000', '通河县', '', 670, 3, 0),
 ('23012900', '23010000', '延寿县', '', 671, 3, 0),
 ('23018100', '23010000', '阿城市', '', 672, 3, 0),
 ('23018200', '23010000', '双城市', '', 673, 3, 0),
 ('23018300', '23010000', '尚志市', '', 674, 3, 0),
 ('23018400', '23010000', '五常市', '', 675, 3, 0),
 ('23020000', '23000000', '齐齐哈尔市', '', 676, 2, 16),
 ('23020200', '23020000', '龙沙区', '', 677, 3, 0),
 ('23020300', '23020000', '建华区', '', 678, 3, 0),
 ('23020400', '23020000', '铁锋区', '', 679, 3, 0),
 ('23020500', '23020000', '昂昂溪区', '', 680, 3, 0),
 ('23020600', '23020000', '富拉尔基区', '', 681, 3, 0),
 ('23020700', '23020000', '碾子山区', '', 682, 3, 0),
 ('23020800', '23020000', '梅里斯达斡尔族区', '', 683, 3, 0),
 ('23022100', '23020000', '龙江县', '', 684, 3, 0),
 ('23022300', '23020000', '依安县', '', 685, 3, 0),
 ('23022400', '23020000', '泰来县', '', 686, 3, 0),
 ('23022500', '23020000', '甘南县', '', 687, 3, 0),
 ('23022700', '23020000', '富裕县', '', 688, 3, 0),
 ('23022900', '23020000', '克山县', '', 689, 3, 0),
 ('23023000', '23020000', '克东县', '', 690, 3, 0),
 ('23023100', '23020000', '拜泉县', '', 691, 3, 0),
 ('23028100', '23020000', '讷河市', '', 692, 3, 0),
 ('23030000', '23000000', '鸡西市', '', 693, 2, 9),
 ('23030200', '23030000', '鸡冠区', '', 694, 3, 0),
 ('23030300', '23030000', '恒山区', '', 695, 3, 0),
 ('23030400', '23030000', '滴道区', '', 696, 3, 0),
 ('23030500', '23030000', '梨树区', '', 697, 3, 0),
 ('23030600', '23030000', '城子河区', '', 698, 3, 0),
 ('23030700', '23030000', '麻山区', '', 699, 3, 0),
 ('23032100', '23030000', '鸡东县', '', 700, 3, 0),
 ('23038100', '23030000', '虎林市', '', 701, 3, 0),
 ('23038200', '23030000', '密山市', '', 702, 3, 0),
 ('23040000', '23000000', '鹤岗市', '', 703, 2, 8),
 ('23040200', '23040000', '向阳区', '', 704, 3, 0),
 ('23040300', '23040000', '工农区', '', 705, 3, 0),
 ('23040400', '23040000', '南山区', '', 706, 3, 0),
 ('23040500', '23040000', '兴安区', '', 707, 3, 0),
 ('23040600', '23040000', '东山区', '', 708, 3, 0),
 ('23040700', '23040000', '兴山区', '', 709, 3, 0),
 ('23042100', '23040000', '萝北县', '', 710, 3, 0),
 ('23042200', '23040000', '绥滨县', '', 711, 3, 0),
 ('23050000', '23000000', '双鸭山市', '', 712, 2, 8),
 ('23050200', '23050000', '尖山区', '', 713, 3, 0),
 ('23050300', '23050000', '岭东区', '', 714, 3, 0),
 ('23050500', '23050000', '四方台区', '', 715, 3, 0),
 ('23050600', '23050000', '宝山区', '', 716, 3, 0),
 ('23052100', '23050000', '集贤县', '', 717, 3, 0),
 ('23052200', '23050000', '友谊县', '', 718, 3, 0),
 ('23052300', '23050000', '宝清县', '', 719, 3, 0),
 ('23052400', '23050000', '饶河县', '', 720, 3, 0),
 ('23060000', '23000000', '大庆市', '', 721, 2, 9),
 ('23060200', '23060000', '萨尔图区', '', 722, 3, 0),
 ('23060300', '23060000', '龙凤区', '', 723, 3, 0),
 ('23060400', '23060000', '让胡路区', '', 724, 3, 0),
 ('23060500', '23060000', '红岗区', '', 725, 3, 0),
 ('23060600', '23060000', '大同区', '', 726, 3, 0),
 ('23062100', '23060000', '肇州县', '', 727, 3, 0),
 ('23062200', '23060000', '肇源县', '', 728, 3, 0),
 ('23062300', '23060000', '林甸县', '', 729, 3, 0),
 ('23062400', '23060000', '杜尔伯特蒙古族自治县', '', 730, 3, 0),
 ('23070000', '23000000', '伊春市', '', 731, 2, 17),
 ('23070200', '23070000', '伊春区', '', 732, 3, 0),
 ('23070300', '23070000', '南岔区', '', 733, 3, 0),
 ('23070400', '23070000', '友好区', '', 734, 3, 0),
 ('23070500', '23070000', '西林区', '', 735, 3, 0),
 ('23070600', '23070000', '翠峦区', '', 736, 3, 0),
 ('23070700', '23070000', '新青区', '', 737, 3, 0),
 ('23070800', '23070000', '美溪区', '', 738, 3, 0),
 ('23070900', '23070000', '金山屯区', '', 739, 3, 0),
 ('23071000', '23070000', '五营区', '', 740, 3, 0),
 ('23071100', '23070000', '乌马河区', '', 741, 3, 0),
 ('23071200', '23070000', '汤旺河区', '', 742, 3, 0),
 ('23071300', '23070000', '带岭区', '', 743, 3, 0),
 ('23071400', '23070000', '乌伊岭区', '', 744, 3, 0),
 ('23071500', '23070000', '红星区', '', 745, 3, 0),
 ('23071600', '23070000', '上甘岭区', '', 746, 3, 0),
 ('23072200', '23070000', '嘉荫县', '', 747, 3, 0),
 ('23078100', '23070000', '铁力市', '', 748, 3, 0),
 ('23080000', '23000000', '佳木斯市', '', 749, 2, 11),
 ('23080200', '23080000', '永红区', '', 750, 3, 0),
 ('23080300', '23080000', '向阳区', '', 751, 3, 0),
 ('23080400', '23080000', '前进区', '', 752, 3, 0),
 ('23080500', '23080000', '东风区', '', 753, 3, 0),
 ('23081100', '23080000', '郊区', '', 754, 3, 0),
 ('23082200', '23080000', '桦南县', '', 755, 3, 0),
 ('23082600', '23080000', '桦川县', '', 756, 3, 0),
 ('23082800', '23080000', '汤原县', '', 757, 3, 0),
 ('23083300', '23080000', '抚远县', '', 758, 3, 0),
 ('23088100', '23080000', '同江市', '', 759, 3, 0),
 ('23088200', '23080000', '富锦市', '', 760, 3, 0),
 ('23090000', '23000000', '七台河市', '', 761, 2, 4),
 ('23090200', '23090000', '新兴区', '', 762, 3, 0),
 ('23090300', '23090000', '桃山区', '', 763, 3, 0),
 ('23090400', '23090000', '茄子河区', '', 764, 3, 0),
 ('23092100', '23090000', '勃利县', '', 765, 3, 0),
 ('23100000', '23000000', '牡丹江市', '', 766, 2, 10),
 ('23100200', '23100000', '东安区', '', 767, 3, 0),
 ('23100300', '23100000', '阳明区', '', 768, 3, 0),
 ('23100400', '23100000', '爱民区', '', 769, 3, 0),
 ('23100500', '23100000', '西安区', '', 770, 3, 0),
 ('23102400', '23100000', '东宁县', '', 771, 3, 0),
 ('23102500', '23100000', '林口县', '', 772, 3, 0),
 ('23108100', '23100000', '绥芬河市', '', 773, 3, 0),
 ('23108300', '23100000', '海林市', '', 774, 3, 0),
 ('23108400', '23100000', '宁安市', '', 775, 3, 0),
 ('23108500', '23100000', '穆棱市', '', 776, 3, 0),
 ('23110000', '23000000', '黑河市', '', 777, 2, 6),
 ('23110200', '23110000', '爱辉区', '', 778, 3, 0),
 ('23112100', '23110000', '嫩江县', '', 779, 3, 0),
 ('23112300', '23110000', '逊克县', '', 780, 3, 0),
 ('23112400', '23110000', '孙吴县', '', 781, 3, 0),
 ('23118100', '23110000', '北安市', '', 782, 3, 0),
 ('23118200', '23110000', '五大连池市', '', 783, 3, 0),
 ('23120000', '23000000', '绥化市', '', 784, 2, 10),
 ('23120200', '23120000', '北林区', '', 785, 3, 0),
 ('23122100', '23120000', '望奎县', '', 786, 3, 0),
 ('23122200', '23120000', '兰西县', '', 787, 3, 0),
 ('23122300', '23120000', '青冈县', '', 788, 3, 0),
 ('23122400', '23120000', '庆安县', '', 789, 3, 0),
 ('23122500', '23120000', '明水县', '', 790, 3, 0),
 ('23122600', '23120000', '绥棱县', '', 791, 3, 0),
 ('23128100', '23120000', '安达市', '', 792, 3, 0),
 ('23128200', '23120000', '肇东市', '', 793, 3, 0),
 ('23128300', '23120000', '海伦市', '', 794, 3, 0),
 ('23270000', '23000000', '大兴安岭地区', '', 795, 2, 3),
 ('23272100', '23270000', '呼玛县', '', 796, 3, 0),
 ('23272200', '23270000', '塔河县', '', 797, 3, 0),
 ('23272300', '23270000', '漠河县', '', 798, 3, 0);
  INSERT `tn_Areas` (`AreaCode`, `ParentCode`, `Name`, `PostCode`, `DisplayOrder`, `Depth`, `ChildCount`)
 VALUES
 ('31000000', 'A1560000', '上海市', '', 799, 1, 1),
 ('31010000', '31000000', '上海市', '', 800, 2, 19),
 ('31010100', '31010000', '黄浦区', '', 801, 3, 0),
 ('31010300', '31010000', '卢湾区', '', 802, 3, 0),
 ('31010400', '31010000', '徐汇区', '', 803, 3, 0),
 ('31010500', '31010000', '长宁区', '', 804, 3, 0),
 ('31010600', '31010000', '静安区', '', 805, 3, 0),
 ('31010700', '31010000', '普陀区', '', 806, 3, 0),
 ('31010800', '31010000', '闸北区', '', 807, 3, 0),
 ('31010900', '31010000', '虹口区', '', 808, 3, 0),
 ('31011000', '31010000', '杨浦区', '', 809, 3, 0),
 ('31011200', '31010000', '闵行区', '', 810, 3, 0),
 ('31011300', '31010000', '宝山区', '', 811, 3, 0),
 ('31011400', '31010000', '嘉定区', '', 812, 3, 0),
 ('31011500', '31010000', '浦东新区', '', 813, 3, 0),
 ('31011600', '31010000', '金山区', '', 814, 3, 0),
 ('31011700', '31010000', '松江区', '', 815, 3, 0),
 ('31011800', '31010000', '青浦区', '', 816, 3, 0),
 ('31011900', '31010000', '南汇区', '', 817, 3, 0),
 ('31012000', '31010000', '奉贤区', '', 818, 3, 0),
 ('31023000', '31010000', '崇明县', '', 819, 3, 0),
 ('32000000', 'A1560000', '江苏省', '', 820, 1, 13),
 ('32010000', '32000000', '南京市', '', 821, 2, 13),
 ('32010200', '32010000', '玄武区', '', 822, 3, 0),
 ('32010300', '32010000', '白下区', '', 823, 3, 0),
 ('32010400', '32010000', '秦淮区', '', 824, 3, 0),
 ('32010500', '32010000', '建邺区', '', 825, 3, 0),
 ('32010600', '32010000', '鼓楼区', '', 826, 3, 0),
 ('32010700', '32010000', '下关区', '', 827, 3, 0),
 ('32011100', '32010000', '浦口区', '', 828, 3, 0),
 ('32011300', '32010000', '栖霞区', '', 829, 3, 0),
 ('32011400', '32010000', '雨花台区', '', 830, 3, 0),
 ('32011500', '32010000', '江宁区', '', 831, 3, 0),
 ('32011600', '32010000', '六合区', '', 832, 3, 0),
 ('32012400', '32010000', '溧水县', '', 833, 3, 0),
 ('32012500', '32010000', '高淳县', '', 834, 3, 0),
 ('32020000', '32000000', '无锡市', '', 835, 2, 8),
 ('32020200', '32020000', '崇安区', '', 836, 3, 0),
 ('32020300', '32020000', '南长区', '', 837, 3, 0),
 ('32020400', '32020000', '北塘区', '', 838, 3, 0),
 ('32020500', '32020000', '锡山区', '', 839, 3, 0),
 ('32020600', '32020000', '惠山区', '', 840, 3, 0),
 ('32021100', '32020000', '滨湖区', '', 841, 3, 0),
 ('32028100', '32020000', '江阴市', '', 842, 3, 0),
 ('32028200', '32020000', '宜兴市', '', 843, 3, 0),
 ('32030000', '32000000', '徐州市', '', 844, 2, 11),
 ('32030200', '32030000', '鼓楼区', '', 845, 3, 0),
 ('32030300', '32030000', '云龙区', '', 846, 3, 0),
 ('32030400', '32030000', '九里区', '', 847, 3, 0),
 ('32030500', '32030000', '贾汪区', '', 848, 3, 0),
 ('32031100', '32030000', '泉山区', '', 849, 3, 0),
 ('32032100', '32030000', '丰县', '', 850, 3, 0),
 ('32032200', '32030000', '沛县', '', 851, 3, 0),
 ('32032300', '32030000', '铜山县', '', 852, 3, 0),
 ('32032400', '32030000', '睢宁县', '', 853, 3, 0),
 ('32038100', '32030000', '新沂市', '', 854, 3, 0),
 ('32038200', '32030000', '邳州市', '', 855, 3, 0),
 ('32040000', '32000000', '常州市', '', 856, 2, 7),
 ('32040200', '32040000', '天宁区', '', 857, 3, 0),
 ('32040400', '32040000', '钟楼区', '', 858, 3, 0),
 ('32040500', '32040000', '戚墅堰区', '', 859, 3, 0),
 ('32041100', '32040000', '新北区', '', 860, 3, 0),
 ('32041200', '32040000', '武进区', '', 861, 3, 0),
 ('32048100', '32040000', '溧阳市', '', 862, 3, 0),
 ('32048200', '32040000', '金坛市', '', 863, 3, 0),
 ('32050000', '32000000', '苏州市', '', 864, 2, 11),
 ('32050200', '32050000', '沧浪区', '', 865, 3, 0),
 ('32050300', '32050000', '平江区', '', 866, 3, 0),
 ('32050400', '32050000', '金阊区', '', 867, 3, 0),
 ('32050500', '32050000', '虎丘区', '', 868, 3, 0),
 ('32050600', '32050000', '吴中区', '', 869, 3, 0),
 ('32050700', '32050000', '相城区', '', 870, 3, 0),
 ('32058100', '32050000', '常熟市', '', 871, 3, 0),
 ('32058200', '32050000', '张家港市', '', 872, 3, 0),
 ('32058300', '32050000', '昆山市', '', 873, 3, 0),
 ('32058400', '32050000', '吴江市', '', 874, 3, 0),
 ('32058500', '32050000', '太仓市', '', 875, 3, 0),
 ('32060000', '32000000', '南通市', '', 876, 2, 8),
 ('32060200', '32060000', '崇川区', '', 877, 3, 0),
 ('32061100', '32060000', '港闸区', '', 878, 3, 0),
 ('32062100', '32060000', '海安县', '', 879, 3, 0),
 ('32062300', '32060000', '如东县', '', 880, 3, 0),
 ('32068100', '32060000', '启东市', '', 881, 3, 0),
 ('32068200', '32060000', '如皋市', '', 882, 3, 0),
 ('32068300', '32060000', '通州市', '', 883, 3, 0),
 ('32068400', '32060000', '海门市', '', 884, 3, 0),
 ('32070000', '32000000', '连云港市', '', 885, 2, 7),
 ('32070300', '32070000', '连云区', '', 886, 3, 0),
 ('32070500', '32070000', '新浦区', '', 887, 3, 0),
 ('32070600', '32070000', '海州区', '', 888, 3, 0),
 ('32072100', '32070000', '赣榆县', '', 889, 3, 0),
 ('32072200', '32070000', '东海县', '', 890, 3, 0),
 ('32072300', '32070000', '灌云县', '', 891, 3, 0),
 ('32072400', '32070000', '灌南县', '', 892, 3, 0),
 ('32080000', '32000000', '淮安市', '', 893, 2, 8),
 ('32080200', '32080000', '清河区', '', 894, 3, 0),
 ('32080300', '32080000', '楚州区', '', 895, 3, 0),
 ('32080400', '32080000', '淮阴区', '', 896, 3, 0),
 ('32081100', '32080000', '清浦区', '', 897, 3, 0),
 ('32082600', '32080000', '涟水县', '', 898, 3, 0),
 ('32082900', '32080000', '洪泽县', '', 899, 3, 0),
 ('32083000', '32080000', '盱眙县', '', 900, 3, 0),
 ('32083100', '32080000', '金湖县', '', 901, 3, 0),
 ('32090000', '32000000', '盐城市', '', 902, 2, 9),
 ('32090200', '32090000', '亭湖区', '', 903, 3, 0),
 ('32090300', '32090000', '盐都区', '', 904, 3, 0),
 ('32092100', '32090000', '响水县', '', 905, 3, 0),
 ('32092200', '32090000', '滨海县', '', 906, 3, 0),
 ('32092300', '32090000', '阜宁县', '', 907, 3, 0),
 ('32092400', '32090000', '射阳县', '', 908, 3, 0),
 ('32092500', '32090000', '建湖县', '', 909, 3, 0),
 ('32098100', '32090000', '东台市', '', 910, 3, 0),
 ('32098200', '32090000', '大丰市', '', 911, 3, 0),
 ('32100000', '32000000', '扬州市', '', 912, 2, 7),
 ('32100200', '32100000', '广陵区', '', 913, 3, 0),
 ('32100300', '32100000', '邗江区', '', 914, 3, 0),
 ('32101100', '32100000', '维扬区', '', 915, 3, 0),
 ('32102300', '32100000', '宝应县', '', 916, 3, 0),
 ('32108100', '32100000', '仪征市', '', 917, 3, 0),
 ('32108400', '32100000', '高邮市', '', 918, 3, 0),
 ('32108800', '32100000', '江都市', '', 919, 3, 0),
 ('32110000', '32000000', '镇江市', '', 920, 2, 6),
 ('32110200', '32110000', '京口区', '', 921, 3, 0),
 ('32111100', '32110000', '润州区', '', 922, 3, 0),
 ('32111200', '32110000', '丹徒区', '', 923, 3, 0),
 ('32118100', '32110000', '丹阳市', '', 924, 3, 0),
 ('32118200', '32110000', '扬中市', '', 925, 3, 0),
 ('32118300', '32110000', '句容市', '', 926, 3, 0),
 ('32120000', '32000000', '泰州市', '', 927, 2, 6),
 ('32120200', '32120000', '海陵区', '', 928, 3, 0),
 ('32120300', '32120000', '高港区', '', 929, 3, 0),
 ('32128100', '32120000', '兴化市', '', 930, 3, 0),
 ('32128200', '32120000', '靖江市', '', 931, 3, 0),
 ('32128300', '32120000', '泰兴市', '', 932, 3, 0),
 ('32128400', '32120000', '姜堰市', '', 933, 3, 0),
 ('32130000', '32000000', '宿迁市', '', 934, 2, 5),
 ('32130200', '32130000', '宿城区', '', 935, 3, 0),
 ('32131100', '32130000', '宿豫区', '', 936, 3, 0),
 ('32132200', '32130000', '沭阳县', '', 937, 3, 0),
 ('32132300', '32130000', '泗阳县', '', 938, 3, 0),
 ('32132400', '32130000', '泗洪县', '', 939, 3, 0),
 ('33000000', 'A1560000', '浙江省', '', 940, 1, 11),
 ('33010000', '33000000', '杭州市', '', 941, 2, 13),
 ('33010200', '33010000', '上城区', '', 942, 3, 0),
 ('33010300', '33010000', '下城区', '', 943, 3, 0),
 ('33010400', '33010000', '江干区', '', 944, 3, 0),
 ('33010500', '33010000', '拱墅区', '', 945, 3, 0),
 ('33010600', '33010000', '西湖区', '', 946, 3, 0),
 ('33010800', '33010000', '滨江区', '', 947, 3, 0),
 ('33010900', '33010000', '萧山区', '', 948, 3, 0),
 ('33011000', '33010000', '余杭区', '', 949, 3, 0),
 ('33012200', '33010000', '桐庐县', '', 950, 3, 0),
 ('33012700', '33010000', '淳安县', '', 951, 3, 0),
 ('33018200', '33010000', '建德市', '', 952, 3, 0),
 ('33018300', '33010000', '富阳市', '', 953, 3, 0),
 ('33018500', '33010000', '临安市', '', 954, 3, 0),
 ('33020000', '33000000', '宁波市', '', 955, 2, 11),
 ('33020300', '33020000', '海曙区', '', 956, 3, 0),
 ('33020400', '33020000', '江东区', '', 957, 3, 0),
 ('33020500', '33020000', '江北区', '', 958, 3, 0),
 ('33020600', '33020000', '北仑区', '', 959, 3, 0),
 ('33021100', '33020000', '镇海区', '', 960, 3, 0),
 ('33021200', '33020000', '鄞州区', '', 961, 3, 0),
 ('33022500', '33020000', '象山县', '', 962, 3, 0),
 ('33022600', '33020000', '宁海县', '', 963, 3, 0),
 ('33028100', '33020000', '余姚市', '', 964, 3, 0),
 ('33028200', '33020000', '慈溪市', '', 965, 3, 0),
 ('33028300', '33020000', '奉化市', '', 966, 3, 0),
 ('33030000', '33000000', '温州市', '', 967, 2, 11),
 ('33030200', '33030000', '鹿城区', '', 968, 3, 0),
 ('33030300', '33030000', '龙湾区', '', 969, 3, 0),
 ('33030400', '33030000', '瓯海区', '', 970, 3, 0),
 ('33032200', '33030000', '洞头县', '', 971, 3, 0),
 ('33032400', '33030000', '永嘉县', '', 972, 3, 0),
 ('33032600', '33030000', '平阳县', '', 973, 3, 0),
 ('33032700', '33030000', '苍南县', '', 974, 3, 0),
 ('33032800', '33030000', '文成县', '', 975, 3, 0),
 ('33032900', '33030000', '泰顺县', '', 976, 3, 0),
 ('33038100', '33030000', '瑞安市', '', 977, 3, 0),
 ('33038200', '33030000', '乐清市', '', 978, 3, 0),
 ('33040000', '33000000', '嘉兴市', '', 979, 2, 7),
 ('33040200', '33040000', '南湖区', '', 980, 3, 0),
 ('33041100', '33040000', '秀洲区', '', 981, 3, 0),
 ('33042100', '33040000', '嘉善县', '', 982, 3, 0),
 ('33042400', '33040000', '海盐县', '', 983, 3, 0),
 ('33048100', '33040000', '海宁市', '', 984, 3, 0),
 ('33048200', '33040000', '平湖市', '', 985, 3, 0),
 ('33048300', '33040000', '桐乡市', '', 986, 3, 0),
 ('33050000', '33000000', '湖州市', '', 987, 2, 5),
 ('33050200', '33050000', '吴兴区', '', 988, 3, 0),
 ('33050300', '33050000', '南浔区', '', 989, 3, 0),
 ('33052100', '33050000', '德清县', '', 990, 3, 0),
 ('33052200', '33050000', '长兴县', '', 991, 3, 0),
 ('33052300', '33050000', '安吉县', '', 992, 3, 0),
 ('33060000', '33000000', '绍兴市', '', 993, 2, 6),
 ('33060200', '33060000', '越城区', '', 994, 3, 0),
 ('33062100', '33060000', '绍兴县', '', 995, 3, 0),
 ('33062400', '33060000', '新昌县', '', 996, 3, 0),
 ('33068100', '33060000', '诸暨市', '', 997, 3, 0),
 ('33068200', '33060000', '上虞市', '', 998, 3, 0),
 ('33068300', '33060000', '嵊州市', '', 999, 3, 0),
 ('33070000', '33000000', '金华市', '', 1000, 2, 9),
 ('33070200', '33070000', '婺城区', '', 1001, 3, 0),
 ('33070300', '33070000', '金东区', '', 1002, 3, 0),
 ('33072300', '33070000', '武义县', '', 1003, 3, 0),
 ('33072600', '33070000', '浦江县', '', 1004, 3, 0),
 ('33072700', '33070000', '磐安县', '', 1005, 3, 0),
 ('33078100', '33070000', '兰溪市', '', 1006, 3, 0),
 ('33078200', '33070000', '义乌市', '', 1007, 3, 0),
 ('33078300', '33070000', '东阳市', '', 1008, 3, 0),
 ('33078400', '33070000', '永康市', '', 1009, 3, 0),
 ('33080000', '33000000', '衢州市', '', 1010, 2, 6),
 ('33080200', '33080000', '柯城区', '', 1011, 3, 0),
 ('33080300', '33080000', '衢江区', '', 1012, 3, 0),
 ('33082200', '33080000', '常山县', '', 1013, 3, 0),
 ('33082400', '33080000', '开化县', '', 1014, 3, 0),
 ('33082500', '33080000', '龙游县', '', 1015, 3, 0),
 ('33088100', '33080000', '江山市', '', 1016, 3, 0),
 ('33090000', '33000000', '舟山市', '', 1017, 2, 4),
 ('33090200', '33090000', '定海区', '', 1018, 3, 0),
 ('33090300', '33090000', '普陀区', '', 1019, 3, 0),
 ('33092100', '33090000', '岱山县', '', 1020, 3, 0),
 ('33092200', '33090000', '嵊泗县', '', 1021, 3, 0),
 ('33100000', '33000000', '台州市', '', 1022, 2, 9),
 ('33100200', '33100000', '椒江区', '', 1023, 3, 0),
 ('33100300', '33100000', '黄岩区', '', 1024, 3, 0),
 ('33100400', '33100000', '路桥区', '', 1025, 3, 0),
 ('33102100', '33100000', '玉环县', '', 1026, 3, 0),
 ('33102200', '33100000', '三门县', '', 1027, 3, 0),
 ('33102300', '33100000', '天台县', '', 1028, 3, 0),
 ('33102400', '33100000', '仙居县', '', 1029, 3, 0),
 ('33108100', '33100000', '温岭市', '', 1030, 3, 0),
 ('33108200', '33100000', '临海市', '', 1031, 3, 0),
 ('33110000', '33000000', '丽水市', '', 1032, 2, 9),
 ('33110200', '33110000', '莲都区', '', 1033, 3, 0),
 ('33112100', '33110000', '青田县', '', 1034, 3, 0),
 ('33112200', '33110000', '缙云县', '', 1035, 3, 0),
 ('33112300', '33110000', '遂昌县', '', 1036, 3, 0),
 ('33112400', '33110000', '松阳县', '', 1037, 3, 0),
 ('33112500', '33110000', '云和县', '', 1038, 3, 0),
 ('33112600', '33110000', '庆元县', '', 1039, 3, 0),
 ('33112700', '33110000', '景宁畲族自治县', '', 1040, 3, 0),
 ('33118100', '33110000', '龙泉市', '', 1041, 3, 0),
 ('34000000', 'A1560000', '安徽省', '', 1042, 1, 17),
 ('34010000', '34000000', '合肥市', '', 1043, 2, 8),
 ('34010200', '34010000', '瑶海区', '', 1044, 3, 0),
 ('34010300', '34010000', '庐阳区', '', 1045, 3, 0),
 ('34010400', '34010000', '蜀山区', '', 1046, 3, 0),
 ('34011100', '34010000', '包河区', '', 1047, 3, 0),
 ('34012100', '34010000', '长丰县', '', 1048, 3, 0),
 ('34012200', '34010000', '肥东县', '', 1049, 3, 0),
 ('34012300', '34010000', '肥西县', '', 1050, 3, 0),
 ('34020000', '34000000', '芜湖市', '', 1051, 2, 7),
 ('34020200', '34020000', '镜湖区', '', 1052, 3, 0),
 ('34020300', '34020000', '弋江区', '', 1053, 3, 0),
 ('34020400', '34020000', '三山区', '', 1054, 3, 0),
 ('34020700', '34020000', '鸠江区', '', 1055, 3, 0),
 ('34022100', '34020000', '芜湖县', '', 1056, 3, 0),
 ('34022200', '34020000', '繁昌县', '', 1057, 3, 0),
 ('34022300', '34020000', '南陵县', '', 1058, 3, 0),
 ('34030000', '34000000', '蚌埠市', '', 1059, 2, 6),
 ('34030200', '34010000', '龙子湖区', '', 1060, 3, 0),
 ('34030300', '34030000', '蚌山区', '', 1061, 3, 0),
 ('34030400', '34030000', '禹会区', '', 1062, 3, 0),
 ('34031100', '34030000', '淮上区', '', 1063, 3, 0),
 ('34032100', '34030000', '怀远县', '', 1064, 3, 0),
 ('34032200', '34030000', '五河县', '', 1065, 3, 0),
 ('34032300', '34030000', '固镇县', '', 1066, 3, 0),
 ('34040000', '34000000', '淮南市', '', 1067, 2, 6),
 ('34040200', '34040000', '大通区', '', 1068, 3, 0),
 ('34040300', '34040000', '田家庵区', '', 1069, 3, 0),
 ('34040400', '34040000', '谢家集区', '', 1070, 3, 0),
 ('34040500', '34040000', '八公山区', '', 1071, 3, 0),
 ('34040600', '34040000', '潘集区', '', 1072, 3, 0),
 ('34042100', '34040000', '凤台县', '', 1073, 3, 0),
 ('34050000', '34000000', '马鞍山市', '', 1074, 2, 4),
 ('34050200', '34050000', '金家庄区', '', 1075, 3, 0),
 ('34050300', '34050000', '花山区', '', 1076, 3, 0),
 ('34050400', '34050000', '雨山区', '', 1077, 3, 0),
 ('34052100', '34050000', '当涂县', '', 1078, 3, 0),
 ('34060000', '34000000', '淮北市', '', 1079, 2, 4),
 ('34060200', '34060000', '杜集区', '', 1080, 3, 0),
 ('34060300', '34060000', '相山区', '', 1081, 3, 0),
 ('34060400', '34060000', '烈山区', '', 1082, 3, 0),
 ('34062100', '34060000', '濉溪县', '', 1083, 3, 0),
 ('34070000', '34000000', '铜陵市', '', 1084, 2, 4),
 ('34070200', '34070000', '铜官山区', '', 1085, 3, 0),
 ('34070300', '34070000', '狮子山区', '', 1086, 3, 0),
 ('34071100', '34070000', '郊区', '', 1087, 3, 0),
 ('34072100', '34070000', '铜陵县', '', 1088, 3, 0),
 ('34080000', '34000000', '安庆市', '', 1089, 2, 11),
 ('34080200', '34080000', '迎江区', '', 1090, 3, 0),
 ('34080300', '34080000', '大观区', '', 1091, 3, 0),
 ('34081100', '34080000', '宜秀区', '', 1092, 3, 0),
 ('34082200', '34080000', '怀宁县', '', 1093, 3, 0),
 ('34082300', '34080000', '枞阳县', '', 1094, 3, 0),
 ('34082400', '34080000', '潜山县', '', 1095, 3, 0),
 ('34082500', '34080000', '太湖县', '', 1096, 3, 0),
 ('34082600', '34080000', '宿松县', '', 1097, 3, 0),
 ('34082700', '34080000', '望江县', '', 1098, 3, 0),
 ('34082800', '34080000', '岳西县', '', 1099, 3, 0),
 ('34088100', '34080000', '桐城市', '', 1100, 3, 0),
 ('34100000', '34000000', '黄山市', '', 1101, 2, 7),
 ('34100200', '34100000', '屯溪区', '', 1102, 3, 0),
 ('34100300', '34100000', '黄山区', '', 1103, 3, 0),
 ('34100400', '34100000', '徽州区', '', 1104, 3, 0),
 ('34102100', '34100000', '歙县', '', 1105, 3, 0),
 ('34102200', '34100000', '休宁县', '', 1106, 3, 0),
 ('34102300', '34100000', '黟县', '', 1107, 3, 0),
 ('34102400', '34100000', '祁门县', '', 1108, 3, 0),
 ('34110000', '34000000', '滁州市', '', 1109, 2, 8),
 ('34110200', '34110000', '琅琊区', '', 1110, 3, 0),
 ('34110300', '34110000', '南谯区', '', 1111, 3, 0),
 ('34112200', '34110000', '来安县', '', 1112, 3, 0),
 ('34112400', '34110000', '全椒县', '', 1113, 3, 0),
 ('34112500', '34110000', '定远县', '', 1114, 3, 0),
 ('34112600', '34110000', '凤阳县', '', 1115, 3, 0),
 ('34118100', '34110000', '天长市', '', 1116, 3, 0),
 ('34118200', '34110000', '明光市', '', 1117, 3, 0),
 ('34120000', '34000000', '阜阳市', '', 1118, 2, 8),
 ('34120200', '34120000', '颍州区', '', 1119, 3, 0),
 ('34120300', '34120000', '颍东区', '', 1120, 3, 0),
 ('34120400', '34120000', '颍泉区', '', 1121, 3, 0),
 ('34122100', '34120000', '临泉县', '', 1122, 3, 0),
 ('34122200', '34120000', '太和县', '', 1123, 3, 0),
 ('34122500', '34120000', '阜南县', '', 1124, 3, 0),
 ('34122600', '34120000', '颍上县', '', 1125, 3, 0),
 ('34128200', '34120000', '界首市', '', 1126, 3, 0),
 ('34130000', '34000000', '宿州市', '', 1127, 2, 5),
 ('34130200', '34130000', '墉桥区', '', 1128, 3, 0),
 ('34132100', '34130000', '砀山县', '', 1129, 3, 0),
 ('34132200', '34130000', '萧县', '', 1130, 3, 0),
 ('34132300', '34130000', '灵璧县', '', 1131, 3, 0),
 ('34132400', '34130000', '泗县', '', 1132, 3, 0),
 ('34140000', '34000000', '巢湖市', '', 1133, 2, 5),
 ('34140200', '34140000', '居巢区', '', 1134, 3, 0),
 ('34142100', '34140000', '庐江县', '', 1135, 3, 0),
 ('34142200', '34140000', '无为县', '', 1136, 3, 0),
 ('34142300', '34140000', '含山县', '', 1137, 3, 0),
 ('34142400', '34140000', '和县', '', 1138, 3, 0),
 ('34150000', '34000000', '六安市', '', 1139, 2, 7),
 ('34150200', '34150000', '金安区', '', 1140, 3, 0),
 ('34150300', '34150000', '裕安区', '', 1141, 3, 0),
 ('34152100', '34150000', '寿县', '', 1142, 3, 0),
 ('34152200', '34150000', '霍邱县', '', 1143, 3, 0),
 ('34152300', '34150000', '舒城县', '', 1144, 3, 0),
 ('34152400', '34150000', '金寨县', '', 1145, 3, 0),
 ('34152500', '34150000', '霍山县', '', 1146, 3, 0),
 ('34160000', '34000000', '亳州市', '', 1147, 2, 4),
 ('34160200', '34160000', '谯城区', '', 1148, 3, 0),
 ('34162100', '34160000', '涡阳县', '', 1149, 3, 0),
 ('34162200', '34160000', '蒙城县', '', 1150, 3, 0),
 ('34162300', '34160000', '利辛县', '', 1151, 3, 0),
 ('34170000', '34000000', '池州市', '', 1152, 2, 4),
 ('34170200', '34170000', '贵池区', '', 1153, 3, 0),
 ('34172100', '34170000', '东至县', '', 1154, 3, 0),
 ('34172200', '34170000', '石台县', '', 1155, 3, 0),
 ('34172300', '34170000', '青阳县', '', 1156, 3, 0),
 ('34180000', '34000000', '宣城市', '', 1157, 2, 7),
 ('34180200', '34180000', '宣州区', '', 1158, 3, 0),
 ('34182100', '34180000', '郎溪县', '', 1159, 3, 0),
 ('34182200', '34180000', '广德县', '', 1160, 3, 0),
 ('34182300', '34180000', '泾县', '', 1161, 3, 0),
 ('34182400', '34180000', '绩溪县', '', 1162, 3, 0),
 ('34182500', '34180000', '旌德县', '', 1163, 3, 0),
 ('34188100', '34180000', '宁国市', '', 1164, 3, 0);
  INSERT `tn_Areas` (`AreaCode`, `ParentCode`, `Name`, `PostCode`, `DisplayOrder`, `Depth`, `ChildCount`)
 VALUES
 ('35000000', 'A1560000', '福建省', '', 1165, 1, 9),
 ('35010000', '35000000', '福州市', '', 1166, 2, 13),
 ('35010200', '35010000', '鼓楼区', '', 1167, 3, 0),
 ('35010300', '35010000', '台江区', '', 1168, 3, 0),
 ('35010400', '35010000', '仓山区', '', 1169, 3, 0),
 ('35010500', '35010000', '马尾区', '', 1170, 3, 0),
 ('35011100', '35010000', '晋安区', '', 1171, 3, 0),
 ('35012100', '35010000', '闽侯县', '', 1172, 3, 0),
 ('35012200', '35010000', '连江县', '', 1173, 3, 0),
 ('35012300', '35010000', '罗源县', '', 1174, 3, 0),
 ('35012400', '35010000', '闽清县', '', 1175, 3, 0),
 ('35012500', '35010000', '永泰县', '', 1176, 3, 0),
 ('35012800', '35010000', '平潭县', '', 1177, 3, 0),
 ('35018100', '35010000', '福清市', '', 1178, 3, 0),
 ('35018200', '35010000', '长乐市', '', 1179, 3, 0),
 ('35020000', '35000000', '厦门市', '', 1180, 2, 6),
 ('35020300', '35020000', '思明区', '', 1181, 3, 0),
 ('35020500', '35020000', '海沧区', '', 1182, 3, 0),
 ('35020600', '35020000', '湖里区', '', 1183, 3, 0),
 ('35021100', '35020000', '集美区', '', 1184, 3, 0),
 ('35021200', '35020000', '同安区', '', 1185, 3, 0),
 ('35021300', '35020000', '翔安区', '', 1186, 3, 0),
 ('35030000', '35000000', '莆田市', '', 1187, 2, 5),
 ('35030200', '35030000', '城厢区', '', 1188, 3, 0),
 ('35030300', '35030000', '涵江区', '', 1189, 3, 0),
 ('35030400', '35030000', '荔城区', '', 1190, 3, 0),
 ('35030500', '35030000', '秀屿区', '', 1191, 3, 0),
 ('35032200', '35030000', '仙游县', '', 1192, 3, 0),
 ('35040000', '35000000', '三明市', '', 1193, 2, 12),
 ('35040200', '35040000', '梅列区', '', 1194, 3, 0),
 ('35040300', '35040000', '三元区', '', 1195, 3, 0),
 ('35042100', '35040000', '明溪县', '', 1196, 3, 0),
 ('35042300', '35040000', '清流县', '', 1197, 3, 0),
 ('35042400', '35040000', '宁化县', '', 1198, 3, 0),
 ('35042500', '35040000', '大田县', '', 1199, 3, 0),
 ('35042600', '35040000', '尤溪县', '', 1200, 3, 0),
 ('35042700', '35040000', '沙县', '', 1201, 3, 0),
 ('35042800', '35040000', '将乐县', '', 1202, 3, 0),
 ('35042900', '35040000', '泰宁县', '', 1203, 3, 0),
 ('35043000', '35040000', '建宁县', '', 1204, 3, 0),
 ('35048100', '35040000', '永安市', '', 1205, 3, 0),
 ('35050000', '35000000', '泉州市', '', 1206, 2, 12),
 ('35050200', '35050000', '鲤城区', '', 1207, 3, 0),
 ('35050300', '35050000', '丰泽区', '', 1208, 3, 0),
 ('35050400', '35050000', '洛江区', '', 1209, 3, 0),
 ('35050500', '35050000', '泉港区', '', 1210, 3, 0),
 ('35052100', '35050000', '惠安县', '', 1211, 3, 0),
 ('35052400', '35050000', '安溪县', '', 1212, 3, 0),
 ('35052500', '35050000', '永春县', '', 1213, 3, 0),
 ('35052600', '35050000', '德化县', '', 1214, 3, 0),
 ('35052700', '35050000', '金门县', '', 1215, 3, 0),
 ('35058100', '35050000', '石狮市', '', 1216, 3, 0),
 ('35058200', '35050000', '晋江市', '', 1217, 3, 0),
 ('35058300', '35050000', '南安市', '', 1218, 3, 0),
 ('35060000', '35000000', '漳州市', '', 1219, 2, 11),
 ('35060200', '35060000', '芗城区', '', 1220, 3, 0),
 ('35060300', '35060000', '龙文区', '', 1221, 3, 0),
 ('35062200', '35060000', '云霄县', '', 1222, 3, 0),
 ('35062300', '35060000', '漳浦县', '', 1223, 3, 0),
 ('35062400', '35060000', '诏安县', '', 1224, 3, 0),
 ('35062500', '35060000', '长泰县', '', 1225, 3, 0),
 ('35062600', '35060000', '东山县', '', 1226, 3, 0),
 ('35062700', '35060000', '南靖县', '', 1227, 3, 0),
 ('35062800', '35060000', '平和县', '', 1228, 3, 0),
 ('35062900', '35060000', '华安县', '', 1229, 3, 0),
 ('35068100', '35060000', '龙海市', '', 1230, 3, 0),
 ('35070000', '35000000', '南平市', '', 1231, 2, 10),
 ('35070200', '35070000', '延平区', '', 1232, 3, 0),
 ('35072100', '35070000', '顺昌县', '', 1233, 3, 0),
 ('35072200', '35070000', '浦城县', '', 1234, 3, 0),
 ('35072300', '35070000', '光泽县', '', 1235, 3, 0),
 ('35072400', '35070000', '松溪县', '', 1236, 3, 0),
 ('35072500', '35070000', '政和县', '', 1237, 3, 0),
 ('35078100', '35070000', '邵武市', '', 1238, 3, 0),
 ('35078200', '35070000', '武夷山市', '', 1239, 3, 0),
 ('35078300', '35070000', '建瓯市', '', 1240, 3, 0),
 ('35078400', '35070000', '建阳市', '', 1241, 3, 0),
 ('35080000', '35000000', '龙岩市', '', 1242, 2, 7),
 ('35080200', '35080000', '新罗区', '', 1243, 3, 0),
 ('35082100', '35080000', '长汀县', '', 1244, 3, 0),
 ('35082200', '35080000', '永定县', '', 1245, 3, 0),
 ('35082300', '35080000', '上杭县', '', 1246, 3, 0),
 ('35082400', '35080000', '武平县', '', 1247, 3, 0),
 ('35082500', '35080000', '连城县', '', 1248, 3, 0),
 ('35088100', '35080000', '漳平市', '', 1249, 3, 0),
 ('35090000', '35000000', '宁德市', '', 1250, 2, 9),
 ('35090200', '35090000', '蕉城区', '', 1251, 3, 0),
 ('35092100', '35090000', '霞浦县', '', 1252, 3, 0),
 ('35092200', '35090000', '古田县', '', 1253, 3, 0),
 ('35092300', '35090000', '屏南县', '', 1254, 3, 0),
 ('35092400', '35090000', '寿宁县', '', 1255, 3, 0),
 ('35092500', '35090000', '周宁县', '', 1256, 3, 0),
 ('35092600', '35090000', '柘荣县', '', 1257, 3, 0),
 ('35098100', '35090000', '福安市', '', 1258, 3, 0),
 ('35098200', '35090000', '福鼎市', '', 1259, 3, 0),
 ('36000000', 'A1560000', '江西省', '', 1260, 1, 11),
 ('36010000', '36000000', '南昌市', '', 1261, 2, 9),
 ('36010200', '36010000', '东湖区', '', 1262, 3, 0),
 ('36010300', '36010000', '西湖区', '', 1263, 3, 0),
 ('36010400', '36010000', '青云谱区', '', 1264, 3, 0),
 ('36010500', '36010000', '湾里区', '', 1265, 3, 0),
 ('36011100', '36010000', '青山湖区', '', 1266, 3, 0),
 ('36012100', '36010000', '南昌县', '', 1267, 3, 0),
 ('36012200', '36010000', '新建县', '', 1268, 3, 0),
 ('36012300', '36010000', '安义县', '', 1269, 3, 0),
 ('36012400', '36010000', '进贤县', '', 1270, 3, 0),
 ('36020000', '36000000', '景德镇市', '', 1271, 2, 4),
 ('36020200', '36020000', '昌江区', '', 1272, 3, 0),
 ('36020300', '36020000', '珠山区', '', 1273, 3, 0),
 ('36022200', '36020000', '浮梁县', '', 1274, 3, 0),
 ('36028100', '36020000', '乐平市', '', 1275, 3, 0),
 ('36030000', '36000000', '萍乡市', '', 1276, 2, 5),
 ('36030200', '36030000', '安源区', '', 1277, 3, 0),
 ('36031300', '36030000', '湘东区', '', 1278, 3, 0),
 ('36032100', '36030000', '莲花县', '', 1279, 3, 0),
 ('36032200', '36030000', '上栗县', '', 1280, 3, 0),
 ('36032300', '36030000', '芦溪县', '', 1281, 3, 0),
 ('36040000', '36000000', '九江市', '', 1282, 2, 12),
 ('36040200', '36040000', '庐山区', '', 1283, 3, 0),
 ('36040300', '36040000', '浔阳区', '', 1284, 3, 0),
 ('36042100', '36040000', '九江县', '', 1285, 3, 0),
 ('36042300', '36040000', '武宁县', '', 1286, 3, 0),
 ('36042400', '36040000', '修水县', '', 1287, 3, 0),
 ('36042500', '36040000', '永修县', '', 1288, 3, 0),
 ('36042600', '36040000', '德安县', '', 1289, 3, 0),
 ('36042700', '36040000', '星子县', '', 1290, 3, 0),
 ('36042800', '36040000', '都昌县', '', 1291, 3, 0),
 ('36042900', '36040000', '湖口县', '', 1292, 3, 0),
 ('36043000', '36040000', '彭泽县', '', 1293, 3, 0),
 ('36048100', '36040000', '瑞昌市', '', 1294, 3, 0),
 ('36050000', '36000000', '新余市', '', 1295, 2, 2),
 ('36050200', '36050000', '渝水区', '', 1296, 3, 0),
 ('36052100', '36050000', '分宜县', '', 1297, 3, 0),
 ('36060000', '36000000', '鹰潭市', '', 1298, 2, 3),
 ('36060200', '36060000', '月湖区', '', 1299, 3, 0),
 ('36062200', '36060000', '余江县', '', 1300, 3, 0),
 ('36068100', '36060000', '贵溪市', '', 1301, 3, 0),
 ('36070000', '36000000', '赣州市', '', 1302, 2, 18),
 ('36070200', '36070000', '章贡区', '', 1303, 3, 0),
 ('36072100', '36070000', '赣县', '', 1304, 3, 0),
 ('36072200', '36070000', '信丰县', '', 1305, 3, 0),
 ('36072300', '36070000', '大余县', '', 1306, 3, 0),
 ('36072400', '36070000', '上犹县', '', 1307, 3, 0),
 ('36072500', '36070000', '崇义县', '', 1308, 3, 0),
 ('36072600', '36070000', '安远县', '', 1309, 3, 0),
 ('36072700', '36070000', '龙南县', '', 1310, 3, 0),
 ('36072800', '36070000', '定南县', '', 1311, 3, 0),
 ('36072900', '36070000', '全南县', '', 1312, 3, 0),
 ('36073000', '36070000', '宁都县', '', 1313, 3, 0),
 ('36073100', '36070000', '于都县', '', 1314, 3, 0),
 ('36073200', '36070000', '兴国县', '', 1315, 3, 0),
 ('36073300', '36070000', '会昌县', '', 1316, 3, 0),
 ('36073400', '36070000', '寻乌县', '', 1317, 3, 0),
 ('36073500', '36070000', '石城县', '', 1318, 3, 0),
 ('36078100', '36070000', '瑞金市', '', 1319, 3, 0),
 ('36078200', '36070000', '南康市', '', 1320, 3, 0),
 ('36080000', '36000000', '吉安市', '', 1321, 2, 13),
 ('36080200', '36080000', '吉州区', '', 1322, 3, 0),
 ('36080300', '36080000', '青原区', '', 1323, 3, 0),
 ('36082100', '36080000', '吉安县', '', 1324, 3, 0),
 ('36082200', '36080000', '吉水县', '', 1325, 3, 0),
 ('36082300', '36080000', '峡江县', '', 1326, 3, 0),
 ('36082400', '36080000', '新干县', '', 1327, 3, 0),
 ('36082500', '36080000', '永丰县', '', 1328, 3, 0),
 ('36082600', '36080000', '泰和县', '', 1329, 3, 0),
 ('36082700', '36080000', '遂川县', '', 1330, 3, 0),
 ('36082800', '36080000', '万安县', '', 1331, 3, 0),
 ('36082900', '36080000', '安福县', '', 1332, 3, 0),
 ('36083000', '36080000', '永新县', '', 1333, 3, 0),
 ('36088100', '36080000', '井冈山市', '', 1334, 3, 0),
 ('36090000', '36000000', '宜春市', '', 1335, 2, 10),
 ('36090200', '36090000', '袁州区', '', 1336, 3, 0),
 ('36092100', '36090000', '奉新县', '', 1337, 3, 0),
 ('36092200', '36090000', '万载县', '', 1338, 3, 0),
 ('36092300', '36090000', '上高县', '', 1339, 3, 0),
 ('36092400', '36090000', '宜丰县', '', 1340, 3, 0),
 ('36092500', '36090000', '靖安县', '', 1341, 3, 0),
 ('36092600', '36090000', '铜鼓县', '', 1342, 3, 0),
 ('36098100', '36090000', '丰城市', '', 1343, 3, 0),
 ('36098200', '36090000', '樟树市', '', 1344, 3, 0),
 ('36098300', '36090000', '高安市', '', 1345, 3, 0),
 ('36100000', '36000000', '抚州市', '', 1346, 2, 11),
 ('36100200', '36100000', '临川区', '', 1347, 3, 0),
 ('36102100', '36100000', '南城县', '', 1348, 3, 0),
 ('36102200', '36100000', '黎川县', '', 1349, 3, 0),
 ('36102300', '36100000', '南丰县', '', 1350, 3, 0),
 ('36102400', '36100000', '崇仁县', '', 1351, 3, 0),
 ('36102500', '36100000', '乐安县', '', 1352, 3, 0),
 ('36102600', '36100000', '宜黄县', '', 1353, 3, 0),
 ('36102700', '36100000', '金溪县', '', 1354, 3, 0),
 ('36102800', '36100000', '资溪县', '', 1355, 3, 0),
 ('36102900', '36100000', '东乡县', '', 1356, 3, 0),
 ('36103000', '36100000', '广昌县', '', 1357, 3, 0),
 ('36110000', '36000000', '上饶市', '', 1358, 2, 12),
 ('36110200', '36110000', '信州区', '', 1359, 3, 0),
 ('36112100', '36110000', '上饶县', '', 1360, 3, 0),
 ('36112200', '36110000', '广丰县', '', 1361, 3, 0),
 ('36112300', '36110000', '玉山县', '', 1362, 3, 0),
 ('36112400', '36110000', '铅山县', '', 1363, 3, 0),
 ('36112500', '36110000', '横峰县', '', 1364, 3, 0),
 ('36112600', '36110000', '弋阳县', '', 1365, 3, 0),
 ('36112700', '36110000', '余干县', '', 1366, 3, 0),
 ('36112800', '36110000', '鄱阳县', '', 1367, 3, 0),
 ('36112900', '36110000', '万年县', '', 1368, 3, 0),
 ('36113000', '36110000', '婺源县', '', 1369, 3, 0),
 ('36118100', '36110000', '德兴市', '', 1370, 3, 0),
 ('37000000', 'A1560000', '山东省', '', 1371, 1, 17),
 ('37010000', '37000000', '济南市', '', 1372, 2, 10),
 ('37010200', '37010000', '历下区', '', 1373, 3, 0),
 ('37010300', '37010000', '市中区', '', 1374, 3, 0),
 ('37010400', '37010000', '槐荫区', '', 1375, 3, 0),
 ('37010500', '37010000', '天桥区', '', 1376, 3, 0),
 ('37011200', '37010000', '历城区', '', 1377, 3, 0),
 ('37011300', '37010000', '长清区', '', 1378, 3, 0),
 ('37012400', '37010000', '平阴县', '', 1379, 3, 0),
 ('37012500', '37010000', '济阳县', '', 1380, 3, 0),
 ('37012600', '37010000', '商河县', '', 1381, 3, 0),
 ('37018100', '37010000', '章丘市', '', 1382, 3, 0),
 ('37020000', '37000000', '青岛市', '', 1383, 2, 12),
 ('37020200', '37020000', '市南区', '', 1384, 3, 0),
 ('37020300', '37020000', '市北区', '', 1385, 3, 0),
 ('37020500', '37020000', '四方区', '', 1386, 3, 0),
 ('37021100', '37020000', '黄岛区', '', 1387, 3, 0),
 ('37021200', '37020000', '崂山区', '', 1388, 3, 0),
 ('37021300', '37020000', '李沧区', '', 1389, 3, 0),
 ('37021400', '37020000', '城阳区', '', 1390, 3, 0),
 ('37028100', '37020000', '胶州市', '', 1391, 3, 0),
 ('37028200', '37020000', '即墨市', '', 1392, 3, 0),
 ('37028300', '37020000', '平度市', '', 1393, 3, 0),
 ('37028400', '37020000', '胶南市', '', 1394, 3, 0),
 ('37028500', '37020000', '莱西市', '', 1395, 3, 0),
 ('37030000', '37000000', '淄博市', '', 1396, 2, 8),
 ('37030200', '37030000', '淄川区', '', 1397, 3, 0),
 ('37030300', '37030000', '张店区', '', 1398, 3, 0),
 ('37030400', '37030000', '博山区', '', 1399, 3, 0),
 ('37030500', '37030000', '临淄区', '', 1400, 3, 0),
 ('37030600', '37030000', '周村区', '', 1401, 3, 0),
 ('37032100', '37030000', '桓台县', '', 1402, 3, 0),
 ('37032200', '37030000', '高青县', '', 1403, 3, 0),
 ('37032300', '37030000', '沂源县', '', 1404, 3, 0),
 ('37040000', '37000000', '枣庄市', '', 1405, 2, 6),
 ('37040200', '37040000', '市中区', '', 1406, 3, 0),
 ('37040300', '37040000', '薛城区', '', 1407, 3, 0),
 ('37040400', '37040000', '峄城区', '', 1408, 3, 0),
 ('37040500', '37040000', '台儿庄区', '', 1409, 3, 0),
 ('37040600', '37040000', '山亭区', '', 1410, 3, 0),
 ('37048100', '37040000', '滕州市', '', 1411, 3, 0),
 ('37050000', '37000000', '东营市', '', 1412, 2, 5),
 ('37050200', '37050000', '东营区', '', 1413, 3, 0),
 ('37050300', '37050000', '河口区', '', 1414, 3, 0),
 ('37052100', '37050000', '垦利县', '', 1415, 3, 0),
 ('37052200', '37050000', '利津县', '', 1416, 3, 0),
 ('37052300', '37050000', '广饶县', '', 1417, 3, 0),
 ('37060000', '37000000', '烟台市', '', 1418, 2, 12),
 ('37060200', '37060000', '芝罘区', '', 1419, 3, 0),
 ('37061100', '37060000', '福山区', '', 1420, 3, 0),
 ('37061200', '37060000', '牟平区', '', 1421, 3, 0),
 ('37061300', '37060000', '莱山区', '', 1422, 3, 0),
 ('37063400', '37060000', '长岛县', '', 1423, 3, 0),
 ('37068100', '37060000', '龙口市', '', 1424, 3, 0),
 ('37068200', '37060000', '莱阳市', '', 1425, 3, 0),
 ('37068300', '37060000', '莱州市', '', 1426, 3, 0),
 ('37068400', '37060000', '蓬莱市', '', 1427, 3, 0),
 ('37068500', '37060000', '招远市', '', 1428, 3, 0),
 ('37068600', '37060000', '栖霞市', '', 1429, 3, 0),
 ('37068700', '37060000', '海阳市', '', 1430, 3, 0),
 ('37070000', '37000000', '潍坊市', '', 1431, 2, 12),
 ('37070200', '37070000', '潍城区', '', 1432, 3, 0),
 ('37070300', '37070000', '寒亭区', '', 1433, 3, 0),
 ('37070400', '37070000', '坊子区', '', 1434, 3, 0),
 ('37070500', '37070000', '奎文区', '', 1435, 3, 0),
 ('37072400', '37070000', '临朐县', '', 1436, 3, 0),
 ('37072500', '37070000', '昌乐县', '', 1437, 3, 0),
 ('37078100', '37070000', '青州市', '', 1438, 3, 0),
 ('37078200', '37070000', '诸城市', '', 1439, 3, 0),
 ('37078300', '37070000', '寿光市', '', 1440, 3, 0),
 ('37078400', '37070000', '安丘市', '', 1441, 3, 0),
 ('37078500', '37070000', '高密市', '', 1442, 3, 0),
 ('37078600', '37070000', '昌邑市', '', 1443, 3, 0),
 ('37080000', '37000000', '济宁市', '', 1444, 2, 12),
 ('37080200', '37080000', '市中区', '', 1445, 3, 0),
 ('37081100', '37080000', '任城区', '', 1446, 3, 0),
 ('37082600', '37080000', '微山县', '', 1447, 3, 0),
 ('37082700', '37080000', '鱼台县', '', 1448, 3, 0),
 ('37082800', '37080000', '金乡县', '', 1449, 3, 0),
 ('37082900', '37080000', '嘉祥县', '', 1450, 3, 0),
 ('37083000', '37080000', '汶上县', '', 1451, 3, 0),
 ('37083100', '37080000', '泗水县', '', 1452, 3, 0),
 ('37083200', '37080000', '梁山县', '', 1453, 3, 0),
 ('37088100', '37080000', '曲阜市', '', 1454, 3, 0),
 ('37088200', '37080000', '兖州市', '', 1455, 3, 0),
 ('37088300', '37080000', '邹城市', '', 1456, 3, 0),
 ('37090000', '37000000', '泰安市', '', 1457, 2, 6),
 ('37090200', '37090000', '泰山区', '', 1458, 3, 0),
 ('37090300', '37090000', '岱岳区', '', 1459, 3, 0),
 ('37092100', '37090000', '宁阳县', '', 1460, 3, 0),
 ('37092300', '37090000', '东平县', '', 1461, 3, 0),
 ('37098200', '37090000', '新泰市', '', 1462, 3, 0),
 ('37098300', '37090000', '肥城市', '', 1463, 3, 0),
 ('37100000', '37000000', '威海市', '', 1464, 2, 4),
 ('37100200', '37100000', '环翠区', '', 1465, 3, 0),
 ('37108100', '37100000', '文登市', '', 1466, 3, 0),
 ('37108200', '37100000', '荣成市', '', 1467, 3, 0),
 ('37108300', '37100000', '乳山市', '', 1468, 3, 0),
 ('37110000', '37000000', '日照市', '', 1469, 2, 4),
 ('37110200', '37110000', '东港区', '', 1470, 3, 0),
 ('37110300', '37110000', '岚山区', '', 1471, 3, 0),
 ('37112100', '37110000', '五莲县', '', 1472, 3, 0),
 ('37112200', '37110000', '莒县', '', 1473, 3, 0),
 ('37120000', '37000000', '莱芜市', '', 1474, 2, 2),
 ('37120200', '37120000', '莱城区', '', 1475, 3, 0),
 ('37120300', '37120000', '钢城区', '', 1476, 3, 0),
 ('37130000', '37000000', '临沂市', '', 1477, 2, 12),
 ('37130200', '37130000', '兰山区', '', 1478, 3, 0),
 ('37131100', '37130000', '罗庄区', '', 1479, 3, 0),
 ('37131200', '37130000', '河东区', '', 1480, 3, 0),
 ('37132100', '37130000', '沂南县', '', 1481, 3, 0),
 ('37132200', '37130000', '郯城县', '', 1482, 3, 0),
 ('37132300', '37130000', '沂水县', '', 1483, 3, 0),
 ('37132400', '37130000', '苍山县', '', 1484, 3, 0),
 ('37132500', '37130000', '费县', '', 1485, 3, 0),
 ('37132600', '37130000', '平邑县', '', 1486, 3, 0),
 ('37132700', '37130000', '莒南县', '', 1487, 3, 0),
 ('37132800', '37130000', '蒙阴县', '', 1488, 3, 0),
 ('37132900', '37130000', '临沭县', '', 1489, 3, 0),
 ('37140000', '37000000', '德州市', '', 1490, 2, 11),
 ('37140200', '37140000', '德城区', '', 1491, 3, 0),
 ('37142100', '37140000', '陵县', '', 1492, 3, 0),
 ('37142200', '37140000', '宁津县', '', 1493, 3, 0),
 ('37142300', '37140000', '庆云县', '', 1494, 3, 0),
 ('37142400', '37140000', '临邑县', '', 1495, 3, 0),
 ('37142500', '37140000', '齐河县', '', 1496, 3, 0),
 ('37142600', '37140000', '平原县', '', 1497, 3, 0),
 ('37142700', '37140000', '夏津县', '', 1498, 3, 0),
 ('37142800', '37140000', '武城县', '', 1499, 3, 0),
 ('37148100', '37140000', '乐陵市', '', 1500, 3, 0),
 ('37148200', '37140000', '禹城市', '', 1501, 3, 0),
 ('37150000', '37000000', '聊城市', '', 1502, 2, 8),
 ('37150200', '37150000', '东昌府区', '', 1503, 3, 0),
 ('37152100', '37150000', '阳谷县', '', 1504, 3, 0),
 ('37152200', '37150000', '莘县', '', 1505, 3, 0),
 ('37152300', '37150000', '茌平县', '', 1506, 3, 0),
 ('37152400', '37150000', '东阿县', '', 1507, 3, 0),
 ('37152500', '37150000', '冠县', '', 1508, 3, 0),
 ('37152600', '37150000', '高唐县', '', 1509, 3, 0),
 ('37158100', '37150000', '临清市', '', 1510, 3, 0),
 ('37160000', '37000000', '滨州市', '', 1511, 2, 7),
 ('37160200', '37160000', '滨城区', '', 1512, 3, 0),
 ('37162100', '37160000', '惠民县', '', 1513, 3, 0),
 ('37162200', '37160000', '阳信县', '', 1514, 3, 0),
 ('37162300', '37160000', '无棣县', '', 1515, 3, 0),
 ('37162400', '37160000', '沾化县', '', 1516, 3, 0),
 ('37162500', '37160000', '博兴县', '', 1517, 3, 0),
 ('37162600', '37160000', '邹平县', '', 1518, 3, 0),
 ('37170000', '37000000', '菏泽市', '', 1519, 2, 9),
 ('37170200', '37170000', '牡丹区', '', 1520, 3, 0),
 ('37172100', '37170000', '曹县', '', 1521, 3, 0),
 ('37172200', '37170000', '单县', '', 1522, 3, 0),
 ('37172300', '37170000', '成武县', '', 1523, 3, 0),
 ('37172400', '37170000', '巨野县', '', 1524, 3, 0),
 ('37172500', '37170000', '郓城县', '', 1525, 3, 0),
 ('37172600', '37170000', '鄄城县', '', 1526, 3, 0),
 ('37172700', '37170000', '定陶县', '', 1527, 3, 0),
 ('37172800', '37170000', '东明县', '', 1528, 3, 0),
 ('41000000', 'A1560000', '河南省', '', 1529, 1, 17),
 ('41010000', '41000000', '郑州市', '', 1530, 2, 12),
 ('41010200', '41010000', '中原区', '', 1531, 3, 0),
 ('41010300', '41010000', '二七区', '', 1532, 3, 0),
 ('41010400', '41010000', '管城回族区', '', 1533, 3, 0),
 ('41010500', '41010000', '金水区', '', 1534, 3, 0),
 ('41010600', '41010000', '上街区', '', 1535, 3, 0),
 ('41010800', '41010000', '惠济区', '', 1536, 3, 0),
 ('41012200', '41010000', '中牟县', '', 1537, 3, 0),
 ('41018100', '41010000', '巩义市', '', 1538, 3, 0),
 ('41018200', '41010000', '荥阳市', '', 1539, 3, 0),
 ('41018300', '41010000', '新密市', '', 1540, 3, 0),
 ('41018400', '41010000', '新郑市', '', 1541, 3, 0),
 ('41018500', '41010000', '登封市', '', 1542, 3, 0),
 ('41020000', '41000000', '开封市', '', 1543, 2, 10),
 ('41020200', '41020000', '龙亭区', '', 1544, 3, 0),
 ('41020300', '41020000', '顺河回族区', '', 1545, 3, 0),
 ('41020400', '41020000', '鼓楼区', '', 1546, 3, 0),
 ('41020500', '41020000', '禹王台区', '', 1547, 3, 0),
 ('41021100', '41020000', '金明区', '', 1548, 3, 0),
 ('41022100', '41020000', '杞县', '', 1549, 3, 0),
 ('41022200', '41020000', '通许县', '', 1550, 3, 0),
 ('41022300', '41020000', '尉氏县', '', 1551, 3, 0),
 ('41022400', '41020000', '开封县', '', 1552, 3, 0),
 ('41022500', '41020000', '兰考县', '', 1553, 3, 0),
 ('41030000', '41000000', '洛阳市', '', 1554, 2, 15),
 ('41030200', '41030000', '老城区', '', 1555, 3, 0),
 ('41030300', '41030000', '西工区', '', 1556, 3, 0),
 ('41030400', '41030000', '瀍河回族区', '', 1557, 3, 0),
 ('41030500', '41030000', '涧西区', '', 1558, 3, 0),
 ('41030600', '41030000', '吉利区', '', 1559, 3, 0),
 ('41030700', '41030000', '洛龙区', '', 1560, 3, 0),
 ('41032200', '41030000', '孟津县', '', 1561, 3, 0),
 ('41032300', '41030000', '新安县', '', 1562, 3, 0),
 ('41032400', '41030000', '栾川县', '', 1563, 3, 0),
 ('41032500', '41030000', '嵩县', '', 1564, 3, 0),
 ('41032600', '41030000', '汝阳县', '', 1565, 3, 0),
 ('41032700', '41030000', '宜阳县', '', 1566, 3, 0),
 ('41032800', '41030000', '洛宁县', '', 1567, 3, 0),
 ('41032900', '41030000', '伊川县', '', 1568, 3, 0),
 ('41038100', '41030000', '偃师市', '', 1569, 3, 0),
 ('41040000', '41000000', '平顶山市', '', 1570, 2, 10),
 ('41040200', '41040000', '新华区', '', 1571, 3, 0),
 ('41040300', '41040000', '卫东区', '', 1572, 3, 0),
 ('41040400', '41040000', '石龙区', '', 1573, 3, 0),
 ('41041100', '41040000', '湛河区', '', 1574, 3, 0),
 ('41042100', '41040000', '宝丰县', '', 1575, 3, 0),
 ('41042200', '41040000', '叶县', '', 1576, 3, 0),
 ('41042300', '41040000', '鲁山县', '', 1577, 3, 0),
 ('41042500', '41040000', '郏县', '', 1578, 3, 0),
 ('41048100', '41040000', '舞钢市', '', 1579, 3, 0),
 ('41048200', '41040000', '汝州市', '', 1580, 3, 0),
 ('41050000', '41000000', '安阳市', '', 1581, 2, 9),
 ('41050200', '41050000', '文峰区', '', 1582, 3, 0),
 ('41050300', '41050000', '北关区', '', 1583, 3, 0),
 ('41050500', '41050000', '殷都区', '', 1584, 3, 0),
 ('41050600', '41050000', '龙安区', '', 1585, 3, 0),
 ('41052200', '41050000', '安阳县', '', 1586, 3, 0),
 ('41052300', '41050000', '汤阴县', '', 1587, 3, 0),
 ('41052600', '41050000', '滑县', '', 1588, 3, 0),
 ('41052700', '41050000', '内黄县', '', 1589, 3, 0),
 ('41058100', '41050000', '林州市', '', 1590, 3, 0),
 ('41060000', '41000000', '鹤壁市', '', 1591, 2, 5),
 ('41060200', '41060000', '鹤山区', '', 1592, 3, 0),
 ('41060300', '41060000', '山城区', '', 1593, 3, 0),
 ('41061100', '41060000', '淇滨区', '', 1594, 3, 0),
 ('41062100', '41060000', '浚县', '', 1595, 3, 0),
 ('41062200', '41060000', '淇县', '', 1596, 3, 0),
 ('41070000', '41000000', '新乡市', '', 1597, 2, 12),
 ('41070200', '41070000', '红旗区', '', 1598, 3, 0),
 ('41070300', '41070000', '卫滨区', '', 1599, 3, 0),
 ('41070400', '41070000', '凤泉区', '', 1600, 3, 0),
 ('41071100', '41070000', '牧野区', '', 1601, 3, 0),
 ('41072100', '41070000', '新乡县', '', 1602, 3, 0),
 ('41072400', '41070000', '获嘉县', '', 1603, 3, 0),
 ('41072500', '41070000', '原阳县', '', 1604, 3, 0),
 ('41072600', '41070000', '延津县', '', 1605, 3, 0),
 ('41072700', '41070000', '封丘县', '', 1606, 3, 0),
 ('41072800', '41070000', '长垣县', '', 1607, 3, 0),
 ('41078100', '41070000', '卫辉市', '', 1608, 3, 0),
 ('41078200', '41070000', '辉县市', '', 1609, 3, 0),
 ('41080000', '41000000', '焦作市', '', 1610, 2, 11),
 ('41080200', '41080000', '解放区', '', 1611, 3, 0),
 ('41080300', '41080000', '中站区', '', 1612, 3, 0),
 ('41080400', '41080000', '马村区', '', 1613, 3, 0),
 ('41081100', '41080000', '山阳区', '', 1614, 3, 0),
 ('41082100', '41080000', '修武县', '', 1615, 3, 0),
 ('41082200', '41080000', '博爱县', '', 1616, 3, 0),
 ('41082300', '41080000', '武陟县', '', 1617, 3, 0),
 ('41082500', '41080000', '温县', '', 1618, 3, 0),
 ('41088100', '41080000', '济源市', '', 1619, 3, 0),
 ('41088200', '41080000', '沁阳市', '', 1620, 3, 0),
 ('41088300', '41080000', '孟州市', '', 1621, 3, 0),
 ('41090000', '41000000', '濮阳市', '', 1622, 2, 6),
 ('41090200', '41090000', '华龙区', '', 1623, 3, 0),
 ('41092200', '41090000', '清丰县', '', 1624, 3, 0),
 ('41092300', '41090000', '南乐县', '', 1625, 3, 0),
 ('41092600', '41090000', '范县', '', 1626, 3, 0),
 ('41092700', '41090000', '台前县', '', 1627, 3, 0),
 ('41092800', '41090000', '濮阳县', '', 1628, 3, 0),
 ('41100000', '41000000', '许昌市', '', 1629, 2, 6),
 ('41100200', '41100000', '魏都区', '', 1630, 3, 0),
 ('41102300', '41100000', '许昌县', '', 1631, 3, 0),
 ('41102400', '41100000', '鄢陵县', '', 1632, 3, 0),
 ('41102500', '41100000', '襄城县', '', 1633, 3, 0),
 ('41108100', '41100000', '禹州市', '', 1634, 3, 0),
 ('41108200', '41100000', '长葛市', '', 1635, 3, 0),
 ('41110000', '41000000', '漯河市', '', 1636, 2, 5),
 ('41110200', '41110000', '源汇区', '', 1637, 3, 0),
 ('41110300', '41110000', '郾城区', '', 1638, 3, 0),
 ('41110400', '41110000', '召陵区', '', 1639, 3, 0),
 ('41112100', '41110000', '舞阳县', '', 1640, 3, 0),
 ('41112200', '41110000', '临颍县', '', 1641, 3, 0),
 ('41120000', '41000000', '三门峡市', '', 1642, 2, 6),
 ('41120200', '41120000', '湖滨区', '', 1643, 3, 0),
 ('41122100', '41120000', '渑池县', '', 1644, 3, 0),
 ('41122200', '41120000', '陕县', '', 1645, 3, 0),
 ('41122400', '41120000', '卢氏县', '', 1646, 3, 0),
 ('41128100', '41120000', '义马市', '', 1647, 3, 0),
 ('41128200', '41120000', '灵宝市', '', 1648, 3, 0),
 ('41130000', '41000000', '南阳市', '', 1649, 2, 13),
 ('41130200', '41130000', '宛城区', '', 1650, 3, 0),
 ('41130300', '41130000', '卧龙区', '', 1651, 3, 0),
 ('41132100', '41130000', '南召县', '', 1652, 3, 0),
 ('41132200', '41130000', '方城县', '', 1653, 3, 0),
 ('41132300', '41130000', '西峡县', '', 1654, 3, 0),
 ('41132400', '41130000', '镇平县', '', 1655, 3, 0),
 ('41132500', '41130000', '内乡县', '', 1656, 3, 0),
 ('41132600', '41130000', '淅川县', '', 1657, 3, 0),
 ('41132700', '41130000', '社旗县', '', 1658, 3, 0),
 ('41132800', '41130000', '唐河县', '', 1659, 3, 0),
 ('41132900', '41130000', '新野县', '', 1660, 3, 0),
 ('41133000', '41130000', '桐柏县', '', 1661, 3, 0),
 ('41138100', '41130000', '邓州市', '', 1662, 3, 0),
 ('41140000', '41000000', '商丘市', '', 1663, 2, 9),
 ('41140200', '41140000', '梁园区', '', 1664, 3, 0),
 ('41140300', '41140000', '睢阳区', '', 1665, 3, 0),
 ('41142100', '41140000', '民权县', '', 1666, 3, 0),
 ('41142200', '41140000', '睢县', '', 1667, 3, 0),
 ('41142300', '41140000', '宁陵县', '', 1668, 3, 0),
 ('41142400', '41140000', '柘城县', '', 1669, 3, 0),
 ('41142500', '41140000', '虞城县', '', 1670, 3, 0),
 ('41142600', '41140000', '夏邑县', '', 1671, 3, 0),
 ('41148100', '41140000', '永城市', '', 1672, 3, 0),
 ('41150000', '41000000', '信阳市', '', 1673, 2, 10),
 ('41150200', '41150000', '?负忧?', '', 1674, 3, 0),
 ('41150300', '41150000', '平桥区', '', 1675, 3, 0),
 ('41152100', '41150000', '罗山县', '', 1676, 3, 0),
 ('41152200', '41150000', '光山县', '', 1677, 3, 0),
 ('41152300', '41150000', '新县', '', 1678, 3, 0),
 ('41152400', '41150000', '商城县', '', 1679, 3, 0),
 ('41152500', '41150000', '固始县', '', 1680, 3, 0),
 ('41152600', '41150000', '潢川县', '', 1681, 3, 0),
 ('41152700', '41150000', '淮滨县', '', 1682, 3, 0),
 ('41152800', '41150000', '息县', '', 1683, 3, 0),
 ('41160000', '41000000', '周口市', '', 1684, 2, 10),
 ('41160200', '41160000', '川汇区', '', 1685, 3, 0),
 ('41162100', '41160000', '扶沟县', '', 1686, 3, 0),
 ('41162200', '41160000', '西华县', '', 1687, 3, 0),
 ('41162300', '41160000', '商水县', '', 1688, 3, 0),
 ('41162400', '41160000', '沈丘县', '', 1689, 3, 0),
 ('41162500', '41160000', '郸城县', '', 1690, 3, 0),
 ('41162600', '41160000', '淮阳县', '', 1691, 3, 0),
 ('41162700', '41160000', '太康县', '', 1692, 3, 0),
 ('41162800', '41160000', '鹿邑县', '', 1693, 3, 0),
 ('41168100', '41160000', '项城市', '', 1694, 3, 0),
 ('41170000', '41000000', '驻马店市', '', 1695, 2, 10),
 ('41170200', '41170000', '驿城区', '', 1696, 3, 0),
 ('41172100', '41170000', '西平县', '', 1697, 3, 0),
 ('41172200', '41170000', '上蔡县', '', 1698, 3, 0),
 ('41172300', '41170000', '平舆县', '', 1699, 3, 0),
 ('41172400', '41170000', '正阳县', '', 1700, 3, 0),
 ('41172500', '41170000', '确山县', '', 1701, 3, 0),
 ('41172600', '41170000', '泌阳县', '', 1702, 3, 0),
 ('41172700', '41170000', '汝南县', '', 1703, 3, 0),
 ('41172800', '41170000', '遂平县', '', 1704, 3, 0),
 ('41172900', '41170000', '新蔡县', '', 1705, 3, 0);
  INSERT `tn_Areas` (`AreaCode`, `ParentCode`, `Name`, `PostCode`, `DisplayOrder`, `Depth`, `ChildCount`)
 VALUES
 ('42000000', 'A1560000', '湖北省', '', 1706, 1, 14),
 ('42010000', '42000000', '武汉市', '', 1707, 2, 13),
 ('42010200', '42010000', '江岸区', '', 1708, 3, 0),
 ('42010300', '42010000', '江汉区', '', 1709, 3, 0),
 ('42010400', '42010000', '硚口区', '', 1710, 3, 0),
 ('42010500', '42010000', '汉阳区', '', 1711, 3, 0),
 ('42010600', '42010000', '武昌区', '', 1712, 3, 0),
 ('42010700', '42010000', '青山区', '', 1713, 3, 0),
 ('42011100', '42010000', '洪山区', '', 1714, 3, 0),
 ('42011200', '42010000', '东西湖区', '', 1715, 3, 0),
 ('42011300', '42010000', '汉南区', '', 1716, 3, 0),
 ('42011400', '42010000', '蔡甸区', '', 1717, 3, 0),
 ('42011500', '42010000', '江夏区', '', 1718, 3, 0),
 ('42011600', '42010000', '黄陂区', '', 1719, 3, 0),
 ('42011700', '42010000', '新洲区', '', 1720, 3, 0),
 ('42020000', '42000000', '黄石市', '', 1721, 2, 6),
 ('42020200', '42020000', '黄石港区', '', 1722, 3, 0),
 ('42020300', '42020000', '西塞山区', '', 1723, 3, 0),
 ('42020400', '42020000', '下陆区', '', 1724, 3, 0),
 ('42020500', '42020000', '铁山区', '', 1725, 3, 0),
 ('42022200', '42020000', '阳新县', '', 1726, 3, 0),
 ('42028100', '42020000', '大冶市', '', 1727, 3, 0),
 ('42030000', '42000000', '十堰市', '', 1728, 2, 8),
 ('42030200', '42030000', '茅箭区', '', 1729, 3, 0),
 ('42030300', '42030000', '张湾区', '', 1730, 3, 0),
 ('42032100', '42030000', '郧县', '', 1731, 3, 0),
 ('42032200', '42030000', '郧西县', '', 1732, 3, 0),
 ('42032300', '42030000', '竹山县', '', 1733, 3, 0),
 ('42032400', '42030000', '竹溪县', '', 1734, 3, 0),
 ('42032500', '42030000', '房县', '', 1735, 3, 0),
 ('42038100', '42030000', '丹江口市', '', 1736, 3, 0),
 ('42050000', '42000000', '宜昌市', '', 1737, 2, 13),
 ('42050200', '42050000', '西陵区', '', 1738, 3, 0),
 ('42050300', '42050000', '伍家岗区', '', 1739, 3, 0),
 ('42050400', '42050000', '点军区', '', 1740, 3, 0),
 ('42050500', '42050000', '猇亭区', '', 1741, 3, 0),
 ('42050600', '42050000', '夷陵区', '', 1742, 3, 0),
 ('42052500', '42050000', '远安县', '', 1743, 3, 0),
 ('42052600', '42050000', '兴山县', '', 1744, 3, 0),
 ('42052700', '42050000', '秭归县', '', 1745, 3, 0),
 ('42052800', '42050000', '长阳土家族自治县', '', 1746, 3, 0),
 ('42052900', '42050000', '五峰土家族自治县', '', 1747, 3, 0),
 ('42058100', '42050000', '宜都市', '', 1748, 3, 0),
 ('42058200', '42050000', '当阳市', '', 1749, 3, 0),
 ('42058300', '42050000', '枝江市', '', 1750, 3, 0),
 ('42060000', '42000000', '襄樊市', '', 1751, 2, 9),
 ('42060200', '42060000', '襄城区', '', 1752, 3, 0),
 ('42060600', '42060000', '樊城区', '', 1753, 3, 0),
 ('42060700', '42060000', '襄阳区', '', 1754, 3, 0),
 ('42062400', '42060000', '南漳县', '', 1755, 3, 0),
 ('42062500', '42060000', '谷城县', '', 1756, 3, 0),
 ('42062600', '42060000', '保康县', '', 1757, 3, 0),
 ('42068200', '42060000', '老河口市', '', 1758, 3, 0),
 ('42068300', '42060000', '枣阳市', '', 1759, 3, 0),
 ('42068400', '42060000', '宜城市', '', 1760, 3, 0),
 ('42070000', '42000000', '鄂州市', '', 1761, 2, 3),
 ('42070200', '42070000', '梁子湖区', '', 1762, 3, 0),
 ('42070300', '42070000', '华容区', '', 1763, 3, 0),
 ('42070400', '42070000', '鄂城区', '', 1764, 3, 0),
 ('42080000', '42000000', '荆门市', '', 1765, 2, 5),
 ('42080200', '42080000', '东宝区', '', 1766, 3, 0),
 ('42080400', '42080000', '掇刀区', '', 1767, 3, 0),
 ('42082100', '42080000', '京山县', '', 1768, 3, 0),
 ('42082200', '42080000', '沙洋县', '', 1769, 3, 0),
 ('42088100', '42080000', '钟祥市', '', 1770, 3, 0),
 ('42090000', '42000000', '孝感市', '', 1771, 2, 7),
 ('42090200', '42090000', '孝南区', '', 1772, 3, 0),
 ('42092100', '42090000', '孝昌县', '', 1773, 3, 0),
 ('42092200', '42090000', '大悟县', '', 1774, 3, 0),
 ('42092300', '42090000', '云梦县', '', 1775, 3, 0),
 ('42098100', '42090000', '应城市', '', 1776, 3, 0),
 ('42098200', '42090000', '安陆市', '', 1777, 3, 0),
 ('42098400', '42090000', '汉川市', '', 1778, 3, 0),
 ('42100000', '42000000', '荆州市', '', 1779, 2, 8),
 ('42100200', '42100000', '沙市区', '', 1780, 3, 0),
 ('42100300', '42100000', '荆州区', '', 1781, 3, 0),
 ('42102200', '42100000', '公安县', '', 1782, 3, 0),
 ('42102300', '42100000', '监利县', '', 1783, 3, 0),
 ('42102400', '42100000', '江陵县', '', 1784, 3, 0),
 ('42108100', '42100000', '石首市', '', 1785, 3, 0),
 ('42108300', '42100000', '洪湖市', '', 1786, 3, 0),
 ('42108700', '42100000', '松滋市', '', 1787, 3, 0),
 ('42110000', '42000000', '黄冈市', '', 1788, 2, 10),
 ('42110200', '42110000', '黄州区', '', 1789, 3, 0),
 ('42112100', '42110000', '团风县', '', 1790, 3, 0),
 ('42112200', '42110000', '红安县', '', 1791, 3, 0),
 ('42112300', '42110000', '罗田县', '', 1792, 3, 0),
 ('42112400', '42110000', '英山县', '', 1793, 3, 0),
 ('42112500', '42110000', '浠水县', '', 1794, 3, 0),
 ('42112600', '42110000', '蕲春县', '', 1795, 3, 0),
 ('42112700', '42110000', '黄梅县', '', 1796, 3, 0),
 ('42118100', '42110000', '麻城市', '', 1797, 3, 0),
 ('42118200', '42110000', '武穴市', '', 1798, 3, 0),
 ('42120000', '42000000', '咸宁市', '', 1799, 2, 6),
 ('42120200', '42120000', '咸安区', '', 1800, 3, 0),
 ('42122100', '42120000', '嘉鱼县', '', 1801, 3, 0),
 ('42122200', '42120000', '通城县', '', 1802, 3, 0),
 ('42122300', '42120000', '崇阳县', '', 1803, 3, 0),
 ('42122400', '42120000', '通山县', '', 1804, 3, 0),
 ('42128100', '42120000', '赤壁市', '', 1805, 3, 0),
 ('42130000', '42000000', '随州市', '', 1806, 2, 2),
 ('42130200', '42130000', '曾都区', '', 1807, 3, 0),
 ('42138100', '42130000', '广水市', '', 1808, 3, 0),
 ('42280000', '42000000', '恩施土家族苗族自治州', '', 1809, 2, 8),
 ('42280100', '42280000', '恩施市', '', 1810, 3, 0),
 ('42280200', '42280000', '利川市', '', 1811, 3, 0),
 ('42282200', '42280000', '建始县', '', 1812, 3, 0),
 ('42282300', '42280000', '巴东县', '', 1813, 3, 0),
 ('42282500', '42280000', '宣恩县', '', 1814, 3, 0),
 ('42282600', '42280000', '咸丰县', '', 1815, 3, 0),
 ('42282700', '42280000', '来凤县', '', 1816, 3, 0),
 ('42282800', '42280000', '鹤峰县', '', 1817, 3, 0),
 ('42900000', '42000000', '省直辖行政单位', '', 1818, 2, 4),
 ('42900400', '42900000', '仙桃市', '', 1819, 3, 0),
 ('42900500', '42900000', '潜江市', '', 1820, 3, 0),
 ('42900600', '42900000', '天门市', '', 1821, 3, 0),
 ('42902100', '42900000', '神农架林区', '', 1822, 3, 0),
 ('43000000', 'A1560000', '湖南省', '', 1823, 1, 14),
 ('43010000', '43000000', '长沙市', '', 1824, 2, 9),
 ('43010200', '43010000', '芙蓉区', '', 1825, 3, 0),
 ('43010300', '43010000', '天心区', '', 1826, 3, 0),
 ('43010400', '43010000', '岳麓区', '', 1827, 3, 0),
 ('43010500', '43010000', '开福区', '', 1828, 3, 0),
 ('43011100', '43010000', '雨花区', '', 1829, 3, 0),
 ('43012100', '43010000', '长沙县', '', 1830, 3, 0),
 ('43012200', '43010000', '望城县', '', 1831, 3, 0),
 ('43012400', '43010000', '宁乡县', '', 1832, 3, 0),
 ('43018100', '43010000', '浏阳市', '', 1833, 3, 0),
 ('43020000', '43000000', '株洲市', '', 1834, 2, 9),
 ('43020200', '43020000', '荷塘区', '', 1835, 3, 0),
 ('43020300', '43020000', '芦淞区', '', 1836, 3, 0),
 ('43020400', '43020000', '石峰区', '', 1837, 3, 0),
 ('43021100', '43020000', '天元区', '', 1838, 3, 0),
 ('43022100', '43020000', '株洲县', '', 1839, 3, 0),
 ('43022300', '43020000', '攸县', '', 1840, 3, 0),
 ('43022400', '43020000', '茶陵县', '', 1841, 3, 0),
 ('43022500', '43020000', '炎陵县', '', 1842, 3, 0),
 ('43028100', '43020000', '醴陵市', '', 1843, 3, 0),
 ('43030000', '43000000', '湘潭市', '', 1844, 2, 5),
 ('43030200', '43030000', '雨湖区', '', 1845, 3, 0),
 ('43030400', '43030000', '岳塘区', '', 1846, 3, 0),
 ('43032100', '43030000', '湘潭县', '', 1847, 3, 0),
 ('43038100', '43030000', '湘乡市', '', 1848, 3, 0),
 ('43038200', '43030000', '韶山市', '', 1849, 3, 0),
 ('43040000', '43000000', '衡阳市', '', 1850, 2, 12),
 ('43040500', '43040000', '珠晖区', '', 1851, 3, 0),
 ('43040600', '43040000', '雁峰区', '', 1852, 3, 0),
 ('43040700', '43040000', '石鼓区', '', 1853, 3, 0),
 ('43040800', '43040000', '蒸湘区', '', 1854, 3, 0),
 ('43041200', '43040000', '南岳区', '', 1855, 3, 0),
 ('43042100', '43040000', '衡阳县', '', 1856, 3, 0),
 ('43042200', '43040000', '衡南县', '', 1857, 3, 0),
 ('43042300', '43040000', '衡山县', '', 1858, 3, 0),
 ('43042400', '43040000', '衡东县', '', 1859, 3, 0),
 ('43042600', '43040000', '祁东县', '', 1860, 3, 0),
 ('43048100', '43040000', '耒阳市', '', 1861, 3, 0),
 ('43048200', '43040000', '常宁市', '', 1862, 3, 0),
 ('43050000', '43000000', '邵阳市', '', 1863, 2, 12),
 ('43050200', '43050000', '双清区', '', 1864, 3, 0),
 ('43050300', '43050000', '大祥区', '', 1865, 3, 0),
 ('43051100', '43050000', '北塔区', '', 1866, 3, 0),
 ('43052100', '43050000', '邵东县', '', 1867, 3, 0),
 ('43052200', '43050000', '新邵县', '', 1868, 3, 0),
 ('43052300', '43050000', '邵阳县', '', 1869, 3, 0),
 ('43052400', '43050000', '隆回县', '', 1870, 3, 0),
 ('43052500', '43050000', '洞口县', '', 1871, 3, 0),
 ('43052700', '43050000', '绥宁县', '', 1872, 3, 0),
 ('43052800', '43050000', '新宁县', '', 1873, 3, 0),
 ('43052900', '43050000', '城步苗族自治县', '', 1874, 3, 0),
 ('43058100', '43050000', '武冈市', '', 1875, 3, 0),
 ('43060000', '43000000', '岳阳市', '', 1876, 2, 9),
 ('43060200', '43060000', '岳阳楼区', '', 1877, 3, 0),
 ('43060300', '43060000', '云溪区', '', 1878, 3, 0),
 ('43061100', '43060000', '君山区', '', 1879, 3, 0),
 ('43062100', '43060000', '岳阳县', '', 1880, 3, 0),
 ('43062300', '43060000', '华容县', '', 1881, 3, 0),
 ('43062400', '43060000', '湘阴县', '', 1882, 3, 0),
 ('43062600', '43060000', '平江县', '', 1883, 3, 0),
 ('43068100', '43060000', '汨罗市', '', 1884, 3, 0),
 ('43068200', '43060000', '临湘市', '', 1885, 3, 0),
 ('43070000', '43000000', '常德市', '', 1886, 2, 9),
 ('43070200', '43070000', '武陵区', '', 1887, 3, 0),
 ('43070300', '43070000', '鼎城区', '', 1888, 3, 0),
 ('43072100', '43070000', '安乡县', '', 1889, 3, 0),
 ('43072200', '43070000', '汉寿县', '', 1890, 3, 0),
 ('43072300', '43070000', '澧县', '', 1891, 3, 0),
 ('43072400', '43070000', '临澧县', '', 1892, 3, 0),
 ('43072500', '43070000', '桃源县', '', 1893, 3, 0),
 ('43072600', '43070000', '石门县', '', 1894, 3, 0),
 ('43078100', '43070000', '津市市', '', 1895, 3, 0),
 ('43080000', '43000000', '张家界市', '', 1896, 2, 4),
 ('43080200', '43080000', '永定区', '', 1897, 3, 0),
 ('43081100', '43080000', '武陵源区', '', 1898, 3, 0),
 ('43082100', '43080000', '慈利县', '', 1899, 3, 0),
 ('43082200', '43080000', '桑植县', '', 1900, 3, 0),
 ('43090000', '43000000', '益阳市', '', 1901, 2, 6),
 ('43090200', '43090000', '资阳区', '', 1902, 3, 0),
 ('43090300', '43090000', '赫山区', '', 1903, 3, 0),
 ('43092100', '43090000', '南县', '', 1904, 3, 0),
 ('43092200', '43090000', '桃江县', '', 1905, 3, 0),
 ('43092300', '43090000', '安化县', '', 1906, 3, 0),
 ('43098100', '43090000', '沅江市', '', 1907, 3, 0),
 ('43100000', '43000000', '郴州市', '', 1908, 2, 11),
 ('43100200', '43100000', '北湖区', '', 1909, 3, 0),
 ('43100300', '43100000', '苏仙区', '', 1910, 3, 0),
 ('43102100', '43100000', '桂阳县', '', 1911, 3, 0),
 ('43102200', '43100000', '宜章县', '', 1912, 3, 0),
 ('43102300', '43100000', '永兴县', '', 1913, 3, 0),
 ('43102400', '43100000', '嘉禾县', '', 1914, 3, 0),
 ('43102500', '43100000', '临武县', '', 1915, 3, 0),
 ('43102600', '43100000', '汝城县', '', 1916, 3, 0),
 ('43102700', '43100000', '桂东县', '', 1917, 3, 0),
 ('43102800', '43100000', '安仁县', '', 1918, 3, 0),
 ('43108100', '43100000', '资兴市', '', 1919, 3, 0),
 ('43110000', '43000000', '永州市', '', 1920, 2, 11),
 ('43110200', '43110000', '零陵区', '', 1921, 3, 0),
 ('43110300', '43110000', '冷水滩区', '', 1922, 3, 0),
 ('43112100', '43110000', '祁阳县', '', 1923, 3, 0),
 ('43112200', '43110000', '东安县', '', 1924, 3, 0),
 ('43112300', '43110000', '双牌县', '', 1925, 3, 0),
 ('43112400', '43110000', '道县', '', 1926, 3, 0),
 ('43112500', '43110000', '江永县', '', 1927, 3, 0),
 ('43112600', '43110000', '宁远县', '', 1928, 3, 0),
 ('43112700', '43110000', '蓝山县', '', 1929, 3, 0),
 ('43112800', '43110000', '新田县', '', 1930, 3, 0),
 ('43112900', '43110000', '江华瑶族自治县', '', 1931, 3, 0),
 ('43120000', '43000000', '怀化市', '', 1932, 2, 12),
 ('43120200', '43120000', '鹤城区', '', 1933, 3, 0),
 ('43122100', '43120000', '中方县', '', 1934, 3, 0),
 ('43122200', '43120000', '沅陵县', '', 1935, 3, 0),
 ('43122300', '43120000', '辰溪县', '', 1936, 3, 0),
 ('43122400', '43120000', '溆浦县', '', 1937, 3, 0),
 ('43122500', '43120000', '会同县', '', 1938, 3, 0),
 ('43122600', '43120000', '麻阳苗族自治县', '', 1939, 3, 0),
 ('43122700', '43120000', '新晃侗族自治县', '', 1940, 3, 0),
 ('43122800', '43120000', '芷江侗族自治县', '', 1941, 3, 0),
 ('43122900', '43120000', '靖州苗族侗族自治县', '', 1942, 3, 0),
 ('43123000', '43120000', '通道侗族自治县', '', 1943, 3, 0),
 ('43128100', '43120000', '洪江市', '', 1944, 3, 0),
 ('43130000', '43000000', '娄底市', '', 1945, 2, 5),
 ('43130200', '43130000', '娄星区', '', 1946, 3, 0),
 ('43132100', '43130000', '双峰县', '', 1947, 3, 0),
 ('43132200', '43130000', '新化县', '', 1948, 3, 0),
 ('43138100', '43130000', '冷水江市', '', 1949, 3, 0),
 ('43138200', '43130000', '涟源市', '', 1950, 3, 0),
 ('43310000', '43000000', '湘西土家族苗族自治州', '', 1951, 2, 8),
 ('43310100', '43310000', '吉首市', '', 1952, 3, 0),
 ('43312200', '43310000', '泸溪县', '', 1953, 3, 0),
 ('43312300', '43310000', '凤凰县', '', 1954, 3, 0),
 ('43312400', '43310000', '花垣县', '', 1955, 3, 0),
 ('43312500', '43310000', '保靖县', '', 1956, 3, 0),
 ('43312600', '43310000', '古丈县', '', 1957, 3, 0),
 ('43312700', '43310000', '永顺县', '', 1958, 3, 0),
 ('43313000', '43310000', '龙山县', '', 1959, 3, 0),
 ('44000000', 'A1560000', '广东省', '', 1960, 1, 21),
 ('44010000', '44000000', '广州市', '', 1961, 2, 12),
 ('44010200', '44010000', '南沙区', '', 1962, 3, 0),
 ('44010300', '44010000', '荔湾区', '', 1963, 3, 0),
 ('44010400', '44010000', '越秀区', '', 1964, 3, 0),
 ('44010500', '44010000', '海珠区', '', 1965, 3, 0),
 ('44010600', '44010000', '天河区', '', 1966, 3, 0),
 ('44010700', '44010000', '萝岗区', '', 1967, 3, 0),
 ('44011100', '44010000', '白云区', '', 1968, 3, 0),
 ('44011200', '44010000', '黄埔区', '', 1969, 3, 0),
 ('44011300', '44010000', '番禺区', '', 1970, 3, 0),
 ('44011400', '44010000', '花都区', '', 1971, 3, 0),
 ('44018300', '44010000', '增城市', '', 1972, 3, 0),
 ('44018400', '44010000', '从化市', '', 1973, 3, 0),
 ('44020000', '44000000', '韶关市', '', 1974, 2, 10),
 ('44020300', '44020000', '武江区', '', 1975, 3, 0),
 ('44020400', '44020000', '浈江区', '', 1976, 3, 0),
 ('44020500', '44020000', '曲江区', '', 1977, 3, 0),
 ('44022200', '44020000', '始兴县', '', 1978, 3, 0),
 ('44022400', '44020000', '仁化县', '', 1979, 3, 0),
 ('44022900', '44020000', '翁源县', '', 1980, 3, 0),
 ('44023200', '44020000', '乳源瑶族自治县', '', 1981, 3, 0),
 ('44023300', '44020000', '新丰县', '', 1982, 3, 0),
 ('44028100', '44020000', '乐昌市', '', 1983, 3, 0),
 ('44028200', '44020000', '南雄市', '', 1984, 3, 0),
 ('44030000', '44000000', '深圳市', '', 1985, 2, 6),
 ('44030300', '44030000', '罗湖区', '', 1986, 3, 0),
 ('44030400', '44030000', '福田区', '', 1987, 3, 0),
 ('44030500', '44030000', '南山区', '', 1988, 3, 0),
 ('44030600', '44030000', '宝安区', '', 1989, 3, 0),
 ('44030700', '44030000', '龙岗区', '', 1990, 3, 0),
 ('44030800', '44030000', '盐田区', '', 1991, 3, 0),
 ('44040000', '44000000', '珠海市', '', 1992, 2, 3),
 ('44040200', '44040000', '香洲区', '', 1993, 3, 0),
 ('44040300', '44040000', '斗门区', '', 1994, 3, 0),
 ('44040400', '44040000', '金湾区', '', 1995, 3, 0),
 ('44050000', '44000000', '汕头市', '', 1996, 2, 7),
 ('44050700', '44050000', '龙湖区', '', 1997, 3, 0),
 ('44051100', '44050000', '金平区', '', 1998, 3, 0),
 ('44051200', '44050000', '濠江区', '', 1999, 3, 0),
 ('44051300', '44050000', '潮阳区', '', 2000, 3, 0),
 ('44051400', '44050000', '潮南区', '', 2001, 3, 0),
 ('44051500', '44050000', '澄海区', '', 2002, 3, 0),
 ('44052300', '44050000', '南澳县', '', 2003, 3, 0),
 ('44060000', '44000000', '佛山市', '', 2004, 2, 5),
 ('44060400', '44060000', '禅城区', '', 2005, 3, 0),
 ('44060500', '44060000', '南海区', '', 2006, 3, 0),
 ('44060600', '44060000', '顺德区', '', 2007, 3, 0),
 ('44060700', '44060000', '三水区', '', 2008, 3, 0),
 ('44060800', '44060000', '高明区', '', 2009, 3, 0),
 ('44070000', '44000000', '江门市', '', 2010, 2, 7),
 ('44070300', '44070000', '蓬江区', '', 2011, 3, 0),
 ('44070400', '44070000', '江海区', '', 2012, 3, 0),
 ('44070500', '44070000', '新会区', '', 2013, 3, 0),
 ('44078100', '44070000', '台山市', '', 2014, 3, 0),
 ('44078300', '44070000', '开平市', '', 2015, 3, 0),
 ('44078400', '44070000', '鹤山市', '', 2016, 3, 0),
 ('44078500', '44070000', '恩平市', '', 2017, 3, 0),
 ('44080000', '44000000', '湛江市', '', 2018, 2, 9),
 ('44080200', '44080000', '赤坎区', '', 2019, 3, 0),
 ('44080300', '44080000', '霞山区', '', 2020, 3, 0),
 ('44080400', '44080000', '坡头区', '', 2021, 3, 0),
 ('44081100', '44080000', '麻章区', '', 2022, 3, 0),
 ('44082300', '44080000', '遂溪县', '', 2023, 3, 0),
 ('44082500', '44080000', '徐闻县', '', 2024, 3, 0),
 ('44088100', '44080000', '廉江市', '', 2025, 3, 0),
 ('44088200', '44080000', '雷州市', '', 2026, 3, 0),
 ('44088300', '44080000', '吴川市', '', 2027, 3, 0),
 ('44090000', '44000000', '茂名市', '', 2028, 2, 6),
 ('44090200', '44090000', '茂南区', '', 2029, 3, 0),
 ('44090300', '44090000', '茂港区', '', 2030, 3, 0),
 ('44092300', '44090000', '电白县', '', 2031, 3, 0),
 ('44098100', '44090000', '高州市', '', 2032, 3, 0),
 ('44098200', '44090000', '化州市', '', 2033, 3, 0),
 ('44098300', '44090000', '信宜市', '', 2034, 3, 0),
 ('44120000', '44000000', '肇庆市', '', 2035, 2, 8),
 ('44120200', '44120000', '端州区', '', 2036, 3, 0),
 ('44120300', '44120000', '鼎湖区', '', 2037, 3, 0),
 ('44122300', '44120000', '广宁县', '', 2038, 3, 0),
 ('44122400', '44120000', '怀集县', '', 2039, 3, 0),
 ('44122500', '44120000', '封开县', '', 2040, 3, 0),
 ('44122600', '44120000', '德庆县', '', 2041, 3, 0),
 ('44128300', '44120000', '高要市', '', 2042, 3, 0),
 ('44128400', '44120000', '四会市', '', 2043, 3, 0),
 ('44130000', '44000000', '惠州市', '', 2044, 2, 5),
 ('44130200', '44130000', '惠城区', '', 2045, 3, 0),
 ('44130300', '44130000', '惠阳区', '', 2046, 3, 0),
 ('44132200', '44130000', '博罗县', '', 2047, 3, 0),
 ('44132300', '44130000', '惠东县', '', 2048, 3, 0),
 ('44132400', '44130000', '龙门县', '', 2049, 3, 0),
 ('44140000', '44000000', '梅州市', '', 2050, 2, 8),
 ('44140200', '44140000', '梅江区', '', 2051, 3, 0),
 ('44142100', '44140000', '梅县', '', 2052, 3, 0),
 ('44142200', '44140000', '大埔县', '', 2053, 3, 0),
 ('44142300', '44140000', '丰顺县', '', 2054, 3, 0),
 ('44142400', '44140000', '五华县', '', 2055, 3, 0),
 ('44142600', '44140000', '平远县', '', 2056, 3, 0),
 ('44142700', '44140000', '蕉岭县', '', 2057, 3, 0),
 ('44148100', '44140000', '兴宁市', '', 2058, 3, 0),
 ('44150000', '44000000', '汕尾市', '', 2059, 2, 4),
 ('44150200', '44150000', '城区', '', 2060, 3, 0),
 ('44152100', '44150000', '海丰县', '', 2061, 3, 0),
 ('44152300', '44150000', '陆河县', '', 2062, 3, 0),
 ('44158100', '44150000', '陆丰市', '', 2063, 3, 0),
 ('44160000', '44000000', '河源市', '', 2064, 2, 6),
 ('44160200', '44160000', '源城区', '', 2065, 3, 0),
 ('44162100', '44160000', '紫金县', '', 2066, 3, 0),
 ('44162200', '44160000', '龙川县', '', 2067, 3, 0),
 ('44162300', '44160000', '连平县', '', 2068, 3, 0),
 ('44162400', '44160000', '和平县', '', 2069, 3, 0),
 ('44162500', '44160000', '东源县', '', 2070, 3, 0),
 ('44170000', '44000000', '阳江市', '', 2071, 2, 4),
 ('44170200', '44170000', '江城区', '', 2072, 3, 0),
 ('44172100', '44170000', '阳西县', '', 2073, 3, 0),
 ('44172300', '44170000', '阳东县', '', 2074, 3, 0),
 ('44178100', '44170000', '阳春市', '', 2075, 3, 0),
 ('44180000', '44000000', '清远市', '', 2076, 2, 8),
 ('44180200', '44180000', '清城区', '', 2077, 3, 0),
 ('44182100', '44180000', '佛冈县', '', 2078, 3, 0),
 ('44182300', '44180000', '阳山县', '', 2079, 3, 0),
 ('44182500', '44180000', '连山壮族瑶族自治县', '', 2080, 3, 0),
 ('44182600', '44180000', '连南瑶族自治县', '', 2081, 3, 0),
 ('44182700', '44180000', '清新县', '', 2082, 3, 0),
 ('44188100', '44180000', '英德市', '', 2083, 3, 0),
 ('44188200', '44180000', '连州市', '', 2084, 3, 0),
 ('44190000', '44000000', '东莞市', '', 2085, 2, 0),
 ('44200000', '44000000', '中山市', '', 2086, 2, 0),
 ('44510000', '44000000', '潮州市', '', 2087, 2, 3),
 ('44510200', '44510000', '湘桥区', '', 2088, 3, 0),
 ('44512100', '44510000', '潮安县', '', 2089, 3, 0),
 ('44512200', '44510000', '饶平县', '', 2090, 3, 0),
 ('44520000', '44000000', '揭阳市', '', 2091, 2, 5),
 ('44520200', '44520000', '榕城区', '', 2092, 3, 0),
 ('44522100', '44520000', '揭东县', '', 2093, 3, 0),
 ('44522200', '44520000', '揭西县', '', 2094, 3, 0),
 ('44522400', '44520000', '惠来县', '', 2095, 3, 0),
 ('44528100', '44520000', '普宁市', '', 2096, 3, 0),
 ('44530000', '44000000', '云浮市', '', 2097, 2, 5),
 ('44530200', '44530000', '云城区', '', 2098, 3, 0),
 ('44532100', '44530000', '新兴县', '', 2099, 3, 0),
 ('44532200', '44530000', '郁南县', '', 2100, 3, 0),
 ('44532300', '44530000', '云安县', '', 2101, 3, 0),
 ('44538100', '44530000', '罗定市', '', 2102, 3, 0),
 ('45000000', 'A1560000', '广西壮族自治区', '', 2103, 1, 14),
 ('45010000', '45000000', '南宁市', '', 2104, 2, 12),
 ('45010200', '45010000', '兴宁区', '', 2105, 3, 0),
 ('45010300', '45010000', '青秀区', '', 2106, 3, 0),
 ('45010500', '45010000', '江南区', '', 2107, 3, 0),
 ('45010700', '45010000', '西乡塘区', '', 2108, 3, 0),
 ('45010800', '45010000', '良庆区', '', 2109, 3, 0),
 ('45010900', '45010000', '邕宁区', '', 2110, 3, 0),
 ('45012200', '45010000', '武鸣县', '', 2111, 3, 0),
 ('45012300', '45010000', '隆安县', '', 2112, 3, 0),
 ('45012400', '45010000', '马山县', '', 2113, 3, 0),
 ('45012500', '45010000', '上林县', '', 2114, 3, 0),
 ('45012600', '45010000', '宾阳县', '', 2115, 3, 0),
 ('45012700', '45010000', '横县', '', 2116, 3, 0),
 ('45020000', '45000000', '柳州市', '', 2117, 2, 10),
 ('45020200', '45020000', '城中区', '', 2118, 3, 0),
 ('45020300', '45020000', '鱼峰区', '', 2119, 3, 0),
 ('45020400', '45020000', '柳南区', '', 2120, 3, 0),
 ('45020500', '45020000', '柳北区', '', 2121, 3, 0),
 ('45022100', '45020000', '柳江县', '', 2122, 3, 0),
 ('45022200', '45020000', '柳城县', '', 2123, 3, 0),
 ('45022300', '45020000', '鹿寨县', '', 2124, 3, 0),
 ('45022400', '45020000', '融安县', '', 2125, 3, 0),
 ('45022500', '45020000', '融水苗族自治县', '', 2126, 3, 0),
 ('45022600', '45020000', '三江侗族自治县', '', 2127, 3, 0),
 ('45030000', '45000000', '桂林市', '', 2128, 2, 17),
 ('45030200', '45030000', '秀峰区', '', 2129, 3, 0),
 ('45030300', '45030000', '叠彩区', '', 2130, 3, 0),
 ('45030400', '45030000', '象山区', '', 2131, 3, 0),
 ('45030500', '45030000', '七星区', '', 2132, 3, 0),
 ('45031100', '45030000', '雁山区', '', 2133, 3, 0),
 ('45032100', '45030000', '阳朔县', '', 2134, 3, 0),
 ('45032200', '45030000', '临桂县', '', 2135, 3, 0),
 ('45032300', '45030000', '灵川县', '', 2136, 3, 0),
 ('45032400', '45030000', '全州县', '', 2137, 3, 0),
 ('45032500', '45030000', '兴安县', '', 2138, 3, 0),
 ('45032600', '45030000', '永福县', '', 2139, 3, 0),
 ('45032700', '45030000', '灌阳县', '', 2140, 3, 0),
 ('45032800', '45030000', '龙胜各族自治县', '', 2141, 3, 0),
 ('45032900', '45030000', '资源县', '', 2142, 3, 0),
 ('45033000', '45030000', '平乐县', '', 2143, 3, 0),
 ('45033100', '45030000', '荔蒲县', '', 2144, 3, 0),
 ('45033200', '45030000', '恭城瑶族自治县', '', 2145, 3, 0),
 ('45040000', '45000000', '梧州市', '', 2146, 2, 7),
 ('45040300', '45040000', '万秀区', '', 2147, 3, 0),
 ('45040400', '45040000', '蝶山区', '', 2148, 3, 0),
 ('45040500', '45040000', '长洲区', '', 2149, 3, 0),
 ('45042100', '45040000', '苍梧县', '', 2150, 3, 0),
 ('45042200', '45040000', '藤县', '', 2151, 3, 0),
 ('45042300', '45040000', '蒙山县', '', 2152, 3, 0),
 ('45048100', '45040000', '岑溪市', '', 2153, 3, 0),
 ('45050000', '45000000', '北海市', '', 2154, 2, 4),
 ('45050200', '45050000', '海城区', '', 2155, 3, 0),
 ('45050300', '45050000', '银海区', '', 2156, 3, 0),
 ('45051200', '45050000', '铁山港区', '', 2157, 3, 0),
 ('45052100', '45050000', '合浦县', '', 2158, 3, 0),
 ('45060000', '45000000', '防城港市', '', 2159, 2, 4),
 ('45060200', '45060000', '港口区', '', 2160, 3, 0),
 ('45060300', '45060000', '防城区', '', 2161, 3, 0),
 ('45062100', '45060000', '上思县', '', 2162, 3, 0),
 ('45068100', '45060000', '东兴市', '', 2163, 3, 0),
 ('45070000', '45000000', '钦州市', '', 2164, 2, 4),
 ('45070200', '45070000', '钦南区', '', 2165, 3, 0),
 ('45070300', '45070000', '钦北区', '', 2166, 3, 0),
 ('45072100', '45070000', '灵山县', '', 2167, 3, 0),
 ('45072200', '45070000', '浦北县', '', 2168, 3, 0),
 ('45080000', '45000000', '贵港市', '', 2169, 2, 5),
 ('45080200', '45080000', '港北区', '', 2170, 3, 0),
 ('45080300', '45080000', '港南区', '', 2171, 3, 0),
 ('45080400', '45080000', '覃塘区', '', 2172, 3, 0),
 ('45082100', '45080000', '平南县', '', 2173, 3, 0),
 ('45088100', '45080000', '桂平市', '', 2174, 3, 0),
 ('45090000', '45000000', '玉林市', '', 2175, 2, 6),
 ('45090200', '45090000', '玉州区', '', 2176, 3, 0),
 ('45092100', '45090000', '容县', '', 2177, 3, 0),
 ('45092200', '45090000', '陆川县', '', 2178, 3, 0),
 ('45092300', '45090000', '博白县', '', 2179, 3, 0),
 ('45092400', '45090000', '兴业县', '', 2180, 3, 0),
 ('45098100', '45090000', '北流市', '', 2181, 3, 0),
 ('45100000', '45000000', '百色市', '', 2182, 2, 12),
 ('45100200', '45100000', '右江区', '', 2183, 3, 0),
 ('45102100', '45100000', '田阳县', '', 2184, 3, 0),
 ('45102200', '45100000', '田东县', '', 2185, 3, 0),
 ('45102300', '45100000', '平果县', '', 2186, 3, 0),
 ('45102400', '45100000', '德保县', '', 2187, 3, 0),
 ('45102500', '45100000', '靖西县', '', 2188, 3, 0),
 ('45102600', '45100000', '那坡县', '', 2189, 3, 0),
 ('45102700', '45100000', '凌云县', '', 2190, 3, 0),
 ('45102800', '45100000', '乐业县', '', 2191, 3, 0),
 ('45102900', '45100000', '田林县', '', 2192, 3, 0),
 ('45103000', '45100000', '西林县', '', 2193, 3, 0),
 ('45103100', '45100000', '隆林各族自治县', '', 2194, 3, 0),
 ('45110000', '45000000', '贺州市', '', 2195, 2, 4),
 ('45110200', '45110000', '八步区', '', 2196, 3, 0),
 ('45112100', '45110000', '昭平县', '', 2197, 3, 0),
 ('45112200', '45110000', '钟山县', '', 2198, 3, 0),
 ('45112300', '45110000', '富川瑶族自治县', '', 2199, 3, 0),
 ('45120000', '45000000', '河池市', '', 2200, 2, 11),
 ('45120200', '45120000', '金城江区', '', 2201, 3, 0),
 ('45122100', '45120000', '南丹县', '', 2202, 3, 0),
 ('45122200', '45120000', '天峨县', '', 2203, 3, 0),
 ('45122300', '45120000', '凤山县', '', 2204, 3, 0),
 ('45122400', '45120000', '东兰县', '', 2205, 3, 0),
 ('45122500', '45120000', '罗城仫佬族自治县', '', 2206, 3, 0),
 ('45122600', '45120000', '环江毛南族自治县', '', 2207, 3, 0),
 ('45122700', '45120000', '巴马瑶族自治县', '', 2208, 3, 0),
 ('45122800', '45120000', '都安瑶族自治县', '', 2209, 3, 0),
 ('45122900', '45120000', '大化瑶族自治县', '', 2210, 3, 0),
 ('45128100', '45120000', '宜州市', '', 2211, 3, 0),
 ('45130000', '45000000', '来宾市', '', 2212, 2, 6),
 ('45130200', '45130000', '兴宾区', '', 2213, 3, 0),
 ('45132100', '45130000', '忻城县', '', 2214, 3, 0),
 ('45132200', '45130000', '象州县', '', 2215, 3, 0),
 ('45132300', '45130000', '武宣县', '', 2216, 3, 0),
 ('45132400', '45130000', '金秀瑶族自治县', '', 2217, 3, 0),
 ('45138100', '45130000', '合山市', '', 2218, 3, 0),
 ('45140000', '45000000', '崇左市', '', 2219, 2, 7),
 ('45140200', '45140000', '江州区', '', 2220, 3, 0),
 ('45142100', '45140000', '扶绥县', '', 2221, 3, 0),
 ('45142200', '45140000', '宁明县', '', 2222, 3, 0),
 ('45142300', '45140000', '龙州县', '', 2223, 3, 0),
 ('45142400', '45140000', '大新县', '', 2224, 3, 0),
 ('45142500', '45140000', '天等县', '', 2225, 3, 0),
 ('45148100', '45140000', '凭祥市', '', 2226, 3, 0),
 ('46000000', 'A1560000', '海南省', '', 2227, 1, 3),
 ('46010000', '46000000', '海口市', '', 2228, 2, 4),
 ('46010500', '46010000', '秀英区', '', 2229, 3, 0),
 ('46010600', '46010000', '龙华区', '', 2230, 3, 0),
 ('46010700', '46010000', '琼山区', '', 2231, 3, 0),
 ('46010800', '46010000', '美兰区', '', 2232, 3, 0),
 ('46020000', '46000000', '三亚市', '', 2233, 2, 0),
 ('46900000', '46000000', '省直辖县级行政单位', '', 2234, 2, 19),
 ('46900100', '46900000', '五指山市', '', 2235, 3, 0),
 ('46900200', '46900000', '琼海市', '', 2236, 3, 0),
 ('46900300', '46900000', '儋州市', '', 2237, 3, 0),
 ('46900500', '46900000', '文昌市', '', 2238, 3, 0),
 ('46900600', '46900000', '万宁市', '', 2239, 3, 0),
 ('46900700', '46900000', '东方市', '', 2240, 3, 0),
 ('46902500', '46900000', '定安县', '', 2241, 3, 0),
 ('46902600', '46900000', '屯昌县', '', 2242, 3, 0),
 ('46902700', '46900000', '澄迈县', '', 2243, 3, 0),
 ('46902800', '46900000', '临高县', '', 2244, 3, 0),
 ('46903000', '46900000', '白沙黎族自治县', '', 2245, 3, 0),
 ('46903100', '46900000', '昌江黎族自治县', '', 2246, 3, 0),
 ('46903300', '46900000', '乐东黎族自治县', '', 2247, 3, 0),
 ('46903400', '46900000', '陵水黎族自治县', '', 2248, 3, 0),
 ('46903500', '46900000', '保亭黎族苗族自治县', '', 2249, 3, 0),
 ('46903600', '46900000', '琼中黎族苗族自治县', '', 2250, 3, 0),
 ('46903700', '46900000', '西沙群岛', '', 2251, 3, 0),
 ('46903800', '46900000', '南沙群岛', '', 2252, 3, 0),
 ('46903900', '46900000', '中沙群岛的岛礁及其海域', '', 2253, 3, 0);
  INSERT `tn_Areas` (`AreaCode`, `ParentCode`, `Name`, `PostCode`, `DisplayOrder`, `Depth`, `ChildCount`)
 VALUES
 ('50000000', 'A1560000', '重庆市', '', 2254, 1, 1),
 ('50010000', '50000000', '重庆市', '', 2255, 2, 40),
 ('50010100', '50010000', '万州区', '', 2256, 3, 0),
 ('50010200', '50010000', '涪陵区', '', 2257, 3, 0),
 ('50010300', '50010000', '渝中区', '', 2258, 3, 0),
 ('50010400', '50010000', '大渡口区', '', 2259, 3, 0),
 ('50010500', '50010000', '江北区', '', 2260, 3, 0),
 ('50010600', '50010000', '沙坪坝区', '', 2261, 3, 0),
 ('50010700', '50010000', '九龙坡区', '', 2262, 3, 0),
 ('50010800', '50010000', '南岸区', '', 2263, 3, 0),
 ('50010900', '50010000', '北碚区', '', 2264, 3, 0),
 ('50011000', '50010000', '万盛区', '', 2265, 3, 0),
 ('50011100', '50010000', '双桥区', '', 2266, 3, 0),
 ('50011200', '50010000', '渝北区', '', 2267, 3, 0),
 ('50011300', '50010000', '巴南区', '', 2268, 3, 0),
 ('50011400', '50010000', '黔江区', '', 2269, 3, 0),
 ('50011500', '50010000', '长寿区', '', 2270, 3, 0),
 ('50022200', '50010000', '綦江县', '', 2271, 3, 0),
 ('50022300', '50010000', '潼南县', '', 2272, 3, 0),
 ('50022400', '50010000', '铜梁县', '', 2273, 3, 0),
 ('50022500', '50010000', '大足县', '', 2274, 3, 0),
 ('50022600', '50010000', '荣昌县', '', 2275, 3, 0),
 ('50022700', '50010000', '璧山县', '', 2276, 3, 0),
 ('50022800', '50010000', '梁平县', '', 2277, 3, 0),
 ('50022900', '50010000', '城口县', '', 2278, 3, 0),
 ('50023000', '50010000', '丰都县', '', 2279, 3, 0),
 ('50023100', '50010000', '垫江县', '', 2280, 3, 0),
 ('50023200', '50010000', '武隆县', '', 2281, 3, 0),
 ('50023300', '50010000', '忠县', '', 2282, 3, 0),
 ('50023400', '50010000', '开县', '', 2283, 3, 0),
 ('50023500', '50010000', '云阳县', '', 2284, 3, 0),
 ('50023600', '50010000', '奉节县', '', 2285, 3, 0),
 ('50023700', '50010000', '巫山县', '', 2286, 3, 0),
 ('50023800', '50010000', '巫溪县', '', 2287, 3, 0),
 ('50024000', '50010000', '石柱土家族自治县', '', 2288, 3, 0),
 ('50024100', '50010000', '秀山土家族苗族自治县', '', 2289, 3, 0),
 ('50024200', '50010000', '酉阳土家族苗族自治县', '', 2290, 3, 0),
 ('50024300', '50010000', '彭水苗族土家族自治县', '', 2291, 3, 0),
 ('50038100', '50010000', '江津市', '', 2292, 3, 0),
 ('50038200', '50010000', '合川市', '', 2293, 3, 0),
 ('50038300', '50010000', '永川市', '', 2294, 3, 0),
 ('50038400', '50010000', '南川市', '', 2295, 3, 0),
 ('51000000', 'A1560000', '四川省', '', 2296, 1, 21),
 ('51010000', '51000000', '成都市', '', 2297, 2, 19),
 ('51010400', '51010000', '锦江区', '', 2298, 3, 0),
 ('51010500', '51010000', '青羊区', '', 2299, 3, 0),
 ('51010600', '51010000', '金牛区', '', 2300, 3, 0),
 ('51010700', '51010000', '武侯区', '', 2301, 3, 0),
 ('51010800', '51010000', '成华区', '', 2302, 3, 0),
 ('51011200', '51010000', '龙泉驿区', '', 2303, 3, 0),
 ('51011300', '51010000', '青白江区', '', 2304, 3, 0),
 ('51011400', '51010000', '新都区', '', 2305, 3, 0),
 ('51011500', '51010000', '温江区', '', 2306, 3, 0),
 ('51012100', '51010000', '金堂县', '', 2307, 3, 0),
 ('51012200', '51010000', '双流县', '', 2308, 3, 0),
 ('51012400', '51010000', '郫县', '', 2309, 3, 0),
 ('51012900', '51010000', '大邑县', '', 2310, 3, 0),
 ('51013100', '51010000', '蒲江县', '', 2311, 3, 0),
 ('51013200', '51010000', '新津县', '', 2312, 3, 0),
 ('51018100', '51010000', '都江堰市', '', 2313, 3, 0),
 ('51018200', '51010000', '彭州市', '', 2314, 3, 0),
 ('51018300', '51010000', '邛崃市', '', 2315, 3, 0),
 ('51018400', '51010000', '崇州市', '', 2316, 3, 0),
 ('51030000', '51000000', '自贡市', '', 2317, 2, 6),
 ('51030200', '51030000', '自流井区', '', 2318, 3, 0),
 ('51030300', '51030000', '贡井区', '', 2319, 3, 0),
 ('51030400', '51030000', '大安区', '', 2320, 3, 0),
 ('51031100', '51030000', '沿滩区', '', 2321, 3, 0),
 ('51032100', '51030000', '荣县', '', 2322, 3, 0),
 ('51032200', '51030000', '富顺县', '', 2323, 3, 0),
 ('51040000', '51000000', '攀枝花市', '', 2324, 2, 5),
 ('51040200', '51040000', '东区', '', 2325, 3, 0),
 ('51040300', '51040000', '西区', '', 2326, 3, 0),
 ('51041100', '51040000', '仁和区', '', 2327, 3, 0),
 ('51042100', '51040000', '米易县', '', 2328, 3, 0),
 ('51042200', '51040000', '盐边县', '', 2329, 3, 0),
 ('51050000', '51000000', '泸州市', '', 2330, 2, 7),
 ('51050200', '51050000', '江阳区', '', 2331, 3, 0),
 ('51050300', '51050000', '纳溪区', '', 2332, 3, 0),
 ('51050400', '51050000', '龙马潭区', '', 2333, 3, 0),
 ('51052100', '51050000', '泸县', '', 2334, 3, 0),
 ('51052200', '51050000', '合江县', '', 2335, 3, 0),
 ('51052400', '51050000', '叙永县', '', 2336, 3, 0),
 ('51052500', '51050000', '古蔺县', '', 2337, 3, 0),
 ('51060000', '51000000', '德阳市', '', 2338, 2, 6),
 ('51060300', '51060000', '旌阳区', '', 2339, 3, 0),
 ('51062300', '51060000', '中江县', '', 2340, 3, 0),
 ('51062600', '51060000', '罗江县', '', 2341, 3, 0),
 ('51068100', '51060000', '广汉市', '', 2342, 3, 0),
 ('51068200', '51060000', '什邡市', '', 2343, 3, 0),
 ('51068300', '51060000', '绵竹市', '', 2344, 3, 0),
 ('51070000', '51000000', '绵阳市', '', 2345, 2, 9),
 ('51070300', '51070000', '涪城区', '', 2346, 3, 0),
 ('51070400', '51070000', '游仙区', '', 2347, 3, 0),
 ('51072200', '51070000', '三台县', '', 2348, 3, 0),
 ('51072300', '51070000', '盐亭县', '', 2349, 3, 0),
 ('51072400', '51070000', '安县', '', 2350, 3, 0),
 ('51072500', '51070000', '梓潼县', '', 2351, 3, 0),
 ('51072600', '51070000', '北川羌族自治县', '', 2352, 3, 0),
 ('51072700', '51070000', '平武县', '', 2353, 3, 0),
 ('51078100', '51070000', '江油市', '', 2354, 3, 0),
 ('51080000', '51000000', '广元市', '', 2355, 2, 7),
 ('51080200', '51080000', '市中区', '', 2356, 3, 0),
 ('51081100', '51080000', '元坝区', '', 2357, 3, 0),
 ('51081200', '51080000', '朝天区', '', 2358, 3, 0),
 ('51082100', '51080000', '旺苍县', '', 2359, 3, 0),
 ('51082200', '51080000', '青川县', '', 2360, 3, 0),
 ('51082300', '51080000', '剑阁县', '', 2361, 3, 0),
 ('51082400', '51080000', '苍溪县', '', 2362, 3, 0),
 ('51090000', '51000000', '遂宁市', '', 2363, 2, 5),
 ('51090300', '51090000', '船山区', '', 2364, 3, 0),
 ('51090400', '51090000', '安居区', '', 2365, 3, 0),
 ('51092100', '51090000', '蓬溪县', '', 2366, 3, 0),
 ('51092200', '51090000', '射洪县', '', 2367, 3, 0),
 ('51092300', '51090000', '大英县', '', 2368, 3, 0),
 ('51100000', '51000000', '内江市', '', 2369, 2, 5),
 ('51100200', '51100000', '市中区', '', 2370, 3, 0),
 ('51101100', '51100000', '东兴区', '', 2371, 3, 0),
 ('51102400', '51100000', '威远县', '', 2372, 3, 0),
 ('51102500', '51100000', '资中县', '', 2373, 3, 0),
 ('51102800', '51100000', '隆昌县', '', 2374, 3, 0),
 ('51110000', '51000000', '乐山市', '', 2375, 2, 11),
 ('51110200', '51110000', '市中区', '', 2376, 3, 0),
 ('51111100', '51110000', '沙湾区', '', 2377, 3, 0),
 ('51111200', '51110000', '五通桥区', '', 2378, 3, 0),
 ('51111300', '51110000', '金口河区', '', 2379, 3, 0),
 ('51112300', '51110000', '犍为县', '', 2380, 3, 0),
 ('51112400', '51110000', '井研县', '', 2381, 3, 0),
 ('51112600', '51110000', '夹江县', '', 2382, 3, 0),
 ('51112900', '51110000', '沐川县', '', 2383, 3, 0),
 ('51113200', '51110000', '峨边彝族自治县', '', 2384, 3, 0),
 ('51113300', '51110000', '马边彝族自治县', '', 2385, 3, 0),
 ('51118100', '51110000', '峨眉山市', '', 2386, 3, 0),
 ('51130000', '51000000', '南充市', '', 2387, 2, 9),
 ('51130200', '51130000', '顺庆区', '', 2388, 3, 0),
 ('51130300', '51130000', '高坪区', '', 2389, 3, 0),
 ('51130400', '51130000', '嘉陵区', '', 2390, 3, 0),
 ('51132100', '51130000', '南部县', '', 2391, 3, 0),
 ('51132200', '51130000', '营山县', '', 2392, 3, 0),
 ('51132300', '51130000', '蓬安县', '', 2393, 3, 0),
 ('51132400', '51130000', '仪陇县', '', 2394, 3, 0),
 ('51132500', '51130000', '西充县', '', 2395, 3, 0),
 ('51138100', '51130000', '阆中市', '', 2396, 3, 0),
 ('51140000', '51000000', '眉山市', '', 2397, 2, 6),
 ('51140200', '51140000', '东坡区', '', 2398, 3, 0),
 ('51142100', '51140000', '仁寿县', '', 2399, 3, 0),
 ('51142200', '51140000', '彭山县', '', 2400, 3, 0),
 ('51142300', '51140000', '洪雅县', '', 2401, 3, 0),
 ('51142400', '51140000', '丹棱县', '', 2402, 3, 0),
 ('51142500', '51140000', '青神县', '', 2403, 3, 0),
 ('51150000', '51000000', '宜宾市', '', 2404, 2, 10),
 ('51150200', '51150000', '翠屏区', '', 2405, 3, 0),
 ('51152100', '51150000', '宜宾县', '', 2406, 3, 0),
 ('51152200', '51150000', '南溪县', '', 2407, 3, 0),
 ('51152300', '51150000', '江安县', '', 2408, 3, 0),
 ('51152400', '51150000', '长宁县', '', 2409, 3, 0),
 ('51152500', '51150000', '高县', '', 2410, 3, 0),
 ('51152600', '51150000', '珙县', '', 2411, 3, 0),
 ('51152700', '51150000', '筠连县', '', 2412, 3, 0),
 ('51152800', '51150000', '兴文县', '', 2413, 3, 0),
 ('51152900', '51150000', '屏山县', '', 2414, 3, 0),
 ('51160000', '51000000', '广安市', '', 2415, 2, 5),
 ('51160200', '51160000', '广安区', '', 2416, 3, 0),
 ('51162100', '51160000', '岳池县', '', 2417, 3, 0),
 ('51162200', '51160000', '武胜县', '', 2418, 3, 0),
 ('51162300', '51160000', '邻水县', '', 2419, 3, 0),
 ('51168100', '51160000', '华莹市', '', 2420, 3, 0),
 ('51170000', '51000000', '达州市', '', 2421, 2, 7),
 ('51170200', '51170000', '通川区', '', 2422, 3, 0),
 ('51172100', '51170000', '达县', '', 2423, 3, 0),
 ('51172200', '51170000', '宣汉县', '', 2424, 3, 0),
 ('51172300', '51170000', '开江县', '', 2425, 3, 0),
 ('51172400', '51170000', '大竹县', '', 2426, 3, 0),
 ('51172500', '51170000', '渠县', '', 2427, 3, 0),
 ('51178100', '51170000', '万源市', '', 2428, 3, 0),
 ('51180000', '51000000', '雅安市', '', 2429, 2, 8),
 ('51180200', '51180000', '雨城区', '', 2430, 3, 0),
 ('51182100', '51180000', '名山县', '', 2431, 3, 0),
 ('51182200', '51180000', '荥经县', '', 2432, 3, 0),
 ('51182300', '51180000', '汉源县', '', 2433, 3, 0),
 ('51182400', '51180000', '石棉县', '', 2434, 3, 0),
 ('51182500', '51180000', '天全县', '', 2435, 3, 0),
 ('51182600', '51180000', '芦山县', '', 2436, 3, 0),
 ('51182700', '51180000', '宝兴县', '', 2437, 3, 0),
 ('51190000', '51000000', '巴中市', '', 2438, 2, 4),
 ('51190200', '51190000', '巴州区', '', 2439, 3, 0),
 ('51192100', '51190000', '通江县', '', 2440, 3, 0),
 ('51192200', '51190000', '南江县', '', 2441, 3, 0),
 ('51192300', '51190000', '平昌县', '', 2442, 3, 0),
 ('51200000', '51000000', '资阳市', '', 2443, 2, 4),
 ('51200200', '51200000', '雁江区', '', 2444, 3, 0),
 ('51202100', '51200000', '安岳县', '', 2445, 3, 0),
 ('51202200', '51200000', '乐至县', '', 2446, 3, 0),
 ('51208100', '51200000', '简阳市', '', 2447, 3, 0),
 ('51320000', '51000000', '阿坝藏族羌族自治州', '', 2448, 2, 13),
 ('51322100', '51320000', '汶川县', '', 2449, 3, 0),
 ('51322200', '51320000', '理县', '', 2450, 3, 0),
 ('51322300', '51320000', '茂县', '', 2451, 3, 0),
 ('51322400', '51320000', '松潘县', '', 2452, 3, 0),
 ('51322500', '51320000', '九寨沟县', '', 2453, 3, 0),
 ('51322600', '51320000', '金川县', '', 2454, 3, 0),
 ('51322700', '51320000', '小金县', '', 2455, 3, 0),
 ('51322800', '51320000', '黑水县', '', 2456, 3, 0),
 ('51322900', '51320000', '马尔康县', '', 2457, 3, 0),
 ('51323000', '51320000', '壤塘县', '', 2458, 3, 0),
 ('51323100', '51320000', '阿坝县', '', 2459, 3, 0),
 ('51323200', '51320000', '若尔盖县', '', 2460, 3, 0),
 ('51323300', '51320000', '红原县', '', 2461, 3, 0),
 ('51330000', '51000000', '甘孜藏族自治州', '', 2462, 2, 18),
 ('51332100', '51330000', '康定县', '', 2463, 3, 0),
 ('51332200', '51330000', '泸定县', '', 2464, 3, 0),
 ('51332300', '51330000', '丹巴县', '', 2465, 3, 0),
 ('51332400', '51330000', '九龙县', '', 2466, 3, 0),
 ('51332500', '51330000', '雅江县', '', 2467, 3, 0),
 ('51332600', '51330000', '道孚县', '', 2468, 3, 0),
 ('51332700', '51330000', '炉霍县', '', 2469, 3, 0),
 ('51332800', '51330000', '甘孜县', '', 2470, 3, 0),
 ('51332900', '51330000', '新龙县', '', 2471, 3, 0),
 ('51333000', '51330000', '德格县', '', 2472, 3, 0),
 ('51333100', '51330000', '白玉县', '', 2473, 3, 0),
 ('51333200', '51330000', '石渠县', '', 2474, 3, 0),
 ('51333300', '51330000', '色达县', '', 2475, 3, 0),
 ('51333400', '51330000', '理塘县', '', 2476, 3, 0),
 ('51333500', '51330000', '巴塘县', '', 2477, 3, 0),
 ('51333600', '51330000', '乡城县', '', 2478, 3, 0),
 ('51333700', '51330000', '稻城县', '', 2479, 3, 0),
 ('51333800', '51330000', '得荣县', '', 2480, 3, 0),
 ('51340000', '51000000', '凉山彝族自治州', '', 2481, 2, 17),
 ('51340100', '51340000', '西昌市', '', 2482, 3, 0),
 ('51342200', '51340000', '木里藏族自治县', '', 2483, 3, 0),
 ('51342300', '51340000', '盐源县', '', 2484, 3, 0),
 ('51342400', '51340000', '德昌县', '', 2485, 3, 0),
 ('51342500', '51340000', '会理县', '', 2486, 3, 0),
 ('51342600', '51340000', '会东县', '', 2487, 3, 0),
 ('51342700', '51340000', '宁南县', '', 2488, 3, 0),
 ('51342800', '51340000', '普格县', '', 2489, 3, 0),
 ('51342900', '51340000', '布拖县', '', 2490, 3, 0),
 ('51343000', '51340000', '金阳县', '', 2491, 3, 0),
 ('51343100', '51340000', '昭觉县', '', 2492, 3, 0),
 ('51343200', '51340000', '喜德县', '', 2493, 3, 0),
 ('51343300', '51340000', '冕宁县', '', 2494, 3, 0),
 ('51343400', '51340000', '越西县', '', 2495, 3, 0),
 ('51343500', '51340000', '甘洛县', '', 2496, 3, 0),
 ('51343600', '51340000', '美姑县', '', 2497, 3, 0),
 ('51343700', '51340000', '雷波县', '', 2498, 3, 0),
 ('52000000', 'A1560000', '贵州省', '', 2499, 1, 9),
 ('52010000', '52000000', '贵阳市', '', 2500, 2, 10),
 ('52010200', '52010000', '南明区', '', 2501, 3, 0),
 ('52010300', '52010000', '云岩区', '', 2502, 3, 0),
 ('52011100', '52010000', '花溪区', '', 2503, 3, 0),
 ('52011200', '52010000', '乌当区', '', 2504, 3, 0),
 ('52011300', '52010000', '白云区', '', 2505, 3, 0),
 ('52011400', '52010000', '小河区', '', 2506, 3, 0),
 ('52012100', '52010000', '开阳县', '', 2507, 3, 0),
 ('52012200', '52010000', '息烽县', '', 2508, 3, 0),
 ('52012300', '52010000', '修文县', '', 2509, 3, 0),
 ('52018100', '52010000', '清镇市', '', 2510, 3, 0),
 ('52020000', '52000000', '六盘水市', '', 2511, 2, 4),
 ('52020100', '52020000', '钟山区', '', 2512, 3, 0),
 ('52020300', '52020000', '六枝特区', '', 2513, 3, 0),
 ('52022100', '52020000', '水城县', '', 2514, 3, 0),
 ('52022200', '52020000', '盘县', '', 2515, 3, 0),
 ('52030000', '52000000', '遵义市', '', 2516, 2, 14),
 ('52030200', '52030000', '红花岗区', '', 2517, 3, 0),
 ('52030300', '52030000', '汇川区', '', 2518, 3, 0),
 ('52032100', '52030000', '遵义县', '', 2519, 3, 0),
 ('52032200', '52030000', '桐梓县', '', 2520, 3, 0),
 ('52032300', '52030000', '绥阳县', '', 2521, 3, 0),
 ('52032400', '52030000', '正安县', '', 2522, 3, 0),
 ('52032500', '52030000', '道真仡佬族苗族自治县', '', 2523, 3, 0),
 ('52032600', '52030000', '务川仡佬族苗族自治县', '', 2524, 3, 0),
 ('52032700', '52030000', '凤冈县', '', 2525, 3, 0),
 ('52032800', '52030000', '湄潭县', '', 2526, 3, 0),
 ('52032900', '52030000', '余庆县', '', 2527, 3, 0),
 ('52033000', '52030000', '习水县', '', 2528, 3, 0),
 ('52038100', '52030000', '赤水市', '', 2529, 3, 0),
 ('52038200', '52030000', '仁怀市', '', 2530, 3, 0),
 ('52040000', '52000000', '安顺市', '', 2531, 2, 6),
 ('52040200', '52040000', '西秀区', '', 2532, 3, 0),
 ('52042100', '52040000', '平坝县', '', 2533, 3, 0),
 ('52042200', '52040000', '普定县', '', 2534, 3, 0),
 ('52042300', '52040000', '镇宁布依族苗族自治县', '', 2535, 3, 0),
 ('52042400', '52040000', '关岭布依族苗族自治县', '', 2536, 3, 0),
 ('52042500', '52040000', '紫云苗族布依族自治县', '', 2537, 3, 0),
 ('52220000', '52000000', '铜仁地区', '', 2538, 2, 10),
 ('52220100', '52220000', '铜仁市', '', 2539, 3, 0),
 ('52222200', '52220000', '江口县', '', 2540, 3, 0),
 ('52222300', '52220000', '玉屏侗族自治县', '', 2541, 3, 0),
 ('52222400', '52220000', '石阡县', '', 2542, 3, 0),
 ('52222500', '52220000', '思南县', '', 2543, 3, 0),
 ('52222600', '52220000', '印江土家族苗族自治县', '', 2544, 3, 0),
 ('52222700', '52220000', '德江县', '', 2545, 3, 0),
 ('52222800', '52220000', '沿河土家族自治县', '', 2546, 3, 0),
 ('52222900', '52220000', '松桃苗族自治县', '', 2547, 3, 0),
 ('52223000', '52220000', '万山特区', '', 2548, 3, 0),
 ('52230000', '52000000', '黔西南布依族苗族自治州', '', 2549, 2, 8),
 ('52230100', '52230000', '兴义市', '', 2550, 3, 0),
 ('52232200', '52230000', '兴仁县', '', 2551, 3, 0),
 ('52232300', '52230000', '普安县', '', 2552, 3, 0),
 ('52232400', '52230000', '晴隆县', '', 2553, 3, 0),
 ('52232500', '52230000', '贞丰县', '', 2554, 3, 0),
 ('52232600', '52230000', '望谟县', '', 2555, 3, 0),
 ('52232700', '52230000', '册亨县', '', 2556, 3, 0),
 ('52232800', '52230000', '安龙县', '', 2557, 3, 0),
 ('52240000', '52000000', '毕节地区', '', 2558, 2, 8),
 ('52240100', '52240000', '毕节市', '', 2559, 3, 0),
 ('52242200', '52240000', '大方县', '', 2560, 3, 0),
 ('52242300', '52240000', '黔西县', '', 2561, 3, 0),
 ('52242400', '52240000', '金沙县', '', 2562, 3, 0),
 ('52242500', '52240000', '织金县', '', 2563, 3, 0),
 ('52242600', '52240000', '纳雍县', '', 2564, 3, 0),
 ('52242700', '52240000', '威宁彝族回族苗族自治县', '', 2565, 3, 0),
 ('52242800', '52240000', '赫章县', '', 2566, 3, 0),
 ('52260000', '52000000', '黔东南苗族侗族自治州', '', 2567, 2, 16),
 ('52260100', '52260000', '凯里市', '', 2568, 3, 0),
 ('52262200', '52260000', '黄平县', '', 2569, 3, 0),
 ('52262300', '52260000', '施秉县', '', 2570, 3, 0),
 ('52262400', '52260000', '三穗县', '', 2571, 3, 0),
 ('52262500', '52260000', '镇远县', '', 2572, 3, 0),
 ('52262600', '52260000', '岑巩县', '', 2573, 3, 0),
 ('52262700', '52260000', '天柱县', '', 2574, 3, 0),
 ('52262800', '52260000', '锦屏县', '', 2575, 3, 0),
 ('52262900', '52260000', '剑河县', '', 2576, 3, 0),
 ('52263000', '52260000', '台江县', '', 2577, 3, 0),
 ('52263100', '52260000', '黎平县', '', 2578, 3, 0),
 ('52263200', '52260000', '榕江县', '', 2579, 3, 0),
 ('52263300', '52260000', '从江县', '', 2580, 3, 0),
 ('52263400', '52260000', '雷山县', '', 2581, 3, 0),
 ('52263500', '52260000', '麻江县', '', 2582, 3, 0),
 ('52263600', '52260000', '丹寨县', '', 2583, 3, 0),
 ('52270000', '52000000', '黔南布依族苗族自治州', '', 2584, 2, 12),
 ('52270100', '52270000', '都匀市', '', 2585, 3, 0),
 ('52270200', '52270000', '福泉市', '', 2586, 3, 0),
 ('52272200', '52270000', '荔波县', '', 2587, 3, 0),
 ('52272300', '52270000', '贵定县', '', 2588, 3, 0),
 ('52272500', '52270000', '瓮安县', '', 2589, 3, 0),
 ('52272600', '52270000', '独山县', '', 2590, 3, 0),
 ('52272700', '52270000', '平塘县', '', 2591, 3, 0),
 ('52272800', '52270000', '罗甸县', '', 2592, 3, 0),
 ('52272900', '52270000', '长顺县', '', 2593, 3, 0),
 ('52273000', '52270000', '龙里县', '', 2594, 3, 0),
 ('52273100', '52270000', '惠水县', '', 2595, 3, 0),
 ('52273200', '52270000', '三都水族自治县', '', 2596, 3, 0),
 ('53000000', 'A1560000', '云南省', '', 2597, 1, 16),
 ('53010000', '53000000', '昆明市', '', 2598, 2, 14),
 ('53010200', '53010000', '五华区', '', 2599, 3, 0),
 ('53010300', '53010000', '盘龙区', '', 2600, 3, 0),
 ('53011100', '53010000', '官渡区', '', 2601, 3, 0),
 ('53011200', '53010000', '西山区', '', 2602, 3, 0),
 ('53011300', '53010000', '东川区', '', 2603, 3, 0),
 ('53012100', '53010000', '呈贡县', '', 2604, 3, 0),
 ('53012200', '53010000', '晋宁县', '', 2605, 3, 0),
 ('53012400', '53010000', '富民县', '', 2606, 3, 0),
 ('53012500', '53010000', '宜良县', '', 2607, 3, 0),
 ('53012600', '53010000', '石林彝族自治县', '', 2608, 3, 0),
 ('53012700', '53010000', '嵩明县', '', 2609, 3, 0),
 ('53012800', '53010000', '禄劝彝族苗族自治县', '', 2610, 3, 0),
 ('53012900', '53010000', '寻甸回族彝族自治县', '', 2611, 3, 0),
 ('53018100', '53010000', '安宁市', '', 2612, 3, 0),
 ('53030000', '53000000', '曲靖市', '', 2613, 2, 9),
 ('53030200', '53030000', '麒麟区', '', 2614, 3, 0),
 ('53032100', '53030000', '马龙县', '', 2615, 3, 0),
 ('53032200', '53030000', '陆良县', '', 2616, 3, 0),
 ('53032300', '53030000', '师宗县', '', 2617, 3, 0),
 ('53032400', '53030000', '罗平县', '', 2618, 3, 0),
 ('53032500', '53030000', '富源县', '', 2619, 3, 0),
 ('53032600', '53030000', '会泽县', '', 2620, 3, 0),
 ('53032800', '53030000', '沾益县', '', 2621, 3, 0),
 ('53038100', '53030000', '宣威市', '', 2622, 3, 0),
 ('53040000', '53000000', '玉溪市', '', 2623, 2, 9),
 ('53040200', '53040000', '红塔区', '', 2624, 3, 0),
 ('53042100', '53040000', '江川县', '', 2625, 3, 0),
 ('53042200', '53040000', '澄江县', '', 2626, 3, 0),
 ('53042300', '53040000', '通海县', '', 2627, 3, 0),
 ('53042400', '53040000', '华宁县', '', 2628, 3, 0),
 ('53042500', '53040000', '易门县', '', 2629, 3, 0),
 ('53042600', '53040000', '峨山彝族自治县', '', 2630, 3, 0),
 ('53042700', '53040000', '新平彝族傣族自治县', '', 2631, 3, 0),
 ('53042800', '53040000', '元江哈尼族彝族傣族自治县', '', 2632, 3, 0),
 ('53050000', '53000000', '保山市', '', 2633, 2, 5),
 ('53050200', '53050000', '隆阳区', '', 2634, 3, 0),
 ('53052100', '53050000', '施甸县', '', 2635, 3, 0),
 ('53052200', '53050000', '腾冲县', '', 2636, 3, 0),
 ('53052300', '53050000', '龙陵县', '', 2637, 3, 0),
 ('53052400', '53050000', '昌宁县', '', 2638, 3, 0),
 ('53060000', '53000000', '昭通市', '', 2639, 2, 11),
 ('53060200', '53060000', '昭阳区', '', 2640, 3, 0),
 ('53062100', '53060000', '鲁甸县', '', 2641, 3, 0),
 ('53062200', '53060000', '巧家县', '', 2642, 3, 0),
 ('53062300', '53060000', '盐津县', '', 2643, 3, 0),
 ('53062400', '53060000', '大关县', '', 2644, 3, 0),
 ('53062500', '53060000', '永善县', '', 2645, 3, 0),
 ('53062600', '53060000', '绥江县', '', 2646, 3, 0),
 ('53062700', '53060000', '镇雄县', '', 2647, 3, 0),
 ('53062800', '53060000', '彝良县', '', 2648, 3, 0),
 ('53062900', '53060000', '威信县', '', 2649, 3, 0),
 ('53063000', '53060000', '水富县', '', 2650, 3, 0),
 ('53070000', '53000000', '丽江市', '', 2651, 2, 5),
 ('53070200', '53070000', '古城区', '', 2652, 3, 0),
 ('53072100', '53070000', '玉龙纳西族自治县', '', 2653, 3, 0),
 ('53072200', '53070000', '永胜县', '', 2654, 3, 0),
 ('53072300', '53070000', '华坪县', '', 2655, 3, 0),
 ('53072400', '53070000', '宁蒗彝族自治县', '', 2656, 3, 0),
 ('53080000', '53000000', '思茅市', '', 2657, 2, 10),
 ('53080200', '53080000', '翠云区', '', 2658, 3, 0),
 ('53082100', '53080000', '普洱哈尼族彝族自治县', '', 2659, 3, 0),
 ('53082200', '53080000', '墨江哈尼族自治县', '', 2660, 3, 0),
 ('53082300', '53080000', '景东彝族自治县', '', 2661, 3, 0),
 ('53082400', '53080000', '景谷傣族彝族自治县', '', 2662, 3, 0),
 ('53082500', '53080000', '镇沅彝族哈尼族拉祜族自治县', '', 2663, 3, 0),
 ('53082600', '53080000', '江城哈尼族彝族自治县', '', 2664, 3, 0),
 ('53082700', '53080000', '孟连傣族拉祜族佤族自治县', '', 2665, 3, 0),
 ('53082800', '53080000', '澜沧拉祜族自治县', '', 2666, 3, 0),
 ('53082900', '53080000', '西盟佤族自治县', '', 2667, 3, 0),
 ('53090000', '53000000', '临沧市', '', 2668, 2, 8),
 ('53090200', '53090000', '临翔区', '', 2669, 3, 0),
 ('53092100', '53090000', '凤庆县', '', 2670, 3, 0),
 ('53092200', '53090000', '云县', '', 2671, 3, 0),
 ('53092300', '53090000', '永德县', '', 2672, 3, 0),
 ('53092400', '53090000', '镇康县', '', 2673, 3, 0),
 ('53092500', '53090000', '双江拉祜族佤族布朗族傣族自治县', '', 2674, 3, 0),
 ('53092600', '53090000', '耿马傣族佤族自治县', '', 2675, 3, 0),
 ('53092700', '53090000', '沧源佤族自治县', '', 2676, 3, 0),
 ('53230000', '53000000', '楚雄彝族自治州', '', 2677, 2, 10),
 ('53230100', '53230000', '楚雄市', '', 2678, 3, 0),
 ('53232200', '53230000', '双柏县', '', 2679, 3, 0),
 ('53232300', '53230000', '牟定县', '', 2680, 3, 0),
 ('53232400', '53230000', '南华县', '', 2681, 3, 0),
 ('53232500', '53230000', '姚安县', '', 2682, 3, 0),
 ('53232600', '53230000', '大姚县', '', 2683, 3, 0),
 ('53232700', '53230000', '永仁县', '', 2684, 3, 0),
 ('53232800', '53230000', '元谋县', '', 2685, 3, 0),
 ('53232900', '53230000', '武定县', '', 2686, 3, 0),
 ('53233100', '53230000', '禄丰县', '', 2687, 3, 0),
 ('53250000', '53000000', '红河哈尼族彝族自治州', '', 2688, 2, 13),
 ('53250100', '53250000', '个旧市', '', 2689, 3, 0),
 ('53250200', '53250000', '开远市', '', 2690, 3, 0),
 ('53252200', '53250000', '蒙自县', '', 2691, 3, 0),
 ('53252300', '53250000', '屏边苗族自治县', '', 2692, 3, 0),
 ('53252400', '53250000', '建水县', '', 2693, 3, 0),
 ('53252500', '53250000', '石屏县', '', 2694, 3, 0),
 ('53252600', '53250000', '弥勒县', '', 2695, 3, 0),
 ('53252700', '53250000', '泸西县', '', 2696, 3, 0),
 ('53252800', '53250000', '元阳县', '', 2697, 3, 0),
 ('53252900', '53250000', '红河县', '', 2698, 3, 0),
 ('53253000', '53250000', '金平苗族瑶族傣族自治县', '', 2699, 3, 0),
 ('53253100', '53250000', '绿春县', '', 2700, 3, 0),
 ('53253200', '53250000', '河口瑶族自治县', '', 2701, 3, 0),
 ('53260000', '53000000', '文山壮族苗族自治州', '', 2702, 2, 8),
 ('53262100', '53260000', '文山县', '', 2703, 3, 0),
 ('53262200', '53260000', '砚山县', '', 2704, 3, 0),
 ('53262300', '53260000', '西畴县', '', 2705, 3, 0),
 ('53262400', '53260000', '麻栗坡县', '', 2706, 3, 0),
 ('53262500', '53260000', '马关县', '', 2707, 3, 0),
 ('53262600', '53260000', '丘北县', '', 2708, 3, 0),
 ('53262700', '53260000', '广南县', '', 2709, 3, 0),
 ('53262800', '53260000', '富宁县', '', 2710, 3, 0),
 ('53280000', '53000000', '西双版纳傣族自治州', '', 2711, 2, 3),
 ('53280100', '53280000', '景洪市', '', 2712, 3, 0),
 ('53282200', '53280000', '勐海县', '', 2713, 3, 0),
 ('53282300', '53280000', '勐腊县', '', 2714, 3, 0),
 ('53290000', '53000000', '大理白族自治州', '', 2715, 2, 12),
 ('53290100', '53290000', '大理市', '', 2716, 3, 0),
 ('53292200', '53290000', '漾濞彝族自治县', '', 2717, 3, 0),
 ('53292300', '53290000', '祥云县', '', 2718, 3, 0),
 ('53292400', '53290000', '宾川县', '', 2719, 3, 0),
 ('53292500', '53290000', '弥渡县', '', 2720, 3, 0),
 ('53292600', '53290000', '南涧彝族自治县', '', 2721, 3, 0),
 ('53292700', '53290000', '巍山彝族回族自治县', '', 2722, 3, 0),
 ('53292800', '53290000', '永平县', '', 2723, 3, 0),
 ('53292900', '53290000', '云龙县', '', 2724, 3, 0),
 ('53293000', '53290000', '洱源县', '', 2725, 3, 0),
 ('53293100', '53290000', '剑川县', '', 2726, 3, 0),
 ('53293200', '53290000', '鹤庆县', '', 2727, 3, 0),
 ('53310000', '53000000', '德宏傣族景颇族自治州', '', 2728, 2, 5),
 ('53310200', '53310000', '瑞丽市', '', 2729, 3, 0),
 ('53310300', '53310000', '潞西市', '', 2730, 3, 0),
 ('53312200', '53310000', '梁河县', '', 2731, 3, 0),
 ('53312300', '53310000', '盈江县', '', 2732, 3, 0),
 ('53312400', '53310000', '陇川县', '', 2733, 3, 0),
 ('53330000', '53000000', '怒江傈僳族自治州', '', 2734, 2, 4),
 ('53332100', '53330000', '泸水县', '', 2735, 3, 0),
 ('53332300', '53330000', '福贡县', '', 2736, 3, 0),
 ('53332400', '53330000', '贡山独龙族怒族自治县', '', 2737, 3, 0),
 ('53332500', '53330000', '兰坪白族普米族自治县', '', 2738, 3, 0),
 ('53340000', '53000000', '迪庆藏族自治州', '', 2739, 2, 3),
 ('53342100', '53340000', '香格里拉县', '', 2740, 3, 0),
 ('53342200', '53340000', '德钦县', '', 2741, 3, 0),
 ('53342300', '53340000', '维西傈僳族自治县', '', 2742, 3, 0),
 ('54000000', 'A1560000', '西藏自治区', '', 2743, 1, 7),
 ('54010000', '54000000', '拉萨市', '', 2744, 2, 8),
 ('54010200', '54010000', '城关区', '', 2745, 3, 0),
 ('54012100', '54010000', '林周县', '', 2746, 3, 0),
 ('54012200', '54010000', '当雄县', '', 2747, 3, 0),
 ('54012300', '54010000', '尼木县', '', 2748, 3, 0),
 ('54012400', '54010000', '曲水县', '', 2749, 3, 0),
 ('54012500', '54010000', '堆龙德庆县', '', 2750, 3, 0),
 ('54012600', '54010000', '达孜县', '', 2751, 3, 0),
 ('54012700', '54010000', '墨竹工卡县', '', 2752, 3, 0),
 ('54210000', '54000000', '昌都地区', '', 2753, 2, 11),
 ('54212100', '54210000', '昌都县', '', 2754, 3, 0),
 ('54212200', '54210000', '江达县', '', 2755, 3, 0),
 ('54212300', '54210000', '贡觉县', '', 2756, 3, 0),
 ('54212400', '54210000', '类乌齐县', '', 2757, 3, 0),
 ('54212500', '54210000', '丁青县', '', 2758, 3, 0),
 ('54212600', '54210000', '察雅县', '', 2759, 3, 0),
 ('54212700', '54210000', '八宿县', '', 2760, 3, 0),
 ('54212800', '54210000', '左贡县', '', 2761, 3, 0),
 ('54212900', '54210000', '芒康县', '', 2762, 3, 0),
 ('54213200', '54210000', '洛隆县', '', 2763, 3, 0),
 ('54213300', '54210000', '边坝县', '', 2764, 3, 0),
 ('54220000', '54000000', '山南地区', '', 2765, 2, 12),
 ('54222100', '54220000', '乃东县', '', 2766, 3, 0),
 ('54222200', '54220000', '扎囊县', '', 2767, 3, 0),
 ('54222300', '54220000', '贡嘎县', '', 2768, 3, 0),
 ('54222400', '54220000', '桑日县', '', 2769, 3, 0),
 ('54222500', '54220000', '琼结县', '', 2770, 3, 0),
 ('54222600', '54220000', '曲松县', '', 2771, 3, 0),
 ('54222700', '54220000', '措美县', '', 2772, 3, 0),
 ('54222800', '54220000', '洛扎县', '', 2773, 3, 0),
 ('54222900', '54220000', '加查县', '', 2774, 3, 0),
 ('54223100', '54220000', '隆子县', '', 2775, 3, 0),
 ('54223200', '54220000', '错那县', '', 2776, 3, 0),
 ('54223300', '54220000', '浪卡子县', '', 2777, 3, 0),
 ('54230000', '54000000', '日喀则地区', '', 2778, 2, 18),
 ('54230100', '54230000', '日喀则市', '', 2779, 3, 0),
 ('54232200', '54230000', '南木林县', '', 2780, 3, 0),
 ('54232300', '54230000', '江孜县', '', 2781, 3, 0),
 ('54232400', '54230000', '定日县', '', 2782, 3, 0),
 ('54232500', '54230000', '萨迦县', '', 2783, 3, 0),
 ('54232600', '54230000', '拉孜县', '', 2784, 3, 0),
 ('54232700', '54230000', '昂仁县', '', 2785, 3, 0),
 ('54232800', '54230000', '谢通门县', '', 2786, 3, 0),
 ('54232900', '54230000', '白朗县', '', 2787, 3, 0),
 ('54233000', '54230000', '仁布县', '', 2788, 3, 0),
 ('54233100', '54230000', '康马县', '', 2789, 3, 0),
 ('54233200', '54230000', '定结县', '', 2790, 3, 0),
 ('54233300', '54230000', '仲巴县', '', 2791, 3, 0),
 ('54233400', '54230000', '亚东县', '', 2792, 3, 0),
 ('54233500', '54230000', '吉隆县', '', 2793, 3, 0),
 ('54233600', '54230000', '聂拉木县', '', 2794, 3, 0),
 ('54233700', '54230000', '萨嘎县', '', 2795, 3, 0),
 ('54233800', '54230000', '岗巴县', '', 2796, 3, 0),
 ('54240000', '54000000', '那曲地区', '', 2797, 2, 10),
 ('54242100', '54240000', '那曲县', '', 2798, 3, 0),
 ('54242200', '54240000', '嘉黎县', '', 2799, 3, 0),
 ('54242300', '54240000', '比如县', '', 2800, 3, 0),
 ('54242400', '54240000', '聂荣县', '', 2801, 3, 0),
 ('54242500', '54240000', '安多县', '', 2802, 3, 0),
 ('54242600', '54240000', '申扎县', '', 2803, 3, 0),
 ('54242700', '54240000', '索县', '', 2804, 3, 0),
 ('54242800', '54240000', '班戈县', '', 2805, 3, 0),
 ('54242900', '54240000', '巴青县', '', 2806, 3, 0),
 ('54243000', '54240000', '尼玛县', '', 2807, 3, 0),
 ('54250000', '54000000', '阿里地区', '', 2808, 2, 7),
 ('54252100', '54250000', '普兰县', '', 2809, 3, 0),
 ('54252200', '54250000', '札达县', '', 2810, 3, 0),
 ('54252300', '54250000', '噶尔县', '', 2811, 3, 0),
 ('54252400', '54250000', '日土县', '', 2812, 3, 0),
 ('54252500', '54250000', '革吉县', '', 2813, 3, 0),
 ('54252600', '54250000', '改则县', '', 2814, 3, 0),
 ('54252700', '54250000', '措勤县', '', 2815, 3, 0),
 ('54260000', '54000000', '林芝地区', '', 2816, 2, 7),
 ('54262100', '54260000', '林芝县', '', 2817, 3, 0),
 ('54262200', '54260000', '工布江达县', '', 2818, 3, 0),
 ('54262300', '54260000', '米林县', '', 2819, 3, 0),
 ('54262400', '54260000', '墨脱县', '', 2820, 3, 0),
 ('54262500', '54260000', '波密县', '', 2821, 3, 0),
 ('54262600', '54260000', '察隅县', '', 2822, 3, 0),
 ('54262700', '54260000', '朗县', '', 2823, 3, 0);
  INSERT `tn_Areas` (`AreaCode`, `ParentCode`, `Name`, `PostCode`, `DisplayOrder`, `Depth`, `ChildCount`)
 VALUES
 ('61000000', 'A1560000', '陕西省', '', 2824, 1, 10),
 ('61010000', '61000000', '西安市', '', 2825, 2, 13),
 ('61010200', '61010000', '新城区', '', 2826, 3, 0),
 ('61010300', '61010000', '碑林区', '', 2827, 3, 0),
 ('61010400', '61010000', '莲湖区', '', 2828, 3, 0),
 ('61011100', '61010000', '灞桥区', '', 2829, 3, 0),
 ('61011200', '61010000', '未央区', '', 2830, 3, 0),
 ('61011300', '61010000', '雁塔区', '', 2831, 3, 0),
 ('61011400', '61010000', '阎良区', '', 2832, 3, 0),
 ('61011500', '61010000', '临潼区', '', 2833, 3, 0),
 ('61011600', '61010000', '长安区', '', 2834, 3, 0),
 ('61012200', '61010000', '蓝田县', '', 2835, 3, 0),
 ('61012400', '61010000', '周至县', '', 2836, 3, 0),
 ('61012500', '61010000', '户县', '', 2837, 3, 0),
 ('61012600', '61010000', '高陵县', '', 2838, 3, 0),
 ('61020000', '61000000', '铜川市', '', 2839, 2, 4),
 ('61020200', '61020000', '王益区', '', 2840, 3, 0),
 ('61020300', '61020000', '印台区', '', 2841, 3, 0),
 ('61020400', '61020000', '耀州区', '', 2842, 3, 0),
 ('61022200', '61020000', '宜君县', '', 2843, 3, 0),
 ('61030000', '61000000', '宝鸡市', '', 2844, 2, 12),
 ('61030200', '61030000', '渭滨区', '', 2845, 3, 0),
 ('61030300', '61030000', '金台区', '', 2846, 3, 0),
 ('61030400', '61030000', '陈仓区', '', 2847, 3, 0),
 ('61032200', '61030000', '凤翔县', '', 2848, 3, 0),
 ('61032300', '61030000', '岐山县', '', 2849, 3, 0),
 ('61032400', '61030000', '扶风县', '', 2850, 3, 0),
 ('61032600', '61030000', '眉县', '', 2851, 3, 0),
 ('61032700', '61030000', '陇县', '', 2852, 3, 0),
 ('61032800', '61030000', '千阳县', '', 2853, 3, 0),
 ('61032900', '61030000', '麟游县', '', 2854, 3, 0),
 ('61033000', '61030000', '凤县', '', 2855, 3, 0),
 ('61033100', '61030000', '太白县', '', 2856, 3, 0),
 ('61040000', '61000000', '咸阳市', '', 2857, 2, 14),
 ('61040200', '61040000', '秦都区', '', 2858, 3, 0),
 ('61040300', '61040000', '杨陵区', '', 2859, 3, 0),
 ('61040400', '61040000', '渭城区', '', 2860, 3, 0),
 ('61042200', '61040000', '三原县', '', 2861, 3, 0),
 ('61042300', '61040000', '泾阳县', '', 2862, 3, 0),
 ('61042400', '61040000', '乾县', '', 2863, 3, 0),
 ('61042500', '61040000', '礼泉县', '', 2864, 3, 0),
 ('61042600', '61040000', '永寿县', '', 2865, 3, 0),
 ('61042700', '61040000', '彬县', '', 2866, 3, 0),
 ('61042800', '61040000', '长武县', '', 2867, 3, 0),
 ('61042900', '61040000', '旬邑县', '', 2868, 3, 0),
 ('61043000', '61040000', '淳化县', '', 2869, 3, 0),
 ('61043100', '61040000', '武功县', '', 2870, 3, 0),
 ('61048100', '61040000', '兴平市', '', 2871, 3, 0),
 ('61050000', '61000000', '渭南市', '', 2872, 2, 11),
 ('61050200', '61050000', '临渭区', '', 2873, 3, 0),
 ('61052100', '61050000', '华县', '', 2874, 3, 0),
 ('61052200', '61050000', '潼关县', '', 2875, 3, 0),
 ('61052300', '61050000', '大荔县', '', 2876, 3, 0),
 ('61052400', '61050000', '合阳县', '', 2877, 3, 0),
 ('61052500', '61050000', '澄城县', '', 2878, 3, 0),
 ('61052600', '61050000', '蒲城县', '', 2879, 3, 0),
 ('61052700', '61050000', '白水县', '', 2880, 3, 0),
 ('61052800', '61050000', '富平县', '', 2881, 3, 0),
 ('61058100', '61050000', '韩城市', '', 2882, 3, 0),
 ('61058200', '61050000', '华阴市', '', 2883, 3, 0),
 ('61060000', '61000000', '延安市', '', 2884, 2, 13),
 ('61060200', '61060000', '宝塔区', '', 2885, 3, 0),
 ('61062100', '61060000', '延长县', '', 2886, 3, 0),
 ('61062200', '61060000', '延川县', '', 2887, 3, 0),
 ('61062300', '61060000', '子长县', '', 2888, 3, 0),
 ('61062400', '61060000', '安塞县', '', 2889, 3, 0),
 ('61062500', '61060000', '志丹县', '', 2890, 3, 0),
 ('61062600', '61060000', '吴旗县', '', 2891, 3, 0),
 ('61062700', '61060000', '甘泉县', '', 2892, 3, 0),
 ('61062800', '61060000', '富县', '', 2893, 3, 0),
 ('61062900', '61060000', '洛川县', '', 2894, 3, 0),
 ('61063000', '61060000', '宜川县', '', 2895, 3, 0),
 ('61063100', '61060000', '黄龙县', '', 2896, 3, 0),
 ('61063200', '61060000', '黄陵县', '', 2897, 3, 0),
 ('61070000', '61000000', '汉中市', '', 2898, 2, 11),
 ('61070200', '61070000', '汉台区', '', 2899, 3, 0),
 ('61072100', '61070000', '南郑县', '', 2900, 3, 0),
 ('61072200', '61070000', '城固县', '', 2901, 3, 0),
 ('61072300', '61070000', '洋县', '', 2902, 3, 0),
 ('61072400', '61070000', '西乡县', '', 2903, 3, 0),
 ('61072500', '61070000', '勉县', '', 2904, 3, 0),
 ('61072600', '61070000', '宁强县', '', 2905, 3, 0),
 ('61072700', '61070000', '略阳县', '', 2906, 3, 0),
 ('61072800', '61070000', '镇巴县', '', 2907, 3, 0),
 ('61072900', '61070000', '留坝县', '', 2908, 3, 0),
 ('61073000', '61070000', '佛坪县', '', 2909, 3, 0),
 ('61080000', '61000000', '榆林市', '', 2910, 2, 12),
 ('61080200', '61080000', '榆阳区', '', 2911, 3, 0),
 ('61082100', '61080000', '神木县', '', 2912, 3, 0),
 ('61082200', '61080000', '府谷县', '', 2913, 3, 0),
 ('61082300', '61080000', '横山县', '', 2914, 3, 0),
 ('61082400', '61080000', '靖边县', '', 2915, 3, 0),
 ('61082500', '61080000', '定边县', '', 2916, 3, 0),
 ('61082600', '61080000', '绥德县', '', 2917, 3, 0),
 ('61082700', '61080000', '米脂县', '', 2918, 3, 0),
 ('61082800', '61080000', '佳县', '', 2919, 3, 0),
 ('61082900', '61080000', '吴堡县', '', 2920, 3, 0),
 ('61083000', '61080000', '清涧县', '', 2921, 3, 0),
 ('61083100', '61080000', '子洲县', '', 2922, 3, 0),
 ('61090000', '61000000', '安康市', '', 2923, 2, 10),
 ('61090200', '61090000', '汉滨区', '', 2924, 3, 0),
 ('61092100', '61090000', '汉阴县', '', 2925, 3, 0),
 ('61092200', '61090000', '石泉县', '', 2926, 3, 0),
 ('61092300', '61090000', '宁陕县', '', 2927, 3, 0),
 ('61092400', '61090000', '紫阳县', '', 2928, 3, 0),
 ('61092500', '61090000', '岚皋县', '', 2929, 3, 0),
 ('61092600', '61090000', '平利县', '', 2930, 3, 0),
 ('61092700', '61090000', '镇坪县', '', 2931, 3, 0),
 ('61092800', '61090000', '旬阳县', '', 2932, 3, 0),
 ('61092900', '61090000', '白河县', '', 2933, 3, 0),
 ('61100000', '61000000', '商洛市', '', 2934, 2, 7),
 ('61100200', '61100000', '商州区', '', 2935, 3, 0),
 ('61102100', '61100000', '洛南县', '', 2936, 3, 0),
 ('61102200', '61100000', '丹凤县', '', 2937, 3, 0),
 ('61102300', '61100000', '商南县', '', 2938, 3, 0),
 ('61102400', '61100000', '山阳县', '', 2939, 3, 0),
 ('61102500', '61100000', '镇安县', '', 2940, 3, 0),
 ('61102600', '61100000', '柞水县', '', 2941, 3, 0),
 ('62000000', 'A1560000', '甘肃省', '', 2942, 1, 14),
 ('62010000', '62000000', '兰州市', '', 2943, 2, 8),
 ('62010200', '62010000', '城关区', '', 2944, 3, 0),
 ('62010300', '62010000', '七里河区', '', 2945, 3, 0),
 ('62010400', '62010000', '西固区', '', 2946, 3, 0),
 ('62010500', '62010000', '安宁区', '', 2947, 3, 0),
 ('62011100', '62010000', '红古区', '', 2948, 3, 0),
 ('62012100', '62010000', '永登县', '', 2949, 3, 0),
 ('62012200', '62010000', '皋兰县', '', 2950, 3, 0),
 ('62012300', '62010000', '榆中县', '', 2951, 3, 0),
 ('62020000', '62000000', '嘉峪关市', '', 2952, 2, 0),
 ('62030000', '62000000', '金昌市', '', 2953, 2, 2),
 ('62030200', '62030000', '金川区', '', 2954, 3, 0),
 ('62032100', '62030000', '永昌县', '', 2955, 3, 0),
 ('62040000', '62000000', '白银市', '', 2956, 2, 5),
 ('62040200', '62040000', '白银区', '', 2957, 3, 0),
 ('62040300', '62040000', '平川区', '', 2958, 3, 0),
 ('62042100', '62040000', '靖远县', '', 2959, 3, 0),
 ('62042200', '62040000', '会宁县', '', 2960, 3, 0),
 ('62042300', '62040000', '景泰县', '', 2961, 3, 0),
 ('62050000', '62000000', '天水市', '', 2962, 2, 7),
 ('62050200', '62050000', '秦卅区', '', 2963, 3, 0),
 ('62050300', '62050000', '麦积区', '', 2964, 3, 0),
 ('62052100', '62050000', '清水县', '', 2965, 3, 0),
 ('62052200', '62050000', '秦安县', '', 2966, 3, 0),
 ('62052300', '62050000', '甘谷县', '', 2967, 3, 0),
 ('62052400', '62050000', '武山县', '', 2968, 3, 0),
 ('62052500', '62050000', '张家川回族自治县', '', 2969, 3, 0),
 ('62060000', '62000000', '武威市', '', 2970, 2, 4),
 ('62060200', '62060000', '凉州区', '', 2971, 3, 0),
 ('62062100', '62060000', '民勤县', '', 2972, 3, 0),
 ('62062200', '62060000', '古浪县', '', 2973, 3, 0),
 ('62062300', '62060000', '天祝藏族自治县', '', 2974, 3, 0),
 ('62070000', '62000000', '张掖市', '', 2975, 2, 6),
 ('62070200', '62070000', '甘州区', '', 2976, 3, 0),
 ('62072100', '62070000', '肃南裕固族自治县', '', 2977, 3, 0),
 ('62072200', '62070000', '民乐县', '', 2978, 3, 0),
 ('62072300', '62070000', '临泽县', '', 2979, 3, 0),
 ('62072400', '62070000', '高台县', '', 2980, 3, 0),
 ('62072500', '62070000', '山丹县', '', 2981, 3, 0),
 ('62080000', '62000000', '平凉市', '', 2982, 2, 7),
 ('62080200', '62080000', '崆峒区', '', 2983, 3, 0),
 ('62082100', '62080000', '泾川县', '', 2984, 3, 0),
 ('62082200', '62080000', '灵台县', '', 2985, 3, 0),
 ('62082300', '62080000', '崇信县', '', 2986, 3, 0),
 ('62082400', '62080000', '华亭县', '', 2987, 3, 0),
 ('62082500', '62080000', '庄浪县', '', 2988, 3, 0),
 ('62082600', '62080000', '静宁县', '', 2989, 3, 0),
 ('62090000', '62000000', '酒泉市', '', 2990, 2, 7),
 ('62090200', '62090000', '肃州区', '', 2991, 3, 0),
 ('62092100', '62090000', '金塔县', '', 2992, 3, 0),
 ('62092200', '62090000', '安西县', '', 2993, 3, 0),
 ('62092300', '62090000', '肃北蒙古族自治县', '', 2994, 3, 0),
 ('62092400', '62090000', '阿克塞哈萨克族自治县', '', 2995, 3, 0),
 ('62098100', '62090000', '玉门市', '', 2996, 3, 0),
 ('62098200', '62090000', '敦煌市', '', 2997, 3, 0),
 ('62100000', '62000000', '庆阳市', '', 2998, 2, 8),
 ('62100200', '62100000', '西峰区', '', 2999, 3, 0),
 ('62102100', '62100000', '庆城县', '', 3000, 3, 0),
 ('62102200', '62100000', '环县', '', 3001, 3, 0),
 ('62102300', '62100000', '华池县', '', 3002, 3, 0),
 ('62102400', '62100000', '合水县', '', 3003, 3, 0),
 ('62102500', '62100000', '正宁县', '', 3004, 3, 0),
 ('62102600', '62100000', '宁县', '', 3005, 3, 0),
 ('62102700', '62100000', '镇原县', '', 3006, 3, 0),
 ('62110000', '62000000', '定西市', '', 3007, 2, 7),
 ('62110200', '62110000', '安定区', '', 3008, 3, 0),
 ('62112100', '62110000', '通渭县', '', 3009, 3, 0),
 ('62112200', '62110000', '陇西县', '', 3010, 3, 0),
 ('62112300', '62110000', '渭源县', '', 3011, 3, 0),
 ('62112400', '62110000', '临洮县', '', 3012, 3, 0),
 ('62112500', '62110000', '漳县', '', 3013, 3, 0),
 ('62112600', '62110000', '岷县', '', 3014, 3, 0),
 ('62120000', '62000000', '陇南市', '', 3015, 2, 9),
 ('62120200', '62120000', '武都区', '', 3016, 3, 0),
 ('62122100', '62120000', '成县', '', 3017, 3, 0),
 ('62122200', '62120000', '文县', '', 3018, 3, 0),
 ('62122300', '62120000', '宕昌县', '', 3019, 3, 0),
 ('62122400', '62120000', '康县', '', 3020, 3, 0),
 ('62122500', '62120000', '西和县', '', 3021, 3, 0),
 ('62122600', '62120000', '礼县', '', 3022, 3, 0),
 ('62122700', '62120000', '徽县', '', 3023, 3, 0),
 ('62122800', '62120000', '两当县', '', 3024, 3, 0),
 ('62290000', '62000000', '临夏回族自治州', '', 3025, 2, 8),
 ('62290100', '62290000', '临夏市', '', 3026, 3, 0),
 ('62292100', '62290000', '临夏县', '', 3027, 3, 0),
 ('62292200', '62290000', '康乐县', '', 3028, 3, 0),
 ('62292300', '62290000', '永靖县', '', 3029, 3, 0),
 ('62292400', '62290000', '广河县', '', 3030, 3, 0),
 ('62292500', '62290000', '和政县', '', 3031, 3, 0),
 ('62292600', '62290000', '东乡族自治县', '', 3032, 3, 0),
 ('62292700', '62290000', '积石山保安族东乡族撒拉族自治县', '', 3033, 3, 0),
 ('62300000', '62000000', '甘南藏族自治州', '', 3034, 2, 8),
 ('62300100', '62300000', '合作市', '', 3035, 3, 0),
 ('62302100', '62300000', '临潭县', '', 3036, 3, 0),
 ('62302200', '62300000', '卓尼县', '', 3037, 3, 0),
 ('62302300', '62300000', '舟曲县', '', 3038, 3, 0),
 ('62302400', '62300000', '迭部县', '', 3039, 3, 0),
 ('62302500', '62300000', '玛曲县', '', 3040, 3, 0),
 ('62302600', '62300000', '碌曲县', '', 3041, 3, 0),
 ('62302700', '62300000', '夏河县', '', 3042, 3, 0),
 ('63000000', 'A1560000', '青海省', '', 3043, 1, 8),
 ('63010000', '63000000', '西宁市', '', 3044, 2, 7),
 ('63010200', '63010000', '城东区', '', 3045, 3, 0),
 ('63010300', '63010000', '城中区', '', 3046, 3, 0),
 ('63010400', '63010000', '城西区', '', 3047, 3, 0),
 ('63010500', '63010000', '城北区', '', 3048, 3, 0),
 ('63012100', '63010000', '大通回族土族自治县', '', 3049, 3, 0),
 ('63012200', '63010000', '湟中县', '', 3050, 3, 0),
 ('63012300', '63010000', '湟源县', '', 3051, 3, 0),
 ('63210000', '63000000', '海东地区', '', 3052, 2, 6),
 ('63212100', '63210000', '平安县', '', 3053, 3, 0),
 ('63212200', '63210000', '民和回族土族自治县', '', 3054, 3, 0),
 ('63212300', '63210000', '乐都县', '', 3055, 3, 0),
 ('63212600', '63210000', '互助土族自治县', '', 3056, 3, 0),
 ('63212700', '63210000', '化隆回族自治县', '', 3057, 3, 0),
 ('63212800', '63210000', '循化撒拉族自治县', '', 3058, 3, 0),
 ('63220000', '63000000', '海北藏族自治州', '', 3059, 2, 4),
 ('63222100', '63220000', '门源回族自治县', '', 3060, 3, 0),
 ('63222200', '63220000', '祁连县', '', 3061, 3, 0),
 ('63222300', '63220000', '海晏县', '', 3062, 3, 0),
 ('63222400', '63220000', '刚察县', '', 3063, 3, 0),
 ('63230000', '63000000', '黄南藏族自治州', '', 3064, 2, 4),
 ('63232100', '63230000', '同仁县', '', 3065, 3, 0),
 ('63232200', '63230000', '尖扎县', '', 3066, 3, 0),
 ('63232300', '63230000', '泽库县', '', 3067, 3, 0),
 ('63232400', '63230000', '河南蒙古族自治县', '', 3068, 3, 0),
 ('63250000', '63000000', '海南藏族自治州', '', 3069, 2, 5),
 ('63252100', '63250000', '共和县', '', 3070, 3, 0),
 ('63252200', '63250000', '同德县', '', 3071, 3, 0),
 ('63252300', '63250000', '贵德县', '', 3072, 3, 0),
 ('63252400', '63250000', '兴海县', '', 3073, 3, 0),
 ('63252500', '63250000', '贵南县', '', 3074, 3, 0),
 ('63260000', '63000000', '果洛藏族自治州', '', 3075, 2, 6),
 ('63262100', '63260000', '玛沁县', '', 3076, 3, 0),
 ('63262200', '63260000', '班玛县', '', 3077, 3, 0),
 ('63262300', '63260000', '甘德县', '', 3078, 3, 0),
 ('63262400', '63260000', '达日县', '', 3079, 3, 0),
 ('63262500', '63260000', '久治县', '', 3080, 3, 0),
 ('63262600', '63260000', '玛多县', '', 3081, 3, 0),
 ('63270000', '63000000', '玉树藏族自治州', '', 3082, 2, 6),
 ('63272100', '63270000', '玉树县', '', 3083, 3, 0),
 ('63272200', '63270000', '杂多县', '', 3084, 3, 0),
 ('63272300', '63270000', '称多县', '', 3085, 3, 0),
 ('63272400', '63270000', '治多县', '', 3086, 3, 0),
 ('63272500', '63270000', '囊谦县', '', 3087, 3, 0),
 ('63272600', '63270000', '曲麻莱县', '', 3088, 3, 0),
 ('63280000', '63000000', '海西蒙古族藏族自治州', '', 3089, 2, 5),
 ('63280100', '63280000', '格尔木市', '', 3090, 3, 0),
 ('63280200', '63280000', '德令哈市', '', 3091, 3, 0),
 ('63282100', '63280000', '乌兰县', '', 3092, 3, 0),
 ('63282200', '63280000', '都兰县', '', 3093, 3, 0),
 ('63282300', '63280000', '天峻县', '', 3094, 3, 0),
 ('64000000', 'A1560000', '宁夏回族自治区', '', 3095, 1, 5),
 ('64010000', '64000000', '银川市', '', 3096, 2, 6),
 ('64010400', '64010000', '兴庆区', '', 3097, 3, 0),
 ('64010500', '64010000', '西夏区', '', 3098, 3, 0),
 ('64010600', '64010000', '金凤区', '', 3099, 3, 0),
 ('64012100', '64010000', '永宁县', '', 3100, 3, 0),
 ('64012200', '64010000', '贺兰县', '', 3101, 3, 0),
 ('64018100', '64010000', '灵武市', '', 3102, 3, 0),
 ('64020000', '64000000', '石嘴山市', '', 3103, 2, 3),
 ('64020200', '64020000', '大武口区', '', 3104, 3, 0),
 ('64020500', '64020000', '惠农区', '', 3105, 3, 0),
 ('64022100', '64020000', '平罗县', '', 3106, 3, 0),
 ('64030000', '64000000', '吴忠市', '', 3107, 2, 4),
 ('64030200', '64030000', '利通区', '', 3108, 3, 0),
 ('64032300', '64030000', '盐池县', '', 3109, 3, 0),
 ('64032400', '64030000', '同心县', '', 3110, 3, 0),
 ('64038100', '64030000', '青铜峡市', '', 3111, 3, 0),
 ('64040000', '64000000', '固原市', '', 3112, 2, 5),
 ('64040200', '64040000', '原州区', '', 3113, 3, 0),
 ('64042200', '64040000', '西吉县', '', 3114, 3, 0),
 ('64042300', '64040000', '隆德县', '', 3115, 3, 0),
 ('64042400', '64040000', '泾源县', '', 3116, 3, 0),
 ('64042500', '64040000', '彭阳县', '', 3117, 3, 0),
 ('64050000', '64000000', '中卫市', '', 3118, 2, 3),
 ('64050200', '64050000', '沙坡头区', '', 3119, 3, 0),
 ('64052100', '64050000', '中宁县', '', 3120, 3, 0),
 ('64052200', '64050000', '海原县', '', 3121, 3, 0),
 ('65000000', 'A1560000', '新疆维吾尔自治区', '', 3122, 1, 15),
 ('65010000', '65000000', '乌鲁木齐市', '', 3123, 2, 8),
 ('65010200', '65010000', '天山区', '', 3124, 3, 0),
 ('65010300', '65010000', '沙依巴克区', '', 3125, 3, 0),
 ('65010400', '65010000', '新市区', '', 3126, 3, 0),
 ('65010500', '65010000', '水磨沟区', '', 3127, 3, 0),
 ('65010600', '65010000', '头屯河区', '', 3128, 3, 0),
 ('65010700', '65010000', '达坂城区', '', 3129, 3, 0),
 ('65010800', '65010000', '东山区', '', 3130, 3, 0),
 ('65012100', '65010000', '乌鲁木齐县', '', 3131, 3, 0),
 ('65020000', '65000000', '克拉玛依市', '', 3132, 2, 4),
 ('65020200', '65020000', '独山子区', '', 3133, 3, 0),
 ('65020300', '65020000', '克拉玛依区', '', 3134, 3, 0),
 ('65020400', '65020000', '白碱滩区', '', 3135, 3, 0),
 ('65020500', '65020000', '乌尔禾区', '', 3136, 3, 0),
 ('65210000', '65000000', '吐鲁番地区', '', 3137, 2, 3),
 ('65210100', '65210000', '吐鲁番市', '', 3138, 3, 0),
 ('65212200', '65210000', '鄯善县', '', 3139, 3, 0),
 ('65212300', '65210000', '托克逊县', '', 3140, 3, 0),
 ('65220000', '65000000', '哈密地区', '', 3141, 2, 3),
 ('65220100', '65220000', '哈密市', '', 3142, 3, 0),
 ('65222200', '65220000', '巴里坤哈萨克自治县', '', 3143, 3, 0),
 ('65222300', '65220000', '伊吾县', '', 3144, 3, 0),
 ('65230000', '65000000', '昌吉回族自治州', '', 3145, 2, 8),
 ('65230100', '65230000', '昌吉市', '', 3146, 3, 0),
 ('65230200', '65230000', '阜康市', '', 3147, 3, 0),
 ('65230300', '65230000', '米泉市', '', 3148, 3, 0),
 ('65232300', '65230000', '呼图壁县', '', 3149, 3, 0),
 ('65232400', '65230000', '玛纳斯县', '', 3150, 3, 0),
 ('65232500', '65230000', '奇台县', '', 3151, 3, 0),
 ('65232700', '65230000', '吉木萨尔县', '', 3152, 3, 0),
 ('65232800', '65230000', '木垒哈萨克自治县', '', 3153, 3, 0),
 ('65270000', '65000000', '博尔塔拉蒙古自治州', '', 3154, 2, 3),
 ('65270100', '65270000', '博乐市', '', 3155, 3, 0),
 ('65272200', '65270000', '精河县', '', 3156, 3, 0),
 ('65272300', '65270000', '温泉县', '', 3157, 3, 0),
 ('65280000', '65000000', '巴音郭楞蒙古自治州', '', 3158, 2, 9),
 ('65280100', '65280000', '库尔勒市', '', 3159, 3, 0),
 ('65282200', '65280000', '轮台县', '', 3160, 3, 0),
 ('65282300', '65280000', '尉犁县', '', 3161, 3, 0),
 ('65282400', '65280000', '若羌县', '', 3162, 3, 0),
 ('65282500', '65280000', '且末县', '', 3163, 3, 0),
 ('65282600', '65280000', '焉耆回族自治县', '', 3164, 3, 0),
 ('65282700', '65280000', '和静县', '', 3165, 3, 0),
 ('65282800', '65280000', '和硕县', '', 3166, 3, 0),
 ('65282900', '65280000', '博湖县', '', 3167, 3, 0),
 ('65290000', '65000000', '阿克苏地区', '', 3168, 2, 9),
 ('65290100', '65290000', '阿克苏市', '', 3169, 3, 0),
 ('65292200', '65290000', '温宿县', '', 3170, 3, 0),
 ('65292300', '65290000', '库车县', '', 3171, 3, 0),
 ('65292400', '65290000', '沙雅县', '', 3172, 3, 0),
 ('65292500', '65290000', '新和县', '', 3173, 3, 0),
 ('65292600', '65290000', '拜城县', '', 3174, 3, 0),
 ('65292700', '65290000', '乌什县', '', 3175, 3, 0),
 ('65292800', '65290000', '阿瓦提县', '', 3176, 3, 0),
 ('65292900', '65290000', '柯坪县', '', 3177, 3, 0),
 ('65300000', '65000000', '克孜勒苏柯尔克孜自治州', '', 3178, 2, 4),
 ('65300100', '65300000', '阿图什市', '', 3179, 3, 0),
 ('65302200', '65300000', '阿克陶县', '', 3180, 3, 0),
 ('65302300', '65300000', '阿合奇县', '', 3181, 3, 0),
 ('65302400', '65300000', '乌恰县', '', 3182, 3, 0),
 ('65310000', '65000000', '喀什地区', '', 3183, 2, 12),
 ('65310100', '65310000', '喀什市', '', 3184, 3, 0),
 ('65312100', '65310000', '疏附县', '', 3185, 3, 0),
 ('65312200', '65310000', '疏勒县', '', 3186, 3, 0),
 ('65312300', '65310000', '英吉沙县', '', 3187, 3, 0),
 ('65312400', '65310000', '泽普县', '', 3188, 3, 0),
 ('65312500', '65310000', '莎车县', '', 3189, 3, 0),
 ('65312600', '65310000', '叶城县', '', 3190, 3, 0),
 ('65312700', '65310000', '麦盖提县', '', 3191, 3, 0),
 ('65312800', '65310000', '岳普湖县', '', 3192, 3, 0),
 ('65312900', '65310000', '伽师县', '', 3193, 3, 0),
 ('65313000', '65310000', '巴楚县', '', 3194, 3, 0),
 ('65313100', '65310000', '塔什库尔干塔吉克自治县', '', 3195, 3, 0),
 ('65320000', '65000000', '和田地区', '', 3196, 2, 8),
 ('65320100', '65320000', '和田市', '', 3197, 3, 0),
 ('65322100', '65320000', '和田县', '', 3198, 3, 0),
 ('65322200', '65320000', '墨玉县', '', 3199, 3, 0),
 ('65322300', '65320000', '皮山县', '', 3200, 3, 0),
 ('65322400', '65320000', '洛浦县', '', 3201, 3, 0),
 ('65322500', '65320000', '策勒县', '', 3202, 3, 0),
 ('65322600', '65320000', '于田县', '', 3203, 3, 0),
 ('65322700', '65320000', '民丰县', '', 3204, 3, 0),
 ('65400000', '65000000', '伊犁哈萨克自治州', '', 3205, 2, 10),
 ('65400200', '65400000', '伊宁市', '', 3206, 3, 0),
 ('65400300', '65400000', '奎屯市', '', 3207, 3, 0),
 ('65402100', '65400000', '伊宁县', '', 3208, 3, 0),
 ('65402200', '65400000', '察布查尔锡伯自治县', '', 3209, 3, 0),
 ('65402300', '65400000', '霍城县', '', 3210, 3, 0),
 ('65402400', '65400000', '巩留县', '', 3211, 3, 0),
 ('65402500', '65400000', '新源县', '', 3212, 3, 0),
 ('65402600', '65400000', '昭苏县', '', 3213, 3, 0),
 ('65402700', '65400000', '特克斯县', '', 3214, 3, 0),
 ('65402800', '65400000', '尼勒克县', '', 3215, 3, 0),
 ('65420000', '65000000', '塔城地区', '', 3216, 2, 7),
 ('65420100', '65420000', '塔城市', '', 3217, 3, 0),
 ('65420200', '65420000', '乌苏市', '', 3218, 3, 0),
 ('65422100', '65420000', '额敏县', '', 3219, 3, 0),
 ('65422300', '65420000', '沙湾县', '', 3220, 3, 0),
 ('65422400', '65420000', '托里县', '', 3221, 3, 0),
 ('65422500', '65420000', '裕民县', '', 3222, 3, 0),
 ('65422600', '65420000', '和布克赛尔蒙古自治县', '', 3223, 3, 0),
 ('65430000', '65000000', '阿勒泰地区', '', 3224, 2, 7),
 ('65430100', '65430000', '阿勒泰市', '', 3225, 3, 0),
 ('65432100', '65430000', '布尔津县', '', 3226, 3, 0),
 ('65432200', '65430000', '富蕴县', '', 3227, 3, 0),
 ('65432300', '65430000', '福海县', '', 3228, 3, 0),
 ('65432400', '65430000', '哈巴河县', '', 3229, 3, 0),
 ('65432500', '65430000', '青河县', '', 3230, 3, 0),
 ('65432600', '65430000', '吉木乃县', '', 3231, 3, 0),
 ('65900000', '65000000', '自治区直辖行政单位', '', 3232, 2, 4),
 ('65900100', '65900000', '石河子市', '', 3233, 3, 0),
 ('65900200', '65900000', '阿拉尔市', '', 3234, 3, 0),
 ('65900300', '65900000', '图木舒克市', '', 3235, 3, 0),
 ('65900400', '65900000', '五家渠市', '', 3236, 3, 0),
 ('71000000', 'A1560000', '台湾省', '', 3237, 1, 0),
 ('81000000', 'A1560000', '香港特别行政区', '', 3238, 1, 0),
 ('82000000', 'A1560000', '澳门特别行政区', '', 3239, 1, 0),
 ('A0040000', '', '阿富汗', '', 3240, 0, 0),
 ('A0480000', '', '巴林', '', 3241, 0, 0),
 ('A0500000', '', '孟加拉', '', 3242, 0, 0),
 ('A0960000', '', '文莱', '', 3243, 0, 0),
 ('A1040000', '', '缅甸', '', 3244, 0, 0),
 ('A1160000', '', '柬埔寨', '', 3245, 0, 0),
 ('A1440000', '', '斯里兰卡', '', 3246, 0, 0),
 ('A1560000', '', '中国', '', 3247, 0, 34),
 ('A1960000', '', '塞浦路斯', '', 3248, 0, 0),
 ('A3560000', '', '印度', '', 3249, 0, 0),
 ('A3600000', '', '印度尼西亚', '', 3250, 0, 0),
 ('A3640000', '', '伊朗', '', 3251, 0, 0),
 ('A3680000', '', '伊拉克', '', 3252, 0, 0),
 ('A3740000', '', '巴勒斯坦', '', 3253, 0, 0),
 ('A3760000', '', '以色列', '', 3254, 0, 0),
 ('A3920000', '', '日本', '', 3255, 0, 0),
 ('A3980000', '', '哈萨克斯坦', '', 3256, 0, 0),
 ('A4000000', '', '约旦', '', 3257, 0, 0),
 ('A4080000', '', '朝鲜', '', 3258, 0, 0),
 ('A4100000', '', '韩国', '', 3259, 0, 0),
 ('A4140000', '', '科威特', '', 3260, 0, 0),
 ('A4170000', '', '吉尔吉斯斯坦', '', 3261, 0, 0),
 ('A4180000', '', '老挝', '', 3262, 0, 0),
 ('A4220000', '', '黎巴嫩', '', 3263, 0, 0),
 ('A4580000', '', '马来西亚', '', 3264, 0, 0),
 ('A4620000', '', '马尔代夫', '', 3265, 0, 0),
 ('A4960000', '', '蒙古', '', 3266, 0, 0),
 ('A5120000', '', '阿曼', '', 3267, 0, 0),
 ('A5240000', '', '尼泊尔', '', 3268, 0, 0),
 ('A5860000', '', '巴基斯坦', '', 3269, 0, 0),
 ('A6080000', '', '菲律宾', '', 3270, 0, 0),
 ('A6260000', '', '东帝汶', '', 3271, 0, 0),
 ('A6340000', '', '卡塔尔', '', 3272, 0, 0),
 ('A6820000', '', '沙特阿拉伯', '', 3273, 0, 0),
 ('A7020000', '', '新加坡', '', 3274, 0, 0),
 ('A7040000', '', '越南', '', 3275, 0, 0),
 ('A7200000', '', '也门', '', 3276, 0, 0),
 ('A7600000', '', '叙利亚', '', 3277, 0, 0),
 ('A7620000', '', '塔吉克斯坦', '', 3278, 0, 0),
 ('A7640000', '', '泰国', '', 3279, 0, 0),
 ('A7840000', '', '阿拉伯联合酋长国', '', 3280, 0, 0),
 ('A7920000', '', '土耳其', '', 3281, 0, 0),
 ('A7950000', '', '土库曼斯坦', '', 3282, 0, 0),
 ('A8600000', '', '乌兹别克斯坦', '', 3283, 0, 0),
 ('B0120000', '', '阿尔及利亚', '', 3284, 0, 0),
 ('B0240000', '', '安哥拉', '', 3285, 0, 0),
 ('B0720000', '', '博茨瓦纳', '', 3286, 0, 0),
 ('B1080000', '', '布隆迪', '', 3287, 0, 0),
 ('B1200000', '', '喀麦隆', '', 3288, 0, 0),
 ('B1320000', '', '佛得角', '', 3289, 0, 0),
 ('B1400000', '', '中非', '', 3290, 0, 0),
 ('B1480000', '', '乍得', '', 3291, 0, 0),
 ('B1740000', '', '科摩罗', '', 3292, 0, 0),
 ('B1780000', '', '刚果(布)', '', 3293, 0, 0),
 ('B1800000', '', '刚果(金)', '', 3294, 0, 0),
 ('B2040000', '', '贝宁', '', 3295, 0, 0),
 ('B2260000', '', '赤道几内亚', '', 3296, 0, 0),
 ('B2300000', '', '埃塞俄比亚', '', 3297, 0, 0),
 ('B2320000', '', '厄立特里亚', '', 3298, 0, 0),
 ('B2620000', '', '吉布提', '', 3299, 0, 0),
 ('B2660000', '', '加蓬', '', 3300, 0, 0),
 ('B2700000', '', '冈比亚', '', 3301, 0, 0),
 ('B2880000', '', '加纳', '', 3302, 0, 0),
 ('B3240000', '', '几内亚', '', 3303, 0, 0),
 ('B3840000', '', '科特迪瓦', '', 3304, 0, 0),
 ('B4040000', '', '肯尼亚', '', 3305, 0, 0),
 ('B4260000', '', '莱索托', '', 3306, 0, 0),
 ('B4300000', '', '利比里亚', '', 3307, 0, 0),
 ('B4340000', '', '利比亚', '', 3308, 0, 0),
 ('B4500000', '', '马达加斯加', '', 3309, 0, 0),
 ('B4660000', '', '马里', '', 3310, 0, 0),
 ('B4780000', '', '毛里塔尼亚', '', 3311, 0, 0),
 ('B4800000', '', '毛里求斯', '', 3312, 0, 0),
 ('B5040000', '', '摩洛哥', '', 3313, 0, 0),
 ('B5080000', '', '莫桑比克', '', 3314, 0, 0),
 ('B5160000', '', '纳米比亚', '', 3315, 0, 0),
 ('B5620000', '', '尼日尔', '', 3316, 0, 0),
 ('B5660000', '', '尼日利亚', '', 3317, 0, 0),
 ('B6240000', '', '几内亚比绍', '', 3318, 0, 0),
 ('B6460000', '', '卢旺达', '', 3319, 0, 0),
 ('B6780000', '', '圣多美和普林西比', '', 3320, 0, 0),
 ('B6860000', '', '塞内加尔', '', 3321, 0, 0),
 ('B6900000', '', '塞舌尔', '', 3322, 0, 0),
 ('B6940000', '', '塞拉利昂', '', 3323, 0, 0),
 ('B7060000', '', '索马里', '', 3324, 0, 0),
 ('B7100000', '', '南非', '', 3325, 0, 0),
 ('B7160000', '', '津巴布韦', '', 3326, 0, 0),
 ('B7320000', '', '西撒哈拉', '', 3327, 0, 0),
 ('B7360000', '', '苏丹', '', 3328, 0, 0),
 ('B7480000', '', '斯威士兰', '', 3329, 0, 0),
 ('B7680000', '', '多哥', '', 3330, 0, 0),
 ('B7880000', '', '突尼斯', '', 3331, 0, 0),
 ('B8000000', '', '乌干达', '', 3332, 0, 0),
 ('B8180000', '', '埃及', '', 3333, 0, 0),
 ('B8340000', '', '坦桑尼亚', '', 3334, 0, 0),
 ('B8540000', '', '布基纳法索', '', 3335, 0, 0),
 ('B8940000', '', '赞比亚', '', 3336, 0, 0),
 ('C0080000', '', '阿尔巴尼亚', '', 3337, 0, 0),
 ('C0200000', '', '安道尔', '', 3338, 0, 0),
 ('C0310000', '', '阿塞拜疆', '', 3339, 0, 0),
 ('C0400000', '', '奥地利', '', 3340, 0, 0),
 ('C0510000', '', '亚美尼亚', '', 3341, 0, 0),
 ('C0560000', '', '比利时', '', 3342, 0, 0),
 ('C0700000', '', '波斯尼亚和黑塞哥维那', '', 3343, 0, 0),
 ('C1000000', '', '保加利亚', '', 3344, 0, 0),
 ('C1120000', '', '白俄罗斯', '', 3345, 0, 0),
 ('C1910000', '', '克罗地亚', '', 3346, 0, 0),
 ('C2030000', '', '捷克', '', 3347, 0, 0),
 ('C2080000', '', '丹麦', '', 3348, 0, 0),
 ('C2330000', '', '爱沙尼亚', '', 3349, 0, 0),
 ('C2460000', '', '芬兰', '', 3350, 0, 0),
 ('C2500000', '', '法国', '', 3351, 0, 0),
 ('C2680000', '', '格鲁吉亚', '', 3352, 0, 0),
 ('C2760000', '', '德国', '', 3353, 0, 0),
 ('C3000000', '', '希腊', '', 3354, 0, 0),
 ('C3040000', '', '格陵兰', '', 3355, 0, 0),
 ('C3360000', '', '梵帝冈', '', 3356, 0, 0),
 ('C3480000', '', '匈牙利', '', 3357, 0, 0),
 ('C3520000', '', '冰岛', '', 3358, 0, 0),
 ('C3720000', '', '爱尔兰', '', 3359, 0, 0),
 ('C3800000', '', '意大利', '', 3360, 0, 0),
 ('C4280000', '', '拉脱维亚', '', 3361, 0, 0),
 ('C4380000', '', '列支敦士登公国', '', 3362, 0, 0),
 ('C4400000', '', '立陶宛', '', 3363, 0, 0),
 ('C4420000', '', '卢森堡', '', 3364, 0, 0),
 ('C4700000', '', '马耳他', '', 3365, 0, 0),
 ('C4920000', '', '摩纳哥', '', 3366, 0, 0),
 ('C4980000', '', '摩尔多瓦', '', 3367, 0, 0),
 ('C5280000', '', '荷兰', '', 3368, 0, 0),
 ('C5780000', '', '挪威', '', 3369, 0, 0),
 ('C6160000', '', '波兰', '', 3370, 0, 0),
 ('C6200000', '', '葡萄牙', '', 3371, 0, 0),
 ('C6420000', '', '罗马尼亚', '', 3372, 0, 0),
 ('C6430000', '', '俄罗斯', '', 3373, 0, 0),
 ('C6740000', '', '圣马力诺', '', 3374, 0, 0),
 ('C7030000', '', '斯洛伐克', '', 3375, 0, 0),
 ('C7050000', '', '斯洛文尼亚', '', 3376, 0, 0),
 ('C7240000', '', '西班牙', '', 3377, 0, 0),
 ('C7520000', '', '瑞典', '', 3378, 0, 0),
 ('C7560000', '', '瑞士', '', 3379, 0, 0),
 ('C8040000', '', '乌克兰', '', 3380, 0, 0),
 ('C8070000', '', '马其顿', '', 3381, 0, 0),
 ('C8260000', '', '英国', '', 3382, 0, 0),
 ('C8900000', '', '塞尔维亚和黑山', '', 3383, 0, 0),
 ('D0280000', '', '安提瓜和巴布达', '', 3384, 0, 0),
 ('D0320000', '', '阿根廷', '', 3385, 0, 0),
 ('D0440000', '', '巴哈马', '', 3386, 0, 0),
 ('D0520000', '', '巴巴多斯', '', 3387, 0, 0),
 ('D0600000', '', '百慕大', '', 3388, 0, 0),
 ('D0680000', '', '玻利维亚', '', 3389, 0, 0),
 ('D0760000', '', '巴西', '', 3390, 0, 0),
 ('D0840000', '', '伯利兹', '', 3391, 0, 0),
 ('D1240000', '', '加拿大', '', 3392, 0, 0),
 ('D1520000', '', '智利', '', 3393, 0, 0),
 ('D1700000', '', '哥伦比亚', '', 3394, 0, 0),
 ('D1880000', '', '哥斯达黎加', '', 3395, 0, 0),
 ('D1920000', '', '古巴', '', 3396, 0, 0),
 ('D2180000', '', '厄瓜多尔', '', 3397, 0, 0),
 ('D2220000', '', '萨尔瓦多', '', 3398, 0, 0),
 ('D3080000', '', '格林纳达', '', 3399, 0, 0),
 ('D3200000', '', '危地马拉', '', 3400, 0, 0),
 ('D3280000', '', '圭亚那', '', 3401, 0, 0),
 ('D3320000', '', '海地', '', 3402, 0, 0),
 ('D3400000', '', '洪都拉斯', '', 3403, 0, 0),
 ('D3880000', '', '牙买加', '', 3404, 0, 0),
 ('D4840000', '', '墨西哥', '', 3405, 0, 0),
 ('D5580000', '', '尼加拉瓜', '', 3406, 0, 0),
 ('D5900000', '', '巴拿马', '', 3407, 0, 0),
 ('D6000000', '', '巴拉圭', '', 3408, 0, 0),
 ('D6040000', '', '秘鲁', '', 3409, 0, 0),
 ('D6300000', '', '波多黎各', '', 3410, 0, 0),
 ('D6600000', '', '安圭拉', '', 3411, 0, 0),
 ('D6620000', '', '圣卢西亚', '', 3412, 0, 0),
 ('D7400000', '', '苏里南', '', 3413, 0, 0),
 ('D7800000', '', '特立尼达和多巴哥', '', 3414, 0, 0),
 ('D8400000', '', '美国', '', 3415, 0, 0),
 ('D8580000', '', '乌拉圭东岸', '', 3416, 0, 0),
 ('D8620000', '', '委内瑞拉', '', 3417, 0, 0),
 ('D9710000', '', '瓜亚基尔', '', 3418, 0, 0),
 ('E0360000', '', '澳大利亚', '', 3419, 0, 0),
 ('E2420000', '', '斐济', '', 3420, 0, 0),
 ('E2960000', '', '基里巴斯', '', 3421, 0, 0),
 ('E3160000', '', '关岛', '', 3422, 0, 0),
 ('E5200000', '', '瑙鲁', '', 3423, 0, 0),
 ('E5400000', '', '新喀里多尼亚', '', 3424, 0, 0),
 ('E5480000', '', '瓦努阿图', '', 3425, 0, 0),
 ('E5540000', '', '新西兰', '', 3426, 0, 0),
 ('E5700000', '', '纽埃', '', 3427, 0, 0),
 ('E5830000', '', '密克罗尼西亚', '', 3428, 0, 0),
 ('E5840000', '', '马绍尔群岛', '', 3429, 0, 0),
 ('E5980000', '', '巴布亚新几内亚', '', 3430, 0, 0),
 ('E7720000', '', '托克劳', '', 3431, 0, 0),
 ('E7760000', '', '汤加', '', 3432, 0, 0),
 ('E7980000', '', '图瓦卢', '', 3433, 0, 0),
 ('E8820000', '', '西萨摩亚', '', 3434, 0, 0);


-- 学校数据
INSERT `tn_Schools` (`Id`, `Name`, `PinyinName`, `ShortPinyinName`, `SchoolType`, `AreaCode`, `DisplayOrder`)
 VALUES (1, '北京大学', 'beijingdaxue', 'bjdx', 0, '11000000', 1),
 (2, '中国人民大学', 'zhongguorenmindaxue', 'zgrmdx', 0, '11000000', 2),
 (3, '清华大学', 'qinghuadaxue', 'qhdx', 0, '11000000', 3),
 (4, '北京交通大学', 'beijingjiaotongdaxue', 'bjjtdx', 0, '11000000', 4),
 (5, '北京科技大学', 'beijingkejidaxue', 'bjkjdx', 0, '11000000', 5),
 (6, '中国石油大学', 'zhongguoshiyoudaxue', 'zgsydx', 0, '11000000', 7),
 (7, '北京邮电大学', 'beijingyoudiandaxue', 'bjyddx', 0, '11000000', 8),
 (8, '华北电力大学', 'huabeidianlidaxue', 'hbdldx', 0, '11000000', 6),
 (9, '北京化工大学', 'beijinghuagongdaxue', 'bjhgdx', 0, '11000000', 9),
 (10, '中国农业大学', 'zhongguonongyedaxue', 'zgnydx', 0, '11000000', 10),
 (11, '北京林业大学', 'beijinglinyedaxue', 'bjlydx', 0, '11000000', 11),
 (12, '北京中医药大学', 'beijingzhongyiyaodaxue', 'bjzyydx', 0, '11000000', 12),
 (13, '北京师范大学', 'beijingshifandaxue', 'bjsfdx', 0, '11000000', 13),
 (14, '北京外国语大学', 'beijingwaiguoyudaxue', 'bjwgydx', 0, '11000000', 14),
 (15, '北京语言大学', 'beijingyuyandaxue', 'bjyydx', 0, '11000000', 15),
 (16, '对外经济贸易大学', 'duiwaijingjimaoyidaxue', 'dwjjmydx', 0, '11000000', 16),
 (17, '中央财经大学', 'zhongyangcaijingdaxue', 'zycjdx', 0, '11000000', 17),
 (18, '中国政法大学', 'zhongguozhengfadaxue', 'zgzfdx', 0, '11000000', 18),
 (19, '中央民族大学', 'zhongyangminzudaxue', 'zymzdx', 0, '11000000', 19),
 (20, '中国人民公安大学', 'zhongguorenmingongandaxue', 'zgrmgadx', 0, '11000000', 20),
 (21, '北京协和医学院', 'beijingxieheyixueyuan', 'bjxhyxy', 0, '11000000', 21),
 (22, '北京体育大学', 'beijingtiyudaxue', 'bjtydx', 0, '11000000', 22),
 (23, '北京理工大学', 'beijingligongdaxue', 'bjlgdx', 0, '11000000', 23),
 (24, '北京航空航天大学', 'beijinghangkonghangtiandaxue', 'bjhkhtdx', 0, '11000000', 24),
 (25, '北京信息科技大学', 'beijingxinxikejidaxue', 'bjxxkjdx', 0, '11000000', 25),
 (26, '北京工商大学', 'beijinggongshangdaxue', 'bjgsdx', 0, '11000000', 26),
 (27, '北京联合大学', 'beijinglianhedaxue', 'bjlhdx', 0, '11000000', 27),
 (28, '北京工业大学', 'beijinggongyedaxue', 'bjgydx', 0, '11000000', 28),
 (29, '北方工业大学', 'beifanggongyedaxue', 'bfgydx', 0, '11000000', 29),
 (30, '首都医科大学', 'shouduyikedaxue', 'sdykdx', 0, '11000000', 30),
 (31, '首都师范大学', 'shoudushifandaxue', 'sdsfdx', 0, '11000000', 31),
 (32, '首都经济贸易大学', 'shoudujingjimaoyidaxue', 'sdjjmydx', 0, '11000000', 32),
 (33, '中国传媒大学', 'zhongguochuanmeidaxue', 'zgcmdx', 0, '11000000', 33),
 (34, '国际关系学院', 'guojiguanxixueyuan', 'gjgxxy', 0, '11000000', 34),
 (35, '中央美术学院', 'zhongyangmeishuxueyuan', 'zymsxy', 0, '11000000', 35),
 (36, '中央戏剧学院', 'zhongyangxijuxueyuan', 'zyxjxy', 0, '11000000', 36),
 (37, '中央音乐学院', 'zhongyangyinlexueyuan', 'zyylxy', 0, '11000000', 37),
 (38, '北京电子科技学院', 'beijingdianzikejixueyuan', 'bjdzkjxy', 0, '11000000', 38),
 (39, '外交学院', 'waijiaoxueyuan', 'wjxy', 0, '11000000', 39),
 (40, '中国劳动关系学院', 'zhongguolaodongguanxixueyuan', 'zgldgxxy', 0, '11000000', 40),
 (41, '中国青年政治学院', 'zhongguoqingnianzhengzhixueyuan', 'zgqnzzxy', 0, '11000000', 41),
 (42, '中华女子学院', 'zhonghuanuzixueyuan', 'zhnzxy', 0, '11000000', 42),
 (43, '北京建筑工程学院', 'beijingjianzhugongchengxueyuan', 'bjjzgcxy', 0, '11000000', 43),
 (44, '北京服装学院', 'beijingfuzhuangxueyuan', 'bjfzxy', 0, '11000000', 44),
 (45, '北京印刷学院', 'beijingyinshuaxueyuan', 'bjysxy', 0, '11000000', 45),
 (46, '北京石油化工学院', 'beijingshiyouhuagongxueyuan', 'bjsyhgxy', 0, '11000000', 46),
 (47, '首钢工学院', 'shouganggongxueyuan', 'sggxy', 0, '11000000', 47),
 (48, '北京农学院', 'beijingnongxueyuan', 'bjnxy', 0, '11000000', 48),
 (49, '首都体育学院', 'shoudutiyuxueyuan', 'sdtyxy', 0, '11000000', 49),
 (50, '北京第二外国语学院', 'beijingdiewaiguoyuxueyuan', 'bjdewgyxy', 0, '11000000', 50),
 (51, '北京物资学院', 'beijingwuzixueyuan', 'bjwzxy', 0, '11000000', 51),
 (52, '北京警察学院', 'beijingjingchaxueyuan', 'bjjcxy', 0, '11000000', 52),
 (53, '中国音乐学院', 'zhongguoyinlexueyuan', 'zgylxy', 0, '11000000', 53),
 (54, '北京舞蹈学院', 'beijingwudaoxueyuan', 'bjwdxy', 0, '11000000', 54),
 (55, '北京电影学院', 'beijingdianyingxueyuan', 'bjdyxy', 0, '11000000', 55),
 (56, '中国戏曲学院', 'zhongguoxiquxueyuan', 'zgxqxy', 0, '11000000', 56),
 (57, '北京城市学院', 'beijingchengshixueyuan', 'bjcsxy', 0, '11000000', 57),
 (58, '北京青年政治学院', 'beijingqingnianzhengzhixueyuan', 'bjqnzzxy', 0, '11000000', 58),
 (59, '北京交通运输职业学院', 'beijingjiaotongyunshuzhiyexueyuan', 'bjjtyszyxy', 0, '11000000', 59),
 (60, '北京信息职业技术学院', 'beijingxinxizhiyejishuxueyuan', 'bjxxzyjsxy', 0, '11000000', 60),
 (61, '北京电子科技职业学院', 'beijingdianzikejizhiyexueyuan', 'bjdzkjzyxy', 0, '11000000', 61),
 (62, '北京科技经营管理学院', 'beijingkejijingyingguanlixueyuan', 'bjkjjyglxy', 0, '11000000', 62),
 (63, '北京工业职业技术学院', 'beijinggongyezhiyejishuxueyuan', 'bjgyzyjsxy', 0, '11000000', 63),
 (64, '北京汇佳职业学院', 'beijinghuijiazhiyexueyuan', 'bjhjzyxy', 0, '11000000', 64),
 (65, '北京农业职业学院', 'beijingnongyezhiyexueyuan', 'bjnyzyxy', 0, '11000000', 65),
 (66, '北京吉利大学', 'beijingjilidaxue', 'bjjldx', 0, '11000000', 66),
 (67, '北京经济技术职业学院', 'beijingjingjijishuzhiyexueyuan', 'bjjjjszyxy', 0, '11000000', 67),
 (68, '北京财贸职业学院', 'beijingcaimaozhiyexueyuan', 'bjcmzyxy', 0, '11000000', 68),
 (69, '北京社会管理职业学院', 'beijingshehuiguanlizhiyexueyuan', 'bjshglzyxy', 0, '11000000', 69),
 (70, '北京培黎职业学院', 'beijingpeilizhiyexueyuan', 'bjplzyxy', 0, '11000000', 70),
 (71, '北京科技职业学院', 'beijingkejizhiyexueyuan', 'bjkjzyxy', 0, '11000000', 71),
 (72, '北京现代职业技术学院', 'beijingxiandaizhiyejishuxueyuan', 'bjxdzyjsxy', 0, '11000000', 72),
 (73, '北京劳动保障职业学院', 'beijinglaodongbaozhangzhiyexueyuan', 'bjldbzzyxy', 0, '11000000', 73),
 (74, '北京戏曲艺术职业学院', 'beijingxiquyishuzhiyexueyuan', 'bjxqyszyxy', 0, '11000000', 74),
 (75, '北京北大方正软件职业技术学院', 'beijingbeidafangzhengruanjianzhiyejishuxueyuan', 'bjbdfzrjzyjsxy', 0, '11000000', 75),
 (76, '北京京北职业技术学院', 'beijingjingbeizhiyejishuxueyuan', 'bjjbzyjsxy', 0, '11000000', 76),
 (77, '北京体育职业学院', 'beijingtiyuzhiyexueyuan', 'bjtyzyxy', 0, '11000000', 77),
 (78, '北京经贸职业学院', 'beijingjingmaozhiyexueyuan', 'bjjmzyxy', 0, '11000000', 78),
 (79, '北京经济管理职业学院', 'beijingjingjiguanlizhiyexueyuan', 'bjjjglzyxy', 0, '11000000', 79),
 (80, '北京新圆明职业学院', 'beijingxinyuanmingzhiyexueyuan', 'bjxymzyxy', 0, '11000000', 80),
 (81, '北京交通职业技术学院', 'beijingjiaotongzhiyejishuxueyuan', 'bjjtzyjsxy', 0, '11000000', 81),
 (82, '北京政法职业学院', 'beijingzhengfazhiyexueyuan', 'bjzfzyxy', 0, '11000000', 82),
 (83, '南开大学', 'nakaidaxue', 'nkdx', 0, '12000000', 83),
 (84, '天津大学', 'tianjindaxue', 'tjdx', 0, '12000000', 84),
 (85, '中国民航大学', 'zhongguominhangdaxue', 'zgmhdx', 0, '12000000', 85),
 (86, '天津工业大学', 'tianjingongyedaxue', 'tjgydx', 0, '12000000', 86),
 (87, '天津科技大学', 'tianjinkejidaxue', 'tjkjdx', 0, '12000000', 87),
 (88, '天津理工大学', 'tianjinligongdaxue', 'tjlgdx', 0, '12000000', 88),
 (89, '天津医科大学', 'tianjinyikedaxue', 'tjykdx', 0, '12000000', 89),
 (90, '天津中医药大学', 'tianjinzhongyiyaodaxue', 'tjzyydx', 0, '12000000', 90),
 (91, '天津师范大学', 'tianjinshifandaxue', 'tjsfdx', 0, '12000000', 91),
 (92, '天津职业技术师范大学', 'tianjinzhiyejishushifandaxue', 'tjzyjssfdx', 0, '12000000', 92),
 (93, '天津外国语大学', 'tianjinwaiguoyudaxue', 'tjwgydx', 0, '12000000', 93),
 (94, '天津财经大学', 'tianjincaijingdaxue', 'tjcjdx', 0, '12000000', 94),
 (95, '天津商业大学', 'tianjinshangyedaxue', 'tjsydx', 0, '12000000', 95),
 (96, '天津天狮学院', 'tianjintianshixueyuan', 'tjtsxy', 0, '12000000', 96),
 (97, '天津城市建设学院', 'tianjinchengshijianshexueyuan', 'tjcsjsxy', 0, '12000000', 97),
 (98, '天津农学院', 'tianjinnongxueyuan', 'tjnxy', 0, '12000000', 98),
 (99, '天津体育学院', 'tianjintiyuxueyuan', 'tjtyxy', 0, '12000000', 99),
 (100, '天津美术学院', 'tianjinmeishuxueyuan', 'tjmsxy', 0, '12000000', 100),
 (101, '天津音乐学院', 'tianjinyinlexueyuan', 'tjylxy', 0, '12000000', 101),
 (102, '天津医学高等专科学校', 'tianjinyixuegaodengzhuankexuexiao', 'tjyxgdzkxx', 0, '12000000', 102),
 (103, '天津渤海职业技术学院', 'tianjinbohaizhiyejishuxueyuan', 'tjbhzyjsxy', 0, '12000000', 103),
 (104, '天津公安警官职业学院', 'tianjingonganjingguanzhiyexueyuan', 'tjgajgzyxy', 0, '12000000', 104),
 (105, '天津轻工职业技术学院', 'tianjinqinggongzhiyejishuxueyuan', 'tjqgzyjsxy', 0, '12000000', 105),
 (106, '天津滨海职业学院', 'tianjinbinhaizhiyexueyuan', 'tjbhzyxy', 0, '12000000', 106),
 (107, '天津职业大学', 'tianjinzhiyedaxue', 'tjzydx', 0, '12000000', 107),
 (108, '天津机电职业技术学院', 'tianjinjidianzhiyejishuxueyuan', 'tjjdzyjsxy', 0, '12000000', 108),
 (109, '天津工程职业技术学院', 'tianjingongchengzhiyejishuxueyuan', 'tjgczyjsxy', 0, '12000000', 109),
 (110, '天津电子信息职业技术学院', 'tianjindianzixinxizhiyejishuxueyuan', 'tjdzxxzyjsxy', 0, '12000000', 110),
 (111, '天津现代职业技术学院', 'tianjinxiandaizhiyejishuxueyuan', 'tjxdzyjsxy', 0, '12000000', 111),
 (112, '天津中德职业技术学院', 'tianjinzhongdezhiyejishuxueyuan', 'tjzdzyjsxy', 0, '12000000', 112),
 (113, '天津生物工程职业技术学院', 'tianjinshengwugongchengzhiyejishuxueyuan', 'tjswgczyjsxy', 0, '12000000', 113),
 (114, '天津冶金职业技术学院', 'tianjinyejinzhiyejishuxueyuan', 'tjyjzyjsxy', 0, '12000000', 114),
 (115, '天津城市职业学院', 'tianjinchengshizhiyexueyuan', 'tjcszyxy', 0, '12000000', 115),
 (116, '天津海运职业学院', 'tianjinhaiyunzhiyexueyuan', 'tjhyzyxy', 0, '12000000', 116),
 (117, '天津城市建设管理职业技术学院', 'tianjinchengshijiansheguanlizhiyejishuxueyuan', 'tjcsjsglzyjsxy', 0, '12000000', 117),
 (118, '天津铁道职业技术学院', 'tianjintiedaozhiyejishuxueyuan', 'tjtdzyjsxy', 0, '12000000', 118),
 (119, '天津石油职业技术学院', 'tianjinshiyouzhiyejishuxueyuan', 'tjsyzyjsxy', 0, '12000000', 119),
 (120, '天津交通职业学院', 'tianjinjiaotongzhiyexueyuan', 'tjjtzyxy', 0, '12000000', 120),
 (121, '天津青年职业学院', 'tianjinqingnianzhiyexueyuan', 'tjqnzyxy', 0, '12000000', 121),
 (122, '天津工艺美术职业学院', 'tianjingongyimeishuzhiyexueyuan', 'tjgymszyxy', 0, '12000000', 122),
 (123, '天津开发区职业技术学院', 'tianjinkaifaquzhiyejishuxueyuan', 'tjkfqzyjsxy', 0, '12000000', 123),
 (124, '天津艺术职业学院', 'tianjinyishuzhiyexueyuan', 'tjyszyxy', 0, '12000000', 124),
 (125, '天津广播影视职业学院', 'tianjinguangboyingshizhiyexueyuan', 'tjgbyszyxy', 0, '12000000', 125),
 (126, '天津商务职业学院', 'tianjinshangwuzhiyexueyuan', 'tjswzyxy', 0, '12000000', 126),
 (127, '天津国土资源和房屋职业学院', 'tianjinguotuziyuanhefangwuzhiyexueyuan', 'tjgtzyhfwzyxy', 0, '12000000', 127),
 (128, '河北大学', 'hebeidaxue', 'hbdx', 0, '13060000', 128),
 (129, '河北工业大学', 'hebeigongyedaxue', 'hbgydx', 0, '12000000', 129),
 (130, '燕山大学', 'yanshandaxue', 'ysdx', 0, '13030000', 130),
 (131, '河北联合大学', 'hebeilianhedaxue', 'hblhdx', 0, '13020000', 131),
 (132, '河北科技大学', 'hebeikejidaxue', 'hbkjdx', 0, '13010000', 132),
 (133, '石家庄铁道大学', 'shijiazhuangtiedaodaxue', 'sjztddx', 0, '13010000', 133),
 (134, '河北工程大学', 'hebeigongchengdaxue', 'hbgcdx', 0, '13040000', 134),
 (135, '河北农业大学', 'hebeinongyedaxue', 'hbnydx', 0, '13060000', 135),
 (136, '河北医科大学', 'hebeiyikedaxue', 'hbykdx', 0, '13010000', 136),
 (137, '河北师范大学', 'hebeishifandaxue', 'hbsfdx', 0, '13010000', 137),
 (138, '河北经贸大学', 'hebeijingmaodaxue', 'hbjmdx', 0, '13010000', 138),
 (139, '中国人民武装警察部队学院', 'zhongguorenminwuzhuangjingchabuduixueyuan', 'zgrmwzjcbdxy', 0, '13100000', 139),
 (140, '中央司法警官学院', 'zhongyangsifajingguanxueyuan', 'zysfjgxy', 0, '13060000', 140),
 (141, '防灾科技学院', 'fangzaikejixueyuan', 'fzkjxy', 0, '13108200', 141),
 (142, '华北科技学院', 'huabeikejixueyuan', 'hbkjxy', 0, '13108200', 142),
 (143, '石家庄经济学院', 'shijiazhuangjingjixueyuan', 'sjzjjxy', 0, '13010000', 143),
 (144, '河北建筑工程学院', 'hebeijianzhugongchengxueyuan', 'hbjzgcxy', 0, '13070000', 144),
 (145, '北华航天工业学院', 'beihuahangtiangongyexueyuan', 'bhhtgyxy', 0, '13100000', 145),
 (146, '河北科技学院', 'hebeikejixueyuan', 'hbkjxy', 0, '13060000', 146),
 (147, '承德医学院', 'chengdeyixueyuan', 'cdyxy', 0, '13080000', 147),
 (148, '唐山师范学院', 'tangshanshifanxueyuan', 'tssfxy', 0, '13020000', 148),
 (149, '廊坊师范学院', 'langfangshifanxueyuan', 'lfsfxy', 0, '13100000', 149),
 (150, '邢台学院', 'xingtaixueyuan', 'xtxy', 0, '13050000', 150),
 (151, '沧州师范学院', 'cangzhoushifanxueyuan', 'czsfxy', 0, '13090000', 151),
 (152, '河北科技师范学院', 'hebeikejishifanxueyuan', 'hbkjsfxy', 0, '13032200', 152),
 (153, '河北民族师范学院', 'hebeiminzushifanxueyuan', 'hbmzsfxy', 0, '13080000', 153),
 (154, '河北金融学院', 'hebeijinrongxueyuan', 'hbjrxy', 0, '13060000', 154),
 (155, '河北体育学院', 'hebeitiyuxueyuan', 'hbtyxy', 0, '13010000', 155),
 (156, '河北传媒学院', 'hebeichuanmeixueyuan', 'hbcmxy', 0, '13010000', 156),
 (157, '河北美术学院', 'hebeimeishuxueyuan', 'hbmsxy', 0, '13010000', 157),
 (158, '唐山学院', 'tangshanxueyuan', 'tsxy', 0, '13020000', 158),
 (159, '石家庄学院', 'shijiazhuangxueyuan', 'sjzxy', 0, '13010000', 159),
 (160, '衡水学院', 'hengshuixueyuan', 'hsxy', 0, '13110000', 160),
 (161, '邯郸学院', 'handanxueyuan', 'hdxy', 0, '13040000', 161),
 (162, '保定学院', 'baodingxueyuan', 'bdxy', 0, '13060000', 162),
 (163, '河北北方学院', 'hebeibeifangxueyuan', 'hbbfxy', 0, '13070000', 163),
 (164, '沧州医学高等专科学校', 'cangzhouyixuegaodengzhuankexuexiao', 'czyxgdzkxx', 0, '13090000', 164),
 (165, '承德石油高等专科学校', 'chengdeshiyougaodengzhuankexuexiao', 'cdsygdzkxx', 0, '13080000', 165),
 (166, '河北工程技术高等专科学校', 'hebeigongchengjishugaodengzhuankexuexiao', 'hbgcjsgdzkxx', 0, '13090000', 166),
 (167, '石家庄人民医学高等专科学校', 'shijiazhuangrenminyixuegaodengzhuankexuexiao', 'sjzrmyxgdzkxx', 0, '13010000', 167),
 (168, '石家庄医学高等专科学校', 'shijiazhuangyixuegaodengzhuankexuexiao', 'sjzyxgdzkxx', 0, '13010000', 168),
 (169, '邢台医学高等专科学校', 'xingtaiyixuegaodengzhuankexuexiao', 'xtyxgdzkxx', 0, '13050000', 169),
 (170, '石家庄幼儿师范高等专科学校', 'shijiazhuangyoueshifangaodengzhuankexuexiao', 'sjzyesfgdzkxx', 0, '13010000', 170),
 (171, '承德护理职业学院', 'chengdehulizhiyexueyuan', 'cdhlzyxy', 0, '13080000', 171),
 (172, '河北化工医药职业技术学院', 'hebeihuagongyiyaozhiyejishuxueyuan', 'hbhgyyzyjsxy', 0, '13010000', 172),
 (173, '邢台职业技术学院', 'xingtaizhiyejishuxueyuan', 'xtzyjsxy', 0, '13050000', 173),
 (174, '沧州职业技术学院', 'cangzhouzhiyejishuxueyuan', 'czzyjsxy', 0, '13090000', 174),
 (175, '石家庄铁路职业技术学院', 'shijiazhuangtieluzhiyejishuxueyuan', 'sjztlzyjsxy', 0, '13010000', 175),
 (176, '张家口职业技术学院', 'zhangjiakouzhiyejishuxueyuan', 'zjkzyjsxy', 0, '13070000', 176),
 (177, '邯郸职业技术学院', 'handanzhiyejishuxueyuan', 'hdzyjsxy', 0, '13040000', 177),
 (178, '河北工业职业技术学院', 'hebeigongyezhiyejishuxueyuan', 'hbgyzyjsxy', 0, '13010000', 178),
 (179, '河北能源职业技术学院', 'hebeinengyuanzhiyejishuxueyuan', 'hbnyzyjsxy', 0, '13020000', 179),
 (180, '石家庄职业技术学院', 'shijiazhuangzhiyejishuxueyuan', 'sjzzyjsxy', 0, '13010000', 180),
 (181, '保定职业技术学院', 'baodingzhiyejishuxueyuan', 'bdzyjsxy', 0, '13060000', 181),
 (182, '河北司法警官职业学院', 'hebeisifajingguanzhiyexueyuan', 'hbsfjgzyxy', 0, '13040000', 182),
 (183, '衡水职业技术学院', 'hengshuizhiyejishuxueyuan', 'hszyjsxy', 0, '13110000', 183),
 (184, '河北外国语职业学院', 'hebeiwaiguoyuzhiyexueyuan', 'hbwgyzyxy', 0, '13030000', 184),
 (185, '秦皇岛职业技术学院', 'qinhuangdaozhiyejishuxueyuan', 'qhdzyjsxy', 0, '13030000', 185),
 (186, '石家庄外国语职业学院', 'shijiazhuangwaiguoyuzhiyexueyuan', 'sjzwgyzyxy', 0, '13040000', 186),
 (187, '石家庄信息工程职业学院', 'shijiazhuangxinxigongchengzhiyexueyuan', 'sjzxxgczyxy', 0, '13010000', 187),
 (188, '石家庄财经职业学院', 'shijiazhuangcaijingzhiyexueyuan', 'sjzcjzyxy', 0, '13010000', 188),
 (189, '冀中职业学院', 'jizhongzhiyexueyuan', 'jzzyxy', 0, '13060000', 189),
 (190, '河北劳动关系职业学院', 'hebeilaodongguanxizhiyexueyuan', 'hbldgxzyxy', 0, '13040000', 190),
 (191, '河北交通职业技术学院', 'hebeijiaotongzhiyejishuxueyuan', 'hbjtzyjsxy', 0, '13010000', 191),
 (192, '石家庄科技职业学院', 'shijiazhuangkejizhiyexueyuan', 'sjzkjzyxy', 0, '13010000', 192),
 (193, '石家庄外事职业学院', 'shijiazhuangwaishizhiyexueyuan', 'sjzwszyxy', 0, '13010000', 193),
 (194, '石家庄邮电职业技术学院', 'shijiazhuangyoudianzhiyejishuxueyuan', 'sjzydzyjsxy', 0, '13010000', 194),
 (195, '河北政法职业学院', 'hebeizhengfazhiyexueyuan', 'hbzfzyxy', 0, '13010000', 195),
 (196, '石家庄理工职业学院', 'shijiazhuangligongzhiyexueyuan', 'sjzlgzyxy', 0, '13010000', 196),
 (197, '石家庄城市职业学院', 'shijiazhuangchengshizhiyexueyuan', 'sjzcszyxy', 0, '13010000', 197),
 (198, '唐山工业职业技术学院', 'tangshangongyezhiyejishuxueyuan', 'tsgyzyjsxy', 0, '13020000', 198),
 (199, '唐山职业技术学院', 'tangshanzhiyejishuxueyuan', 'tszyjsxy', 0, '13020000', 199),
 (200, '河北旅游职业学院', 'hebeiluyouzhiyexueyuan', 'hblyzyxy', 0, '13080000', 200),
 (201, '河北女子职业技术学院', 'hebeinuzizhiyejishuxueyuan', 'hbnzzyjsxy', 0, '13010000', 201),
 (202, '廊坊东方职业技术学院', 'langfangdongfangzhiyejishuxueyuan', 'lfdfzyjsxy', 0, '13100000', 202),
 (203, '泊头职业学院', 'botouzhiyexueyuan', 'btzyxy', 0, '13090000', 203),
 (204, '宣化科技职业学院', 'xuanhuakejizhiyexueyuan', 'xhkjzyxy', 0, '13070000', 204),
 (205, '廊坊职业技术学院', 'langfangzhiyejishuxueyuan', 'lfzyjsxy', 0, '13100000', 205),
 (206, '保定电力职业技术学院', 'baodingdianlizhiyejishuxueyuan', 'bddlzyjsxy', 0, '13060000', 206),
 (207, '河北机电职业技术学院', 'hebeijidianzhiyejishuxueyuan', 'hbjdzyjsxy', 0, '13050000', 207),
 (208, '唐山科技职业技术学院', 'tangshankejizhiyejishuxueyuan', 'tskjzyjsxy', 0, '13020000', 208),
 (209, '渤海石油职业学院', 'bohaishiyouzhiyexueyuan', 'bhsyzyxy', 0, '13090000', 209),
 (210, '河北公安警察职业学院', 'hebeigonganjingchazhiyexueyuan', 'hbgajczyxy', 0, '13010000', 210),
 (211, '石家庄科技信息职业学院', 'shijiazhuangkejixinxizhiyexueyuan', 'sjzkjxxzyxy', 0, '13010000', 211),
 (212, '河北石油职业技术学院', 'hebeishiyouzhiyejishuxueyuan', 'hbsyzyjsxy', 0, '13100000', 212),
 (213, '河北省艺术职业学院', 'hebeishengyishuzhiyexueyuan', 'hbsyszyxy', 0, '13010000', 213),
 (214, '河北软件职业技术学院', 'hebeiruanjianzhiyejishuxueyuan', 'hbrjzyjsxy', 0, '13060000', 214),
 (215, '石家庄科技工程职业学院', 'shijiazhuangkejigongchengzhiyexueyuan', 'sjzkjgczyxy', 0, '13010000', 215),
 (216, '石家庄外语翻译职业学院', 'shijiazhuangwaiyufanyizhiyexueyuan', 'sjzwyfyzyxy', 0, '13010000', 216),
 (217, '河北建材职业技术学院', 'hebeijiancaizhiyejishuxueyuan', 'hbjczyjsxy', 0, '13030000', 217),
 (218, '石家庄计算机职业学院', 'shijiazhuangjisuanjizhiyexueyuan', 'sjzjsjzyxy', 0, '13010000', 218),
 (219, '廊坊卫生职业学院', 'langfangweishengzhiyexueyuan', 'lfwszyxy', 0, '13100000', 219),
 (220, '石家庄工商职业学院', 'shijiazhuanggongshangzhiyexueyuan', 'sjzgszyxy', 0, '13010000', 220),
 (221, '廊坊燕京职业技术学院', 'langfangyanjingzhiyejishuxueyuan', 'lfyjzyjsxy', 0, '13100000', 221),
 (222, '山西大学', 'shanxidaxue', 'sxdx', 0, '14010000', 222),
 (223, '太原理工大学', 'taiyuanligongdaxue', 'tylgdx', 0, '14010000', 223),
 (224, '中北大学', 'zhongbeidaxue', 'zbdx', 0, '14010000', 224),
 (225, '太原科技大学', 'taiyuankejidaxue', 'tykjdx', 0, '14010000', 225),
 (226, '山西农业大学', 'shanxinongyedaxue', 'sxnydx', 0, '14072600', 226),
 (227, '山西医科大学', 'shanxiyikedaxue', 'sxykdx', 0, '14010000', 227),
 (228, '山西师范大学', 'shanxishifandaxue', 'sxsfdx', 0, '14100000', 228),
 (229, '山西大同大学', 'shanxidatongdaxue', 'sxdtdx', 0, '14020000', 229),
 (230, '山西财经大学', 'shanxicaijingdaxue', 'sxcjdx', 0, '14010000', 230),
 (231, '太原工业学院', 'taiyuangongyexueyuan', 'tygyxy', 0, '14010000', 231),
 (232, '山西中医学院', 'shanxizhongyixueyuan', 'sxzyxy', 0, '14010000', 232),
 (233, '长治医学院', 'changzhiyixueyuan', 'czyxy', 0, '14040000', 233),
 (234, '长治学院', 'changzhixueyuan', 'czxy', 0, '14040000', 234),
 (235, '运城学院', 'yunchengxueyuan', 'ycxy', 0, '14080000', 235),
 (236, '晋中学院', 'jinzhongxueyuan', 'jzxy', 0, '14070200', 236),
 (237, '忻州师范学院', 'xinzhoushifanxueyuan', 'xzsfxy', 0, '14090000', 237),
 (238, '吕梁学院', 'luliangxueyuan', 'llxy', 0, '14110000', 238),
 (239, '太原师范学院', 'taiyuanshifanxueyuan', 'tysfxy', 0, '14010000', 239),
 (240, '山西工商学院', 'shanxigongshangxueyuan', 'sxgsxy', 0, '14010000', 240),
 (241, '太原电力高等专科学校', 'taiyuandianligaodengzhuankexuexiao', 'tydlgdzkxx', 0, '14010000', 241),
 (242, '晋中师范高等专科学校', 'jinzhongshifangaodengzhuankexuexiao', 'jzsfgdzkxx', 0, '14070000', 242),
 (243, '阳泉师范高等专科学校', 'yangquanshifangaodengzhuankexuexiao', 'yqsfgdzkxx', 0, '14030000', 243),
 (244, '运城幼儿师范高等专科学校', 'yunchengyoueshifangaodengzhuankexuexiao', 'ycyesfgdzkxx', 0, '14080000', 244),
 (245, '山西省财政税务专科学校', 'shanxishengcaizhengshuiwuzhuankexuexiao', 'sxsczswzkxx', 0, '14010000', 245),
 (246, '山西警官高等专科学校', 'shanxijingguangaodengzhuankexuexiao', 'sxjggdzkxx', 0, '14010000', 246),
 (247, '太原大学', 'taiyuandaxue', 'tydx', 0, '14010000', 247),
 (248, '大同煤炭职业技术学院', 'datongmeitanzhiyejishuxueyuan', 'dtmtzyjsxy', 0, '14020000', 248),
 (249, '山西职业技术学院', 'shanxizhiyejishuxueyuan', 'sxzyjsxy', 0, '14010000', 249),
 (250, '山西青年职业学院', 'shanxiqingnianzhiyexueyuan', 'sxqnzyxy', 0, '14010000', 250),
 (251, '山西林业职业技术学院', 'shanxilinyezhiyejishuxueyuan', 'sxlyzyjsxy', 0, '14010000', 251),
 (252, '山西水利职业技术学院', 'shanxishuilizhiyejishuxueyuan', 'sxslzyjsxy', 0, '14080000', 252),
 (253, '阳泉职业技术学院', 'yangquanzhiyejishuxueyuan', 'yqzyjsxy', 0, '14030000', 253),
 (254, '山西兴华职业学院', 'shanxixinghuazhiyexueyuan', 'sxxhzyxy', 0, '14010000', 254),
 (255, '山西建筑职业技术学院', 'shanxijianzhuzhiyejishuxueyuan', 'sxjzzyjsxy', 0, '14010000', 255),
 (256, '晋城职业技术学院', 'jinchengzhiyejishuxueyuan', 'jczyjsxy', 0, '14050000', 256),
 (257, '长治职业技术学院', 'changzhizhiyejishuxueyuan', 'czzyjsxy', 0, '14040000', 257),
 (258, '山西生物应用职业技术学院', 'shanxishengwuyingyongzhiyejishuxueyuan', 'sxswyyzyjsxy', 0, '14010000', 258),
 (259, '山西交通职业技术学院', 'shanxijiaotongzhiyejishuxueyuan', 'sxjtzyjsxy', 0, '14010000', 259),
 (260, '山西金融职业学院', 'shanxijinrongzhiyexueyuan', 'sxjrzyxy', 0, '14010000', 260),
 (261, '山西艺术职业学院', 'shanxiyishuzhiyexueyuan', 'sxyszyxy', 0, '14010000', 261),
 (262, '山西工程职业技术学院', 'shanxigongchengzhiyejishuxueyuan', 'sxgczyjsxy', 0, '14010000', 262),
 (263, '太原旅游职业学院', 'taiyuanluyouzhiyexueyuan', 'tylyzyxy', 0, '14010000', 263),
 (264, '忻州职业技术学院', 'xinzhouzhiyejishuxueyuan', 'xzzyjsxy', 0, '14090000', 264),
 (265, '山西体育职业学院', 'shanxitiyuzhiyexueyuan', 'sxtyzyxy', 0, '14010000', 265),
 (266, '山西警官职业学院', 'shanxijingguanzhiyexueyuan', 'sxjgzyxy', 0, '14010000', 266),
 (267, '山西国际商务职业学院', 'shanxiguojishangwuzhiyexueyuan', 'sxgjswzyxy', 0, '14010000', 267),
 (268, '山西电力职业技术学院', 'shanxidianlizhiyejishuxueyuan', 'sxdlzyjsxy', 0, '14010000', 268),
 (269, '运城职业技术学院', 'yunchengzhiyejishuxueyuan', 'yczyjsxy', 0, '14080000', 269),
 (270, '山西财贸职业技术学院', 'shanxicaimaozhiyejishuxueyuan', 'sxcmzyjsxy', 0, '14010000', 270),
 (271, '山西老区职业技术学院', 'shanxilaoquzhiyejishuxueyuan', 'sxlqzyjsxy', 0, '14010000', 271),
 (272, '太原城市职业技术学院', 'taiyuanchengshizhiyejishuxueyuan', 'tycszyjsxy', 0, '14010000', 272),
 (273, '潞安职业技术学院', 'luanzhiyejishuxueyuan', 'lazyjsxy', 0, '14040000', 273),
 (274, '山西旅游职业学院', 'shanxiluyouzhiyexueyuan', 'sxlyzyxy', 0, '14010000', 274),
 (275, '山西管理职业学院', 'shanxiguanlizhiyexueyuan', 'sxglzyxy', 0, '14100000', 275),
 (276, '山西经贸职业学院', 'shanxijingmaozhiyexueyuan', 'sxjmzyxy', 0, '14010000', 276),
 (277, '山西轻工职业技术学院', 'shanxiqinggongzhiyejishuxueyuan', 'sxqgzyjsxy', 0, '14010000', 277),
 (278, '山西煤炭职业技术学院', 'shanximeitanzhiyejishuxueyuan', 'sxmtzyjsxy', 0, '14010000', 278),
 (279, '山西信息职业技术学院', 'shanxixinxizhiyejishuxueyuan', 'sxxxzyjsxy', 0, '14100000', 279),
 (280, '山西华澳商贸职业学院', 'shanxihuaaoshangmaozhiyexueyuan', 'sxhasmzyxy', 0, '14010000', 280),
 (281, '山西戏剧职业学院', 'shanxixijuzhiyexueyuan', 'sxxjzyxy', 0, '14010000', 281),
 (282, '晋中职业技术学院', 'jinzhongzhiyejishuxueyuan', 'jzzyjsxy', 0, '14070200', 282),
 (283, '山西运城农业职业技术学院', 'shanxiyunchengnongyezhiyejishuxueyuan', 'sxycnyzyjsxy', 0, '14080000', 283),
 (284, '朔州职业技术学院', 'shuozhouzhiyejishuxueyuan', 'szzyjsxy', 0, '14060000', 284),
 (285, '临汾职业技术学院', 'linfenzhiyejishuxueyuan', 'lfzyjsxy', 0, '14100000', 285),
 (286, '山西同文职业技术学院', 'shanxitongwenzhiyejishuxueyuan', 'sxtwzyjsxy', 0, '14070000', 286),
 (287, '山西机电职业技术学院', 'shanxijidianzhiyejishuxueyuan', 'sxjdzyjsxy', 0, '14040000', 287),
 (288, '内蒙古大学', 'neimenggudaxue', 'nmgdx', 0, '15010000', 288),
 (289, '内蒙古科技大学', 'neimenggukejidaxue', 'nmgkjdx', 0, '15020000', 289),
 (290, '内蒙古民族大学', 'neimengguminzudaxue', 'nmgmzdx', 0, '15050000', 290),
 (291, '内蒙古工业大学', 'neimenggugongyedaxue', 'nmggydx', 0, '15010000', 291),
 (292, '内蒙古农业大学', 'neimenggunongyedaxue', 'nmgnydx', 0, '15010000', 292),
 (293, '内蒙古师范大学', 'neimenggushifandaxue', 'nmgsfdx', 0, '15010000', 293),
 (294, '内蒙古医学院', 'neimengguyixueyuan', 'nmgyxy', 0, '15010000', 294),
 (295, '赤峰学院', 'chifengxueyuan', 'cfxy', 0, '15040000', 295),
 (296, '呼和浩特民族学院', 'huhehaoteminzuxueyuan', 'hhhtmzxy', 0, '15010000', 296),
 (297, '集宁师范学院', 'jiningshifanxueyuan', 'jnsfxy', 0, '15090200', 297),
 (298, '呼伦贝尔学院', 'hulunbeiexueyuan', 'hlbexy', 0, '15070200', 298),
 (299, '内蒙古财经学院', 'neimenggucaijingxueyuan', 'nmgcjxy', 0, '15010000', 299),
 (300, '乌兰察布医学高等专科学校', 'wulanchabuyixuegaodengzhuankexuexiao', 'wlcbyxgdzkxx', 0, '15090000', 300),
 (301, '满洲里俄语职业学院', 'manzhoulieyuzhiyexueyuan', 'mzleyzyxy', 0, '15078100', 301),
 (302, '包头职业技术学院', 'baotouzhiyejishuxueyuan', 'btzyjsxy', 0, '15020000', 302),
 (303, '内蒙古建筑职业技术学院', 'neimenggujianzhuzhiyejishuxueyuan', 'nmgjzzyjsxy', 0, '15010000', 303),
 (304, '河套大学', 'hetaodaxue', 'htdx', 0, '15080200', 304),
 (305, '内蒙古能源职业学院', 'neimenggunengyuanzhiyexueyuan', 'nmgnyzyxy', 0, '15010000', 305),
 (306, '通辽职业学院', 'tongliaozhiyexueyuan', 'tlzyxy', 0, '15050000', 306),
 (307, '阿拉善职业技术学院', 'alashanzhiyejishuxueyuan', 'alszyjsxy', 0, '64010000', 307),
 (308, '内蒙古化工职业学院', 'neimengguhuagongzhiyexueyuan', 'nmghgzyxy', 0, '15010000', 308),
 (309, '乌海职业技术学院', 'wuhaizhiyejishuxueyuan', 'whzyjsxy', 0, '15030000', 309),
 (310, '内蒙古交通职业技术学院', 'neimenggujiaotongzhiyejishuxueyuan', 'nmgjtzyjsxy', 0, '15040000', 310),
 (311, '赤峰职业技术学院', 'chifengzhiyejishuxueyuan', 'cfzyjsxy', 0, '15040000', 311),
 (312, '内蒙古机电职业技术学院', 'neimenggujidianzhiyejishuxueyuan', 'nmgjdzyjsxy', 0, '15010000', 312),
 (313, '内蒙古科技职业学院', 'neimenggukejizhiyexueyuan', 'nmgkjzyxy', 0, '15010000', 313),
 (314, '内蒙古商贸职业学院', 'neimenggushangmaozhiyexueyuan', 'nmgsmzyxy', 0, '15010000', 314),
 (315, '包头轻工职业技术学院', 'baotouqinggongzhiyejishuxueyuan', 'btqgzyjsxy', 0, '15020000', 315),
 (316, '包头铁道职业技术学院', 'baotoutiedaozhiyejishuxueyuan', 'bttdzyjsxy', 0, '15020000', 316),
 (317, '乌兰察布职业学院', 'wulanchabuzhiyexueyuan', 'wlcbzyxy', 0, '15090000', 317),
 (318, '鄂尔多斯职业学院', 'eeduosizhiyexueyuan', 'eedszyxy', 0, '15060000', 318),
 (319, '科尔沁艺术职业学院', 'keeqinyishuzhiyexueyuan', 'keqyszyxy', 0, '15050200', 319),
 (320, '内蒙古北方职业技术学院', 'neimenggubeifangzhiyejishuxueyuan', 'nmgbfzyjsxy', 0, '15010000', 320),
 (321, '兴安职业技术学院', 'xinganzhiyejishuxueyuan', 'xazyjsxy', 0, '15220100', 321),
 (322, '包头钢铁职业技术学院', 'baotougangtiezhiyejishuxueyuan', 'btgtzyjsxy', 0, '15020000', 322),
 (323, '内蒙古体育职业学院', 'neimenggutiyuzhiyexueyuan', 'nmgtyzyxy', 0, '15010000', 323),
 (324, '内蒙古警察职业学院', 'neimenggujingchazhiyexueyuan', 'nmgjczyxy', 0, '15010000', 324),
 (325, '内蒙古经贸外语职业学院', 'neimenggujingmaowaiyuzhiyexueyuan', 'nmgjmwyzyxy', 0, '15010000', 325),
 (326, '呼和浩特职业学院', 'huhehaotezhiyexueyuan', 'hhhtzyxy', 0, '15010000', 326),
 (327, '锡林郭勒职业学院', 'xilinguolezhiyexueyuan', 'xlglzyxy', 0, '15250000', 327),
 (328, '赤峰工业职业技术学院', 'chifenggongyezhiyejishuxueyuan', 'cfgyzyjsxy', 0, '15040000', 328),
 (329, '内蒙古电子信息职业技术学院', 'neimenggudianzixinxizhiyejishuxueyuan', 'nmgdzxxzyjsxy', 0, '15010000', 329),
 (330, '内蒙古丰州职业学院', 'neimenggufengzhouzhiyexueyuan', 'nmgfzzyxy', 0, '15010000', 330),
 (331, '内蒙古轩元职业学院', 'neimengguxuanyuanzhiyexueyuan', 'nmgxyzyxy', 0, '15010000', 331),
 (332, '呼伦贝尔职业技术学院', 'hulunbeiezhiyejishuxueyuan', 'hlbezyjsxy', 0, '15070000', 332),
 (333, '大连理工大学', 'dalianligongdaxue', 'dllgdx', 0, '21020000', 333),
 (334, '东北大学', 'dongbeidaxue', 'dbdx', 0, '21010000', 334),
 (335, '大连海事大学', 'dalianhaishidaxue', 'dlhsdx', 0, '21020000', 335),
 (336, '辽宁大学', 'liaoningdaxue', 'lndx', 0, '21010000', 336),
 (337, '沈阳大学', 'shenyangdaxue', 'sydx', 0, '21010000', 337),
 (338, '大连大学', 'daliandaxue', 'dldx', 0, '21020000', 338),
 (339, '沈阳理工大学', 'shenyangligongdaxue', 'sylgdx', 0, '21010000', 339),
 (340, '辽宁工程技术大学', 'liaoninggongchengjishudaxue', 'lngcjsdx', 0, '21090000', 340),
 (341, '沈阳工业大学', 'shenyanggongyedaxue', 'sygydx', 0, '21010000', 341),
 (342, '沈阳建筑大学', 'shenyangjianzhudaxue', 'syjzdx', 0, '21010000', 342),
 (343, '辽宁石油化工大学', 'liaoningshiyouhuagongdaxue', 'lnsyhgdx', 0, '21040000', 343),
 (344, '大连交通大学', 'dalianjiaotongdaxue', 'dljtdx', 0, '21020000', 344),
 (345, '沈阳化工大学', 'shenyanghuagongdaxue', 'syhgdx', 0, '21010000', 345),
 (346, '辽宁科技大学', 'liaoningkejidaxue', 'lnkjdx', 0, '21030000', 346),
 (347, '辽宁工业大学', 'liaoninggongyedaxue', 'lngydx', 0, '21070000', 347),
 (348, '大连工业大学', 'daliangongyedaxue', 'dlgydx', 0, '21020000', 348),
 (349, '沈阳航空航天大学', 'shenyanghangkonghangtiandaxue', 'syhkhtdx', 0, '21010000', 349),
 (350, '沈阳农业大学', 'shenyangnongyedaxue', 'synydx', 0, '21010000', 350),
 (351, '大连海洋大学', 'dalianhaiyangdaxue', 'dlhydx', 0, '21020000', 351),
 (352, '中国医科大学', 'zhongguoyikedaxue', 'zgykdx', 0, '21010000', 352),
 (353, '大连医科大学', 'dalianyikedaxue', 'dlykdx', 0, '21020000', 353),
 (354, '辽宁中医药大学', 'liaoningzhongyiyaodaxue', 'lnzyydx', 0, '21010000', 354),
 (355, '沈阳药科大学', 'shenyangyaokedaxue', 'syykdx', 0, '21010000', 355),
 (356, '辽宁师范大学', 'liaoningshifandaxue', 'lnsfdx', 0, '21020000', 356),
 (357, '沈阳师范大学', 'shenyangshifandaxue', 'sysfdx', 0, '21010000', 357),
 (358, '渤海大学', 'bohaidaxue', 'bhdx', 0, '21070000', 358),
 (359, '东北财经大学', 'dongbeicaijingdaxue', 'dbcjdx', 0, '21020000', 359),
 (360, '大连民族学院', 'dalianminzuxueyuan', 'dlmzxy', 0, '21020000', 360),
 (361, '中国刑事警察学院', 'zhongguoxingshijingchaxueyuan', 'zgxsjcxy', 0, '21010000', 361),
 (362, '沈阳工程学院', 'shenyanggongchengxueyuan', 'sygcxy', 0, '21010000', 362),
 (363, '辽宁科技学院', 'liaoningkejixueyuan', 'lnkjxy', 0, '21050000', 363),
 (364, '大连东软信息学院', 'daliandongruanxinxixueyuan', 'dldrxxxy', 0, '21020000', 364),
 (365, '大连科技学院', 'daliankejixueyuan', 'dlkjxy', 0, '21020000', 365),
 (366, '辽宁医学院', 'liaoningyixueyuan', 'lnyxy', 0, '21070000', 366),
 (367, '沈阳医学院', 'shenyangyixueyuan', 'syyxy', 0, '21010000', 367),
 (368, '辽宁何氏医学院', 'liaoningheshiyixueyuan', 'lnhsyxy', 0, '21010000', 368),
 (369, '鞍山师范学院', 'anshanshifanxueyuan', 'assfxy', 0, '21030000', 369),
 (370, '大连外国语学院', 'dalianwaiguoyuxueyuan', 'dlwgyxy', 0, '21020000', 370),
 (371, '辽宁财贸学院', 'liaoningcaimaoxueyuan', 'lncmxy', 0, '21140000', 371),
 (372, '沈阳体育学院', 'shenyangtiyuxueyuan', 'sytyxy', 0, '21010000', 372),
 (373, '鲁迅美术学院', 'luxunmeishuxueyuan', 'lxmsxy', 0, '21010000', 373),
 (374, '沈阳音乐学院', 'shenyangyinlexueyuan', 'syylxy', 0, '21010000', 374),
 (375, '大连艺术学院', 'dalianyishuxueyuan', 'dlysxy', 0, '21020000', 375),
 (376, '辽宁对外经贸学院', 'liaoningduiwaijingmaoxueyuan', 'lndwjmxy', 0, '21020000', 376),
 (377, '辽东学院', 'liaodongxueyuan', 'ldxy', 0, '21060000', 377),
 (378, '辽宁交通高等专科学校', 'liaoningjiaotonggaodengzhuankexuexiao', 'lnjtgdzkxx', 0, '21010000', 378),
 (379, '抚顺师范高等专科学校', 'fushunshifangaodengzhuankexuexiao', 'fssfgdzkxx', 0, '21040000', 379),
 (380, '锦州师范高等专科学校', 'jinzhoushifangaodengzhuankexuexiao', 'jzsfgdzkxx', 0, '21070000', 380),
 (381, '朝阳师范高等专科学校', 'chaoyangshifangaodengzhuankexuexiao', 'cysfgdzkxx', 0, '21130000', 381),
 (382, '铁岭师范高等专科学校', 'tielingshifangaodengzhuankexuexiao', 'tlsfgdzkxx', 0, '21120000', 382),
 (383, '辽宁税务高等专科学校', 'liaoningshuiwugaodengzhuankexuexiao', 'lnswgdzkxx', 0, '21020000', 383),
 (384, '辽宁警官高等专科学校', 'liaoningjingguangaodengzhuankexuexiao', 'lnjggdzkxx', 0, '21020000', 384),
 (385, '阜新高等专科学校', 'fuxingaodengzhuankexuexiao', 'fxgdzkxx', 0, '21090000', 385),
 (386, '辽宁城市建设职业技术学院', 'liaoningchengshijianshezhiyejishuxueyuan', 'lncsjszyjsxy', 0, '21010000', 386),
 (387, '辽宁冶金职业技术学院', 'liaoningyejinzhiyejishuxueyuan', 'lnyjzyjsxy', 0, '21050000', 387),
 (388, '辽宁工程职业学院', 'liaoninggongchengzhiyexueyuan', 'lngczyxy', 0, '21120000', 388),
 (389, '铁岭卫生职业学院', 'tielingweishengzhiyexueyuan', 'tlwszyxy', 0, '21120000', 389),
 (390, '辽宁卫生职业技术学院', 'liaoningweishengzhiyejishuxueyuan', 'lnwszyjsxy', 0, '21010000', 390),
 (391, '大连商务职业学院', 'dalianshangwuzhiyexueyuan', 'dlswzyxy', 0, '21020000', 391),
 (392, '渤海船舶职业学院', 'bohaichuanbozhiyexueyuan', 'bhcbzyxy', 0, '21140000', 392),
 (393, '辽宁农业职业技术学院', 'liaoningnongyezhiyejishuxueyuan', 'lnnyzyjsxy', 0, '21080000', 393),
 (394, '营口职业技术学院', 'yingkouzhiyejishuxueyuan', 'ykzyjsxy', 0, '21080000', 394),
 (395, '大连职业技术学院', 'dalianzhiyejishuxueyuan', 'dlzyjsxy', 0, '21020000', 395),
 (396, '辽阳职业技术学院', 'liaoyangzhiyejishuxueyuan', 'lyzyjsxy', 0, '21100000', 396),
 (397, '抚顺职业技术学院', 'fushunzhiyejishuxueyuan', 'fszyjsxy', 0, '21040000', 397),
 (398, '盘锦职业技术学院', 'panjinzhiyejishuxueyuan', 'pjzyjsxy', 0, '21110000', 398),
 (399, '辽宁现代服务职业技术学院', 'liaoningxiandaifuwuzhiyejishuxueyuan', 'lnxdfwzyjsxy', 0, '21010000', 399),
 (400, '大连航运职业技术学院', 'dalianhangyunzhiyejishuxueyuan', 'dlhyzyjsxy', 0, '21020000', 400),
 (401, '辽宁广告职业学院', 'liaoningguanggaozhiyexueyuan', 'lnggzyxy', 0, '21010000', 401),
 (402, '辽宁体育运动职业技术学院', 'liaoningtiyuyundongzhiyejishuxueyuan', 'lntyydzyjsxy', 0, '21010000', 402),
 (403, '辽宁职业学院', 'liaoningzhiyexueyuan', 'lnzyxy', 0, '21120000', 403),
 (404, '大连装备制造职业技术学院', 'dalianzhuangbeizhizaozhiyejishuxueyuan', 'dlzbzzzyjsxy', 0, '21020000', 404),
 (405, '大连汽车职业技术学院', 'dalianqichezhiyejishuxueyuan', 'dlqczyjsxy', 0, '21020000', 405),
 (406, '辽宁林业职业技术学院', 'liaoninglinyezhiyejishuxueyuan', 'lnlyzyjsxy', 0, '21010000', 406),
 (407, '辽宁金融职业学院', 'liaoningjinrongzhiyexueyuan', 'lnjrzyxy', 0, '21010000', 407),
 (408, '大连艺术职业学院', 'dalianyishuzhiyexueyuan', 'dlyszyxy', 0, '21020000', 408),
 (409, '辽宁铁道职业技术学院', 'liaoningtiedaozhiyejishuxueyuan', 'lntdzyjsxy', 0, '21070000', 409),
 (410, '大连东软信息技术职业学院', 'daliandongruanxinxijishuzhiyexueyuan', 'dldrxxjszyxy', 0, '21020000', 410),
 (411, '辽宁理工职业学院', 'liaoningligongzhiyexueyuan', 'lnlgzyxy', 0, '21070000', 411),
 (412, '辽宁石化职业技术学院', 'liaoningshihuazhiyejishuxueyuan', 'lnshzyjsxy', 0, '21070000', 412),
 (413, '辽宁经济职业技术学院', 'liaoningjingjizhiyejishuxueyuan', 'lnjjzyjsxy', 0, '21010000', 413),
 (414, '辽宁机电职业技术学院', 'liaoningjidianzhiyejishuxueyuan', 'lnjdzyjsxy', 0, '21060000', 414),
 (415, '辽宁建筑职业技术学院', 'liaoningjianzhuzhiyejishuxueyuan', 'lnjzzyjsxy', 0, '21010000', 415),
 (416, '沈阳职业技术学院', 'shenyangzhiyejishuxueyuan', 'syzyjsxy', 0, '21010000', 416),
 (417, '辽宁信息职业技术学院', 'liaoningxinxizhiyejishuxueyuan', 'lnxxzyjsxy', 0, '21100000', 417),
 (418, '沈阳航空职业技术学院', 'shenyanghangkongzhiyejishuxueyuan', 'syhkzyjsxy', 0, '21010000', 418),
 (419, '辽宁地质工程职业学院', 'liaoningdizhigongchengzhiyexueyuan', 'lndzgczyxy', 0, '21060000', 419),
 (420, '辽宁美术职业学院', 'liaoningmeishuzhiyexueyuan', 'lnmszyxy', 0, '21010000', 420),
 (421, '大连软件职业学院', 'dalianruanjianzhiyexueyuan', 'dlrjzyxy', 0, '21020000', 421),
 (422, '大连翻译职业学院', 'dalianfanyizhiyexueyuan', 'dlfyzyxy', 0, '21020000', 422),
 (423, '辽宁商贸职业学院', 'liaoningshangmaozhiyexueyuan', 'lnsmzyxy', 0, '21010000', 423),
 (424, '大连枫叶职业技术学院', 'dalianfengyezhiyejishuxueyuan', 'dlfyzyjsxy', 0, '21020000', 424),
 (425, '辽宁装备制造职业技术学院', 'liaoningzhuangbeizhizaozhiyejishuxueyuan', 'lnzbzzzyjsxy', 0, '21010000', 425),
 (426, '辽河石油职业技术学院', 'liaoheshiyouzhiyejishuxueyuan', 'lhsyzyjsxy', 0, '21110000', 426),
 (427, '吉林大学', 'jilindaxue', 'jldx', 0, '22010000', 427),
 (428, '东北师范大学', 'dongbeishifandaxue', 'dbsfdx', 0, '22010000', 428),
 (429, '延边大学', 'yanbiandaxue', 'ybdx', 0, '22240100', 429),
 (430, '北华大学', 'beihuadaxue', 'bhdx', 0, '22020000', 430),
 (431, '长春大学', 'changchundaxue', 'ccdx', 0, '22010000', 431),
 (432, '长春理工大学', 'changchunligongdaxue', 'cclgdx', 0, '22010000', 432),
 (433, '长春工业大学', 'changchungongyedaxue', 'ccgydx', 0, '22010000', 433),
 (434, '吉林农业大学', 'jilinnongyedaxue', 'jlnydx', 0, '22010000', 434),
 (435, '长春中医药大学', 'changchunzhongyiyaodaxue', 'cczyydx', 0, '22010000', 435),
 (436, '吉林师范大学', 'jilinshifandaxue', 'jlsfdx', 0, '22030000', 436),
 (437, '吉林财经大学', 'jilincaijingdaxue', 'jlcjdx', 0, '22010000', 437),
 (438, '东北电力大学', 'dongbeidianlidaxue', 'dbdldx', 0, '22020000', 438),
 (439, '长春工程学院', 'changchungongchengxueyuan', 'ccgcxy', 0, '22010000', 439),
 (440, '吉林建筑工程学院', 'jilinjianzhugongchengxueyuan', 'jljzgcxy', 0, '22010000', 440),
 (441, '吉林化工学院', 'jilinhuagongxueyuan', 'jlhgxy', 0, '22020000', 441),
 (442, '长春建筑学院', 'changchunjianzhuxueyuan', 'ccjzxy', 0, '22010000', 442),
 (443, '吉林农业科技学院', 'jilinnongyekejixueyuan', 'jlnykjxy', 0, '22020000', 443),
 (444, '吉林医药学院', 'jilinyiyaoxueyuan', 'jlyyxy', 0, '22020000', 444),
 (445, '吉林工程技术师范学院', 'jilingongchengjishushifanxueyuan', 'jlgcjssfxy', 0, '22010000', 445),
 (446, '通化师范学院', 'tonghuashifanxueyuan', 'thsfxy', 0, '22050000', 446),
 (447, '长春师范学院', 'changchunshifanxueyuan', 'ccsfxy', 0, '22010000', 447),
 (448, '白城师范学院', 'baichengshifanxueyuan', 'bcsfxy', 0, '22080000', 448),
 (449, '吉林华桥外国语学院', 'jilinhuaqiaowaiguoyuxueyuan', 'jlhqwgyxy', 0, '22010000', 449),
 (450, '吉林工商学院', 'jilingongshangxueyuan', 'jlgsxy', 0, '22010000', 450),
 (451, '吉林警察学院', 'jilinjingchaxueyuan', 'jljcxy', 0, '22010000', 451),
 (452, '吉林体育学院', 'jilintiyuxueyuan', 'jltyxy', 0, '22010000', 452),
 (453, '吉林艺术学院', 'jilinyishuxueyuan', 'jlysxy', 0, '22010000', 453),
 (454, '吉林动画学院', 'jilindonghuaxueyuan', 'jldhxy', 0, '22010000', 454),
 (455, '白城医学高等专科学校', 'baichengyixuegaodengzhuankexuexiao', 'bcyxgdzkxx', 0, '22080000', 455),
 (456, '长春汽车工业高等专科学校', 'changchunqichegongyegaodengzhuankexuexiao', 'ccqcgygdzkxx', 0, '22010000', 456),
 (457, '长春医学高等专科学校', 'changchunyixuegaodengzhuankexuexiao', 'ccyxgdzkxx', 0, '22010000', 457),
 (458, '长春金融高等专科学校', 'changchunjinronggaodengzhuankexuexiao', 'ccjrgdzkxx', 0, '22010000', 458),
 (459, '吉林科技职业技术学院', 'jilinkejizhiyejishuxueyuan', 'jlkjzyjsxy', 0, '22010000', 459),
 (460, '吉林交通职业技术学院', 'jilinjiaotongzhiyejishuxueyuan', 'jljtzyjsxy', 0, '22010000', 460),
 (461, '长春东方职业学院', 'changchundongfangzhiyexueyuan', 'ccdfzyxy', 0, '22010000', 461),
 (462, '辽源职业技术学院', 'liaoyuanzhiyejishuxueyuan', 'lyzyjsxy', 0, '22040000', 462),
 (463, '四平职业大学', 'sipingzhiyedaxue', 'spzydx', 0, '22030000', 463),
 (464, '吉林司法警官职业学院', 'jilinsifajingguanzhiyexueyuan', 'jlsfjgzyxy', 0, '22010000', 464),
 (465, '长白山职业技术学院', 'changbaishanzhiyejishuxueyuan', 'cbszyjsxy', 0, '22060000', 465),
 (466, '长春信息技术职业学院', 'changchunxinxijishuzhiyexueyuan', 'ccxxjszyxy', 0, '22010000', 466),
 (467, '白城职业技术学院', 'baichengzhiyejishuxueyuan', 'bczyjsxy', 0, '22080000', 467),
 (468, '长春职业技术学院', 'changchunzhiyejishuxueyuan', 'cczyjsxy', 0, '22010000', 468),
 (469, '吉林农业工程职业技术学院', 'jilinnongyegongchengzhiyejishuxueyuan', 'jlnygczyjsxy', 0, '22038100', 469),
 (470, '吉林工业职业技术学院', 'jilingongyezhiyejishuxueyuan', 'jlgyzyjsxy', 0, '22020000', 470),
 (471, '松原职业技术学院', 'songyuanzhiyejishuxueyuan', 'syzyjsxy', 0, '22070000', 471),
 (472, '延边职业技术学院', 'yanbianzhiyejishuxueyuan', 'ybzyjsxy', 0, '22240100', 472),
 (473, '吉林铁道职业技术学院', 'jilintiedaozhiyejishuxueyuan', 'jltdzyjsxy', 0, '22020000', 473),
 (474, '吉林电子信息职业技术学院', 'jilindianzixinxizhiyejishuxueyuan', 'jldzxxzyjsxy', 0, '22020000', 474),
 (475, '东北林业大学', 'dongbeilinyedaxue', 'dblydx', 0, '23010000', 475),
 (476, '哈尔滨工业大学', 'haebingongyedaxue', 'hebgydx', 0, '23010000', 476),
 (477, '哈尔滨工程大学', 'haebingongchengdaxue', 'hebgcdx', 0, '23010000', 477),
 (478, '黑龙江大学', 'heilongjiangdaxue', 'hljdx', 0, '23010000', 478),
 (479, '佳木斯大学', 'jiamusidaxue', 'jmsdx', 0, '23080000', 479),
 (480, '齐齐哈尔大学', 'qiqihaedaxue', 'qqhedx', 0, '23020000', 480),
 (481, '哈尔滨理工大学', 'haebinligongdaxue', 'heblgdx', 0, '23010000', 481),
 (482, '东北石油大学', 'dongbeishiyoudaxue', 'dbsydx', 0, '23060000', 482),
 (483, '东北农业大学', 'dongbeinongyedaxue', 'dbnydx', 0, '23010000', 483),
 (484, '黑龙江八一农垦大学', 'heilongjiangbayinongkendaxue', 'hljbynkdx', 0, '23060000', 484),
 (485, '哈尔滨医科大学', 'haebinyikedaxue', 'hebykdx', 0, '23010000', 485),
 (486, '黑龙江中医药大学', 'heilongjiangzhongyiyaodaxue', 'hljzyydx', 0, '23010000', 486),
 (487, '哈尔滨师范大学', 'haebinshifandaxue', 'hebsfdx', 0, '23010000', 487),
 (488, '哈尔滨商业大学', 'haebinshangyedaxue', 'hebsydx', 0, '23010000', 488),
 (489, '齐齐哈尔工程学院', 'qiqihaegongchengxueyuan', 'qqhegcxy', 0, '23020000', 489),
 (490, '黑龙江科技学院', 'heilongjiangkejixueyuan', 'hljkjxy', 0, '23010000', 490),
 (491, '黑龙江工程学院', 'heilongjianggongchengxueyuan', 'hljgcxy', 0, '23010000', 491),
 (492, '哈尔滨学院', 'haebinxueyuan', 'hebxy', 0, '23010000', 492),
 (493, '牡丹江医学院', 'mudanjiangyixueyuan', 'mdjyxy', 0, '23100000', 493),
 (494, '齐齐哈尔医学院', 'qiqihaeyixueyuan', 'qqheyxy', 0, '23020000', 494),
 (495, '大庆师范学院', 'daqingshifanxueyuan', 'dqsfxy', 0, '23060000', 495),
 (496, '牡丹江师范学院', 'mudanjiangshifanxueyuan', 'mdjsfxy', 0, '23100000', 496),
 (497, '黑龙江外国语学院', 'heilongjiangwaiguoyuxueyuan', 'hljwgyxy', 0, '23010000', 497),
 (498, '哈尔滨金融学院', 'haebinjinrongxueyuan', 'hebjrxy', 0, '23010000', 498),
 (499, '哈尔滨德强商务学院', 'haebindeqiangshangwuxueyuan', 'hebdqswxy', 0, '23010000', 499),
 (500, '哈尔滨体育学院', 'haebintiyuxueyuan', 'hebtyxy', 0, '23010000', 500);
 INSERT `tn_Schools` (`Id`, `Name`, `PinyinName`, `ShortPinyinName`, `SchoolType`, `AreaCode`, `DisplayOrder`)
 VALUES
 (501, '绥化学院', 'suihuaxueyuan', 'shxy', 0, '23120000', 501),
 (502, '黑龙江东方学院', 'heilongjiangdongfangxueyuan', 'hljdfxy', 0, '23010000', 502),
 (503, '哈尔滨剑桥学院', 'haebinjianqiaoxueyuan', 'hebjqxy', 0, '23010000', 503),
 (504, '黑河学院', 'heihexueyuan', 'hhxy', 0, '23110000', 504),
 (505, '哈尔滨华德学院', 'haebinhuadexueyuan', 'hebhdxy', 0, '23010000', 505),
 (506, '大庆医学高等专科学校', 'daqingyixuegaodengzhuankexuexiao', 'dqyxgdzkxx', 0, '23060000', 506),
 (507, '黑龙江护理高等专科学校', 'heilongjianghuligaodengzhuankexuexiao', 'hljhlgdzkxx', 0, '23010000', 507),
 (508, '齐齐哈尔高等师范专科学校', 'qiqihaegaodengshifanzhuankexuexiao', 'qqhegdsfzkxx', 0, '23020000', 508),
 (509, '黑龙江幼儿师范高等专科学校', 'heilongjiangyoueshifangaodengzhuankexuexiao', 'hljyesfgdzkxx', 0, '23100000', 509),
 (510, '鹤岗师范高等专科学校', 'hegangshifangaodengzhuankexuexiao', 'hgsfgdzkxx', 0, '23040000', 510),
 (511, '黑龙江科技职业学院', 'heilongjiangkejizhiyexueyuan', 'hljkjzyxy', 0, '23018200', 511),
 (512, '大庆职业学院', 'daqingzhiyexueyuan', 'dqzyxy', 0, '23060000', 512),
 (513, '黑龙江农业职业技术学院', 'heilongjiangnongyezhiyejishuxueyuan', 'hljnyzyjsxy', 0, '23100000', 513),
 (514, '鸡西大学', 'jixidaxue', 'jxdx', 0, '23030000', 514),
 (515, '黑龙江农业工程职业学院', 'heilongjiangnongyegongchengzhiyexueyuan', 'hljnygczyxy', 0, '23010000', 515),
 (516, '黑龙江司法警官职业学院', 'heilongjiangsifajingguanzhiyexueyuan', 'hljsfjgzyxy', 0, '23010000', 516),
 (517, '黑龙江林业职业技术学院', 'heilongjianglinyezhiyejishuxueyuan', 'hljlyzyjsxy', 0, '23100000', 517),
 (518, '黑龙江建筑职业技术学院', 'heilongjiangjianzhuzhiyejishuxueyuan', 'hljjzzyjsxy', 0, '23010000', 518),
 (519, '牡丹江大学', 'mudanjiangdaxue', 'mdjdx', 0, '23100000', 519),
 (520, '黑龙江农垦职业学院', 'heilongjiangnongkenzhiyexueyuan', 'hljnkzyxy', 0, '23010000', 520),
 (521, '伊春职业学院', 'yichunzhiyexueyuan', 'yczyxy', 0, '23070000', 521),
 (522, '大兴安岭职业学院', 'daxinganlingzhiyexueyuan', 'dxalzyxy', 0, '23270000', 522),
 (523, '黑龙江民族职业学院', 'heilongjiangminzuzhiyexueyuan', 'hljmzzyxy', 0, '23010000', 523),
 (524, '哈尔滨江南职业技术学院', 'haebinjiangnazhiyejishuxueyuan', 'hebjnzyjsxy', 0, '23010000', 524),
 (525, '黑龙江农业经济职业学院', 'heilongjiangnongyejingjizhiyexueyuan', 'hljnyjjzyxy', 0, '23100000', 525),
 (526, '黑龙江工商职业技术学院', 'heilongjianggongshangzhiyejishuxueyuan', 'hljgszyjsxy', 0, '23010000', 526),
 (527, '哈尔滨电力职业技术学院', 'haebindianlizhiyejishuxueyuan', 'hebdlzyjsxy', 0, '23010000', 527),
 (528, '七台河职业学院', 'qitaihezhiyexueyuan', 'qthzyxy', 0, '23090000', 528),
 (529, '哈尔滨铁道职业技术学院', 'haebintiedaozhiyejishuxueyuan', 'hebtdzyjsxy', 0, '23010000', 529),
 (530, '黑龙江公安警官职业学院', 'heilongjianggonganjingguanzhiyexueyuan', 'hljgajgzyxy', 0, '23010000', 530),
 (531, '黑龙江信息技术职业学院', 'heilongjiangxinxijishuzhiyexueyuan', 'hljxxjszyxy', 0, '23010000', 531),
 (532, '黑龙江煤炭职业技术学院', 'heilongjiangmeitanzhiyejishuxueyuan', 'hljmtzyjsxy', 0, '23050000', 532),
 (533, '黑龙江生态工程职业学院', 'heilongjiangshengtaigongchengzhiyexueyuan', 'hljstgczyxy', 0, '23010000', 533),
 (534, '黑龙江三江美术职业学院', 'heilongjiangsanjiangmeishuzhiyexueyuan', 'hljsjmszyxy', 0, '23010000', 534),
 (535, '黑龙江旅游职业技术学院', 'heilongjiangluyouzhiyejishuxueyuan', 'hljlyzyjsxy', 0, '23010000', 535),
 (536, '哈尔滨科学技术职业学院', 'haebinkexuejishuzhiyexueyuan', 'hebkxjszyxy', 0, '23010000', 536),
 (537, '黑龙江农垦科技职业学院', 'heilongjiangnongkenkejizhiyexueyuan', 'hljnkkjzyxy', 0, '23120000', 537),
 (538, '哈尔滨职业技术学院', 'haebinzhiyejishuxueyuan', 'hebzyjsxy', 0, '23010000', 538),
 (539, '黑龙江生物科技职业学院', 'heilongjiangshengwukejizhiyexueyuan', 'hljswkjzyxy', 0, '23010000', 539),
 (540, '佳木斯职业学院', 'jiamusizhiyexueyuan', 'jmszyxy', 0, '23080000', 540),
 (541, '哈尔滨现代公共关系职业学院', 'haebinxiandaigonggongguanxizhiyexueyuan', 'hebxdgggxzyxy', 0, '23010000', 541),
 (542, '黑龙江粮食职业学院', 'heilongjiangliangshizhiyexueyuan', 'hljlszyxy', 0, '23010000', 542),
 (543, '哈尔滨华夏计算机职业技术学院', 'haebinhuaxiajisuanjizhiyejishuxueyuan', 'hebhxjsjzyjsxy', 0, '23010000', 543),
 (544, '黑龙江艺术职业学院', 'heilongjiangyishuzhiyexueyuan', 'hljyszyxy', 0, '23010000', 544),
 (545, '哈尔滨应用职业技术学院', 'haebinyingyongzhiyejishuxueyuan', 'hebyyzyjsxy', 0, '23010000', 545),
 (546, '黑龙江交通职业技术学院', 'heilongjiangjiaotongzhiyejishuxueyuan', 'hljjtzyjsxy', 0, '23020000', 546),
 (547, '黑龙江商业职业学院', 'heilongjiangshangyezhiyexueyuan', 'hljsyzyxy', 0, '23100000', 547),
 (548, '复旦大学', 'fudandaxue', 'fddx', 0, '31000000', 548),
 (549, '同济大学', 'tongjidaxue', 'tjdx', 0, '31000000', 549),
 (550, '上海交通大学', 'shanghaijiaotongdaxue', 'shjtdx', 0, '31000000', 550),
 (551, '华东理工大学', 'huadongligongdaxue', 'hdlgdx', 0, '31000000', 551),
 (552, '东华大学', 'donghuadaxue', 'dhdx', 0, '31000000', 552),
 (553, '华东师范大学', 'huadongshifandaxue', 'hdsfdx', 0, '31000000', 553),
 (554, '上海外国语大学', 'shanghaiwaiguoyudaxue', 'shwgydx', 0, '31000000', 554),
 (555, '上海财经大学', 'shanghaicaijingdaxue', 'shcjdx', 0, '31000000', 555),
 (556, '上海大学', 'shanghaidaxue', 'shdx', 0, '31000000', 556),
 (557, '上海理工大学', 'shanghailigongdaxue', 'shlgdx', 0, '31000000', 557),
 (558, '上海海事大学', 'shanghaihaishidaxue', 'shhsdx', 0, '31000000', 558),
 (559, '上海工程技术大学', 'shanghaigongchengjishudaxue', 'shgcjsdx', 0, '31000000', 559),
 (560, '上海海洋大学', 'shanghaihaiyangdaxue', 'shhydx', 0, '31000000', 560),
 (561, '上海中医药大学', 'shanghaizhongyiyaodaxue', 'shzyydx', 0, '31000000', 561),
 (562, '上海师范大学', 'shanghaishifandaxue', 'shsfdx', 0, '31000000', 562),
 (563, '华东政法大学', 'huadongzhengfadaxue', 'hdzfdx', 0, '31000000', 563),
 (564, '上海海关学院', 'shanghaihaiguanxueyuan', 'shhgxy', 0, '31000000', 564),
 (565, '上海建桥学院', 'shanghaijianqiaoxueyuan', 'shjqxy', 0, '31000000', 565),
 (566, '上海政法学院', 'shanghaizhengfaxueyuan', 'shzfxy', 0, '31000000', 566),
 (567, '上海应用技术学院', 'shanghaiyingyongjishuxueyuan', 'shyyjsxy', 0, '31000000', 567),
 (568, '上海电力学院', 'shanghaidianlixueyuan', 'shdlxy', 0, '31000000', 568),
 (569, '上海第二工业大学', 'shanghaidiegongyedaxue', 'shdegydx', 0, '31000000', 569),
 (570, '上海电机学院', 'shanghaidianjixueyuan', 'shdjxy', 0, '31000000', 570),
 (571, '上海对外贸易学院', 'shanghaiduiwaimaoyixueyuan', 'shdwmyxy', 0, '31000000', 571),
 (572, '上海金融学院', 'shanghaijinrongxueyuan', 'shjrxy', 0, '31000000', 572),
 (573, '上海商学院', 'shanghaishangxueyuan', 'shsxy', 0, '31000000', 573),
 (574, '上海立信会计学院', 'shanghailixinhuijixueyuan', 'shlxhjxy', 0, '31000000', 574),
 (575, '上海体育学院', 'shanghaitiyuxueyuan', 'shtyxy', 0, '31000000', 575),
 (576, '上海音乐学院', 'shanghaiyinlexueyuan', 'shylxy', 0, '31000000', 576),
 (577, '上海戏剧学院', 'shanghaixijuxueyuan', 'shxjxy', 0, '31000000', 577),
 (578, '上海杉达学院', 'shanghaishadaxueyuan', 'shsdxy', 0, '31000000', 578),
 (579, '上海医疗器械高等专科学校', 'shanghaiyiliaoqixiegaodengzhuankexuexiao', 'shylqxgdzkxx', 0, '31000000', 579),
 (580, '上海出版印刷高等专科学校', 'shanghaichubanyinshuagaodengzhuankexuexiao', 'shcbysgdzkxx', 0, '31000000', 580),
 (581, '上海医药高等专科学校', 'shanghaiyiyaogaodengzhuankexuexiao', 'shyygdzkxx', 0, '31000000', 581),
 (582, '上海旅游高等专科学校', 'shanghailuyougaodengzhuankexuexiao', 'shlygdzkxx', 0, '31000000', 582),
 (583, '上海公安高等专科学校', 'shanghaigongangaodengzhuankexuexiao', 'shgagdzkxx', 0, '31000000', 583),
 (584, '上海电影艺术职业学院', 'shanghaidianyingyishuzhiyexueyuan', 'shdyyszyxy', 0, '31000000', 584),
 (585, '上海健康职业技术学院', 'shanghaijiankangzhiyejishuxueyuan', 'shjkzyjsxy', 0, '31000000', 585),
 (586, '上海新侨职业技术学院', 'shanghaixinqiaozhiyejishuxueyuan', 'shxqzyjsxy', 0, '31000000', 586),
 (587, '上海东海职业技术学院', 'shanghaidonghaizhiyejishuxueyuan', 'shdhzyjsxy', 0, '31000000', 587),
 (588, '上海邦德职业技术学院', 'shanghaibangdezhiyejishuxueyuan', 'shbdzyjsxy', 0, '31000000', 588),
 (589, '上海城市管理职业技术学院', 'shanghaichengshiguanlizhiyejishuxueyuan', 'shcsglzyjsxy', 0, '31000000', 589),
 (590, '上海科学技术职业学院', 'shanghaikexuejishuzhiyexueyuan', 'shkxjszyxy', 0, '31000000', 590),
 (591, '上海海事职业技术学院', 'shanghaihaishizhiyejishuxueyuan', 'shhszyjsxy', 0, '31000000', 591),
 (592, '上海立达职业技术学院', 'shanghailidazhiyejishuxueyuan', 'shldzyjsxy', 0, '31000000', 592),
 (593, '上海交通职业技术学院', 'shanghaijiaotongzhiyejishuxueyuan', 'shjtzyjsxy', 0, '31000000', 593),
 (594, '上海欧华职业技术学院', 'shanghaiohuazhiyejishuxueyuan', 'shohzyjsxy', 0, '31000000', 594),
 (595, '上海济光职业技术学院', 'shanghaijiguangzhiyejishuxueyuan', 'shjgzyjsxy', 0, '31000000', 595),
 (596, '上海行健职业学院', 'shanghaixingjianzhiyexueyuan', 'shxjzyxy', 0, '31000000', 596),
 (597, '上海电子信息职业技术学院', 'shanghaidianzixinxizhiyejishuxueyuan', 'shdzxxzyjsxy', 0, '31000000', 597),
 (598, '上海兴韦信息技术职业学院', 'shanghaixingweixinxijishuzhiyexueyuan', 'shxwxxjszyxy', 0, '31000000', 598),
 (599, '上海工商外国语职业学院', 'shanghaigongshangwaiguoyuzhiyexueyuan', 'shgswgyzyxy', 0, '31000000', 599),
 (600, '上海思博职业技术学院', 'shanghaisibozhiyejishuxueyuan', 'shsbzyjsxy', 0, '31000000', 600),
 (601, '上海震旦职业学院', 'shanghaizhendanzhiyexueyuan', 'shzdzyxy', 0, '31000000', 601),
 (602, '上海民远职业技术学院', 'shanghaiminyuanzhiyejishuxueyuan', 'shmyzyjsxy', 0, '31000000', 602),
 (603, '上海建峰职业技术学院', 'shanghaijianfengzhiyejishuxueyuan', 'shjfzyjsxy', 0, '31000000', 603),
 (604, '上海中侨职业技术学院', 'shanghaizhongqiaozhiyejishuxueyuan', 'shzqzyjsxy', 0, '31000000', 604),
 (605, '上海中华职业技术学院', 'shanghaizhonghuazhiyejishuxueyuan', 'shzhzyjsxy', 0, '31000000', 605),
 (606, '上海体育职业学院', 'shanghaitiyuzhiyexueyuan', 'shtyzyxy', 0, '31000000', 606),
 (607, '上海工艺美术职业学院', 'shanghaigongyimeishuzhiyexueyuan', 'shgymszyxy', 0, '31000000', 607),
 (608, '上海工会管理职业学院', 'shanghaigonghuiguanlizhiyexueyuan', 'shghglzyxy', 0, '31000000', 608),
 (609, '上海农林职业技术学院', 'shanghainonglinzhiyejishuxueyuan', 'shnlzyjsxy', 0, '31000000', 609),
 (610, '南京大学', 'najingdaxue', 'njdx', 0, '32010000', 610),
 (611, '东南大学', 'dongnadaxue', 'dndx', 0, '32010000', 611),
 (612, '中国矿业大学', 'zhongguokuangyedaxue', 'zgkydx', 0, '32030000', 612),
 (613, '河海大学', 'hehaidaxue', 'hhdx', 0, '32010000', 613),
 (614, '江南大学', 'jiangnadaxue', 'jndx', 0, '32020000', 614),
 (615, '南京农业大学', 'najingnongyedaxue', 'njnydx', 0, '32010000', 615),
 (616, '中国药科大学', 'zhongguoyaokedaxue', 'zgykdx', 0, '32010000', 616),
 (617, '南京理工大学', 'najingligongdaxue', 'njlgdx', 0, '32010000', 617),
 (618, '南京航空航天大学', 'najinghangkonghangtiandaxue', 'njhkhtdx', 0, '32010000', 618),
 (619, '苏州大学', 'suzhoudaxue', 'szdx', 0, '32050000', 619),
 (620, '扬州大学', 'yangzhoudaxue', 'yzdx', 0, '32100000', 620),
 (621, '江苏大学', 'jiangsudaxue', 'jsdx', 0, '32110000', 621),
 (622, '江苏科技大学', 'jiangsukejidaxue', 'jskjdx', 0, '32110000', 622),
 (623, '南京邮电大学', 'najingyoudiandaxue', 'njyddx', 0, '32010000', 623),
 (624, '南京工业大学', 'najinggongyedaxue', 'njgydx', 0, '32010000', 624),
 (625, '常州大学', 'changzhoudaxue', 'czdx', 0, '32040000', 625),
 (626, '南京林业大学', 'najinglinyedaxue', 'njlydx', 0, '32010000', 626),
 (627, '南京医科大学', 'najingyikedaxue', 'njykdx', 0, '32010000', 627),
 (628, '南京中医药大学', 'najingzhongyiyaodaxue', 'njzyydx', 0, '32010000', 628),
 (629, '南京师范大学', 'najingshifandaxue', 'njsfdx', 0, '32010000', 629),
 (630, '徐州师范大学', 'xuzhoushifandaxue', 'xzsfdx', 0, '32030000', 630),
 (631, '南京财经大学', 'najingcaijingdaxue', 'njcjdx', 0, '32010000', 631),
 (632, '南通大学', 'natongdaxue', 'ntdx', 0, '32060000', 632),
 (633, '西交利物浦大学', 'xijiaoliwupudaxue', 'xjlwpdx', 0, '32050000', 633),
 (634, '南京森林警察学院', 'najingsenlinjingchaxueyuan', 'njsljcxy', 0, '32010000', 634),
 (635, '南京信息工程大学', 'najingxinxigongchengdaxue', 'njxxgcdx', 0, '32010000', 635),
 (636, '南京工程学院', 'najinggongchengxueyuan', 'njgcxy', 0, '32010000', 636),
 (637, '常州工学院', 'changzhougongxueyuan', 'czgxy', 0, '32040000', 637),
 (638, '徐州工程学院', 'xuzhougongchengxueyuan', 'xzgcxy', 0, '32030000', 638),
 (639, '金陵科技学院', 'jinlingkejixueyuan', 'jlkjxy', 0, '32010000', 639),
 (640, '淮阴工学院', 'huaiyingongxueyuan', 'hygxy', 0, '32080000', 640),
 (641, '淮海工学院', 'huaihaigongxueyuan', 'hhgxy', 0, '32070000', 641),
 (642, '盐城工学院', 'yanchenggongxueyuan', 'ycgxy', 0, '32090000', 642),
 (643, '徐州医学院', 'xuzhouyixueyuan', 'xzyxy', 0, '32030000', 643),
 (644, '江苏技术师范学院', 'jiangsujishushifanxueyuan', 'jsjssfxy', 0, '32040000', 644),
 (645, '苏州科技学院', 'suzhoukejixueyuan', 'szkjxy', 0, '32050000', 645),
 (646, '淮阴师范学院', 'huaiyinshifanxueyuan', 'hysfxy', 0, '32080400', 646),
 (647, '南京晓庄学院', 'najingxiaozhuangxueyuan', 'njxzxy', 0, '32010000', 647),
 (648, '盐城师范学院', 'yanchengshifanxueyuan', 'ycsfxy', 0, '32090000', 648),
 (649, '南京审计学院', 'najingshenjixueyuan', 'njsjxy', 0, '32010000', 649),
 (650, '江苏警官学院', 'jiangsujingguanxueyuan', 'jsjgxy', 0, '32010000', 650),
 (651, '南京体育学院', 'najingtiyuxueyuan', 'njtyxy', 0, '32010000', 651),
 (652, '南京艺术学院', 'najingyishuxueyuan', 'njysxy', 0, '32010000', 652),
 (653, '常熟理工学院', 'changshuligongxueyuan', 'cslgxy', 0, '32050000', 653),
 (654, '三江学院', 'sanjiangxueyuan', 'sjxy', 0, '32010000', 654),
 (655, '无锡太湖学院', 'wuxitaihuxueyuan', 'wxthxy', 0, '32020000', 655),
 (656, '连云港师范高等专科学校', 'lianyungangshifangaodengzhuankexuexiao', 'lygsfgdzkxx', 0, '32070000', 656),
 (657, '泰州师范高等专科学校', 'taizhoushifangaodengzhuankexuexiao', 'tzsfgdzkxx', 0, '32120000', 657),
 (658, '徐州幼儿师范高等专科学校', 'xuzhouyoueshifangaodengzhuankexuexiao', 'xzyesfgdzkxx', 0, '32030000', 658),
 (659, '镇江市高等专科学校', 'zhenjiangshigaodengzhuankexuexiao', 'zjsgdzkxx', 0, '32110000', 659),
 (660, '江苏畜牧兽医职业技术学院', 'jiangsuxumushouyizhiyejishuxueyuan', 'jsxmsyzyjsxy', 0, '32120000', 660),
 (661, '连云港职业技术学院', 'lianyungangzhiyejishuxueyuan', 'lygzyjsxy', 0, '32070000', 661),
 (662, '江苏城市职业学院', 'jiangsuchengshizhiyexueyuan', 'jscszyxy', 0, '32010000', 662),
 (663, '扬州市职业大学', 'yangzhoushizhiyedaxue', 'yzszydx', 0, '32100000', 663),
 (664, '沙洲职业工学院', 'shazhouzhiyegongxueyuan', 'szzygxy', 0, '32058200', 664),
 (665, '苏州市职业大学', 'suzhoushizhiyedaxue', 'szszydx', 0, '32050000', 665),
 (666, '南通职业大学', 'natongzhiyedaxue', 'ntzydx', 0, '32060000', 666),
 (667, '南通纺织职业技术学院', 'natongfangzhizhiyejishuxueyuan', 'ntfzzyjsxy', 0, '32060000', 667),
 (668, '江苏建筑职业技术学院', 'jiangsujianzhuzhiyejishuxueyuan', 'jsjzzyjsxy', 0, '32030000', 668),
 (669, '泰州职业技术学院', 'taizhouzhiyejishuxueyuan', 'tzzyjsxy', 0, '32120000', 669),
 (670, '无锡商业职业技术学院', 'wuxishangyezhiyejishuxueyuan', 'wxsyzyjsxy', 0, '32020000', 670),
 (671, '南京工业职业技术学院', 'najinggongyezhiyejishuxueyuan', 'njgyzyjsxy', 0, '32010000', 671),
 (672, '苏州工艺美术职业技术学院', 'suzhougongyimeishuzhiyejishuxueyuan', 'szgymszyjsxy', 0, '32050000', 672),
 (673, '南通航运职业技术学院', 'natonghangyunzhiyejishuxueyuan', 'nthyzyjsxy', 0, '32060000', 673),
 (674, '民办明达职业技术学院', 'minbanmingdazhiyejishuxueyuan', 'mbmdzyjsxy', 0, '32090000', 674),
 (675, '无锡职业技术学院', 'wuxizhiyejishuxueyuan', 'wxzyjsxy', 0, '32020000', 675),
 (676, '常州机电职业技术学院', 'changzhoujidianzhiyejishuxueyuan', 'czjdzyjsxy', 0, '32040000', 676),
 (677, '建东职业技术学院', 'jiandongzhiyejishuxueyuan', 'jdzyjsxy', 0, '32040000', 677),
 (678, '徐州工业职业技术学院', 'xuzhougongyezhiyejishuxueyuan', 'xzgyzyjsxy', 0, '32030000', 678),
 (679, '江苏食品职业技术学院', 'jiangsushipinzhiyejishuxueyuan', 'jsspzyjsxy', 0, '32080400', 679),
 (680, '江苏农林职业技术学院', 'jiangsunonglinzhiyejishuxueyuan', 'jsnlzyjsxy', 0, '32110000', 680),
 (681, '常州轻工职业技术学院', 'changzhouqinggongzhiyejishuxueyuan', 'czqgzyjsxy', 0, '32040000', 681),
 (682, '硅湖职业技术学院', 'guihuzhiyejishuxueyuan', 'ghzyjsxy', 0, '32050000', 682),
 (683, '盐城卫生职业技术学院', 'yanchengweishengzhiyejishuxueyuan', 'ycwszyjsxy', 0, '32090000', 683),
 (684, '江苏经贸职业技术学院', 'jiangsujingmaozhiyejishuxueyuan', 'jsjmzyjsxy', 0, '32010000', 684),
 (685, '江苏信息职业技术学院', 'jiangsuxinxizhiyejishuxueyuan', 'jsxxzyjsxy', 0, '32020000', 685),
 (686, '江南影视艺术职业学院', 'jiangnayingshiyishuzhiyexueyuan', 'jnysyszyxy', 0, '32020000', 686),
 (687, '江苏联合职业技术学院', 'jiangsulianhezhiyejishuxueyuan', 'jslhzyjsxy', 0, '32010000', 687),
 (688, '盐城纺织职业技术学院', 'yanchengfangzhizhiyejishuxueyuan', 'ycfzzyjsxy', 0, '32090000', 688),
 (689, '苏州高博软件技术职业学院', 'suzhougaoboruanjianjishuzhiyexueyuan', 'szgbrjjszyxy', 0, '32050000', 689),
 (690, '苏州卫生职业技术学院', 'suzhouweishengzhiyejishuxueyuan', 'szwszyjsxy', 0, '32050000', 690),
 (691, '南京机电职业技术学院', 'najingjidianzhiyejishuxueyuan', 'njjdzyjsxy', 0, '32010000', 691),
 (692, '苏州港大思培科技职业学院', 'suzhougangdasipeikejizhiyexueyuan', 'szgdspkjzyxy', 0, '32050000', 692),
 (693, '昆山登云科技职业学院', 'kunshandengyunkejizhiyexueyuan', 'ksdykjzyxy', 0, '32058300', 693),
 (694, '南京视觉艺术职业学院', 'najingshijueyishuzhiyexueyuan', 'njsjyszyxy', 0, '32010000', 694),
 (695, '南京铁道职业技术学院', 'najingtiedaozhiyejishuxueyuan', 'njtdzyjsxy', 0, '32010000', 695),
 (696, '南京旅游职业学院', 'najingluyouzhiyexueyuan', 'njlyzyxy', 0, '32010000', 696),
 (697, '正德职业技术学院', 'zhengdezhiyejishuxueyuan', 'zdzyjsxy', 0, '32010000', 697),
 (698, '江阴职业技术学院', 'jiangyinzhiyejishuxueyuan', 'jyzyjsxy', 0, '32020000', 698),
 (699, '宿迁职业技术学院', 'suqianzhiyejishuxueyuan', 'sqzyjsxy', 0, '32130000', 699),
 (700, '南京信息职业技术学院', 'najingxinxizhiyejishuxueyuan', 'njxxzyjsxy', 0, '32010000', 700),
 (701, '无锡城市职业技术学院', 'wuxichengshizhiyejishuxueyuan', 'wxcszyjsxy', 0, '32020000', 701),
 (702, '常州工程职业技术学院', 'changzhougongchengzhiyejishuxueyuan', 'czgczyjsxy', 0, '32040000', 702),
 (703, '无锡工艺职业技术学院', 'wuxigongyizhiyejishuxueyuan', 'wxgyzyjsxy', 0, '32020000', 703),
 (704, '健雄职业技术学院', 'jianxiongzhiyejishuxueyuan', 'jxzyjsxy', 0, '32050000', 704),
 (705, '金肯职业技术学院', 'jinkenzhiyejishuxueyuan', 'jkzyjsxy', 0, '32010000', 705),
 (706, '紫琅职业技术学院', 'zilangzhiyejishuxueyuan', 'zlzyjsxy', 0, '32060000', 706),
 (707, '九州职业技术学院', 'jiuzhouzhiyejishuxueyuan', 'jzzyjsxy', 0, '32030000', 707),
 (708, '苏州农业职业技术学院', 'suzhounongyezhiyejishuxueyuan', 'sznyzyjsxy', 0, '32050000', 708),
 (709, '江海职业技术学院', 'jianghaizhiyejishuxueyuan', 'jhzyjsxy', 0, '32100000', 709),
 (710, '南京化工职业技术学院', 'najinghuagongzhiyejishuxueyuan', 'njhgzyjsxy', 0, '32010000', 710),
 (711, '苏州信息职业技术学院', 'suzhouxinxizhiyejishuxueyuan', 'szxxzyjsxy', 0, '32050000', 711),
 (712, '常州纺织服装职业技术学院', 'changzhoufangzhifuzhuangzhiyejishuxueyuan', 'czfzfzzyjsxy', 0, '32040000', 712),
 (713, '常州信息职业技术学院', 'changzhouxinxizhiyejishuxueyuan', 'czxxzyjsxy', 0, '32040000', 713),
 (714, '南京交通职业技术学院', 'najingjiaotongzhiyejishuxueyuan', 'njjtzyjsxy', 0, '32010000', 714),
 (715, '无锡南洋职业技术学院', 'wuxinayangzhiyejishuxueyuan', 'wxnyzyjsxy', 0, '32020000', 715),
 (716, '太湖创意职业技术学院', 'taihuchuangyizhiyejishuxueyuan', 'thcyzyjsxy', 0, '32020000', 716),
 (717, '江苏财经职业技术学院', 'jiangsucaijingzhiyejishuxueyuan', 'jscjzyjsxy', 0, '32080000', 717),
 (718, '苏州工业园区职业技术学院', 'suzhougongyeyuanquzhiyejishuxueyuan', 'szgyyqzyjsxy', 0, '32050000', 718),
 (719, '淮安信息职业技术学院', 'huaianxinxizhiyejishuxueyuan', 'haxxzyjsxy', 0, '32080000', 719),
 (720, '扬州工业职业技术学院', 'yangzhougongyezhiyejishuxueyuan', 'yzgyzyjsxy', 0, '32100000', 720),
 (721, '南京特殊教育职业技术学院', 'najingteshujiaoyuzhiyejishuxueyuan', 'njtsjyzyjsxy', 0, '32010000', 721),
 (722, '金山职业技术学院', 'jinshanzhiyejishuxueyuan', 'jszyjsxy', 0, '32110000', 722),
 (723, '江苏建康职业学院', 'jiangsujiankangzhiyexueyuan', 'jsjkzyxy', 0, '32010000', 723),
 (724, '炎黄职业技术学院', 'yanhuangzhiyejishuxueyuan', 'yhzyjsxy', 0, '32090000', 724),
 (725, '苏州经贸职业技术学院', 'suzhoujingmaozhiyejishuxueyuan', 'szjmzyjsxy', 0, '32050000', 725),
 (726, '应天职业技术学院', 'yingtianzhiyejishuxueyuan', 'ytzyjsxy', 0, '32010000', 726),
 (727, '苏州托普信息职业技术学院', 'suzhoutuopuxinxizhiyejishuxueyuan', 'sztpxxzyjsxy', 0, '32050000', 727),
 (728, '江苏海事职业技术学院', 'jiangsuhaishizhiyejishuxueyuan', 'jshszyjsxy', 0, '32010000', 728),
 (729, '苏州工业职业技术学院', 'suzhougongyezhiyejishuxueyuan', 'szgyzyjsxy', 0, '32050000', 729),
 (730, '扬州环境资源职业技术学院', 'yangzhouhuanjingziyuanzhiyejishuxueyuan', 'yzhjzyzyjsxy', 0, '32100000', 730),
 (731, '南通农业职业技术学院', 'natongnongyezhiyejishuxueyuan', 'ntnyzyjsxy', 0, '32060000', 731),
 (732, '钟山职业技术学院', 'zhongshanzhiyejishuxueyuan', 'zszyjsxy', 0, '32010000', 732),
 (733, '无锡科技职业学院', 'wuxikejizhiyexueyuan', 'wxkjzyxy', 0, '32020000', 733),
 (734, '苏州工业园区服务外包职业学院', 'suzhougongyeyuanqufuwuwaibaozhiyexueyuan', 'szgyyqfwwbzyxy', 0, '32050000', 734),
 (735, '宿迁泽达职业技术学院', 'suqianzedazhiyejishuxueyuan', 'sqzdzyjsxy', 0, '32130000', 735),
 (736, '浙江大学', 'zhejiangdaxue', 'zjdx', 0, '33010000', 736),
 (737, '宁波大学', 'ningbodaxue', 'nbdx', 0, '33020000', 737),
 (738, '浙江工业大学', 'zhejianggongyedaxue', 'zjgydx', 0, '33010000', 738),
 (739, '杭州电子科技大学', 'hangzhoudianzikejidaxue', 'hzdzkjdx', 0, '33010000', 739),
 (740, '浙江理工大学', 'zhejiangligongdaxue', 'zjlgdx', 0, '33010000', 740),
 (741, '浙江农林大学', 'zhejiangnonglindaxue', 'zjnldx', 0, '33010000', 741),
 (742, '浙江中医药大学', 'zhejiangzhongyiyaodaxue', 'zjzyydx', 0, '33010000', 742),
 (743, '浙江师范大学', 'zhejiangshifandaxue', 'zjsfdx', 0, '33070000', 743),
 (744, '杭州师范大学', 'hangzhoushifandaxue', 'hzsfdx', 0, '33010000', 744),
 (745, '浙江工商大学', 'zhejianggongshangdaxue', 'zjgsdx', 0, '33010000', 745),
 (746, '宁波诺丁汉大学', 'ningbonuodinghandaxue', 'nbndhdx', 0, '33020000', 746),
 (747, '温州大学', 'wenzhoudaxue', 'wzdx', 0, '33030000', 747),
 (748, '公安海警学院', 'gonganhaijingxueyuan', 'gahjxy', 0, '33020000', 748),
 (749, '宁波大红鹰学院', 'ningbodahongyingxueyuan', 'nbdhyxy', 0, '33020000', 749),
 (750, '浙江越秀外国语学院', 'zhejiangyuexiuwaiguoyuxueyuan', 'zjyxwgyxy', 0, '33060000', 750),
 (751, '浙江科技学院', 'zhejiangkejixueyuan', 'zjkjxy', 0, '33010000', 751),
 (752, '宁波工程学院', 'ningbogongchengxueyuan', 'nbgcxy', 0, '33020000', 752),
 (753, '中国计量学院', 'zhongguojiliangxueyuan', 'zgjlxy', 0, '33010000', 753),
 (754, '嘉兴学院', 'jiaxingxueyuan', 'jxxy', 0, '33040000', 754),
 (755, '浙江海洋学院', 'zhejianghaiyangxueyuan', 'zjhyxy', 0, '33090000', 755),
 (756, '温州医学院', 'wenzhouyixueyuan', 'wzyxy', 0, '33030000', 756),
 (757, '湖州师范学院', 'huzhoushifanxueyuan', 'hzsfxy', 0, '33050000', 757),
 (758, '台州学院', 'taizhouxueyuan', 'tzxy', 0, '33100000', 758),
 (759, '绍兴文理学院', 'shaoxingwenlixueyuan', 'sxwlxy', 0, '33060000', 759),
 (760, '浙江传媒学院', 'zhejiangchuanmeixueyuan', 'zjcmxy', 0, '33010000', 760),
 (761, '浙江外国语学院', 'zhejiangwaiguoyuxueyuan', 'zjwgyxy', 0, '33010000', 761),
 (762, '浙江财经学院', 'zhejiangcaijingxueyuan', 'zjcjxy', 0, '33010000', 762),
 (763, '浙江警察学院', 'zhejiangjingchaxueyuan', 'zjjcxy', 0, '33010000', 763),
 (764, '中国美术学院', 'zhongguomeishuxueyuan', 'zgmsxy', 0, '33010000', 764),
 (765, '浙江树人学院', 'zhejiangshurenxueyuan', 'zjsrxy', 0, '33010000', 765),
 (766, '浙江万里学院', 'zhejiangwanlixueyuan', 'zjwlxy', 0, '33020000', 766),
 (767, '丽水学院', 'lishuixueyuan', 'lsxy', 0, '33110000', 767),
 (768, '衢州学院', 'quzhouxueyuan', 'qzxy', 0, '33080000', 768),
 (769, '浙江水利水电专科学校', 'zhejiangshuilishuidianzhuankexuexiao', 'zjslsdzkxx', 0, '33010000', 769),
 (770, '浙江医药高等专科学校', 'zhejiangyiyaogaodengzhuankexuexiao', 'zjyygdzkxx', 0, '33020000', 770),
 (771, '浙江医学高等专科学校', 'zhejiangyixuegaodengzhuankexuexiao', 'zjyxgdzkxx', 0, '33010000', 771),
 (772, '温州职业技术学院', 'wenzhouzhiyejishuxueyuan', 'wzzyjsxy', 0, '33030000', 772),
 (773, '金华职业技术学院', 'jinhuazhiyejishuxueyuan', 'jhzyjsxy', 0, '33070000', 773),
 (774, '浙江交通职业技术学院', 'zhejiangjiaotongzhiyejishuxueyuan', 'zjjtzyjsxy', 0, '33010000', 774),
 (775, '宁波职业技术学院', 'ningbozhiyejishuxueyuan', 'nbzyjsxy', 0, '33020000', 775),
 (776, '义乌工商职业技术学院', 'yiwugongshangzhiyejishuxueyuan', 'ywgszyjsxy', 0, '33078200', 776),
 (777, '浙江经贸职业技术学院', 'zhejiangjingmaozhiyejishuxueyuan', 'zjjmzyjsxy', 0, '33010000', 777),
 (778, '浙江经济职业技术学院', 'zhejiangjingjizhiyejishuxueyuan', 'zjjjzyjsxy', 0, '33010000', 778),
 (779, '温州科技职业学院', 'wenzhoukejizhiyexueyuan', 'wzkjzyxy', 0, '33030000', 779),
 (780, '浙江旅游职业学院', 'zhejiangluyouzhiyexueyuan', 'zjlyzyxy', 0, '33010000', 780),
 (781, '浙江工业职业技术学院', 'zhejianggongyezhiyejishuxueyuan', 'zjgyzyjsxy', 0, '33060000', 781),
 (782, '浙江警官职业学院', 'zhejiangjingguanzhiyexueyuan', 'zjjgzyxy', 0, '33010000', 782),
 (783, '浙江商业职业技术学院', 'zhejiangshangyezhiyejishuxueyuan', 'zjsyzyjsxy', 0, '33010000', 783),
 (784, '浙江机电职业技术学院', 'zhejiangjidianzhiyejishuxueyuan', 'zjjdzyjsxy', 0, '33010000', 784),
 (785, '浙江艺术职业学院', 'zhejiangyishuzhiyexueyuan', 'zjyszyxy', 0, '33010000', 785),
 (786, '浙江工商职业技术学院', 'zhejianggongshangzhiyejishuxueyuan', 'zjgszyjsxy', 0, '33020000', 786),
 (787, '浙江育英职业技术学院', 'zhejiangyuyingzhiyejishuxueyuan', 'zjyyzyjsxy', 0, '33010000', 787),
 (788, '浙江工贸职业技术学院', 'zhejianggongmaozhiyejishuxueyuan', 'zjgmzyjsxy', 0, '33030000', 788),
 (789, '浙江建设职业技术学院', 'zhejiangjianshezhiyejishuxueyuan', 'zjjszyjsxy', 0, '33010000', 789),
 (790, '浙江东方职业技术学院', 'zhejiangdongfangzhiyejishuxueyuan', 'zjdfzyjsxy', 0, '33030000', 790),
 (791, '浙江长征职业技术学院', 'zhejiangchangzhengzhiyejishuxueyuan', 'zjczzyjsxy', 0, '33010000', 791),
 (792, '宁波天一职业技术学院', 'ningbotianyizhiyejishuxueyuan', 'nbtyzyjsxy', 0, '33020000', 792),
 (793, '台州科技职业学院', 'taizhoukejizhiyexueyuan', 'tzkjzyxy', 0, '33100000', 793),
 (794, '杭州科技职业技术学院', 'hangzhoukejizhiyejishuxueyuan', 'hzkjzyjsxy', 0, '33010000', 794),
 (795, '宁波城市职业技术学院', 'ningbochengshizhiyejishuxueyuan', 'nbcszyjsxy', 0, '33020000', 795),
 (796, '浙江邮电职业技术学院', 'zhejiangyoudianzhiyejishuxueyuan', 'zjydzyjsxy', 0, '33060000', 796),
 (797, '浙江农业商贸职业学院', 'zhejiangnongyeshangmaozhiyexueyuan', 'zjnysmzyxy', 0, '33060000', 797),
 (798, '浙江国际海运职业技术学院', 'zhejiangguojihaiyunzhiyejishuxueyuan', 'zjgjhyzyjsxy', 0, '33090000', 798),
 (799, '嘉兴南洋职业技术学院', 'jiaxingnayangzhiyejishuxueyuan', 'jxnyzyjsxy', 0, '33040000', 799),
 (800, '台州职业技术学院', 'taizhouzhiyejishuxueyuan', 'tzzyjsxy', 0, '33100000', 800),
 (801, '丽水职业技术学院', 'lishuizhiyejishuxueyuan', 'lszyjsxy', 0, '33110000', 801),
 (802, '浙江横店影视职业学院', 'zhejianghengdianyingshizhiyexueyuan', 'zjhdyszyxy', 0, '33070000', 802),
 (803, '浙江体育职业技术学院', 'zhejiangtiyuzhiyejishuxueyuan', 'zjtyzyjsxy', 0, '33010000', 803),
 (804, '浙江金融职业学院', 'zhejiangjinrongzhiyexueyuan', 'zjjrzyxy', 0, '33010000', 804),
 (805, '浙江汽车职业技术学院', 'zhejiangqichezhiyejishuxueyuan', 'zjqczyjsxy', 0, '33100000', 805),
 (806, '浙江电力职业技术学院', 'zhejiangdianlizhiyejishuxueyuan', 'zjdlzyjsxy', 0, '33010000', 806),
 (807, '绍兴职业技术学院', 'shaoxingzhiyejishuxueyuan', 'sxzyjsxy', 0, '33060000', 807),
 (808, '杭州万向职业技术学院', 'hangzhouwanxiangzhiyejishuxueyuan', 'hzwxzyjsxy', 0, '33010000', 808),
 (809, '衢州职业技术学院', 'quzhouzhiyejishuxueyuan', 'qzzyjsxy', 0, '33080000', 809),
 (810, '湖州职业技术学院', 'huzhouzhiyejishuxueyuan', 'hzzyjsxy', 0, '33050000', 810),
 (811, '嘉兴职业技术学院', 'jiaxingzhiyejishuxueyuan', 'jxzyjsxy', 0, '33040000', 811),
 (812, '浙江同济科技职业学院', 'zhejiangtongjikejizhiyexueyuan', 'zjtjkjzyxy', 0, '33010000', 812),
 (813, '浙江纺织服装职业技术学院', 'zhejiangfangzhifuzhuangzhiyejishuxueyuan', 'zjfzfzzyjsxy', 0, '33020000', 813),
 (814, '杭州职业技术学院', 'hangzhouzhiyejishuxueyuan', 'hzzyjsxy', 0, '33010000', 814),
 (815, '浙江广厦建设职业技术学院', 'zhejiangguangxiajianshezhiyejishuxueyuan', 'zjgxjszyjsxy', 0, '33070000', 815),
 (816, '合肥工业大学', 'hefeigongyedaxue', 'hfgydx', 0, '34010000', 816),
 (817, '中国科学技术大学', 'zhongguokexuejishudaxue', 'zgkxjsdx', 0, '34010000', 817),
 (818, '安徽大学', 'anhuidaxue', 'ahdx', 0, '34010000', 818),
 (819, '安徽理工大学', 'anhuiligongdaxue', 'ahlgdx', 0, '34040000', 819),
 (820, '安徽工业大学', 'anhuigongyedaxue', 'ahgydx', 0, '34050000', 820),
 (821, '安徽工程大学', 'anhuigongchengdaxue', 'ahgcdx', 0, '34020000', 821),
 (822, '安徽农业大学', 'anhuinongyedaxue', 'ahnydx', 0, '34010000', 822),
 (823, '安徽医科大学', 'anhuiyikedaxue', 'ahykdx', 0, '34010000', 823),
 (824, '安徽师范大学', 'anhuishifandaxue', 'ahsfdx', 0, '34020000', 824),
 (825, '淮北师范大学', 'huaibeishifandaxue', 'hbsfdx', 0, '34060000', 825),
 (826, '安徽财经大学', 'anhuicaijingdaxue', 'ahcjdx', 0, '34030000', 826),
 (827, '安徽三联学院', 'anhuisanlianxueyuan', 'ahslxy', 0, '34010000', 827),
 (828, '安徽建筑工业学院', 'anhuijianzhugongyexueyuan', 'ahjzgyxy', 0, '34010000', 828),
 (829, '安徽文达信息工程学院', 'anhuiwendaxinxigongchengxueyuan', 'ahwdxxgcxy', 0, '34010000', 829),
 (830, '安徽中医学院', 'anhuizhongyixueyuan', 'ahzyxy', 0, '34010000', 830),
 (831, '皖南医学院', 'wannayixueyuan', 'wnyxy', 0, '34020000', 831),
 (832, '蚌埠医学院', 'bangbuyixueyuan', 'bbyxy', 0, '34030000', 832),
 (833, '淮南师范学院', 'huainashifanxueyuan', 'hnsfxy', 0, '34040000', 833),
 (834, '阜阳师范学院', 'fuyangshifanxueyuan', 'fysfxy', 0, '34120000', 834),
 (835, '安庆师范学院', 'anqingshifanxueyuan', 'aqsfxy', 0, '34080000', 835),
 (836, '安徽科技学院', 'anhuikejixueyuan', 'ahkjxy', 0, '34110000', 836),
 (837, '合肥师范学院', 'hefeishifanxueyuan', 'hfsfxy', 0, '34010000', 837),
 (838, '安徽外国语学院', 'anhuiwaiguoyuxueyuan', 'ahwgyxy', 0, '34010000', 838),
 (839, '池州学院', 'chizhouxueyuan', 'czxy', 0, '34170000', 839),
 (840, '合肥学院', 'hefeixueyuan', 'hfxy', 0, '34010000', 840),
 (841, '黄山学院', 'huangshanxueyuan', 'hsxy', 0, '34100000', 841),
 (842, '蚌埠学院', 'bangbuxueyuan', 'bbxy', 0, '34030000', 842),
 (843, '宿州学院', 'suzhouxueyuan', 'szxy', 0, '34130000', 843),
 (844, '铜陵学院', 'tonglingxueyuan', 'tlxy', 0, '34070000', 844),
 (845, '滁州学院', 'chuzhouxueyuan', 'czxy', 0, '34110000', 845),
 (846, '皖西学院', 'wanxixueyuan', 'wxxy', 0, '34150000', 846),
 (847, '巢湖学院', 'chaohuxueyuan', 'chxy', 0, '34140000', 847),
 (848, '安徽新华学院', 'anhuixinhuaxueyuan', 'ahxhxy', 0, '34010000', 848),
 (849, '马鞍山师范高等专科学校', 'maanshanshifangaodengzhuankexuexiao', 'massfgdzkxx', 0, '34050000', 849),
 (850, '安徽中医药高等专科学校', 'anhuizhongyiyaogaodengzhuankexuexiao', 'ahzyygdzkxx', 0, '34020000', 850),
 (851, '安徽医学高等专科学校', 'anhuiyixuegaodengzhuankexuexiao', 'ahyxgdzkxx', 0, '34010000', 851),
 (852, '安庆医药高等专科学校', 'anqingyiyaogaodengzhuankexuexiao', 'aqyygdzkxx', 0, '34080000', 852),
 (853, '亳州师范高等专科学校', 'bozhoushifangaodengzhuankexuexiao', 'bzsfgdzkxx', 0, '34160000', 853),
 (854, '桐城师范高等专科学校', 'tongchengshifangaodengzhuankexuexiao', 'tcsfgdzkxx', 0, '34088100', 854),
 (855, '合肥幼儿师范高等专科学校', 'hefeiyoueshifangaodengzhuankexuexiao', 'hfyesfgdzkxx', 0, '34010000', 855),
 (856, '安徽汽车职业技术学院', 'anhuiqichezhiyejishuxueyuan', 'ahqczyjsxy', 0, '34010000', 856),
 (857, '皖西卫生职业学院', 'wanxiweishengzhiyexueyuan', 'wxwszyxy', 0, '34150000', 857),
 (858, '安徽职业技术学院', 'anhuizhiyejishuxueyuan', 'ahzyjsxy', 0, '34010000', 858),
 (859, '民办万博科技职业学院', 'minbanwanbokejizhiyexueyuan', 'mbwbkjzyxy', 0, '34010000', 859),
 (860, '安徽商贸职业技术学院', 'anhuishangmaozhiyejishuxueyuan', 'ahsmzyjsxy', 0, '34020000', 860),
 (861, '淮南联合大学', 'huainalianhedaxue', 'hnlhdx', 0, '34040000', 861),
 (862, '安徽水利水电职业技术学院', 'anhuishuilishuidianzhiyejishuxueyuan', 'ahslsdzyjsxy', 0, '34010000', 862),
 (863, '芜湖职业技术学院', 'wuhuzhiyejishuxueyuan', 'whzyjsxy', 0, '34020000', 863),
 (864, '淮北职业技术学院', 'huaibeizhiyejishuxueyuan', 'hbzyjsxy', 0, '34060000', 864),
 (865, '铜陵职业技术学院', 'tonglingzhiyejishuxueyuan', 'tlzyjsxy', 0, '34070000', 865),
 (866, '安徽警官职业学院', 'anhuijingguanzhiyexueyuan', 'ahjgzyxy', 0, '34010000', 866),
 (867, '淮南职业技术学院', 'huainazhiyejishuxueyuan', 'hnzyjsxy', 0, '34040000', 867),
 (868, '安徽绿海商务职业学院', 'anhuiluhaishangwuzhiyexueyuan', 'ahlhswzyxy', 0, '34010000', 868),
 (869, '合肥通用职业技术学院', 'hefeitongyongzhiyejishuxueyuan', 'hftyzyjsxy', 0, '34010000', 869),
 (870, '安徽工商职业学院', 'anhuigongshangzhiyexueyuan', 'ahgszyxy', 0, '34010000', 870),
 (871, '安徽冶金科技职业学院', 'anhuiyejinkejizhiyexueyuan', 'ahyjkjzyxy', 0, '34050000', 871),
 (872, '安庆职业技术学院', 'anqingzhiyejishuxueyuan', 'aqzyjsxy', 0, '34080000', 872),
 (873, '合肥信息技术职业学院', 'hefeixinxijishuzhiyexueyuan', 'hfxxjszyxy', 0, '34010000', 873),
 (874, '安徽矿业职业技术学院', 'anhuikuangyezhiyejishuxueyuan', 'ahkyzyjsxy', 0, '34060000', 874),
 (875, '安徽审计职业学院', 'anhuishenjizhiyexueyuan', 'ahsjzyxy', 0, '34010000', 875),
 (876, '安徽公安职业学院', 'anhuigonganzhiyexueyuan', 'ahgazyxy', 0, '34010000', 876),
 (877, '阜阳科技职业学院', 'fuyangkejizhiyexueyuan', 'fykjzyxy', 0, '34120000', 877),
 (878, '安徽电气工程职业技术学院', 'anhuidianqigongchengzhiyejishuxueyuan', 'ahdqgczyjsxy', 0, '34010000', 878),
 (879, '安徽艺术职业学院', 'anhuiyishuzhiyexueyuan', 'ahyszyxy', 0, '34010000', 879),
 (880, '蚌埠经济技术职业学院', 'bangbujingjijishuzhiyexueyuan', 'bbjjjszyxy', 0, '34030000', 880),
 (881, '安徽城市管理职业学院', 'anhuichengshiguanlizhiyexueyuan', 'ahcsglzyxy', 0, '34010000', 881),
 (882, '安徽涉外经济职业学院', 'anhuishewaijingjizhiyexueyuan', 'ahswjjzyxy', 0, '34010000', 882),
 (883, '宿州职业技术学院', 'suzhouzhiyejishuxueyuan', 'szzyjsxy', 0, '34130000', 883),
 (884, '合肥共达职业技术学院', 'hefeigongdazhiyejishuxueyuan', 'hfgdzyjsxy', 0, '34010000', 884),
 (885, '安徽长江职业学院', 'anhuichangjiangzhiyexueyuan', 'ahcjzyxy', 0, '34140000', 885),
 (886, '芜湖信息技术职业学院', 'wuhuxinxijishuzhiyexueyuan', 'whxxjszyxy', 0, '34020000', 886),
 (887, '民办合肥财经职业学院', 'minbanhefeicaijingzhiyexueyuan', 'mbhfcjzyxy', 0, '34010000', 887),
 (888, '安徽机电职业技术学院', 'anhuijidianzhiyejishuxueyuan', 'ahjdzyjsxy', 0, '34020000', 888),
 (889, '巢湖职业技术学院', 'chaohuzhiyejishuxueyuan', 'chzyjsxy', 0, '34140000', 889),
 (890, '安徽现代信息工程职业学院', 'anhuixiandaixinxigongchengzhiyexueyuan', 'ahxdxxgczyxy', 0, '34150000', 890),
 (891, '安徽国防科技职业学院', 'anhuiguofangkejizhiyexueyuan', 'ahgfkjzyxy', 0, '34150000', 891),
 (892, '安徽中澳科技职业学院', 'anhuizhongaokejizhiyexueyuan', 'ahzakjzyxy', 0, '34010000', 892),
 (893, '宣城职业技术学院', 'xuanchengzhiyejishuxueyuan', 'xczyjsxy', 0, '34180000', 893),
 (894, '安徽扬子职业技术学院', 'anhuiyangzizhiyejishuxueyuan', 'ahyzzyjsxy', 0, '34020000', 894),
 (895, '滁州职业技术学院', 'chuzhouzhiyejishuxueyuan', 'czzyjsxy', 0, '34110000', 895),
 (896, '民办合肥滨湖职业技术学院', 'minbanhefeibinhuzhiyejishuxueyuan', 'mbhfbhzyjsxy', 0, '34010000', 896),
 (897, '池州职业技术学院', 'chizhouzhiyejishuxueyuan', 'czzyjsxy', 0, '34170000', 897),
 (898, '亳州职业技术学院', 'bozhouzhiyejishuxueyuan', 'bzzyjsxy', 0, '34160000', 898),
 (899, '民办合肥经济技术职业学院', 'minbanhefeijingjijishuzhiyexueyuan', 'mbhfjjjszyxy', 0, '34010000', 899),
 (900, '安徽林业职业技术学院', 'anhuilinyezhiyejishuxueyuan', 'ahlyzyjsxy', 0, '34010000', 900),
 (901, '安徽财贸职业学院', 'anhuicaimaozhiyexueyuan', 'ahcmzyxy', 0, '34010000', 901),
 (902, '马鞍山职业技术学院', 'maanshanzhiyejishuxueyuan', 'maszyjsxy', 0, '34050000', 902),
 (903, '安徽新闻出版职业技术学院', 'anhuixinwenchubanzhiyejishuxueyuan', 'ahxwcbzyjsxy', 0, '34010000', 903),
 (904, '安徽广播影视职业技术学院', 'anhuiguangboyingshizhiyejishuxueyuan', 'ahgbyszyjsxy', 0, '34010000', 904),
 (905, '徽商职业学院', 'huishangzhiyexueyuan', 'hszyxy', 0, '34010000', 905),
 (906, '安徽电子信息职业技术学院', 'anhuidianzixinxizhiyejishuxueyuan', 'ahdzxxzyjsxy', 0, '34030000', 906),
 (907, '安徽工业职业技术学院', 'anhuigongyezhiyejishuxueyuan', 'ahgyzyjsxy', 0, '34070000', 907),
 (908, '六安职业技术学院', 'liuanzhiyejishuxueyuan', 'lazyjsxy', 0, '34150000', 908),
 (909, '安徽体育运动职业技术学院', 'anhuitiyuyundongzhiyejishuxueyuan', 'ahtyydzyjsxy', 0, '34010000', 909),
 (910, '安徽国际商务职业学院', 'anhuiguojishangwuzhiyexueyuan', 'ahgjswzyxy', 0, '34010000', 910),
 (911, '安徽黄梅戏艺术职业学院', 'anhuihuangmeixiyishuzhiyexueyuan', 'ahhmxyszyxy', 0, '34080000', 911),
 (912, '民办安徽旅游职业学院', 'minbananhuiluyouzhiyexueyuan', 'mbahlyzyxy', 0, '34120000', 912),
 (913, '安徽交通职业技术学院', 'anhuijiaotongzhiyejishuxueyuan', 'ahjtzyjsxy', 0, '34010000', 913),
 (914, '安徽工业经济职业技术学院', 'anhuigongyejingjizhiyejishuxueyuan', 'ahgyjjzyjsxy', 0, '34010000', 914),
 (915, '安徽工贸职业技术学院', 'anhuigongmaozhiyejishuxueyuan', 'ahgmzyjsxy', 0, '34040000', 915),
 (916, '阜阳职业技术学院', 'fuyangzhiyejishuxueyuan', 'fyzyjsxy', 0, '34120000', 916),
 (917, '安徽邮电职业技术学院', 'anhuiyoudianzhiyejishuxueyuan', 'ahydzyjsxy', 0, '34010000', 917),
 (918, '滁州城市职业学院', 'chuzhouchengshizhiyexueyuan', 'czcszyxy', 0, '34110000', 918),
 (919, '黄山职业技术学院', 'huangshanzhiyejishuxueyuan', 'hszyjsxy', 0, '34100000', 919),
 (920, '厦门大学', 'xiamendaxue', 'xmdx', 0, '35020000', 920),
 (921, '华侨大学', 'huaqiaodaxue', 'hqdx', 0, '35050000', 921),
 (922, '福建农林大学', 'fujiannonglindaxue', 'fjnldx', 0, '35010000', 922),
 (923, '集美大学', 'jimeidaxue', 'jmdx', 0, '35020000', 923),
 (924, '福州大学', 'fuzhoudaxue', 'fzdx', 0, '35010000', 924),
 (925, '仰恩大学', 'yangedaxue', 'yedx', 0, '35050000', 925),
 (926, '福建医科大学', 'fujianyikedaxue', 'fjykdx', 0, '35010000', 926),
 (927, '福建中医药大学', 'fujianzhongyiyaodaxue', 'fjzyydx', 0, '35010000', 927),
 (928, '福建师范大学', 'fujianshifandaxue', 'fjsfdx', 0, '35010000', 928),
 (929, '厦门理工学院', 'xiamenligongxueyuan', 'xmlgxy', 0, '35020000', 929),
 (930, '闽南理工学院', 'minnaligongxueyuan', 'mnlgxy', 0, '35050000', 930),
 (931, '福建工程学院', 'fujiangongchengxueyuan', 'fjgcxy', 0, '35010000', 931),
 (932, '宁德师范学院', 'ningdeshifanxueyuan', 'ndsfxy', 0, '35090000', 932),
 (933, '泉州师范学院', 'quanzhoushifanxueyuan', 'qzsfxy', 0, '35050000', 933),
 (934, '漳州师范学院', 'zhangzhoushifanxueyuan', 'zzsfxy', 0, '35060000', 934),
 (935, '福州外语外贸学院', 'fuzhouwaiyuwaimaoxueyuan', 'fzwywmxy', 0, '35010000', 935),
 (936, '福建警察学院', 'fujianjingchaxueyuan', 'fjjcxy', 0, '35010000', 936),
 (937, '龙岩学院', 'longyanxueyuan', 'lyxy', 0, '35080000', 937),
 (938, '三明学院', 'sanmingxueyuan', 'smxy', 0, '35040000', 938),
 (939, '闽江学院', 'minjiangxueyuan', 'mjxy', 0, '35010000', 939),
 (940, '武夷学院', 'wuyixueyuan', 'wyxy', 0, '35070000', 940),
 (941, '莆田学院', 'putianxueyuan', 'ptxy', 0, '35030000', 941),
 (942, '福建江夏学院', 'fujianjiangxiaxueyuan', 'fjjxxy', 0, '35010000', 942),
 (943, '泉州医学高等专科学校', 'quanzhouyixuegaodengzhuankexuexiao', 'qzyxgdzkxx', 0, '35050000', 943),
 (944, '厦门医学高等专科学校', 'xiamenyixuegaodengzhuankexuexiao', 'xmyxgdzkxx', 0, '35020000', 944),
 (945, '泉州幼儿师范高等专科学校', 'quanzhouyoueshifangaodengzhuankexuexiao', 'qzyesfgdzkxx', 0, '35050000', 945),
 (946, '福建商业高等专科学校', 'fujianshangyegaodengzhuankexuexiao', 'fjsygdzkxx', 0, '35010000', 946),
 (947, '黎明职业大学', 'limingzhiyedaxue', 'lmzydx', 0, '35050000', 947),
 (948, '福建华南女子职业学院', 'fujianhuananuzizhiyexueyuan', 'fjhnnzzyxy', 0, '35010000', 948),
 (949, '漳州职业技术学院', 'zhangzhouzhiyejishuxueyuan', 'zzzyjsxy', 0, '35060000', 949),
 (950, '厦门华厦职业学院', 'xiamenhuaxiazhiyexueyuan', 'xmhxzyxy', 0, '35020000', 950),
 (951, '福建交通职业技术学院', 'fujianjiaotongzhiyejishuxueyuan', 'fjjtzyjsxy', 0, '35010000', 951),
 (952, '福州英华职业学院', 'fuzhouyinghuazhiyexueyuan', 'fzyhzyxy', 0, '35010000', 952),
 (953, '泉州纺织服装职业学院', 'quanzhoufangzhifuzhuangzhiyexueyuan', 'qzfzfzzyxy', 0, '35050000', 953),
 (954, '厦门华天涉外职业技术学院', 'xiamenhuatianshewaizhiyejishuxueyuan', 'xmhtswzyjsxy', 0, '35020000', 954),
 (955, '厦门南洋职业学院', 'xiamennayangzhiyexueyuan', 'xmnyzyxy', 0, '35020000', 955),
 (956, '漳州城市职业学院', 'zhangzhouchengshizhiyexueyuan', 'zzcszyxy', 0, '35060000', 956),
 (957, '厦门演艺职业学院', 'xiamenyanyizhiyexueyuan', 'xmyyzyxy', 0, '35020000', 957),
 (958, '福建体育职业技术学院', 'fujiantiyuzhiyejishuxueyuan', 'fjtyzyjsxy', 0, '35010000', 958),
 (959, '厦门安防科技职业学院', 'xiamenanfangkejizhiyexueyuan', 'xmafkjzyxy', 0, '35020000', 959),
 (960, '泉州泰山航海职业学院', 'quanzhoutaishanhanghaizhiyexueyuan', 'qztshhzyxy', 0, '35050000', 960),
 (961, '福州科技职业技术学院', 'fuzhoukejizhiyejishuxueyuan', 'fzkjzyjsxy', 0, '35010000', 961),
 (962, '泉州轻工职业学院', 'quanzhouqinggongzhiyexueyuan', 'qzqgzyxy', 0, '35050000', 962),
 (963, '福建警官职业学院', 'fujianjingguanzhiyexueyuan', 'fjjgzyxy', 0, '35010000', 963),
 (964, '泉州经贸职业技术学院', 'quanzhoujingmaozhiyejishuxueyuan', 'qzjmzyjsxy', 0, '35050000', 964),
 (965, '湄洲湾职业技术学院', 'meizhouwanzhiyejishuxueyuan', 'mzwzyjsxy', 0, '35030000', 965),
 (966, '福建对外经济贸易职业技术学院', 'fujianduiwaijingjimaoyizhiyejishuxueyuan', 'fjdwjjmyzyjsxy', 0, '35010000', 966),
 (967, '泉州信息职业技术学院', 'quanzhouxinxizhiyejishuxueyuan', 'qzxxzyjsxy', 0, '35050000', 967),
 (968, '福建生物工程职业技术学院', 'fujianshengwugongchengzhiyejishuxueyuan', 'fjswgczyjsxy', 0, '35010000', 968),
 (969, '三明职业技术学院', 'sanmingzhiyejishuxueyuan', 'smzyjsxy', 0, '35040000', 969),
 (970, '福州软件职业技术学院', 'fuzhouruanjianzhiyejishuxueyuan', 'fzrjzyjsxy', 0, '35010000', 970),
 (971, '厦门兴才职业技术学院', 'xiamenxingcaizhiyejishuxueyuan', 'xmxczyjsxy', 0, '35020000', 971),
 (972, '福建农业职业技术学院', 'fujiannongyezhiyejishuxueyuan', 'fjnyzyjsxy', 0, '35010000', 972),
 (973, '福建林业职业技术学院', 'fujianlinyezhiyejishuxueyuan', 'fjlyzyjsxy', 0, '35070000', 973),
 (974, '福建电力职业技术学院', 'fujiandianlizhiyejishuxueyuan', 'fjdlzyjsxy', 0, '35050000', 974),
 (975, '武夷山职业学院', 'wuyishanzhiyexueyuan', 'wyszyxy', 0, '35070000', 975),
 (976, '福建水利电力职业技术学院', 'fujianshuilidianlizhiyejishuxueyuan', 'fjsldlzyjsxy', 0, '35040000', 976),
 (977, '福建卫生职业技术学院', 'fujianweishengzhiyejishuxueyuan', 'fjwszyjsxy', 0, '35010000', 977),
 (978, '福建信息职业技术学院', 'fujianxinxizhiyejishuxueyuan', 'fjxxzyjsxy', 0, '35010000', 978),
 (979, '漳州卫生职业学院', 'zhangzhouweishengzhiyexueyuan', 'zzwszyxy', 0, '35060000', 979),
 (980, '闽西职业技术学院', 'minxizhiyejishuxueyuan', 'mxzyjsxy', 0, '35080000', 980),
 (981, '福州职业技术学院', 'fuzhouzhiyejishuxueyuan', 'fzzyjsxy', 0, '35010000', 981),
 (982, '闽北职业技术学院', 'minbeizhiyejishuxueyuan', 'mbzyjsxy', 0, '35070000', 982),
 (983, '福州海峡职业技术学院', 'fuzhouhaixiazhiyejishuxueyuan', 'fzhxzyjsxy', 0, '35010000', 983),
 (984, '福州黎明职业技术学院', 'fuzhoulimingzhiyejishuxueyuan', 'fzlmzyjsxy', 0, '35010000', 984),
 (985, '泉州华光摄影艺术职业学院', 'quanzhouhuaguangsheyingyishuzhiyexueyuan', 'qzhgsyyszyxy', 0, '35050000', 985),
 (986, '厦门城市职业学院', 'xiamenchengshizhiyexueyuan', 'xmcszyxy', 0, '35020000', 986),
 (987, '漳州理工职业学院', 'zhangzhouligongzhiyexueyuan', 'zzlgzyxy', 0, '35060000', 987),
 (988, '宁德职业技术学院', 'ningdezhiyejishuxueyuan', 'ndzyjsxy', 0, '35090000', 988),
 (989, '漳州天福茶职业技术学院', 'zhangzhoutianfuchazhiyejishuxueyuan', 'zztfczyjsxy', 0, '35060000', 989),
 (990, '德化陶瓷职业技术学院', 'dehuataocizhiyejishuxueyuan', 'dhtczyjsxy', 0, '35050000', 990),
 (991, '福建艺术职业学院', 'fujianyishuzhiyexueyuan', 'fjyszyxy', 0, '35010000', 991),
 (992, '泉州理工职业学院', 'quanzhouligongzhiyexueyuan', 'qzlgzyxy', 0, '35050000', 992),
 (993, '厦门东海职业技术学院', 'xiamendonghaizhiyejishuxueyuan', 'xmdhzyjsxy', 0, '35020000', 993),
 (994, '厦门软件职业技术学院', 'xiamenruanjianzhiyejishuxueyuan', 'xmrjzyjsxy', 0, '35020000', 994),
 (995, '厦门海洋职业技术学院', 'xiamenhaiyangzhiyejishuxueyuan', 'xmhyzyjsxy', 0, '35020000', 995),
 (996, '南昌大学', 'nachangdaxue', 'ncdx', 0, '36010000', 996),
 (997, '江西理工大学', 'jiangxiligongdaxue', 'jxlgdx', 0, '36070000', 997),
 (998, '东华理工大学', 'donghualigongdaxue', 'dhlgdx', 0, '36100000', 998),
 (999, '华东交通大学', 'huadongjiaotongdaxue', 'hdjtdx', 0, '36010000', 999);
 INSERT `tn_Schools` (`Id`, `Name`, `PinyinName`, `ShortPinyinName`, `SchoolType`, `AreaCode`, `DisplayOrder`)
 VALUES
 (1000, '南昌航空大学', 'nachanghangkongdaxue', 'nchkdx', 0, '36010000', 1000),
 (1001, '江西农业大学', 'jiangxinongyedaxue', 'jxnydx', 0, '36010000', 1001),
 (1002, '江西师范大学', 'jiangxishifandaxue', 'jxsfdx', 0, '36010000', 1002),
 (1003, '江西财经大学', 'jiangxicaijingdaxue', 'jxcjdx', 0, '36010000', 1003),
 (1004, '井冈山大学', 'jinggangshandaxue', 'jgsdx', 0, '36080000', 1004),
 (1005, '景德镇陶瓷学院', 'jingdezhentaocixueyuan', 'jdztcxy', 0, '36020000', 1005),
 (1006, '南昌工程学院', 'nachanggongchengxueyuan', 'ncgcxy', 0, '36010000', 1006),
 (1007, '南昌工学院', 'nachanggongxueyuan', 'ncgxy', 0, '36010000', 1007),
 (1008, '南昌理工学院', 'nachangligongxueyuan', 'nclgxy', 0, '36010000', 1008),
 (1009, '江西中医学院', 'jiangxizhongyixueyuan', 'jxzyxy', 0, '36010000', 1009),
 (1010, '赣南医学院', 'gannayixueyuan', 'gnyxy', 0, '36070000', 1010),
 (1011, '江西科技师范学院', 'jiangxikejishifanxueyuan', 'jxkjsfxy', 0, '36010000', 1011),
 (1012, '上饶师范学院', 'shangraoshifanxueyuan', 'srsfxy', 0, '36110000', 1012),
 (1013, '赣南师范学院', 'gannashifanxueyuan', 'gnsfxy', 0, '36070000', 1013),
 (1014, '江西警察学院', 'jiangxijingchaxueyuan', 'jxjcxy', 0, '36010000', 1014),
 (1015, '江西服装学院', 'jiangxifuzhuangxueyuan', 'jxfzxy', 0, '36010000', 1015),
 (1016, '新余学院', 'xinyuxueyuan', 'xyxy', 0, '36050000', 1016),
 (1017, '江西蓝天学院', 'jiangxilatianxueyuan', 'jxltxy', 0, '36010000', 1017),
 (1018, '九江学院', 'jiujiangxueyuan', 'jjxy', 0, '36040000', 1018),
 (1019, '宜春学院', 'yichunxueyuan', 'ycxy', 0, '36090000', 1019),
 (1020, '江西中医药高等专科学校', 'jiangxizhongyiyaogaodengzhuankexuexiao', 'jxzyygdzkxx', 0, '36100000', 1020),
 (1021, '南昌师范高等专科学校', 'nachangshifangaodengzhuankexuexiao', 'ncsfgdzkxx', 0, '36010000', 1021),
 (1022, '萍乡高等专科学校', 'pingxianggaodengzhuankexuexiao', 'pxgdzkxx', 0, '36030000', 1022),
 (1023, '景德镇高等专科学校', 'jingdezhengaodengzhuankexuexiao', 'jdzgdzkxx', 0, '36020000', 1023),
 (1024, '江西护理职业技术学院', 'jiangxihulizhiyejishuxueyuan', 'jxhlzyjsxy', 0, '36010000', 1024),
 (1025, '九江职业大学', 'jiujiangzhiyedaxue', 'jjzydx', 0, '36040000', 1025),
 (1026, '江西工业职业技术学院', 'jiangxigongyezhiyejishuxueyuan', 'jxgyzyjsxy', 0, '36010000', 1026),
 (1027, '九江职业技术学院', 'jiujiangzhiyejishuxueyuan', 'jjzyjsxy', 0, '36040000', 1027),
 (1028, '江西机电职业技术学院', 'jiangxijidianzhiyejishuxueyuan', 'jxjdzyjsxy', 0, '36010000', 1028),
 (1029, '江西旅游商贸职业学院', 'jiangxiluyoushangmaozhiyexueyuan', 'jxlysmzyxy', 0, '36010000', 1029),
 (1030, '江西电力职业技术学院', 'jiangxidianlizhiyejishuxueyuan', 'jxdlzyjsxy', 0, '36010000', 1030),
 (1031, '江西陶瓷工艺美术职业技术学院', 'jiangxitaocigongyimeishuzhiyejishuxueyuan', 'jxtcgymszyjsxy', 0, '36020000', 1031),
 (1032, '江西财经职业学院', 'jiangxicaijingzhiyexueyuan', 'jxcjzyxy', 0, '36040000', 1032),
 (1033, '江西艺术职业学院', 'jiangxiyishuzhiyexueyuan', 'jxyszyxy', 0, '36010000', 1033),
 (1034, '江西生物科技职业学院', 'jiangxishengwukejizhiyexueyuan', 'jxswkjzyxy', 0, '36010000', 1034),
 (1035, '江西航空职业技术学院', 'jiangxihangkongzhiyejishuxueyuan', 'jxhkzyjsxy', 0, '36010000', 1035),
 (1036, '江西外语外贸职业学院', 'jiangxiwaiyuwaimaozhiyexueyuan', 'jxwywmzyxy', 0, '36010000', 1036),
 (1037, '江西城市职业学院', 'jiangxichengshizhiyexueyuan', 'jxcszyxy', 0, '36010000', 1037),
 (1038, '江西司法警官职业学院', 'jiangxisifajingguanzhiyexueyuan', 'jxsfjgzyxy', 0, '36010000', 1038),
 (1039, '南昌职业学院', 'nachangzhiyexueyuan', 'nczyxy', 0, '36010000', 1039),
 (1040, '抚州职业技术学院', 'fuzhouzhiyejishuxueyuan', 'fzzyjsxy', 0, '36100000', 1040),
 (1041, '江西应用工程职业学院', 'jiangxiyingyonggongchengzhiyexueyuan', 'jxyygczyxy', 0, '36030000', 1041),
 (1042, '宜春职业技术学院', 'yichunzhiyejishuxueyuan', 'yczyjsxy', 0, '36090000', 1042),
 (1043, '江西工业贸易职业技术学院', 'jiangxigongyemaoyizhiyejishuxueyuan', 'jxgymyzyjsxy', 0, '36010000', 1043),
 (1044, '江西建设职业技术学院', 'jiangxijianshezhiyejishuxueyuan', 'jxjszyjsxy', 0, '36010000', 1044),
 (1045, '江西工商职业技术学院', 'jiangxigongshangzhiyejishuxueyuan', 'jxgszyjsxy', 0, '36010000', 1045),
 (1046, '江西应用技术职业学院', 'jiangxiyingyongjishuzhiyexueyuan', 'jxyyjszyxy', 0, '36070000', 1046),
 (1047, '江西泰豪动漫职业学院', 'jiangxitaihaodongmanzhiyexueyuan', 'jxthdmzyxy', 0, '36010000', 1047),
 (1048, '江西经济管理职业学院', 'jiangxijingjiguanlizhiyexueyuan', 'jxjjglzyxy', 0, '36010000', 1048),
 (1049, '江西渝州科技职业学院', 'jiangxiyuzhoukejizhiyexueyuan', 'jxyzkjzyxy', 0, '36050000', 1049),
 (1050, '江西制造职业技术学院', 'jiangxizhizaozhiyejishuxueyuan', 'jxzzzyjsxy', 0, '36010000', 1050),
 (1051, '江西枫林涉外经贸职业学院', 'jiangxifenglinshewaijingmaozhiyexueyuan', 'jxflswjmzyxy', 0, '36040000', 1051),
 (1052, '江西信息应用职业技术学院', 'jiangxixinxiyingyongzhiyejishuxueyuan', 'jxxxyyzyjsxy', 0, '36010000', 1052),
 (1053, '江西工业工程职业技术学院', 'jiangxigongyegongchengzhiyejishuxueyuan', 'jxgygczyjsxy', 0, '36030000', 1053),
 (1054, '上饶职业技术学院', 'shangraozhiyejishuxueyuan', 'srzyjsxy', 0, '36110000', 1054),
 (1055, '江西农业工程职业学院', 'jiangxinongyegongchengzhiyexueyuan', 'jxnygczyxy', 0, '36098200', 1055),
 (1056, '鹰潭职业技术学院', 'yingtanzhiyejishuxueyuan', 'ytzyjsxy', 0, '36060000', 1056),
 (1057, '江西工程职业学院', 'jiangxigongchengzhiyexueyuan', 'jxgczyxy', 0, '36010000', 1057),
 (1058, '江西青年职业学院', 'jiangxiqingnianzhiyexueyuan', 'jxqnzyxy', 0, '36010000', 1058),
 (1059, '江西新闻出版职业技术学院', 'jiangxixinwenchubanzhiyejishuxueyuan', 'jxxwcbzyjsxy', 0, '36010000', 1059),
 (1060, '江西管理职业学院', 'jiangxiguanlizhiyexueyuan', 'jxglzyxy', 0, '36010000', 1060),
 (1061, '江西科技职业学院', 'jiangxikejizhiyexueyuan', 'jxkjzyxy', 0, '36010000', 1061),
 (1062, '江西交通职业技术学院', 'jiangxijiaotongzhiyejishuxueyuan', 'jxjtzyjsxy', 0, '36010000', 1062),
 (1063, '赣西科技职业学院', 'ganxikejizhiyexueyuan', 'gxkjzyxy', 0, '36050000', 1063),
 (1064, '江西现代职业技术学院', 'jiangxixiandaizhiyejishuxueyuan', 'jxxdzyjsxy', 0, '36010000', 1064),
 (1065, '江西先锋软件职业技术学院', 'jiangxixianfengruanjianzhiyejishuxueyuan', 'jxxfrjzyjsxy', 0, '36010000', 1065),
 (1066, '江西环境工程职业学院', 'jiangxihuanjinggongchengzhiyexueyuan', 'jxhjgczyxy', 0, '36070000', 1066),
 (1067, '江西太阳能科技职业学院', 'jiangxitaiyangnengkejizhiyexueyuan', 'jxtynkjzyxy', 0, '36050000', 1067),
 (1068, '江西冶金职业技术学院', 'jiangxiyejinzhiyejishuxueyuan', 'jxyjzyjsxy', 0, '36050000', 1068),
 (1069, '山东大学', 'shandongdaxue', 'sddx', 0, '37010000', 1069),
 (1070, '中国海洋大学', 'zhongguohaiyangdaxue', 'zghydx', 0, '37020000', 1070),
 (1071, '青岛大学', 'qingdaodaxue', 'qddx', 0, '37020000', 1071),
 (1072, '山东科技大学', 'shandongkejidaxue', 'sdkjdx', 0, '37020000', 1072),
 (1073, '山东理工大学', 'shandongligongdaxue', 'sdlgdx', 0, '37030000', 1073),
 (1074, '烟台大学', 'yantaidaxue', 'ytdx', 0, '37060000', 1074),
 (1075, '聊城大学', 'liaochengdaxue', 'lcdx', 0, '37150000', 1075),
 (1076, '青岛科技大学', 'qingdaokejidaxue', 'qdkjdx', 0, '37020000', 1076),
 (1077, '青岛理工大学', 'qingdaoligongdaxue', 'qdlgdx', 0, '37020000', 1077),
 (1078, '济南大学', 'jinadaxue', 'jndx', 0, '37010000', 1078),
 (1079, '山东建筑大学', 'shandongjianzhudaxue', 'sdjzdx', 0, '37010000', 1079),
 (1080, '山东农业大学', 'shandongnongyedaxue', 'sdnydx', 0, '37090000', 1080),
 (1081, '青岛农业大学', 'qingdaonongyedaxue', 'qdnydx', 0, '37020000', 1081),
 (1082, '山东中医药大学', 'shandongzhongyiyaodaxue', 'sdzyydx', 0, '37010000', 1082),
 (1083, '山东师范大学', 'shandongshifandaxue', 'sdsfdx', 0, '37010000', 1083),
 (1084, '曲阜师范大学', 'qufushifandaxue', 'qfsfdx', 0, '37080000', 1084),
 (1085, '鲁东大学', 'ludongdaxue', 'lddx', 0, '37060000', 1085),
 (1086, '山东万杰医学院', 'shandongwanjieyixueyuan', 'sdwjyxy', 0, '37030000', 1086),
 (1087, '山东英才学院', 'shandongyingcaixueyuan', 'sdycxy', 0, '37010000', 1087),
 (1088, '潍坊科技学院', 'weifangkejixueyuan', 'wfkjxy', 0, '37070000', 1088),
 (1089, '山东轻工业学院', 'shandongqinggongyexueyuan', 'sdqgyxy', 0, '37010000', 1089),
 (1090, '山东交通学院', 'shandongjiaotongxueyuan', 'sdjtxy', 0, '37010000', 1090),
 (1091, '潍坊学院', 'weifangxueyuan', 'wfxy', 0, '37070000', 1091),
 (1092, '青岛工学院', 'qingdaogongxueyuan', 'qdgxy', 0, '37020000', 1092),
 (1093, '潍坊医学院', 'weifangyixueyuan', 'wfyxy', 0, '37070000', 1093),
 (1094, '泰山医学院', 'taishanyixueyuan', 'tsyxy', 0, '37090000', 1094),
 (1095, '济宁医学院', 'jiningyixueyuan', 'jnyxy', 0, '37080000', 1095),
 (1096, '滨州医学院', 'binzhouyixueyuan', 'bzyxy', 0, '37160000', 1096),
 (1097, '德州学院', 'dezhouxueyuan', 'dzxy', 0, '37140000', 1097),
 (1098, '临沂大学', 'linyidaxue', 'lydx', 0, '37130000', 1098),
 (1099, '齐鲁师范学院', 'qilushifanxueyuan', 'qlsfxy', 0, '37010000', 1099),
 (1100, '山东经济学院', 'shandongjingjixueyuan', 'sdjjxy', 0, '37010000', 1100),
 (1101, '山东财政学院', 'shandongcaizhengxueyuan', 'sdczxy', 0, '37010000', 1101),
 (1102, '山东工商学院', 'shandonggongshangxueyuan', 'sdgsxy', 0, '37060000', 1102),
 (1103, '山东警察学院', 'shandongjingchaxueyuan', 'sdjcxy', 0, '37010000', 1103),
 (1104, '山东青年政治学院', 'shandongqingnianzhengzhixueyuan', 'sdqnzzxy', 0, '37010000', 1104),
 (1105, '山东政法学院', 'shandongzhengfaxueyuan', 'sdzfxy', 0, '37010000', 1105),
 (1106, '山东体育学院', 'shandongtiyuxueyuan', 'sdtyxy', 0, '37010000', 1106),
 (1107, '山东艺术学院', 'shandongyishuxueyuan', 'sdysxy', 0, '37010000', 1107),
 (1108, '山东工艺美术学院', 'shandonggongyimeishuxueyuan', 'sdgymsxy', 0, '37010000', 1108),
 (1109, '泰山学院', 'taishanxueyuan', 'tsxy', 0, '37090000', 1109),
 (1110, '济宁学院', 'jiningxueyuan', 'jnxy', 0, '37080000', 1110),
 (1111, '滨州学院', 'binzhouxueyuan', 'bzxy', 0, '37160000', 1111),
 (1112, '烟台南山学院', 'yantainashanxueyuan', 'ytnsxy', 0, '37060000', 1112),
 (1113, '青岛滨海学院', 'qingdaobinhaixueyuan', 'qdbhxy', 0, '37020000', 1113),
 (1114, '枣庄学院', 'zaozhuangxueyuan', 'zzxy', 0, '37040000', 1114),
 (1115, '菏泽学院', 'hezexueyuan', 'hzxy', 0, '37170000', 1115),
 (1116, '青岛黄海学院', 'qingdaohuanghaixueyuan', 'qdhhxy', 0, '37020000', 1116),
 (1117, '山东女子学院', 'shandongnuzixueyuan', 'sdnzxy', 0, '37010000', 1117),
 (1118, '山东协和学院', 'shandongxiehexueyuan', 'sdxhxy', 0, '37010000', 1118),
 (1119, '山东中医药高等专科学校', 'shandongzhongyiyaogaodengzhuankexuexiao', 'sdzyygdzkxx', 0, '37060000', 1119),
 (1120, '淄博师范高等专科学校', 'ziboshifangaodengzhuankexuexiao', 'zbsfgdzkxx', 0, '37030000', 1120),
 (1121, '山东电力高等专科学校', 'shandongdianligaodengzhuankexuexiao', 'sddlgdzkxx', 0, '37010000', 1121),
 (1122, '山东医学高等专科学校', 'shandongyixuegaodengzhuankexuexiao', 'sdyxgdzkxx', 0, '37130000', 1122),
 (1123, '菏泽医学专科学校', 'hezeyixuezhuankexuexiao', 'hzyxzkxx', 0, '37170000', 1123),
 (1124, '济南幼儿师范高等专科学校', 'jinayoueshifangaodengzhuankexuexiao', 'jnyesfgdzkxx', 0, '37010000', 1124),
 (1125, '山东畜牧兽医职业学院', 'shandongxumushouyizhiyexueyuan', 'sdxmsyzyxy', 0, '37070000', 1125),
 (1126, '济宁职业技术学院', 'jiningzhiyejishuxueyuan', 'jnzyjsxy', 0, '37080000', 1126),
 (1127, '山东劳动职业技术学院', 'shandonglaodongzhiyejishuxueyuan', 'sdldzyjsxy', 0, '37010000', 1127),
 (1128, '青岛职业技术学院', 'qingdaozhiyejishuxueyuan', 'qdzyjsxy', 0, '37020000', 1128),
 (1129, '莱芜职业技术学院', 'laiwuzhiyejishuxueyuan', 'lwzyjsxy', 0, '37120000', 1129),
 (1130, '山东商业职业技术学院', 'shandongshangyezhiyejishuxueyuan', 'sdsyzyjsxy', 0, '37010000', 1130),
 (1131, '曲阜远东职业技术学院', 'qufuyuandongzhiyejishuxueyuan', 'qfydzyjsxy', 0, '37080000', 1131),
 (1132, '威海职业学院', 'weihaizhiyexueyuan', 'whzyxy', 0, '37100000', 1132),
 (1133, '日照职业技术学院', 'rizhaozhiyejishuxueyuan', 'rzzyjsxy', 0, '37110000', 1133),
 (1134, '聊城职业技术学院', 'liaochengzhiyejishuxueyuan', 'lczyjsxy', 0, '37150000', 1134),
 (1135, '潍坊工程职业学院', 'weifanggongchengzhiyexueyuan', 'wfgczyxy', 0, '37078100', 1135),
 (1136, '泰山护理职业学院', 'taishanhulizhiyexueyuan', 'tshlzyxy', 0, '37090000', 1136),
 (1137, '枣庄职业学院', 'zaozhuangzhiyexueyuan', 'zzzyxy', 0, '37040000', 1137),
 (1138, '济南护理职业学院', 'jinahulizhiyexueyuan', 'jnhlzyxy', 0, '37010000', 1138),
 (1139, '济南职业学院', 'jinazhiyexueyuan', 'jnzyxy', 0, '37010000', 1139),
 (1140, '潍坊护理职业学院', 'weifanghulizhiyexueyuan', 'wfhlzyxy', 0, '37078100', 1140),
 (1141, '山东旅游职业学院', 'shandongluyouzhiyexueyuan', 'sdlyzyxy', 0, '37010000', 1141),
 (1142, '山东杏林科技职业学院', 'shandongxinglinkejizhiyexueyuan', 'sdxlkjzyxy', 0, '37010000', 1142),
 (1143, '菏泽家政职业学院', 'hezejiazhengzhiyexueyuan', 'hzjzzyxy', 0, '37170000', 1143),
 (1144, '烟台工程职业技术学院', 'yantaigongchengzhiyejishuxueyuan', 'ytgczyjsxy', 0, '37060000', 1144),
 (1145, '山东海事职业学院', 'shandonghaishizhiyexueyuan', 'sdhszyxy', 0, '37070000', 1145),
 (1146, '临沂职业学院', 'linyizhiyexueyuan', 'lyzyxy', 0, '37130000', 1146),
 (1147, '山东传媒职业学院', 'shandongchuanmeizhiyexueyuan', 'sdcmzyxy', 0, '37010000', 1147),
 (1148, '山东外事翻译职业学院', 'shandongwaishifanyizhiyexueyuan', 'sdwsfyzyxy', 0, '37010000', 1148),
 (1149, '山东凯文科技职业学院', 'shandongkaiwenkejizhiyexueyuan', 'sdkwkjzyxy', 0, '37010000', 1149),
 (1150, '山东理工职业学院', 'shandongligongzhiyexueyuan', 'sdlgzyxy', 0, '37080000', 1150),
 (1151, '枣庄科技职业学院', 'zaozhuangkejizhiyexueyuan', 'zzkjzyxy', 0, '37040000', 1151),
 (1152, '山东外国语职业学院', 'shandongwaiguoyuzhiyexueyuan', 'sdwgyzyxy', 0, '37110000', 1152),
 (1153, '青岛恒星职业技术学院', 'qingdaohengxingzhiyejishuxueyuan', 'qdhxzyjsxy', 0, '37020000', 1153),
 (1154, '山东药品食品职业学院', 'shandongyaopinshipinzhiyexueyuan', 'sdypspzyxy', 0, '37100000', 1154),
 (1155, '青岛港湾职业技术学院', 'qingdaogangwanzhiyejishuxueyuan', 'qdgwzyjsxy', 0, '37020000', 1155),
 (1156, '泰山职业技术学院', 'taishanzhiyejishuxueyuan', 'tszyjsxy', 0, '37090000', 1156),
 (1157, '山东工业职业学院', 'shandonggongyezhiyexueyuan', 'sdgyzyxy', 0, '37030000', 1157),
 (1158, '潍坊工商职业学院', 'weifanggongshangzhiyexueyuan', 'wfgszyxy', 0, '37070000', 1158),
 (1159, '山东大王职业学院', 'shandongdawangzhiyexueyuan', 'sddwzyxy', 0, '37050000', 1159),
 (1160, '山东胜利职业学院', 'shandongshenglizhiyexueyuan', 'sdslzyxy', 0, '37050000', 1160),
 (1161, '德州科技职业学院', 'dezhoukejizhiyexueyuan', 'dzkjzyxy', 0, '37140000', 1161),
 (1162, '山东力明科技职业学院', 'shandonglimingkejizhiyexueyuan', 'sdlmkjzyxy', 0, '37010000', 1162),
 (1163, '山东服装职业学院', 'shandongfuzhuangzhiyexueyuan', 'sdfzzyxy', 0, '37090000', 1163),
 (1164, '济南工程职业技术学院', 'jinagongchengzhiyejishuxueyuan', 'jngczyjsxy', 0, '37010000', 1164),
 (1165, '淄博科技职业学院', 'zibokejizhiyexueyuan', 'zbkjzyxy', 0, '37030000', 1165),
 (1166, '东营职业学院', 'dongyingzhiyexueyuan', 'dyzyxy', 0, '37050000', 1166),
 (1167, '青岛飞洋职业技术学院', 'qingdaofeiyangzhiyejishuxueyuan', 'qdfyzyjsxy', 0, '37020000', 1167),
 (1168, '山东华宇职业技术学院', 'shandonghuayuzhiyejishuxueyuan', 'sdhyzyjsxy', 0, '37140000', 1168),
 (1169, '青岛酒店管理职业技术学院', 'qingdaojiudianguanlizhiyejishuxueyuan', 'qdjdglzyjsxy', 0, '37020000', 1169),
 (1170, '山东商务职业学院', 'shandongshangwuzhiyexueyuan', 'sdswzyxy', 0, '37060000', 1170),
 (1171, '淄博职业学院', 'zibozhiyexueyuan', 'zbzyxy', 0, '37030000', 1171),
 (1172, '山东现代职业学院', 'shandongxiandaizhiyexueyuan', 'sdxdzyxy', 0, '37010000', 1172),
 (1173, '山东外贸职业学院', 'shandongwaimaozhiyexueyuan', 'sdwmzyxy', 0, '37020000', 1173),
 (1174, '山东信息职业技术学院', 'shandongxinxizhiyejishuxueyuan', 'sdxxzyjsxy', 0, '37070000', 1174),
 (1175, '山东交通职业学院', 'shandongjiaotongzhiyexueyuan', 'sdjtzyxy', 0, '37070000', 1175),
 (1176, '山东铝业职业学院', 'shandongluyezhiyexueyuan', 'sdlyzyxy', 0, '37030000', 1176),
 (1177, '山东经贸职业学院', 'shandongjingmaozhiyexueyuan', 'sdjmzyxy', 0, '37070000', 1177),
 (1178, '滨州职业学院', 'binzhouzhiyexueyuan', 'bzzyxy', 0, '37160000', 1178),
 (1179, '青岛求实职业技术学院', 'qingdaoqiushizhiyejishuxueyuan', 'qdqszyjsxy', 0, '37020000', 1179),
 (1180, '山东司法警官职业学院', 'shandongsifajingguanzhiyexueyuan', 'sdsfjgzyxy', 0, '37010000', 1180),
 (1181, '潍坊职业学院', 'weifangzhiyexueyuan', 'wfzyxy', 0, '37070000', 1181),
 (1182, '烟台汽车工程职业学院', 'yantaiqichegongchengzhiyexueyuan', 'ytqcgczyxy', 0, '37060000', 1182),
 (1183, '山东城市建设职业学院', 'shandongchengshijianshezhiyexueyuan', 'sdcsjszyxy', 0, '37010000', 1183),
 (1184, '山东圣翰财贸职业学院', 'shandongshenghancaimaozhiyexueyuan', 'sdshcmzyxy', 0, '37010000', 1184),
 (1185, '山东电子职业技术学院', 'shandongdianzizhiyejishuxueyuan', 'sddzzyjsxy', 0, '37010000', 1185),
 (1186, '山东科技职业学院', 'shandongkejizhiyexueyuan', 'sdkjzyxy', 0, '37070000', 1186),
 (1187, '烟台职业学院', 'yantaizhiyexueyuan', 'ytzyxy', 0, '37060000', 1187),
 (1188, '山东丝绸纺织职业学院', 'shandongsichoufangzhizhiyexueyuan', 'sdscfzzyxy', 0, '37030000', 1188),
 (1189, '山东化工职业学院', 'shandonghuagongzhiyexueyuan', 'sdhgzyxy', 0, '37030000', 1189),
 (1190, '山东职业学院', 'shandongzhiyexueyuan', 'sdzyxy', 0, '37010000', 1190),
 (1191, '德州职业技术学院', 'dezhouzhiyejishuxueyuan', 'dzzyjsxy', 0, '37140000', 1191),
 (1192, '山东水利职业学院', 'shandongshuilizhiyexueyuan', 'sdslzyxy', 0, '37110000', 1192),
 (1193, '青岛远洋船员职业学院', 'qingdaoyuanyangchuanyuanzhiyexueyuan', 'qdyycyzyxy', 0, '37020000', 1193),
 (1194, '山东文化产业职业学院', 'shandongwenhuachanyezhiyexueyuan', 'sdwhcyzyxy', 0, '37068400', 1194),
 (1195, '郑州大学', 'zhengzhoudaxue', 'zzdx', 0, '41010000', 1195),
 (1196, '河南大学', 'henadaxue', 'hndx', 0, '41020000', 1196),
 (1197, '河南科技大学', 'henakejidaxue', 'hnkjdx', 0, '41030000', 1197),
 (1198, '河南理工大学', 'henaligongdaxue', 'hnlgdx', 0, '41080000', 1198),
 (1199, '河南工业大学', 'henagongyedaxue', 'hngydx', 0, '41010000', 1199),
 (1200, '河南农业大学', 'henanongyedaxue', 'hnnydx', 0, '41010000', 1200),
 (1201, '河南师范大学', 'henashifandaxue', 'hnsfdx', 0, '41070000', 1201),
 (1202, '河南财经政法大学', 'henacaijingzhengfadaxue', 'hncjzfdx', 0, '41010000', 1202),
 (1203, '郑州华信学院', 'zhengzhouhuaxinxueyuan', 'zzhxxy', 0, '41010000', 1203),
 (1204, '郑州科技学院', 'zhengzhoukejixueyuan', 'zzkjxy', 0, '41010000', 1204),
 (1205, '华北水利水电学院', 'huabeishuilishuidianxueyuan', 'hbslsdxy', 0, '41010000', 1205),
 (1206, '郑州轻工业学院', 'zhengzhouqinggongyexueyuan', 'zzqgyxy', 0, '41010000', 1206),
 (1207, '黄河科技学院', 'huanghekejixueyuan', 'hhkjxy', 0, '41010000', 1207),
 (1208, '南阳理工学院', 'nayangligongxueyuan', 'nylgxy', 0, '41130000', 1208),
 (1209, '安阳工学院', 'anyanggongxueyuan', 'aygxy', 0, '41050000', 1209),
 (1210, '河南城建学院', 'henachengjianxueyuan', 'hncjxy', 0, '41040000', 1210),
 (1211, '河南工程学院', 'henagongchengxueyuan', 'hngcxy', 0, '41010000', 1211),
 (1212, '中原工学院', 'zhongyuangongxueyuan', 'zygxy', 0, '41010000', 1212),
 (1213, '郑州航空工业管理学院', 'zhengzhouhangkonggongyeguanlixueyuan', 'zzhkgyglxy', 0, '41010000', 1213),
 (1214, '洛阳理工学院', 'luoyangligongxueyuan', 'lylgxy', 0, '41030000', 1214),
 (1215, '商丘工学院', 'shangqiugongxueyuan', 'sqgxy', 0, '41140000', 1215),
 (1216, '河南中医学院', 'henazhongyixueyuan', 'hnzyxy', 0, '41010000', 1216),
 (1217, '新乡医学院', 'xinxiangyixueyuan', 'xxyxy', 0, '41070000', 1217),
 (1218, '信阳师范学院', 'xinyangshifanxueyuan', 'xysfxy', 0, '41150000', 1218),
 (1219, '安阳师范学院', 'anyangshifanxueyuan', 'aysfxy', 0, '41050000', 1219),
 (1220, '南阳师范学院', 'nayangshifanxueyuan', 'nysfxy', 0, '41130000', 1220),
 (1221, '商丘师范学院', 'shangqiushifanxueyuan', 'sqsfxy', 0, '41140000', 1221),
 (1222, '洛阳师范学院', 'luoyangshifanxueyuan', 'lysfxy', 0, '41030000', 1222),
 (1223, '周口师范学院', 'zhoukoushifanxueyuan', 'zksfxy', 0, '41160000', 1223),
 (1224, '郑州师范学院', 'zhengzhoushifanxueyuan', 'zzsfxy', 0, '41010000', 1224),
 (1225, '郑州升达经贸管理学院', 'zhengzhoushengdajingmaoguanlixueyuan', 'zzsdjmglxy', 0, '41010000', 1225),
 (1226, '河南警察学院', 'henajingchaxueyuan', 'hnjcxy', 0, '41010000', 1226),
 (1227, '新乡学院', 'xinxiangxueyuan', 'xxxy', 0, '41070000', 1227),
 (1228, '平顶山学院', 'pingdingshanxueyuan', 'pdsxy', 0, '41040000', 1228),
 (1229, '黄淮学院', 'huanghuaixueyuan', 'hhxy', 0, '41170000', 1229),
 (1230, '河南科技学院', 'henakejixueyuan', 'hnkjxy', 0, '41070000', 1230),
 (1231, '许昌学院', 'xuchangxueyuan', 'xcxy', 0, '41100000', 1231),
 (1232, '商丘学院', 'shangqiuxueyuan', 'sqxy', 0, '41140000', 1232),
 (1233, '铁道警官高等专科学校', 'tiedaojingguangaodengzhuankexuexiao', 'tdjggdzkxx', 0, '41010000', 1233),
 (1234, '漯河医学高等专科学校', 'luoheyixuegaodengzhuankexuexiao', 'lhyxgdzkxx', 0, '41110000', 1234),
 (1235, '郑州电力高等专科学校', 'zhengzhoudianligaodengzhuankexuexiao', 'zzdlgdzkxx', 0, '41010000', 1235),
 (1236, '河南机电高等专科学校', 'henajidiangaodengzhuankexuexiao', 'hnjdgdzkxx', 0, '41070000', 1236),
 (1237, '郑州牧业工程高等专科学校', 'zhengzhoumuyegongchenggaodengzhuankexuexiao', 'zzmygcgdzkxx', 0, '41010000', 1237),
 (1238, '信阳农业高等专科学校', 'xinyangnongyegaodengzhuankexuexiao', 'xynygdzkxx', 0, '41150000', 1238),
 (1239, '郑州澍青医学高等专科学校', 'zhengzhoushuqingyixuegaodengzhuankexuexiao', 'zzsqyxgdzkxx', 0, '41010000', 1239),
 (1240, '南阳医学高等专科学校', 'nayangyixuegaodengzhuankexuexiao', 'nyyxgdzkxx', 0, '41130000', 1240),
 (1241, '商丘医学高等专科学校', 'shangqiuyixuegaodengzhuankexuexiao', 'sqyxgdzkxx', 0, '41140000', 1241),
 (1242, '焦作师范高等专科学校', 'jiaozuoshifangaodengzhuankexuexiao', 'jzsfgdzkxx', 0, '41080000', 1242),
 (1243, '河南财政税务高等专科学校', 'henacaizhengshuiwugaodengzhuankexuexiao', 'hnczswgdzkxx', 0, '41010000', 1243),
 (1244, '河南商业高等专科学校', 'henashangyegaodengzhuankexuexiao', 'hnsygdzkxx', 0, '41010000', 1244),
 (1245, '焦作工贸职业学院', 'jiaozuogongmaozhiyexueyuan', 'jzgmzyxy', 0, '41080000', 1245),
 (1246, '河南化工职业学院', 'henahuagongzhiyexueyuan', 'hnhgzyxy', 0, '41010000', 1246),
 (1247, '郑州理工职业学院', 'zhengzhouligongzhiyexueyuan', 'zzlgzyxy', 0, '41010000', 1247),
 (1248, '郑州信息工程职业学院', 'zhengzhouxinxigongchengzhiyexueyuan', 'zzxxgczyxy', 0, '41010000', 1248),
 (1249, '开封文化艺术职业学院', 'kaifengwenhuayishuzhiyexueyuan', 'kfwhyszyxy', 0, '41020000', 1249),
 (1250, '河南艺术职业学院', 'henayishuzhiyexueyuan', 'hnyszyxy', 0, '41010000', 1250),
 (1251, '黄河水利职业技术学院', 'huangheshuilizhiyejishuxueyuan', 'hhslzyjsxy', 0, '41020000', 1251),
 (1252, '漯河职业技术学院', 'luohezhiyejishuxueyuan', 'lhzyjsxy', 0, '41110000', 1252),
 (1253, '焦作大学', 'jiaozuodaxue', 'jzdx', 0, '41080000', 1253),
 (1254, '开封大学', 'kaifengdaxue', 'kfdx', 0, '41020000', 1254),
 (1255, '中州大学', 'zhongzhoudaxue', 'zzdx', 0, '41010000', 1255),
 (1256, '河南职业技术学院', 'henazhiyejishuxueyuan', 'hnzyjsxy', 0, '41010000', 1256),
 (1257, '郑州铁路职业技术学院', 'zhengzhoutieluzhiyejishuxueyuan', 'zztlzyjsxy', 0, '41010000', 1257),
 (1258, '三门峡职业技术学院', 'sanmenxiazhiyejishuxueyuan', 'smxzyjsxy', 0, '41120000', 1258),
 (1259, '洛阳职业技术学院', 'luoyangzhiyejishuxueyuan', 'lyzyjsxy', 0, '41030000', 1259),
 (1260, '许昌电气职业学院', 'xuchangdianqizhiyexueyuan', 'xcdqzyxy', 0, '41100000', 1260),
 (1261, '河南推拿职业学院', 'henatuinazhiyexueyuan', 'hntnzyxy', 0, '41030000', 1261),
 (1262, '漯河食品职业学院', 'luoheshipinzhiyexueyuan', 'lhspzyxy', 0, '41110000', 1262),
 (1263, '河南护理职业学院', 'henahulizhiyexueyuan', 'hnhlzyxy', 0, '41050000', 1263),
 (1264, '商丘职业技术学院', 'shangqiuzhiyejishuxueyuan', 'sqzyjsxy', 0, '41140000', 1264),
 (1265, '郑州经贸职业学院', 'zhengzhoujingmaozhiyexueyuan', 'zzjmzyxy', 0, '41010000', 1265),
 (1266, '郑州信息科技职业学院', 'zhengzhouxinxikejizhiyexueyuan', 'zzxxkjzyxy', 0, '41010000', 1266),
 (1267, '河南质量工程职业学院', 'henazhilianggongchengzhiyexueyuan', 'hnzlgczyxy', 0, '41040000', 1267),
 (1268, '南阳职业学院', 'nayangzhiyexueyuan', 'nyzyxy', 0, '41130000', 1268),
 (1269, '郑州电子信息职业技术学院', 'zhengzhoudianzixinxizhiyejishuxueyuan', 'zzdzxxzyjsxy', 0, '41010000', 1269),
 (1270, '河南机电职业学院', 'henajidianzhiyexueyuan', 'hnjdzyxy', 0, '41018400', 1270),
 (1271, '郑州电力职业技术学院', 'zhengzhoudianlizhiyejishuxueyuan', 'zzdlzyjsxy', 0, '41010000', 1271),
 (1272, '新乡职业技术学院', 'xinxiangzhiyejishuxueyuan', 'xxzyjsxy', 0, '41070000', 1272),
 (1273, '嵩山少林武术职业学院', 'songshanshaolinwushuzhiyexueyuan', 'ssslwszyxy', 0, '41018500', 1273),
 (1274, '郑州工业安全职业学院', 'zhengzhougongyeanquanzhiyexueyuan', 'zzgyaqzyxy', 0, '41010000', 1274),
 (1275, '永城职业学院', 'yongchengzhiyexueyuan', 'yczyxy', 0, '41148100', 1275),
 (1276, '信阳职业技术学院', 'xinyangzhiyejishuxueyuan', 'xyzyjsxy', 0, '41150000', 1276),
 (1277, '郑州职业技术学院', 'zhengzhouzhiyejishuxueyuan', 'zzzyjsxy', 0, '41010000', 1277),
 (1278, '郑州旅游职业学院', 'zhengzhouluyouzhiyexueyuan', 'zzlyzyxy', 0, '41010000', 1278),
 (1279, '河南农业职业学院', 'henanongyezhiyexueyuan', 'hnnyzyxy', 0, '41010000', 1279),
 (1280, '河南交通职业技术学院', 'henajiaotongzhiyejishuxueyuan', 'hnjtzyjsxy', 0, '41010000', 1280),
 (1281, '河南经贸职业学院', 'henajingmaozhiyexueyuan', 'hnjmzyxy', 0, '41010000', 1281),
 (1282, '鹤壁汽车工程职业学院', 'hebiqichegongchengzhiyexueyuan', 'hbqcgczyxy', 0, '41060000', 1282),
 (1283, '安阳职业技术学院', 'anyangzhiyejishuxueyuan', 'ayzyjsxy', 0, '41050000', 1283),
 (1284, '信阳涉外职业技术学院', 'xinyangshewaizhiyejishuxueyuan', 'xyswzyjsxy', 0, '41150000', 1284),
 (1285, '郑州交通职业学院', 'zhengzhoujiaotongzhiyexueyuan', 'zzjtzyxy', 0, '41010000', 1285),
 (1286, '河南检察职业学院', 'henajianchazhiyexueyuan', 'hnjczyxy', 0, '41010000', 1286),
 (1287, '驻马店职业技术学院', 'zhumadianzhiyejishuxueyuan', 'zmdzyjsxy', 0, '41170000', 1287),
 (1288, '河南工业贸易职业学院', 'henagongyemaoyizhiyexueyuan', 'hngymyzyxy', 0, '41010000', 1288),
 (1289, '济源职业技术学院', 'jiyuanzhiyejishuxueyuan', 'jyzyjsxy', 0, '41088100', 1289),
 (1290, '郑州商贸旅游职业学院', 'zhengzhoushangmaoluyouzhiyexueyuan', 'zzsmlyzyxy', 0, '41010000', 1290),
 (1291, '周口科技职业学院', 'zhoukoukejizhiyexueyuan', 'zkkjzyxy', 0, '41160000', 1291),
 (1292, '河南建筑职业技术学院', 'henajianzhuzhiyejishuxueyuan', 'hnjzzyjsxy', 0, '41010000', 1292),
 (1293, '平顶山工业职业技术学院', 'pingdingshangongyezhiyejishuxueyuan', 'pdsgyzyjsxy', 0, '41040000', 1293),
 (1294, '郑州城市职业学院', 'zhengzhouchengshizhiyexueyuan', 'zzcszyxy', 0, '41010000', 1294),
 (1295, '鹤壁职业技术学院', 'hebizhiyejishuxueyuan', 'hbzyjsxy', 0, '41060000', 1295),
 (1296, '濮阳职业技术学院', 'puyangzhiyejishuxueyuan', 'pyzyjsxy', 0, '41090000', 1296),
 (1297, '许昌职业技术学院', 'xuchangzhiyejishuxueyuan', 'xczyjsxy', 0, '41100000', 1297),
 (1298, '周口职业技术学院', 'zhoukouzhiyejishuxueyuan', 'zkzyjsxy', 0, '41160000', 1298),
 (1299, '河南司法警官职业学院', 'henasifajingguanzhiyexueyuan', 'hnsfjgzyxy', 0, '41010000', 1299),
 (1300, '河南工业职业技术学院', 'henagongyezhiyejishuxueyuan', 'hngyzyjsxy', 0, '41130000', 1300),
 (1301, '长垣烹饪职业技术学院', 'changyuanpengrenzhiyejishuxueyuan', 'cyprzyjsxy', 0, '41070000', 1301),
 (1302, '许昌陶瓷职业学院', 'xuchangtaocizhiyexueyuan', 'xctczyxy', 0, '41100000', 1302),
 (1303, '武汉大学', 'wuhandaxue', 'whdx', 0, '42010000', 1303),
 (1304, '中南财经政法大学', 'zhongnacaijingzhengfadaxue', 'zncjzfdx', 0, '42010000', 1304),
 (1305, '华中科技大学', 'huazhongkejidaxue', 'hzkjdx', 0, '42010000', 1305),
 (1306, '武汉理工大学', 'wuhanligongdaxue', 'whlgdx', 0, '42010000', 1306),
 (1307, '中国地质大学', 'zhongguodizhidaxue', 'zgdzdx', 0, '42010000', 1307),
 (1308, '华中农业大学', 'huazhongnongyedaxue', 'hznydx', 0, '42010000', 1308),
 (1309, '华中师范大学', 'huazhongshifandaxue', 'hzsfdx', 0, '42010000', 1309),
 (1310, '中南民族大学', 'zhongnaminzudaxue', 'znmzdx', 0, '42010000', 1310),
 (1311, '湖北大学', 'hubeidaxue', 'hbdx', 0, '42010000', 1311),
 (1312, '长江大学', 'changjiangdaxue', 'cjdx', 0, '42100000', 1312),
 (1313, '江汉大学', 'jianghandaxue', 'jhdx', 0, '42010000', 1313),
 (1314, '三峡大学', 'sanxiadaxue', 'sxdx', 0, '42050000', 1314),
 (1315, '武汉科技大学', 'wuhankejidaxue', 'whkjdx', 0, '42010000', 1315),
 (1316, '湖北工业大学', 'hubeigongyedaxue', 'hbgydx', 0, '42010000', 1316),
 (1317, '武汉工程大学', 'wuhangongchengdaxue', 'whgcdx', 0, '42010000', 1317),
 (1318, '武汉纺织大学', 'wuhanfangzhidaxue', 'whfzdx', 0, '42010000', 1318),
 (1319, '湖北中医药大学', 'hubeizhongyiyaodaxue', 'hbzyydx', 0, '42010000', 1319),
 (1320, '武汉工业学院', 'wuhangongyexueyuan', 'whgyxy', 0, '42010000', 1320),
 (1321, '湖北汽车工业学院', 'hubeiqichegongyexueyuan', 'hbqcgyxy', 0, '42030000', 1321),
 (1322, '荆楚理工学院', 'jingchuligongxueyuan', 'jclgxy', 0, '42080000', 1322),
 (1323, '武昌理工学院', 'wuchangligongxueyuan', 'wclgxy', 0, '42010000', 1323),
 (1324, '湖北医药学院', 'hubeiyiyaoxueyuan', 'hbyyxy', 0, '42030000', 1324),
 (1325, '湖北师范学院', 'hubeishifanxueyuan', 'hbsfxy', 0, '42020000', 1325),
 (1326, '黄冈师范学院', 'huanggangshifanxueyuan', 'hgsfxy', 0, '42110000', 1326),
 (1327, '孝感学院', 'xiaoganxueyuan', 'xgxy', 0, '42090000', 1327),
 (1328, '湖北第二师范学院', 'hubeidieshifanxueyuan', 'hbdesfxy', 0, '42010000', 1328),
 (1329, '湖北经济学院', 'hubeijingjixueyuan', 'hbjjxy', 0, '42010000', 1329),
 (1330, '武汉长江工商学院', 'wuhanchangjianggongshangxueyuan', 'whcjgsxy', 0, '42010000', 1330),
 (1331, '湖北警官学院', 'hubeijingguanxueyuan', 'hbjgxy', 0, '42010000', 1331),
 (1332, '武汉体育学院', 'wuhantiyuxueyuan', 'whtyxy', 0, '42010000', 1332),
 (1333, '湖北美术学院', 'hubeimeishuxueyuan', 'hbmsxy', 0, '42010000', 1333),
 (1334, '武汉音乐学院', 'wuhanyinlexueyuan', 'whylxy', 0, '42010000', 1334),
 (1335, '湖北民族学院', 'hubeiminzuxueyuan', 'hbmzxy', 0, '42280100', 1335),
 (1336, '黄石理工学院', 'huangshiligongxueyuan', 'hslgxy', 0, '42020000', 1336),
 (1337, '武汉生物工程学院', 'wuhanshengwugongchengxueyuan', 'whswgcxy', 0, '42010000', 1337),
 (1338, '襄樊学院', 'xiangfanxueyuan', 'xfxy', 0, '42060000', 1338),
 (1339, '咸宁学院', 'xianningxueyuan', 'xnxy', 0, '42120000', 1339),
 (1340, '武汉东湖学院', 'wuhandonghuxueyuan', 'whdhxy', 0, '42010000', 1340),
 (1341, '汉口学院', 'hankouxueyuan', 'hkxy', 0, '42010000', 1341),
 (1342, '湖北中医药高等专科学校', 'hubeizhongyiyaogaodengzhuankexuexiao', 'hbzyygdzkxx', 0, '42100000', 1342),
 (1343, '郧阳师范高等专科学校', 'yunyangshifangaodengzhuankexuexiao', 'yysfgdzkxx', 0, '42030000', 1343),
 (1344, '湖北财经高等专科学校', 'hubeicaijinggaodengzhuankexuexiao', 'hbcjgdzkxx', 0, '42010000', 1344),
 (1345, '武汉船舶职业技术学院', 'wuhanchuanbozhiyejishuxueyuan', 'whcbzyjsxy', 0, '42010000', 1345),
 (1346, '恩施职业技术学院', 'eshizhiyejishuxueyuan', 'eszyjsxy', 0, '42280100', 1346),
 (1347, '长江职业学院', 'changjiangzhiyexueyuan', 'cjzyxy', 0, '42010000', 1347),
 (1348, '武汉工贸职业学院', 'wuhangongmaozhiyexueyuan', 'whgmzyxy', 0, '42010000', 1348),
 (1349, '十堰职业技术学院', 'shiyanzhiyejishuxueyuan', 'syzyjsxy', 0, '42030000', 1349),
 (1350, '鄂州职业大学', 'ezhouzhiyedaxue', 'ezzydx', 0, '42070000', 1350),
 (1351, '荆州理工职业学院', 'jingzhouligongzhiyexueyuan', 'jzlgzyxy', 0, '42100000', 1351),
 (1352, '武汉商业服务学院', 'wuhanshangyefuwuxueyuan', 'whsyfwxy', 0, '42010000', 1352),
 (1353, '黄冈职业技术学院', 'huanggangzhiyejishuxueyuan', 'hgzyjsxy', 0, '42110000', 1353),
 (1354, '湖北职业技术学院', 'hubeizhiyejishuxueyuan', 'hbzyjsxy', 0, '42090000', 1354),
 (1355, '襄樊职业技术学院', 'xiangfanzhiyejishuxueyuan', 'xfzyjsxy', 0, '42060000', 1355),
 (1356, '武汉职业技术学院', 'wuhanzhiyejishuxueyuan', 'whzyjsxy', 0, '42010000', 1356),
 (1357, '随州职业技术学院', 'suizhouzhiyejishuxueyuan', 'szzyjsxy', 0, '42130000', 1357),
 (1358, '武汉铁路职业技术学院', 'wuhantieluzhiyejishuxueyuan', 'whtlzyjsxy', 0, '42010000', 1358),
 (1359, '武汉警官职业学院', 'wuhanjingguanzhiyexueyuan', 'whjgzyxy', 0, '42010000', 1359),
 (1360, '三峡旅游职业技术学院', 'sanxialuyouzhiyejishuxueyuan', 'sxlyzyjsxy', 0, '42050000', 1360),
 (1361, '黄冈科技职业学院', 'huanggangkejizhiyexueyuan', 'hgkjzyxy', 0, '42110000', 1361),
 (1362, '武汉民政职业学院', 'wuhanminzhengzhiyexueyuan', 'whmzzyxy', 0, '42010000', 1362),
 (1363, '武汉交通职业学院', 'wuhanjiaotongzhiyexueyuan', 'whjtzyxy', 0, '42010000', 1363),
 (1364, '鄂东职业技术学院', 'edongzhiyejishuxueyuan', 'edzyjsxy', 0, '42070000', 1364),
 (1365, '湖北财税职业学院', 'hubeicaishuizhiyexueyuan', 'hbcszyxy', 0, '42010000', 1365),
 (1366, '湖北生物科技职业学院', 'hubeishengwukejizhiyexueyuan', 'hbswkjzyxy', 0, '42010000', 1366),
 (1367, '湖北国土资源职业学院', 'hubeiguotuziyuanzhiyexueyuan', 'hbgtzyzyxy', 0, '42100000', 1367),
 (1368, '湖北生态工程职业技术学院', 'hubeishengtaigongchengzhiyejishuxueyuan', 'hbstgczyjsxy', 0, '42010000', 1368),
 (1369, '武汉语言文化职业学院', 'wuhanyuyanwenhuazhiyexueyuan', 'whyywhzyxy', 0, '42010000', 1369),
 (1370, '江汉艺术职业学院', 'jianghanyishuzhiyexueyuan', 'jhyszyxy', 0, '53050000', 1370),
 (1371, '武汉工业职业技术学院', 'wuhangongyezhiyejishuxueyuan', 'whgyzyjsxy', 0, '42010000', 1371),
 (1372, '天门职业学院', 'tianmenzhiyexueyuan', 'tmzyxy', 0, '42900600', 1372),
 (1373, '咸宁职业技术学院', 'xianningzhiyejishuxueyuan', 'xnzyjsxy', 0, '42120000', 1373),
 (1374, '襄阳汽车职业技术学院', 'xiangyangqichezhiyejishuxueyuan', 'xyqczyjsxy', 0, '42060700', 1374),
 (1375, '湖北艺术职业学院', 'hubeiyishuzhiyexueyuan', 'hbyszyxy', 0, '42010000', 1375),
 (1376, '湖北科技职业学院', 'hubeikejizhiyexueyuan', 'hbkjzyxy', 0, '42010000', 1376),
 (1377, '湖北交通职业技术学院', 'hubeijiaotongzhiyejishuxueyuan', 'hbjtzyjsxy', 0, '42010000', 1377),
 (1378, '湖北轻工职业技术学院', 'hubeiqinggongzhiyejishuxueyuan', 'hbqgzyjsxy', 0, '42010000', 1378),
 (1379, '武汉软件工程职业学院', 'wuhanruanjiangongchengzhiyexueyuan', 'whrjgczyxy', 0, '42010000', 1379),
 (1380, '黄石职业技术学院', 'huangshizhiyejishuxueyuan', 'hszyjsxy', 0, '42020000', 1380),
 (1381, '荆州职业技术学院', 'jingzhouzhiyejishuxueyuan', 'jzzyjsxy', 0, '42100000', 1381),
 (1382, '武汉外语外事职业学院', 'wuhanwaiyuwaishizhiyexueyuan', 'whwywszyxy', 0, '42010000', 1382),
 (1383, '仙桃职业学院', 'xiantaozhiyexueyuan', 'xtzyxy', 0, '42900400', 1383),
 (1384, '湖北三峡职业技术学院', 'hubeisanxiazhiyejishuxueyuan', 'hbsxzyjsxy', 0, '42050000', 1384),
 (1385, '湖北体育职业学院', 'hubeitiyuzhiyexueyuan', 'hbtyzyxy', 0, '42010000', 1385),
 (1386, '武汉商贸职业学院', 'wuhanshangmaozhiyexueyuan', 'whsmzyxy', 0, '42010000', 1386),
 (1387, '长江工程职业技术学院', 'changjianggongchengzhiyejishuxueyuan', 'cjgczyjsxy', 0, '42010000', 1387),
 (1388, '武汉航海职业技术学院', 'wuhanhanghaizhiyejishuxueyuan', 'whhhzyjsxy', 0, '42010000', 1388),
 (1389, '武汉城市职业学院', 'wuhanchengshizhiyexueyuan', 'whcszyxy', 0, '42010000', 1389),
 (1390, '湖北开放职业学院', 'hubeikaifangzhiyexueyuan', 'hbkfzyxy', 0, '42010000', 1390),
 (1391, '武汉信息传播职业技术学院', 'wuhanxinxichuanbozhiyejishuxueyuan', 'whxxcbzyjsxy', 0, '42010000', 1391),
 (1392, '武汉科技职业学院', 'wuhankejizhiyexueyuan', 'whkjzyxy', 0, '42010000', 1392),
 (1393, '武汉电力职业技术学院', 'wuhandianlizhiyejishuxueyuan', 'whdlzyjsxy', 0, '42010000', 1393),
 (1394, '三峡电力职业学院', 'sanxiadianlizhiyexueyuan', 'sxdlzyxy', 0, '42050000', 1394),
 (1395, '湖北城市建设职业技术学院', 'hubeichengshijianshezhiyejishuxueyuan', 'hbcsjszyjsxy', 0, '42010000', 1395),
 (1396, '武汉工程职业技术学院', 'wuhangongchengzhiyejishuxueyuan', 'whgczyjsxy', 0, '42010000', 1396),
 (1397, '湖北青年职业学院', 'hubeiqingnianzhiyexueyuan', 'hbqnzyxy', 0, '42010000', 1397),
 (1398, '湖北水利水电职业技术学院', 'hubeishuilishuidianzhiyejishuxueyuan', 'hbslsdzyjsxy', 0, '42010000', 1398),
 (1399, '中南大学', 'zhongnadaxue', 'zndx', 0, '43010000', 1399),
 (1400, '湖南大学', 'hunadaxue', 'hndx', 0, '43010000', 1400),
 (1401, '湘潭大学', 'xiangtandaxue', 'xtdx', 0, '43030000', 1401),
 (1402, '吉首大学', 'jishoudaxue', 'jsdx', 0, '43310100', 1402),
 (1403, '湖南科技大学', 'hunakejidaxue', 'hnkjdx', 0, '43030000', 1403),
 (1404, '长沙理工大学', 'changshaligongdaxue', 'cslgdx', 0, '43010000', 1404),
 (1405, '南华大学', 'nahuadaxue', 'nhdx', 0, '43040000', 1405),
 (1406, '湖南工业大学', 'hunagongyedaxue', 'hngydx', 0, '43020000', 1406),
 (1407, '湖南农业大学', 'hunanongyedaxue', 'hnnydx', 0, '43010000', 1407),
 (1408, '湖南中医药大学', 'hunazhongyiyaodaxue', 'hnzyydx', 0, '43010000', 1408),
 (1409, '湖南师范大学', 'hunashifandaxue', 'hnsfdx', 0, '43010000', 1409),
 (1410, '长沙学院', 'changshaxueyuan', 'csxy', 0, '43010000', 1410),
 (1411, '湖南第一师范学院', 'hunadiyishifanxueyuan', 'hndysfxy', 0, '43010000', 1411),
 (1412, '湖南理工学院', 'hunaligongxueyuan', 'hnlgxy', 0, '43060000', 1412),
 (1413, '湖南工学院', 'hunagongxueyuan', 'hngxy', 0, '43040000', 1413),
 (1414, '湖南工程学院', 'hunagongchengxueyuan', 'hngcxy', 0, '43030000', 1414),
 (1415, '湖南城市学院', 'hunachengshixueyuan', 'hncsxy', 0, '43090000', 1415),
 (1416, '中南林业科技大学', 'zhongnalinyekejidaxue', 'znlykjdx', 0, '43020000', 1416),
 (1417, '长沙医学院', 'changshayixueyuan', 'csyxy', 0, '43040000', 1417),
 (1418, '衡阳师范学院', 'hengyangshifanxueyuan', 'hysfxy', 0, '43040000', 1418),
 (1419, '湘南学院', 'xiangnaxueyuan', 'xnxy', 0, '43100000', 1419),
 (1420, '湖南财政经济学院', 'hunacaizhengjingjixueyuan', 'hnczjjxy', 0, '43010000', 1420),
 (1421, '湖南商学院', 'hunashangxueyuan', 'hnsxy', 0, '43010000', 1421),
 (1422, '湖南涉外经济学院', 'hunashewaijingjixueyuan', 'hnswjjxy', 0, '43010000', 1422),
 (1423, '湖南警察学院', 'hunajingchaxueyuan', 'hnjcxy', 0, '43010000', 1423),
 (1424, '湖南文理学院', 'hunawenlixueyuan', 'hnwlxy', 0, '43070000', 1424),
 (1425, '怀化学院', 'huaihuaxueyuan', 'hhxy', 0, '43120000', 1425),
 (1426, '湖南科技学院', 'hunakejixueyuan', 'hnkjxy', 0, '43110000', 1426),
 (1427, '邵阳学院', 'shaoyangxueyuan', 'syxy', 0, '43050000', 1427),
 (1428, '湖南人文科技学院', 'hunarenwenkejixueyuan', 'hnrwkjxy', 0, '43130000', 1428),
 (1429, '湖南女子学院', 'hunanuzixueyuan', 'hnnzxy', 0, '43010000', 1429),
 (1430, '怀化医学高等专科学校', 'huaihuayixuegaodengzhuankexuexiao', 'hhyxgdzkxx', 0, '43120000', 1430),
 (1431, '益阳医学高等专科学校', 'yiyangyixuegaodengzhuankexuexiao', 'yyyxgdzkxx', 0, '43090000', 1431),
 (1432, '邵阳医学高等专科学校', 'shaoyangyixuegaodengzhuankexuexiao', 'syyxgdzkxx', 0, '43050000', 1432),
 (1433, '湖南中医药高等专科学校', 'hunazhongyiyaogaodengzhuankexuexiao', 'hnzyygdzkxx', 0, '43020000', 1433),
 (1434, '株洲师范高等专科学校', 'zhuzhoushifangaodengzhuankexuexiao', 'zzsfgdzkxx', 0, '43020000', 1434),
 (1435, '长沙师范学校', 'changshashifanxuexiao', 'cssfxx', 0, '43010000', 1435),
 (1436, '湖南税务高等专科学校', 'hunashuiwugaodengzhuankexuexiao', 'hnswgdzkxx', 0, '43010000', 1436),
 (1437, '长沙航空职业技术学院', 'changshahangkongzhiyejishuxueyuan', 'cshkzyjsxy', 0, '43010000', 1437),
 (1438, '湖南环境生物职业技术学院', 'hunahuanjingshengwuzhiyejishuxueyuan', 'hnhjswzyjsxy', 0, '43040000', 1438),
 (1439, '湖南大众传媒职业技术学院', 'hunadazhongchuanmeizhiyejishuxueyuan', 'hndzcmzyjsxy', 0, '43010000', 1439),
 (1440, '永州职业技术学院', 'yongzhouzhiyejishuxueyuan', 'yzzyjsxy', 0, '43110000', 1440),
 (1441, '长沙民政职业技术学院', 'changshaminzhengzhiyejishuxueyuan', 'csmzzyjsxy', 0, '43010000', 1441),
 (1442, '湖南铁道职业技术学院', 'hunatiedaozhiyejishuxueyuan', 'hntdzyjsxy', 0, '43020000', 1442),
 (1443, '湖南工业职业技术学院', 'hunagongyezhiyejishuxueyuan', 'hngyzyjsxy', 0, '43010000', 1443),
 (1444, '湖南信息职业技术学院', 'hunaxinxizhiyejishuxueyuan', 'hnxxzyjsxy', 0, '43010000', 1444),
 (1445, '湖南冶金职业技术学院', 'hunayejinzhiyejishuxueyuan', 'hnyjzyjsxy', 0, '43020000', 1445),
 (1446, '湖南城建职业技术学院', 'hunachengjianzhiyejishuxueyuan', 'hncjzyjsxy', 0, '43030000', 1446),
 (1447, '衡阳财经工业职业技术学院', 'hengyangcaijinggongyezhiyejishuxueyuan', 'hycjgyzyjsxy', 0, '43040000', 1447),
 (1448, '湖南外国语职业学院', 'hunawaiguoyuzhiyexueyuan', 'hnwgyzyxy', 0, '43010000', 1448),
 (1449, '湖南石油化工职业技术学院', 'hunashiyouhuagongzhiyejishuxueyuan', 'hnsyhgzyjsxy', 0, '43060000', 1449),
 (1450, '株洲职业技术学院', 'zhuzhouzhiyejishuxueyuan', 'zzzyjsxy', 0, '43020000', 1450),
 (1451, '长沙职业技术学院', 'changshazhiyejishuxueyuan', 'cszyjsxy', 0, '43010000', 1451),
 (1452, '湘西民族职业技术学院', 'xiangximinzuzhiyejishuxueyuan', 'xxmzzyjsxy', 0, '43310000', 1452),
 (1453, '湖南电气职业技术学院', 'hunadianqizhiyejishuxueyuan', 'hndqzyjsxy', 0, '43030000', 1453),
 (1454, '益阳职业技术学院', 'yiyangzhiyejishuxueyuan', 'yyzyjsxy', 0, '43090000', 1454),
 (1455, '湖南同德职业学院', 'hunatongdezhiyexueyuan', 'hntdzyxy', 0, '43070000', 1455),
 (1456, '湖南食品药品职业学院', 'hunashipinyaopinzhiyexueyuan', 'hnspypzyxy', 0, '43010000', 1456),
 (1457, '湖南司法警官职业学院', 'hunasifajingguanzhiyexueyuan', 'hnsfjgzyxy', 0, '43010000', 1457),
 (1458, '湖南民族职业学院', 'hunaminzuzhiyexueyuan', 'hnmzzyxy', 0, '43060000', 1458),
 (1459, '湖南网络工程职业学院', 'hunawangluogongchengzhiyexueyuan', 'hnwlgczyxy', 0, '43010000', 1459),
 (1460, '长沙商贸旅游职业技术学院', 'changshashangmaoluyouzhiyejishuxueyuan', 'cssmlyzyjsxy', 0, '43010000', 1460),
 (1461, '湖南有色金属职业技术学院', 'hunayousejinshuzhiyejishuxueyuan', 'hnysjszyjsxy', 0, '43020000', 1461),
 (1462, '湖南科技经贸职业学院', 'hunakejijingmaozhiyexueyuan', 'hnkjjmzyxy', 0, '43040000', 1462),
 (1463, '长沙电力职业技术学院', 'changshadianlizhiyejishuxueyuan', 'csdlzyjsxy', 0, '43010000', 1463),
 (1464, '湖南水利水电职业技术学院', 'hunashuilishuidianzhiyejishuxueyuan', 'hnslsdzyjsxy', 0, '43010000', 1464),
 (1465, '湖南现代物流职业技术学院', 'hunaxiandaiwuliuzhiyejishuxueyuan', 'hnxdwlzyjsxy', 0, '43010000', 1465),
 (1466, '湖南高速铁路职业技术学院', 'hunagaosutieluzhiyejishuxueyuan', 'hngstlzyjsxy', 0, '43040000', 1466),
 (1467, '湖南铁路科技职业技术学院', 'hunatielukejizhiyejishuxueyuan', 'hntlkjzyjsxy', 0, '43020000', 1467),
 (1468, '湖南工艺美术职业学院', 'hunagongyimeishuzhiyexueyuan', 'hngymszyxy', 0, '43090000', 1468),
 (1469, '湖南电子科技职业学院', 'hunadianzikejizhiyexueyuan', 'hndzkjzyxy', 0, '43030000', 1469),
 (1470, '湖南理工职业技术学院', 'hunaligongzhiyejishuxueyuan', 'hnlgzyjsxy', 0, '43030000', 1470),
 (1471, '长沙卫生职业学院', 'changshaweishengzhiyexueyuan', 'cswszyxy', 0, '43010000', 1471),
 (1472, '湖南软件职业学院', 'hunaruanjianzhiyexueyuan', 'hnrjzyxy', 0, '43030000', 1472),
 (1473, '湖南信息科学职业学院', 'hunaxinxikexuezhiyexueyuan', 'hnxxkxzyxy', 0, '43010000', 1473),
 (1474, '湖南生物机电职业技术学院', 'hunashengwujidianzhiyejishuxueyuan', 'hnswjdzyjsxy', 0, '43010000', 1474),
 (1475, '岳阳职业技术学院', 'yueyangzhiyejishuxueyuan', 'yyzyjsxy', 0, '43060000', 1475),
 (1476, '湖南安全技术职业学院', 'hunaanquanjishuzhiyexueyuan', 'hnaqjszyxy', 0, '43010000', 1476),
 (1477, '邵阳职业技术学院', 'shaoyangzhiyejishuxueyuan', 'syzyjsxy', 0, '43050000', 1477),
 (1478, '湖南都市职业学院', 'hunadushizhiyexueyuan', 'hndszyxy', 0, '43010000', 1478),
 (1479, '湖南九嶷职业技术学院', 'hunajiuyizhiyejishuxueyuan', 'hnjyzyjsxy', 0, '43110000', 1479),
 (1480, '湖南机电职业技术学院', 'hunajidianzhiyejishuxueyuan', 'hnjdzyjsxy', 0, '43010000', 1480),
 (1481, '张家界航空工业职业技术学院', 'zhangjiajiehangkonggongyezhiyejishuxueyuan', 'zjjhkgyzyjsxy', 0, '43080000', 1481),
 (1482, '长沙通信职业技术学院', 'changshatongxinzhiyejishuxueyuan', 'cstxzyjsxy', 0, '43010000', 1482),
 (1483, '娄底职业技术学院', 'loudizhiyejishuxueyuan', 'ldzyjsxy', 0, '43130000', 1483),
 (1484, '湖南交通职业技术学院', 'hunajiaotongzhiyejishuxueyuan', 'hnjtzyjsxy', 0, '43010000', 1484),
 (1485, '潇湘职业学院', 'xiaoxiangzhiyexueyuan', 'xxzyxy', 0, '43130000', 1485),
 (1486, '湖南商务职业技术学院', 'hunashangwuzhiyejishuxueyuan', 'hnswzyjsxy', 0, '43010000', 1486),
 (1487, '湘潭职业技术学院', 'xiangtanzhiyejishuxueyuan', 'xtzyjsxy', 0, '43030000', 1487),
 (1488, '郴州职业技术学院', 'chenzhouzhiyejishuxueyuan', 'czzyjsxy', 0, '43100000', 1488),
 (1489, '湖南科技职业学院', 'hunakejizhiyexueyuan', 'hnkjzyxy', 0, '43010000', 1489),
 (1490, '湖南体育职业学院', 'hunatiyuzhiyexueyuan', 'hntyzyxy', 0, '43010000', 1490),
 (1491, '湖南艺术职业学院', 'hunayishuzhiyexueyuan', 'hnyszyxy', 0, '43010000', 1491),
 (1492, '长沙南方职业学院', 'changshanafangzhiyexueyuan', 'csnfzyxy', 0, '43010000', 1492),
 (1493, '湖南三一工业职业技术学院', 'hunasanyigongyezhiyejishuxueyuan', 'hnsygyzyjsxy', 0, '43010000', 1493),
 (1494, '常德职业技术学院', 'changdezhiyejishuxueyuan', 'cdzyjsxy', 0, '43070000', 1494),
 (1495, '怀化职业技术学院', 'huaihuazhiyejishuxueyuan', 'hhzyjsxy', 0, '43120000', 1495),
 (1496, '保险职业学院', 'baoxianzhiyexueyuan', 'bxzyxy', 0, '43010000', 1496),
 (1497, '湖南科技工业职业技术学院', 'hunakejigongyezhiyejishuxueyuan', 'hnkjgyzyjsxy', 0, '43030000', 1497),
 (1498, '湖南化工职业技术学院', 'hunahuagongzhiyejishuxueyuan', 'hnhgzyjsxy', 0, '43020000', 1498),
 (1499, '湖南外贸职业学院', 'hunawaimaozhiyexueyuan', 'hnwmzyxy', 0, '43010000', 1499);
 INSERT `tn_Schools` (`Id`, `Name`, `PinyinName`, `ShortPinyinName`, `SchoolType`, `AreaCode`, `DisplayOrder`)
 VALUES
 (1500, '湖南工程职业技术学院', 'hunagongchengzhiyejishuxueyuan', 'hngczyjsxy', 0, '43010000', 1500),
 (1501, '长沙环境保护职业技术学院', 'changshahuanjingbaohuzhiyejishuxueyuan', 'cshjbhzyjsxy', 0, '43010000', 1501),
 (1502, '湖南高尔夫旅游职业学院', 'hunagaoefuluyouzhiyexueyuan', 'hngeflyzyxy', 0, '43070000', 1502),
 (1503, '湖南工商职业学院', 'hunagongshangzhiyexueyuan', 'hngszyxy', 0, '43040000', 1503),
 (1504, '中山大学', 'zhongshandaxue', 'zsdx', 0, '44010000', 1504),
 (1505, '华南理工大学', 'huanaligongdaxue', 'hnlgdx', 0, '44010000', 1505),
 (1506, '暨南大学', 'jinadaxue', 'jndx', 0, '44010000', 1506),
 (1507, '汕头大学', 'shantoudaxue', 'stdx', 0, '44050000', 1507),
 (1508, '深圳大学', 'shenzhendaxue', 'szdx', 0, '44030000', 1508),
 (1509, '五邑大学', 'wuyidaxue', 'wydx', 0, '44070000', 1509),
 (1510, '广东工业大学', 'guangdonggongyedaxue', 'gdgydx', 0, '44010000', 1510),
 (1511, '华南农业大学', 'huananongyedaxue', 'hnnydx', 0, '44010000', 1511),
 (1512, '广东海洋大学', 'guangdonghaiyangdaxue', 'gdhydx', 0, '44080000', 1512),
 (1513, '广州中医药大学', 'guangzhouzhongyiyaodaxue', 'gzzyydx', 0, '44010000', 1513),
 (1514, '南方医科大学', 'nafangyikedaxue', 'nfykdx', 0, '44010000', 1514),
 (1515, '华南师范大学', 'huanashifandaxue', 'hnsfdx', 0, '44010000', 1515),
 (1516, '广东外语外贸大学', 'guangdongwaiyuwaimaodaxue', 'gdwywmdx', 0, '44010000', 1516),
 (1517, '广州大学', 'guangzhoudaxue', 'gzdx', 0, '44010000', 1517),
 (1518, '北京师范大学-香港浸会大学联合国际学院', 'beijingshifandaxue-xianggangjinhuidaxuelianheguojixueyuan', 'bjsfdx-xgjhdxlhgjxy', 0, '44010000', 1518),
 (1519, '肇庆学院', 'zhaoqingxueyuan', 'zqxy', 0, '44120000', 1519),
 (1520, '广东石油化工学院', 'guangdongshiyouhuagongxueyuan', 'gdsyhgxy', 0, '44090000', 1520),
 (1521, '东莞理工学院', 'dongguanligongxueyuan', 'dglgxy', 0, '44190000', 1521),
 (1522, '广东科技学院', 'guangdongkejixueyuan', 'gdkjxy', 0, '44190000', 1522),
 (1523, '仲恺农业工程学院', 'zhongkainongyegongchengxueyuan', 'zknygcxy', 0, '44010000', 1523),
 (1524, '广东医学院', 'guangdongyixueyuan', 'gdyxy', 0, '44080000', 1524),
 (1525, '广州医学院', 'guangzhouyixueyuan', 'gzyxy', 0, '44010000', 1525),
 (1526, '广东药学院', 'guangdongyaoxueyuan', 'gdyxy', 0, '44010000', 1526),
 (1527, '韶关学院', 'shaoguanxueyuan', 'sgxy', 0, '44020000', 1527),
 (1528, '嘉应学院', 'jiayingxueyuan', 'jyxy', 0, '44140000', 1528),
 (1529, '惠州学院', 'huizhouxueyuan', 'hzxy', 0, '44130000', 1529),
 (1530, '湛江师范学院', 'zhanjiangshifanxueyuan', 'zjsfxy', 0, '44080000', 1530),
 (1531, '韩山师范学院', 'hanshanshifanxueyuan', 'hssfxy', 0, '44510000', 1531),
 (1532, '广东第二师范学院', 'guangdongdieshifanxueyuan', 'gddesfxy', 0, '44010000', 1532),
 (1533, '广东金融学院', 'guangdongjinrongxueyuan', 'gdjrxy', 0, '44010000', 1533),
 (1534, '广东商学院', 'guangdongshangxueyuan', 'gdsxy', 0, '44010000', 1534),
 (1535, '广东警官学院', 'guangdongjingguanxueyuan', 'gdjgxy', 0, '44010000', 1535),
 (1536, '广州体育学院', 'guangzhoutiyuxueyuan', 'gztyxy', 0, '44010000', 1536),
 (1537, '广州美术学院', 'guangzhoumeishuxueyuan', 'gzmsxy', 0, '44010000', 1537),
 (1538, '星海音乐学院', 'xinghaiyinlexueyuan', 'xhylxy', 0, '44010000', 1538),
 (1539, '广东技术师范学院', 'guangdongjishushifanxueyuan', 'gdjssfxy', 0, '44010000', 1539),
 (1540, '佛山科学技术学院', 'fushankexuejishuxueyuan', 'fskxjsxy', 0, '44060000', 1540),
 (1541, '广东培正学院', 'guangdongpeizhengxueyuan', 'gdpzxy', 0, '44010000', 1541),
 (1542, '广东白云学院', 'guangdongbaiyunxueyuan', 'gdbyxy', 0, '44010000', 1542),
 (1543, '广州航海高等专科学校', 'guangzhouhanghaigaodengzhuankexuexiao', 'gzhhgdzkxx', 0, '44010000', 1543),
 (1544, '肇庆医学高等专科学校', 'zhaoqingyixuegaodengzhuankexuexiao', 'zqyxgdzkxx', 0, '44120000', 1544),
 (1545, '民办南华工商学院', 'minbannahuagongshangxueyuan', 'mbnhgsxy', 0, '44010000', 1545),
 (1546, '私立华联学院', 'silihualianxueyuan', 'slhlxy', 0, '44010000', 1546),
 (1547, '广州民航职业技术学院', 'guangzhouminhangzhiyejishuxueyuan', 'gzmhzyjsxy', 0, '44010000', 1547),
 (1548, '广东食品药品职业学院', 'guangdongshipinyaopinzhiyexueyuan', 'gdspypzyxy', 0, '44010000', 1548),
 (1549, '顺德职业技术学院', 'shundezhiyejishuxueyuan', 'sdzyjsxy', 0, '44060000', 1549),
 (1550, '广东松山职业技术学院', 'guangdongsongshanzhiyejishuxueyuan', 'gdsszyjsxy', 0, '44020000', 1550),
 (1551, '潮汕职业技术学院', 'chaoshanzhiyejishuxueyuan', 'cszyjsxy', 0, '44520000', 1551),
 (1552, '广东新安职业技术学院', 'guangdongxinanzhiyejishuxueyuan', 'gdxazyjsxy', 0, '44030000', 1552),
 (1553, '广东农工商职业技术学院', 'guangdongnonggongshangzhiyejishuxueyuan', 'gdngszyjsxy', 0, '44010000', 1553),
 (1554, '广东交通职业技术学院', 'guangdongjiaotongzhiyejishuxueyuan', 'gdjtzyjsxy', 0, '44010000', 1554),
 (1555, '佛山职业技术学院', 'fushanzhiyejishuxueyuan', 'fszyjsxy', 0, '44060000', 1555),
 (1556, '广东轻工职业技术学院', 'guangdongqinggongzhiyejishuxueyuan', 'gdqgzyjsxy', 0, '44010000', 1556),
 (1557, '广东水利电力职业技术学院', 'guangdongshuilidianlizhiyejishuxueyuan', 'gdsldlzyjsxy', 0, '44010000', 1557),
 (1558, '深圳职业技术学院', 'shenzhenzhiyejishuxueyuan', 'szzyjsxy', 0, '44030000', 1558),
 (1559, '江门职业技术学院', 'jiangmenzhiyejishuxueyuan', 'jmzyjsxy', 0, '44070000', 1559),
 (1560, '广州城建职业学院', 'guangzhouchengjianzhiyexueyuan', 'gzcjzyxy', 0, '44010000', 1560),
 (1561, '湛江现代科技职业学院', 'zhanjiangxiandaikejizhiyexueyuan', 'zjxdkjzyxy', 0, '44080000', 1561),
 (1562, '广州松田职业学院', 'guangzhousongtianzhiyexueyuan', 'gzstzyxy', 0, '44010000', 1562),
 (1563, '广州珠江职业技术学院', 'guangzhouzhujiangzhiyejishuxueyuan', 'gzzjzyjsxy', 0, '44010000', 1563),
 (1564, '广东科贸职业学院', 'guangdongkemaozhiyexueyuan', 'gdkmzyxy', 0, '44010000', 1564),
 (1565, '广州科技贸易职业学院', 'guangzhoukejimaoyizhiyexueyuan', 'gzkjmyzyxy', 0, '44010000', 1565),
 (1566, '中山职业技术学院', 'zhongshanzhiyejishuxueyuan', 'zszyjsxy', 0, '44200000', 1566),
 (1567, '广东文艺职业学院', 'guangdongwenyizhiyexueyuan', 'gdwyzyxy', 0, '44010000', 1567),
 (1568, '中山火炬职业技术学院', 'zhongshanhuojuzhiyejishuxueyuan', 'zshjzyjsxy', 0, '44200000', 1568),
 (1569, '茂名职业技术学院', 'maomingzhiyejishuxueyuan', 'mmzyjsxy', 0, '44090000', 1569),
 (1570, '广州南洋理工职业学院', 'guangzhounayangligongzhiyexueyuan', 'gznylgzyxy', 0, '44010000', 1570),
 (1571, '广东理工职业学院', 'guangdongligongzhiyexueyuan', 'gdlgzyxy', 0, '44010000', 1571),
 (1572, '广州工商职业技术学院', 'guangzhougongshangzhiyejishuxueyuan', 'gzgszyjsxy', 0, '44010000', 1572),
 (1573, '广州铁路职业技术学院', 'guangzhoutieluzhiyejishuxueyuan', 'gztlzyjsxy', 0, '44010000', 1573),
 (1574, '肇庆工商职业技术学院', 'zhaoqinggongshangzhiyejishuxueyuan', 'zqgszyjsxy', 0, '44120000', 1574),
 (1575, '惠州经济职业技术学院', 'huizhoujingjizhiyejishuxueyuan', 'hzjjzyjsxy', 0, '44130000', 1575),
 (1576, '珠海城市职业技术学院', 'zhuhaichengshizhiyejishuxueyuan', 'zhcszyjsxy', 0, '44040000', 1576),
 (1577, '广州工程技术职业学院', 'guangzhougongchengjishuzhiyexueyuan', 'gzgcjszyxy', 0, '44010000', 1577),
 (1578, '广州体育职业技术学院', 'guangzhoutiyuzhiyejishuxueyuan', 'gztyzyjsxy', 0, '44010000', 1578),
 (1579, '广东亚视演艺职业学院', 'guangdongyashiyanyizhiyexueyuan', 'gdysyyzyxy', 0, '44190000', 1579),
 (1580, '广州番禺职业技术学院', 'guangzhoufanyuzhiyejishuxueyuan', 'gzfyzyjsxy', 0, '44010000', 1580),
 (1581, '广东体育职业技术学院', 'guangdongtiyuzhiyejishuxueyuan', 'gdtyzyjsxy', 0, '44010000', 1581),
 (1582, '广东行政职业学院', 'guangdongxingzhengzhiyexueyuan', 'gdxzzyxy', 0, '44010000', 1582),
 (1583, '广东科学技术职业学院', 'guangdongkexuejishuzhiyexueyuan', 'gdkxjszyxy', 0, '44010000', 1583),
 (1584, '珠海艺术职业学院', 'zhuhaiyishuzhiyexueyuan', 'zhyszyxy', 0, '44040000', 1584),
 (1585, '南海东软信息技术职业学院', 'nahaidongruanxinxijishuzhiyexueyuan', 'nhdrxxjszyxy', 0, '44060500', 1585),
 (1586, '广州康大职业技术学院', 'guangzhoukangdazhiyejishuxueyuan', 'gzkdzyjsxy', 0, '44010000', 1586),
 (1587, '广东工贸职业技术学院', 'guangdonggongmaozhiyejishuxueyuan', 'gdgmzyjsxy', 0, '44010000', 1587),
 (1588, '广州华立科技职业学院', 'guangzhouhualikejizhiyexueyuan', 'gzhlkjzyxy', 0, '44010000', 1588),
 (1589, '深圳信息职业技术学院', 'shenzhenxinxizhiyejishuxueyuan', 'szxxzyjsxy', 0, '44030000', 1589),
 (1590, '广州现代信息工程职业技术学院', 'guangzhouxiandaixinxigongchengzhiyejishuxueyuan', 'gzxdxxgczyjsxy', 0, '44010000', 1590),
 (1591, '清远职业技术学院', 'qingyuanzhiyejishuxueyuan', 'qyzyjsxy', 0, '44180000', 1591),
 (1592, '汕头职业技术学院', 'shantouzhiyejishuxueyuan', 'stzyjsxy', 0, '44050000', 1592),
 (1593, '广东邮电职业技术学院', 'guangdongyoudianzhiyejishuxueyuan', 'gdydzyjsxy', 0, '44010000', 1593),
 (1594, '揭阳职业技术学院', 'jieyangzhiyejishuxueyuan', 'jyzyjsxy', 0, '44520000', 1594),
 (1595, '广州涉外经济职业技术学院', 'guangzhoushewaijingjizhiyejishuxueyuan', 'gzswjjzyjsxy', 0, '44010000', 1595),
 (1596, '广州华南商贸职业学院', 'guangzhouhuanashangmaozhiyexueyuan', 'gzhnsmzyxy', 0, '44010000', 1596),
 (1597, '广州科技职业技术学院', 'guangzhoukejizhiyejishuxueyuan', 'gzkjzyjsxy', 0, '44010000', 1597),
 (1598, '广州城市职业学院', 'guangzhouchengshizhiyexueyuan', 'gzcszyxy', 0, '44010000', 1598),
 (1599, '广东工程职业技术学院', 'guangdonggongchengzhiyejishuxueyuan', 'gdgczyjsxy', 0, '44010000', 1599),
 (1600, '广东司法警官职业学院', 'guangdongsifajingguanzhiyexueyuan', 'gdsfjgzyxy', 0, '44010000', 1600),
 (1601, '广东女子职业技术学院', 'guangdongnuzizhiyejishuxueyuan', 'gdnzzyjsxy', 0, '44010000', 1601),
 (1602, '肇庆科技职业技术学院', 'zhaoqingkejizhiyejishuxueyuan', 'zqkjzyjsxy', 0, '44120000', 1602),
 (1603, '广东财经职业学院', 'guangdongcaijingzhiyexueyuan', 'gdcjzyxy', 0, '44010000', 1603),
 (1604, '广东省外语艺术职业学院', 'guangdongshengwaiyuyishuzhiyexueyuan', 'gdswyyszyxy', 0, '44010000', 1604),
 (1605, '广东纺织职业技术学院', 'guangdongfangzhizhiyejishuxueyuan', 'gdfzzyjsxy', 0, '44060000', 1605),
 (1606, '罗定职业技术学院', 'luodingzhiyejishuxueyuan', 'ldzyjsxy', 0, '44538100', 1606),
 (1607, '阳江职业技术学院', 'yangjiangzhiyejishuxueyuan', 'yjzyjsxy', 0, '44170000', 1607),
 (1608, '河源职业技术学院', 'heyuanzhiyejishuxueyuan', 'hyzyjsxy', 0, '44160000', 1608),
 (1609, '广东岭南职业技术学院', 'guangdonglingnazhiyejishuxueyuan', 'gdlnzyjsxy', 0, '44010000', 1609),
 (1610, '广东建设职业技术学院', 'guangdongjianshezhiyejishuxueyuan', 'gdjszyjsxy', 0, '44010000', 1610),
 (1611, '广东机电职业技术学院', 'guangdongjidianzhiyejishuxueyuan', 'gdjdzyjsxy', 0, '44010000', 1611),
 (1612, '广东青年职业学院', 'guangdongqingnianzhiyexueyuan', 'gdqnzyxy', 0, '44010000', 1612),
 (1613, '广州东华职业学院', 'guangzhoudonghuazhiyexueyuan', 'gzdhzyxy', 0, '44010000', 1613),
 (1614, '广东创新科技职业学院', 'guangdongchuangxinkejizhiyexueyuan', 'gdcxkjzyxy', 0, '44190000', 1614),
 (1615, '汕尾职业技术学院', 'shanweizhiyejishuxueyuan', 'swzyjsxy', 0, '44150000', 1615),
 (1616, '东莞职业技术学院', 'dongguanzhiyejishuxueyuan', 'dgzyjsxy', 0, '44190000', 1616),
 (1617, '广东环境保护工程职业学院', 'guangdonghuanjingbaohugongchengzhiyexueyuan', 'gdhjbhgczyxy', 0, '44060000', 1617),
 (1618, '广州华夏职业学院', 'guangzhouhuaxiazhiyexueyuan', 'gzhxzyxy', 0, '44010000', 1618),
 (1619, '广东江门艺华旅游职业学院', 'guangdongjiangmenyihualuyouzhiyexueyuan', 'gdjmyhlyzyxy', 0, '44070000', 1619),
 (1620, '广州华商职业学院', 'guangzhouhuashangzhiyexueyuan', 'gzhszyxy', 0, '44010000', 1620),
 (1621, '广西大学', 'guangxidaxue', 'gxdx', 0, '45010000', 1621),
 (1622, '桂林电子科技大学', 'guilindianzikejidaxue', 'gldzkjdx', 0, '45030000', 1622),
 (1623, '桂林理工大学', 'guilinligongdaxue', 'gllgdx', 0, '45030000', 1623),
 (1624, '广西医科大学', 'guangxiyikedaxue', 'gxykdx', 0, '45010000', 1624),
 (1625, '广西师范大学', 'guangxishifandaxue', 'gxsfdx', 0, '45030000', 1625),
 (1626, '广西民族大学', 'guangximinzudaxue', 'gxmzdx', 0, '45010000', 1626),
 (1627, '广西工学院', 'guangxigongxueyuan', 'gxgxy', 0, '45020000', 1627),
 (1628, '广西中医学院', 'guangxizhongyixueyuan', 'gxzyxy', 0, '45010000', 1628),
 (1629, '桂林医学院', 'guilinyixueyuan', 'glyxy', 0, '45030000', 1629),
 (1630, '右江民族医学院', 'youjiangminzuyixueyuan', 'yjmzyxy', 0, '45100000', 1630),
 (1631, '广西师范学院', 'guangxishifanxueyuan', 'gxsfxy', 0, '45010000', 1631),
 (1632, '广西民族师范学院', 'guangximinzushifanxueyuan', 'gxmzsfxy', 0, '45142300', 1632),
 (1633, '玉林师范学院', 'yulinshifanxueyuan', 'ylsfxy', 0, '45090000', 1633),
 (1634, '河池学院', 'hechixueyuan', 'hcxy', 0, '45128100', 1634),
 (1635, '广西外国语学院', 'guangxiwaiguoyuxueyuan', 'gxwgyxy', 0, '45010000', 1635),
 (1636, '广西财经学院', 'guangxicaijingxueyuan', 'gxcjxy', 0, '45010000', 1636),
 (1637, '广西艺术学院', 'guangxiyishuxueyuan', 'gxysxy', 0, '45010000', 1637),
 (1638, '百色学院', 'baisexueyuan', 'bsxy', 0, '45100000', 1638),
 (1639, '贺州学院', 'hezhouxueyuan', 'hzxy', 0, '45110000', 1639),
 (1640, '钦州学院', 'qinzhouxueyuan', 'qzxy', 0, '45070000', 1640),
 (1641, '梧州学院', 'wuzhouxueyuan', 'wzxy', 0, '45040000', 1641),
 (1642, '桂林航天工业高等专科学校', 'guilinhangtiangongyegaodengzhuankexuexiao', 'glhtgygdzkxx', 0, '45030000', 1642),
 (1643, '柳州医学高等专科学校', 'liuzhouyixuegaodengzhuankexuexiao', 'lzyxgdzkxx', 0, '45020000', 1643),
 (1644, '柳州师范高等专科学校', 'liuzhoushifangaodengzhuankexuexiao', 'lzsfgdzkxx', 0, '45020000', 1644),
 (1645, '桂林师范高等专科学校', 'guilinshifangaodengzhuankexuexiao', 'glsfgdzkxx', 0, '45030000', 1645),
 (1646, '广西幼儿师范高等专科学校', 'guangxiyoueshifangaodengzhuankexuexiao', 'gxyesfgdzkxx', 0, '45010000', 1646),
 (1647, '桂林旅游高等专科学校', 'guilinluyougaodengzhuankexuexiao', 'gllygdzkxx', 0, '45030000', 1647),
 (1648, '广西警官高等专科学校', 'guangxijingguangaodengzhuankexuexiao', 'gxjggdzkxx', 0, '45010000', 1648),
 (1649, '广西体育高等专科学校', 'guangxitiyugaodengzhuankexuexiao', 'gxtygdzkxx', 0, '45010000', 1649),
 (1650, '广西科技职业学院', 'guangxikejizhiyexueyuan', 'gxkjzyxy', 0, '45142100', 1650),
 (1651, '广西卫生职业技术学院', 'guangxiweishengzhiyejishuxueyuan', 'gxwszyjsxy', 0, '45010000', 1651),
 (1652, '柳州职业技术学院', 'liuzhouzhiyejishuxueyuan', 'lzzyjsxy', 0, '45020000', 1652),
 (1653, '广西职业技术学院', 'guangxizhiyejishuxueyuan', 'gxzyjsxy', 0, '45010000', 1653),
 (1654, '南宁职业技术学院', 'naningzhiyejishuxueyuan', 'nnzyjsxy', 0, '45010000', 1654),
 (1655, '广西机电职业技术学院', 'guangxijidianzhiyejishuxueyuan', 'gxjdzyjsxy', 0, '45010000', 1655),
 (1656, '桂林山水职业学院', 'guilinshanshuizhiyexueyuan', 'glsszyxy', 0, '45030000', 1656),
 (1657, '广西电力职业技术学院', 'guangxidianlizhiyejishuxueyuan', 'gxdlzyjsxy', 0, '45010000', 1657),
 (1658, '广西建设职业技术学院', 'guangxijianshezhiyejishuxueyuan', 'gxjszyjsxy', 0, '45010000', 1658),
 (1659, '广西水利电力职业技术学院', 'guangxishuilidianlizhiyejishuxueyuan', 'gxsldlzyjsxy', 0, '45010000', 1659),
 (1660, '广西交通职业技术学院', 'guangxijiaotongzhiyejishuxueyuan', 'gxjtzyjsxy', 0, '45010000', 1660),
 (1661, '广西生态工程职业技术学院', 'guangxishengtaigongchengzhiyejishuxueyuan', 'gxstgczyjsxy', 0, '45020000', 1661),
 (1662, '广西演艺职业学院', 'guangxiyanyizhiyexueyuan', 'gxyyzyxy', 0, '45010000', 1662),
 (1663, '广西经济职业学院', 'guangxijingjizhiyexueyuan', 'gxjjzyxy', 0, '45010000', 1663),
 (1664, '广西国际商务职业技术学院', 'guangxiguojishangwuzhiyejishuxueyuan', 'gxgjswzyjsxy', 0, '45010000', 1664),
 (1665, '广西农业职业技术学院', 'guangxinongyezhiyejishuxueyuan', 'gxnyzyjsxy', 0, '45010000', 1665),
 (1666, '北海职业学院', 'beihaizhiyexueyuan', 'bhzyxy', 0, '45050000', 1666),
 (1667, '百色职业学院', 'baisezhiyexueyuan', 'bszyxy', 0, '45100000', 1667),
 (1668, '柳州城市职业学院', 'liuzhouchengshizhiyexueyuan', 'lzcszyxy', 0, '45020000', 1668),
 (1669, '广西英华国际职业学院', 'guangxiyinghuaguojizhiyexueyuan', 'gxyhgjzyxy', 0, '45070000', 1669),
 (1670, '广西城市职业学院', 'guangxichengshizhiyexueyuan', 'gxcszyxy', 0, '45010000', 1670),
 (1671, '广西工程职业学院', 'guangxigongchengzhiyexueyuan', 'gxgczyxy', 0, '45100000', 1671),
 (1672, '北海艺术设计职业学院', 'beihaiyishushejizhiyexueyuan', 'bhyssjzyxy', 0, '45050000', 1672),
 (1673, '广西工商职业技术学院', 'guangxigongshangzhiyejishuxueyuan', 'gxgszyjsxy', 0, '45010000', 1673),
 (1674, '梧州职业学院', 'wuzhouzhiyexueyuan', 'wzzyxy', 0, '45040000', 1674),
 (1675, '贵港职业学院', 'guigangzhiyexueyuan', 'ggzyxy', 0, '45080000', 1675),
 (1676, '广西现代职业技术学院', 'guangxixiandaizhiyejishuxueyuan', 'gxxdzyjsxy', 0, '45120000', 1676),
 (1677, '广西经贸职业技术学院', 'guangxijingmaozhiyejishuxueyuan', 'gxjmzyjsxy', 0, '45010000', 1677),
 (1678, '广西工业职业技术学院', 'guangxigongyezhiyejishuxueyuan', 'gxgyzyjsxy', 0, '45010000', 1678),
 (1679, '广西理工职业技术学院', 'guangxiligongzhiyejishuxueyuan', 'gxlgzyjsxy', 0, '45140000', 1679),
 (1680, '柳州铁道职业技术学院', 'liuzhoutiedaozhiyejishuxueyuan', 'lztdzyjsxy', 0, '45020000', 1680),
 (1681, '邕江大学', 'yongjiangdaxue', 'yjdx', 0, '45010000', 1681),
 (1682, '海南大学', 'hainadaxue', 'hndx', 0, '46010000', 1682),
 (1683, '海南师范大学', 'hainashifandaxue', 'hnsfdx', 0, '46010000', 1683),
 (1684, '海口经济学院', 'haikoujingjixueyuan', 'hkjjxy', 0, '46010000', 1684),
 (1685, '海南医学院', 'hainayixueyuan', 'hnyxy', 0, '46010000', 1685),
 (1686, '琼州学院', 'qiongzhouxueyuan', 'qzxy', 0, '46900100', 1686),
 (1687, '琼台师范高等专科学校', 'qiongtaishifangaodengzhuankexuexiao', 'qtsfgdzkxx', 0, '46010000', 1687),
 (1688, '三亚城市职业学院', 'sanyachengshizhiyexueyuan', 'sycszyxy', 0, '46020000', 1688),
 (1689, '海南职业技术学院', 'hainazhiyejishuxueyuan', 'hnzyjsxy', 0, '46010000', 1689),
 (1690, '三亚航空旅游职业学院', 'sanyahangkongluyouzhiyexueyuan', 'syhklyzyxy', 0, '46020000', 1690),
 (1691, '海南科技职业学院', 'hainakejizhiyexueyuan', 'hnkjzyxy', 0, '46010000', 1691),
 (1692, '海南工商职业学院', 'hainagongshangzhiyexueyuan', 'hngszyxy', 0, '46010000', 1692),
 (1693, '海南经贸职业技术学院', 'hainajingmaozhiyejishuxueyuan', 'hnjmzyjsxy', 0, '46010000', 1693),
 (1694, '海南软件职业技术学院', 'hainaruanjianzhiyejishuxueyuan', 'hnrjzyjsxy', 0, '46900200', 1694),
 (1695, '三亚理工职业学院', 'sanyaligongzhiyexueyuan', 'sylgzyxy', 0, '46020000', 1695),
 (1696, '海南政法职业学院', 'hainazhengfazhiyexueyuan', 'hnzfzyxy', 0, '46010000', 1696),
 (1697, '海南外国语职业学院', 'hainawaiguoyuzhiyexueyuan', 'hnwgyzyxy', 0, '46900500', 1697),
 (1698, '重庆大学', 'zhongqingdaxue', 'zqdx', 0, '50000000', 1698),
 (1699, '西南大学', 'xinadaxue', 'xndx', 0, '50000000', 1699),
 (1700, '重庆交通大学', 'zhongqingjiaotongdaxue', 'zqjtdx', 0, '50000000', 1700),
 (1701, '重庆邮电大学', 'zhongqingyoudiandaxue', 'zqyddx', 0, '50000000', 1701),
 (1702, '重庆理工大学', 'zhongqingligongdaxue', 'zqlgdx', 0, '50000000', 1702),
 (1703, '重庆医科大学', 'zhongqingyikedaxue', 'zqykdx', 0, '50000000', 1703),
 (1704, '重庆师范大学', 'zhongqingshifandaxue', 'zqsfdx', 0, '50000000', 1704),
 (1705, '重庆工商大学', 'zhongqinggongshangdaxue', 'zqgsdx', 0, '50000000', 1705),
 (1706, '西南政法大学', 'xinazhengfadaxue', 'xnzfdx', 0, '50000000', 1706),
 (1707, '重庆科技学院', 'zhongqingkejixueyuan', 'zqkjxy', 0, '50000000', 1707),
 (1708, '长江师范学院', 'changjiangshifanxueyuan', 'cjsfxy', 0, '50000000', 1708),
 (1709, '四川外语学院', 'sichuanwaiyuxueyuan', 'scwyxy', 0, '50000000', 1709),
 (1710, '四川美术学院', 'sichuanmeishuxueyuan', 'scmsxy', 0, '50000000', 1710),
 (1711, '重庆三峡学院', 'zhongqingsanxiaxueyuan', 'zqsxxy', 0, '50000000', 1711),
 (1712, '重庆文理学院', 'zhongqingwenlixueyuan', 'zqwlxy', 0, '50000000', 1712),
 (1713, '重庆电力高等专科学校', 'zhongqingdianligaodengzhuankexuexiao', 'zqdlgdzkxx', 0, '50000000', 1713),
 (1714, '重庆医药高等专科学校', 'zhongqingyiyaogaodengzhuankexuexiao', 'zqyygdzkxx', 0, '50000000', 1714),
 (1715, '重庆三峡医药高等专科学校', 'zhongqingsanxiayiyaogaodengzhuankexuexiao', 'zqsxyygdzkxx', 0, '50000000', 1715),
 (1716, '重庆化工职业学院', 'zhongqinghuagongzhiyexueyuan', 'zqhgzyxy', 0, '50000000', 1716),
 (1717, '重庆工业职业技术学院', 'zhongqinggongyezhiyejishuxueyuan', 'zqgyzyjsxy', 0, '50000000', 1717),
 (1718, '重庆电讯职业学院', 'zhongqingdianxunzhiyexueyuan', 'zqdxzyxy', 0, '50000000', 1718),
 (1719, '重庆传媒职业学院', 'zhongqingchuanmeizhiyexueyuan', 'zqcmzyxy', 0, '50000000', 1719),
 (1720, '重庆工程职业技术学院', 'zhongqinggongchengzhiyejishuxueyuan', 'zqgczyjsxy', 0, '50000000', 1720),
 (1721, '重庆建筑工程职业学院', 'zhongqingjianzhugongchengzhiyexueyuan', 'zqjzgczyxy', 0, '50000000', 1721),
 (1722, '重庆能源职业学院', 'zhongqingnengyuanzhiyexueyuan', 'zqnyzyxy', 0, '50000000', 1722),
 (1723, '重庆科创职业学院', 'zhongqingkechuangzhiyexueyuan', 'zqkczyxy', 0, '50000000', 1723),
 (1724, '重庆民生职业技术学院', 'zhongqingminshengzhiyejishuxueyuan', 'zqmszyjsxy', 0, '50000000', 1724),
 (1725, '重庆正大软件职业技术学院', 'zhongqingzhengdaruanjianzhiyejishuxueyuan', 'zqzdrjzyjsxy', 0, '50000000', 1725),
 (1726, '重庆航天职业技术学院', 'zhongqinghangtianzhiyejishuxueyuan', 'zqhtzyjsxy', 0, '50000000', 1726),
 (1727, '重庆财经职业学院', 'zhongqingcaijingzhiyexueyuan', 'zqcjzyxy', 0, '50000000', 1727),
 (1728, '重庆经贸职业学院', 'zhongqingjingmaozhiyexueyuan', 'zqjmzyxy', 0, '50000000', 1728),
 (1729, '重庆商务职业学院', 'zhongqingshangwuzhiyexueyuan', 'zqswzyxy', 0, '50000000', 1729),
 (1730, '重庆三峡职业学院', 'zhongqingsanxiazhiyexueyuan', 'zqsxzyxy', 0, '50000000', 1730),
 (1731, '重庆信息技术职业学院', 'zhongqingxinxijishuzhiyexueyuan', 'zqxxjszyxy', 0, '50000000', 1731),
 (1732, '重庆机电职业技术学院', 'zhongqingjidianzhiyejishuxueyuan', 'zqjdzyjsxy', 0, '50000000', 1732),
 (1733, '重庆城市职业学院', 'zhongqingchengshizhiyexueyuan', 'zqcszyxy', 0, '50000000', 1733),
 (1734, '重庆水利电力职业技术学院', 'zhongqingshuilidianlizhiyejishuxueyuan', 'zqsldlzyjsxy', 0, '50000000', 1734),
 (1735, '重庆电子工程职业学院', 'zhongqingdianzigongchengzhiyexueyuan', 'zqdzgczyxy', 0, '50000000', 1735),
 (1736, '重庆城市管理职业学院', 'zhongqingchengshiguanlizhiyexueyuan', 'zqcsglzyxy', 0, '50000000', 1736),
 (1737, '重庆工贸职业技术学院', 'zhongqinggongmaozhiyejishuxueyuan', 'zqgmzyjsxy', 0, '50000000', 1737),
 (1738, '重庆海联职业技术学院', 'zhongqinghailianzhiyejishuxueyuan', 'zqhlzyjsxy', 0, '50000000', 1738),
 (1739, '重庆电信职业学院', 'zhongqingdianxinzhiyexueyuan', 'zqdxzyxy', 0, '50000000', 1739),
 (1740, '重庆警官职业学院', 'zhongqingjingguanzhiyexueyuan', 'zqjgzyxy', 0, '50000000', 1740),
 (1741, '重庆工商职业学院', 'zhongqinggongshangzhiyexueyuan', 'zqgszyxy', 0, '50000000', 1741),
 (1742, '重庆轻工职业学院', 'zhongqingqinggongzhiyexueyuan', 'zqqgzyxy', 0, '50000000', 1742),
 (1743, '重庆安全技术职业学院', 'zhongqinganquanjishuzhiyexueyuan', 'zqaqjszyxy', 0, '50000000', 1743),
 (1744, '重庆青年职业技术学院', 'zhongqingqingnianzhiyejishuxueyuan', 'zqqnzyjsxy', 0, '50000000', 1744),
 (1745, '重庆公共运输职业学院', 'zhongqinggonggongyunshuzhiyexueyuan', 'zqggyszyxy', 0, '50000000', 1745),
 (1746, '重庆艺术工程职业学院', 'zhongqingyishugongchengzhiyexueyuan', 'zqysgczyxy', 0, '50000000', 1746),
 (1747, '重庆房地产职业学院', 'zhongqingfangdichanzhiyexueyuan', 'zqfdczyxy', 0, '50000000', 1747),
 (1748, '重庆交通职业学院', 'zhongqingjiaotongzhiyexueyuan', 'zqjtzyxy', 0, '50000000', 1748),
 (1749, '重庆旅游职业学院', 'zhongqingluyouzhiyexueyuan', 'zqlyzyxy', 0, '50000000', 1749),
 (1750, '四川大学', 'sichuandaxue', 'scdx', 0, '51010000', 1750),
 (1751, '西南交通大学', 'xinajiaotongdaxue', 'xnjtdx', 0, '51010000', 1751),
 (1752, '电子科技大学', 'dianzikejidaxue', 'dzkjdx', 0, '51010000', 1752),
 (1753, '西南财经大学', 'xinacaijingdaxue', 'xncjdx', 0, '51010000', 1753),
 (1754, '西南民族大学', 'xinaminzudaxue', 'xnmzdx', 0, '51010000', 1754),
 (1755, '成都理工大学', 'chengduligongdaxue', 'cdlgdx', 0, '51010000', 1755),
 (1756, '西华大学', 'xihuadaxue', 'xhdx', 0, '51010000', 1756),
 (1757, '西南科技大学', 'xinakejidaxue', 'xnkjdx', 0, '51070000', 1757),
 (1758, '四川农业大学', 'sichuannongyedaxue', 'scnydx', 0, '51180000', 1758),
 (1759, '成都中医药大学', 'chengduzhongyiyaodaxue', 'cdzyydx', 0, '51010000', 1759),
 (1760, '四川师范大学', 'sichuanshifandaxue', 'scsfdx', 0, '51010000', 1760),
 (1761, '西华师范大学', 'xihuashifandaxue', 'xhsfdx', 0, '51130000', 1761),
 (1762, '中国民用航空飞行学院', 'zhongguominyonghangkongfeixingxueyuan', 'zgmyhkfxxy', 0, '51068100', 1762),
 (1763, '西南石油大学', 'xinashiyoudaxue', 'xnsydx', 0, '51130000', 1763),
 (1764, '四川理工学院', 'sichuanligongxueyuan', 'sclgxy', 0, '51030000', 1764),
 (1765, '成都信息工程学院', 'chengduxinxigongchengxueyuan', 'cdxxgcxy', 0, '51010000', 1765),
 (1766, '成都东软学院', 'chengdudongruanxueyuan', 'cddrxy', 0, '51010000', 1766),
 (1767, '泸州医学院', 'luzhouyixueyuan', 'lzyxy', 0, '51050000', 1767),
 (1768, '川北医学院', 'chuanbeiyixueyuan', 'cbyxy', 0, '51130000', 1768),
 (1769, '成都医学院', 'chengduyixueyuan', 'cdyxy', 0, '51010000', 1769),
 (1770, '乐山师范学院', 'leshanshifanxueyuan', 'lssfxy', 0, '51110000', 1770),
 (1771, '四川文理学院', 'sichuanwenlixueyuan', 'scwlxy', 0, '51170000', 1771),
 (1772, '内江师范学院', 'neijiangshifanxueyuan', 'njsfxy', 0, '51100000', 1772),
 (1773, '四川警察学院', 'sichuanjingchaxueyuan', 'scjcxy', 0, '51050000', 1773),
 (1774, '成都体育学院', 'chengdutiyuxueyuan', 'cdtyxy', 0, '51010000', 1774),
 (1775, '四川音乐学院', 'sichuanyinlexueyuan', 'scylxy', 0, '51010000', 1775),
 (1776, '四川民族学院', 'sichuanminzuxueyuan', 'scmzxy', 0, '51330000', 1776),
 (1777, '成都学院', 'chengduxueyuan', 'cdxy', 0, '51010000', 1777),
 (1778, '绵阳师范学院', 'mianyangshifanxueyuan', 'mysfxy', 0, '51070000', 1778),
 (1779, '西昌学院', 'xichangxueyuan', 'xcxy', 0, '51340100', 1779),
 (1780, '宜宾学院', 'yibinxueyuan', 'ybxy', 0, '51150000', 1780),
 (1781, '攀枝花学院', 'panzhihuaxueyuan', 'pzhxy', 0, '51040000', 1781),
 (1782, '成都纺织高等专科学校', 'chengdufangzhigaodengzhuankexuexiao', 'cdfzgdzkxx', 0, '51010000', 1782),
 (1783, '四川烹饪高等专科学校', 'sichuanpengrengaodengzhuankexuexiao', 'scprgdzkxx', 0, '51010000', 1783),
 (1784, '成都电子机械高等专科学校', 'chengdudianzijixiegaodengzhuankexuexiao', 'cddzjxgdzkxx', 0, '51010000', 1784),
 (1785, '四川中医药高等专科学校', 'sichuanzhongyiyaogaodengzhuankexuexiao', 'sczyygdzkxx', 0, '51070000', 1785),
 (1786, '阿坝师范高等专科学校', 'abashifangaodengzhuankexuexiao', 'absfgdzkxx', 0, '51322100', 1786),
 (1787, '四川幼儿师范高等专科学校', 'sichuanyoueshifangaodengzhuankexuexiao', 'scyesfgdzkxx', 0, '51070000', 1787),
 (1788, '民办四川天一学院', 'minbansichuantianyixueyuan', 'mbsctyxy', 0, '51010000', 1788),
 (1789, '成都航空职业技术学院', 'chengduhangkongzhiyejishuxueyuan', 'cdhkzyjsxy', 0, '51010000', 1789),
 (1790, '四川邮电职业技术学院', 'sichuanyoudianzhiyejishuxueyuan', 'scydzyjsxy', 0, '51010000', 1790),
 (1791, '四川化工职业技术学院', 'sichuanhuagongzhiyejishuxueyuan', 'schgzyjsxy', 0, '51050000', 1791),
 (1792, '达州职业技术学院', 'dazhouzhiyejishuxueyuan', 'dzzyjsxy', 0, '51170000', 1792),
 (1793, '四川航天职业技术学院', 'sichuanhangtianzhiyejishuxueyuan', 'schtzyjsxy', 0, '51010000', 1793),
 (1794, '乐山职业技术学院', 'leshanzhiyejishuxueyuan', 'lszyjsxy', 0, '51110000', 1794),
 (1795, '泸州职业技术学院', 'luzhouzhiyejishuxueyuan', 'lzzyjsxy', 0, '51050000', 1795),
 (1796, '四川警安职业学院', 'sichuanjinganzhiyexueyuan', 'scjazyxy', 0, '51060000', 1796),
 (1797, '四川信息职业技术学院', 'sichuanxinxizhiyejishuxueyuan', 'scxxzyjsxy', 0, '51080000', 1797),
 (1798, '眉山职业技术学院', 'meishanzhiyejishuxueyuan', 'mszyjsxy', 0, '51140000', 1798),
 (1799, '四川长江职业学院', 'sichuanchangjiangzhiyexueyuan', 'sccjzyxy', 0, '51010000', 1799),
 (1800, '成都艺术职业学院', 'chengduyishuzhiyexueyuan', 'cdyszyxy', 0, '51010000', 1800),
 (1801, '广安职业技术学院', 'guanganzhiyejishuxueyuan', 'gazyjsxy', 0, '51160000', 1801),
 (1802, '四川司法警官职业学院', 'sichuansifajingguanzhiyexueyuan', 'scsfjgzyxy', 0, '51060000', 1802),
 (1803, '四川工程职业技术学院', 'sichuangongchengzhiyejishuxueyuan', 'scgczyjsxy', 0, '51060000', 1803),
 (1804, '宜宾职业技术学院', 'yibinzhiyejishuxueyuan', 'ybzyjsxy', 0, '51150000', 1804),
 (1805, '成都农业科技职业学院', 'chengdunongyekejizhiyexueyuan', 'cdnykjzyxy', 0, '51010000', 1805),
 (1806, '四川国际标榜职业学院', 'sichuanguojibiaobangzhiyexueyuan', 'scgjbbzyxy', 0, '51010000', 1806),
 (1807, '四川科技职业学院', 'sichuankejizhiyexueyuan', 'sckjzyxy', 0, '51010000', 1807),
 (1808, '四川托普信息技术职业学院', 'sichuantuopuxinxijishuzhiyexueyuan', 'sctpxxjszyxy', 0, '51010000', 1808),
 (1809, '四川职业技术学院', 'sichuanzhiyejishuxueyuan', 'sczyjsxy', 0, '51090000', 1809),
 (1810, '四川机电职业技术学院', 'sichuanjidianzhiyejishuxueyuan', 'scjdzyjsxy', 0, '51040000', 1810),
 (1811, '四川交通职业技术学院', 'sichuanjiaotongzhiyejishuxueyuan', 'scjtzyjsxy', 0, '51010000', 1811),
 (1812, '四川建筑职业技术学院', 'sichuanjianzhuzhiyejishuxueyuan', 'scjzzyjsxy', 0, '51060000', 1812),
 (1813, '雅安职业技术学院', 'yaanzhiyejishuxueyuan', 'yazyjsxy', 0, '51180000', 1813),
 (1814, '绵阳职业技术学院', 'mianyangzhiyejishuxueyuan', 'myzyjsxy', 0, '51070000', 1814),
 (1815, '四川工商职业技术学院', 'sichuangongshangzhiyejishuxueyuan', 'scgszyjsxy', 0, '51010000', 1815),
 (1816, '四川电力职业技术学院', 'sichuandianlizhiyejishuxueyuan', 'scdlzyjsxy', 0, '51010000', 1816),
 (1817, '四川艺术职业学院', 'sichuanyishuzhiyexueyuan', 'scyszyxy', 0, '51010000', 1817),
 (1818, '南充职业技术学院', 'nachongzhiyejishuxueyuan', 'nczyjsxy', 0, '51130000', 1818),
 (1819, '内江职业技术学院', 'neijiangzhiyejishuxueyuan', 'njzyjsxy', 0, '51100000', 1819),
 (1820, '成都职业技术学院', 'chengduzhiyejishuxueyuan', 'cdzyjsxy', 0, '51010000', 1820),
 (1821, '四川文化传媒职业学院', 'sichuanwenhuachuanmeizhiyexueyuan', 'scwhcmzyxy', 0, '51010000', 1821),
 (1822, '四川管理职业学院', 'sichuanguanlizhiyexueyuan', 'scglzyxy', 0, '51010000', 1822),
 (1823, '四川文化产业职业学院', 'sichuanwenhuachanyezhiyexueyuan', 'scwhcyzyxy', 0, '51010000', 1823),
 (1824, '四川水利职业技术学院', 'sichuanshuilizhiyejishuxueyuan', 'scslzyjsxy', 0, '51010000', 1824),
 (1825, '四川财经职业学院', 'sichuancaijingzhiyexueyuan', 'sccjzyxy', 0, '51010000', 1825),
 (1826, '四川商务职业学院', 'sichuanshangwuzhiyexueyuan', 'scswzyxy', 0, '51010000', 1826),
 (1827, '四川现代职业学院', 'sichuanxiandaizhiyexueyuan', 'scxdzyxy', 0, '51010000', 1827),
 (1828, '四川城市职业学院', 'sichuanchengshizhiyexueyuan', 'sccszyxy', 0, '51010000', 1828),
 (1829, '四川华新现代职业学院', 'sichuanhuaxinxiandaizhiyexueyuan', 'schxxdzyxy', 0, '51010000', 1829),
 (1830, '贵州大学', 'guizhoudaxue', 'gzdx', 0, '52010000', 1830),
 (1831, '贵州师范大学', 'guizhoushifandaxue', 'gzsfdx', 0, '52010000', 1831),
 (1832, '贵阳医学院', 'guiyangyixueyuan', 'gyyxy', 0, '52010000', 1832),
 (1833, '遵义医学院', 'zunyiyixueyuan', 'zyyxy', 0, '52030000', 1833),
 (1834, '贵阳中医学院', 'guiyangzhongyixueyuan', 'gyzyxy', 0, '52010000', 1834),
 (1835, '毕节学院', 'bijiexueyuan', 'bjxy', 0, '52240100', 1835),
 (1836, '遵义师范学院', 'zunyishifanxueyuan', 'zysfxy', 0, '52030000', 1836),
 (1837, '黔南民族师范学院', 'qiannaminzushifanxueyuan', 'qnmzsfxy', 0, '52270100', 1837),
 (1838, '六盘水师范学院', 'liupanshuishifanxueyuan', 'lpssfxy', 0, '52020000', 1838),
 (1839, '兴义民族师范学院', 'xingyiminzushifanxueyuan', 'xymzsfxy', 0, '52230100', 1839),
 (1840, '贵州师范学院', 'guizhoushifanxueyuan', 'gzsfxy', 0, '52010000', 1840),
 (1841, '贵州财经学院', 'guizhoucaijingxueyuan', 'gzcjxy', 0, '52010000', 1841),
 (1842, '贵州民族学院', 'guizhouminzuxueyuan', 'gzmzxy', 0, '52010000', 1842),
 (1843, '安顺学院', 'anshunxueyuan', 'asxy', 0, '52040000', 1843),
 (1844, '铜仁学院', 'tongrenxueyuan', 'trxy', 0, '52220100', 1844),
 (1845, '贵阳学院', 'guiyangxueyuan', 'gyxy', 0, '52010000', 1845),
 (1846, '凯里学院', 'kailixueyuan', 'klxy', 0, '52260100', 1846),
 (1847, '黔南民族医学高等专科学校', 'qiannaminzuyixuegaodengzhuankexuexiao', 'qnmzyxgdzkxx', 0, '52270100', 1847),
 (1848, '遵义医药高等专科学校', 'zunyiyiyaogaodengzhuankexuexiao', 'zyyygdzkxx', 0, '52030000', 1848),
 (1849, '贵州商业高等专科学校', 'guizhoushangyegaodengzhuankexuexiao', 'gzsygdzkxx', 0, '52010000', 1849),
 (1850, '贵州航天职业技术学院', 'guizhouhangtianzhiyejishuxueyuan', 'gzhtzyjsxy', 0, '52030000', 1850),
 (1851, '贵州交通职业技术学院', 'guizhoujiaotongzhiyejishuxueyuan', 'gzjtzyjsxy', 0, '52010000', 1851),
 (1852, '贵州警官职业学院', 'guizhoujingguanzhiyexueyuan', 'gzjgzyxy', 0, '52010000', 1852),
 (1853, '贵州电子信息职业技术学院', 'guizhoudianzixinxizhiyejishuxueyuan', 'gzdzxxzyjsxy', 0, '52260100', 1853),
 (1854, '黔西南民族职业技术学院', 'qianxinaminzuzhiyejishuxueyuan', 'qxnmzzyjsxy', 0, '52230100', 1854),
 (1855, '贵州亚泰职业学院', 'guizhouyataizhiyexueyuan', 'gzytzyxy', 0, '52010000', 1855),
 (1856, '贵州工业职业技术学院', 'guizhougongyezhiyejishuxueyuan', 'gzgyzyjsxy', 0, '52010000', 1856),
 (1857, '遵义职业技术学院', 'zunyizhiyejishuxueyuan', 'zyzyjsxy', 0, '52030000', 1857),
 (1858, '安顺职业技术学院', 'anshunzhiyejishuxueyuan', 'aszyjsxy', 0, '52040000', 1858),
 (1859, '黔南民族职业技术学院', 'qiannaminzuzhiyejishuxueyuan', 'qnmzzyjsxy', 0, '52270100', 1859),
 (1860, '贵州轻工职业技术学院', 'guizhouqinggongzhiyejishuxueyuan', 'gzqgzyjsxy', 0, '52010000', 1860),
 (1861, '贵州职业技术学院', 'guizhouzhiyejishuxueyuan', 'gzzyjsxy', 0, '52010000', 1861),
 (1862, '贵阳职业技术学院', 'guiyangzhiyejishuxueyuan', 'gyzyjsxy', 0, '52010000', 1862),
 (1863, '贵州盛华职业学院', 'guizhoushenghuazhiyexueyuan', 'gzshzyxy', 0, '52270000', 1863),
 (1864, '毕节职业技术学院', 'bijiezhiyejishuxueyuan', 'bjzyjsxy', 0, '52240100', 1864),
 (1865, '贵阳护理职业学院', 'guiyanghulizhiyexueyuan', 'gyhlzyxy', 0, '52010000', 1865),
 (1866, '六盘水职业技术学院', 'liupanshuizhiyejishuxueyuan', 'lpszyjsxy', 0, '52020000', 1866),
 (1867, '铜仁职业技术学院', 'tongrenzhiyejishuxueyuan', 'trzyjsxy', 0, '52220100', 1867),
 (1868, '贵州电力职业技术学院', 'guizhoudianlizhiyejishuxueyuan', 'gzdlzyjsxy', 0, '52010000', 1868),
 (1869, '黔东南民族职业技术学院', 'qiandongnaminzuzhiyejishuxueyuan', 'qdnmzzyjsxy', 0, '52260100', 1869),
 (1870, '云南大学', 'yunnadaxue', 'yndx', 0, '53010000', 1870),
 (1871, '昆明理工大学', 'kunmingligongdaxue', 'kmlgdx', 0, '53010000', 1871),
 (1872, '云南农业大学', 'yunnanongyedaxue', 'ynnydx', 0, '53010000', 1872),
 (1873, '西南林业大学', 'xinalinyedaxue', 'xnlydx', 0, '53010000', 1873),
 (1874, '云南师范大学', 'yunnashifandaxue', 'ynsfdx', 0, '53010000', 1874),
 (1875, '云南财经大学', 'yunnacaijingdaxue', 'yncjdx', 0, '53010000', 1875),
 (1876, '云南民族大学', 'yunnaminzudaxue', 'ynmzdx', 0, '53010000', 1876),
 (1877, '昆明医学院', 'kunmingyixueyuan', 'kmyxy', 0, '53010000', 1877),
 (1878, '云南中医学院', 'yunnazhongyixueyuan', 'ynzyxy', 0, '53010000', 1878),
 (1879, '曲靖师范学院', 'qujingshifanxueyuan', 'qjsfxy', 0, '53030000', 1879),
 (1880, '玉溪师范学院', 'yuxishifanxueyuan', 'yxsfxy', 0, '53040000', 1880),
 (1881, '楚雄师范学院', 'chuxiongshifanxueyuan', 'cxsfxy', 0, '53230100', 1881),
 (1882, '红河学院', 'honghexueyuan', 'hhxy', 0, '53250000', 1882),
 (1883, '云南工商学院', 'yunnagongshangxueyuan', 'yngsxy', 0, '53010000', 1883),
 (1884, '云南警官学院', 'yunnajingguanxueyuan', 'ynjgxy', 0, '53010000', 1884),
 (1885, '云南艺术学院', 'yunnayishuxueyuan', 'ynysxy', 0, '53010000', 1885),
 (1886, '昆明学院', 'kunmingxueyuan', 'kmxy', 0, '53010000', 1886),
 (1887, '大理学院', 'dalixueyuan', 'dlxy', 0, '53290000', 1887),
 (1888, '文山学院', 'wenshanxueyuan', 'wsxy', 0, '53260000', 1888),
 (1889, '保山学院', 'baoshanxueyuan', 'bsxy', 0, '53050000', 1889),
 (1890, '昆明冶金高等专科学校', 'kunmingyejingaodengzhuankexuexiao', 'kmyjgdzkxx', 0, '53010000', 1890),
 (1891, '保山中医药高等专科学校', 'baoshanzhongyiyaogaodengzhuankexuexiao', 'bszyygdzkxx', 0, '53050000', 1891),
 (1892, '曲靖医学高等专科学校', 'qujingyixuegaodengzhuankexuexiao', 'qjyxgdzkxx', 0, '53030000', 1892),
 (1893, '楚雄医药高等专科学校', 'chuxiongyiyaogaodengzhuankexuexiao', 'cxyygdzkxx', 0, '53230000', 1893),
 (1894, '思茅师范高等专科学校', 'simaoshifangaodengzhuankexuexiao', 'smsfgdzkxx', 0, '53082100', 1894),
 (1895, '昭通师范高等专科学校', 'zhaotongshifangaodengzhuankexuexiao', 'ztsfgdzkxx', 0, '53060000', 1895),
 (1896, '德宏师范高等专科学校', 'dehongshifangaodengzhuankexuexiao', 'dhsfgdzkxx', 0, '53310000', 1896),
 (1897, '临沧师范高等专科学校', 'lincangshifangaodengzhuankexuexiao', 'lcsfgdzkxx', 0, '53090000', 1897),
 (1898, '丽江师范高等专科学校', 'lijiangshifangaodengzhuankexuexiao', 'ljsfgdzkxx', 0, '53070000', 1898),
 (1899, '云南交通职业技术学院', 'yunnajiaotongzhiyejishuxueyuan', 'ynjtzyjsxy', 0, '53010000', 1899),
 (1900, '云南科技信息职业学院', 'yunnakejixinxizhiyexueyuan', 'ynkjxxzyxy', 0, '53010000', 1900),
 (1901, '云南三鑫职业技术学院', 'yunnasanxinzhiyejishuxueyuan', 'ynsxzyjsxy', 0, '53260000', 1901),
 (1902, '西双版纳职业技术学院', 'xishuangbannazhiyejishuxueyuan', 'xsbnzyjsxy', 0, '53280000', 1902),
 (1903, '云南旅游职业学院', 'yunnaluyouzhiyexueyuan', 'ynlyzyxy', 0, '53010000', 1903),
 (1904, '云南体育运动职业技术学院', 'yunnatiyuyundongzhiyejishuxueyuan', 'yntyydzyjsxy', 0, '53010000', 1904),
 (1905, '云南经济管理职业学院', 'yunnajingjiguanlizhiyexueyuan', 'ynjjglzyxy', 0, '53010000', 1905),
 (1906, '云南文化艺术职业学院', 'yunnawenhuayishuzhiyexueyuan', 'ynwhyszyxy', 0, '53010000', 1906),
 (1907, '云南新兴职业学院', 'yunnaxinxingzhiyexueyuan', 'ynxxzyxy', 0, '53010000', 1907),
 (1908, '云南经贸外事职业学院', 'yunnajingmaowaishizhiyexueyuan', 'ynjmwszyxy', 0, '53010000', 1908),
 (1909, '德宏职业学院', 'dehongzhiyexueyuan', 'dhzyxy', 0, '53310000', 1909),
 (1910, '云南锡业职业技术学院', 'yunnaxiyezhiyejishuxueyuan', 'ynxyzyjsxy', 0, '53250000', 1910),
 (1911, '云南热带作物职业学院', 'yunnaredaizuowuzhiyexueyuan', 'ynrdzwzyxy', 0, '53082100', 1911),
 (1912, '云南国防工业职业技术学院', 'yunnaguofanggongyezhiyejishuxueyuan', 'yngfgyzyjsxy', 0, '53010000', 1912),
 (1913, '玉溪农业职业技术学院', 'yuxinongyezhiyejishuxueyuan', 'yxnyzyjsxy', 0, '53040000', 1913),
 (1914, '昆明工业职业技术学院', 'kunminggongyezhiyejishuxueyuan', 'kmgyzyjsxy', 0, '53010000', 1914),
 (1915, '云南农业职业技术学院', 'yunnanongyezhiyejishuxueyuan', 'ynnyzyjsxy', 0, '53010000', 1915),
 (1916, '云南机电职业技术学院', 'yunnajidianzhiyejishuxueyuan', 'ynjdzyjsxy', 0, '53010000', 1916),
 (1917, '云南司法警官职业学院', 'yunnasifajingguanzhiyexueyuan', 'ynsfjgzyxy', 0, '53010000', 1917),
 (1918, '昆明扬帆职业技术学院', 'kunmingyangfanzhiyejishuxueyuan', 'kmyfzyjsxy', 0, '53010000', 1918),
 (1919, '云南国土资源职业学院', 'yunnaguotuziyuanzhiyexueyuan', 'yngtzyzyxy', 0, '53010000', 1919),
 (1920, '云南城市建设职业学院', 'yunnachengshijianshezhiyexueyuan', 'yncsjszyxy', 0, '53010000', 1920),
 (1921, '昆明艺术职业学院', 'kunmingyishuzhiyexueyuan', 'kmyszyxy', 0, '53010000', 1921),
 (1922, '云南现代职业技术学院', 'yunnaxiandaizhiyejishuxueyuan', 'ynxdzyjsxy', 0, '53230100', 1922),
 (1923, '昆明卫生职业学院', 'kunmingweishengzhiyexueyuan', 'kmwszyxy', 0, '53010000', 1923),
 (1924, '云南林业职业技术学院', 'yunnalinyezhiyejishuxueyuan', 'ynlyzyjsxy', 0, '53010000', 1924),
 (1925, '云南能源职业技术学院', 'yunnanengyuanzhiyejishuxueyuan', 'ynnyzyjsxy', 0, '53030000', 1925),
 (1926, '云南商务职业学院', 'yunnashangwuzhiyexueyuan', 'ynswzyxy', 0, '53010000', 1926),
 (1927, '西藏大学', 'xicangdaxue', 'xcdx', 0, '54010000', 1927),
 (1928, '西藏藏医学院', 'xicangcangyixueyuan', 'xccyxy', 0, '54010000', 1928),
 (1929, '西藏民族学院', 'xicangminzuxueyuan', 'xcmzxy', 0, '61040000', 1929),
 (1930, '拉萨师范高等专科学校', 'lasashifangaodengzhuankexuexiao', 'lssfgdzkxx', 0, '54010000', 1930),
 (1931, '西藏警官高等专科学校', 'xicangjingguangaodengzhuankexuexiao', 'xcjggdzkxx', 0, '54010000', 1931),
 (1932, '西藏职业技术学院', 'xicangzhiyejishuxueyuan', 'xczyjsxy', 0, '54010000', 1932),
 (1933, '西安交通大学', 'xianjiaotongdaxue', 'xajtdx', 0, '61010000', 1933),
 (1934, '长安大学', 'changandaxue', 'cadx', 0, '61010000', 1934),
 (1935, '西安电子科技大学', 'xiandianzikejidaxue', 'xadzkjdx', 0, '61010000', 1935),
 (1936, '西北农林科技大学', 'xibeinonglinkejidaxue', 'xbnlkjdx', 0, '61040000', 1936),
 (1937, '陕西师范大学', 'shanxishifandaxue', 'sxsfdx', 0, '61010000', 1937),
 (1938, '西北工业大学', 'xibeigongyedaxue', 'xbgydx', 0, '61010000', 1938),
 (1939, '西北大学', 'xibeidaxue', 'xbdx', 0, '61010000', 1939),
 (1940, '延安大学', 'yanandaxue', 'yadx', 0, '61060000', 1940),
 (1941, '西安理工大学', 'xianligongdaxue', 'xalgdx', 0, '61010000', 1941),
 (1942, '西安建筑科技大学', 'xianjianzhukejidaxue', 'xajzkjdx', 0, '61010000', 1942),
 (1943, '西安科技大学', 'xiankejidaxue', 'xakjdx', 0, '61010000', 1943),
 (1944, '西安石油大学', 'xianshiyoudaxue', 'xasydx', 0, '61010000', 1944),
 (1945, '西安工程大学', 'xiangongchengdaxue', 'xagcdx', 0, '61010000', 1945),
 (1946, '西安工业大学', 'xiangongyedaxue', 'xagydx', 0, '61010000', 1946),
 (1947, '西安外国语大学', 'xianwaiguoyudaxue', 'xawgydx', 0, '61010000', 1947),
 (1948, '西北政法大学', 'xibeizhengfadaxue', 'xbzfdx', 0, '61010000', 1948),
 (1949, '陕西科技大学', 'shanxikejidaxue', 'sxkjdx', 0, '61010000', 1949),
 (1950, '陕西国际商贸学院', 'shanxiguojishangmaoxueyuan', 'sxgjsmxy', 0, '61040000', 1950),
 (1951, '西安思源学院', 'xiansiyuanxueyuan', 'xasyxy', 0, '61010000', 1951),
 (1952, '西安邮电学院', 'xianyoudianxueyuan', 'xaydxy', 0, '61010000', 1952),
 (1953, '陕西中医学院', 'shanxizhongyixueyuan', 'sxzyxy', 0, '61040000', 1953),
 (1954, '西安医学院', 'xianyixueyuan', 'xayxy', 0, '61010000', 1954),
 (1955, '宝鸡文理学院', 'baojiwenlixueyuan', 'bjwlxy', 0, '61030000', 1955),
 (1956, '咸阳师范学院', 'xianyangshifanxueyuan', 'xysfxy', 0, '61040000', 1956),
 (1957, '陕西理工学院', 'shanxiligongxueyuan', 'sxlgxy', 0, '61070000', 1957),
 (1958, '榆林学院', 'yulinxueyuan', 'ylxy', 0, '61080000', 1958),
 (1959, '渭南师范学院', 'weinashifanxueyuan', 'wnsfxy', 0, '61050000', 1959),
 (1960, '西安财经学院', 'xiancaijingxueyuan', 'xacjxy', 0, '61010000', 1960),
 (1961, '西安体育学院', 'xiantiyuxueyuan', 'xatyxy', 0, '61010000', 1961),
 (1962, '西安美术学院', 'xianmeishuxueyuan', 'xamsxy', 0, '61010000', 1962),
 (1963, '西安音乐学院', 'xianyinlexueyuan', 'xaylxy', 0, '61010000', 1963),
 (1964, '陕西服装工程学院', 'shanxifuzhuanggongchengxueyuan', 'sxfzgcxy', 0, '61040000', 1964),
 (1965, '西京学院', 'xijingxueyuan', 'xjxy', 0, '61010000', 1965),
 (1966, '西安翻译学院', 'xianfanyixueyuan', 'xafyxy', 0, '61010000', 1966),
 (1967, '西安外事学院', 'xianwaishixueyuan', 'xawsxy', 0, '61010000', 1967),
 (1968, '西安欧亚学院', 'xianoyaxueyuan', 'xaoyxy', 0, '61010000', 1968),
 (1969, '西安培华学院', 'xianpeihuaxueyuan', 'xaphxy', 0, '61010000', 1969),
 (1970, '商洛学院', 'shangluoxueyuan', 'slxy', 0, '61100200', 1970),
 (1971, '安康学院', 'ankangxueyuan', 'akxy', 0, '61090000', 1971),
 (1972, '西安文理学院', 'xianwenlixueyuan', 'xawlxy', 0, '61010000', 1972),
 (1973, '西安航空技术高等专科学校', 'xianhangkongjishugaodengzhuankexuexiao', 'xahkjsgdzkxx', 0, '61010000', 1973),
 (1974, '西安电力高等专科学校', 'xiandianligaodengzhuankexuexiao', 'xadlgdzkxx', 0, '61010000', 1974),
 (1975, '西安医学高等专科学校', 'xianyixuegaodengzhuankexuexiao', 'xayxgdzkxx', 0, '61010000', 1975),
 (1976, '杨凌职业技术学院', 'yanglingzhiyejishuxueyuan', 'ylzyjsxy', 0, '61040000', 1976),
 (1977, '陕西工业职业技术学院', 'shanxigongyezhiyejishuxueyuan', 'sxgyzyjsxy', 0, '61040000', 1977),
 (1978, '陕西旅游烹饪职业学院', 'shanxiluyoupengrenzhiyexueyuan', 'sxlyprzyxy', 0, '61040000', 1978),
 (1979, '陕西警官职业学院', 'shanxijingguanzhiyexueyuan', 'sxjgzyxy', 0, '61010000', 1979),
 (1980, '陕西电子科技职业学院', 'shanxidianzikejizhiyexueyuan', 'sxdzkjzyxy', 0, '61010000', 1980),
 (1981, '西安东方亚太职业技术学院', 'xiandongfangyataizhiyejishuxueyuan', 'xadfytzyjsxy', 0, '61010000', 1981),
 (1982, '西安海棠职业学院', 'xianhaitangzhiyexueyuan', 'xahtzyxy', 0, '61010000', 1982),
 (1983, '西安汽车科技职业学院', 'xianqichekejizhiyexueyuan', 'xaqckjzyxy', 0, '61010000', 1983),
 (1984, '陕西工商职业学院', 'shanxigongshangzhiyexueyuan', 'sxgszyxy', 0, '61040000', 1984),
 (1985, '陕西交通职业技术学院', 'shanxijiaotongzhiyejishuxueyuan', 'sxjtzyjsxy', 0, '61010000', 1985),
 (1986, '西安航空职业技术学院', 'xianhangkongzhiyejishuxueyuan', 'xahkzyjsxy', 0, '61010000', 1986),
 (1987, '陕西邮电职业技术学院', 'shanxiyoudianzhiyejishuxueyuan', 'sxydzyjsxy', 0, '61040000', 1987),
 (1988, '西安科技商贸职业学院', 'xiankejishangmaozhiyexueyuan', 'xakjsmzyxy', 0, '61010000', 1988),
 (1989, '西安三资职业学院', 'xiansanzizhiyexueyuan', 'xaszzyxy', 0, '61010000', 1989),
 (1990, '西安高新科技职业学院', 'xiangaoxinkejizhiyexueyuan', 'xagxkjzyxy', 0, '61010000', 1990),
 (1991, '西安铁路职业技术学院', 'xiantieluzhiyejishuxueyuan', 'xatlzyjsxy', 0, '61010000', 1991),
 (1992, '陕西经济管理职业技术学院', 'shanxijingjiguanlizhiyejishuxueyuan', 'sxjjglzyjsxy', 0, '61010000', 1992),
 (1993, '咸阳职业技术学院', 'xianyangzhiyejishuxueyuan', 'xyzyjsxy', 0, '61040000', 1993),
 (1994, '西安职业技术学院', 'xianzhiyejishuxueyuan', 'xazyjsxy', 0, '61010000', 1994),
 (1995, '商洛职业技术学院', 'shangluozhiyejishuxueyuan', 'slzyjsxy', 0, '44098100', 1995),
 (1996, '宝鸡职业技术学院', 'baojizhiyejishuxueyuan', 'bjzyjsxy', 0, '61030000', 1996),
 (1997, '陕西国防工业职业技术学院', 'shanxiguofanggongyezhiyejishuxueyuan', 'sxgfgyzyjsxy', 0, '61010000', 1997),
 (1998, '陕西铁路工程职业技术学院', 'shanxitielugongchengzhiyejishuxueyuan', 'sxtlgczyjsxy', 0, '61050000', 1998),
 (1999, '陕西财经职业技术学院', 'shanxicaijingzhiyejishuxueyuan', 'sxcjzyjsxy', 0, '61040000', 1999);
 INSERT `tn_Schools` (`Id`, `Name`, `PinyinName`, `ShortPinyinName`, `SchoolType`, `AreaCode`, `DisplayOrder`)
 VALUES
 (2000, '陕西电子信息职业技术学院', 'shanxidianzixinxizhiyejishuxueyuan', 'sxdzxxzyjsxy', 0, '61010000', 2000),
 (2001, '汉中职业技术学院', 'hanzhongzhiyejishuxueyuan', 'hzzyjsxy', 0, '61070000', 2001),
 (2002, '延安职业技术学院', 'yananzhiyejishuxueyuan', 'yazyjsxy', 0, '61060000', 2002),
 (2003, '渭南职业技术学院', 'weinazhiyejishuxueyuan', 'wnzyjsxy', 0, '61050000', 2003),
 (2004, '安康职业技术学院', 'ankangzhiyejishuxueyuan', 'akzyjsxy', 0, '61090000', 2004),
 (2005, '铜川职业技术学院', 'tongchuanzhiyejishuxueyuan', 'tczyjsxy', 0, '61020000', 2005),
 (2006, '陕西青年职业学院', 'shanxiqingnianzhiyexueyuan', 'sxqnzyxy', 0, '61010000', 2006),
 (2007, '陕西职业技术学院', 'shanxizhiyejishuxueyuan', 'sxzyjsxy', 0, '61010000', 2007),
 (2008, '陕西能源职业技术学院', 'shanxinengyuanzhiyejishuxueyuan', 'sxnyzyjsxy', 0, '61040000', 2008),
 (2009, '陕西航空职业技术学院', 'shanxihangkongzhiyejishuxueyuan', 'sxhkzyjsxy', 0, '61070000', 2009),
 (2010, '榆林职业技术学院', 'yulinzhiyejishuxueyuan', 'ylzyjsxy', 0, '61080000', 2010),
 (2011, '兰州大学', 'lanzhoudaxue', 'lzdx', 0, '62010000', 2011),
 (2012, '西北民族大学', 'xibeiminzudaxue', 'xbmzdx', 0, '62010000', 2012),
 (2013, '兰州理工大学', 'lanzhouligongdaxue', 'lzlgdx', 0, '62010000', 2013),
 (2014, '兰州交通大学', 'lanzhoujiaotongdaxue', 'lzjtdx', 0, '62010000', 2014),
 (2015, '甘肃农业大学', 'gansunongyedaxue', 'gsnydx', 0, '62010000', 2015),
 (2016, '西北师范大学', 'xibeishifandaxue', 'xbsfdx', 0, '62010000', 2016),
 (2017, '甘肃中医学院', 'gansuzhongyixueyuan', 'gszyxy', 0, '62010000', 2017),
 (2018, '陇东学院', 'longdongxueyuan', 'ldxy', 0, '62100200', 2018),
 (2019, '天水师范学院', 'tianshuishifanxueyuan', 'tssfxy', 0, '62050000', 2019),
 (2020, '甘肃民族师范学院', 'gansuminzushifanxueyuan', 'gsmzsfxy', 0, '23022500', 2020),
 (2021, '兰州商学院', 'lanzhoushangxueyuan', 'lzsxy', 0, '62010000', 2021),
 (2022, '甘肃政法学院', 'gansuzhengfaxueyuan', 'gszfxy', 0, '62010000', 2022),
 (2023, '兰州城市学院', 'lanzhouchengshixueyuan', 'lzcsxy', 0, '62010000', 2023),
 (2024, '河西学院', 'hexixueyuan', 'hxxy', 0, '62070000', 2024),
 (2025, '兰州工业高等专科学校', 'lanzhougongyegaodengzhuankexuexiao', 'lzgygdzkxx', 0, '62010000', 2025),
 (2026, '张掖医学高等专科学校', 'zhangyeyixuegaodengzhuankexuexiao', 'zyyxgdzkxx', 0, '62070000', 2026),
 (2027, '平凉医学高等专科学校', 'pingliangyixuegaodengzhuankexuexiao', 'plyxgdzkxx', 0, '62080000', 2027),
 (2028, '陇南师范高等专科学校', 'longnashifangaodengzhuankexuexiao', 'lnsfgdzkxx', 0, '62122100', 2028),
 (2029, '定西师范高等专科学校', 'dingxishifangaodengzhuankexuexiao', 'dxsfgdzkxx', 0, '62110000', 2029),
 (2030, '甘肃机电职业技术学院', 'gansujidianzhiyejishuxueyuan', 'gsjdzyjsxy', 0, '62050000', 2030),
 (2031, '兰州石化职业技术学院', 'lanzhoushihuazhiyejishuxueyuan', 'lzshzyjsxy', 0, '62010000', 2031),
 (2032, '甘肃联合大学', 'gansulianhedaxue', 'gslhdx', 0, '62010000', 2032),
 (2033, '甘肃畜牧工程职业技术学院', 'gansuxumugongchengzhiyejishuxueyuan', 'gsxmgczyjsxy', 0, '62060000', 2033),
 (2034, '白银矿冶职业技术学院', 'baiyinkuangyezhiyejishuxueyuan', 'bykyzyjsxy', 0, '62040000', 2034),
 (2035, '甘肃有色冶金职业技术学院', 'gansuyouseyejinzhiyejishuxueyuan', 'gsysyjzyjsxy', 0, '62030000', 2035),
 (2036, '武威职业学院', 'wuweizhiyexueyuan', 'wwzyxy', 0, '62060000', 2036),
 (2037, '甘肃钢铁职业技术学院', 'gansugangtiezhiyejishuxueyuan', 'gsgtzyjsxy', 0, '62020000', 2037),
 (2038, '兰州资源环境职业技术学院', 'lanzhouziyuanhuanjingzhiyejishuxueyuan', 'lzzyhjzyjsxy', 0, '62010000', 2038),
 (2039, '甘肃建筑职业技术学院', 'gansujianzhuzhiyejishuxueyuan', 'gsjzzyjsxy', 0, '62010000', 2039),
 (2040, '甘肃农业职业技术学院', 'gansunongyezhiyejishuxueyuan', 'gsnyzyjsxy', 0, '62010000', 2040),
 (2041, '甘肃工业职业技术学院', 'gansugongyezhiyejishuxueyuan', 'gsgyzyjsxy', 0, '62050000', 2041),
 (2042, '兰州职业技术学院', 'lanzhouzhiyejishuxueyuan', 'lzzyjsxy', 0, '62010000', 2042),
 (2043, '兰州外语职业学院', 'lanzhouwaiyuzhiyexueyuan', 'lzwyzyxy', 0, '62010000', 2043),
 (2044, '酒泉职业技术学院', 'jiuquanzhiyejishuxueyuan', 'jqzyjsxy', 0, '62090000', 2044),
 (2045, '甘肃交通职业技术学院', 'gansujiaotongzhiyejishuxueyuan', 'gsjtzyjsxy', 0, '62010000', 2045),
 (2046, '甘肃警察职业学院', 'gansujingchazhiyexueyuan', 'gsjczyxy', 0, '62010000', 2046),
 (2047, '甘肃林业职业技术学院', 'gansulinyezhiyejishuxueyuan', 'gslyzyjsxy', 0, '62050000', 2047),
 (2048, '青海大学', 'qinghaidaxue', 'qhdx', 0, '63010000', 2048),
 (2049, '青海师范大学', 'qinghaishifandaxue', 'qhsfdx', 0, '63010000', 2049),
 (2050, '青海民族大学', 'qinghaiminzudaxue', 'qhmzdx', 0, '63010000', 2050),
 (2051, '青海畜牧兽医职业技术学院', 'qinghaixumushouyizhiyejishuxueyuan', 'qhxmsyzyjsxy', 0, '63010000', 2051),
 (2052, '青海卫生职业技术学院', 'qinghaiweishengzhiyejishuxueyuan', 'qhwszyjsxy', 0, '63010000', 2052),
 (2053, '青海警官职业学院', 'qinghaijingguanzhiyexueyuan', 'qhjgzyxy', 0, '63010000', 2053),
 (2054, '青海交通职业技术学院', 'qinghaijiaotongzhiyejishuxueyuan', 'qhjtzyjsxy', 0, '63010000', 2054),
 (2055, '青海建筑职业技术学院', 'qinghaijianzhuzhiyejishuxueyuan', 'qhjzzyjsxy', 0, '63010000', 2055),
 (2056, '北方民族大学', 'beifangminzudaxue', 'bfmzdx', 0, '64010000', 2056),
 (2057, '宁夏大学', 'ningxiadaxue', 'nxdx', 0, '64010000', 2057),
 (2058, '宁夏理工学院', 'ningxialigongxueyuan', 'nxlgxy', 0, '64020000', 2058),
 (2059, '宁夏医科大学', 'ningxiayikedaxue', 'nxykdx', 0, '64010000', 2059),
 (2060, '宁夏师范学院', 'ningxiashifanxueyuan', 'nxsfxy', 0, '64040000', 2060),
 (2061, '宁夏民族职业技术学院', 'ningxiaminzuzhiyejishuxueyuan', 'nxmzzyjsxy', 0, '64030000', 2061),
 (2062, '宁夏防沙治沙职业技术学院', 'ningxiafangshazhishazhiyejishuxueyuan', 'nxfszszyjsxy', 0, '64010000', 2062),
 (2063, '宁夏工业职业学院', 'ningxiagongyezhiyexueyuan', 'nxgyzyxy', 0, '64010000', 2063),
 (2064, '宁夏职业技术学院', 'ningxiazhiyejishuxueyuan', 'nxzyjsxy', 0, '64010000', 2064),
 (2065, '银川科技职业学院', 'yinchuankejizhiyexueyuan', 'yckjzyxy', 0, '64010000', 2065),
 (2066, '宁夏建设职业技术学院', 'ningxiajianshezhiyejishuxueyuan', 'nxjszyjsxy', 0, '64010000', 2066),
 (2067, '宁夏工商职业技术学院', 'ningxiagongshangzhiyejishuxueyuan', 'nxgszyjsxy', 0, '64010000', 2067),
 (2068, '宁夏财经职业技术学院', 'ningxiacaijingzhiyejishuxueyuan', 'nxcjzyjsxy', 0, '64010000', 2068),
 (2069, '宁夏司法警官职业学院', 'ningxiasifajingguanzhiyexueyuan', 'nxsfjgzyxy', 0, '64010000', 2069),
 (2070, '新疆大学', 'xinjiangdaxue', 'xjdx', 0, '65010000', 2070),
 (2071, '石河子大学', 'shihezidaxue', 'shzdx', 0, '65900100', 2071),
 (2072, '新疆农业大学', 'xinjiangnongyedaxue', 'xjnydx', 0, '65010000', 2072),
 (2073, '塔里木大学', 'talimudaxue', 'tlmdx', 0, '65900200', 2073),
 (2074, '新疆医科大学', 'xinjiangyikedaxue', 'xjykdx', 0, '65010000', 2074),
 (2075, '新疆师范大学', 'xinjiangshifandaxue', 'xjsfdx', 0, '65010000', 2075),
 (2076, '新疆财经大学', 'xinjiangcaijingdaxue', 'xjcjdx', 0, '65010000', 2076),
 (2077, '喀什师范学院', 'kashishifanxueyuan', 'kssfxy', 0, '65310100', 2077),
 (2078, '伊犁师范学院', 'yilishifanxueyuan', 'ylsfxy', 0, '65400200', 2078),
 (2079, '新疆艺术学院', 'xinjiangyishuxueyuan', 'xjysxy', 0, '65010000', 2079),
 (2080, '昌吉学院', 'changjixueyuan', 'cjxy', 0, '65230100', 2080),
 (2081, '新疆工业高等专科学校', 'xinjianggongyegaodengzhuankexuexiao', 'xjgygdzkxx', 0, '65010000', 2081),
 (2082, '新疆维吾尔医学专科学校', 'xinjiangweiwueyixuezhuankexuexiao', 'xjwweyxzkxx', 0, '65320100', 2082),
 (2083, '和田师范专科学校', 'hetianshifanzhuankexuexiao', 'htsfzkxx', 0, '65320100', 2083),
 (2084, '新疆兵团警官高等专科学校', 'xinjiangbingtuanjingguangaodengzhuankexuexiao', 'xjbtjggdzkxx', 0, '65010000', 2084),
 (2085, '新疆警官高等专科学校', 'xinjiangjingguangaodengzhuankexuexiao', 'xjjggdzkxx', 0, '65010000', 2085),
 (2086, '乌鲁木齐职业大学', 'wulumuqizhiyedaxue', 'wlmqzydx', 0, '65010000', 2086),
 (2087, '新疆机电职业技术学院', 'xinjiangjidianzhiyejishuxueyuan', 'xjjdzyjsxy', 0, '65010000', 2087),
 (2088, '新疆轻工职业技术学院', 'xinjiangqinggongzhiyejishuxueyuan', 'xjqgzyjsxy', 0, '65010000', 2088),
 (2089, '克拉玛依职业技术学院', 'kelamayizhiyejishuxueyuan', 'klmyzyjsxy', 0, '65020000', 2089),
 (2090, '新疆农业职业技术学院', 'xinjiangnongyezhiyejishuxueyuan', 'xjnyzyjsxy', 0, '65230100', 2090),
 (2091, '昌吉职业技术学院', 'changjizhiyejishuxueyuan', 'cjzyjsxy', 0, '65230100', 2091),
 (2092, '新疆石河子职业技术学院', 'xinjiangshihezizhiyejishuxueyuan', 'xjshzzyjsxy', 0, '65900100', 2092),
 (2093, '新疆交通职业技术学院', 'xinjiangjiaotongzhiyejishuxueyuan', 'xjjtzyjsxy', 0, '65010000', 2093),
 (2094, '新疆现代职业技术学院', 'xinjiangxiandaizhiyejishuxueyuan', 'xjxdzyjsxy', 0, '65010000', 2094),
 (2095, '新疆天山职业技术学院', 'xinjiangtianshanzhiyejishuxueyuan', 'xjtszyjsxy', 0, '65010000', 2095),
 (2096, '阿克苏职业技术学院', 'akesuzhiyejishuxueyuan', 'akszyjsxy', 0, '65290100', 2096),
 (2097, '巴音郭楞职业技术学院', 'bayinguolengzhiyejishuxueyuan', 'byglzyjsxy', 0, '51190200', 2097),
 (2098, '伊犁职业技术学院', 'yilizhiyejishuxueyuan', 'ylzyjsxy', 0, '65400200', 2098),
 (2099, '新疆职业大学', 'xinjiangzhiyedaxue', 'xjzydx', 0, '65010000', 2099),
 (2100, '新疆能源职业技术学院', 'xinjiangnengyuanzhiyejishuxueyuan', 'xjnyzyjsxy', 0, '65010000', 2100),
 (2101, '新疆建设职业技术学院', 'xinjiangjianshezhiyejishuxueyuan', 'xjjszyjsxy', 0, '65010000', 2101);

-- 敏感词
INSERT `tn_SensitiveWords` ( `Word`, `Replacement`, `TypeId`)
 VALUES ( '阿扁推翻', '*', 0),
 ( '阿宾', '*', 0),
 ( '阿賓', '*', 0),
 ( '挨了一炮', '*', 0),
 ( '爱液横流', '*', 0),
 ( '安街逆', '*', 0),
 ( '安局办公楼', '*', 0),
 ( '安局豪华', '*', 0),
 ( '安门事', '*', 0),
 ( '安眠藥', '*', 0),
 ( '案的准确', '*', 0),
 ( '八九民', '*', 0),
 ( '八九学', '*', 0),
 ( '八九政治', '*', 0),
 ( '把病人整', '*', 0),
 ( '把邓小平', '*', 0),
 ( '把学生整', '*', 0),
 ( '罢工门', '*', 0),
 ( '白黄牙签', '*', 0),
 ( '败培训', '*', 0),
 ( '办本科', '*', 0),
 ( '办理本科', '*', 0),
 ( '办理各种', '*', 0),
 ( '办理票据', '*', 0),
 ( '办理文凭', '*', 0),
 ( '办理真实', '*', 0),
 ( '办理证书', '*', 0),
 ( '办理资格', '*', 0),
 ( '办文凭', '*', 0),
 ( '办怔', '*', 0),
 ( '办证', '*', 0),
 ( '半刺刀', '*', 0),
 ( '辦毕业', '*', 0),
 ( '辦證', '*', 0),
 ( '谤罪获刑', '*', 0),
 ( '磅解码器', '*', 0),
 ( '磅遥控器', '*', 0),
 ( '宝在甘肃修', '*', 0),
 ( '保过答案', '*', 0),
 ( '报复执法', '*', 0),
 ( '爆发骚', '*', 0),
 ( '北省委门', '*', 0),
 ( '被打死', '*', 0),
 ( '被指抄袭', '*', 0),
 ( '被中共', '*', 0),
 ( '本公司担', '*', 0),
 ( '本无码', '*', 0),
 ( '毕业證', '*', 0),
 ( '变牌绝', '*', 0),
 ( '辩词与梦', '*', 0),
 ( '冰毒', '*', 0),
 ( '冰火毒', '*', 0),
 ( '冰火佳', '*', 0),
 ( '冰火九重', '*', 0),
 ( '冰火漫', '*', 0),
 ( '冰淫传', '*', 0),
 ( '冰在火上', '*', 0),
 ( '波推龙', '*', 0),
 ( '博彩娱', '*', 0),
 ( '博会暂停', '*', 0),
 ( '博园区伪', '*', 0),
 ( '不查都', '*', 0),
 ( '不查全', '*', 0),
 ( '不思四化', '*', 0),
 ( '布卖淫女', '*', 0),
 ( '部忙组阁', '*', 0),
 ( '部是这样', '*', 0),
 ( '才知道只生', '*', 0),
 ( '财众科技', '*', 0),
 ( '采花堂', '*', 0),
 ( '踩踏事', '*', 0),
 ( '苍山兰', '*', 0),
 ( '苍蝇水', '*', 0),
 ( '藏春阁', '*', 0),
 ( '藏獨', '*', 0),
 ( '操了嫂', '*', 0),
 ( '操嫂子', '*', 0),
 ( '策没有不', '*', 0),
 ( '插屁屁', '*', 0),
 ( '察象蚂', '*', 0),
 ( '拆迁灭', '*', 0),
 ( '车牌隐', '*', 0),
 ( '成人电', '*', 0),
 ( '成人卡通', '*', 0),
 ( '成人聊', '*', 0),
 ( '成人片', '*', 0),
 ( '成人视', '*', 0),
 ( '成人图', '*', 0),
 ( '成人文', '*', 0),
 ( '成人小', '*', 0),
 ( '城管灭', '*', 0),
 ( '惩公安', '*', 0),
 ( '惩贪难', '*', 0),
 ( '充气娃', '*', 0),
 ( '冲凉死', '*', 0),
 ( '抽着大中', '*', 0),
 ( '抽着芙蓉', '*', 0),
 ( '出成绩付', '*', 0),
 ( '出售发票', '*', 0),
 ( '出售军', '*', 0),
 ( '穿透仪器', '*', 0),
 ( '春水横溢', '*', 0),
 ( '纯度白', '*', 0),
 ( '纯度黄', '*', 0),
 ( '次通过考', '*', 0),
 ( '催眠水', '*', 0),
 ( '催情粉', '*', 0),
 ( '催情药', '*', 0),
 ( '催情藥', '*', 0),
 ( '挫仑', '*', 0),
 ( '达毕业证', '*', 0),
 ( '答案包', '*', 0),
 ( '答案提供', '*', 0),
 ( '打标语', '*', 0),
 ( '打错门', '*', 0),
 ( '打飞机专', '*', 0),
 ( '打死经过', '*', 0),
 ( '打死人', '*', 0),
 ( '打砸办公', '*', 0),
 ( '大鸡巴', '*', 0),
 ( '大雞巴', '*', 0),
 ( '大纪元', '*', 0),
 ( '大揭露', '*', 0),
 ( '大奶子', '*', 0),
 ( '大批贪官', '*', 0),
 ( '大肉棒', '*', 0),
 ( '大嘴歌', '*', 0),
 ( '代办发票', '*', 0),
 ( '代办各', '*', 0),
 ( '代办文', '*', 0),
 ( '代办学', '*', 0),
 ( '代办制', '*', 0),
 ( '代辦', '*', 0),
 ( '代表烦', '*', 0),
 ( '代開', '*', 0),
 ( '代考', '*', 0),
 ( '代理发票', '*', 0),
 ( '代理票据', '*', 0),
 ( '代您考', '*', 0),
 ( '代写毕', '*', 0),
 ( '代写论', '*', 0),
 ( '代孕', '*', 0),
 ( '贷办', '*', 0),
 ( '贷借款', '*', 0),
 ( '贷开', '*', 0),
 ( '戴海静', '*', 0),
 ( '当代七整', '*', 0),
 ( '当官要精', '*', 0),
 ( '当官在于', '*', 0),
 ( '党的官', '*', 0),
 ( '党后萎', '*', 0),
 ( '党前干劲', '*', 0),
 ( '刀架保安', '*', 0),
 ( '导的情人', '*', 0),
 ( '导叫失', '*', 0),
 ( '导人的最', '*', 0),
 ( '导人最', '*', 0),
 ( '导小商', '*', 0),
 ( '到花心', '*', 0),
 ( '得财兼', '*', 0),
 ( '的同修', '*', 0),
 ( '灯草和', '*', 0),
 ( '等级證', '*', 0),
 ( '等屁民', '*', 0),
 ( '等人老百', '*', 0),
 ( '等人是老', '*', 0),
 ( '等人手术', '*', 0),
 ( '邓爷爷转', '*', 0),
 ( '邓玉娇', '*', 0),
 ( '地产之歌', '*', 0),
 ( '地下先烈', '*', 0),
 ( '地震哥', '*', 0),
 ( '帝国之梦', '*', 0),
 ( '递纸死', '*', 0),
 ( '点数优惠', '*', 0),
 ( '电狗', '*', 0),
 ( '电话监', '*', 0),
 ( '电鸡', '*', 0),
 ( '甸果敢', '*', 0),
 ( '蝶舞按', '*', 0),
 ( '丁香社', '*', 0),
 ( '丁子霖', '*', 0),
 ( '顶花心', '*', 0),
 ( '东北独立', '*', 0),
 ( '东复活', '*', 0),
 ( '东京热', '*', 0),
 ( '東京熱', '*', 0),
 ( '洞小口紧', '*', 0),
 ( '都当警', '*', 0),
 ( '都当小姐', '*', 0),
 ( '都进中央', '*', 0),
 ( '毒蛇钻', '*', 0),
 ( '独立台湾', '*', 0),
 ( '赌球网', '*', 0),
 ( '短信截', '*', 0),
 ( '对日强硬', '*', 0),
 ( '多美康', '*', 0),
 ( '躲猫猫', '*', 0),
 ( '俄羅斯', '*', 0),
 ( '恶势力操', '*', 0),
 ( '恶势力插', '*', 0),
 ( '恩氟烷', '*', 0),
 ( '儿园惨', '*', 0),
 ( '儿园砍', '*', 0),
 ( '儿园杀', '*', 0),
 ( '儿园凶', '*', 0),
 ( '二奶大', '*', 0),
 ( '发牌绝', '*', 0),
 ( '发票出', '*', 0),
 ( '发票代', '*', 0),
 ( '发票销', '*', 0),
 ( '發票', '*', 0),
 ( '法车仑', '*', 0),
 ( '法伦功', '*', 0),
 ( '法轮', '*', 0),
 ( '法轮佛', '*', 0),
 ( '法维权', '*', 0),
 ( '法一轮', '*', 0),
 ( '法院给废', '*', 0),
 ( '法正乾', '*', 0),
 ( '反测速雷', '*', 0),
 ( '反雷达测', '*', 0),
 ( '反屏蔽', '*', 0),
 ( '范燕琼', '*', 0),
 ( '方迷香', '*', 0),
 ( '防电子眼', '*', 0),
 ( '防身药水', '*', 0),
 ( '房贷给废', '*', 0),
 ( '仿真枪', '*', 0),
 ( '仿真证', '*', 0),
 ( '诽谤罪', '*', 0),
 ( '费私服', '*', 0),
 ( '封锁消', '*', 0),
 ( '佛同修', '*', 0),
 ( '夫妻交换', '*', 0),
 ( '福尔马林', '*', 0),
 ( '福娃的預', '*', 0),
 ( '福娃頭上', '*', 0),
 ( '福香巴', '*', 0),
 ( '府包庇', '*', 0),
 ( '府集中领', '*', 0),
 ( '妇销魂', '*', 0),
 ( '附送枪', '*', 0),
 ( '复印件生', '*', 0),
 ( '复印件制', '*', 0),
 ( '富民穷', '*', 0),
 ( '富婆给废', '*', 0),
 ( '改号软件', '*', 0),
 ( '感扑克', '*', 0),
 ( '冈本真', '*', 0),
 ( '肛交', '*', 0),
 ( '肛门是邻', '*', 0),
 ( '岡本真', '*', 0),
 ( '钢针狗', '*', 0),
 ( '钢珠枪', '*', 0),
 ( '港澳博球', '*', 0),
 ( '港馬會', '*', 0),
 ( '港鑫華', '*', 0),
 ( '高就在政', '*', 0),
 ( '高考黑', '*', 0),
 ( '高莺莺', '*', 0),
 ( '搞媛交', '*', 0),
 ( '告长期', '*', 0),
 ( '告洋状', '*', 0),
 ( '格证考试', '*', 0),
 ( '各类考试', '*', 0),
 ( '各类文凭', '*', 0),
 ( '跟踪器', '*', 0),
 ( '工程吞得', '*', 0),
 ( '工力人', '*', 0),
 ( '公安错打', '*', 0),
 ( '公安网监', '*', 0),
 ( '公开小姐', '*', 0),
 ( '攻官小姐', '*', 0),
 ( '共狗', '*', 0),
 ( '共王储', '*', 0),
 ( '狗粮', '*', 0),
 ( '狗屁专家', '*', 0),
 ( '鼓动一些', '*', 0),
 ( '乖乖粉', '*', 0),
 ( '官商勾', '*', 0),
 ( '官也不容', '*', 0),
 ( '官因发帖', '*', 0),
 ( '光学真题', '*', 0),
 ( '跪真相', '*', 0),
 ( '滚圆大乳', '*', 0),
 ( '国际投注', '*', 0),
 ( '国家妓', '*', 0),
 ( '国家软弱', '*', 0),
 ( '国家吞得', '*', 0),
 ( '国库折', '*', 0),
 ( '国一九五七', '*', 0),
 ( '國內美', '*', 0),
 ( '哈药直销', '*', 0),
 ( '海访民', '*', 0),
 ( '豪圈钱', '*', 0),
 ( '号屏蔽器', '*', 0),
 ( '和狗交', '*', 0),
 ( '和狗性', '*', 0),
 ( '和狗做', '*', 0),
 ( '黑火药的', '*', 0),
 ( '红色恐怖', '*', 0),
 ( '红外透视', '*', 0),
 ( '紅色恐', '*', 0),
 ( '胡江内斗', '*', 0),
 ( '胡紧套', '*', 0),
 ( '胡錦濤', '*', 0),
 ( '胡适眼', '*', 0),
 ( '胡耀邦', '*', 0),
 ( '湖淫娘', '*', 0),
 ( '虎头猎', '*', 0),
 ( '华国锋', '*', 0),
 ( '华门开', '*', 0),
 ( '化学扫盲', '*', 0),
 ( '划老公', '*', 0),
 ( '还会吹萧', '*', 0),
 ( '还看锦涛', '*', 0),
 ( '环球证件', '*', 0),
 ( '换妻', '*', 0),
 ( '皇冠投注', '*', 0),
 ( '黄冰', '*', 0),
 ( '浑圆豪乳', '*', 0),
 ( '活不起', '*', 0),
 ( '火车也疯', '*', 0),
 ( '机定位器', '*', 0),
 ( '机号定', '*', 0),
 ( '机号卫', '*', 0),
 ( '机卡密', '*', 0),
 ( '机屏蔽器', '*', 0),
 ( '基本靠吼', '*', 0),
 ( '绩过后付', '*', 0);
 INSERT `tn_SensitiveWords` ( `Word`, `Replacement`, `TypeId`)
 VALUES
 ( '激情电', '*', 0),
 ( '激情短', '*', 0),
 ( '激情妹', '*', 0),
 ( '激情炮', '*', 0),
 ( '级办理', '*', 0),
 ( '级答案', '*', 0),
 ( '急需嫖', '*', 0),
 ( '集体打砸', '*', 0),
 ( '集体腐', '*', 0),
 ( '挤乳汁', '*', 0),
 ( '擠乳汁', '*', 0),
 ( '佳静安定', '*', 0),
 ( '家一样饱', '*', 0),
 ( '家属被打', '*', 0),
 ( '甲虫跳', '*', 0),
 ( '甲流了', '*', 0),
 ( '奸成瘾', '*', 0),
 ( '兼职上门', '*', 0),
 ( '监听器', '*', 0),
 ( '监听王', '*', 0),
 ( '简易炸', '*', 0),
 ( '江胡内斗', '*', 0),
 ( '江太上', '*', 0),
 ( '江系人', '*', 0),
 ( '江贼民', '*', 0),
 ( '疆獨', '*', 0),
 ( '蒋彦永', '*', 0),
 ( '叫自慰', '*', 0),
 ( '揭贪难', '*', 0),
 ( '姐包夜', '*', 0),
 ( '姐服务', '*', 0),
 ( '姐兼职', '*', 0),
 ( '姐上门', '*', 0),
 ( '金扎金', '*', 0),
 ( '金钟气', '*', 0),
 ( '津大地震', '*', 0),
 ( '津地震', '*', 0),
 ( '进来的罪', '*', 0),
 ( '京地震', '*', 0),
 ( '京要地震', '*', 0),
 ( '经典谎言', '*', 0),
 ( '精子射在', '*', 0),
 ( '警察被', '*', 0),
 ( '警察的幌', '*', 0),
 ( '警察殴打', '*', 0),
 ( '警察说保', '*', 0),
 ( '警车雷达', '*', 0),
 ( '警方包庇', '*', 0),
 ( '警用品', '*', 0),
 ( '径步枪', '*', 0),
 ( '敬请忍', '*', 0),
 ( '究生答案', '*', 0),
 ( '九龙论坛', '*', 0),
 ( '九评共', '*', 0),
 ( '酒象喝汤', '*', 0),
 ( '酒像喝汤', '*', 0),
 ( '就爱插', '*', 0),
 ( '就要色', '*', 0),
 ( '举国体', '*', 0),
 ( '巨乳', '*', 0),
 ( '据说全民', '*', 0),
 ( '绝食声', '*', 0),
 ( '军长发威', '*', 0),
 ( '军刺', '*', 0),
 ( '军品特', '*', 0),
 ( '军用手', '*', 0),
 ( '开邓选', '*', 0),
 ( '开锁工具', '*', 0),
 ( '開碼', '*', 0),
 ( '開票', '*', 0),
 ( '砍杀幼', '*', 0),
 ( '砍伤儿', '*', 0),
 ( '康没有不', '*', 0),
 ( '康跳楼', '*', 0),
 ( '考答案', '*', 0),
 ( '考后付款', '*', 0),
 ( '考机构', '*', 0),
 ( '考考邓', '*', 0),
 ( '考联盟', '*', 0),
 ( '考前答', '*', 0),
 ( '考前答案', '*', 0),
 ( '考前付', '*', 0),
 ( '考设备', '*', 0),
 ( '考试包过', '*', 0),
 ( '考试保', '*', 0),
 ( '考试答案', '*', 0),
 ( '考试机构', '*', 0),
 ( '考试联盟', '*', 0),
 ( '考试枪', '*', 0),
 ( '考研考中', '*', 0),
 ( '考中答案', '*', 0),
 ( '磕彰', '*', 0),
 ( '克分析', '*', 0),
 ( '克千术', '*', 0),
 ( '克透视', '*', 0),
 ( '空和雅典', '*', 0),
 ( '孔摄像', '*', 0),
 ( '控诉世博', '*', 0),
 ( '控制媒', '*', 0),
 ( '口手枪', '*', 0),
 ( '骷髅死', '*', 0),
 ( '快速办', '*', 0),
 ( '矿难不公', '*', 0),
 ( '拉登说', '*', 0),
 ( '拉开水晶', '*', 0),
 ( '来福猎', '*', 0),
 ( '拦截器', '*', 0),
 ( '狼全部跪', '*', 0),
 ( '浪穴', '*', 0),
 ( '老虎机', '*', 0),
 ( '雷人女官', '*', 0),
 ( '类准确答', '*', 0),
 ( '黎阳平', '*', 0),
 ( '李洪志', '*', 0),
 ( '李咏曰', '*', 0),
 ( '理各种证', '*', 0),
 ( '理是影帝', '*', 0),
 ( '理证件', '*', 0),
 ( '理做帐报', '*', 0),
 ( '力骗中央', '*', 0),
 ( '力月西', '*', 0),
 ( '丽媛离', '*', 0),
 ( '利他林', '*', 0),
 ( '连发手', '*', 0),
 ( '聯繫電', '*', 0),
 ( '炼大法', '*', 0),
 ( '两岸才子', '*', 0),
 ( '两会代', '*', 0),
 ( '两会又三', '*', 0),
 ( '聊视频', '*', 0),
 ( '聊斋艳', '*', 0),
 ( '了件渔袍', '*', 0),
 ( '猎好帮手', '*', 0),
 ( '猎枪销', '*', 0),
 ( '猎槍', '*', 0),
 ( '獵槍', '*', 0),
 ( '领土拿', '*', 0),
 ( '流血事', '*', 0),
 ( '六合彩', '*', 0),
 ( '六死', '*', 0),
 ( '六四事', '*', 0),
 ( '六月联盟', '*', 0),
 ( '龙湾事件', '*', 0),
 ( '隆手指', '*', 0),
 ( '陆封锁', '*', 0),
 ( '陆同修', '*', 0),
 ( '氯胺酮', '*', 0),
 ( '乱奸', '*', 0),
 ( '乱伦类', '*', 0),
 ( '乱伦小', '*', 0),
 ( '亂倫', '*', 0),
 ( '伦理大', '*', 0),
 ( '伦理电影', '*', 0),
 ( '伦理毛', '*', 0),
 ( '伦理片', '*', 0),
 ( '轮功', '*', 0),
 ( '轮手枪', '*', 0),
 ( '论文代', '*', 0),
 ( '罗斯小姐', '*', 0),
 ( '裸聊网', '*', 0),
 ( '裸舞视', '*', 0),
 ( '落霞缀', '*', 0),
 ( '麻古', '*', 0),
 ( '麻果配', '*', 0),
 ( '麻果丸', '*', 0),
 ( '麻将透', '*', 0),
 ( '麻醉狗', '*', 0),
 ( '麻醉枪', '*', 0),
 ( '麻醉槍', '*', 0),
 ( '麻醉藥', '*', 0),
 ( '蟆叫专家', '*', 0),
 ( '卖地财政', '*', 0),
 ( '卖发票', '*', 0),
 ( '卖银行卡', '*', 0),
 ( '卖自考', '*', 0),
 ( '漫步丝', '*', 0),
 ( '忙爱国', '*', 0),
 ( '猫眼工具', '*', 0),
 ( '毛一鲜', '*', 0),
 ( '媒体封锁', '*', 0),
 ( '每周一死', '*', 0),
 ( '美艳少妇', '*', 0),
 ( '妹按摩', '*', 0),
 ( '妹上门', '*', 0),
 ( '门按摩', '*', 0),
 ( '门保健', '*', 0),
 ( '門服務', '*', 0),
 ( '氓培训', '*', 0),
 ( '蒙汗药', '*', 0),
 ( '迷幻型', '*', 0),
 ( '迷幻药', '*', 0),
 ( '迷幻藥', '*', 0),
 ( '迷昏口', '*', 0),
 ( '迷昏药', '*', 0),
 ( '迷昏藥', '*', 0),
 ( '迷魂香', '*', 0),
 ( '迷魂药', '*', 0),
 ( '迷魂藥', '*', 0),
 ( '迷奸药', '*', 0),
 ( '迷情水', '*', 0),
 ( '迷情药', '*', 0),
 ( '迷藥', '*', 0),
 ( '谜奸药', '*', 0),
 ( '蜜穴', '*', 0),
 ( '灭绝罪', '*', 0),
 ( '民储害', '*', 0),
 ( '民九亿商', '*', 0),
 ( '民抗议', '*', 0),
 ( '明慧网', '*', 0),
 ( '铭记印尼', '*', 0),
 ( '摩小姐', '*', 0),
 ( '母乳家', '*', 0),
 ( '木齐针', '*', 0),
 ( '幕没有不', '*', 0),
 ( '幕前戲', '*', 0),
 ( '内射', '*', 0),
 ( '南充针', '*', 0),
 ( '嫩穴', '*', 0),
 ( '嫩阴', '*', 0),
 ( '泥马之歌', '*', 0),
 ( '你的西域', '*', 0),
 ( '拟涛哥', '*', 0),
 ( '娘两腿之间', '*', 0),
 ( '妞上门', '*', 0),
 ( '浓精', '*', 0),
 ( '怒的志愿', '*', 0),
 ( '女被人家搞', '*', 0),
 ( '女激情', '*', 0),
 ( '女技师', '*', 0),
 ( '女人和狗', '*', 0),
 ( '女任职名', '*', 0),
 ( '女上门', '*', 0),
 ( '女優', '*', 0),
 ( '鸥之歌', '*', 0),
 ( '拍肩神药', '*', 0),
 ( '拍肩型', '*', 0),
 ( '牌分析', '*', 0),
 ( '牌技网', '*', 0),
 ( '炮的小蜜', '*', 0),
 ( '陪考枪', '*', 0),
 ( '配有消', '*', 0),
 ( '喷尿', '*', 0),
 ( '嫖俄罗', '*', 0),
 ( '嫖鸡', '*', 0),
 ( '平惨案', '*', 0),
 ( '平叫到床', '*', 0),
 ( '仆不怕饮', '*', 0),
 ( '普通嘌', '*', 0),
 ( '期货配', '*', 0),
 ( '奇迹的黄', '*', 0),
 ( '奇淫散', '*', 0),
 ( '骑单车出', '*', 0),
 ( '气狗', '*', 0),
 ( '气枪', '*', 0),
 ( '汽狗', '*', 0),
 ( '汽枪', '*', 0),
 ( '氣槍', '*', 0),
 ( '铅弹', '*', 0),
 ( '钱三字经', '*', 0),
 ( '枪出售', '*', 0),
 ( '枪的参', '*', 0),
 ( '枪的分', '*', 0),
 ( '枪的结', '*', 0),
 ( '枪的制', '*', 0),
 ( '枪货到', '*', 0),
 ( '枪决女犯', '*', 0),
 ( '枪决现场', '*', 0),
 ( '枪模', '*', 0),
 ( '枪手队', '*', 0),
 ( '枪手网', '*', 0),
 ( '枪销售', '*', 0),
 ( '枪械制', '*', 0),
 ( '枪子弹', '*', 0),
 ( '强权政府', '*', 0),
 ( '强硬发言', '*', 0),
 ( '抢其火炬', '*', 0),
 ( '切听器', '*', 0),
 ( '窃听器', '*', 0),
 ( '禽流感了', '*', 0),
 ( '勤捞致', '*', 0),
 ( '氢弹手', '*', 0),
 ( '清除负面', '*', 0),
 ( '清純壆', '*', 0),
 ( '情聊天室', '*', 0),
 ( '情妹妹', '*', 0),
 ( '情视频', '*', 0),
 ( '情自拍', '*', 0),
 ( '氰化钾', '*', 0),
 ( '氰化钠', '*', 0),
 ( '请集会', '*', 0),
 ( '请示威', '*', 0),
 ( '请愿', '*', 0),
 ( '琼花问', '*', 0),
 ( '区的雷人', '*', 0),
 ( '娶韩国', '*', 0),
 ( '全真证', '*', 0),
 ( '群奸暴', '*', 0),
 ( '群起抗暴', '*', 0),
 ( '群体性事', '*', 0),
 ( '绕过封锁', '*', 0),
 ( '惹的国', '*', 0),
 ( '人权律', '*', 0),
 ( '人体艺', '*', 0),
 ( '人游行', '*', 0),
 ( '人在云上', '*', 0),
 ( '人真钱', '*', 0),
 ( '认牌绝', '*', 0),
 ( '任于斯国', '*', 0),
 ( '柔胸粉', '*', 0),
 ( '肉洞', '*', 0),
 ( '肉棍', '*', 0),
 ( '如厕死', '*', 0),
 ( '乳交', '*', 0),
 ( '软弱的国', '*', 0);
 INSERT `tn_SensitiveWords` ( `Word`, `Replacement`, `TypeId`)
 VALUES
 ( '赛后骚', '*', 0),
 ( '三挫', '*', 0),
 ( '三级片', '*', 0),
 ( '三秒倒', '*', 0),
 ( '三网友', '*', 0),
 ( '三唑', '*', 0),
 ( '骚妇', '*', 0),
 ( '骚浪', '*', 0),
 ( '骚穴', '*', 0),
 ( '骚嘴', '*', 0),
 ( '扫了爷爷', '*', 0),
 ( '色电影', '*', 0),
 ( '色妹妹', '*', 0),
 ( '色视频', '*', 0),
 ( '色小说', '*', 0),
 ( '杀指南', '*', 0),
 ( '山涉黑', '*', 0),
 ( '煽动不明', '*', 0),
 ( '煽动群众', '*', 0),
 ( '上门激', '*', 0),
 ( '烧公安局', '*', 0),
 ( '烧瓶的', '*', 0),
 ( '韶关斗', '*', 0),
 ( '韶关玩', '*', 0),
 ( '韶关旭', '*', 0),
 ( '射网枪', '*', 0),
 ( '涉嫌抄袭', '*', 0),
 ( '深喉冰', '*', 0),
 ( '神七假', '*', 0),
 ( '神韵艺术', '*', 0),
 ( '生被砍', '*', 0),
 ( '生踩踏', '*', 0),
 ( '生肖中特', '*', 0),
 ( '圣战不息', '*', 0),
 ( '盛行在舞', '*', 0),
 ( '尸博', '*', 0),
 ( '失身水', '*', 0),
 ( '失意药', '*', 0),
 ( '狮子旗', '*', 0),
 ( '十八等', '*', 0),
 ( '十大谎', '*', 0),
 ( '十大禁', '*', 0),
 ( '十个预言', '*', 0),
 ( '十类人不', '*', 0),
 ( '十七大幕', '*', 0),
 ( '实毕业证', '*', 0),
 ( '实体娃', '*', 0),
 ( '实学历文', '*', 0),
 ( '士康事件', '*', 0),
 ( '式粉推', '*', 0),
 ( '视解密', '*', 0),
 ( '是躲猫', '*', 0),
 ( '手变牌', '*', 0),
 ( '手答案', '*', 0),
 ( '手狗', '*', 0),
 ( '手机跟', '*', 0),
 ( '手机监', '*', 0),
 ( '手机窃', '*', 0),
 ( '手机追', '*', 0),
 ( '手拉鸡', '*', 0),
 ( '手木仓', '*', 0),
 ( '手槍', '*', 0),
 ( '守所死法', '*', 0),
 ( '兽交', '*', 0),
 ( '售步枪', '*', 0),
 ( '售纯度', '*', 0),
 ( '售单管', '*', 0),
 ( '售弹簧刀', '*', 0),
 ( '售防身', '*', 0),
 ( '售狗子', '*', 0),
 ( '售虎头', '*', 0),
 ( '售火药', '*', 0),
 ( '售假币', '*', 0),
 ( '售健卫', '*', 0),
 ( '售军用', '*', 0),
 ( '售猎枪', '*', 0),
 ( '售氯胺', '*', 0),
 ( '售麻醉', '*', 0),
 ( '售冒名', '*', 0),
 ( '售枪支', '*', 0),
 ( '售热武', '*', 0),
 ( '售三棱', '*', 0),
 ( '售手枪', '*', 0),
 ( '售五四', '*', 0),
 ( '售信用', '*', 0),
 ( '售一元硬', '*', 0),
 ( '售子弹', '*', 0),
 ( '售左轮', '*', 0),
 ( '书办理', '*', 0),
 ( '熟妇', '*', 0),
 ( '术牌具', '*', 0),
 ( '双管立', '*', 0),
 ( '双管平', '*', 0),
 ( '水阎王', '*', 0),
 ( '丝护士', '*', 0),
 ( '丝情侣', '*', 0),
 ( '丝袜保', '*', 0),
 ( '丝袜恋', '*', 0),
 ( '丝袜美', '*', 0),
 ( '丝袜妹', '*', 0),
 ( '丝袜网', '*', 0),
 ( '丝足按', '*', 0),
 ( '司长期有', '*', 0),
 ( '司法黑', '*', 0),
 ( '私房写真', '*', 0),
 ( '死法分布', '*', 0),
 ( '死要见毛', '*', 0),
 ( '四博会', '*', 0),
 ( '四大扯个', '*', 0),
 ( '四小码', '*', 0),
 ( '苏家屯集', '*', 0),
 ( '诉讼集团', '*', 0),
 ( '素女心', '*', 0),
 ( '速代办', '*', 0),
 ( '速取证', '*', 0),
 ( '酸羟亚胺', '*', 0),
 ( '蹋纳税', '*', 0),
 ( '太王四神', '*', 0),
 ( '泰兴幼', '*', 0),
 ( '泰兴镇中', '*', 0),
 ( '泰州幼', '*', 0),
 ( '贪官也辛', '*', 0),
 ( '探测狗', '*', 0),
 ( '涛共产', '*', 0),
 ( '涛一样胡', '*', 0),
 ( '特工资', '*', 0),
 ( '特码', '*', 0),
 ( '特上门', '*', 0),
 ( '体透视镜', '*', 0),
 ( '替考', '*', 0),
 ( '替人体', '*', 0),
 ( '天朝特', '*', 0),
 ( '天鹅之旅', '*', 0),
 ( '天推广歌', '*', 0),
 ( '田罢工', '*', 0),
 ( '田田桑', '*', 0),
 ( '田停工', '*', 0),
 ( '庭保养', '*', 0),
 ( '庭审直播', '*', 0),
 ( '通钢总经', '*', 0),
 ( '偷電器', '*', 0),
 ( '偷肃贪', '*', 0),
 ( '偷听器', '*', 0),
 ( '偷偷贪', '*', 0),
 ( '头双管', '*', 0),
 ( '透视功能', '*', 0),
 ( '透视镜', '*', 0),
 ( '透视扑', '*', 0),
 ( '透视器', '*', 0),
 ( '透视眼镜', '*', 0),
 ( '透视药', '*', 0),
 ( '透视仪', '*', 0),
 ( '秃鹰汽', '*', 0),
 ( '突破封锁', '*', 0),
 ( '突破网路', '*', 0),
 ( '推油按', '*', 0),
 ( '脱衣艳', '*', 0),
 ( '瓦斯手', '*', 0),
 ( '袜按摩', '*', 0),
 ( '外透视镜', '*', 0),
 ( '外围赌球', '*', 0),
 ( '湾版假', '*', 0),
 ( '万能钥匙', '*', 0),
 ( '万人骚动', '*', 0),
 ( '王立军', '*', 0),
 ( '王益案', '*', 0),
 ( '网民案', '*', 0),
 ( '网民获刑', '*', 0),
 ( '网民诬', '*', 0),
 ( '微型摄像', '*', 0),
 ( '围攻警', '*', 0),
 ( '围攻上海', '*', 0),
 ( '维汉员', '*', 0),
 ( '维权基', '*', 0),
 ( '维权人', '*', 0),
 ( '维权谈', '*', 0),
 ( '委坐船', '*', 0),
 ( '谓的和谐', '*', 0),
 ( '温家堡', '*', 0),
 ( '温切斯特', '*', 0),
 ( '温影帝', '*', 0),
 ( '溫家寶', '*', 0),
 ( '瘟加饱', '*', 0),
 ( '瘟假饱', '*', 0),
 ( '文凭证', '*', 0),
 ( '文强', '*', 0),
 ( '纹了毛', '*', 0),
 ( '闻被控制', '*', 0),
 ( '闻封锁', '*', 0),
 ( '瓮安', '*', 0),
 ( '我的西域', '*', 0),
 ( '我搞台独', '*', 0),
 ( '乌蝇水', '*', 0),
 ( '无耻语录', '*', 0),
 ( '无码专', '*', 0),
 ( '五套功', '*', 0),
 ( '五月天', '*', 0),
 ( '午夜电', '*', 0),
 ( '午夜极', '*', 0),
 ( '武警暴', '*', 0),
 ( '武警殴', '*', 0),
 ( '武警已增', '*', 0),
 ( '务员答案', '*', 0),
 ( '务员考试', '*', 0),
 ( '雾型迷', '*', 0),
 ( '西藏限', '*', 0),
 ( '西服进去', '*', 0),
 ( '希脏', '*', 0),
 ( '习进平', '*', 0),
 ( '习晋平', '*', 0),
 ( '席复活', '*', 0),
 ( '席临终前', '*', 0),
 ( '席指着护', '*', 0),
 ( '洗澡死', '*', 0),
 ( '喜贪赃', '*', 0),
 ( '先烈纷纷', '*', 0),
 ( '现大地震', '*', 0),
 ( '现金投注', '*', 0),
 ( '线透视镜', '*', 0),
 ( '限制言', '*', 0),
 ( '陷害案', '*', 0),
 ( '陷害罪', '*', 0),
 ( '相自首', '*', 0),
 ( '香港论坛', '*', 0),
 ( '香港马会', '*', 0),
 ( '香港一类', '*', 0),
 ( '香港总彩', '*', 0),
 ( '硝化甘', '*', 0),
 ( '小穴', '*', 0),
 ( '校骚乱', '*', 0),
 ( '协晃悠', '*', 0),
 ( '写两会', '*', 0),
 ( '泄漏的内', '*', 0),
 ( '新建户', '*', 0),
 ( '新疆叛', '*', 0),
 ( '新疆限', '*', 0),
 ( '新金瓶', '*', 0),
 ( '新唐人', '*', 0),
 ( '信访专班', '*', 0),
 ( '信接收器', '*', 0),
 ( '兴中心幼', '*', 0),
 ( '星上门', '*', 0),
 ( '行长王益', '*', 0),
 ( '形透视镜', '*', 0),
 ( '型手枪', '*', 0),
 ( '姓忽悠', '*', 0),
 ( '幸运码', '*', 0),
 ( '性爱日', '*', 0),
 ( '性福情', '*', 0),
 ( '性感少', '*', 0),
 ( '性推广歌', '*', 0),
 ( '胸主席', '*', 0),
 ( '徐玉元', '*', 0),
 ( '学骚乱', '*', 0),
 ( '学位證', '*', 0),
 ( '學生妹', '*', 0),
 ( '丫与王益', '*', 0),
 ( '烟感器', '*', 0),
 ( '严晓玲', '*', 0),
 ( '言被劳教', '*', 0),
 ( '言论罪', '*', 0),
 ( '盐酸曲', '*', 0),
 ( '颜射', '*', 0),
 ( '恙虫病', '*', 0),
 ( '姚明进去', '*', 0),
 ( '要人权', '*', 0),
 ( '要射精了', '*', 0),
 ( '要射了', '*', 0),
 ( '要泄了', '*', 0),
 ( '夜激情', '*', 0),
 ( '液体炸', '*', 0),
 ( '一小撮别', '*', 0),
 ( '遗情书', '*', 0),
 ( '蚁力神', '*', 0),
 ( '益关注组', '*', 0),
 ( '益受贿', '*', 0),
 ( '阴间来电', '*', 0),
 ( '陰唇', '*', 0),
 ( '陰道', '*', 0),
 ( '陰戶', '*', 0),
 ( '淫魔舞', '*', 0),
 ( '淫情女', '*', 0),
 ( '淫肉', '*', 0),
 ( '淫騷妹', '*', 0),
 ( '淫兽', '*', 0),
 ( '淫兽学', '*', 0),
 ( '淫水', '*', 0),
 ( '淫穴', '*', 0),
 ( '隐形耳', '*', 0),
 ( '隐形喷剂', '*', 0),
 ( '应子弹', '*', 0),
 ( '婴儿命', '*', 0),
 ( '咏妓', '*', 0),
 ( '用手枪', '*', 0),
 ( '幽谷三', '*', 0),
 ( '游精佑', '*', 0),
 ( '有奶不一', '*', 0),
 ( '右转是政', '*', 0),
 ( '幼齿类', '*', 0),
 ( '娱乐透视', '*', 0),
 ( '愚民同', '*', 0),
 ( '愚民政', '*', 0),
 ( '与狗性', '*', 0),
 ( '玉蒲团', '*', 0),
 ( '育部女官', '*', 0),
 ( '冤民大', '*', 0),
 ( '鸳鸯洗', '*', 0),
 ( '园惨案', '*', 0),
 ( '园发生砍', '*', 0),
 ( '园砍杀', '*', 0),
 ( '园凶杀', '*', 0),
 ( '园血案', '*', 0),
 ( '原一九五七', '*', 0),
 ( '原装弹', '*', 0),
 ( '袁腾飞', '*', 0),
 ( '晕倒型', '*', 0),
 ( '韵徐娘', '*', 0),
 ( '遭便衣', '*', 0),
 ( '遭到警', '*', 0),
 ( '遭警察', '*', 0),
 ( '遭武警', '*', 0),
 ( '择油录', '*', 0),
 ( '曾道人', '*', 0),
 ( '炸弹教', '*', 0),
 ( '炸弹遥控', '*', 0),
 ( '炸广州', '*', 0),
 ( '炸立交', '*', 0),
 ( '炸药的制', '*', 0),
 ( '炸药配', '*', 0),
 ( '炸药制', '*', 0),
 ( '张春桥', '*', 0),
 ( '找枪手', '*', 0),
 ( '找援交', '*', 0),
 ( '找政法委副', '*', 0),
 ( '赵紫阳', '*', 0),
 ( '针刺案', '*', 0),
 ( '针刺伤', '*', 0),
 ( '针刺事', '*', 0),
 ( '针刺死', '*', 0),
 ( '侦探设备', '*', 0),
 ( '真钱斗地', '*', 0),
 ( '真钱投注', '*', 0),
 ( '真善忍', '*', 0),
 ( '真实文凭', '*', 0),
 ( '真实资格', '*', 0),
 ( '震惊一个民', '*', 0),
 ( '震其国土', '*', 0),
 ( '证到付款', '*', 0),
 ( '证件办', '*', 0),
 ( '证件集团', '*', 0),
 ( '证生成器', '*', 0),
 ( '证书办', '*', 0),
 ( '证一次性', '*', 0),
 ( '政府操', '*', 0),
 ( '政论区', '*', 0),
 ( '證件', '*', 0),
 ( '植物冰', '*', 0),
 ( '殖器护', '*', 0),
 ( '指纹考勤', '*', 0),
 ( '指纹膜', '*', 0),
 ( '指纹套', '*', 0),
 ( '至国家高', '*', 0),
 ( '志不愿跟', '*', 0),
 ( '制服诱', '*', 0),
 ( '制手枪', '*', 0),
 ( '制证定金', '*', 0),
 ( '制作证件', '*', 0),
 ( '中的班禅', '*', 0),
 ( '中共黑', '*', 0),
 ( '中国不强', '*', 0),
 ( '种公务员', '*', 0),
 ( '种学历证', '*', 0),
 ( '众像羔', '*', 0),
 ( '州惨案', '*', 0),
 ( '州大批贪', '*', 0),
 ( '州三箭', '*', 0),
 ( '宙最高法', '*', 0),
 ( '昼将近', '*', 0),
 ( '主席忏', '*', 0),
 ( '住英国房', '*', 0),
 ( '助考', '*', 0),
 ( '助考网', '*', 0),
 ( '专业办理', '*', 0),
 ( '专业代', '*', 0),
 ( '专业代写', '*', 0),
 ( '专业助', '*', 0),
 ( '转是政府', '*', 0),
 ( '赚钱资料', '*', 0);
 INSERT `tn_SensitiveWords` ( `Word`, `Replacement`, `TypeId`)
 VALUES
 ( '装弹甲', '*', 0),
 ( '装枪套', '*', 0),
 ( '装消音', '*', 0),
 ( '着护士的胸', '*', 0),
 ( '着涛哥', '*', 0),
 ( '姿不对死', '*', 0),
 ( '资格證', '*', 0),
 ( '资料泄', '*', 0),
 ( '梓健特药', '*', 0),
 ( '字牌汽', '*', 0),
 ( '自己找枪', '*', 0),
 ( '自慰用', '*', 0),
 ( '自由圣', '*', 0),
 ( '自由亚', '*', 0),
 ( '总会美女', '*', 0),
 ( '足球玩法', '*', 0),
 ( '最牛公安', '*', 0),
 ( '醉钢枪', '*', 0),
 ( '醉迷药', '*', 0),
 ( '醉乙醚', '*', 0),
 ( '尊爵粉', '*', 0),
 ( '左转是政', '*', 0),
 ( '作弊器', '*', 0),
 ( '作各种证', '*', 0),
 ( '作硝化甘', '*', 0),
 ( '唑仑', '*', 0),
 ( '做爱小', '*', 0),
 ( '做原子弹', '*', 0),
 ( '做证件', '*', 0);