﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.DALFactory;
using goodHelper.Model;
using goodHelper.BLL;

namespace goodHelper.Web
{
    public partial class List : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int pagesize = 50;
                string strWhere="";
                string cid = StringFormat.GetQuerystring("fid");
                if (cid != "")
                {
                    strWhere += " classid=" + cid;
                }
                else
                {
                    Response.Redirect("default.aspx");
                }
                int page;
                if(StringFormat.IsNumber(StringFormat.GetQuerystring("p")))
                {
                    page=int.Parse(StringFormat.GetQuerystring("p"));
                }
                else
                {
                    page=1;
                }

                BLL.gf_Class cbll = new goodHelper.BLL.gf_Class();
                Model.gf_Class model = cbll.GetModel(int.Parse(cid));
                int AllCount = model.themeCount;
                //计算页数
                int allPage = AllCount / pagesize;
                if ((AllCount % pagesize) > 0)
                {
                    allPage++;
                }
                if (AllCount == 0)
                {
                    allPage = 1;
                }
                if (page < 1)
                {
                    page = 1;
                }
                if (page > allPage)
                {
                    page = allPage;
                }
                PageTopShow.InnerHtml = "<input  type=\"button\" class=\"but_new\" value=\"\" onclick=\"window.location='Post.aspx?fid=" + cid + "'\" onmouseover=\"this.className='but_new  but_new_h'\" onmouseout=\"this.className='but_new'\" />\n";
                //分页控制
                PageTopShow.InnerHtml += "<span>总贴数：<font class=\"forange\">" + AllCount.ToString() + "</font>篇</span>\n<span class=\"pgs\">";
                if (page > 1)
                {
                    PageTopShow.InnerHtml += "<a class=\"pages_next\" href=\"List.aspx?fid=" + cid + "&p=" + (page - 1).ToString() + "\">上一页</a>\n";
                }
                //上导航2页
                for (int i = 2; i > 0; i--)
                {
                    if ((page - i) > 0)
                    {
                        PageTopShow.InnerHtml += "<a  href=\"List.aspx?fid=" + cid + "&p=" + (page - i).ToString() + "\" >" + (page - i).ToString() + "</a>\n";
                    }
                }

                PageTopShow.InnerHtml += "<a class='pcurr' >" + page.ToString() + "</a>\n";


                //下导航2页
                for (int i = 1; i < 3; i++)
                {
                    if ((page + i) <= allPage)
                    {
                        PageTopShow.InnerHtml += "<a href=\"List.aspx?fid=" + cid + "&p=" + (page + i).ToString() + "\" >" + (page + i).ToString() + "</a>\n";
                    }
                }
                //下一页
                if ((page+1)<=allPage)
                {
                    PageTopShow.InnerHtml += "<a class=\"pages_next\" href=\"List.aspx?fid=" + cid + "&p=" + (page + 1).ToString() + "\">下一页</a></span>\n";
                }

                PageTopShow.InnerHtml += "</span>";
                PageTopShow.InnerHtml += "<span>第<input type=\"text\" size=\"3\" class='ipt_pg' />页&nbsp;<a style=\"cursor: pointer\" class='btn_go' onclick=\"javascript:var value = parseInt(this.previousSibling.previousSibling.value); var page=(value>" + allPage + ") ? " + allPage + " : value;  location='/list.aspx?fid=" + cid + "&p='+page+''; return false;\">GO</a></span>";

                PageDownShow.InnerHtml = PageTopShow.InnerHtml;

                BLL.gf_F bll = new goodHelper.BLL.gf_F();

                DataTable dt = bll.GetList(pagesize, page, strWhere);
                datalistF.DataSource = dt.DefaultView;
                datalistF.DataBind();
            }
        }

        protected string GetState(bool isAllTop, bool isTop, bool isWonderful)
        {
            string returnStr = "";
            if (isAllTop)
            {
                returnStr += "[总置顶]";
            }
            else
            {
                if (isTop)
                {
                    returnStr += "[置顶]";
                }
            }
            if (isWonderful)
            {
                returnStr += "[精华]";
            }
            return returnStr;
        }

        protected string StateImg(int hits, int replays)
        {
            if (replays == 0)
            {
                return "<img src=\"images/i_nor.gif\">";
            }
            else
            {
                if (hits > 2000 && replays > 50)
                {
                    return "<img src=\"images/i_hot.gif\">";
                }
                else
                {
                    return "<img src=\"images/i_new.gif\">";
                }
            }
        }
    }
}
