﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.DALFactory;
using goodHelper.Model;
using goodHelper.BLL;

namespace goodHelper.Web
{
    public partial class Login : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["act"] != null)
            {
                if (Request.QueryString["act"].ToString() == "out")
                {
                    Response.Cookies["userInfo"].Expires = DateTime.Now.AddDays(-1);
                    Response.Redirect("default.aspx");
                }
            }
        }
        protected void btn_Login_Click(object sender, EventArgs e)
        {
            string vali = txt_vali.Text;
            if (!Session["validateCode"].Equals(vali))
            {
                lab_ErrMsg.Text = "不正确的验证码！";
                Response.End();
            }
            string loginID = StringFormat.FormatHtml(txt_loginID.Text);
            string password = StringFormat.FormatHtml(txt_password.Text);

            string strSql = string.Format("select id from gf_UserLogin where loginid='{0}' and password='{1}'",loginID,StringFormat.MD5(password));
            DataTable dt = DataOperate.CreateDAL_DBO().GetExecuteNonQuery_DataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                long userid = long.Parse(dt.Rows[0]["id"].ToString());
                BLL.gf_UserInfo bll = new goodHelper.BLL.gf_UserInfo();
                Model.gf_UserInfo model = bll.GetModel(userid);
                if (model.userid.ToString() == "")
                {
                    //用户没有开通论坛功能，让他去输昵称
                    Response.Redirect("");
                }
                //写Cookies
                HttpCookie cookies = new HttpCookie("userInfo");
                cookies.Values["userID"] = model.userid.ToString();
                cookies.Values["userName"] = model.userName;
                cookies.Values["userGroup"] = model.userGroup.ToString();
                cookies.Values["userLevel"] = model.userLevel.ToString();
                cookies.Values["userPower"] = model.userPower;
                Response.Cookies.Add(cookies);

                //更新最后活动时间
                DataOperate.CreateDAL_DBO().GetExecuteNonQuery_Int("update gf_UserInfo set lastDate=getdate() where userid="+model.userid.ToString());
                Response.Redirect("Default.aspx");
            }
            else
            {
                lab_ErrMsg.Text = "用户名或密码不正确！";
            }
        }
}
}
