﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.DALFactory;
using goodHelper.BLL;
using goodHelper.Model;
using System.Xml;

namespace goodHelper.Web
{
    public partial class Page : System.Web.UI.MasterPage
    {
        string classid = StringFormat.GetQuerystring("fid");
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (htm_Nav.Text == "")
                {
                    htm_Nav.Text = "<a href=\"default.aspx\" class=\"ghome\">论坛首页</a>";
                    if (StringFormat.IsNumber(classid))
                    {
                        BLL.gf_Class bll = new goodHelper.BLL.gf_Class();
                        Model.gf_Class model = bll.GetModel(int.Parse(classid));
                        DataTable dt = DataOperate.CreateDAL_DBO().GetExecuteNonQuery_DataTable("select classid,className from gf_Class where classid in (" + model.parentStr + ") order by orders");
                        for (int i = 0; dt.Rows.Count > i; i++)
                        {
                            htm_Nav.Text += " > <a href=\"List.aspx?fid=" + dt.Rows[i]["classid"].ToString() + "\" class=\"ghome\">" + dt.Rows[i]["className"].ToString() + "</a>";
                        }

                        htm_Nav.Text += " > <a class=\"ghome\">" + model.className + "</a>";
                    }
                }
                XmlDocument xmldoc = XmlOperate.LoadXml("SiteBase.config");
                Base.SetPageInfo(Page, XmlOperate.GetNodeListValue(xmldoc, "webName"), XmlOperate.GetNodeListValue(xmldoc, "keywords"), XmlOperate.GetNodeListValue(xmldoc, "description"), "");

                //加载用户身份
                HttpCookie cookies;
                if (Request.Cookies["userInfo"] != null)
                {
                    cookies = Request.Cookies["userInfo"];
                    user_info.InnerHtml = "欢迎回来：<strong>" + cookies["userName"].ToString() + "</strong> <em>|</em> <a href=\"userCenter.aspx\">用户中心</a>  <em>|</em> <a href=\"login.aspx?act=out\">退出</a>  <em>|</em>";
                }
                else
                {
                    user_info.InnerHtml = "欢迎您：<strong>游客</strong> <em>|</em> <a href=\"login.aspx\">登录</a>  <em>|</em>  <a href=\"reg.aspx\">注册</a> <em>|</em>";
                }
            }
        }
    }
}
