﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.DALFactory;
using goodHelper.Model;
using goodHelper.BLL;

namespace goodHelper.Web
{
    public partial class Post : System.Web.UI.Page
    {
        public HttpCookie cookies;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.Cookies["userInfo"] != null)
            {
                cookies = Request.Cookies["userInfo"];
            }
            else
            {
                Response.Redirect("login.aspx");
            }
            if (!IsPostBack)
            {
                try
                {
                    BLL.gf_Class bll = new goodHelper.BLL.gf_Class();
                    Model.gf_Class model = bll.GetModel(int.Parse(Request.QueryString["fid"].ToString()));
                    if (model.classId.ToString() == "")
                    {
                        MessageBox.AlertUrl("出错了！", "default.aspx");
                    }
                    hidden_classid.Value = model.classId.ToString();
                    lab_className.Text = model.className;
                }
                catch
                {

                    MessageBox.AlertUrl("出错了！", "default.aspx");
                }
            }
        }

        protected void btn_Save_Click(object sender, EventArgs e)
        {
            string vali = txt_vali.Text;
            if (Session["validateCode"].Equals(null))
            {
                MessageBox.Alert("验证码过期，点击验证码更换后重新输入！");
                return;                
            }
            if (!Session["validateCode"].Equals(vali))
            {
                MessageBox.Alert("不正确的验证码！");
                return;
            }
            Model.gf_F model = new goodHelper.Model.gf_F();

            string title = StringFormat.FormatHtml(txt_title.Text);
            string content = StringFormat.FormatHtml(editorContent.Value);
            if (title.Length < 10 || title.Length > 200)
            {
                MessageBox.Alert("标题不能为空，且不能超过100字！");
                return;
            }
            if (content.Length < 10)
            {
                MessageBox.Alert("内容不能少于10字！");
                return;
            }


            model.title = title;
            model.contents = content;
            model.classid = int.Parse(hidden_classid.Value);
            model.userid = long.Parse(cookies["userID"].ToString());
            model.username = cookies["userName"].ToString();
            model.addtime = DateTime.Now;
            model.hits = 0;
            model.replays = 0;
            model.isAllTop = false;
            model.isTop = false;
            model.isWonderful = false;
            model.lastReTime = DateTime.Now;
            model.lastReUser = "";
            model.lastReUserID = 0;

            BLL.gf_F bll = new goodHelper.BLL.gf_F();
            bll.Add(model);
            MessageBox.AlertUrl("发表成功", "List.aspx?cid="+model.classid.ToString());

        }
    }
}
