﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.Model;
using goodHelper.BLL;

namespace goodHelper.Web.SysAdmin
{
    public partial class ClassAdd : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            CheckPower.CheckAdminPower();
            if (!IsPostBack)
            {
                goodHelper.Model.gf_Class model = new goodHelper.Model.gf_Class();
                goodHelper.BLL.gf_Class bll = new goodHelper.BLL.gf_Class();
                if (StringFormat.GetQuerystring("action") == "edit")
                {
                    if (StringFormat.GetQuerystring("classID") == "")
                    {
                        MessageBox.AlertUrl("修改出错", "ClassManage.aspx");
                    }
                    model = bll.GetModel(int.Parse(StringFormat.GetQuerystring("classID")));
                    hiddenAction.Value = "edit";
                    hiddenParentID.Value = model.parentID.ToString();
                    hiddenClassID.Value = model.classId.ToString();
                    if (model.parentID == 0)
                    {
                        labParentName.Text = "无上级分类（顶级）";
                    }
                    else
                    {
                        Model.gf_Class parentModel = bll.GetModel(model.parentID);
                        labParentName.Text = parentModel.className;
                        parentModel = null;
                    }
                    txtClassName.Text = model.className;
                    txtDescription.Text = StringFormat.Invert(model.description);
                    hiddenImgUrl.Value = model.ImgUrl;
                    imgPreview.Src = model.ImgUrl;

                    labPageTitle.Text = "修改论坛版块";
                    btn_Save.Text = "保存修改";
                }
                else
                {
                    hiddenAction.Value = "add";
                    if (StringFormat.GetQuerystring("parentID") == "")
                    {
                        this.hiddenParentID.Value = "0";
                        labParentName.Text = "无上级分类（顶级）";
                    }
                    else
                    {
                        model = bll.GetModel(int.Parse(StringFormat.GetQuerystring("parentID")));
                        this.hiddenParentID.Value = model.classId.ToString();
                        labParentName.Text = model.className;
                    }
                }
            }
        }
        protected void btn_UpLoad_Click(object sender, EventArgs e)
        {
            string[] ImgUrl = UploadFile.SaveFile(upfile.PostedFile);
            if (ImgUrl[0] == "1")
            {
                hiddenImgUrl.Value = ImgUrl[1];
                imgPreview.Src = ImgUrl[1];
                labUpImgErrMsg.Text = "";
            }
            else
            {
                hiddenImgUrl.Value = "";
                labUpImgErrMsg.Text = ImgUrl[1];
            }
        }
        protected void btn_Save_Click(object sender, EventArgs e)
        {
            bool DataVali = false;
            if (txtClassName.Text.Length > 20)
            {
                labClassNameErrMsg.Text = "<font color=red>添加的内容长度不能超过20字！</font>";
                DataVali = true;
            }
            if (txtDescription.Text.Length > 500)
            {
                labDescriptionErrMsg.Text = "<font color=red>描述的内容长度不能超过500字！</font>";
                DataVali = true;
            }
            if (DataVali)
            {
                return;
            }
            BLL.gf_Class bll = new goodHelper.BLL.gf_Class();
            Model.gf_Class model = new goodHelper.Model.gf_Class();

            if (hiddenAction.Value == "edit")
            { 
                model = bll.GetModel(int.Parse(hiddenClassID.Value));
                model.className = txtClassName.Text;
                model.ImgUrl = hiddenImgUrl.Value;
                model.description = StringFormat.FormatHtml(txtDescription.Text);
                bll.Update(model);
                MessageBox.AlertUrl("修改成功","ClassManage.aspx");
            }
            else //添加
            {
                model.parentID = int.Parse(hiddenParentID.Value);
                model.className = txtClassName.Text;
                model.ImgUrl = hiddenImgUrl.Value;
                model.description = StringFormat.FormatHtml(txtDescription.Text);
                //默认数据
                model.lastThemeID = 0;
                model.managerUserID = "";
                model.themeCount = 0;
                model.replyCount = 0;

                bll.Add(model);
                MessageBox.AlertUrl("添加成功","ClassManage.aspx");
            }

        }
    }
}
