﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.Model;
using goodHelper.DALFactory;
using goodHelper.BLL;

namespace goodHelper.Web.SysAdmin
{
    public partial class F_Manage : System.Web.UI.Page
    {
        public int pagesize = 20;
        protected void Page_Load(object sender, EventArgs e)
        {
            CheckPower.CheckAdminPower();
            if (!IsPostBack)
            {
                GetCountPage();
                FDataBind(1);
            }
        }

        protected void GetCountPage()
        {
            string keywords = StringFormat.FormatHtml(hidden_SearchTxt.Value);
            int Counts = (int)DataOperate.CreateDAL_DBO().GetSingle("select count(fid) from gf_F where title like '%"+keywords+"%'");
            int PageCount = Counts % pagesize == 0 ? Counts / pagesize : (Counts / pagesize) + 1;
            lab_DataCount.Text = Counts.ToString();
            lab_PageCount.Text = PageCount.ToString();

            if (PageCount == 0 || PageCount == 1)
            {
                btn_UpperPage.Enabled = false;
                btn_LowerPage.Enabled = false;
                txt_JumpPage.ReadOnly = true;
                btn_JumpPage.Enabled = false;
            }
            else
            {
                btn_UpperPage.Enabled = true;
                btn_LowerPage.Enabled = true;
                txt_JumpPage.ReadOnly = false;
                btn_JumpPage.Enabled = true;
            }
        }

        protected void FDataBind(int pageIndex)
        {
            string keywords = StringFormat.FormatHtml(hidden_SearchTxt.Value);
            string strWhere = "";
            if (keywords != "")
            {
                strWhere = " title like '%" + keywords + "%'";
            }
            BLL.gf_F bll = new goodHelper.BLL.gf_F();
            DataTable  dt = bll.GetList(pagesize, pageIndex, strWhere);
            datalistF.DataSource = dt.DefaultView;
            datalistF.DataBind();
        }

        protected void btn_Search_Click(object sender, EventArgs e)
        {
            hidden_SearchTxt.Value = txt_Search.Text.Trim();
            GetCountPage();
            FDataBind(1);
        }

        protected void btn_JumpPage_Click(object sender, EventArgs e)
        {
            int pageCount = int.Parse(lab_PageCount.Text.ToString());
            int pageIndex = int.Parse(lab_PageIndex.Text.ToString());
            int pageIndexTemp = 1;
            bool jumpFlag = false;
            try
            {
                pageIndexTemp = int.Parse(txt_JumpPage.Text.ToString());
                jumpFlag = true;
            }
            catch (Exception ex)
            {
                jumpFlag = false;
            }
            if (jumpFlag)
            {
                if (pageIndexTemp > pageCount)
                {
                    pageIndexTemp = pageCount;
                }
                else if (pageIndexTemp < 1)
                {
                    pageIndexTemp = 1;
                }
                if (pageIndex != pageIndexTemp)
                {
                    FDataBind(pageIndexTemp);
                }
            }
        }

        protected void btn_UpperPage_Click(object sender, EventArgs e)
        {
            int pageIndex = int.Parse(lab_PageIndex.Text.ToString());
            if (pageIndex > 1)
            {
                pageIndex--;
                FDataBind(pageIndex);
            }
        }

        protected void btn_LowerPage_Cilck(object sender, EventArgs e)
        {
            int pageCount = int.Parse(lab_PageCount.Text.ToString());
            int pageIndex = int.Parse(lab_PageIndex.Text.ToString());
            if (pageIndex < pageCount)
            {
                pageIndex++;
                FDataBind(pageIndex);
            }
        }


        protected void datalistF_ItemCommand(object source, DataListCommandEventArgs e)
        {
            switch (e.CommandName)
            {
                case "show":
                    Response.Redirect("show.aspx?id=" + e.CommandArgument.ToString());
                    break;
                case "update":
                    Response.Redirect("f_update.aspx?fid="+e.CommandArgument.ToString());
                    break;
                case "delete":
                    Delete_F(e.CommandArgument.ToString());
                    break;

            }
        }

        protected void Delete_F(string fid)
        {
            BLL.gf_F bll = new goodHelper.BLL.gf_F();

            bll.Delete(long.Parse(fid));
        }
    }
}
