﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.DALFactory;
using goodHelper.BLL;
using goodHelper.Model;

namespace goodHelper.Web.SysAdmin
{
    public partial class F_Update : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            CheckPower.CheckAdminPower();
            if (!IsPostBack)
            {
                string fid = StringFormat.GetQuerystring("fid");
                if (!StringFormat.IsNumber(fid))
                {
                    MessageBox.AlertUrl("fid不正确！", "AdminIndexMain.aspx");
                }
                BLL.gf_F bll = new goodHelper.BLL.gf_F();
                Model.gf_F model = bll.GetModel(long.Parse(fid));
                txtTitle.Text = StringFormat.Invert(model.title);
                hidden_fid.Value = fid;
                chk_IsAllTop.Checked = model.isAllTop;
                chk_IsTop.Checked = model.isTop;
                chk_IsWonderful.Checked = model.isWonderful;
                editorContent.Value = StringFormat.Invert(model.contents);
            }
        }


        protected void btn_Save_Click(object sender, EventArgs e)
        {
            long fid = long.Parse(hidden_fid.Value);
            BLL.gf_F bll = new goodHelper.BLL.gf_F();

            Model.gf_F model = bll.GetModel(fid);

            if (txtTitle.Text.Length > 500)
            {
                MessageBox.Alert("标题太长了");
            }
            model.title = StringFormat.FormatHtml(txtTitle.Text);
            model.contents = StringFormat.FormatHtml(editorContent.Value);
            model.isAllTop = chk_IsAllTop.Checked;
            model.isTop = chk_IsTop.Checked;
            model.isWonderful = chk_IsWonderful.Checked;

            bll.Update(model);

            MessageBox.AlertUrl("修改成功！", "F_Manage.aspx");
        }
    }
}
