﻿<%@ webhandler Language="C#" class="Upload" %>

/**
 * KindEditor ASP.NET
 *
 * 本ASP.NET程序是演示程序，建议不要直接在实际项目中使用。
 * 如果您确定直接使用本程序，使用之前请仔细确认相关安全设置。
 *
 */

using System;
using System.Collections;
using System.Web;
using System.Xml;
using System.IO;
using System.Globalization;
using LitJson;
using goodHelper.Common;

public class Upload : IHttpHandler
{
	private HttpContext context;

	public void ProcessRequest(HttpContext context)
	{
        String dirPaths = context.Request.QueryString["rootPath"].ToString();

        String aspxUrl = "/";
                
        //文件保存目录路径
        String savePath = dirPaths;
		//文件保存目录URL
        String saveUrl = aspxUrl + dirPaths;
		//定义允许上传的文件扩展名
		Hashtable extTable = new Hashtable();
        extTable.Add("image", "gif|jpg|jpeg|png|bmp");
        extTable.Add("flash", "swf|flv");
        extTable.Add("media", "swf|flv|mp3|wav|wma|wmv|mid|avi|mpg|asf|rm|rmvb");
        extTable.Add("file", "doc|docx|xls|xlsx|ppt|htm|html|txt|zip|rar|gz|bz2");

		//最大文件大小 单位K
        int maxSize = 500;
		this.context = context;
        
		HttpPostedFile imgFile = context.Request.Files["imgFile"];
		if (imgFile == null)
		{
			showError("请选择文件。");
        }
        
        String dirPath = context.Server.MapPath("~/" + dirPaths);

        String dirName = context.Request.QueryString["dir"];
        
        if (String.IsNullOrEmpty(dirName))
        {
            dirName = "image";
        }
        if (!extTable.ContainsKey(dirName))
        {
            showError("目录名不正确。");
        }
        
        /*
         * 水印设置的 修改于：2012年6月21日 下午
         * 修改者：Sam QQ：18283778
         * 取系统设置后，添加水印
         */


        string[] uploadReturn;
        if (dirName == "image")
        {
            XmlDocument xmldoc = XmlOperate.LoadXml("../SiteBase.config");
            string waterSet = XmlOperate.GetNodeListValue(xmldoc, "WaterSet");
            string waterTxt = XmlOperate.GetNodeListValue(xmldoc, "WaterTxt");


            switch (waterSet)
            {
                case "no":
                    uploadReturn = UploadFile.SaveFile(imgFile, dirPaths, (String)extTable[dirName], maxSize, null, null);
                    break;
                case "txt":
                    uploadReturn = UploadFile.SaveFile(imgFile, dirPaths, (String)extTable[dirName], maxSize, waterTxt, null);
                    break;
                case "img":
                    uploadReturn = UploadFile.SaveFile(imgFile, dirPaths, (String)extTable[dirName], maxSize, null, waterTxt);
                    break;
                default:
                    uploadReturn = UploadFile.SaveFile(imgFile, dirPaths, (String)extTable[dirName], maxSize, null, null);
                    break;
            }
        }
        else
        {
            uploadReturn = UploadFile.SaveFile(imgFile, dirPaths, (String)extTable[dirName], maxSize, null, null);
        }
        if (uploadReturn[0] == "0")
        {
            showError(uploadReturn[1]);
        }
        
        //String fileName = imgFile.FileName;
        //String fileExt = Path.GetExtension(fileName).ToLower();

        //if (imgFile.InputStream == null || imgFile.InputStream.Length > maxSize)
        //{
        //    showError("上传文件大小超过限制。");
        //}

        //if (String.IsNullOrEmpty(fileExt) || Array.IndexOf(((String)extTable[dirName]).Split(','), fileExt.Substring(1).ToLower()) == -1)
        //{
        //    showError("上传文件扩展名是不允许的扩展名。\n只允许" + ((String)extTable[dirName]) + "格式。");
        //}

        ////创建文件夹
        //dirPath += dirName + "\\";
        //saveUrl += dirName + "/";
        //if (!Directory.Exists(dirPath)) {
        //    Directory.CreateDirectory(dirPath);
        //}

        //if (!Directory.Exists(dirPath))
        //{
        //    showError("上传目录不存在。");
        //}
                
        //String ymd = DateTime.Now.ToString("yyyyMMdd", DateTimeFormatInfo.InvariantInfo);
        //dirPath += ymd + "\\";
        //saveUrl += ymd + "/";
        //if (!Directory.Exists(dirPath)) {
        //    Directory.CreateDirectory(dirPath);
        //}

        //String newFileName = DateTime.Now.ToString("yyyyMMddHHmmss_ffff", DateTimeFormatInfo.InvariantInfo) + fileExt;
        //String filePath = dirPath + newFileName;

        //imgFile.SaveAs(filePath);

        //String fileUrl = saveUrl + newFileName;

        
		Hashtable hash = new Hashtable();
		hash["error"] = 0;
        hash["url"] = uploadReturn[1];
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}

	private void showError(string message)
	{
		Hashtable hash = new Hashtable();
		hash["error"] = 1;
        hash["message"] = message;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}

	public bool IsReusable
	{
		get
		{
			return true;
		}
	}
}
