﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.DALFactory;
using goodHelper.Model;
using goodHelper.BLL;

namespace goodHelper.Web
{
    public partial class reply : System.Web.UI.Page
    {
        public HttpCookie cookies;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.Cookies["userInfo"] != null)
            {
                cookies = Request.Cookies["userInfo"];
            }
            else
            {
                Response.Redirect("login.aspx");
            }
            if (!IsPostBack)
            {
                try
                {
                    BLL.gf_F bll = new goodHelper.BLL.gf_F();
                    Model.gf_F model = bll.GetModel(long.Parse(Request.QueryString["pid"].ToString()));
                    if (model.fid.ToString() == "")
                    {
                        MessageBox.AlertUrl("出错了！", "default.aspx");
                    }
                    hidden_fid.Value = model.fid.ToString();
                    hidden_classid.Value = model.classid.ToString();

                    txt_title.Text = "Re:" + model.title;
                }
                catch
                {
                    Response.Redirect("Error.htm");
                }
            }

        }
        protected void btn_Save_Click(object sender, EventArgs e)
        {
            string vali = txt_vali.Text;
            if (Session["validateCode"]==null)
            {
                MessageBox.Alert("验证码过期，点击验证码更换后重新输入！");
                return;
            }
            if (!Session["validateCode"].Equals(vali))
            {
                MessageBox.Alert("不正确的验证码！");
                return;
            }

            long fid = long.Parse(hidden_fid.Value);
            string title = StringFormat.FormatHtml(txt_title.Text);
            string content = StringFormat.FormatHtml(editorContent.Value);
            if (content.Length < 10)
            {
                MessageBox.Alert("内容不能少于10字！");
                return;
            }

            BLL.gf_R bll = new goodHelper.BLL.gf_R();
            Model.gf_R model = new goodHelper.Model.gf_R();

            model.fid = fid;
            model.title = title;
            model.contents = content;
            model.userid = long.Parse(cookies["userid"].ToString());
            model.userName = cookies["username"].ToString();
            model.addtime = DateTime.Now;
            model.lastEdit = DateTime.Now;

            bll.Add(model);

            MessageBox.AlertUrl("回复成功", "thread.aspx?fid="+hidden_classid.Value+"&pid="+fid.ToString());
        }
    }
}
