﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.DALFactory;
using goodHelper.Model;
using goodHelper.BLL;

namespace goodHelper.Web
{
    public partial class thread : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                string classid = StringFormat.GetQuerystring("fid");
                string fid = StringFormat.GetQuerystring("pid");
                int page = 0;
                if (classid == ""||!StringFormat.IsNumber(page.ToString()))
                {
                    Response.Redirect("Error.htm");
                }
                if (fid == ""||!StringFormat.IsNumber(page.ToString()))
                {
                    Response.Redirect("Error.htm");
                }
                if (!StringFormat.IsNumber(StringFormat.GetQuerystring("page")))
                {
                    page = 1;
                }
                else
                {
                    page = int.Parse(StringFormat.GetQuerystring("page"));
                }

                //主题
                BLL.gf_F fbll = new goodHelper.BLL.gf_F();
                Model.gf_F fmodel = fbll.GetShowModel(long.Parse(fid));
                if (fmodel.fid.ToString() == "")
                {
                    Response.Redirect("Error.htm");
                }
                htm_fTitle.Text = "<span><font>发布时间："+fmodel.addtime.ToString("yyyy-MM-dd hh:mm:ss")+"</font> <em>[楼主]</em></span><strong>"+fmodel.title+"</strong>";
                htm_fContent.Text = StringFormat.Invert(fmodel.contents);
                htm_fAuthor.Text = GetUserInfo(fmodel.userid);

                //处理回复
                int pagesize = 20; //分页数
                int allCount = fmodel.replays; //回复总数
                int allpage = fmodel.replays / pagesize; //全部页数
                if (allpage < 1)
                {
                    allpage = 1;
                }
                if (page > allpage)
                {
                    page = allpage;
                }
                PageTop.InnerHtml = "<input name=\"\" type=\"button\" class=\"but_new\" value=\"\" onclick=\"window.location='post.aspx?fid="+classid+"'\" onmouseover=\"this.className = 'but_new but_new_h'\" onmouseout=\"this.className = 'but_new'\" />";
                PageTop.InnerHtml += "<input name=\"\" type=\"button\" class=\"but_reply\" value=\"\" onclick=\"window.location='reply.aspx?pid="+fid+"&fid="+classid+"'\" onmouseover=\"this.className = 'but_reply but_reply_h'\" onmouseout=\"this.className = 'but_reply'\"  />";
                PageTop.InnerHtml += "<span>回复数：<font class=\"forange\">" + allCount + "</font>篇  查看数：<font class=\"forange\">" + fmodel.hits.ToString() + "</font>次</span>";
                PageTop.InnerHtml += "<span class=\"pgs\">";

                if (page > 1)
                { 
                    PageTop.InnerHtml +="<a class=\"pages_next\" href=\"/thread.aspx?fid="+classid+"&pid="+fid+"&page="+(page-1).ToString()+"\">上一页</a>";
                }
                for (int i = 2; i > 0; i--)
                {
                    if (page - i > 0)
                    {
                        PageTop.InnerHtml += "<a href='thread.aspx?fid=" + classid + "&pid=" + fid + "&page=" + (page - i).ToString() + "'>" + (page - i).ToString() + "</a>";
                    }
                }
                PageTop.InnerHtml += "<a class='pcurr' >" + page.ToString() + "</a>";

                for (int i = 1; i < 3; i++)
                {
                    if (page + i <= allpage)
                    {
                        PageTop.InnerHtml += "<a href='thread.aspx?fid=" + classid + "&pid=" + fid + "&page=" + (page + i).ToString() + "'>"+ ( page + i ).ToString()+"</a>";
                    }
                }
                
                if (page < allpage)
                {
                    PageTop.InnerHtml += "<a class=\"pages_next\" href=\"/thread.aspx?fid=" + classid + "&pid=" + fid + "&page=" + (page + 1).ToString() + "\">下一页</a>";
                }

                PageTop.InnerHtml += "</span>";

                PageDown.InnerHtml = PageTop.InnerHtml;

                BLL.gf_R  bll = new goodHelper.BLL.gf_R();

                DataTable dt = bll.GetList(pagesize, page, "fid="+fid.ToString());

                datalistR.DataSource = dt.DefaultView;
                datalistR.DataBind();
            }
        }

        protected string GetUserInfo(long userid)
        {
            BLL.gf_UserInfo bll = new goodHelper.BLL.gf_UserInfo();
            Model.gf_UserInfo model =bll.GetModel(userid);
            string reStr="";
            reStr += "<div class=\"authorinfo\">\n";
            reStr += "  <span class=\"arrow\"></span>\n";
            reStr += "  <div class=\"author_photo\">\n";
            reStr += "    <div class=\"author_photo_in\"><span class=\"author_photo_bg\"></span>\n";
            reStr += "      <img src=\"" + model.userImg + "\" onerror=\"this.src = '/images/default.gif'\" />\n";
            reStr += "    </div>\n";
            reStr += "  </div>\n";
            reStr += "         <p class=\"uname\"><a href=\"userCenter.aspx?uid=" + model.userid.ToString() + "\">" + model.userName + "</a></p>";
            reStr += "  <dl>\n";
            reStr += "    <dt>主题：</dt><dd><strong>" + model.themeCount.ToString() + "</strong></dd>\n";
            reStr += "    <dt>经验：</dt><dd><strong>" + model.exp.ToString() + "</strong></dd>\n";
            reStr += "    <dt>积分：</dt><dd><strong>" + model.integral.ToString() + "</strong></dd>\n";
            reStr += "    <dt>金币：</dt><dd><strong>" + model.gold.ToString() + "</strong></dd>\n";
            //reStr="    <dt>经验：</dt><dd class=\"ep\"><span class=\"empirical\"><em style=\"width:19px;\"></em><font>99/140</font></span></dd>\n";
            //reStr = "    <dt>积分：</dt><dd><strong>1362</strong>  帖子：<strong>1</strong></dd>\n";
            reStr += "  </dl>\n";
            reStr += "</div>\n";

            return reStr;
        }

        protected string FormatString(string str)
        {
            return StringFormat.Invert(str);
        }
    }
}
