﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using goodHelper.Common;
using goodHelper.BLL;
using goodHelper.Model;
using goodHelper.DALFactory;

namespace goodHelper.Web
{
    public partial class userCenter : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Localize htmNav = (Localize)this.Page.Master.FindControl("htm_Nav");
            htmNav.Text = "<a href=\"default.aspx\" class=\"ghome\">论坛首页</a> > <a href=\"\" class=\"ghome\">用户中心</a>";
            if (!IsPostBack)
            {
                HttpCookie cookies;
                string userid = StringFormat.GetQuerystring("uid");
                if (userid == "")
                {
                    if (Request.Cookies["userInfo"] != null)
                    {
                        cookies = Request.Cookies["userInfo"];                      
                        userid = cookies["userid"].ToString();
                        lab_EditImg.Disabled = true;
                    }
                    else
                    {
                        userid = "";
                    }
                    if (userid == "")
                    {
                        Response.Redirect("login.aspx?act=userCenter");
                    }

                }
                BLL.gf_UserInfo bll = new goodHelper.BLL.gf_UserInfo();

                Model.gf_UserInfo model = bll.GetModel(long.Parse(userid));

                if (model.userImg != "")
                {
                    userimg.Src = model.userImg;
                }
                else
                {
                    userimg.Src = "/images/default.gif";
                }

                lab_userName.Text = model.userName;
                lab_exp.Text = model.exp.ToString();
                lab_gold.Text = model.gold.ToString();
                lab_integral.Text = model.integral.ToString();
                lab_replyCount.Text = model.replyCount.ToString();
                lab_themeCount.Text = model.themeCount.ToString();
                lab_regDate.Text = model.regDate.ToString();
                lab_lastDate.Text = model.lastDate.ToString();
            }
        }
    }
}
