﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

/// <summary>
/// HostManage 的摘要说明
/// </summary>
public class HostManage
{
	public HostManage()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

    DataBase data = new DataBase();

    #region 定义版主--数据结构
    private string hostname = "";
    private string moduleid = "";
    private string hostpwd = "";
    private string tname = "";
    private bool sex = false;
    private DateTime birthday = Convert.ToDateTime(DateTime.Now.ToShortDateString());
    private string tel = "";
    private string mobile = "";
    private int qq = 0;
    private string photo = "";
    private string email = "";
    private string faddress = "";
    private string raddress = "";
    private string index = "";
    private string hostpop = "版主";
    /// <summary>
    /// 版主名
    /// </summary>
    public string HostName
    {
        get { return hostname; }
        set { hostname = value; }
    }
    /// <summary>
    /// 版块编号
    /// </summary>
    public string ModuleID
    {
        get { return moduleid; }
        set { moduleid = value; }
    }
    /// <summary>
    /// 版主密码
    /// </summary>
    public string HostPwd
    {
        get { return hostpwd; }
        set { hostpwd = value; }
    }
    /// <summary>
    /// 真实姓名
    /// </summary>
    public string TName
    {
        get { return tname; }
        set { tname = value; }
    }
    /// <summary>
    /// 性别
    /// </summary>
    public bool Sex
    {
        get { return sex; }
        set { sex = value; }
    }
    /// <summary>
    /// 出生日期
    /// </summary>
    public DateTime Birthday
    {
        get { return birthday; }
        set { birthday = value; }
    }
    /// <summary>
    /// 联系电话
    /// </summary>
    public string Tel
    {
        get { return tel; }
        set { tel = value; }
    }
    /// <summary>
    /// 手机
    /// </summary>
    public string Mobile
    {
        get { return mobile; }
        set { mobile = value; }
    }
    /// <summary>
    /// QQ号
    /// </summary>
    public int QQ
    {
        get { return qq; }
        set { qq = value; }
    }
    /// <summary>
    /// 头像
    /// </summary>
    public string Photo
    {
        get { return photo; }
        set { photo = value; }
    }
    /// <summary>
    /// Email
    /// </summary>
    public string Email
    {
        get { return email; }
        set { email = value; }
    }
    /// <summary>
    /// 家庭住址
    /// </summary>
    public string FAddress
    {
        get { return faddress; }
        set { faddress = value; }
    }
    /// <summary>
    /// 联系地址
    /// </summary>
    public string RAddress
    {
        get { return raddress; }
        set { raddress = value; }
    }
    /// <summary>
    /// 个人首页
    /// </summary>
    public string Index
    {
        get { return index; }
        set { index = value; }
    }
    /// <summary>
    /// 版主权限
    /// </summary>
    public string HostPop
    {
        get { return hostpop; }
        set { hostpop = value; }
    }
    #endregion

    #region 添加--版主信息
    /// <summary>
    /// 添加--版主信息
    /// </summary>
    /// <param name="hostmanage"></param>
    /// <returns></returns>
    public int AddHost(HostManage hostmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@hostname",  SqlDbType.NVarChar, 50, hostmanage.HostName),
                                        data.MakeInParam("@moduleid",  SqlDbType.NVarChar, 50, hostmanage.ModuleID),
                						data.MakeInParam("@hostpwd",  SqlDbType.NVarChar, 50,hostmanage.HostPwd),
                						data.MakeInParam("@tname",  SqlDbType.NVarChar, 20, hostmanage.TName),
                						data.MakeInParam("@sex",  SqlDbType.Bit, 1, hostmanage.Sex),
                						data.MakeInParam("@birthday",  SqlDbType.SmallDateTime, 8, hostmanage.Birthday),
                						data.MakeInParam("@tel",  SqlDbType.NVarChar, 20, hostmanage.Tel),
                                        data.MakeInParam("@mobile",  SqlDbType.NVarChar, 20, hostmanage.Mobile),
                						data.MakeInParam("@qq",  SqlDbType.BigInt, 8,hostmanage.QQ),
                						data.MakeInParam("@photo",  SqlDbType.NVarChar, 200, hostmanage.Photo),
                						data.MakeInParam("@email",  SqlDbType.NVarChar, 50, hostmanage.Email),
                						data.MakeInParam("@faddress",  SqlDbType.NVarChar, 100, hostmanage.FAddress),
                						data.MakeInParam("@raddress",  SqlDbType.NVarChar, 100, hostmanage.RAddress),
                                        data.MakeInParam("@index",  SqlDbType.NVarChar, 50, hostmanage.Index),
			};
        return (data.RunProc("INSERT INTO tb_Host (版主,版块编号,密码,真实姓名,性别,出生日期,联系电话,手机,QQ号,头像,Email,家庭住址,联系地址,个人首页,版主权限) "
            + "VALUES (@hostname,@moduleid,@hostpwd,@tname,@sex,@birthday,@tel,@mobile,@qq,@photo,@email,@faddress,@raddress,@index,'" + hostpop + "')", prams));
    }
    #endregion

    #region 修改--版主信息
    /// <summary>
    /// 修改--版主信息
    /// </summary>
    /// <param name="hostmanage"></param>
    /// <returns></returns>
    public int UpdateHost(HostManage hostmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@hostname",  SqlDbType.NVarChar, 50, hostmanage.HostName),
                						data.MakeInParam("@hostpwd",  SqlDbType.NVarChar, 50,hostmanage.HostPwd),
                						data.MakeInParam("@tname",  SqlDbType.NVarChar, 20, hostmanage.TName),
                						data.MakeInParam("@sex",  SqlDbType.Bit, 1, hostmanage.Sex),
                						data.MakeInParam("@birthday",  SqlDbType.SmallDateTime, 8, hostmanage.Birthday),
                						data.MakeInParam("@tel",  SqlDbType.NVarChar, 20, hostmanage.Tel),
                                        data.MakeInParam("@mobile",  SqlDbType.NVarChar, 20, hostmanage.Mobile),
                						data.MakeInParam("@qq",  SqlDbType.BigInt, 8,hostmanage.QQ),
                						data.MakeInParam("@photo",  SqlDbType.NVarChar, 200, hostmanage.Photo),
                						data.MakeInParam("@email",  SqlDbType.NVarChar, 50, hostmanage.Email),
                						data.MakeInParam("@faddress",  SqlDbType.NVarChar, 100, hostmanage.FAddress),
                						data.MakeInParam("@raddress",  SqlDbType.NVarChar, 100, hostmanage.RAddress),
                                        data.MakeInParam("@index",  SqlDbType.NVarChar, 50, hostmanage.Index),
			};
        return (data.RunProc("update tb_Host set 密码=@hostpwd,真实姓名=@tname,性别=@sex,出生日期=@birthday,联系电话=@tel,手机=@mobile,"
            + "QQ号=@qq,头像=@photo,Email=@email,家庭住址=@faddress,联系地址=@raddress,个人首页=@index where 版主=@hostname", prams));
    }
    #endregion

    #region 删除--版主信息
    /// <summary>
    /// 删除--版主信息
    /// </summary>
    /// <param name="hostmanage"></param>
    /// <returns></returns>
    public int DeleteHost(HostManage hostmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@hostname",  SqlDbType.NVarChar, 50, hostmanage.HostName),
			};
        return (data.RunProc("delete from tb_Host where 版主=@hostname", prams));
    }
    #endregion

    #region 查询--版主信息
    /// <summary>
    /// 根据--版主姓名--得到版主信息
    /// </summary>
    /// <param name="hostmanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindHostByName(HostManage hostmanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@hostname",  SqlDbType.NVarChar, 50, hostmanage.HostName+"%"),
			};
        return (data.RunProcReturn("select * from tb_Host where 版主 like @hostname", prams, tbName));
    }
    /// <summary>
    /// 根据--版块编号--得到版主信息
    /// </summary>
    /// <param name="hostmanage"></param>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet FindHostByMID(HostManage hostmanage, string tbName)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@moduleid",  SqlDbType.NVarChar, 50, hostmanage.ModuleID+"%"),
			};
        return (data.RunProcReturn("select * from tb_Host where 版块编号 like @moduleid", prams, tbName));
    }
    /// <summary>
    /// 得到所有--版主信息
    /// </summary>
    /// <param name="tbName"></param>
    /// <returns></returns>
    public DataSet GetAllHost(string tbName)
    {
        return (data.RunProcReturn("select * from tb_Host ORDER BY 版主", tbName));
    }
    #endregion

    #region 版主登录
    /// <summary>
    /// 版主登录
    /// </summary>
    /// <param name="hostmanage"></param>
    /// <returns></returns>
    public DataSet Login(HostManage hostmanage)
    {
        SqlParameter[] prams = {
									    data.MakeInParam("@hostname",  SqlDbType.NVarChar, 50, hostmanage.HostName),
                						data.MakeInParam("@hostpwd",  SqlDbType.NVarChar, 50,hostmanage.HostPwd),
			};
        return (data.RunProcReturn("SELECT * FROM tb_Host WHERE (版主 = @hostname) AND (密码 = @hostpwd)", prams, "tb_Host"));
    }
    #endregion
}
