﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class CardManage_Card : System.Web.UI.Page
{
    CardManage cardmanage = new CardManage();
    ModuleManage modulemanage = new ModuleManage();
    protected void Page_Load(object sender, EventArgs e)
    {
        dlBind();
    }
    protected void lnkbtnOne_Click(object sender, EventArgs e)
    {
        labPage.Text = "1";
        dlBind();
    }
    protected void lnkbtnUp_Click(object sender, EventArgs e)
    {
        labPage.Text = Convert.ToString(Convert.ToInt32(labPage.Text) - 1);
        dlBind();
    }
    protected void lnkbtnNext_Click(object sender, EventArgs e)
    {
        labPage.Text = Convert.ToString(Convert.ToInt32(labPage.Text) + 1);
        dlBind();
    }
    protected void lnkbtnBack_Click(object sender, EventArgs e)
    {
        labPage.Text = labBackPage.Text;
        dlBind();
    }
    public void dlBind()
    {
        int curpage = Convert.ToInt32(labPage.Text);
        PagedDataSource ps = new PagedDataSource();
        cardmanage.ModuleID = Page.Request.QueryString["ModuleID"].ToString();
        ps.DataSource = cardmanage.FindCardByMID(cardmanage,"tb_Card").Tables[0].DefaultView;
        ps.AllowPaging = true; //是否可以分页
        ps.PageSize = 3; //显示的数量
        ps.CurrentPageIndex = curpage - 1; //取得当前页的页码
        lnkbtnUp.Enabled = true;
        lnkbtnNext.Enabled = true;
        lnkbtnBack.Enabled = true;
        lnkbtnOne.Enabled = true;
        if (curpage == 1)
        {
            lnkbtnOne.Enabled = false;//不显示第一页按钮
            lnkbtnUp.Enabled = false;//不显示上一页按钮
        }
        if (curpage == ps.PageCount)
        {
            lnkbtnNext.Enabled = false;//不显示下一页
            lnkbtnBack.Enabled = false;//不显示最后一页
        }
        this.labBackPage.Text = Convert.ToString(ps.PageCount);
        dlInfo.DataSource = ps;
        dlInfo.DataKeyField = "帖子编号";
        dlInfo.DataBind();
    }
    public string getModule()
    {
        modulemanage.ModuleID = Page.Request.QueryString["ModuleID"].ToString();
        if (modulemanage.FindModuleByID(modulemanage, "tb_Module").Tables[0].Rows.Count > 0)
        {
            string module = modulemanage.FindModuleByID(modulemanage, "tb_Module").Tables[0].Rows[0][1].ToString();
            return module;
        }
        else
            return null;
    }
    protected void dlInfo_EditCommand(object source, DataListCommandEventArgs e)
    {
        string cardid = dlInfo.DataKeys[e.Item.ItemIndex].ToString();
        Page.Response.Redirect("RevertCard.aspx?CardID=" + cardid + "");
    }
}
