﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class CardManage_CardInfo : System.Web.UI.Page
{
    CardManage cardmanage = new CardManage();
    RevertManage revertmanage = new RevertManage();
    UserManage usermanage = new UserManage();
    HostManage hostmanage = new HostManage();
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            dataBind();
        }
        catch { }
    }
    protected void lnkbtnOne_Click(object sender, EventArgs e)
    {
        labPage.Text = "1";
        pageCount();
    }
    protected void lnkbtnUp_Click(object sender, EventArgs e)
    {
        labPage.Text = Convert.ToString(Convert.ToInt32(labPage.Text) - 1);
        pageCount();
    }
    protected void lnkbtnNext_Click(object sender, EventArgs e)
    {
        labPage.Text = Convert.ToString(Convert.ToInt32(labPage.Text) + 1);
        pageCount();
    }
    protected void lnkbtnBack_Click(object sender, EventArgs e)
    {
        labPage.Text = labBackPage.Text;
        pageCount();
    }
    protected void LinkButton1_Click(object sender, EventArgs e)
    {
        string cardid = "";
        if (Page.Request.QueryString["CardID"] != null)
        {
            cardid = Page.Request.QueryString["CardID"].ToString();
            Page.Response.Redirect("RevertCard.aspx?CardID=" + cardid + "");
            return;
        }
        if (Session["CardID"].ToString() != null)
        {
            cardid = Session["CardID"].ToString();
            Page.Response.Redirect("RevertCard.aspx?CardID=" + cardid + "");
            return;
        }
    }
    protected void dlInfo_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        if (Session["Pop"] == "管理员" || Session["Pop"] == "版主")
        {
            string revertid = dlInfo.DataKeys[e.Item.ItemIndex].ToString(); //获取当前DataList控件列
            revertmanage.RevertID = revertid;
            revertmanage.DeleteRevert(revertmanage);
            Response.Write("<script>alert('回帖信息--删除成功')</script>");
            dataBind();
            return;
        }
        else
            Response.Redirect("../Common/LimitPop.aspx");
    }
    public void dlBind(string str)
    {
        int curpage = Convert.ToInt32(labPage.Text);
        PagedDataSource ps = new PagedDataSource();
        revertmanage.CardID = str;
        ps.DataSource = revertmanage.FindRevertByCID(revertmanage, "tb_Revert").Tables[0].DefaultView;
        ps.AllowPaging = true; //是否可以分页
        ps.PageSize = 2; //显示的数量
        ps.CurrentPageIndex = curpage - 1; //取得当前页的页码
        lnkbtnUp.Enabled = true;
        lnkbtnNext.Enabled = true;
        lnkbtnBack.Enabled = true;
        lnkbtnOne.Enabled = true;
        if (curpage == 1)
        {
            lnkbtnOne.Enabled = false;//不显示第一页按钮
            lnkbtnUp.Enabled = false;//不显示上一页按钮
        }
        if (curpage == ps.PageCount)
        {
            lnkbtnNext.Enabled = false;//不显示下一页
            lnkbtnBack.Enabled = false;//不显示最后一页
        }
        this.labBackPage.Text = Convert.ToString(ps.PageCount);
        dlInfo.DataSource = ps;
        dlInfo.DataKeyField = "回帖编号";
        dlInfo.DataBind();
    }
    public void dataBind()
    {
        if (Page.Request.QueryString["CardID"] != null)
        {
            cardBind(Page.Request.QueryString["CardID"].ToString());
            dlBind(Page.Request.QueryString["CardID"].ToString());
            return;
        }
        if (Session["CardID"] != null)
        {
            cardBind(Session["CardID"].ToString());
            dlBind(Session["CardID"].ToString());
            return;
        }
    }
    public void cardBind(string str)
    {
        try
        {
            cardmanage.CardID = str;
            Label1.Text = Convert.ToDateTime(cardmanage.FindCardByID(cardmanage, "tb_Card").Tables[0].Rows[0][4].ToString()).ToLongDateString();
            Label2.Text = cardmanage.FindCardByID(cardmanage, "tb_Card").Tables[0].Rows[0][5].ToString();
            Label4.Text = cardmanage.FindCardByID(cardmanage, "tb_Card").Tables[0].Rows[0][1].ToString();
            Label8.Text = cardmanage.FindCardByID(cardmanage, "tb_Card").Tables[0].Rows[0][3].ToString();
            string strPop = cardmanage.FindCardByID(cardmanage, "tb_Card").Tables[0].Rows[0][6].ToString().Trim();
            string strPhoto = "";
            if (strPop == "游客")
            {
                strPhoto = "../Images/Visiter.jpg";
            }
            if (strPop == "用户")
            {
                usermanage.UserName = cardmanage.FindCardByID(cardmanage, "tb_Card").Tables[0].Rows[0][5].ToString();
                strPhoto = usermanage.FindUserByName(usermanage, "tb_User").Tables[0].Rows[0][8].ToString();
            }
            if (strPop == "版主")
            {
                hostmanage.HostName = cardmanage.FindCardByID(cardmanage, "tb_Card").Tables[0].Rows[0][5].ToString();
                strPhoto = hostmanage.FindHostByName(hostmanage, "tb_Host").Tables[0].Rows[0][9].ToString();
            }
            if (strPop == "管理员")
            {
                strPhoto = "../Images/Admin.jpg";
            }
            Image2.ImageUrl = strPhoto;
        }
        catch { }
    }
    public void pageCount()
    {
        if (Page.Request.QueryString["CardID"] != null)
        {
            dlBind(Page.Request.QueryString["CardID"].ToString());
            return;
        }
        if (Session["CardID"] != null)
        {
            dlBind(Session["CardID"].ToString());
            return;
        }
    }
    public string getPhoto(string str)
    {
        string strPhoto = "";
        revertmanage.RevertID = str;
        string strPop = revertmanage.FindRevertByID(revertmanage, "tb_Revert").Tables[0].Rows[0][6].ToString().Trim();

        if (strPop == "用户")
        {
            usermanage.UserName = revertmanage.FindRevertByID(revertmanage, "tb_Revert").Tables[0].Rows[0][5].ToString();
            strPhoto = usermanage.FindUserByName(usermanage, "tb_User").Tables[0].Rows[0][8].ToString();
        }
        if (strPop == "版主")
        {
            hostmanage.HostName = revertmanage.FindRevertByID(revertmanage, "tb_Revert").Tables[0].Rows[0][5].ToString();
            strPhoto = hostmanage.FindHostByName(hostmanage, "tb_Host").Tables[0].Rows[0][9].ToString();
        }
        if (strPop == "管理员")
        {
            strPhoto = "../Images/Admin.jpg";
        }
        return strPhoto;
    }
}
