﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class CardManage_CardManage : System.Web.UI.Page
{
    CardManage cardmanage = new CardManage();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            gvInfo.DataSource = cardmanage.GetAllCard("tb_Card").Tables[0].DefaultView;
            gvInfo.DataKeyNames = new string[] { "帖子编号" };
            gvInfo.DataBind();
            for (int i = 0; i < cardmanage.GetAllCard("tb_Card").Tables[0].Rows.Count; i++)
            {
                gvInfo.Rows[i].Cells[1].Text = SubStr(cardmanage.GetAllCard("tb_Card").Tables[0].Rows[i][1].ToString(), 8);
                gvInfo.Rows[i].Cells[2].Text = Convert.ToDateTime(cardmanage.GetAllCard("tb_Card").Tables[0].Rows[i][4].ToString()).ToLongDateString();
            }
        }
    }
    protected void btnFind_Click(object sender, EventArgs e)
    {
        gvBind();
    }
    protected void gvInfo_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        gvInfo.PageIndex = e.NewPageIndex;
        gvBind();
    }
    protected void gvInfo_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        cardmanage.CardID = gvInfo.DataKeys[e.RowIndex].Value.ToString();
        cardmanage.DeleteCard(cardmanage);
        gvBind();
    }
    protected void gvInfo_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            ((LinkButton)(e.Row.Cells[5].Controls[0])).Attributes.Add("onclick", "return confirm('确定要删除吗？')");
        }
    }
    protected void gvInfo_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Update")
        {
            Session["CardID"] = gvInfo.Rows[Convert.ToInt32(e.CommandArgument)].Cells[0].Text;
            Response.Redirect("CardInfo.aspx");
        }
    }
    public void gvBind()
    {
        if (txtName.Text == string.Empty)
        {
            gvInfo.DataSource = cardmanage.GetAllCard("tb_Card").Tables[0];
            gvInfo.DataBind();
            for (int i = 0; i < cardmanage.GetAllCard("tb_Card").Tables[0].Rows.Count; i++)
            {
                gvInfo.Rows[i].Cells[1].Text = SubStr(cardmanage.GetAllCard("tb_Card").Tables[0].Rows[i][1].ToString(), 8);
                gvInfo.Rows[i].Cells[2].Text = Convert.ToDateTime(cardmanage.GetAllCard("tb_Card").Tables[0].Rows[i][4].ToString()).ToLongDateString();
            }
        }
        else
        {
            cardmanage.CardName = txtName.Text;
            gvInfo.DataSource = cardmanage.FindCardByName(cardmanage, "tb_Card").Tables[0];
            gvInfo.DataBind();
            for (int i = 0; i < cardmanage.FindCardByName(cardmanage, "tb_Card").Tables[0].Rows.Count; i++)
            {
                gvInfo.Rows[i].Cells[1].Text = SubStr(cardmanage.FindCardByName(cardmanage, "tb_Card").Tables[0].Rows[i][1].ToString(), 8);
                gvInfo.Rows[i].Cells[2].Text = Convert.ToDateTime(cardmanage.FindCardByName(cardmanage, "tb_Card").Tables[0].Rows[i][4].ToString()).ToLongDateString();
            }
        }
    }
    public string SubStr(string sString, int nLeng)
    {
        if (sString.Length <= nLeng)
        {
            return sString;
        }
        string sNewStr = sString.Substring(0, nLeng);
        sNewStr = sNewStr + "...";
        return sNewStr;
    }
}
