using System;
using System.Web;
using System.Net;
using System.Xml;
using System.Text;
using System.Data;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;
using MyFunc;
using NetSNS.Model;
using NetSNS.DALProfile;
using NetSNS.Common;
using System.Collections.Generic;
using System.IO;
using System.Collections.Specialized;
namespace NetSNS.API.Interface
{
    /// <summary>
    /// ṩ API Ӧ
    /// </summary>
    public class pdo : System.Web.UI.Page
    {
        private XmlDocument xmlDoc;
        private string message, action, username,email, syskey, appid, userTrueIP;
        private int status;

        // ͻ˷͹
        private NameValueCollection __RequestData, __ResponseChoiceList;
        private readonly string __AppId = string.Empty, __SysKey = string.Empty;
        private readonly string[] __ReqAppIdList = new string[] { "netcms", "netsns", "dvbbs", "powereasy", "oblog", "other" };
        private string __ResponseBodyMessage = "ɹ";
        private bool __IsSuccess = true, __Finished = false;
        private readonly Dictionary<string, string> __ApiCfg = null;

        public pdo()
        {
            __ApiCfg = new Config("./pdo.config").Dict;
            __SysKey = __ApiCfg["SYSKEY"];
            __AppId = __ApiCfg["APPID"];
        }
        private void SaveUserCookie()
        {
            syskey = Text.SqlEncode(Get("syskey")).Trim();
            username = Text.SqlEncode(Get("username")).Trim();
            email = Text.SqlEncode(Get("email")).Trim();
            if (username.IndexOf("'") > 0)
                return;

            string password = Text.SqlEncode(Get("password")).Trim();
            string savecookie = Get("savecookie").Trim();
            string rawpassword = Get("rawpassword").Trim();
            if (savecookie == "") savecookie = "0";

            int savedays = 0;
            switch (int.Parse(savecookie))
            {
                case 0:
                    {
                        savedays = 0;
                        break;
                    }
                case 1:
                    {
                        savedays = 7;
                        break;
                    }
                case 2:
                    {
                        savedays = 30;
                        break;
                    }
                case 3:
                    {
                        savedays = 365;
                        break;
                    }
                default:
                    {
                        savedays = 0;
                        break;
                    }
            }

            if (password == "")
            {
                Context.Session.Remove("SITEINFO");
                HttpContext.Current.Response.Cookies.Clear();
                Session.Clear();
                return;
            }
            userTrueIP = Fetch.UserIp;
            if (!CheckLogin(SqlEncode(email), rawpassword, savedays))
            {
                return;
            }

            // ָʾֹ this.__Finish()
            this.__Finished = true;

            // ͷԴ
            this.__Finish();
        }

        private bool CheckPost()
        {
            XmlNode eAppId = xmlDoc.SelectSingleNode("root/appid");
            XmlNode eUsername = xmlDoc.SelectSingleNode("root/username");
            XmlNode eAction = xmlDoc.SelectSingleNode("root/action");
            XmlNode eSysKey = xmlDoc.SelectSingleNode("root/syskey");
            XmlNode eUserIP = xmlDoc.SelectSingleNode("root/userip");
            XmlNode eEmail = xmlDoc.SelectSingleNode("root/email");
            if (eAppId == null || eAction == null || eSysKey == null || eEmail == null)
            {
                message = "ύݷǷֹ" + eAppId + "," + eUsername;
                status = 1;
                return false;
            }

            appid = eAppId.InnerText.Trim();
            username = eUsername.InnerText.Trim();
            syskey = eSysKey.InnerText.Trim();
            action = eAction.InnerText.Trim();
            userTrueIP = eUserIP.InnerText.Trim();
            email = eEmail.InnerText.Trim();
            if (userTrueIP == "")
                userTrueIP = Fetch.UserIp;

            if (username.IndexOf("'") > 0)
            {
                status = 1;
                message = "Ƿֹ";
                return false;
            }

            Dictionary<string, string> cfg = new Config("./pdo.config").Dict;

            //			if (syskey != getMD5.MD5(username + cfg["SYSKEY"]))
            if (syskey != Text.MD5(email + cfg["SYSKEY"]) && syskey != Text.MD5(username + cfg["SYSKEY"]))
            {
                status = 1;
                message = "Ƿ";
                return false;
            }
            return true;
        }

        private void CheckName()
        {

            IDataReader rs = DbHelper.ExecuteReader(CommandType.Text, "select count(username) from " + Fetch.TablePrefix + "sys_user where username='" + Text.SqlEncode(username) + "'", null);
            if (!rs.Read())
            {
                rs.Dispose();
                status = 1;
                message = "ûʧܣ";
                return;
            }

            if ((int)rs[0] == 0)
            {
                message = "ͨ⣬ʹ";
                status = 0;
            }
            else
            {
                message = "עѱռû";
                status = 1;
            }
            rs.Dispose();
        }

        private void GetInfo()
        {
            xmlDoc.LoadXml("<root><appid/><status>0</status><body><message/><email/><question/><answer/><savecookie/><truename/><gender/><birthday/><qq/><msn/><mobile/><telephone/><province/><city/><address/><zipcode/><homepage/><userip/><jointime/><experience/><ticket/><valuation/><balance/><posts/><userstatus/></body></root>");

            string sql = "select * from " + Fetch.TablePrefix + "user " + Fetch.TablePrefix + "userinfo b  on  b.userid=a.userid where a.email='" + Text.SqlEncode(email) + "'";
            DataTable dt = DbHelper.ExecuteTable(CommandType.Text, sql, null);
            if (dt.Rows.Count < 1)
            {
                status = 1;
                message = "ѯûڣ";
            }
            else
            {
                DataRow Rs = dt.Rows[0];
                xmlDoc.DocumentElement.SelectSingleNode("body/email").InnerText = Rs["Email"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/question").InnerText ="111111";
                xmlDoc.DocumentElement.SelectSingleNode("body/answer").InnerText = "111111";
                //Ա
                if (Rs["Sex"].ToString() == "1")
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/gender").InnerText = "0";
                }
                else if (Rs["Sex"].ToString() == "0")
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/gender").InnerText = "1";
                }

                xmlDoc.DocumentElement.SelectSingleNode("body/homepage").InnerText = Rs["website"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/qq").InnerText = Rs["qq"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/msn").InnerText = Rs["msn"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/telephone").InnerText = Rs["Tel"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/mobile").InnerText = Rs["mobile"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/address").InnerText = Rs["Addr"].ToString();
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/province").InnerText = getAreaName(Convert.ToInt32(Rs["province"])).ToString();
                    xmlDoc.DocumentElement.SelectSingleNode("body/city").InnerText = getAreaName(Convert.ToInt32(Rs["city"])).ToString();
                }
                catch { }
                xmlDoc.DocumentElement.SelectSingleNode("body/userip").InnerText = Rs["LastLoginIP"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/jointime").InnerText = Rs["RegTime"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/experience").InnerText = "0";
                xmlDoc.DocumentElement.SelectSingleNode("body/ticket").InnerText = "0";
                xmlDoc.DocumentElement.SelectSingleNode("body/posts").InnerText = "";

                int t = 0;
                // 0- 1- 2-
                if (Rs["state"].ToString() == "1")
                {
                    t = 1;
                }
                xmlDoc.DocumentElement.SelectSingleNode("body/userstatus").InnerText = t.ToString();

                xmlDoc.DocumentElement.SelectSingleNode("body/truename").InnerText = Rs["username"].ToString();

                status = 0;
                message = "ݲѯϣ";
            }
        }

        private void UserLogin()
        {
            string password = xmlDoc.DocumentElement.SelectSingleNode("password").InnerText.Trim();
            string email = xmlDoc.DocumentElement.SelectSingleNode("email").InnerText.Trim();
            string savecookie = Get("savecookie");

            int savedays = 0;
            if (savecookie == "") savecookie = "0";
            switch (int.Parse(savecookie))
            {
                case 0:
                    {
                        savedays = 0;
                        break;
                    }
                case 1:
                    {
                        savedays = 7;
                        break;
                    }
                case 2:
                    {
                        savedays = 30;
                        break;
                    }
                case 3:
                    {
                        savedays = 365;
                        break;
                    }
                default:
                    {
                        savedays = 0;
                        break;
                    }
            }

            if (!CheckLogin(SqlEncode(email), password, savedays))
            {
                status = 1;
                return;
            }
            status = 0;
            message = "Login Successed.";
        }

        /// <Summary>
        /// жIPǷڱķΧ
        /// </Summary>
        public bool IsDeniedIp()
        {
            return false;
        }

        /// <Summary>
        /// û¼
        /// </Summary>
        public bool CheckLogin(string email, string password, int saveDays)
        {
            if (email == null || password == null
                   || email == string.Empty || password == string.Empty)
            {
                status = 1;
                message = "½";
                return false;
            }
            else
            {
                int userId = 0;
                string userName = string.Empty;
                string userPortrait = string.Empty;
                BLL.User.User us = new NetSNS.BLL.User.User();
                EnumLoginState state = us.Login(email, password, out userId, out userName, out userPortrait);
                switch (state)
                {
                    case EnumLoginState.Succeed:
                        NetSNS.Web.UI.Page.UserPage.SetCookie(userId, userName, Input.MD5(password, false), userPortrait, false);
                        status = 0;
                        message = "½ɹ";
                        return true;
                    case EnumLoginState.Err_UnActivation:
                        status = 1;
                        message = "ʼûͨʼ";
                        return false;
                    case EnumLoginState.Err_NameOrPwdError:
                        status = 1;
                        message = "û";
                        return false;
                    case EnumLoginState.Err_Locked:
                        message = "ԲʺѾϵͳʣԱϵ";
                        status = 1;
                        return false;
                    default:
                        status = 1;
                        message = "½";
                        return false;
                }
            }
            
        }



        private void Logout()
        {
            HttpCookie cookieToken = new HttpCookie("SnsUserToken");
            if (cookieToken != null)
            {
                cookieToken.Expires.AddMilliseconds(0.1);
                Response.Cookies.Add(cookieToken);
            }
            status = 0;
            message = "Logout Successed.";
        }

        private void OutputData()
        {
            if (action != "getinfo")
                xmlDoc.LoadXml("<?xml version=\"1.0\" encoding=\"gb2312\"?>\n<root><appid>Dvbbs bbs</appid><status>0</status><body><message/></body></root>");

            Dictionary<string, string> cfg = new Config("./pdo.config").Dict;
            xmlDoc.DocumentElement.SelectSingleNode("appid").InnerText = cfg["APPID"];
            xmlDoc.DocumentElement.SelectSingleNode("status").InnerText = status.ToString();
            XmlNode tn = xmlDoc.CreateCDataSection(message.Replace("]]>", "]]&gt;"));
            xmlDoc.DocumentElement.SelectSingleNode("body/message").AppendChild(tn);
            Response.Clear();
            Response.ContentType = "text/xml";
            Response.Charset = "gb2312";
            xmlDoc.Save(Response.OutputStream);
        }

        private void DeleteUser()
        {
            string[] D_Users = email.Split(',');
            string D_Users_List = "";
            for (int i = 0; i < D_Users.Length; i++)
            {
                D_Users_List += ("'" + SqlEncode(D_Users[i]) + "',");
            }

            status = 0;
            if (D_Users_List != "")
            {
                D_Users_List = D_Users_List.Substring(0, D_Users_List.Length - 1);
                string sql = "delete from  " + Fetch.TablePrefix + "user where email in (" + D_Users_List + ")";
                try
                {
                    DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
                    message = "ѳɹɾָû";
                }
                catch
                {
                    status = 1;
                    message = "ݿʧܣ";
                }
            }
        }

        private void LockUser()
        {
            string UserStatus = xmlDoc.SelectSingleNode("root/userstatus").InnerText;
            if (UserStatus == "")
            {
                status = 1;
                message = "ûָͣ";
                return;
            }

            try
            {
                int LockType = Convert.ToInt32(UserStatus);
                if (LockType != 1)
                    LockType = 0;

                // ΪʱΪ365졣
                System.DateTime unlockTime = System.DateTime.Now;
                if (LockType == 1)
                    unlockTime = unlockTime.AddDays(365);

                string sql = "update " + Fetch.TablePrefix + "user set status=1 where email='" + SqlEncode(email) + "'";
                DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
                status = 0;
                if (LockType == 1)
                    message = "ɹ";
                else
                    message = "ɹ";
            }
            catch
            {
                status = 1;
                message = "󣬲ֹ";
            }
        }

        private void UpdateUser()
        {
            string password, email, sex, question, answer;
            string sql = "";

            // Ҫ¸Ϣڴ˴д
            password = xmlDoc.SelectSingleNode("root/password").InnerText.Trim();
            email = SqlEncode(xmlDoc.SelectSingleNode("root/email").InnerText).Trim();
            sex = xmlDoc.SelectSingleNode("root/gender").InnerText.Trim();
            question = SqlEncode(xmlDoc.SelectSingleNode("root/question").InnerText).Trim();
            answer = xmlDoc.SelectSingleNode("root/answer").InnerText.Trim();

            if (password != "")
            {
                password = NetSNS.Common.Input.MD5(password,false);
                sql += ("[Password]='" + password + "',");
            }

            //if (sex == "0")
            //{
            //    sql += "[sex]=1,";
            //}
            //else
            //{
            //    if (sex == "1")
            //    {
            //        sql += "[sex]=0,";
            //    }
            //}



            if (sql != "")
            {
                sql = sql.Substring(0, sql.Length - 1);
                sql = "update " + Fetch.TablePrefix + "user set " + sql + " where email='" + SqlEncode(email) + "'";
                if (DbHelper.ExecuteNonQuery(CommandType.Text, sql, null) > 0)
                {
                    status = 0;
                    message = "Ϣɹ";
                }
                else
                {
                    status = 1;
                    message = "Ϣʧܣ" + sql;
                }
            }
            else
            {
                status = 0;
                message = "ûҪµϢ";
            }
        }

        private void RegUser()
        {
            string siteID = "0";
            string password, email, username, sex, question, answer, province, city;
            username = SqlEncode(xmlDoc.SelectSingleNode("root/username").InnerText).Trim();
            email = SqlEncode(xmlDoc.SelectSingleNode("root/email").InnerText).Trim();
            password = xmlDoc.SelectSingleNode("root/password").InnerText.Trim();
            sex = xmlDoc.SelectSingleNode("root/gender").InnerText.Trim();
            province = xmlDoc.SelectSingleNode("root/province").InnerText.Trim();
            city = xmlDoc.SelectSingleNode("root/city").InnerText.Trim();
            this.email = email;
            // 0Ϊԣ1ΪŮ
            if (sex == "0")
                sex = "1";
            else
                sex = "0";

            //question = SqlEncode(xmlDoc.SelectSingleNode("root/question").InnerText);
            //answer = xmlDoc.SelectSingleNode("root/answer").InnerText;
   
            if (password == "")
            {
                status = 1;
                message = "Ƿʧܣ";
                return;
            }

            if (!this.CheckEmail())
            {
                return;
            }
            UserInfo ui = new UserInfo();
            ui.Email = email;
            ui.Username = username;
            ui.Password = password;
            ui.Province = getAreaID(province);
            ui.City = getAreaID(city);
            NetSNS.BLL.User.User User = new NetSNS.BLL.User.User();
            EnumRegister ret = User.Register(ui);
            if (ret == EnumRegister.Succeed)
            {
                status = 0;
                message = "עɹ";
            }
            else if (ret == EnumRegister.EmailRepeat)
            {
                status = 1;
                message = "Emailַעʻ";
            }
            else if (ret == EnumRegister.EmailMayNotSend)
            {
                status = 0;
                message = "Ѿɹע,Ժ,ûյʺȷʼ,ͷϵ";
            }
            else
            {
                status = 1;
                message = "ϵͳ,Ժ";
            }
        }

        private bool CheckEmail()
        {
            string email = this.email;
            if (null != email && email.Length > 0)
            {
                if (-1 == email.IndexOf("@") || -1 == email.IndexOf("."))
                {
                    this.__Throw("ȷ");
                    return false;
                }
                // ʼǷѱʹ
                int count = int.Parse(DbHelper.ExecuteScalar(CommandType.Text, "SELECT COUNT(1) FROM " + Fetch.TablePrefix + "User WHERE Email='" + email + "'").ToString(), null);
                if (count > 0)
                {
                    status = 1;
                    message = "ʼ" + email + "ѱʹã";
                    this.__Throw(message);
                    return false;
                }
            }

            return true;
        }

        //Page_Load
        private void Page_Load(object sender, EventArgs e)
        {
            // ʼ
            __Initialize();

            if (Get("syskey") != "" && Get("username") != "")
            {
                // ֤ȫ syskey
                if (!CheckSysKey())
                {
                    message = "֤ȫ벻ȷ";
                    status = 1;
                    this.__Throw(message);
                    return;
                }
                SaveUserCookie();
            }
            else
            {
                //xmlDoc = new XmlDocument();
                //try
                //{
                //    xmlDoc.Load(Request.InputStream);
                //}
                //catch
                //{
                //    message = "ĵ󣬲ֹ";
                //    status  = 1;
                //    this.__Throw(message);
                //}
                if (CheckPost())
                {
                    switch (action)
                    {
                        case "checkname":
                            {
                                CheckName();
                                break;
                            }
                        case "reguser":
                            {
                                RegUser();
                                break;
                            }
                        case "login":
                            {
                                UserLogin();
                                break;
                            }
                        case "logout":
                            {
                                Logout();
                                break;
                            }
                        case "update":
                            {
                                UpdateUser();
                                break;
                            }
                        case "delete":
                            {
                                DeleteUser();
                                break;
                            }
                        case "lock":
                            {
                                LockUser();
                                break;
                            }
                        case "getinfo":
                            {
                                GetInfo();
                                break;
                            }
                        case "checkemail":
                            {
                                CheckEmail();
                                break;
                            }
                        default:
                            {
                                message = "δָͣ";
                                status = 1;
                                this.__Throw(message);
                                break;
                            }
                    }
                }
                //OutputData();
            }
            this.__Finish();
        }

        protected override void OnInit(EventArgs e)
        {
            InitializeComponent();
            base.OnInit(e);
        }

        private void InitializeComponent()
        {
            this.Load += new EventHandler(this.Page_Load);
        }

        private string Get(string key)
        {
            if (string.IsNullOrEmpty(Request.QueryString[key]))
            {
                return "";
            }
            return Request.QueryString[key];
        }

        private string SqlEncode(string key)
        {
            return Text.SqlEncode(key);
        }



        // ֤ȫ syskey
        private bool CheckSysKey()
        {
            email = Request.QueryString["email"];
            username = Request.QueryString["username"];
            if (null == email || 0 == email.Length)
            {
                return false;
            }

            Dictionary<string, string> cfg = new Config("./pdo.config").Dict;

            string __SysKey = cfg["SYSKEY"];

            string syskey = Request.QueryString["syskey"];
            if (null == syskey || 0 == syskey.Length)
            {
                return false;
            }
            if (!this.ValidateMD5(email + __SysKey, syskey) && !this.ValidateMD5(username + __SysKey, syskey))
            {
                return false;
            }

            return true;
        }

        private bool ValidateMD5(string rawString, string md5String)
        {
            if (null == rawString || 0 == rawString.Length || null == md5String || 0 == md5String.Length)
            {
                return false;
            }

            string utf8_md5 = Text.MD5(rawString);
            if (utf8_md5 == md5String)
            {
                return true;
            }

            string req_enc_md5 = Text.MD5(rawString, 32);
            if (req_enc_md5 == md5String)
            {
                return true;
            }

            return false;
        }


        // β
        private void __Finish()
        {
            if (__Finished)
            {
                return;
            }

            __Finished = true;

            XmlTextWriter writer = null;
            try
            {
                writer = new XmlTextWriter(Response.Output);

                writer.Formatting = Formatting.Indented;

                writer.WriteStartDocument();

                writer.WriteStartElement("root");

                writer.WriteStartElement("appid");
                writer.WriteString("NetSNS");
                writer.WriteEndElement();

                writer.WriteStartElement("status");
                writer.WriteString(status.ToString());
                writer.WriteEndElement();

                writer.WriteStartElement("needcookie");
                if (null != __RequestData)
                {
                    writer.WriteString("1" == Request.QueryString["needcookie"] ? "1" : "0");
                }
                writer.WriteEndElement();

                writer.WriteStartElement("body");

                writer.WriteStartElement("message");
                writer.WriteString(message);
                writer.WriteEndElement();

                // ѡб׷ӽ
                if (null != __ResponseChoiceList && __ResponseChoiceList.Count > 0)
                {
                    string key = null;
                    for (int i = 0; i < __ResponseChoiceList.Count; i++)
                    {
                        key = __ResponseChoiceList.GetKey(i);
                        if (null != key && key.Length > 0)
                        {
                            writer.WriteStartElement(key);
                            writer.WriteString(__ResponseChoiceList[i]);
                            writer.WriteEndElement();
                        }
                    }
                }

                writer.WriteEndElement();

                writer.WriteEndElement();

                writer.WriteEndDocument();
            }
            finally
            {
                if (null != writer)
                {
                    writer.Close();
                    writer = null;
                }
            }
            using (StreamWriter fwriter = new StreamWriter(Server.MapPath("~/Api/api.log"), false))
            {
                if (0 == Get("syskey").Length && 0 == Get("username").Length && null != __RequestData)
                {
                    foreach (string key in __RequestData.Keys)
                    {
                        fwriter.Write("<" + key + ">" + __RequestData[key] + "</" + key + ">\r\n");
                    }

                    fwriter.Write("\r\n\r\n");
                }

                fwriter.Write("Request.QueryString:\r\n");
                foreach (string key in Request.QueryString.Keys)
                {
                    fwriter.Write("" + key + "=" + Request.QueryString[key] + "\r\n");
                }

                fwriter.Write("Request.Form:\r\n");
                foreach (string key in Request.Form.Keys)
                {
                    fwriter.Write("" + key + "=" + Request.Form[key] + "\r\n");
                }
            }
        }

        // Properties
        private NameValueCollection ResponseChoiceList
        {
            get
            {
                if (null == __ResponseChoiceList)
                {
                    __ResponseChoiceList = new NameValueCollection();
                }
                return __ResponseChoiceList;
            }
        }

        // ʼ
        private void __Initialize()
        {
            //  HTTP ͷ
            Response.ContentType = "text/xml";
            Response.ContentEncoding = System.Text.Encoding.GetEncoding("gb2312");

            // ʼ __RequestData 
            __RequestData = new NameValueCollection();
            if (Get("syskey") == "" || (Get("username") == "" && Get("email") == ""))
            {
                // еݲǼص __RequestData 
                XmlTextReader reader = null;
                try
                {
                    reader = new XmlTextReader(Request.InputStream);
                    xmlDoc = new XmlDocument();
                    xmlDoc.Load(reader);
                    reader.WhitespaceHandling = WhitespaceHandling.None;
                    reader.MoveToContent();

                    string value = string.Empty;
                    while (reader.Read())
                    {
                        if (1 == reader.Depth && reader.IsStartElement())
                        {
                            value = reader.ReadString();
                            if (null == value || 0 == value.Length)
                            {
                                __RequestData[reader.Name] = string.Empty;
                            }
                            else
                            {
                                __RequestData[reader.Name] = Server.UrlDecode(value);
                            }
                        }
                    }
                }
                finally
                {
                    if (null != reader)
                    {
                        reader.Close();
                        reader = null;
                    }
                }
            }
        }

        private void __Throw(string errorMessage)
        {
            this.__IsSuccess = false;
            this.__ResponseBodyMessage = "NetSNS Api ʾ" + errorMessage;
            this.__Finish();
            Response.End();
        }
        /// <summary>
        /// õID
        /// </summary>
        /// <param name="areaname"></param>
        /// <returns>ID</returns>
        private int getAreaID(string areaname)
        {
            NetSNS.BLL.User.Dict dict = new NetSNS.BLL.User.Dict();
            return dict.GetAreaID(areaname);
        }
        /// <summary>
        /// ȡõ
        /// </summary>
        /// <param name="areaid">ID</param>
        /// <returns></returns>
        private string getAreaName(int areaid)
        {
            NetSNS.BLL.User.Dict dict = new NetSNS.BLL.User.Dict();
            return dict.GetAreaName(areaid);
        }
    }
}