using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using NetSNS.Model;
using System.Data;

namespace NetSNS.BLL.User
{
    public class MiniBlog
    {
        NetSNS.DALFactory.IMiniBlog dal;
        public MiniBlog()
        {
            dal = DataAccess.CreateMiniBlog();
        }
        /// <summary>
        /// ռ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Content"></param>
        /// <param name="MType"></param>
        /// <returns></returns>
        public int SaveMini(int userId, string content, string MType)
        {
            return dal.SaveMini(userId, content, MType);
        }
        /// <summary>
        /// ɾռ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int DeleteMini(int userId, int miniId)
        {
            return dal.DeleteMini(userId, miniId, false);
        }
        /// <summary>
        /// ȡMiniBlogʵ
        /// </summary>
        /// <param name="MiniID">MiniBlogID</param>
        /// <returns></returns>
        public MiniBlogInfo GetMiniInfo(int MiniID)
        {
            return dal.GetMiniInfo(MiniID);
        }
        /// <summary>
        /// Ƿв鿴־Ȩ
        /// </summary>
        /// <param name="hostId"></param>
        /// <param name="guestId"></param>
        /// <returns></returns>
        public bool CheckAuthority(int hostId, int guestId)
        {
            if (hostId == guestId)
                return true;
            else
                return dal.CheckAuthority(hostId, guestId);
        }
        /// <summary>
        /// ȡû󷢲ռ
        /// </summary>
        /// <param name="vistor"></param>
        /// <param name="owner"></param>
        /// <returns></returns>
        public MiniBlogInfo GetLastInfo(int vistor, int owner)
        {
            return dal.GetLastInfo(vistor, owner);
        }

        /// <summary>
        /// õռǵ
        /// </summary>
        /// <param name="Mid">ռǵID</param>
        /// <returns></returns>
        public IDataReader GetMiniComment(int mid)
        {
            return dal.GetMiniComment(mid);
        }

        /// <summary>
        /// õ㲩͵
        /// </summary>
        /// <param name="mid">㲩ID</param>
        /// <returns></returns>
        public int GetMiniCount(int mid)
        {
            return dal.GetMiniCount(mid);
        }

        /// <summary>
        /// ռ
        /// </summary>
        /// <param name="mid">۵ID</param>
        /// <param name="Content"></param>
        /// <param name="UserID">û</param>
        /// <param name="CommentID">ID</param>
        public void SaveMiniComment(int mid, string Content, int UserID, int CommentID)
        {
            dal.SaveMiniComment(mid, Content, UserID, CommentID);
        }

        /// <summary>
        /// ɾռ
        /// </summary>
        /// <param name="bid"></param>
        public void DelMiniComent(int bid)
        {
            dal.DelMiniComent(bid);
        }

        /// <summary>
        /// ȡµĶMINIBLOG
        /// </summary>
        /// <param name="Num"></param>
        /// <returns></returns>
        public List<MiniBlogInfo> List(int Num)
        {
            return dal.List(Num);
        }
    }
}
