using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.BLL.User
{
    public class Movie
    {
        NetSNS.DALFactory.IMovie dal;
        public Movie()
        {
            dal = DataAccess.CreateMovie();
        }
        /// <summary>
        /// ȡŵӰ
        /// </summary>
        /// <returns></returns>
        public DataTable RandMovie()
        {
            return dal.RandMovie();
        }

        /// <summary>
        /// ȡú뿴ĵӰ
        /// </summary>
        /// <param name="UsreID">Ա</param>
        /// <returns>ݱ</returns>
        public DataTable FriendThinkLookMovie(int UsreID)
        {
            return dal.FriendThinkLookMovie(UsreID);
        }

        /// <summary>
        /// ȡ뿴ĵӰ
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        public DataTable MyThinkLookMovie(int UserID)
        {
            return dal.MyThinkLookMovie(UserID);
        }

        /// <summary>
        /// ȡúа
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns>ݱ</returns>
        public DataTable getTopFriendMovie(int UserID)
        {
            return dal.getTopFriendMovie(UserID);
        }

        /// <summary>
        /// ȡѶĳӰ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>ݱ</returns>
        public DataTable FriendMovieComm(int UserID, int MovieID)
        {
            return dal.FriendMovieComm(UserID, MovieID);
        }

        /// <summary>
        /// ӵӰ
        /// </summary>
        /// <param name="SortName"></param>
        /// <returns>ӳɹ1</returns>
        public int AddMovieSort(string SortName)
        {
            return dal.AddMovieSort(SortName);
        }

        /// <summary>
        /// ӵӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>ӳɹ1</returns>
        public int AddSortForMovie(MovieSortInfo Info)
        {
            return dal.AddSortForMovie(Info);
        }

        /// <summary>
        /// ȡõӰӦĵӰͱ
        /// </summary>
        /// <param name="movieid">Ӱ</param>
        /// <returns>ݱ</returns>
        public DataTable getSortForMovie(int movieid)
        {
            return dal.getSortForMovie(movieid);
        }

        /// <summary>
        /// ȡõӰб
        /// </summary>
        /// <returns>ݱ</returns>
        public DataTable getDictMovieSortList()
        {
            return dal.getDictMovieSortList();
        }

        /// <summary>
        /// ޸ĵӰ
        /// </summary>
        /// <param name="SortName"></param>
        /// <param name="ID">ͱ</param>
        /// <returns>޸ĳɹ1</returns>
        public int EditMovieSort(string SortName, int ID)
        {
            return dal.EditMovieSort(SortName, ID);
        }

        /// <summary>
        /// ȡõӰϢ
        /// </summary>
        /// <param name="ID">Ӱͱ</param>
        /// <returns>صӰʵ</returns>
        public Dict_MovieSortInfo MovieSortInfo(int ID)
        {
            return dal.MovieSortInfo(ID);
        }

        /// <summary>
        /// ɾӰ
        /// </summary>
        /// <param name="ID">ͱ</param>
        /// <returns>ɾɹ1</returns>
        public int DelMovieSort(int ID)
        {
            DataTable dt = dal.getMoviePostFileForSort(ID);
            DataTable dt1 = dal.getMovieUpFileForSort(ID);
            int n = dal.DelMovieSort(ID);
            if (n == 1)
            {
                string s_Rootpath = ServerInfo.GetRootPath();
                if (dt != null)
                {
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        Public.DelFile(s_Rootpath + dt.Rows[i]["PosterFile"].ToString());
                    }
                    dt.Clear(); dt.Dispose();
                }
                if (dt1 != null)
                {
                    for (int j = 0; j < dt1.Rows.Count; j++)
                    {
                        Public.DelFile(s_Rootpath + dt1.Rows[j]["FileName"].ToString());
                    }
                    dt1.Clear(); dt1.Dispose();
                }
            }
            return n;
        }

        /// <summary>
        /// ȡõӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>ݱ</returns>
        public DataTable getMovieGut(int MovieID)
        {
            return dal.getMovieGut(MovieID);
        }
        /// <summary>
        /// ӵӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>ӳɹصӰ</returns>
        public int AddMovie(MovieInfo Info)
        {
            return dal.AddMovie(Info);
        }

        /// <summary>
        /// ޸ĵӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>޸ĳɹ1</returns>
        public int EditMovie(MovieInfo Info)
        {
            MovieInfo tempinfo = this.GetMovieInfo(Info.MovieID);
            int n = dal.EditMovie(Info);
            if (n == 1 && Info.PosterFile != "")
            {
                string s_Rootpath = ServerInfo.GetRootPath();
                Public.DelFile(s_Rootpath + tempinfo.PosterFile);
            }
            return n;
        }

        /// <summary>
        /// ƼӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <returns></returns>
        public int RecMovie(int MovieID)
        {
            return dal.RecMovie(MovieID);
        }

        /// <summary>
        /// ȡƼӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <returns></returns>
        public int UnRecMovie(int MovieID)
        {
            return dal.UnRecMovie(MovieID);
        }

        /// <summary>
        /// ɾӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>ɾɹ1</returns>
        public int DelMovie(int MovieID)
        {
            MovieInfo movieinfo = new MovieInfo();
            movieinfo = GetMovieInfo(MovieID);
            DataTable dt = dal.getMoviePoster(MovieID);

            int n = dal.DelMovie(MovieID);
            if (n == 1)
            {
                string s_Rootpath = ServerInfo.GetRootPath();
                Public.DelFile(s_Rootpath + "/movie/" + movieinfo.PosterFile);
                if (dt != null)
                {
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        Public.DelFile(s_Rootpath + dt.Rows[i]["FileName"].ToString());
                    }
                    dt.Clear(); dt.Dispose();
                }
            }
            return n;
        }

        /// <summary>
        /// ȡӰʵ
        /// </summary>
        /// <param name="ID">Ӱ</param>
        /// <returns>صӰʵ</returns>
        public MoviePosterInfo getMoviePosterInfo(int ID)
        {
            return dal.getMoviePosterInfo(ID);
        }

        /// <summary>
        /// ɾӰ
        /// </summary>
        /// <param name="ID">Ӱ</param>
        /// <returns>ɾɹ1</returns>
        public int DelMoviePoster(int ID)
        {
            MoviePosterInfo posterinfo = new MoviePosterInfo();
            posterinfo = getMoviePosterInfo(ID);
            int n = dal.DelMoviePoster(ID);
            if (n == 1)
            {
                string s_Rootpath = ServerInfo.GetRootPath();
                Public.DelFile(s_Rootpath + posterinfo.FileName);
            }
            return n;
        }

        /// <summary>
        /// ޸ĵӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <param name="PosterFile">ַ</param>
        /// <returns>޸ĳɹ1</returns>
        public int SetPosterFile(int MovieID, string PosterFile)
        {
            MovieInfo movieinfo = new MovieInfo();
            movieinfo = GetMovieInfo(MovieID);
            int n = dal.SetPosterFile(MovieID, PosterFile);
            if (n == 1)
            {
                string s_Rootpath = ServerInfo.GetRootPath();
                Public.DelFile(s_Rootpath + movieinfo.PosterFile);
            }
            return n;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MovieID">ӰID</param>
        /// <returns></returns>
        public int SaveComment(int UserID, int MovieID, string Comment)
        {
            return dal.SaveComment(UserID, MovieID, Comment);
        }

        /// <summary>
        /// ȡѶĳӰ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>Ϣ</returns>
        public string getComment(int UserID, int MovieID)
        {
            return dal.getComment(UserID, MovieID);
        }

        /// <summary>
        /// Ӱ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MovieID">ӰID</param>
        /// <param name="Score">Ӱ</param>
        /// <returns></returns>
        public int SaveScore(int UserID, int MovieID, int Score)
        {
            return dal.SaveScore(UserID, MovieID, Score);
        }

        /// <summary>
        /// 뿴õӰ
        /// </summary>
        /// <param name="MovieID">ӰID</param>
        /// <param name="UserID">ûID</param>
        /// <param name="tag">trueΪ1falseΪ1</param>
        /// <returns></returns>
        public int UpdateWanna(int MovieID, int UserID, bool tag)
        {
            return dal.UpdateWanna(MovieID, UserID, tag);
        }
        /// <summary>
        /// ²뿴õӰ
        /// </summary>
        /// <param name="MovieID">ӰID</param>
        /// <param name="UserID">ûID</param>
        /// <param name="tag">trueΪ1falseΪ1</param>
        /// <returns></returns>
        public int UpdateWonna(int MovieID, int UserID, bool tag)
        {
            return dal.UpdateWonna(MovieID, UserID, tag);
        }
        /// <summary>
        /// ȡӰʵ
        /// </summary>
        /// <param name="MovieID">ӰID</param>
        /// <returns></returns>
        public MovieInfo GetMovieInfo(int MovieID)
        {
            return dal.GetMovieInfo(MovieID);
        }
        /// <summary>
        /// ϴӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>ϴɹ1</returns>
        public int AddMoviePoster(MoviePosterInfo Info)
        {
            return dal.AddMoviePoster(Info);
        }
        /// <summary>
        /// ȡõӰķ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>ڴ˼¼ط,ڷ-2</returns>
        public int getScore(int UserID, int MovieID)
        {
            return dal.getScore(UserID, MovieID);
        }

        ///// <summary>
        ///// õӰϢ
        ///// </summary>
        ///// <param name="MovieID"></param>
        ///// <returns></returns>
        //public IDataReader getMovieInfo(int MovieID)
        //{
        //    return dal.getMovieInfo(MovieID);
        //}
    }
}
