using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using NetSNS.Config;
using System.IO;
using NetSNS.Common;

namespace NetSNS.BLL.User.PicService
{
    public class GroupHeadUpload:PicUpload
    {
        private HttpPostedFile PostedFile;
        public GroupHeadUpload(HttpPostedFile postfile,int userid)
            :base(userid)
        {
            PostedFile = postfile;
        }
        public override string SaveFile()
        {
            //ϴͼƬ
            NetSNS.Common.Upload upload = new NetSNS.Common.Upload();
            upload.FileLength = PostedFile.ContentLength;
            Dictionary<string, PicConfigInfo> pci;
            pci = PicConfig.GroupHead;
            string filename = this.newFileName() + "." + this.getFileExtName(PostedFile.FileName); 
            string dirroot = PicConfig.GroupHeadRoot.Replace("{UserID}", this.UserID.ToString());
            string s_savepath = HttpContext.Current.Server.MapPath("/" + dirroot);
            if (!Directory.Exists(s_savepath))
            {
                Directory.CreateDirectory(s_savepath);
            }
            upload.SavePath = s_savepath;
            upload.Extension = "jpg,gif,bmp";
            upload.PostedFile = PostedFile;
            upload.FileName = filename;
            string s_path = "/" + dirroot + "/" + upload.FileName;
            string returnPath = string.Empty;
            if (PicConfig.GroupHeadServer != "~" && PicConfig.GroupHeadServer != "")
            {
                byte[] data=new byte[PostedFile.ContentLength];
                FileStream fs = new FileStream(PostedFile.FileName, FileMode.Open, FileAccess.Read);
                BinaryReader br = new BinaryReader(fs);
                data = br.ReadBytes((int)fs.Length);
                int i = 0;
                foreach (string k in pci.Keys)
                {
                    if (k != "")
                    {                        
                        string dir = "/" + pci[k].Directory.Replace("{UserID}", this.UserID.ToString()); ;
                        string cPath = dir + "/" + filename;
                        localhost.MySoapHeader myheader = new localhost.MySoapHeader();
                        myheader.Password = SoapPassword;
                        localhost.UploadService upservice = new localhost.UploadService();
                        upservice.MySoapHeaderValue = myheader;
                        byte[] buffer;
                        Thumbnail.CreateThumbnail(data,out buffer, pci[k].X, 0);
                        upservice.UploadFile(buffer, cPath);
                        if (i == 0)
                        {
                            returnPath = cPath;
                        }
                        i++;
                    }
                }
            }
            else
            {
                string[] arr_return = upload.UploadStart().Split('$');
                int i = 0;
                foreach (string k in pci.Keys)
                {
                    if (k != "")
                    {
                        Thumbnail thb = new Thumbnail(HttpContext.Current.Server.MapPath(s_path));
                        string dir = "/" + pci[k].Directory.Replace("{UserID}", this.UserID.ToString()); ;
                        if (!Directory.Exists(dir))
                        {
                            Directory.CreateDirectory(dir);
                        }
                        string cPath = dir + "/" + filename;
                        thb.Width = pci[k].X;
                        thb.Height = pci[k].Y;
                        thb.NewPath = HttpContext.Current.Server.MapPath(cPath);
                        thb.Make();
                        if (i == 0)
                        {
                            returnPath = cPath;
                        }
                        i++;
                    }
                }
            }
            return returnPath;
        }        
    }
}
