//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:93333147,Email:zhangyuanjun@126.com        ==
//==               Code By Arjun                           ==
//===========================================================
using System;
using System.Data;
using System.Configuration;
using System.Web;
using NetSNS.Config;
using System.IO;
using System.Drawing;
using NetSNS.Common;
using NetSNS.Model;
using NetSNS.BLL.User;
using System.Collections.Generic;

namespace NetSNS.BLL.User.PicService
{
    public class HeadUpload : PicUpload
    {
        private string dir;
        private int x;
        private int y;
        private int w;
        private int h;
        private HttpFileCollection hfc;
        private string errmsg;
        public HeadUpload(int userid, int albumid)
            : base(userid, albumid)
        {
            dir = "";
            dir += PicConfig.ProtraitServer + "/";
            dir += PicConfig.ProtraitRoot;
            string xx = HttpContext.Current.Request.QueryString["x"];
            string yy = HttpContext.Current.Request.QueryString["y"];
            string ww = HttpContext.Current.Request.QueryString["w"];
            x=0;
            y=0;
            w=150;
            h=150;
            if(!string.IsNullOrEmpty(xx))
            {
                x=int.Parse(xx);

            }
            if(!string.IsNullOrEmpty(yy))
            {
                y=int.Parse(yy);
            }
            if(!string.IsNullOrEmpty(ww))
            {
                w=int.Parse(ww);
                h=w;
            }
            hfc = HttpContext.Current.Request.Files;
            errmsg = string.Empty;
        }


        

        public override string SaveFile()
        {
            if (PicConfig.ProtraitServer != "~" && PicConfig.ProtraitServer!="")
            {
                return UploadForService();               
            }            
            string path = dir;
            path = HttpContext.Current.Server.MapPath(path);
            if (!Directory.Exists(path))
            {
                Directory.CreateDirectory(path);
            }
            int n = 0;
            for (int i = 0; i < hfc.Count; i++)
            {
                Common.Upload up = new Common.Upload();
                up.PostedFile = hfc[i];
                string fileMainName = newFileName();
                string fileExtName = getFileExtName(hfc[i].FileName);
                string filename = fileMainName + "." + fileExtName;
                //չƺļ
                if (!checkExt(fileExtName))
                {
                    errmsg += "<li>" + "ϴļչ" + "</li>";
                    continue;
                }
                if (!checkContentLength(hfc[i].ContentLength))
                {
                    errmsg += "<li>" + "ϴļ̫" + "</li>";
                    continue;
                }
                n++;
                up.Extension = fileExtName;
                up.FileLength = hfc[i].ContentLength;
                up.FileName = filename;
                up.SavePath = path;
                string err = up.UploadStart();
                if (err.IndexOf('$') != -1)
                {
                    Thumbnail.MakeAllThumbnail(path, filename, true);
                    Bitmap bmp = new Bitmap(path + "\\" + filename);
                    UpdateSQL(filename, bmp, i);
                    makeRectImage(bmp, filename, x, y, w, h); //ɼͷ                    
                }
                else
                {
                    errmsg += "<li>" + err + "</li>";
                }
                if (n != 0)
                {
                    errmsg = "";
                }
            }
            return errmsg;
        }

        private string UploadForService()
        {
            HttpFileCollection hfc = HttpContext.Current.Request.Files;
            int n = 0;
            for (int i = 0; i < hfc.Count; i++)
            {
                if (i > 0 && hfc[i].ContentLength == 0)
                {
                    errmsg += "<li>" + "ϴļ̫" + "</li>";
                    continue;
                }
                string fileMainName = newFileName();
                string fileExtName = getFileExtName(hfc[i].FileName);
                string filename = fileMainName + "." + fileExtName;
                //չƺļ
                if (!checkExt(fileExtName))
                {
                    errmsg += "<li>" + "ϴļչ" + "</li>";
                    continue;
                }
                n++;
                System.Web.HttpPostedFile pf = hfc[i];
                byte[] buffer = new byte[pf.ContentLength];
                pf.InputStream.Read(buffer, 0, buffer.Length);
                localhost.MySoapHeader myheader = new localhost.MySoapHeader();
                BLL.User.User u = new NetSNS.BLL.User.User();
                NetSNS.Model.UserInfo userinfo = u.GetUserInfo(this.UserID);
                myheader.Password = SoapPassword;
                localhost.UploadService upservice = new localhost.UploadService();
                upservice.MySoapHeaderValue = myheader;
                upservice.SaveFile(buffer, filename, true);
                upservice.MakeRectImage(buffer, filename, x, y, w, h); //ɼͷ
                //ƬϢ                
                Bitmap bmp = new Bitmap(hfc[i].InputStream);
                UpdateSQL(filename, bmp, i);
            }
            if (n != 0)
            {
                errmsg = "";
            }
            return errmsg;
        }      

        private void UpdateSQL(string filename, Bitmap bmp, int i)
        {
            //ƬϢ
            PhotoInfo phi = new PhotoInfo();
            phi.AlbumID = 0;
            phi.Comments = 0;
            phi.Description = "";
            phi.FilePath = filename;
            HttpCookie cookieToken = HttpContext.Current.Request.Cookies["SnsUserToken"];
            cookieToken.Values["headpic"] = filename;
            HttpContext.Current.Response.SetCookie(cookieToken); //дcookie
            phi.FileSize = hfc[i].ContentLength;            
            phi.Height = bmp.Height;
            phi.Width = bmp.Width;
            phi.IsCover = false;
            phi.IsLock = EnumIsLock.UnLock;
            phi.PhotoType = 0;
            phi.PostIP = this.ClientIP;
            phi.PostTime = DateTime.Now;
            phi.State = 0;
            phi.UploadUser = this.UserID;
            phi.Views = 0;
            Photo ph = new Photo();
            ph.Add(phi);
        }
    }
}
