//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:93333147,Email:zhangyuanjun@126.com        ==
//==               Code By Arjun                           ==
//===========================================================
using System;
using System.Data;
using System.Configuration;
using System.Web;
using NetSNS.Model;
using NetSNS.Config;
using NetSNS.Common;
using System.Drawing;
using System.IO;
using NetSNS.BLL.User;

namespace NetSNS.BLL.User.PicService
{
    public class PhotoUpload : PicUpload
    {
        private string dir;
        private string errmsg;
        private HttpFileCollection hfc; 
        public PhotoUpload(int userid, int albumid)
            : base(userid, albumid)
        {
            dir = string.Empty;
            dir += PicConfig.PhotoServer + "/";
            dir += PicConfig.PhotoRoot;
            hfc = HttpContext.Current.Request.Files;
            errmsg = string.Empty;
        }

        public override string SaveFile()
        {
            if (PicConfig.PhotoServer != "~" && PicConfig.PhotoServer != "")
            {
                return UploadForService();
            }
            string path = dir;
            path = HttpContext.Current.Server.MapPath(path);
            if (!Directory.Exists(path))
            {
                Directory.CreateDirectory(path);
            }
            int errexti = 0;
            int n = 0;
            for (int i = 0; i < hfc.Count; i++)
            {
                Common.Upload up = new Common.Upload();
                up.PostedFile = hfc[i];
                string fileMainName = this.newFileName();
                string fileExtName = getFileExtName(hfc[i].FileName);
                string filename = fileMainName + "." + fileExtName;

                if (i > 0 && hfc[i].ContentLength == 0)
                {
                    continue;
                }
                //չƺļ
                if (!checkExt(fileExtName))
                {
                    errexti++;
                }
                if (errexti == hfc.Count)
                {
                    errmsg += "<li>" + "ϴļչ" + "</li>";
                    continue;
                }
                if (!checkContentLength(hfc[i].ContentLength))
                {
                    errmsg += "<li>" + "ϴļ̫" + "</li>";
                    continue;
                }
                n++;
                if (!checkExt(fileExtName))
                    continue;
                up.Extension = fileExtName;
                up.FileLength = hfc[i].ContentLength;
                up.FileName = filename;
                up.SavePath = path;
                string err = up.UploadStart();
                if (err.IndexOf('$') != -1)
                {
                    Thumbnail.MakeAllThumbnail(path, filename);
                    Bitmap bmp = new Bitmap(path + "\\" + filename);
                    UploadSQL(filename, bmp, i);
                }
                else
                {
                    errmsg += "<li>" + err + "</li>";
                }
                if (n != 0)
                {
                    errmsg = "";
                }
            }
            return errmsg;
        }

        private string UploadForService()
        {
            string errmsg = string.Empty;
            HttpFileCollection hfc = HttpContext.Current.Request.Files;
            int n = 0;
            for (int i = 0; i < hfc.Count; i++)
            {
                if (i > 0 && hfc[i].ContentLength == 0)
                {
                    errmsg += "<li>" + "ϴļ̫" + "</li>";
                    continue;
                }
                string fileMainName = newFileName();
                string fileExtName = getFileExtName(hfc[i].FileName);
                string filename = fileMainName + "." + fileExtName;
                //չƺļ
                if (!checkExt(fileExtName))
                {
                    errmsg += "<li>" + "ϴļչ" + "</li>";
                    continue;
                }
                n++;
                System.Web.HttpPostedFile pf = hfc[i];
                byte[] buffer = new byte[pf.ContentLength];
                pf.InputStream.Read(buffer, 0, buffer.Length);
                localhost.MySoapHeader myheader = new localhost.MySoapHeader();
                BLL.User.User u = new NetSNS.BLL.User.User();
                NetSNS.Model.UserInfo userinfo = u.GetUserInfo(this.UserID);
                myheader.Password = SoapPassword;
                localhost.UploadService upservice = new localhost.UploadService();
                upservice.MySoapHeaderValue = myheader;
                upservice.SaveFile(buffer, filename, false);
                //ƬϢ
                Bitmap bmp = new Bitmap(hfc[i].InputStream);
                UploadSQL(filename, bmp,i);
            }
            if (n != 0)
            {
                errmsg = "";
            }
            return errmsg;
        }

        private void UploadSQL(string filename,Bitmap bmp,int i)
        {
            //ƬϢ
            PhotoInfo phi = new PhotoInfo();
            phi.AlbumID = this.AlbumID;
            phi.Comments = 0;
            phi.Description = "";
            phi.FilePath = filename;
            phi.FileSize = hfc[i].ContentLength;
            phi.Height = bmp.Height;
            phi.Width = bmp.Width;
            phi.IsCover = false;
            phi.IsLock = EnumIsLock.UnLock;
            phi.PhotoType = 1;
            phi.PostIP = this.ClientIP;
            phi.PostTime = DateTime.Now;
            phi.State = 0;
            phi.UploadUser = this.UserID;
            phi.Views = 0;
            Photo ph = new Photo();
            ph.Add(phi);
            bmp.Dispose();
        }
    }
}
