using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Web;
using System.Drawing.Imaging;
using NetSNS.Model;
using NetSNS.BLL.User;
using System.Drawing;
using NetSNS.Common;
using NetSNS.Config;

namespace NetSNS.BLL.User.PicService
{
    public class PicCam : PicUpload
    {
        private string dir;
        private string errmsg;
        private int pic_width;
        private int pic_height;
        private string bitmap_data;

        public PicCam(int userid, int albumid, int width, int height, string data)
            : base(userid, albumid)
        {
            dir = string.Empty;
            dir += PicConfig.PhotoServer + "/";
            dir += PicConfig.PhotoRoot;
            errmsg = string.Empty;
            pic_width = width;
            pic_height = height;
            bitmap_data = data;
        }


        public override string SaveFile()
        {
            Bitmap m_pic = new Bitmap(pic_width, pic_height);
            string[] m_tempPics = bitmap_data.Split(',');
            for (int i = 0; i < pic_width; i++)
            {
                for (int j = 0; j < pic_height; j++)
                {
                    uint pic_argb = (uint)long.Parse(m_tempPics[i * pic_height + j]);
                    int pic_a = (int)(pic_argb >> 24 & 0xFF);
                    int pic_r = (int)(pic_argb >> 16 & 0xFF);
                    int pic_g = (int)(pic_argb >> 8 & 0xFF);
                    int pic_b = (int)(pic_argb & 0xFF);

                    m_pic.SetPixel(i, j, Color.FromArgb(pic_a, pic_r, pic_g, pic_b));
                }
            }

            if (PicConfig.PhotoServer != "~" && PicConfig.PhotoServer != "")
            {
                return UploadForService(m_pic);
            }

            string path = dir;
            path = HttpContext.Current.Server.MapPath(path);
            if (!Directory.Exists(path))
            {
                Directory.CreateDirectory(path);
            }

            //ļ
            string saveName = Public.newFileName();
            string fileName = saveName + ".jpg";
            m_pic.Save(path + "\\" + fileName, ImageFormat.Jpeg);
            Thumbnail.MakeAllThumbnail(path, fileName);
            UploadSQL(fileName, m_pic);

            return "ɹ";
        }

        private string UploadForService(Bitmap bmp)
        {
            string errmsg = string.Empty;
            dir = "/";
            dir += PicConfig.PhotoRoot;
            string path = dir;
            path = HttpContext.Current.Server.MapPath(path);
            string fileMainName = Public.newFileName();
            string filename = fileMainName + ".jpg";

            byte[] byt = null;
            MemoryStream stream = new MemoryStream();
            bmp.Save(stream, ImageFormat.Jpeg);
            byt = stream.ToArray();

            localhost.MySoapHeader myheader = new localhost.MySoapHeader();
            BLL.User.User u = new NetSNS.BLL.User.User();
            NetSNS.Model.UserInfo userinfo = u.GetUserInfo(this.UserID);
            myheader.Password = SoapPassword;
            localhost.UploadService upservice = new localhost.UploadService();
            upservice.MySoapHeaderValue = myheader;
            upservice.SaveFile(byt, filename, false);

            UploadSQL(filename, bmp);
            return errmsg;
        }

        private void UploadSQL(string filename, Bitmap bmp)
        {
            //ƬϢ
            PhotoInfo phi = new PhotoInfo();
            phi.AlbumID = this.AlbumID;
            phi.Comments = 0;
            phi.Description = "";
            phi.FilePath = filename;
            phi.FileSize = 3072;
            phi.Height = bmp.Height;
            phi.Width = bmp.Width;
            phi.IsCover = false;
            phi.IsLock = EnumIsLock.UnLock;
            phi.PhotoType = 1;
            phi.PostIP = this.ClientIP;
            phi.PostTime = DateTime.Now;
            phi.State = 0;
            phi.UploadUser = this.UserID;
            phi.Views = 0;
            Photo ph = new Photo();
            ph.Add(phi);
            bmp.Dispose();
        }
    }
}
