using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Xml;

namespace NetSNS.Common
{
    public class HttpModule : IHttpModule
    {
        /// <summary>
        /// ʵֽӿڵ Init 
        /// </summary>
        /// <param name="app"></param>
        public void Init(HttpApplication app)
        {
            app.BeginRequest += new EventHandler(this.ModuleRewriter_BeginRequest);
        }

        /// <summary>
        /// ʵֽӿڵ Dispose 
        /// </summary>
        public void Dispose() { }

        /// <summary>
        /// BeginRequestӦ¼
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ModuleRewriter_BeginRequest(object sender, EventArgs e)
        {
            HttpApplication app = (HttpApplication)sender;
            Rewrite(app.Request.Path, app);
        }

        /// <summary>
        /// URLд
        /// </summary>
        /// <param name="requestedPath"></param>
        /// <param name="app"></param>
        protected void Rewrite(string requestedPath, HttpApplication app)
        {
            string urlstr = requestedPath.ToLower();
            string reqstr = string.Empty;
            HttpContext Context = app.Context;
            int pos = requestedPath.IndexOf('?');
            if (pos > 0)
            {
                urlstr = urlstr.Substring(0, pos);
                reqstr = requestedPath.Substring(pos);
            }
            SiteUrls site = SiteUrls.GetInstance();
            string newurl = site.GetValue(urlstr);
            if (newurl == null)
                return;
            else
                Context.RewritePath(newurl + reqstr);
            //string requestPath = context.Request.Path.ToLower();
            //ʹαaspx, :showforum-1.aspx.
            /*
            if (config.Aspxrewrite == 1)
            {
                foreach (SiteUrls.URLRewrite url in SiteUrls.GetSiteUrls().Urls)
                {
                    if (Regex.IsMatch(requestPath, url.Pattern, Utils.GetRegexCompiledOptions() | RegexOptions.IgnoreCase))
                    {
                        string newUrl = Regex.Replace(requestPath.Substring(context.Request.Path.LastIndexOf("/")), url.Pattern, url.QueryString, Utils.GetRegexCompiledOptions() | RegexOptions.IgnoreCase);
                        if (config.BrowseCreateTemplate == 1)
                        {
                            CreateTemplate(forumPath, Templates.GetTemplateItem(int.Parse(strTemplateid)).Directory, url.Page.Replace("/", ""), int.Parse(strTemplateid));
                        }
                        //ָͨģ
                        if (config.Specifytemplate)
                        {
                            strTemplateid = SelectTemplate(strTemplateid, url.Page, newUrl);
                        }
                        context.RewritePath(forumPath + "aspx/" + strTemplateid + url.Page, string.Empty, newUrl + "&selectedtemplateid=" + strTemplateid);

                        return;
                    }
                }
            }*/
        }
    }


    /// <summary>
    /// վαUrlϢ
    /// </summary>
    public class SiteUrls
    {
        #region ڲԺͷ

        private static object lockPad = new object();
        private static volatile SiteUrls instance = null;
        private Dictionary<string, string> _UrlList;

        public Dictionary<string, string> UrlList
        {
            get
            {
                return _UrlList;
            }
            set
            {
                _UrlList = value;
            }
        }
        public string GetValue(string key)
        {
            string value = null;
            if (_UrlList.TryGetValue(key, out value))
                return value;
            else
                return null;
        }
        private SiteUrls()
        {
            string SiteUrlsFile = HttpContext.Current.Server.MapPath("~/config/url.config");
            _UrlList = new Dictionary<string, string>();
            XmlDocument xml = new XmlDocument();
            xml.Load(SiteUrlsFile);
            XmlNode root = xml.SelectSingleNode("urls");
            foreach (XmlNode n in root.ChildNodes)
            {
                if (n.NodeType != XmlNodeType.Comment && n.Name.ToLower() == "rewrite")
                {
                    XmlAttribute pseudo = n.Attributes["pseudourl"];
                    XmlAttribute real = n.Attributes["realurl"];

                    if (pseudo != null && real != null)
                    {
                        if (!_UrlList.ContainsKey(pseudo.Value))
                            _UrlList.Add(pseudo.Value.ToLower(), real.Value);
                    }
                }
            }
        }
        #endregion

        public static SiteUrls GetInstance()
        {
            if (instance == null)
            {
                lock (lockPad)
                {
                    if (instance == null)
                    {
                        instance = new SiteUrls();
                    }
                }
            }
            return instance;
        }

        public static void SetInstance(SiteUrls anInstance)
        {
            if (anInstance != null)
                instance = anInstance;
        }

        public static void SetInstance()
        {
            SetInstance(new SiteUrls());
        }
    }
    /*
    /// <summary>
    /// URLдϢ
    /// </summary>
    public class RewirteInfo
    {
        private string _pseudo;
        private string _real;
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="pseudo">αַ</param>
        /// <param name="real">ʵʵַ</param>
        public RewirteInfo(string pseudo, string real)
        {
            _pseudo = pseudo;
            _real = real;
        }
        /// <summary>
        /// αַ
        /// </summary>
        public string PseudoUrl
        {
            get { return _pseudo; }
        }
        /// <summary>
        /// ʵʵַ
        /// </summary>
        public string RealUrl
        {
            get { return _real; }
        }
    }
    */
}
