using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Xml;
//using NetSNS.Common;

namespace NetSNS.Config
{
    /// <summary>
    /// ʼص
    /// </summary>
    public class EmailConfig
    {
        #region ˽б
        static private readonly string configpath = "~/config/email.config";
        static private string _mode;
        static private string _host;
        static private int _port;
        static private string _from;
        static private string _username;
        static private string _password;
        static private bool _enablessl;
        #endregion
        /// <summary>
        /// ̬캯
        /// </summary>
        static EmailConfig()
        {
            Reload();
        }
        /// <summary>
        /// ¶ȡConfigļȡֵ
        /// </summary>
        static public void Reload()
        {
            string filepath = HttpContext.Current.Server.MapPath(configpath);
            XmlDocument xml = new XmlDocument();
            xml.Load(filepath);
            XmlNode rootpor = xml.SelectSingleNode("email/setting");
            _mode = rootpor.Attributes["current"].Value;
            foreach (XmlNode n in rootpor.ChildNodes)
            {
                if (n.NodeType != XmlNodeType.Comment && n.Name.ToLower() == "parameter")
                {
                    _host = n.Attributes["host"].Value;
                    _port = int.Parse(n.Attributes["port"].Value);
                    _from = n.Attributes["from"].Value;
                    _username = n.Attributes["username"].Value;
                    _password = n.Attributes["password"].Value;
                    if (n.Attributes["enablessl"].Value.ToLower() == "true")
                        _enablessl = true;
                    else
                        _enablessl = false;
                }
            }
        }
        /// <summary>
        /// ʼʽ
        /// </summary>
        static public string mode
        {
            get { return _mode; }
        }
        /// <summary>
        /// 
        /// </summary>
        static public string host
        {
            get { return _host; }
        }
        /// <summary>
        /// ˿
        /// </summary>
        static public int port
        {
            get { return _port; }
        }
        /// <summary>
        /// ʼַ
        /// </summary>
        static public string from
        {
            get { return _from; }
        }
        /// <summary>
        /// û
        /// </summary>
        static public string username
        {
            get { return _username; }
        }
        /// <summary>
        /// 
        /// </summary>
        static public string password
        {
            get { return _password; }
        }
        /// <summary>
        /// SSL
        /// </summary>
        static public bool enablessl
        {
            get { return _enablessl; }
        }
        
        /// <summary>
        /// һصʼ
        /// </summary>
        static public string retrieve
        {
            get { return BaseConfig.GetConfigValue("matter/retrievepwd", HttpContext.Current.Server.MapPath(configpath), true); }
        }
        /// <summary>
        /// עᷢʼ
        /// </summary>
        static public string register
        {
            get { return BaseConfig.GetConfigValue("matter/register", HttpContext.Current.Server.MapPath(configpath), true); }
        }
        /// <summary>
        /// Ѽʼ
        /// </summary>
        static public string invite
        {
            get { return BaseConfig.GetConfigValue("matter/invite", HttpContext.Current.Server.MapPath(configpath), true); }
        }
        /// <summary>
        /// ȡӦĵ¼ҳַ
        /// </summary>
        /// <param name="emailAddress"></param>
        /// <returns></returns>
        static public string GetEmailLoginUrl(string emailAddress)
        {
            if (emailAddress == null)
                return string.Empty;
            string addr = Regex.Match(emailAddress, "@.+$", RegexOptions.Compiled).Value;
            if (addr == null || addr.Trim() == string.Empty)
                return string.Empty;
            string filepath = HttpContext.Current.Server.MapPath(configpath);
            XmlDocument xml = new XmlDocument();
            xml.Load(filepath);
            XmlNode rootpor = xml.SelectSingleNode("email/loginurl");
            foreach (XmlNode n in rootpor.ChildNodes)
            {
                if (n.NodeType != XmlNodeType.Comment && n.Name.ToLower() == "email")
                {
                    string s = n.Attributes["address"].Value;
                    if (s.ToLower() == addr.ToLower())
                        return n.InnerText;
                }
            }
            return string.Empty;
        }
    }
}
