using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Web;

namespace NetSNS.Config
{
    /// <summary>
    /// Ⱥ࣬
    /// </summary>
    public class GroupConfig
    {
        private static readonly string path = "/config/Group.config";
        private static Dictionary<int, string> _BookType = new Dictionary<int, string>();
        private static Dictionary<int, string> _GroupType = new Dictionary<int, string>();
        /// <summary>
        /// 
        /// </summary>
        static public Dictionary<int, string> BookType
        {
            get { return _BookType; }
        }
        /// <summary>
        /// Ⱥ
        /// </summary>
        static public Dictionary<int, string> GroupType
        {
            get { return _GroupType; }
        }
        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="i"></param>
        /// <returns></returns>
        static public string GetBookType(int i)
        {
            return _BookType[i];
        }
        /// <summary>
        /// ȡȺ
        /// </summary>
        /// <param name="i"></param>
        /// <returns></returns>
        static public string GetGroupType(int i)
        {
            return _GroupType[i];
        }
        static GroupConfig()
        {
            reload();
        }
        static public void reload()
        {
            string filepath = "Group.config";
            try
            {
                filepath = HttpContext.Current.Server.MapPath(path);
            }
            catch
            {
                if (!string.IsNullOrEmpty(filepath))
                {
                    filepath = "Group.config";
                }
            }
            XmlDocument xml = new XmlDocument();
            xml.Load(filepath);
            XmlNodeList nodes = xml.SelectNodes("/config/grouptype/add");
            for (int i = 0; i < nodes.Count; i++)
            {
                int key = 0;
                string value = string.Empty;
                XmlNode node = nodes[i];
                XmlAttributeCollection xac = node.Attributes;
                for (int j = 0; j < xac.Count; j++)
                {
                    switch (xac[j].Name)
                    {
                        case "key":
                            int.TryParse(xac[j].InnerText,out key);
                            break;
                        case "value":
                            value = xac[j].InnerText;
                            break;
                    }
                }
                _GroupType.Add(key, value);
            }
            nodes = xml.SelectNodes("/config/booktype/add");
            for (int i = 0; i < nodes.Count; i++)
            {
                int key = 0;
                string value = string.Empty;
                XmlNode node = nodes[i];
                XmlAttributeCollection xac = node.Attributes;
                for (int j = 0; j < xac.Count; j++)
                {
                    switch (xac[j].Name)
                    {
                        case "key":
                            int.TryParse(xac[j].InnerText, out key);
                            break;
                        case "value":
                            value = xac[j].InnerText;
                            break;
                    }
                }
                _BookType.Add(key, value);
            }
        }

    }
}
