using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Xml;
//using NetSNS.Common;
using System.IO;

namespace NetSNS.Config
{
    /// <summary>
    /// ͼƬͼص
    /// </summary>
    public class PicConfig
    {
        #region ˽б
        static private readonly string configpath = "~/config/photo.config";
        static private string _protraitserv;
        static private string _photoserv;
        static private string _protraitdir;
        static private string _photodir;

        static private Dictionary<string, PicConfigInfo> _portrait = new Dictionary<string, PicConfigInfo>();
        static private Dictionary<string, PicConfigInfo> _photo = new Dictionary<string, PicConfigInfo>();
        static private Dictionary<string, PicConfigInfo> _grouphead = new Dictionary<string, PicConfigInfo>();
        static private string _groupheaddir;
        static private string _groupheadserver;

        static private string _blogserv;
        static private string _blogorigdir;
        static private string _blogbrevdir;
        #endregion
        /// <summary>
        /// ̬캯
        /// </summary>
        static PicConfig()
        {
            Reload();
        }
        /// <summary>
        /// ¶ȡConfigļȡֵ
        /// </summary>
        static public void Reload()
        {
            string filepath = HttpContext.Current.Server.MapPath(configpath);
            XmlDocument xml = new XmlDocument();
            xml.Load(filepath);
            #region ͷ
            XmlNode rootpor = xml.SelectSingleNode("picture/portrait");
            _protraitserv = rootpor.Attributes["server"].Value;
            _protraitdir = rootpor.Attributes["originaldir"].Value;
            foreach (XmlNode n in rootpor.ChildNodes)
            {
                if (n.NodeType != XmlNodeType.Comment)
                {
                    if (n.Name.ToLower() == "breviary")
                    {
                        XmlAttribute name = n.Attributes["name"];
                        XmlAttribute dir = n.Attributes["directory"];
                        XmlAttribute wid = n.Attributes["width"];
                        XmlAttribute hei = n.Attributes["height"];
                        XmlAttribute pri = n.Attributes["priority"];
                        PicConfigInfo info = new PicConfigInfo();
                        info.Directory = dir.Value;
                        if (string.IsNullOrEmpty(wid.Value))
                        {
                            info.X = 1;
                        }
                        else
                        {
                            info.X = Convert.ToInt32(wid.Value);
                        }
                        if (string.IsNullOrEmpty(hei.Value))
                        {
                            info.Y = 1;
                        }
                        else
                        {
                            info.Y = Convert.ToInt32(hei.Value);
                        }
                        if (string.IsNullOrEmpty(pri.Value))
                        {
                            info.Priority = 1;
                        }
                        else
                        {
                            info.Priority = Convert.ToInt32(pri.Value);
                        }
                        try
                        {
                            _portrait.Add(name.Value, info);
                        }
                        catch
                        {
                        }
                    }
                }
            }
            #endregion
            #region Ƭ
            XmlNode rootpho = xml.SelectSingleNode("picture/photo");
            _photoserv = rootpho.Attributes["server"].Value;
            _photodir = rootpho.Attributes["originaldir"].Value;
            foreach (XmlNode n in rootpho.ChildNodes)
            {
                if (n.NodeType != XmlNodeType.Comment)
                {
                    if (n.Name.ToLower() == "breviary")
                    {
                        XmlAttribute name = n.Attributes["name"];
                        XmlAttribute dir = n.Attributes["directory"];
                        XmlAttribute wid = n.Attributes["width"];
                        XmlAttribute hei = n.Attributes["height"];
                        XmlAttribute pri = n.Attributes["priority"];
                        PicConfigInfo info = new PicConfigInfo();
                        info.Directory = dir.Value;
                        if (string.IsNullOrEmpty(wid.Value))
                        {
                            info.X = 1;
                        }
                        else
                        {
                            info.X = Convert.ToInt32(wid.Value);
                        }
                        if (string.IsNullOrEmpty(hei.Value))
                        {
                            info.Y = 1;
                        }
                        else
                        {
                            info.Y = Convert.ToInt32(hei.Value);
                        }
                        if (string.IsNullOrEmpty(pri.Value))
                        {
                            info.Priority = 1;
                        }
                        else
                        {
                            info.Priority = Convert.ToInt32(pri.Value);
                        }
                        try
                        {
                            _photo.Add(name.Value, info);
                        }
                        catch
                        {
                        }
                    }
                }
            }
            #endregion
            #region Ⱥͷ
            XmlNode rootgrouphead = xml.SelectSingleNode("picture/grouphead");
            _groupheadserver = rootgrouphead.Attributes["server"].Value;
            _groupheaddir = rootgrouphead.Attributes["originaldir"].Value;
            foreach (XmlNode n in rootgrouphead.ChildNodes)
            {
                if (n.NodeType != XmlNodeType.Comment)
                {
                    if (n.Name.ToLower() == "breviary")
                    {
                        XmlAttribute name = n.Attributes["name"];
                        XmlAttribute dir = n.Attributes["directory"];
                        XmlAttribute wid = n.Attributes["width"];
                        XmlAttribute hei = n.Attributes["height"];
                        XmlAttribute pri = n.Attributes["priority"];
                        PicConfigInfo info = new PicConfigInfo();
                        info.Directory = dir.Value;
                        if (string.IsNullOrEmpty(wid.Value))
                        {
                            info.X = 1;
                        }
                        else
                        {
                            info.X = Convert.ToInt32(wid.Value);
                        }
                        if (string.IsNullOrEmpty(hei.Value))
                        {
                            info.Y = 1;
                        }
                        else
                        {
                            info.Y = Convert.ToInt32(hei.Value);
                        }
                        if (string.IsNullOrEmpty(pri.Value))
                        {
                            info.Priority = 1;
                        }
                        else
                        {
                            info.Priority = Convert.ToInt32(pri.Value);
                        }
                        try
                        {
                            _grouphead.Add(name.Value, info);
                        }
                        catch
                        {
                        }
                    }
                }
            }
            #endregion
            #region ־
            XmlNode rootblog = xml.SelectSingleNode("picture/blogimg");
            _blogserv = rootblog.Attributes["server"].Value;
            _blogorigdir = rootblog.Attributes["originaldir"].Value;
            _blogbrevdir = rootblog.Attributes["breviary"].Value;
            #endregion
        }
        /// <summary>
        /// ȡԭʼͼƬĿ¼
        /// </summary>
        static public string PhotoRoot
        {
            get { return _photodir; }
        }
        /// <summary>
        /// ȡԭʼͷĿ¼
        /// </summary>
        static public string ProtraitRoot
        {
            get { return _protraitdir; }
        }
        /// <summary>
        /// ȡͷ
        /// </summary>
        static public string ProtraitServer
        {
            get { return _protraitserv; }
        }
        /// <summary>
        /// ȡƬ
        /// </summary>
        static public string PhotoServer
        {
            get { return _photoserv; }
        }
        /// <summary>
        /// ͷͼϢ
        /// </summary>
        static public Dictionary<string, PicConfigInfo> Portrait
        {
            get { return _portrait; }
        }
        /// <summary>
        /// ƬͼϢ
        /// </summary>
        static public Dictionary<string, PicConfigInfo> Photo
        {
            get { return _photo; }
        }
        /// <summary>
        /// ȺͷϢ
        /// </summary>
        static public Dictionary<string, PicConfigInfo> GroupHead
        {
            get { return _grouphead; }
        }
        /// <summary>
        /// Ⱥͷ·
        /// </summary>
        static public string GroupHeadRoot
        {
            get { return _groupheaddir; }
        }
        /// <summary>
        /// Ⱥͷ
        /// </summary>
        static public string GroupHeadServer
        {
            get { return _groupheadserver; }
        }
        /// <summary>
        /// ־ͼƬ
        /// </summary>
        static public string BlogServer
        {
            get { return _blogserv; }
        }
        /// <summary>
        /// ԭʼ־ͼƬĿ¼
        /// </summary>
        static public string BlogOrigDir
        {
            get { return _blogorigdir; }
        }
        /// <summary>
        /// ־ͼƬĿ¼
        /// </summary>
        static public string BlogBrevDir
        {
            get { return _blogbrevdir; }
        }
        /// <summary>
        /// ȡͷصͼϢ
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        static public PicConfigInfo GetPortrtBrevi(string name)
        {
            PicConfigInfo value;
            if (_portrait.TryGetValue(name, out value))
                return value;
            else
                return null;
        }
        /// <summary>
        /// ȡƬصͼϢ
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        static public PicConfigInfo GetPhotoBrevi(string name)
        {
            PicConfigInfo value;
            if (_photo.TryGetValue(name, out value))
                return value;
            else
                return null;
        }
        /// <summary>
        /// ȡȺͷ
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        static public PicConfigInfo GetGroupheadBrevi(string name)
        {
            PicConfigInfo value;
            if (_grouphead.TryGetValue(name, out value))
                return value;
            else
                return null;
        }
    }
    /// <summary>
    /// Ƭ,ͷصϢ
    /// </summary>
    public class PicConfigInfo
    {
        private string _directory;
        private int _x;
        private int _y;
        private int _priority;
        /// <summary>
        /// 
        /// </summary>
        public int X
        {
            get { return _x; }
            set { _x = value; }
        }
        /// <summary>
        /// Ŀ
        /// </summary>
        public string Directory
        {
            get { return _directory; }
            set { _directory = value; }
        }
        /// <summary>
        /// ߶
        /// </summary>
        public int Y
        {
            get { return _y; }
            set { _y = value; }
        }
        /// <summary>
        /// ,0ʾ,ʾ߶
        /// </summary>
        public int Priority
        {
            get { return _priority; }
            set { _priority = value; }
        }

    }
}
