using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using NetSNS.Model;
using System.Data;

namespace NetSNS.DALFactory
{
    public interface IMiniBlog
    {
        /// <summary>
        /// ռ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Content"></param>
        /// <param name="MType"></param>
        /// <returns></returns>
        int SaveMini(int userId, string content, string MType);
        /// <summary>
        /// ɾռ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        int DeleteMini(int userId, int miniId, bool isAdmin);
        /// <summary>
        /// ȡMiniBlogʵ
        /// </summary>
        /// <param name="MiniID">MiniBlogID</param>
        /// <returns></returns>
        MiniBlogInfo GetMiniInfo(int MiniID);
        /// <summary>
        /// Ƿв鿴־Ȩ
        /// </summary>
        /// <param name="hostId"></param>
        /// <param name="guestId"></param>
        /// <returns></returns>
        bool CheckAuthority(int hostId, int guestId);
        /// <summary>
        /// ȡû󷢲ռ
        /// </summary>
        /// <param name="vistor"></param>
        /// <param name="owner"></param>
        /// <returns></returns>
        MiniBlogInfo GetLastInfo(int vistor, int owner);

        /// <summary>
        /// õռǵ
        /// </summary>
        /// <param name="Mid">ռǵID</param>
        /// <returns></returns>
        IDataReader GetMiniComment(int Mid);

        /// <summary>
        /// õ㲩͵
        /// </summary>
        /// <param name="mid">㲩ID</param>
        /// <returns></returns>
        int GetMiniCount(int mid);

        /// <summary>
        /// ռ
        /// </summary>
        /// <param name="mid">۵ID</param>
        /// <param name="Content"></param>
        /// <param name="UserID">û</param>
        /// <param name="CommentID">ID</param>
        void SaveMiniComment(int mid, string Content, int UserID, int CommentID);
        /// <summary>
        /// ɾռ
        /// </summary>
        /// <param name="bid"></param>
        void DelMiniComent(int bid);


        /// <summary>
        /// ȡµĶMINIBLOG
        /// </summary>
        /// <param name="Num"></param>
        /// <returns></returns>
        List<MiniBlogInfo> List(int Num);

        #region Ա̨
        /// <summary>
        /// 㲩
        /// </summary>
        /// <param name="searchCondition">:1.;2.־</param>
        /// <param name="keyword">ؼ</param>
        /// <param name="orderType">ʽ:1.;2.;3.</param>
        /// <returns></returns>
        DataTable Search(int searchCondition, string keyword, int orderType, int pageIndex, int pageSize, out int recordCount, out int pageCount);

        void updateMiniRec(int ID, int NUM);
        /// <summary>
        /// ռ
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="blogId"></param>
        /// <param name="lockSate"></param>
        int ChangeLock(int userId, int miniBlogId, bool lockSate);
        #endregion
    }
    public sealed partial class DataAccess
    {
        public static IMiniBlog CreateMiniBlog()
        {
            string className = path + ".MiniBlog";
            return (IMiniBlog)Assembly.Load(path).CreateInstance(className);
        }
    }
}
