using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Reflection;
using NetSNS.Model;

namespace NetSNS.DALFactory
{
    public interface IUser
    {
        /// <summary>
        /// жǷѾע
        /// </summary>
        /// <param name="UserEmail">ûEmail</param>
        /// <returns></returns>
        bool IsExist(string UserEmail);
        /// <summary>
        /// ûע
        /// </summary>
        /// <param name="ui">û</param>
        /// <returns>Ӱ</returns>
        EnumRegister Register(UserInfo ui);
        /// <summary>
        /// עȷ,֤ͬʱ¼
        /// </summary>
        /// <param name="code"></param>
        /// <param name="userId"></param>
        /// <param name="userName"></param>
        /// <param name="md5Password"></param>
        /// <returns>0ɹ,-1֤벻ȷ,-2û֤ͨ,-3޸ʧ</returns>
        int RegisterConfirm(string code, out int userId, out string userName, out string md5Password);
        /// <summary>
        /// ûע
        /// </summary>
        /// <param name="ui"></param>
        /// <param name="code"></param>
        /// <returns></returns>
        EnumRegister InviterRegister(UserInfo ui, EnumFriendInviteMode mode, string code, out int userId);
        /// <summary>
        /// ˳
        /// </summary>
        /// <param name="Email">ûEmail</param>
        /// <returns></returns>
        int Exit(int userID);
        /// <summary>
        /// ޸û
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="NewName">û</param>
        /// <returns></returns>
        int ChangeName(int UserID, string NewName);
        /// <summary>
        /// ޸Email
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Email">Email</param>
        /// <returns></returns>
        int ChangeEmail(int UserID, string Email);
        /// <summary>
        /// ޸
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Password">Password</param>
        /// <returns></returns>
        int ChangePassword(int UserID, string Password);
        /// <summary>
        /// ޸ڵ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Province">ʡ</param>
        /// <param name="City"></param>
        /// <returns></returns>
        int ChangeAddr(int UserID, int Province, int City);
        /// <summary>
        /// MSN
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MSN">MSNʺ</param>
        /// <returns></returns>
        int ChangeMSN(int UserID, string MSN);
        /// <summary>
        /// GTalk
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MSN">GTalkʺ</param>
        /// <returns></returns>
        int ChangeGTalk(int UserID, string GTalk);
        /// <summary>
        /// Mobile
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MSN">Mobileʺ</param>
        /// <returns></returns>
        int ChangeMobile(int UserID, string Mobile);
        #region ¼
        /// <summary>
        /// ¼
        /// </summary>
        /// <param name="Email">ûEmail</param>
        /// <param name="Password"></param>
        /// <returns></returns>
        EnumLoginState Login(string email, string password, out int userId, out string userName, out string portrait);
        /// <summary>
        /// ¼
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="password"></param>
        /// <returns></returns>
        EnumLoginState CheckLogin(int userId, string password);
        #endregion
        /// <summary>
        /// ȡûʵ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        UserInfo GetUserInfo(int UserID);
        /// <summary>
        /// ȡûϢʵ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        UserBasicInfo GetUserBasic(int UserID);
        /// <summary>
        /// ȡ˽˶̬ʵ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        UserSettingInfo GetUSetInfo(int UserID);

        #region
        //༭Ϣ
        //༭Ϣ
        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="ubi">ûϢ</param>
        /// <param name="Province">ʡ</param>
        /// <param name="City"></param>
        /// <returns></returns>
        int SaveBasic(NetSNS.Model.UserBasicInfo ubi, int Province, int City);

        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="listEdu">Ϣ</param>
        /// <returns></returns>
        int SaveEducation(List<NetSNS.Model.UserEducationInfo> listEdu);
        /// <summary>
        /// ɾѧУ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        int DelEducation(int ID);
        /// <summary>
        /// 湤Ϣ
        /// </summary>
        /// <param name="listCareer">Ϣ</param>
        /// <returns></returns>
        int SaveCareer(List<NetSNS.Model.UserCareerInfo> listCareer);
        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="ID">ϢID</param>
        /// <returns></returns>
        int DelCareer(int ID);
        #endregion
        #region ȡûһЩصϢ
        /// <summary>
        /// ȡûĽϢ
        /// </summary>
        /// <param name="userid">鿴ID</param>
        /// <param name="friendid">鿴ID</param>
        /// <returns></returns>
        DataTable GetEducation(int userid, int friendid);
        /// <summary>
        /// ȡùصϢ
        /// </summary>
        /// <param name="userid">鿴ID</param>
        /// <param name="friendid">鿴ID</param>
        /// <returns></returns>
        DataTable GetCareer(int userid, int friendid);
        #endregion
        /// <summary>
        /// ȡû߽Ϣ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        UserEducationInfo LastEducInfo(int UserID);
        /// <summary>
        /// ȡѧУϢ
        /// </summary>
        /// <param name="SchoolID">ѧУ</param>
        /// <returns></returns>
        DictSchoolInfo GetSchoolInfo(int SchoolID);
        /// <summary>
        /// ȡԺϵϢ
        /// </summary>
        /// <param name="AcademyID">Ժϵ</param>
        /// <returns></returns>
        DictAcademyInfo GetAcademyInfo(int AcademyID);
        /// <summary>
        /// ȡĳһû
        /// </summary>
        /// <param name="topNum"></param>
        /// <param name="networkId"></param>
        /// <returns></returns>
        DataTable GetUserByNetwork(int topNum, int networkId, int userId);
        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="Email">Email</param>
        /// <returns>0,ɹ,-2,Ч</returns>
        int Retrieve(string email);
        /// <summary>
        /// ,޸ĵ¼
        /// </summary>
        /// <param name="newPwd"></param>
        /// <param name="code"></param>
        /// <returns>0ɹ-1ûҵص¼,-2Ч,-3Ч</returns>
        int ResetPwd(string newPwd, string code, out int userId, out string userName, out string userPortrait);

        /// <summary>
        /// ȡ˽Ϣ
        /// </summary>
        /// <param name="UserID">ûIDϢ</param>
        /// <returns></returns>
        PrivacyInfo GetPrivacy(int UserID);
        /// <summary>
        /// ˽Ϣ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="privacyinfo">˽Ϣ</param>
        /// <returns></returns>
        int SetPrivacy(int UserID, PrivacyInfo privacyinfo);

        /// <summary>
        /// û
        /// </summary>
        /// <param name="us">ʵ</param>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        int UpdateUser(NetSNS.Model.UserInfo us, int UserID);

        /// <summary>
        /// ɾԱ
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        int DelUser(int UserID, int flag);

        /// <summary>
        /// »ԱϢ
        /// </summary>
        /// <param name="info"></param>
        /// <returns></returns>
        int UpdateUserBase(UserBasicInfo info);

        /// <summary>
        /// ޸ĻԱϵϢɼ
        /// </summary>
        /// <param name="ub"></param>
        /// <returns></returns>
        int UpdateUserPrivacy(UserBasicInfo ub);

        /// <summary>
        /// IDȡϢ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        DataTable getCareerByID(int id);

        /// <summary>
        /// IDȡϢ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        DataTable getEducationByID(int id);

        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        int LockEducation(int ID, int value);


        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="value"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        int LockDelArea(int ID, int value, int flag);

        /// <summary>
        /// ӡ޸ĵϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="name"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        int UpdateAddArea(int ID, int ParentID, string name, int flag);

        /// <summary>
        /// жϵм
        /// </summary>
        /// <param name="ParentID"></param>
        /// <returns></returns>
        int getArea(int ParentID);

        #region ûע
        /// <summary>
        /// ȡϢ
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        InviteInfo GetInviteInfo(string code, EnumFriendInviteMode mode, out Dictionary<string, string> friends);
        #endregion

        /// <summary>
        /// жûǷ
        /// </summary>
        /// <param name="UserId"></param>
        bool CheckUser(int UserId);

        int GetUserCity(int UserID);
        /// <summary>
        /// ȡUSerID
        /// </summary>
        /// <returns></returns>
        int GetMaxUserID();

        IDataReader GetRecUser(int flg);

        IDataReader GetMiniBlog(int Num);

        void GetInvReg(int UserID);

        void updateinte(int UserID, int Point, int Flag, int ifoat, string Content);

        IDataReader GetUserPoint(int UserID);

        DataTable SearchPointHistoryPage(int UserID,string sTime, string eTime, int PageIndex, int PageSize, out int RecordCount, out int PageCount);
        /// <summary>
        /// ֤
        /// </summary>
        /// <param name="kid">ûID</param>
        /// <param name="md5email">MD5EMAIL</param>
        /// <param name="ui">ûϢ</param>
        /// <returns></returns>
        bool checkForKanshu(int kid, string md5email, out UserInfo ui);
        /// <summary>
        /// IDȡûϢ
        /// </summary>
        /// <param name="kid">ûID</param>
        /// <returns></returns>
        UserInfo GetUserInfoByKid(int kid);

        IDataReader GetGameInfo(int ID);

        IDataReader GetGameClass(int ID);

        /// <summary>
        /// ȡԱϢ
        /// </summary>
        /// <param name="ID">Ա</param>
        /// <returns></returns>
        IDataReader getAdmin(int ID);

        /// <summary>
        /// Ӹ¹Ա
        /// </summary>
        /// <param name="loginname">½</param>
        /// <param name="TrueName">ʵ</param>
        /// <param name="Pwd">Ա</param>
        /// <param name="AdminID"></param>
        /// <param name="flag">0ӣ1޸</param>
        /// <returns></returns>
        int addUpdateAdmin(string loginname, string TrueName, string Pwd, int AdminID, int flag);

        /// <summary>
        /// ɾԱ
        /// </summary>
        /// <param name="AdminID">Ա</param>
        /// <param name="value">05ɾ</param>
        /// <returns></returns>
        int deleteLock(int AdminID, int value);
        /// <summary>
        /// ȡûID by email
        /// </summary>
        /// <param name="email">ʼ</param>
        /// <returns></returns>
        int GetIdByEmail(string email);
         /// <summary>
        /// ¼
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Password"></param>
        /// <returns></returns>
        EnumLoginState Login(int UserID, string password, out string userName, out string portrait);
        /// <summary>
        /// ȡÿûID
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        int GetKid(int UserID);
    }
    public sealed partial class DataAccess
    {
        public static IUser CreateUser()
        {
            string className = path + ".User";
            return (IUser)Assembly.Load(path).CreateInstance(className);
        }
    }
}
