using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    public class Account : DbBase, IAccount
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="provice">ʡ</param>
        /// <param name="city"></param>
        /// <returns></returns>
        public int UpdateNetSet(int provice, int city,int userid)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string sql = "update NT_User set Province=" + provice + ",City=" + city + " where UserID=" + userid;
                int n = DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
                if (n == 1)
                {
                    EnumUserAction action = EnumUserAction.ChangeAddr;
                    n = UserLog(trans, action, userid, "", userid);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ʺã޸
        /// </summary>
        /// <param name="oldName"></param>
        /// <param name="userName"></param>
        /// <param name="userid">Ա</param>
        /// <returns></returns>
        public int UpdateUserName(string oldName, string userName, int userid)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string sql = "update NT_User set UserName='" + userName + "'  where UserID=" + userid;
                int n = DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
                if (n == 1)
                {
                    EnumUserAction action = EnumUserAction.ChangeName;
                    n = UserLog(trans, action, userid, oldName+" ĳ "+userName, userid);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ǷѾʹ
        /// </summary>
        /// <param name="Email"></param>
        /// <returns></returns>
        public bool CheckEmail(string Email)
        {
            SqlParameter param = new SqlParameter("@Email", Email);
            string sql = "select Id from NT_SpareEmail where  Email=@Email";
            string strsql="select UserId from NT_User where  Email=@Email";
            DataTable dt = DbHelper.ExecuteTable(CommandType.Text, sql, param);
            DataTable obj = null;
            if(dt!=null)
            {
                if (dt.Rows.Count > 0)
                {
                    return true;//ѱ
                }
                else
                {
                    obj = DbHelper.ExecuteTable(CommandType.Text, strsql, param);
                    if (obj == null)
                    {
                        return false;//û
                    }
                    else
                    {
                        if (obj.Rows.Count > 0)
                        {
                            return true;//ѱ
                        }
                        else
                        {
                            return false;//û
                        }
                    }
                }
            }
            else 
            {
                obj = DbHelper.ExecuteTable(CommandType.Text, strsql, param);
                if (obj == null)
                {
                    return false;//û
                }
                else
                {
                    if (obj.Rows.Count > 0)
                    {
                        return true;//ѱ
                    }
                    else
                    {
                        return false;//û
                    }
                }
            }
        }

        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="Email">Ҫɾ</param>
        /// <returns></returns>
        public int DelInfo(string Email)
        {
            SqlParameter param = new SqlParameter("@Email", Email);
            string sql = "delete from NT_SpareEmail where Email=@Email";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="newEmail">Ĭ</param>
        /// <param name="oldEmail">ǰĬ</param>
        /// <param name="userid">Ա</param>
        /// <param name="Ip">IP</param>
        /// <param name="flag">true䣬false</param>
        /// <returns></returns>
        public int UpdateEmail(string newEmail,string oldEmail,int userid,string Ip,bool flag)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = new SqlParameter[4];
                param[0] = new SqlParameter("@newEmail", SqlDbType.NVarChar, 100);
                param[0].Value = newEmail;
                param[1] = new SqlParameter("@oldEmail", SqlDbType.NVarChar,100);
                param[1].Value = oldEmail;
                param[2] = new SqlParameter("@userid", SqlDbType.Int, 4);
                param[2].Value = userid;
                param[3] = new SqlParameter("@Ip", SqlDbType.Char, 15);
                param[3].Value = Ip;

                string sql = "update NT_User set Email=@newEmail where UserID=@userid";
                int n = DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);
                if (n == 1)
                {
                    if (flag)
                    {
                        sql = "insert into NT_SpareEmail(UserID,Email,PostTime,PostIP) values(@userid,@oldEmail,getdate(),@Ip)";
                    }
                    else
                    {
                        sql = "update NT_SpareEmail set Email=@oldEmail,PostTime=getdate(),PostIP=@Ip where Email=@newEmail and UserID=@userid";
                    }
                    n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                    
                    EnumUserAction action = EnumUserAction.ChangeContact;
                    n = UserLog(trans, action, userid, "޸ϵϢ", userid);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// IDDatatable
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public DataTable getEmail(int Id, int flag)
        {
            SqlParameter param = new SqlParameter("@Id", Id);
            string sql = "";
            if (flag == 0)//ȡԱ
            {
                sql = "select Email,flag=0 from NT_User where UserID=@Id union select Email,flag=1 from NT_SpareEmail where UserID=@Id";
            }
            else if (flag == 1)//ȡԱ֪ͨ
            {
                sql = "select ItemID,Announce,PostTime from NT_EmailNotify where UserID=@Id";
            }
            else if (flag == 2)//ȡĳһʱδ½ĻԱ
            {
                sql = "select UserID,UserName,Email from dbo.NT_User where LastLoginTime<=(getdate()-@Id)";
            }
            else if (flag == 3)//ȡԱ֪ͨ
            {
                sql = "select ItemID,Announce,PostTime from NT_EmailNotify where UserID=@Id and Announce=1";
            }
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }

        /// <summary>
        ///  ûǷȷ
        /// </summary>
        /// <param name="userId">Ա</param>
        /// <returns></returns>
        public bool getPwd(int userId,string Pwd)
        {
            SqlParameter[] param = new SqlParameter[2];
            param[0] = new SqlParameter("@userId", SqlDbType.Int, 4);
            param[0].Value = userId;
            param[1] = new SqlParameter("@Pwd", SqlDbType.NChar,32);
            param[1].Value = Pwd;

            string sql = "select Password from NT_User where UserID=@userId and Password=@Pwd";
            string pd=(string)DbHelper.ExecuteScalar(CommandType.Text, sql, param);
            if (pd == "" || pd == null)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        /// <summary>
        /// ޸
        /// </summary>
        /// <param name="OldPwd"></param>
        /// <param name="NewPwd"></param>
        /// <param name="userId">Ա</param>
        public int ChanagePwd(string OldPwd,string NewPwd,int userId)
        {
             SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
           
            int i = 0;
            try
            {
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@NewPwd", SqlDbType.NChar, 32);
                param[0].Value = NewPwd;
                param[1] = new SqlParameter("@userId", SqlDbType.Int,4);
                param[1].Value = userId;

                if (getPwd(userId, OldPwd))
                {
                    string sql = "update NT_User set Password=@NewPwd where UserID=@userId";
                    i = DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);
                }
                else
                {
                    i = 2;
                }
                if (i == 1)
                {
                    EnumUserAction action = EnumUserAction.ChangeEmail;
                    i = UserLog(trans, action, userId, "޸", userId);
                }
                trans.Commit();
                return i;
            }
            catch (SqlException e)
            {
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// MSN/Gtalk
        /// </summary>
        /// <returns></returns>
        public int UpdateMSNGtalk(string value,int userid,int flag)
        {
            SqlParameter[] param = new SqlParameter[1];
            param[0] = new SqlParameter("@userid", SqlDbType.Int, 4);
            param[0].Value = userid;
            int n = 0;
            string sql = "";

            if (flag == 0)//MSN
            {
                sql = "update NT_UserInfo set MSN='" + value + "' where UserID=@userid";
            }
            else if(flag==1)//Gtalk
            {
                sql = "update NT_UserInfo set GTalk='" + value + "' where UserID=@userid";
            }
            else if (flag == 2)//ֻ
            {
                sql = "update NT_UserInfo set Mobile='" + value + "' where UserID=@userid";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// жMSN,Gtalk,Mobile Ƿ
        /// </summary>
        /// <param name="temp"></param>
        /// <param name="flag">ʶ0MSN 1Gtalk 2:ֻ</param>
        /// <returns></returns>
        public int getMSNGtalk(string temp,int flag)
        {
            SqlParameter[] param = new SqlParameter[1];
            param[0] = new SqlParameter("@temp", SqlDbType.NVarChar, 50);
            param[0].Value = temp;

            string sql = "select count(*) from NT_UserInfo where MSN=@temp";
            if (flag == 1)
            {
                sql = "select count(*) from NT_UserInfo where GTalk=@temp";
            }
            else if (flag == 2)
            {
                sql = "select count(*) from NT_UserInfo where Mobile=@temp";
            }
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
        }

        /// <summary>
        /// ʼ֪ͨ
        /// </summary>
        /// <param name="type"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public int UpdateEmailSet(string type,string value,int userID,string IP,int flag)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string sql = ""; 
                string[] Item=type.Split('|');
                string[] Acc = value.Split('|');
                int n = 0;
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@IP", SqlDbType.Char,15);
                param[0].Value = IP;
                param[1] = new SqlParameter("@userID", SqlDbType.Int, 4);
                param[1].Value = userID;


                if (flag == 0)
                {
                    for (int j = 0; j < Acc.Length - 1; j++)
                    {
                        sql = "update NT_EmailNotify set Announce=" + int.Parse(Acc[j].ToString()) + ",PostTime=getdate(),PostIP=@IP where UserID=@userID and ItemID=" + int.Parse(Item[j].ToString());
                        n = DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);
                    }
                }
                else
                {
                    for (int j = 0; j < Acc.Length - 1; j++)
                    {
                        sql = "insert NT_EmailNotify (UserID,ItemID,Announce,PostTime,PostIP) values(@userID," + int.Parse(Item[j].ToString()) + "," + int.Parse(Acc[j].ToString()) + ",getdate(),@IP)";
                        n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                    }
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

       /// <summary>
        /// ȡʼ֪ͨ
       /// </summary>
       /// <param name="userid"></param>
       /// <returns></returns>
        public bool sendEmailStr(int userid,string email,string username,int day)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            try
            {
                SqlParameter param = new SqlParameter("@userid", userid);
                string returnStr = "";
                string sql = "";
                DataTable dt = getEmail(userid,3);

                if (dt != null)
                {
                    if(dt.Rows.Count>0)
                    {
                        int type = 0;
                        for (int i = 0; i < dt.Rows.Count;i++)
                        {
                            type = int.Parse(dt.Rows[i]["ItemID"].ToString());
                            if (type == (int)EnumEmailSet.NewLetter)
                            {
                                // ˽
                                sql = "select DISTINCT b.UserName from NT_Letter as a inner join NT_User as b on a.Sender=b.UserID left Join Nt_Photo as d On b.Portrait=d.PhotoID And d.IsLock=0 where (a.ID IN (SELECT letterid FROM nt_inbox WHERE userid=@userid) and a.TopicID=0) and a.PostTime<(getdate()-" + day + ")";
                                returnStr = getEmailUser(Conn, sql, "к ԣ", param);
                            }
                            if (type == (int)EnumEmailSet.FriendRequest)
                            {
                                //
                                sql = "select DISTINCT b.UserName from NT_Request a inner join NT_User as b on b.UserID=a.Receiver where a.RequestType=1 and a.Receiver=@userid and a.isLock=0 and a.isDel=0 and a.ReplyResult=0 and a.PostTime<(getdate()-" + day + ")";
                                returnStr += getEmailUser(Conn, sql, "ԣ", param);
                            }
                            if (type == (int)EnumEmailSet.NewWord)
                            {
                                //
                                sql = "select DISTINCT b.UserName from NT_LeaveWord a inner join NT_User b on a.Sender=b.UserID where a.Receiver=@userid and a.IsLock=0 and a.PostTime<(getdate()-" + day + ")";
                                returnStr += getEmailUser(Conn, sql, "ԣԣ", param);
                            }
                            if (type == (int)EnumEmailSet.Greet)
                            {
                                //к
                                sql = "select DISTINCT b.UserName from NT_Greet a inner join NT_User b on a.UserID=b.UserID where a.IsRead=0 and a.FriendID=@userid and a.PostTime<(getdate()-" + day + ")";
                                returnStr += getEmailUser(Conn, sql, "кԣ", param);
                            }
                            if (type == (int)EnumEmailSet.FriendDescription)
                            {
                                //
                                //sql = "select a.id,b.UserName from NT_Request a inner join NT_User as b on b.UserID=a.Receiver where a.RequestType=1 and a.Receiver=@userid and a.isLock=0 and a.isDel=0 and a.ReplyResult=0";
                                //returnStr += getEmailUser(sql, "ԣ", param);
                            }
                            if (type == (int)EnumEmailSet.AcceptRequest)
                            {
                                //
                                sql = "select DISTINCT b.UserName from  NT_FriendInvite a inner join NT_User b on a.UserID=b.UserID  where a.UserID=@userid and Reply=0 and  Method=1 and a.PostTime<(getdate()-" + day + ")";
                                returnStr += getEmailUser(Conn, sql, "˽˷ֱǣ", param);
                            }
                            if (type == (int)EnumEmailSet.PhotoBeQ)
                            {
                                //ƬбȦ
                                sql = "select DISTINCT b.UserName from NT_PhotoLasso a inner join NT_User b on a.Userid=b.UserID where FriendID=@userid and IsLock=0 and a.PostTime<(getdate()-" + day + ") and a.userid<>@userid";
                                returnStr += getEmailUser(Conn, sql, "ƬȦ㣬ֱǣ", param);
                            }
                            //if (type == (int)EnumEmailSet.PhotoRequest)
                            //{
                            ////յƬȦ
                            //sql = "select a.id,b.UserName from NT_Request a inner join NT_User as b on b.UserID=a.Receiver where a.RequestType=1 and a.Receiver=@userid and a.isLock=0 and a.isDel=0 and a.ReplyResult=0";
                            //returnStr += getEmailUser(sql, "ԣ", param);
                            //}
                            if (type == (int)EnumEmailSet.PhotoRequest)
                            {
                                //Ƭ
                                sql = "select DISTINCT b.UserName from  NT_PhotoComment a inner join NT_User b on a.UserID=b.UserID where PhotoID in(select PhotoID from dbo.NT_Photo c where c.UploadUser=@userid) and a.PostTime<(getdate()-" + day + ") and a.userid<>@userid";
                                returnStr += getEmailUser(Conn, sql, "Ƭۣԣ", param);
                            }
                            if (type == (int)EnumEmailSet.PhotoResponse)
                            {
                                //Ƭ»ظ
                                sql = "select DISTINCT b.UserName from  NT_PhotoComment a inner join NT_User b on a.UserID=b.UserID Where [CommentID] in (select a.ID from  NT_PhotoComment a where PhotoID in(select PhotoID from dbo.NT_Photo c  where c.UploadUser=@userid)) and a.PostTime<(getdate()-" + day + ") and a.userid<>@userid";
                                returnStr += getEmailUser(Conn, sql, "Ƭۻظԣ", param);
                            }
                            if (type == (int)EnumEmailSet.GroupInvite)
                            {
                                //Ⱥ
                                sql = "select DISTINCT b.UserName  from NT_GroupInvite a inner join NT_User b on a.UserID=b.UserID where a.InviteFlag=1 and a.JoinUserID=@userid and Response=0 and a.PostTime<(getdate()-" + day + ")";
                                returnStr += getEmailUser(Conn, sql, "Ⱥ,ԣ", param);
                            }
                            if (type == (int)EnumEmailSet.ChanageGroupManager)
                            {
                                //ΪȺԱ
                                sql = "select DISTINCT UserName=b.GroupName from NT_GroupMember a inner join dbo.NT_UserGroup b on a.UserID=b.UserId where a.Grade=1 and a.UserID=@userid and a.JoinTime<=getdate()-" + day;
                                returnStr += getEmailUser(Conn, sql, "ΪȺԱ", param);
                            }
                            //if (type == (int)EnumEmailSet.GroupJoin)
                            //{
                            //    //ȺԱ
                            //    sql = "select a.id,b.UserName from NT_Request a inner join NT_User as b on b.UserID=a.Receiver where a.RequestType=1 and a.Receiver=@userid and a.isLock=0 and a.isDel=0 and a.ReplyResult=0";
                            //    returnStr += getEmailUser(sql, "ȺԱ룬ֱǣ", param);
                            //}
                            if (type == (int)EnumEmailSet.Response)
                            {
                                //»ظ
                                sql = "select DISTINCT b.UserName from NT_GroupDiscuss as a inner join NT_User as b on a.UserID=b.UserID where BelongTopic in (select GroupID from dbo.NT_GroupMember where UserID=@userid) and a.posttime<(getdate()-" + day + ") and a.UserID<>@userid";
                                returnStr += getEmailUser(Conn, sql, "ظԣ", param);
                            }
                            if (type == (int)EnumEmailSet.LogComments)
                            {
                                //־
                                sql = "select DISTINCT b.UserName from NT_BLogComment a inner join NT_User b on a.UserID=b.UserID where a.IsLock=0 and a.BlogID in (select ID from dbo.NT_Blog where UserID=@userid) and a.userid<>@userid and a.PostTime<(getdate()-" + day + ")";
                                returnStr += getEmailUser(Conn, sql, "־ۣԣ", param);
                            }
                            if (type == (int)EnumEmailSet.LogResponse)
                            {
                                //־»ظ
                                sql = "select DISTINCT b.UserName from NT_BLogComment a inner join NT_User b on a.UserID=b.UserID where a.IsLock=0 and a.BlogID in (select ID from dbo.NT_Blog where UserID=@userid) and a.userid<>@userid and a.PostTime<(getdate()) and commentID in(select BlogID from dbo.NT_BlogComment)";
                                returnStr += getEmailUser(Conn, sql, "־ۻظԣ", param);
                            }
                            if (type == (int)EnumEmailSet.ShareComments)
                            {
                                //
                                sql = "Select DISTINCT b.UserName From [NT_ShareComment] a inner join NT_User b on a.userID=b.UserID Where a.shareID in (select ID from  dbo.NT_Share where UserID=@userid) and postTime<(getdate()-" + day + ") and a.userid<>@userid";
                                returnStr += getEmailUser(Conn, sql, "ۣԣ", param);
                            }
                            //if (type == (int)EnumEmailSet.ShareResponse)
                            //{
                            //    //ķ»ظ
                            //    sql = "select a.id,b.UserName from NT_Request a inner join NT_User as b on b.UserID=a.Receiver where a.RequestType=1 and a.Receiver=@userid and a.isLock=0 and a.isDel=0 and a.ReplyResult=0";
                            //    returnStr += getEmailUser(sql, "·ۻظԣ", param);
                            //}
                        }
                    }
                }
                if(returnStr!="")
                {
                    #region ʼ
                    NetSNS.Common.EMail em = NetSNS.Common.EMail.CreateInstance();
                    string body = emailsetConfig.letter;
                    body = body.Replace("{SiteName}", UiConfig.SiteName);
                    body = body.Replace("{UserName}", username);
                    body = body.Replace("{Domain}", UiConfig.Domain);
                    body = body.Replace("{Date}", DateTime.Now.ToString("yyyyMMdd"));
                    body = body.Replace("{Url}", UiConfig.RootUrl);
                    body = body.Replace("{Content}", returnStr);
                    em.Body = body;
                    em.Subject = "װ" + username + "" + UiConfig.SiteName + "Ϣ";
                    em.To = email;
                    em.From = UiConfig.SiteName + "<" + EmailConfig.from + ">";
                    em.Send();
                    #endregion
                } 
                 return true;
            }
            catch
            {
                return false;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        public string getEmailUser(SqlConnection Conn,string strSql,string content,SqlParameter param)
        {
            string str = "";
            try
            {
                DataTable dt = DbHelper.ExecuteTable(Conn, CommandType.Text, strSql, param);
                if (dt != null)
                {
                    if (dt.Rows.Count > 0)
                    {
                        for (int i = 0; i < dt.Rows.Count; i++)
                        {
                            if (i != dt.Rows.Count - 1)
                            {
                                str += dt.Rows[i]["UserName"].ToString() + "";
                            }
                            else
                            {
                                str += dt.Rows[i]["UserName"].ToString();
                            }
                        }
                        str = dt.Rows.Count + content + str+"<br/>";
                    }
                }
                return str;
            }
            catch (SqlException e)
            {
                throw e;
            }
        }
    }
}

