using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;
using System.Text;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// 
    /// </summary>
    public class Ads : DbBase, IAds
    {
        /// <summary>
        /// ӹ
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns>Ѵڴ˹ؼַ-1,򷵻1</returns>
        public int Add(AdsInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Select Count([ID]) From [NT_Ads] Where [keyword]=@keyword And [CompanyID]!=@CompanyID";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, param));
            if (n > 0)
                return -1;
            Sql = "Insert Into [NT_Ads]([keyword],[Content],[ViewTime],[CompanyID]) " +
                  "Values(@keyword,@Content,@ViewTime,@CompanyID)";
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
        }

        /// <summary>
        /// ޸Ĺ
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns>Ѵڴ˹ؼַ-1,򷵻1</returns>
        public int Edit(AdsInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Select Count([ID]) From [NT_Ads] Where [keyword]=@keyword And [ID]!=@ID";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, param));
            if (n > 0)
                return -1;

            Sql = "Update [NT_Ads] " +
                  "Set [keyword]=@keyword,[Content]=@Content,[CompanyID]=@CompanyID " +
                  "Where [ID]=@ID";
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
        }

        /// <summary>
        /// ʾ
        /// </summary>
        /// <param name="ID"></param>
        public void AddViewTime(int ID)
        {
            string Sql = "Update [NT_Ads] Set [ViewTime]=[ViewTime]+1 Where [ID]=" + ID;
            DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="ID"></param>
        public void Del(int ID)
        {
            string Sql = "Delete From [NT_Ads] Where [ID]=" + ID;
            DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ƥб
        /// </summary>
        /// <param name="key">ؼ</param>
        /// <returns>б</returns>
        public List<AdsInfo> List(string key)
        {
            List<AdsInfo> list = new List<AdsInfo>();
            string Sql = "Select [ID],[keyword],[Content],[ViewTime],[CompanyID] From [NT_Ads] Where [keyword] Like '%" + key + "%'";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                AdsInfo info = new AdsInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["keyword"] != DBNull.Value) info.keyword = rd["keyword"].ToString();
                if (rd["Content"] != DBNull.Value) info.Content = rd["Content"].ToString();
                info.ViewTime = Convert.ToInt32(rd["ViewTime"].ToString());
                info.CompanyID = Convert.ToInt32(rd["CompanyID"].ToString());
                list.Add(info);
            }
            rd.Close();
            return list;
        }

        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns>عʵ</returns>
        public AdsInfo Info(int ID)
        {
            AdsInfo info = new AdsInfo();
            string Sql = "Select [ID],[keyword],[Content],[ViewTime],[CompanyID] " +
                         "From " +
                         "[NT_Ads] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["keyword"] != DBNull.Value) info.keyword = rd["keyword"].ToString();
                if (rd["Content"] != DBNull.Value) info.Content = rd["Content"].ToString();
                info.ViewTime = Convert.ToInt32(rd["ViewTime"].ToString());
                info.CompanyID = Convert.ToInt32(rd["CompanyID"].ToString());
            }
            rd.Close();
            return info;
        }
        /// <summary>
        /// ȡеĹؼ
        /// </summary>
        /// <returns>ؼб,ָ</returns>
        public string AllKeywords()
        {
            StringBuilder sb = new StringBuilder();
            string sql = "select distinct keyword from NT_Ads";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                sb.Append(rd.GetString(0));
                sb.Append(",");
            }
            string s = sb.ToString();
            if (!string.IsNullOrEmpty(s))
                s = s.Substring(0, s.Length - 1);
            return s;
        }
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(AdsInfo Info)
        {
            SqlParameter[] param = new SqlParameter[5];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@keyword", SqlDbType.NVarChar, 100);
            param[1].Value = Info.keyword;
            param[2] = new SqlParameter("@Content", SqlDbType.NText);
            param[2].Value = Info.Content;

            param[3] = new SqlParameter("@ViewTime", SqlDbType.Int, 4);
            param[3].Value = Info.ViewTime;
            param[4] = new SqlParameter("@CompanyID", SqlDbType.Int, 4);
            param[4].Value = Info.CompanyID;
            return param;
        }
    }
}
