//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// 
    /// </summary>
    public class Album : DbBase, IAlbum
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(AlbumInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                string Sql = "Insert Into [NT_Album]" +
                             "([UserID],[Title],[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID]) " +
                             "Values(@UserID,@Title,@Description,@ImagesCount,@CreateTime,@Privacy,@GroupID);" +
                             "Select @@IDENTITY";
                int AlbumID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                int n = UserLog(trans, EnumUserAction.CreateAlbum, Info.UserID, "һ", AlbumID);
                trans.Commit();
                User us = new User();
                us.updateinte(Info.UserID, 5, 0, 0,"");
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ޸Ϣ
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns>޸ĳɹ1</returns>
        public int Edit(AlbumInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Update [NT_Album] " +
                         "Set " +
                         "[Title]=@Title,[Description]=@Description,[Privacy]=@Privacy " +
                         "Where [AlbumID]=@AlbumID and [UserID]=@UserID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// ɾ(̨)
        /// </summary>
        /// <param name="AlbumID"></param>
        /// <returns>ɾɹ1</returns>
        public int Del(int AlbumID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //־
                int n = UserLog(trans, EnumUserAction.DelAlbum, 0, "ɾ", AlbumID);
                //Ⱥ־״̬Ϊ
                string Sql = "Update [NT_UserLog] " +
                      "Set " +
                      "[IsLock]=" + (int)EnumIsLock.Lock + " " +
                      "Where " +
                      "([CorrespondInfo]=" + AlbumID + " And " +
                            "([ActionType]=" + (int)EnumUserAction.CreateAlbum + " Or [ActionType]=" + (int)EnumUserAction.DelAlbum + ")) " +
                      "Or " +
                      "([CorrespondInfo] In" +
                            "(Select [ID] From [NT_PhotoLasso] Where [PhotoID] " +
                                "In(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ")) And " +
                                    "([ActionType]=" + (int)EnumUserAction.AddLasso + " Or [ActionType]=" + (int)EnumUserAction.DelLasso + ")) " +
                      "Or " +
                      "([CorrespondInfo] In" +
                            "(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ") And " +
                                    "([ActionType]=" + (int)EnumUserAction.AddPhoto + " Or [ActionType]=" + (int)EnumUserAction.DelPhoto + " Or " +
                                        "[ActionType]=" + (int)EnumUserAction.UpdateHead + ")) ";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾ֪ͨ
                Sql = "Delete From [NT_Notice] Where [MsgType]=" + (int)EnumNotifyType.PhotoComm + " And " +
                      "[Correspond] In(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾ
                Sql = "Delete From [NT_Album] Where [AlbumID]=" + AlbumID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾƬ۱
                Sql = "Delete From [NT_PhotoComment] Where " +
                      "[PhotoID] In(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾƬȦ˱
                Sql = "Delete From [NT_PhotoLasso] Where " +
                      "[PhotoID] In(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾƬ
                Sql = "Delete From [NT_Photo] Where [AlbumID]=" + AlbumID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾ(ǰ̨)
        /// </summary>
        /// <param name="AlbumID"></param>
        /// <param name="UserID">Ա</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int AlbumID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            if (!Check(Conn, UserID, AlbumID))
                return -1;

            SqlTransaction trans = Conn.BeginTransaction();

            try
            {
                //־
                int n = UserLog(trans, EnumUserAction.DelAlbum, 0, "ɾ", AlbumID);
                //Ⱥ־״̬Ϊ
                string Sql = "Update [NT_UserLog] " +
                      "Set " +
                      "[IsLock]=" + (int)EnumIsLock.Lock + " " +
                      "Where " +
                      "([CorrespondInfo]=" + AlbumID + " And " +
                            "([ActionType]=" + (int)EnumUserAction.CreateAlbum + " Or [ActionType]=" + (int)EnumUserAction.DelAlbum + ")) " +
                      "Or " +
                      "([CorrespondInfo] In" +
                            "(Select [ID] From [NT_PhotoLasso] Where [PhotoID] " +
                                "In(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ")) And " +
                                    "([ActionType]=" + (int)EnumUserAction.AddLasso + " Or [ActionType]=" + (int)EnumUserAction.DelLasso + ")) " +
                      "Or " +
                      "([CorrespondInfo] In" +
                            "(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ") And " +
                                    "([ActionType]=" + (int)EnumUserAction.AddPhoto + " Or [ActionType]=" + (int)EnumUserAction.DelPhoto + " Or " +
                                        "[ActionType]=" + (int)EnumUserAction.UpdateHead + ")) ";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾ֪ͨ
                Sql = "Delete From [NT_Notice] where [MsgType]=" + (int)EnumNotifyType.PhotoComm + " And " +
                      "[Correspond] In(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾ
                Sql = "Delete From [NT_Album] Where [AlbumID]=" + AlbumID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                User us = new User();
                us.updateinte(UserID, 5, 0, 1,"ɾ");
                //ɾƬ۱
                Sql = "Delete From [NT_PhotoComment] Where " +
                      "[PhotoID] In(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾƬȦ˱
                Sql = "Delete From [NT_PhotoLasso] Where " +
                      "[PhotoID] In(Select [PhotoID] From [NT_Photo] Where [AlbumID]=" + AlbumID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾƬ
                Sql = "Delete From [NT_Photo] Where [AlbumID]=" + AlbumID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȡƬ¼
        /// </summary>
        /// <param name="AlbumID"></param>
        /// <returns>Ƭ¼</returns>
        public int Count(int AlbumID)
        {
            string Sql = "Select [ImagesCount] From [NT_Album] Where [AlbumID]=" + AlbumID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ݿǷڴ˼¼
        /// </summary>
        /// <param name="Conn">SQLӶ</param>
        /// <param name="UserID">Ա</param>
        /// <param name="AlbumID"></param>
        /// <returns>ڷtrue,򷵻false</returns>
        private bool Check(SqlConnection Conn, int UserID, int AlbumID)
        {
            bool tf = false;
            string Sql = "Select Count([AlbumID]) From [NT_Album] Where [UserID]=" + UserID + " And [AlbumID]=" + AlbumID;
            int i_Cnt = Convert.ToInt32(DbHelper.ExecuteScalar(Conn, CommandType.Text, Sql, null));
            if (i_Cnt > 0)
                tf = true;
            return tf;
        }

        /// <summary>
        /// ȡƬ·BLLɾ֮
        /// </summary>
        /// <param name="AlubmID"></param>
        /// <returns>ر</returns>
        public string A_s_PPath(int AlubmID)
        {
            string s_Path = "";
            string Sql = "Select [FilePath] From [NT_Photo] Where [AlbumID]=" + AlubmID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                s_Path += rd["FilePath"].ToString() + ",";
            }
            rd.Close();
            if (s_Path != "")
                s_Path = s_Path.TrimEnd(',');
            return s_Path;
        }

        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="AlbumID"></param>
        /// <returns>ʵ</returns>
        public AlbumInfo Info(int AlbumID)
        {
            AlbumInfo info = new AlbumInfo();
            string Sql = "Select [AlbumID],[UserID],[Title]," +
                         "[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID] " +
                         "From " +
                         "[NT_Album] " +
                         "Where [AlbumID]=" + AlbumID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Title"] != DBNull.Value) info.Title = rd["Title"].ToString();
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.ImagesCount = Convert.ToInt32(rd["ImagesCount"].ToString());
                info.CreateTime = Convert.ToDateTime(rd["CreateTime"].ToString());
                info.Privacy = (EnumPrivacy)Convert.ToInt32(rd["Privacy"].ToString());
                try
                {
                    info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                }
                catch { }
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// ȡָûἯ
        /// </summary>
        /// <param name="UserID">û</param>
        /// <returns>ʵ༯</returns>
        public List<AlbumInfo> AlbumList(int UserID)
        {
            List<AlbumInfo> InfoList=new List<AlbumInfo>();
            string sql = "Select [AlbumID],[UserID],[Title]," +
                         "[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID] " +
                         "From " +
                         "[NT_Album] " +
                         "Where [UserID]=" + UserID+" order by AlbumID desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                AlbumInfo info = new AlbumInfo();
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Title"] != DBNull.Value) info.Title = rd["Title"].ToString();
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.ImagesCount = Convert.ToInt32(rd["ImagesCount"].ToString());
                info.CreateTime = Convert.ToDateTime(rd["CreateTime"].ToString());
                info.Privacy = (EnumPrivacy)Convert.ToInt32(rd["Privacy"].ToString());
                try
                {
                    info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                }
                catch { }
                InfoList.Add(info);
            }
            rd.Close();
            return InfoList;
        }
        /// <summary>
        /// ȡú
        /// </summary>
        /// <param name="UserID">û</param>
        /// <returns></returns>
        public List<AlbumInfo> FriendAlbumList(int UserID)
        {
            List<AlbumInfo> InfoList = new List<AlbumInfo>();
            string sql = "Select [AlbumID],[UserID],[Title]," +
                         "[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID] " +
                         "From " +
                         "[NT_Album] " +
                         "Where [UserID] in (select FriendID from [NT_Friend] where UserID=" + UserID + ") order by AlbumID desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                AlbumInfo info = new AlbumInfo();
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Title"] != DBNull.Value) info.Title = rd["Title"].ToString();
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.ImagesCount = Convert.ToInt32(rd["ImagesCount"].ToString());
                info.CreateTime = Convert.ToDateTime(rd["CreateTime"].ToString());
                info.Privacy = (EnumPrivacy)Convert.ToInt32(rd["Privacy"].ToString());
                try
                {
                    info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                }
                catch { }
                InfoList.Add(info);
            }
            rd.Close();
            return InfoList;
        }

        /// <summary>
        /// ȡָûID
        /// </summary>
        /// <param name="UserID">û</param>
        /// <returns>ID</returns>
        public int LastAlbumID(int UserID)
        {
            string sql = "Select [AlbumID]" +
                         "From " +
                         "[NT_Album] " +
                         "Where [UserID]=" + UserID+" order by AlbumID desc";
            object o = DbHelper.ExecuteScalar(CommandType.Text, sql, null);
            return Convert.ToInt32(o);
        }

        /// <summary>
        /// ָͼƬַ
        /// </summary>
        /// <param name="AlbumID">ID</param>
        /// <returns>ͼƬ·</returns>
        public string CoverPath(int AlbumID)
        {
            string sql = "Select a.[FilePath] " +
                         " From " +
                         "[NT_Photo] a" +
                         " inner join [NT_Photo] b on b.AlbumID=a.AlbumID Where a.AlbumID=" + AlbumID + " and a.IsCover=1"; 
            object o = DbHelper.ExecuteScalar(CommandType.Text, sql, null);
            return Convert.ToString(o);
        }

        /// <summary>
        /// ȡȺ
        /// </summary>
        /// <param name="UserID">ȺID</param>
        /// <returns></returns>
        public List<AlbumInfo> GroupAlbumList(int GroupID)
        {
            List<AlbumInfo> InfoList = new List<AlbumInfo>();
            string sql = "Select [AlbumID],[UserID],[Title]," +
                         "[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID] " +
                         "From " +
                         "[NT_Album] " +
                         "Where [GroupID]=" + GroupID + " order by AlbumID desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                AlbumInfo info = new AlbumInfo();
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Title"] != DBNull.Value) info.Title = rd["Title"].ToString();
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.ImagesCount = Convert.ToInt32(rd["ImagesCount"].ToString());
                info.CreateTime = Convert.ToDateTime(rd["CreateTime"].ToString());
                info.Privacy = (EnumPrivacy)Convert.ToInt32(rd["Privacy"].ToString());
                try
                {
                    info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                }
                catch { }
                InfoList.Add(info);
            }
            rd.Close();
            return InfoList;
        }
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(AlbumInfo Info)
        {
            SqlParameter[] param = new SqlParameter[8];

            param[0] = new SqlParameter("@AlbumID", SqlDbType.Int, 4);
            param[0].Value = Info.AlbumID;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value = Info.UserID;
            param[2] = new SqlParameter("@Title", SqlDbType.NVarChar, 50);
            param[2].Value = Info.Title;

            param[3] = new SqlParameter("@Description", SqlDbType.NVarChar, 255);
            param[3].Value = Info.Description;
            if (Info.Description == null)
            {
                param[3].Value = "";
            }
            param[4] = new SqlParameter("@ImagesCount", SqlDbType.Int, 4);
            param[4].Value = Info.ImagesCount;
            param[5] = new SqlParameter("@CreateTime", SqlDbType.DateTime, 8);
            param[5].Value = Info.CreateTime;

            param[6] = new SqlParameter("@Privacy", SqlDbType.Int, 4);
            param[6].Value = (int)Info.Privacy;

            param[7] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
            param[7].Value = Info.GroupID;

            return param;
        }
    }
}
