using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using NetSNS.Config;
using NetSNS.Model;
using NetSNS.DALProfile;
using NetSNS.Common;
using NetSNS.DALFactory;

namespace NetSNS.DALSQLServer
{
    public class Blog : DbBase, IBlog
    {
        #region Աǰ̨
        /// <summary>
        /// ȡĳ־ݸ
        /// </summary>
        /// <param name="blogid"></param>
        /// <param name="isdraft"></param>
        /// <returns></returns>
        BlogInfo IBlog.GetBlog(int blogid, bool isdraft)
        {
            BlogInfo info = new BlogInfo();
            string Sql = "select UserID,Title,Content,PicPath,Privacy,LastModTime,PostTime from NT_BlogDraft where ID=" + blogid;
            if (!isdraft)
                Sql = "select UserID,Title,Content,PicPath,Privacy,LastModTime,PostTime from NT_Blog where ID=" + blogid;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = blogid;
                info.UserID = rd.GetInt32(0);
                if (!rd.IsDBNull(1)) info.Title = rd.GetString(1);
                if (!rd.IsDBNull(2)) info.Content = rd.GetString(2);
                if (!rd.IsDBNull(3)) info.PicPath = rd.GetString(3);
                info.Privacy = (EnumPrivacy)rd.GetInt32(4);
                if (!rd.IsDBNull(5)) info.PostTime = rd.GetDateTime(5);
                if (!rd.IsDBNull(6)) info.LastModTime = rd.GetDateTime(6);
            }
            rd.Close();
            return info;
        }
        /// <summary>
        /// ݸ
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="draftid"></param>
        /// <returns></returns>
        int IBlog.DeliverDraft(int userid, int draftid)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql = "select count(ID) from NT_BlogDraft where UserID=" + userid + " and ID=" + draftid;
                int n = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                if (n < 1)
                    return -1;
                SqlTransaction trans = cn.BeginTransaction();
                try
                {
                    DateTime now = DateTime.Now;
                    Sql = "insert into NT_Blog (UserID,Title,Content,PicPath,PostTime,PostIP,Privacy,IsLock,Comments,LastModTime) select ";
                    Sql += "UserID,Title,Content,PicPath,'" + now + "','" + Public.GetClientIP() + "',Privacy,0,0,'" + now + "') from ";
                    Sql += "NT_BlogDraft where ID=" + draftid;
                    int m = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    Sql = "delete from NT_BlogDraft where ID=" + draftid;
                    m += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    trans.Commit();
                    return m;
                }
                catch
                {
                    trans.Rollback();
                    throw;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }

        }
        /// <summary>
        /// ޸־ݸ
        /// </summary>
        /// <param name="info"></param>
        /// <param name="draftSate">0־1ݸ壬2ǲݸ-Ϊ־</param>
        /// <returns>־ID</returns>
        int IBlog.Edit(BlogInfo info, int draftSate)
        {
            SqlParameter[] Param = new SqlParameter[3];
            Param[0] = new SqlParameter("@Title", SqlDbType.NVarChar, 40);
            Param[0].Value = info.Title;
            Param[1] = new SqlParameter("@Content", SqlDbType.NText);
            Param[1].Value = info.Content;
            Param[2] = new SqlParameter("@PicPath", SqlDbType.NVarChar, 255);
            if (info.PicPath == null || info.PicPath.Trim() == string.Empty)
                Param[2].Value = DBNull.Value;
            else
                Param[2].Value = info.PicPath;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql = "select count(ID) from NT_BlogDraft where ID=" + info.ID + " and UserID=" + info.UserID;
                if (draftSate == 0)
                    Sql = "select count(ID) from NT_Blog where UserID=" + info.UserID + " and ID=" + info.ID;
                int r = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                if (r < 1)
                    throw new Exception("־,ûȨ޸ĸ־");
                DateTime now = DateTime.Now;
                if (draftSate == 1)
                {
                    Sql = "update NT_BlogDraft set Title=@Title,Content=@Content,PicPath=@PicPath,LastModTime='" + now + "' where ID=" + info.ID;
                    return DbHelper.ExecuteNonQuery(cn, CommandType.Text, Sql, Param);
                }
                else
                {
                    SqlTransaction trans = cn.BeginTransaction();
                    try
                    {
                        int n = 0;
                        if (draftSate == 0)
                        {
                            Sql = "update NT_Blog set Title=@Title,Content=@Content,PicPath=@PicPath,LastModTime='" + now + "' where ID=" + info.ID;
                            n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, Param);
                            if (n > 0)
                                n += UserLog(trans, EnumUserAction.ModifyBlog, info.UserID, null, info.ID);
                        }
                        else if (draftSate == 2)
                        {
                            Sql = "insert into NT_Blog (UserID,Title,Content,PicPath,PostTime,PostIP,Privacy,IsLock,Comments,LastModTime) values (";
                            Sql += info.UserID + ",@Title,@Content,@PicPath,'" + now + "','" + Public.GetClientIP() + "'," + (int)info.Privacy + ",0,0,'" + now + "');select @@IDENTITY";
                            n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, Param));
                            UserLog(trans, EnumUserAction.DeliverBlog, info.UserID, null, n);
                            Sql = "delete from NT_BlogDraft where ID=" + info.ID;
                            DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                        }
                        trans.Commit();
                        return n;
                    }
                    catch
                    {
                        trans.Rollback();
                        throw;
                    }
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ־ݸ
        /// </summary>
        /// <param name="info"></param>
        /// <param name="isdraft">ǲǲݸ</param>
        /// <returns></returns>
        int IBlog.Deliver(BlogInfo info, bool isdraft)
        {
            SqlParameter[] Param = new SqlParameter[3];
            Param[0] = new SqlParameter("@Title", SqlDbType.NVarChar, 40);
            Param[0].Value = info.Title;
            Param[1] = new SqlParameter("@Content", SqlDbType.NText);
            Param[1].Value = info.Content;
            Param[2] = new SqlParameter("@PicPath", SqlDbType.NVarChar, 255);
            if (info.PicPath == null || info.PicPath.Trim() == string.Empty)
                Param[2].Value = DBNull.Value;
            else
                Param[2].Value = info.PicPath;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                DateTime now = DateTime.Now;
                if (isdraft)
                {
                    string Sql = "insert into NT_BlogDraft (UserID,Title,Content,PicPath,PostTime,PostIP,Privacy,IsLock,LastModTime) values (";
                    Sql += info.UserID + ",@Title,@Content,@PicPath,'" + now + "','" + Public.GetClientIP() + "'," + (int)info.Privacy + ",0,'" + now + "');SELECT @@IDENTITY";
                    return Convert.ToInt32(DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, Param));
                }
                else
                {
                    SqlTransaction trans = cn.BeginTransaction();
                    try
                    {
                        string Sql = "insert into NT_Blog (UserID,Title,Content,PicPath,PostTime,PostIP,Privacy,IsLock,Comments,LastModTime) values (";
                        Sql += info.UserID + ",@Title,@Content,@PicPath,'" + now + "','" + Public.GetClientIP() + "'," + (int)info.Privacy + ",0,0,'" + now + "');select @@IDENTITY";
                        int n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, Param));
                        UserLog(trans, EnumUserAction.DeliverBlog, info.UserID, null, n);
                        trans.Commit();
                        return n;
                    }
                    catch
                    {
                        trans.Rollback();
                        throw;
                    }
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ־
        /// </summary>
        /// <param name="blogid"></param>
        /// <param name="userid"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        int IBlog.CommentsBlog(int blogid, int userid, string content)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql = "select UserID from NT_BLog where ID=" + blogid;
                object uid = DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                SqlTransaction trans = cn.BeginTransaction();
                try
                {
                    //־
                    Sql = "insert into NT_BLogComment (BlogID,UserID,Content,PostTime,PostIP,IsLock) values (";
                    Sql += blogid + "," + userid + ",@Content,'" + DateTime.Now + "','" + Public.GetClientIP() + "',0);select @@IDENTITY";
                    SqlParameter Param = new SqlParameter("@Content", SqlDbType.NVarChar, 1000);
                    Param.Value = content;
                    int cid = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, Param));
                    //޸־
                    Sql = "update NT_BLog set Comments=Comments+1 where ID=" + blogid;
                    int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //޸Ķ̬
                    n += UserLog(trans, EnumUserAction.CommentBlog, userid, null, cid);
                    //֪ͨ
                    if (Convert.ToInt32(uid) != userid)
                    {
                        n += Notify(trans, EnumNotifyType.CommentBlog, userid, (int)uid, null, blogid);
                    }
                    trans.Commit();
                    return n;
                }
                catch
                {
                    trans.Rollback();
                    throw;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ɾ־,ֻ߻־߿ɾ
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="commentid"></param>
        /// <returns></returns>
        int IBlog.DelComment(int userid, int commentid)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql = "select b.ID from NT_BLogComment a inner join NT_Blog b on a.BlogID=b.ID where a.ID=" + commentid;
                Sql += " and (a.UserID=" + userid + " or b.UserID=" + userid + ")";
                object obj = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                if (obj == null || obj == DBNull.Value)
                {
                    throw new Exception("Բ,ûɾ־۵Ȩ");
                }
                SqlTransaction trans = cn.BeginTransaction();
                try
                {
                    Sql = "delete from NT_BLogComment where ID=" + commentid;
                    int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    Sql = "delete from NT_BLogComment where CommentID=" + commentid;
                    n += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    Sql = "update NT_Blog set Comments=Comments-1 where ID=" + (int)obj;
                    n += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    trans.Commit();
                    return n;
                }
                catch
                {
                    trans.Rollback();
                    throw;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ɾ־
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="blogid"></param>
        /// <returns></returns>
        int IBlog.DelBlog(int userid, int blogid, bool isAdmin)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql;
                if (!isAdmin)
                {
                    Sql = "select count(ID) from NT_BLog where ID=" + blogid + " and UserID=" + userid;
                    int n = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                    if (n < 1)
                    {
                        throw new Exception("Բ,ûɾ־Ȩ");
                    }
                }
                SqlTransaction trans = cn.BeginTransaction();
                try
                {
                    Sql = "delete from NT_BLog where ID=" + blogid;
                    int m = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    Sql = "delete from NT_BLogComment where BlogID=" + blogid;
                    m += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    trans.Commit();
                    return m;
                }
                catch
                {
                    trans.Rollback();
                    throw;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ɾݸ
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="draftid"></param>
        /// <returns></returns>
        int IBlog.DelDraft(int userid, int draftid)
        {
            string Sql = "delete from NT_BlogDraft where ID=" + draftid + " and UserID=" + userid;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }
        /// <summary>
        /// ־Ϣ
        /// </summary>
        /// <param name="userId">¼ûID</param>
        /// <param name="blogId">id</param>
        /// <param name="blogInf">־Ϣ</param>
        /// <param name="comment">۵Ϣ</param>
        /// <returns>ظû־</returns>
        int IBlog.GetAllInfo(int userId, int blogId, bool increaseReads, out BlogInfo blogInf, out List<BlogCommentInfo> comment)
        {
            blogInf = new BlogInfo();
            comment = new List<BlogCommentInfo>();
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                bool bex = false;
                string Sql = "select a.ID,a.UserID,a.Title,a.Content,a.PostTime,a.Comments,a.Privacy,a.PicPath,a.Reads,b.UserName,c.FilePath ";
                Sql += "from NT_BLog a inner join NT_User b on a.UserID=b.UserID left join NT_Photo c on (b.Portrait=c.PhotoID and c.IsLock=0) where a.IsLock=0 and a.ID=" + blogId;
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                if (rd.Read())
                {
                    blogInf.ID = rd.GetInt32(0);
                    blogInf.UserID = rd.GetInt32(1);
                    if (!rd.IsDBNull(2)) blogInf.Title = rd.GetString(2);
                    if (!rd.IsDBNull(3)) blogInf.Content = rd.GetString(3);
                    blogInf.PostTime = rd.GetDateTime(4);
                    blogInf.Comments = rd.GetInt32(5);
                    blogInf.Privacy = (EnumPrivacy)rd.GetInt32(6);
                    if (!rd.IsDBNull(7)) blogInf.PicPath = rd.GetString(7);
                    blogInf.Reads = rd.GetInt32(8);
                    blogInf.UserName = rd.GetString(9);
                    if (!rd.IsDBNull(10)) blogInf.UserPortrait = rd.GetString(10);
                    bex = true;
                }
                rd.Close();
                if (!bex)
                    throw new Exception("ûҵص־");
                Sql = "select count(ID) from NT_BLog where UserID=" + blogInf.UserID;
                int n = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                if (n < 1)
                {
                    return n;
                }
                if (userId != blogInf.UserID && !CheckPrivacy(cn, blogInf.Privacy, userId, blogInf.UserID))
                {
                    throw new Exception("Բ,ûв鿴־Ȩ");
                }
                Sql = "select a.ID,a.BlogID,a.UserID,a.Content,a.PostTime,b.UserName,c.Name,d.FilePath from NT_BLogComment a inner join NT_User b on a.UserID=b.UserID inner join NT_Dict_Area c on b.Province=c.ID left join NT_Photo d on (b.Portrait=d.PhotoID and d.IsLock=0) where a.IsLock=0 and a.BlogID=" + blogId;
                Sql += " order by a.ID Asc";
                rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                while (rd.Read())
                {
                    BlogCommentInfo cm = new BlogCommentInfo();
                    cm.ID = rd.GetInt32(0);
                    cm.BlogID = rd.GetInt32(1);
                    cm.UserID = rd.GetInt32(2);
                    if (!rd.IsDBNull(3)) cm.Content = rd.GetString(3);
                    cm.PostTime = rd.GetDateTime(4);
                    cm.UserName = rd.GetString(5);
                    cm.UserNetwork = rd.GetString(6);
                    if (!rd.IsDBNull(7)) cm.UserPortrait = rd.GetString(7);
                    comment.Add(cm);
                }
                rd.Close();
                if (increaseReads)
                {
                    Sql = "update NT_BLog set Reads=Reads+1 where ID=" + blogId;
                    DbHelper.ExecuteNonQuery(cn, CommandType.Text, Sql, null);
                    blogInf.Reads += 1;
                }
                return n;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        #endregion
        #region ̨
        /// <summary>
        /// ־
        /// </summary>
        /// <param name="searchCondition">:1.;2.־</param>
        /// <param name="keyword">ؼ</param>
        /// <param name="orderType">ʽ:1.;2.;3.</param>
        /// <returns></returns>
        public DataTable Search(int searchCondition, string keyword, int orderType, int pageIndex, int pageSize, out int recordCount, out int pageCount)
        {
            string AllFields = "a.ID,a.UserID,a.Title,a.PostTime,a.IsLock,a.Comments,a.Privacy,b.UserName";
            string TablesAndWhere = "NT_Blog a inner join NT_User b on a.UserID=b.UserID";
            if (keyword != null && keyword.Trim() != string.Empty)
            {
                string _key = keyword.Replace("'", "''");
                if (searchCondition == 1)
                    TablesAndWhere += " where b.UserName like '%" + _key + "%'";
                else if (searchCondition == 2)
                    TablesAndWhere += " where a.Title like '%" + _key + "%'";
            }
            string IndexField = "a.ID";
            string OrderFields = "order by a.ID Desc";
            switch (orderType)
            {
                case 1:
                    OrderFields = "order by a.PostTime Desc";
                    break;
                case 2:
                    OrderFields = "order by b.UserName Desc";
                    break;
                case 3:
                    OrderFields = "order by a.Comments Desc";
                    break;
            }
            return Pagination.ProcPage(AllFields, TablesAndWhere, IndexField, OrderFields, pageIndex, pageSize, out recordCount, out pageCount);
        }
        /// <summary>
        /// ־
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="blogId"></param>
        /// <param name="lockSate"></param>
        public int ChangeLock(int userId, int blogId, bool lockSate)
        {
            int newLock = 0;
            if (lockSate)
                newLock = 1;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            SqlTransaction trans = cn.BeginTransaction();
            try
            {
                string Sql = "update NT_Blog set IsLock=" + newLock + " where ID=" + blogId;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "update NT_BlogComment set IsLock=" + newLock + " where BlogID=" + blogId;
                n += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return n;
            }
            catch
            {
                trans.Rollback();
                throw;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        #endregion
    }
}
