using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// 
    /// </summary>
    public class BookShelf : DbBase, IBookShelf
    {
        /// <summary>
        /// 鱾
        /// </summary>
        /// <param name="Info">鱾ʵ</param>
        /// <returns></returns>
        public int Add(BookShelfInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Insert Into [Nt_BookShelf]([ShelfPic],[ShelfUrl],[ShelfName],[ShelfIntro],[ShelfType],[GroupID],[UserID]) " +
                         "Values(@ShelfPic,@ShelfUrl,@ShelfName,@ShelfIntro,@ShelfType,@GroupID,@UserID)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// ޸鱾Ϣ
        /// </summary>
        /// <param name="Info">鱾ʵ</param>
        /// <returns></returns>
        public int Edit(BookShelfInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Update [Nt_BookShelf] Set [ShelfPic]=@ShelfPic," +
                         "[ShelfUrl]=@ShelfUrl,[ShelfName]=@ShelfName,[ShelfIntro]=@ShelfIntro,[ShelfType]=@ShelfType " +
                         "Where [GroupID]=@GroupID And [ID]=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// ɾ鱾
        /// </summary>
        /// <param name="ID">鱾</param>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns></returns>
        public int Del(int ID, int GroupID)
        {
            string Sql = "Delete From Nt_BookShelf Where ID=" + ID + " And GroupID=" + GroupID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// 鱾ϸϢ
        /// </summary>
        /// <param name="ID">鱾</param>
        /// <returns></returns>
        public BookShelfInfo Info(int ID)
        {
            BookShelfInfo info = new BookShelfInfo();
            string Sql = "Select [ID],[ShelfPic],[ShelfUrl],[ShelfName],[ShelfIntro],[ShelfType],[GroupID],[UserID] " +
                         "From " +
                         "[Nt_BookShelf] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["ShelfPic"] != DBNull.Value) info.ShelfPic = rd["ShelfPic"].ToString();
                if (rd["ShelfUrl"] != DBNull.Value) info.ShelfUrl = rd["ShelfUrl"].ToString();
                if (rd["ShelfName"] != DBNull.Value) info.ShelfName = rd["ShelfName"].ToString();
                if (rd["ShelfIntro"] != DBNull.Value) info.ShelfIntro = rd["ShelfIntro"].ToString();
                info.ShelfType = Convert.ToInt32(rd["ShelfType"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">鱾ʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(BookShelfInfo Info)
        {
            SqlParameter[] param = new SqlParameter[8];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@ShelfPic", SqlDbType.NVarChar, 100);
            param[1].Value = Info.ShelfPic;
            param[2] = new SqlParameter("@ShelfUrl", SqlDbType.NVarChar, 100);
            param[2].Value = Info.ShelfUrl;

            param[3] = new SqlParameter("@ShelfName", SqlDbType.NVarChar, 100);
            param[3].Value = Info.ShelfName;
            param[4] = new SqlParameter("@ShelfIntro", SqlDbType.NVarChar, 200);
            param[4].Value = Info.ShelfIntro;
            param[5] = new SqlParameter("@ShelfType", SqlDbType.Int, 4);
            param[5].Value = Info.ShelfType;

            param[6] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
            param[6].Value = Info.GroupID;
            param[7] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[7].Value = Info.UserID;

            return param;
        }
    }
}
