using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using NetSNS.Model;
using System.Data.SqlClient;
using System.Data;
using NetSNS.DALProfile;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    public class CarATC : DbBase, ICarATC
    {
        /// <summary>
        /// ӻ
        /// </summary>
        /// <param name="atcinfo">Ϣ</param>
        /// <returns></returns>
        public int Add(CarATCInfo atcinfo)
        {
            SqlParameter[] parm = getParameters(atcinfo);
            string sql = "insert into NT_CarATC(HName,StartTime,EndTime,GoTime,HDesc,HAppeal,isLock,isCheck,CreatTime,CarType,PrPrice,UserID,isRec,HADDress,AssembleTime,CID,Line) values(@HName,@StartTime,@EndTime,@GoTime,@HDesc,@HAppeal,@isLock,@isCheck,@CreatTime,@CarType,@PrPrice,@UserID,@isRec,@HADDress,@AssembleTime,@CID,@Line)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// ȡû
        /// </summary>
        /// <param name="hid">ID</param>
        /// <returns></returns>
        public CarATCInfo GetInfo(int hid)
        {
            CarATCInfo atcinfo = new CarATCInfo();
            SqlParameter parm = new SqlParameter("@HID", SqlDbType.Int, 4);
            parm.Value = hid;
            string sql="select HID,HName,StartTime,EndTime,GoTime,HDesc,HAppeal,isLock,isCheck,CreatTime,CarType,PrPrice,UserID,isRec,HADDress,AssembleTime,CID,Line from NT_CarATC where HID=@HID";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, parm);
            if (dr.Read())
            {
                atcinfo.HID = dr.GetInt32(0);
                atcinfo.HName = dr.GetString(1);
                atcinfo.StartTime = dr.GetDateTime(2);
                atcinfo.EndTime = dr.GetDateTime(3);
                atcinfo.GoTime = dr.GetDateTime(4);
                atcinfo.HDesc = dr.IsDBNull(5) ? null : dr.GetString(5);
                atcinfo.HAppeal = dr.IsDBNull(6) ? null : dr.GetString(6);
                atcinfo.isLock = (EnumIsLock)dr.GetInt32(7);
                atcinfo.isCheck = dr.GetInt32(8);
                atcinfo.CreatTime = dr.GetDateTime(9);
                atcinfo.CarType = dr.IsDBNull(10) ? null : dr.GetString(10);
                atcinfo.PrPrice = dr.GetString(11);
                atcinfo.UserID = dr.GetString(12);
                atcinfo.isRec = dr.GetInt32(13);
                atcinfo.HADDress = dr.IsDBNull(14) ? null : dr.GetString(14);
                atcinfo.AssembleTime = dr.GetDateTime(15);
                atcinfo.CID = dr.GetInt32(16);
                atcinfo.Line = dr.IsDBNull(17) ? null : dr.GetString(17);
            }
            else
            {
                atcinfo = null;
            }
            dr.Close();
            return atcinfo;
        }
        /// <summary>
        /// ȡû
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public CarATCInfo GetInfo(string name)
        {
            CarATCInfo atcinfo = new CarATCInfo();
            SqlParameter parm = new SqlParameter("@HName", SqlDbType.NVarChar, 100);
            parm.Value = name;
            string sql = "select HID,HName,StartTime,EndTime,GoTime,HDesc,HAppeal,isLock,isCheck,CreatTime,CarType,PrPrice,UserID,isRec,HADDress,AssembleTime,CID,Line from NT_CarATC where HName=@HName";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, parm);
            if (dr.Read())
            {
                atcinfo.HID = dr.GetInt32(0);
                atcinfo.HName = dr.GetString(1);
                atcinfo.StartTime = dr.GetDateTime(2);
                atcinfo.EndTime = dr.GetDateTime(3);
                atcinfo.GoTime = dr.GetDateTime(4);
                atcinfo.HDesc = dr.IsDBNull(5) ? null : dr.GetString(5);
                atcinfo.HAppeal = dr.IsDBNull(6) ? null : dr.GetString(6);
                atcinfo.isLock = (EnumIsLock)dr.GetInt32(7);
                atcinfo.isCheck = dr.GetInt32(8);
                atcinfo.CreatTime = dr.GetDateTime(9);
                atcinfo.CarType = dr.IsDBNull(10) ? null : dr.GetString(10);
                atcinfo.PrPrice = dr.GetString(11);
                atcinfo.UserID = dr.GetString(12);
                atcinfo.isRec = dr.GetInt32(13);
                atcinfo.HADDress = dr.IsDBNull(14) ? null : dr.GetString(14);
                atcinfo.AssembleTime = dr.GetDateTime(15);
                atcinfo.CID = dr.GetInt32(16);
                atcinfo.Line = dr.IsDBNull(17) ? null : dr.GetString(17);
            }
            else
            {
                atcinfo = null;
            }
            dr.Close();
            return atcinfo;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="hid">ID</param>
        /// <returns></returns>
        public int Delete(int hid)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter parm = new SqlParameter("@HID", SqlDbType.Int, 4);
                parm.Value = hid;
                string sql = "delete from NT_CarATC where HID=@HID";
                int returnN=DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, parm);
                sql = "delete from NT_CarATCCal where HID=@HID";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, parm);
                sql = "delete from NT_CarATCComment where ATCID=@HID";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, parm);
                trans.Commit();
                return returnN;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }            
        }
        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="atcinfo">Ϣʵ</param>
        /// <returns></returns>
        public int Update(CarATCInfo atcinfo)
        {
            SqlParameter[] parm = getParameters(atcinfo);
            string sql = "update NT_CarATC set HName=@HName,StartTime=@StartTime,EndTime=@EndTime,GoTime=@GoTime,HDesc=@HDesc,HAppeal=@HAppeal,isLock=@isLock,isCheck=@isCheck,CreatTime=@CreatTime,CarType=@CarType,PrPrice=@PrPrice,UserID=@UserID,isRec=@isRec,HADDress=@HADDress,AssembleTime=@AssembleTime,CID=@CID,Line=@Line where HID=@HID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }

        /// <summary>
        /// ȡóѻжٸ
        /// </summary>
        /// <param name="CID">ѻ</param>
        /// <returns>ؼ¼</returns>
        public int Count(int CID)
        {
            SqlParameter parm = new SqlParameter("@CID", SqlDbType.Int, 4);
            parm.Value = CID;
            string Sql = "Select Count([HID]) From NT_CarATC Where CID=@CID";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, parm));
        }
        /// <summary>
        /// Ƽ
        /// </summary>
        /// <param name="hid">ID</param>
        /// <returns></returns>
        public int Recommend(int hid)
        {
            SqlParameter parm = new SqlParameter("@HID", SqlDbType.Int, 4);
            parm.Value = hid;
            string sql = "update NT_CarATC set isRec=1 where hid=@HID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// 뾰صĻ
        /// </summary>
        /// <param name="scenic"></param>
        /// <returns></returns>
        public List<CarATCInfo> RelatedScenicATC(params string[] scenic)
        {
            List<CarATCInfo> list = new List<CarATCInfo>();
            for (int i = 0; i < scenic.Length; i++)
            {
                if (scenic[i] == "")
                    continue;
                SqlParameter param = new SqlParameter("@scenic", SqlDbType.NVarChar);
                param.Value = "%" + scenic[i] + "%";
                string sql = "select HID,HName,StartTime,EndTime,GoTime,HDesc,HAppeal,isLock,isCheck,CreatTime,CarType,PrPrice,UserID,isRec,HADDress,AssembleTime,CID,Line from NT_CarATC where Line like @scenic and EndTime>=getdate()";
                IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
                while (dr.Read())
                {
                    CarATCInfo atcinfo = new CarATCInfo();
                    atcinfo.HID = dr.GetInt32(0);
                    atcinfo.HName = dr.GetString(1);
                    atcinfo.StartTime = dr.GetDateTime(2);
                    atcinfo.EndTime = dr.GetDateTime(3);
                    atcinfo.GoTime = dr.GetDateTime(4);
                    atcinfo.HDesc = dr.IsDBNull(5) ? null : dr.GetString(5);
                    atcinfo.HAppeal = dr.IsDBNull(6) ? null : dr.GetString(6);
                    atcinfo.isLock = (EnumIsLock)dr.GetInt32(7);
                    atcinfo.isCheck = dr.GetInt32(8);
                    atcinfo.CreatTime = dr.GetDateTime(9);
                    atcinfo.CarType = dr.IsDBNull(10) ? null : dr.GetString(10);
                    atcinfo.PrPrice = dr.GetString(11);
                    atcinfo.UserID = dr.GetString(12);
                    atcinfo.isRec = dr.GetInt32(13);
                    atcinfo.HADDress = dr.IsDBNull(14) ? null : dr.GetString(14);
                    atcinfo.AssembleTime = dr.GetDateTime(15);
                    atcinfo.CID = dr.GetInt32(16);
                    atcinfo.Line = dr.IsDBNull(17) ? null : dr.GetString(17);
                    list.Add(atcinfo);
                }
                dr.Dispose();
            }
            return list;
        }
        /// <summary>
        /// ³ѻ
        /// </summary>
        /// <param name="num">Ŀ</param>
        /// <returns></returns>
        public List<CarATCInfo> NewAtc(int num)
        {
            List<CarATCInfo> list = new List<CarATCInfo>();
            string wstr = string.Empty;
            if (num != 0)
                wstr = " top " + num + " ";
            string sql = "select " + wstr + " HID,HName,StartTime,EndTime,GoTime,HDesc,HAppeal,isLock,isCheck,CreatTime,CarType,PrPrice,UserID,isRec,HADDress,AssembleTime,CID,Line from NT_CarATC order by HID desc";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (dr.Read())
            {
                CarATCInfo atcinfo = new CarATCInfo();
                atcinfo.HID = dr.GetInt32(0);
                atcinfo.HName = dr.GetString(1);
                atcinfo.StartTime = dr.GetDateTime(2);
                atcinfo.EndTime = dr.GetDateTime(3);
                atcinfo.GoTime = dr.GetDateTime(4);
                atcinfo.HDesc = dr.IsDBNull(5) ? null : dr.GetString(5);
                atcinfo.HAppeal = dr.IsDBNull(6) ? null : dr.GetString(6);
                atcinfo.isLock = (EnumIsLock)dr.GetInt32(7);
                atcinfo.isCheck = dr.GetInt32(8);
                atcinfo.CreatTime = dr.GetDateTime(9);
                atcinfo.CarType = dr.IsDBNull(10) ? null : dr.GetString(10);
                atcinfo.PrPrice = dr.GetString(11);
                atcinfo.UserID = dr.GetString(12);
                atcinfo.isRec = dr.GetInt32(13);
                atcinfo.HADDress = dr.IsDBNull(14) ? null : dr.GetString(14);
                atcinfo.AssembleTime = dr.GetDateTime(15);
                atcinfo.CID = dr.GetInt32(16);
                atcinfo.Line = dr.IsDBNull(17) ? null : dr.GetString(17);
                list.Add(atcinfo);
            }
            dr.Dispose();
            return list;
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns></returns>
        private SqlParameter[] getParameters(CarATCInfo Info)
        {
            SqlParameter[] param = new SqlParameter[18];
            param[0] = new SqlParameter("@HID", SqlDbType.Int, 4);
            param[0].Value = Info.HID;
            param[1] = new SqlParameter("@HName", SqlDbType.NVarChar, 100);
            param[1].Value = Info.HName;
            param[2] = new SqlParameter("@StartTime", SqlDbType.DateTime, 8);
            param[2].Value = Info.StartTime;
            param[3] = new SqlParameter("@EndTime", SqlDbType.DateTime, 8);
            param[3].Value = Info.EndTime;
            param[4] = new SqlParameter("@GoTime", SqlDbType.DateTime, 8);
            param[4].Value = Info.GoTime;
            param[5] = new SqlParameter("@HDesc", SqlDbType.NVarChar, 2000);
            param[5].Value = Info.HDesc;
            param[6] = new SqlParameter("@HAppeal", SqlDbType.NVarChar, 1000);
            param[6].Value = Info.HAppeal;
            param[7] = new SqlParameter("@isLock", SqlDbType.Int, 4);
            param[7].Value = (int)Info.isLock;
            param[8] = new SqlParameter("@isCheck", SqlDbType.Int, 4);
            param[8].Value = Info.isCheck;
            param[9] = new SqlParameter("@CreatTime", SqlDbType.DateTime, 8);
            param[9].Value = Info.CreatTime;
            param[10] = new SqlParameter("@CarType", SqlDbType.NVarChar, 100);
            param[10].Value = Info.CarType;
            param[11] = new SqlParameter("@PrPrice", SqlDbType.NVarChar, 20);
            param[11].Value = Info.PrPrice;
            param[12] = new SqlParameter("@UserID", SqlDbType.NVarChar, 200);
            param[12].Value = Info.UserID;
            param[13] = new SqlParameter("@isRec", SqlDbType.Int, 4);
            param[13].Value = Info.isRec;
            param[14] = new SqlParameter("@HADDress", SqlDbType.NVarChar, 100);
            param[14].Value = Info.HADDress;
            param[15] = new SqlParameter("@AssembleTime", SqlDbType.DateTime, 8);
            param[15].Value = Info.AssembleTime;
            param[16] = new SqlParameter("@CID", SqlDbType.Int, 4);
            param[16].Value = Info.CID;
            param[17] = new SqlParameter("@Line", SqlDbType.NVarChar, 1000);
            param[17].Value = Info.Line;
            return param;
        }
    }
}
